/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.github.mustachejava.Mustache;
import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.template.mustache.MustacheUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.Rewriteable;

public class PrecompiledTemplateFeature
implements Feature,
Accountable {
    private static final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(StoredFeature.class);
    private final String name;
    private final Mustache template;
    private final String templateString;
    private final Collection<String> queryParams;

    private PrecompiledTemplateFeature(String name, Mustache template, String templateString, Collection<String> queryParams) {
        this.name = name;
        this.template = template;
        this.queryParams = queryParams;
        this.templateString = templateString;
    }

    public static PrecompiledTemplateFeature compile(StoredFeature feature) {
        assert ("mustache".equals(feature.templateLanguage()));
        Mustache mustache = MustacheUtils.compile(feature.name(), feature.template());
        return new PrecompiledTemplateFeature(feature.name(), mustache, feature.template(), feature.queryParams());
    }

    public long ramBytesUsed() {
        return BASE_RAM_USED + (long)(2 * this.name.length()) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.queryParams.stream().mapToLong(x -> 2 * x.length() + RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER).sum() + (long)((2 * this.templateString.length() + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) * 2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Query doToQuery(LtrQueryContext context, FeatureSet set, Map<String, Object> params) {
        List missingParams = this.queryParams.stream().filter(x -> params == null || !params.containsKey(x)).collect(Collectors.toList());
        if (!missingParams.isEmpty()) {
            String names = missingParams.stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("Missing required param(s): [" + names + "]");
        }
        String query = MustacheUtils.execute(this.template, params);
        try {
            XContentParser parser = MediaTypeRegistry.xContent((CharSequence)query).xContent().createParser(context.getQueryShardContext().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
            QueryBuilder queryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
            return ((QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)context.getQueryShardContext())).toQuery(context.getQueryShardContext());
        }
        catch (IOException | IllegalArgumentException | ParsingException e) {
            throw new QueryShardException(context.getQueryShardContext(), "Cannot create query while parsing feature [" + this.name + "]", e, new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrecompiledTemplateFeature that = (PrecompiledTemplateFeature)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.templateString.equals(that.templateString)) {
            return false;
        }
        return this.queryParams.equals(that.queryParams);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.templateString.hashCode();
        result = 31 * result + this.queryParams.hashCode();
        return result;
    }
}

