/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.settings.Setting;
import org.opensearch.timeseries.settings.DynamicNumericSetting;

public class ADEnabledSetting
extends DynamicNumericSetting {
    private static ADEnabledSetting INSTANCE;
    public static final String AD_ENABLED = "plugins.anomaly_detection.enabled";
    @Deprecated
    public static final String AD_BREAKER_ENABLED = "plugins.anomaly_detection.breaker.enabled";
    public static final String LEGACY_OPENDISTRO_AD_ENABLED = "opendistro.anomaly_detection.enabled";
    public static final String LEGACY_OPENDISTRO_AD_BREAKER_ENABLED = "opendistro.anomaly_detection.breaker.enabled";
    @Deprecated
    public static final String INTERPOLATION_IN_HCAD_COLD_START_ENABLED = "plugins.anomaly_detection.hcad_cold_start_interpolation.enabled";
    public static final String DOOR_KEEPER_IN_CACHE_ENABLED = "plugins.anomaly_detection.door_keeper_in_cache.enabled";
    public static final Map<String, Setting<?>> settings;

    ADEnabledSetting(Map<String, Setting<?>> settings) {
        super(settings);
    }

    public static synchronized ADEnabledSetting getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ADEnabledSetting(settings);
        }
        return INSTANCE;
    }

    public static boolean isADEnabled() {
        return (Boolean)ADEnabledSetting.getInstance().getSettingValue(AD_ENABLED);
    }

    public static boolean isADBreakerEnabled() {
        return (Boolean)ADEnabledSetting.getInstance().getSettingValue(AD_BREAKER_ENABLED);
    }

    public static boolean isInterpolationInColdStartEnabled() {
        return (Boolean)ADEnabledSetting.getInstance().getSettingValue(INTERPOLATION_IN_HCAD_COLD_START_ENABLED);
    }

    public static boolean isDoorKeeperInCacheEnabled() {
        return (Boolean)ADEnabledSetting.getInstance().getSettingValue(DOOR_KEEPER_IN_CACHE_ENABLED);
    }

    static {
        settings = Collections.unmodifiableMap(new HashMap<String, Setting<?>>(){
            {
                Setting LegacyADEnabledSetting = Setting.boolSetting((String)ADEnabledSetting.LEGACY_OPENDISTRO_AD_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
                this.put(ADEnabledSetting.LEGACY_OPENDISTRO_AD_ENABLED, LegacyADEnabledSetting);
                Setting LegacyADBreakerEnabledSetting = Setting.boolSetting((String)ADEnabledSetting.LEGACY_OPENDISTRO_AD_BREAKER_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
                this.put(ADEnabledSetting.LEGACY_OPENDISTRO_AD_BREAKER_ENABLED, LegacyADBreakerEnabledSetting);
                this.put(ADEnabledSetting.AD_ENABLED, Setting.boolSetting((String)ADEnabledSetting.AD_ENABLED, (Setting)LegacyADEnabledSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(ADEnabledSetting.AD_BREAKER_ENABLED, Setting.boolSetting((String)ADEnabledSetting.AD_BREAKER_ENABLED, (Setting)LegacyADBreakerEnabledSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(ADEnabledSetting.INTERPOLATION_IN_HCAD_COLD_START_ENABLED, Setting.boolSetting((String)ADEnabledSetting.INTERPOLATION_IN_HCAD_COLD_START_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(ADEnabledSetting.DOOR_KEEPER_IN_CACHE_ENABLED, Setting.boolSetting((String)ADEnabledSetting.DOOR_KEEPER_IN_CACHE_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            }
        });
    }
}

