/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.PortsRange;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.transport.AuxTransport;
import org.opensearch.transport.BindTransportException;
import org.opensearch.transport.Transport;

public class Netty4GrpcServerTransport
extends AuxTransport {
    private static final Logger logger = LogManager.getLogger(Netty4GrpcServerTransport.class);
    public static final String GRPC_TRANSPORT_SETTING_KEY = "transport-grpc";
    public static final Setting<PortsRange> SETTING_GRPC_PORT = AUX_TRANSPORT_PORT.getConcreteSettingForNamespace("transport-grpc");
    public static final Setting<Integer> SETTING_GRPC_PUBLISH_PORT = Setting.intSetting((String)"grpc.publish_port", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> SETTING_GRPC_HOST = Setting.listSetting((String)"grpc.host", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> SETTING_GRPC_BIND_HOST = Setting.listSetting((String)"grpc.bind_host", SETTING_GRPC_HOST, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> SETTING_GRPC_PUBLISH_HOST = Setting.listSetting((String)"grpc.publish_host", SETTING_GRPC_HOST, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> SETTING_GRPC_WORKER_COUNT = new Setting("grpc.netty.worker_count", s -> Integer.toString(OpenSearchExecutors.allocatedProcessors((Settings)s)), s -> Setting.parseInt((String)s, (int)1, (String)"grpc.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> SETTING_GRPC_MAX_CONCURRENT_CONNECTION_CALLS = Setting.intSetting((String)"grpc.netty.max_concurrent_connection_calls", (int)100, (int)1, (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SETTING_GRPC_MAX_MSG_SIZE = Setting.byteSizeSetting((String)"grpc.netty.max_msg_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(0L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(Integer.MAX_VALUE, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SETTING_GRPC_MAX_CONNECTION_AGE = Setting.timeSetting((String)"grpc.netty.max_connection_age", (TimeValue)new TimeValue(Long.MAX_VALUE), (TimeValue)new TimeValue(0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SETTING_GRPC_MAX_CONNECTION_IDLE = Setting.timeSetting((String)"grpc.netty.max_connection_idle", (TimeValue)new TimeValue(Long.MAX_VALUE), (TimeValue)new TimeValue(0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SETTING_GRPC_KEEPALIVE_TIMEOUT = Setting.timeSetting((String)"grpc.netty.keepalive_timeout", (TimeValue)new TimeValue(Long.MAX_VALUE), (TimeValue)new TimeValue(0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    protected PortsRange port;
    protected String portSettingKey;
    protected final Settings settings;
    private final NetworkService networkService;
    private final List<BindableService> services;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private final int nettyEventLoopThreads;
    private final long maxInboundMessageSize;
    private final long maxConcurrentConnectionCalls;
    private final TimeValue maxConnectionAge;
    private final TimeValue maxConnectionIdle;
    private final TimeValue keepAliveTimeout;
    private final CopyOnWriteArrayList<Server> servers = new CopyOnWriteArrayList();
    private final List<UnaryOperator<NettyServerBuilder>> serverBuilderConfigs = new ArrayList<UnaryOperator<NettyServerBuilder>>();
    private volatile BoundTransportAddress boundAddress;
    private volatile EventLoopGroup eventLoopGroup;

    public Netty4GrpcServerTransport(Settings settings, List<BindableService> services, NetworkService networkService) {
        logger.debug("Initializing Netty4GrpcServerTransport with settings = {}", (Object)settings);
        this.settings = Objects.requireNonNull(settings);
        this.services = Objects.requireNonNull(services);
        this.networkService = Objects.requireNonNull(networkService);
        List grpcBindHost = (List)SETTING_GRPC_BIND_HOST.get(settings);
        this.bindHosts = (grpcBindHost.isEmpty() ? (List)NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : grpcBindHost).toArray(Strings.EMPTY_ARRAY);
        List grpcPublishHost = (List)SETTING_GRPC_PUBLISH_HOST.get(settings);
        this.publishHosts = (grpcPublishHost.isEmpty() ? (List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : grpcPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.port = (PortsRange)SETTING_GRPC_PORT.get(settings);
        this.nettyEventLoopThreads = (Integer)SETTING_GRPC_WORKER_COUNT.get(settings);
        this.maxInboundMessageSize = ((ByteSizeValue)SETTING_GRPC_MAX_MSG_SIZE.get(settings)).getBytes();
        this.maxConcurrentConnectionCalls = ((Integer)SETTING_GRPC_MAX_CONCURRENT_CONNECTION_CALLS.get(settings)).intValue();
        this.maxConnectionAge = (TimeValue)SETTING_GRPC_MAX_CONNECTION_AGE.get(settings);
        this.maxConnectionIdle = (TimeValue)SETTING_GRPC_MAX_CONNECTION_IDLE.get(settings);
        this.keepAliveTimeout = (TimeValue)SETTING_GRPC_KEEPALIVE_TIMEOUT.get(settings);
        this.portSettingKey = SETTING_GRPC_PORT.getKey();
    }

    public String settingKey() {
        return GRPC_TRANSPORT_SETTING_KEY;
    }

    public BoundTransportAddress getBoundAddress() {
        return this.boundAddress;
    }

    protected void addServerConfig(UnaryOperator<NettyServerBuilder> configModifier) {
        this.serverBuilderConfigs.add(configModifier);
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.eventLoopGroup = new NioEventLoopGroup(this.nettyEventLoopThreads, OpenSearchExecutors.daemonThreadFactory((Settings)this.settings, (String)"grpc_event_loop"));
            this.bindServer();
            success = true;
            logger.info("Started gRPC server on port {}", (Object)this.port);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        for (Server server : this.servers) {
            if (server == null) continue;
            server.shutdown();
            try {
                server.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while shutting down gRPC server");
            }
            finally {
                server.shutdownNow();
            }
        }
        if (this.eventLoopGroup != null) {
            try {
                this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Failed to shut down event loop group");
            }
        }
    }

    protected void doClose() {
        this.eventLoopGroup.close();
    }

    private void bindServer() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", (Throwable)e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address, this.port));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", (Throwable)e);
        }
        int publishPort = Transport.resolveTransportPublishPort((int)((Integer)SETTING_GRPC_PUBLISH_PORT.get(this.settings)), boundAddresses, (InetAddress)publishInetAddress);
        if (publishPort < 0) {
            throw new BindTransportException("Failed to auto-resolve grpc publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + this.portSettingKey + " or " + SETTING_GRPC_PUBLISH_PORT.getKey());
        }
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        this.boundAddress = new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), publishAddress);
        logger.info("{}", (Object)this.boundAddress);
    }

    private TransportAddress bindAddress(InetAddress hostAddress, PortsRange portRange) {
        AtomicReference addr = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = portRange.iterate(portNumber -> {
            try {
                InetSocketAddress address = new InetSocketAddress(hostAddress, portNumber);
                NettyServerBuilder serverBuilder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).directExecutor()).bossEventLoopGroup(this.eventLoopGroup).workerEventLoopGroup(this.eventLoopGroup).maxInboundMessageSize((int)this.maxInboundMessageSize).maxConcurrentCallsPerConnection((int)this.maxConcurrentConnectionCalls).maxConnectionAge(this.maxConnectionAge.duration(), this.maxConnectionAge.timeUnit()).maxConnectionIdle(this.maxConnectionIdle.duration(), this.maxConnectionIdle.timeUnit()).keepAliveTimeout(this.keepAliveTimeout.duration(), this.keepAliveTimeout.timeUnit()).channelType(NioServerSocketChannel.class).addService(new HealthStatusManager().getHealthService())).addService(ProtoReflectionService.newInstance());
                for (UnaryOperator<NettyServerBuilder> op : this.serverBuilderConfigs) {
                    op.apply(serverBuilder);
                }
                this.services.forEach(arg_0 -> ((NettyServerBuilder)serverBuilder).addService(arg_0));
                Server srv = serverBuilder.build().start();
                this.servers.add(srv);
                addr.set(new TransportAddress(hostAddress, portNumber));
                logger.debug("Bound gRPC to address {{}}", (Object)address);
                return true;
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
        });
        if (!success) {
            throw new RuntimeException("Failed to bind to " + String.valueOf(hostAddress) + " on ports " + String.valueOf(portRange), (Throwable)lastException.get());
        }
        return (TransportAddress)addr.get();
    }
}

