/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master.ui;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SSLOptions;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DeployMessages$RequestMasterState$;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.Master;
import org.apache.spark.deploy.master.WorkerInfo;
import org.apache.spark.deploy.master.ui.ApplicationPage;
import org.apache.spark.deploy.master.ui.MasterPage;
import org.apache.spark.deploy.master.ui.MasterWebUI$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.WebUI;
import org.apache.spark.ui.WebUI$;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb!B\f\u0019\u0001i!\u0003\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011Y\u0002!\u0011!Q\u0001\nIB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019a\u0005\u0001)A\u0005\r\"9Q\n\u0001b\u0001\n\u0003q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0001(\t\rQ\u0003\u0001\u0015!\u0003P\u0011\u001d)\u0006A1A\u0005\u0002YCaA\u0019\u0001!\u0002\u00139\u0006\"B2\u0001\t\u0003!\u0007\"\u00025\u0001\t\u0003!\u0007\"B5\u0001\t\u0003Q\u0007\"\u00029\u0001\t\u0013\t\b\"\u0002?\u0001\t\u0013ix\u0001CA\u000b1!\u0005!$a\u0006\u0007\u000f]A\u0002\u0012\u0001\u000e\u0002\u001a!1ah\u0005C\u0001\u0003CA\u0011\"a\t\u0014\u0005\u0004%I!!\n\t\u0011\u0005E2\u0003)A\u0005\u0003O\u00111\"T1ti\u0016\u0014x+\u001a2V\u0013*\u0011\u0011DG\u0001\u0003k&T!a\u0007\u000f\u0002\r5\f7\u000f^3s\u0015\tib$\u0001\u0004eKBdw.\u001f\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sON\u0019\u0001!\n\u0016\u0011\u0005\u0019BS\"A\u0014\u000b\u0005eq\u0012BA\u0015(\u0005\u00159VMY+J!\tYc&D\u0001-\u0015\tic$\u0001\u0005j]R,'O\\1m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0004\u0001U\t!\u0007\u0005\u00024i5\t!$\u0003\u000265\t1Q*Y:uKJ\fq!\\1ti\u0016\u0014\b%A\u0007sKF,Xm\u001d;fIB{'\u000f\u001e\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002A\u0005\u000e\u0003\"!\u0011\u0001\u000e\u0003aAQa\u0007\u0003A\u0002IBQa\u000e\u0003A\u0002a\n\u0011#\\1ti\u0016\u0014XI\u001c3q_&tGOU3g+\u00051\u0005CA$K\u001b\u0005A%BA%\u001f\u0003\r\u0011\boY\u0005\u0003\u0017\"\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\nnCN$XM]#oIB|\u0017N\u001c;SK\u001a\u0004\u0013aC6jY2,e.\u00192mK\u0012,\u0012a\u0014\t\u0003sAK!!\u0015\u001e\u0003\u000f\t{w\u000e\\3b]\u0006a1.\u001b7m\u000b:\f'\r\\3eA\u0005!B-Z2p[6L7o]5p]\u0012K7/\u00192mK\u0012\fQ\u0003Z3d_6l\u0017n]:j_:$\u0015n]1cY\u0016$\u0007%A\u000beK\u000e|W.\\5tg&|g.\u00117m_^lu\u000eZ3\u0016\u0003]\u0003\"\u0001W0\u000f\u0005ek\u0006C\u0001.;\u001b\u0005Y&B\u0001/1\u0003\u0019a$o\\8u}%\u0011aLO\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_u\u00051B-Z2p[6L7o]5p]\u0006cGn\\<N_\u0012,\u0007%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012!\u001a\t\u0003s\u0019L!a\u001a\u001e\u0003\tUs\u0017\u000e^\u0001\tC\u0012$\u0007K]8ys\u0006i\u0011\u000e\u001a+p+&\fE\r\u001a:fgN$\"a\u001b8\u0011\u0007ebw+\u0003\u0002nu\t1q\n\u001d;j_:DQa\\\bA\u0002]\u000b!!\u001b3\u0002\u000f%\u001cHj\\2bYR\u0011qJ\u001d\u0005\u0006gB\u0001\r\u0001^\u0001\bC\u0012$'/Z:t!\t)(0D\u0001w\u0015\t9\b0A\u0002oKRT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|m\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0003}I7\u000fR3d_6l\u0017n]:j_:Lgn\u001a*fcV,7\u000f^!mY><X\r\u001a\u000b\u0003\u001fzDaa`\tA\u0002\u0005\u0005\u0011a\u0001:fcB!\u00111AA\t\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00025uiBTA!a\u0003\u0002\u000e\u000591/\u001a:wY\u0016$(BAA\b\u0003\u0015Q\u0017M^1y\u0013\u0011\t\u0019\"!\u0002\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\f\u001b\u0006\u001cH/\u001a:XK\n,\u0016\n\u0005\u0002B'M\u00191#a\u0007\u0011\u0007e\ni\"C\u0002\u0002 i\u0012a!\u00118z%\u00164GCAA\f\u0003M\u0019F+\u0011+J\u0007~\u0013ViU(V%\u000e+u\fR%S+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003_\u0001\u0005Y\u0006tw-C\u0002a\u0003W\tAc\u0015+B)&\u001buLU#T\u001fV\u00136)R0E\u0013J\u0003\u0003")
public class MasterWebUI
extends WebUI {
    private final Master master;
    private final RpcEndpointRef masterEndpointRef;
    private final boolean killEnabled;
    private final boolean decommissionDisabled;
    private final String decommissionAllowMode;

    public Master master() {
        return this.master;
    }

    public RpcEndpointRef masterEndpointRef() {
        return this.masterEndpointRef;
    }

    public boolean killEnabled() {
        return this.killEnabled;
    }

    public boolean decommissionDisabled() {
        return this.decommissionDisabled;
    }

    public String decommissionAllowMode() {
        return this.decommissionAllowMode;
    }

    @Override
    public void initialize() {
        MasterPage masterPage = new MasterPage(this);
        this.attachPage(new ApplicationPage(this));
        this.attachPage(masterPage);
        this.addStaticHandler(MasterWebUI$.MODULE$.org$apache$spark$deploy$master$ui$MasterWebUI$$STATIC_RESOURCE_DIR(), this.addStaticHandler$default$2());
        String x$1 = "/app/kill";
        String x$2 = "/";
        Function1 & Serializable x$3 = (Function1 & Serializable)request -> {
            masterPage.handleAppKillRequest(request);
            return BoxedUnit.UNIT;
        };
        Set x$4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"POST"}));
        String x$5 = JettyUtils$.MODULE$.createRedirectHandler$default$4();
        this.attachHandler(JettyUtils$.MODULE$.createRedirectHandler("/app/kill", "/", (Function1<HttpServletRequest, BoxedUnit>)x$3, x$5, (Set<String>)x$4));
        String x$6 = "/driver/kill";
        String x$7 = "/";
        Function1 & Serializable x$8 = (Function1 & Serializable)request -> {
            masterPage.handleDriverKillRequest(request);
            return BoxedUnit.UNIT;
        };
        Set x$9 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"POST"}));
        String x$10 = JettyUtils$.MODULE$.createRedirectHandler$default$4();
        this.attachHandler(JettyUtils$.MODULE$.createRedirectHandler("/driver/kill", "/", (Function1<HttpServletRequest, BoxedUnit>)x$8, x$10, (Set<String>)x$9));
        this.attachHandler(JettyUtils$.MODULE$.createServletHandler("/workers/kill", new HttpServlet(this){
            private final /* synthetic */ MasterWebUI $outer;

            public void doPost(HttpServletRequest req, HttpServletResponse resp) {
                Seq hostnames = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)req.getParameterValues("host")).getOrElse((Function0 & Serializable)() -> (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
                if (this.$outer.decommissionDisabled() || !this.$outer.org$apache$spark$deploy$master$ui$MasterWebUI$$isDecommissioningRequestAllowed(req)) {
                    resp.sendError(405);
                } else {
                    Integer removedWorkers = (Integer)this.$outer.masterEndpointRef().askSync(new DeployMessages.DecommissionWorkersOnHosts((Seq<String>)hostnames), ClassTag$.MODULE$.apply(Integer.class));
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Decommissioning of hosts ").append(hostnames).append(" decommissioned ").append(removedWorkers).append(" workers").toString());
                    if (Predef$.MODULE$.Integer2int(removedWorkers) > 0) {
                        resp.setStatus(200);
                    } else if (BoxesRunTime.equalsNumObject((Number)removedWorkers, (Object)BoxesRunTime.boxToInteger((int)0))) {
                        resp.sendError(404);
                    } else {
                        resp.setStatus(500);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doPost$1(), $anonfun$doPost$2(scala.collection.immutable.Seq java.lang.Integer )}, serializedLambda);
            }
        }, ""));
    }

    public void addProxy() {
        ServletContextHandler handler = JettyUtils$.MODULE$.createProxyHandler((Function1<String, Option<String>>)(Function1 & Serializable)id -> this.idToUiAddress((String)id));
        this.attachHandler(handler);
    }

    public Option<String> idToUiAddress(String id) {
        DeployMessages.MasterStateResponse state = (DeployMessages.MasterStateResponse)this.masterEndpointRef().askSync(DeployMessages$RequestMasterState$.MODULE$, ClassTag$.MODULE$.apply(DeployMessages.MasterStateResponse.class));
        Option maybeWorkerUiAddress = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])state.workers()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MasterWebUI.$anonfun$idToUiAddress$1(id, x$1))).map((Function1 & Serializable)x$2 -> x$2.webUiAddress());
        Option maybeAppUiAddress = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])state.activeApps()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MasterWebUI.$anonfun$idToUiAddress$3(id, x$3))).map((Function1 & Serializable)x$4 -> x$4.desc().appUiUrl());
        return maybeWorkerUiAddress.orElse((Function0 & Serializable)() -> maybeAppUiAddress);
    }

    private boolean isLocal(InetAddress address) {
        boolean bl;
        block4: {
            if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                return true;
            }
            try {
                if (NetworkInterface.getByInetAddress(address) != null) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (SocketException socketException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean org$apache$spark$deploy$master$ui$MasterWebUI$$isDecommissioningRequestAllowed(HttpServletRequest req) {
        boolean bl;
        block4: {
            String string = this.decommissionAllowMode();
            switch (string == null ? 0 : string.hashCode()) {
                case 62368553: {
                    if (!"ALLOW".equals(string)) break;
                    bl = true;
                    break block4;
                }
                case 72607563: {
                    if (!"LOCAL".equals(string)) break;
                    bl = this.isLocal(InetAddress.getByName(req.getRemoteAddr()));
                    break block4;
                }
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$idToUiAddress$1(String id$1, WorkerInfo x$1) {
        String string = x$1.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$idToUiAddress$3(String id$1, ApplicationInfo x$3) {
        String string = x$3.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MasterWebUI(Master master, int requestedPort) {
        this.master = master;
        SecurityManager x$1 = master.securityMgr();
        SSLOptions x$2 = master.securityMgr().getSSLOptions("standalone");
        int x$3 = requestedPort;
        SparkConf x$4 = master.conf();
        String x$5 = "MasterUI";
        String x$6 = WebUI$.MODULE$.$lessinit$greater$default$5();
        int x$7 = WebUI$.MODULE$.$lessinit$greater$default$7();
        super(x$1, x$2, x$3, x$4, x$6, "MasterUI", x$7);
        this.masterEndpointRef = master.self();
        this.killEnabled = BoxesRunTime.unboxToBoolean((Object)master.conf().get(UI$.MODULE$.UI_KILL_ENABLED()));
        this.decommissionDisabled = !BoxesRunTime.unboxToBoolean((Object)master.conf().get(package$.MODULE$.DECOMMISSION_ENABLED()));
        this.decommissionAllowMode = master.conf().get(UI$.MODULE$.MASTER_UI_DECOMMISSION_ALLOW_MODE());
        this.initialize();
    }
}

