/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class StorageUtils$
implements Logging {
    public static final StorageUtils$ MODULE$;
    private static final Function1<DirectBuffer, BoxedUnit> bufferCleaner;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Function1 & Serializable intersect;
        MODULE$ = new StorageUtils$();
        Logging.$init$((Logging)MODULE$);
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            Method cleanerMethod = Utils$.MODULE$.classForName("sun.misc.Unsafe", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getMethod("invokeCleaner", ByteBuffer.class);
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            intersect = (Function1 & Serializable)buffer -> {
                cleanerMethod.invoke((Object)unsafe, buffer);
                return BoxedUnit.UNIT;
            };
        } else {
            Method cleanerMethod = Utils$.MODULE$.classForName("sun.misc.Cleaner", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getMethod("clean", new Class[0]);
            intersect = (Function1 & Serializable)buffer -> {
                StorageUtils$.$anonfun$bufferCleaner$2(cleanerMethod, buffer);
                return BoxedUnit.UNIT;
            };
        }
        bufferCleaner = intersect;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Function1<DirectBuffer, BoxedUnit> bufferCleaner() {
        return bufferCleaner;
    }

    public void dispose(ByteBuffer buffer) {
        block0: {
            if (buffer == null || !(buffer instanceof MappedByteBuffer)) break block0;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Disposing of ").append(buffer).toString());
            this.bufferCleaner().apply((Object)((DirectBuffer)((Object)buffer)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public int externalShuffleServicePort(SparkConf conf) {
        void var2_2;
        int tmpPort = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkOrYarnConfig(conf, package$.MODULE$.SHUFFLE_SERVICE_PORT().key(), package$.MODULE$.SHUFFLE_SERVICE_PORT().defaultValueString())));
        return tmpPort == 0 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.get(package$.MODULE$.SHUFFLE_SERVICE_PORT().key()))) : var2_2;
    }

    public static final /* synthetic */ void $anonfun$bufferCleaner$2(Method cleanerMethod$2, DirectBuffer buffer) {
        block0: {
            Cleaner cleaner = buffer.cleaner();
            if (cleaner == null) break block0;
            cleanerMethod$2.invoke((Object)cleaner, new Object[0]);
        }
    }

    private StorageUtils$() {
    }
}

