/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.HighlightFunction;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.NestedAllTupleFields;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.ScoreFunction;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParser;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParserBaseVisitor;
import org.opensearch.sql.sql.parser.ParserUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstExpressionBuilder
extends OpenSearchSQLParserBaseVisitor<UnresolvedExpression> {
    @Override
    public UnresolvedExpression visitTableName(OpenSearchSQLParser.TableNameContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.qualifiedName());
    }

    @Override
    public UnresolvedExpression visitColumnName(OpenSearchSQLParser.ColumnNameContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.qualifiedName());
    }

    @Override
    public UnresolvedExpression visitIdent(OpenSearchSQLParser.IdentContext ctx) {
        return this.visitIdentifiers(Collections.singletonList(ctx));
    }

    @Override
    public UnresolvedExpression visitQualifiedName(OpenSearchSQLParser.QualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.ident());
    }

    @Override
    public UnresolvedExpression visitMathExpressionAtom(OpenSearchSQLParser.MathExpressionAtomContext ctx) {
        return new Function(ctx.mathOperator.getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitNestedExpressionAtom(OpenSearchSQLParser.NestedExpressionAtomContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public UnresolvedExpression visitNestedAllFunctionCall(OpenSearchSQLParser.NestedAllFunctionCallContext ctx) {
        return new NestedAllTupleFields(this.visitQualifiedName(ctx.allTupleFields().path).toString());
    }

    @Override
    public UnresolvedExpression visitScalarFunctionCall(OpenSearchSQLParser.ScalarFunctionCallContext ctx) {
        return this.buildFunction(ctx.scalarFunctionName().getText(), ctx.functionArgs().functionArg());
    }

    @Override
    public UnresolvedExpression visitGetFormatFunctionCall(OpenSearchSQLParser.GetFormatFunctionCallContext ctx) {
        return new Function(ctx.getFormatFunction().GET_FORMAT().toString(), this.getFormatFunctionArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitHighlightFunctionCall(OpenSearchSQLParser.HighlightFunctionCallContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.highlightFunction().highlightArg().forEach(v -> builder.put((Object)v.highlightArgName().getText().toLowerCase(Locale.ROOT), (Object)new Literal(StringUtils.unquoteText(v.highlightArgValue().getText()), DataType.STRING)));
        return new HighlightFunction((UnresolvedExpression)this.visit((ParseTree)ctx.highlightFunction().relevanceField()), (Map<String, Literal>)builder.build());
    }

    @Override
    public UnresolvedExpression visitTimestampFunctionCall(OpenSearchSQLParser.TimestampFunctionCallContext ctx) {
        return new Function(ctx.timestampFunction().timestampFunctionName().getText(), this.timestampFunctionArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitPositionFunction(OpenSearchSQLParser.PositionFunctionContext ctx) {
        return new Function(BuiltinFunctionName.POSITION.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(0)), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(1))));
    }

    @Override
    public UnresolvedExpression visitTableFilter(OpenSearchSQLParser.TableFilterContext ctx) {
        return new Function(BuiltinFunctionName.LIKE.getName().getFunctionName(), Arrays.asList(AstDSL.qualifiedName("TABLE_NAME"), (UnresolvedExpression)this.visit((ParseTree)ctx.showDescribePattern())));
    }

    @Override
    public UnresolvedExpression visitColumnFilter(OpenSearchSQLParser.ColumnFilterContext ctx) {
        return new Function(BuiltinFunctionName.LIKE.getName().getFunctionName(), Arrays.asList(AstDSL.qualifiedName("COLUMN_NAME"), (UnresolvedExpression)this.visit((ParseTree)ctx.showDescribePattern())));
    }

    @Override
    public UnresolvedExpression visitShowDescribePattern(OpenSearchSQLParser.ShowDescribePatternContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.stringLiteral());
    }

    @Override
    public UnresolvedExpression visitFilteredAggregationFunctionCall(OpenSearchSQLParser.FilteredAggregationFunctionCallContext ctx) {
        AggregateFunction agg = (AggregateFunction)this.visit((ParseTree)ctx.aggregateFunction());
        return agg.condition((UnresolvedExpression)this.visit((ParseTree)ctx.filterClause()));
    }

    @Override
    public UnresolvedExpression visitWindowFunctionClause(OpenSearchSQLParser.WindowFunctionClauseContext ctx) {
        OpenSearchSQLParser.OverClauseContext overClause = ctx.overClause();
        List<UnresolvedExpression> partitionByList = Collections.emptyList();
        if (overClause.partitionByClause() != null) {
            partitionByList = overClause.partitionByClause().expression().stream().map(arg_0 -> ((AstExpressionBuilder)this).visit(arg_0)).collect(Collectors.toList());
        }
        List<Object> sortList = Collections.emptyList();
        if (overClause.orderByClause() != null) {
            sortList = overClause.orderByClause().orderByElement().stream().map(item -> ImmutablePair.of((Object)ParserUtils.createSortOption(item), (Object)((UnresolvedExpression)this.visit((ParseTree)item.expression())))).collect(Collectors.toList());
        }
        return new WindowFunction((UnresolvedExpression)this.visit((ParseTree)ctx.function), partitionByList, sortList);
    }

    @Override
    public UnresolvedExpression visitScalarWindowFunction(OpenSearchSQLParser.ScalarWindowFunctionContext ctx) {
        return this.buildFunction(ctx.functionName.getText(), ctx.functionArgs().functionArg());
    }

    @Override
    public UnresolvedExpression visitRegularAggregateFunctionCall(OpenSearchSQLParser.RegularAggregateFunctionCallContext ctx) {
        return new AggregateFunction(ctx.functionName.getText(), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg()));
    }

    @Override
    public UnresolvedExpression visitDistinctCountFunctionCall(OpenSearchSQLParser.DistinctCountFunctionCallContext ctx) {
        return new AggregateFunction(ctx.COUNT().getText(), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg()), true);
    }

    @Override
    public UnresolvedExpression visitCountStarFunctionCall(OpenSearchSQLParser.CountStarFunctionCallContext ctx) {
        return new AggregateFunction("COUNT", AllFields.of());
    }

    @Override
    public UnresolvedExpression visitFilterClause(OpenSearchSQLParser.FilterClauseContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public UnresolvedExpression visitIsNullPredicate(OpenSearchSQLParser.IsNullPredicateContext ctx) {
        return new Function(ctx.nullNotnull().NOT() == null ? BuiltinFunctionName.IS_NULL.getName().getFunctionName() : BuiltinFunctionName.IS_NOT_NULL.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.predicate())));
    }

    @Override
    public UnresolvedExpression visitBetweenPredicate(OpenSearchSQLParser.BetweenPredicateContext ctx) {
        UnresolvedExpression func = AstDSL.between((UnresolvedExpression)this.visit((ParseTree)ctx.predicate(0)), (UnresolvedExpression)this.visit((ParseTree)ctx.predicate(1)), (UnresolvedExpression)this.visit((ParseTree)ctx.predicate(2)));
        if (ctx.NOT() != null) {
            func = AstDSL.not(func);
        }
        return func;
    }

    @Override
    public UnresolvedExpression visitLikePredicate(OpenSearchSQLParser.LikePredicateContext ctx) {
        return new Function(ctx.NOT() == null ? BuiltinFunctionName.LIKE.getName().getFunctionName() : BuiltinFunctionName.NOT_LIKE.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitRegexpPredicate(OpenSearchSQLParser.RegexpPredicateContext ctx) {
        return new Function(BuiltinFunctionName.REGEXP.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitInPredicate(OpenSearchSQLParser.InPredicateContext ctx) {
        UnresolvedExpression field = (UnresolvedExpression)this.visit((ParseTree)ctx.predicate());
        List<UnresolvedExpression> inLists = ctx.expressions().expression().stream().map(arg_0 -> ((AstExpressionBuilder)this).visit(arg_0)).collect(Collectors.toList());
        UnresolvedExpression in = AstDSL.in(field, inLists);
        return ctx.NOT() != null ? AstDSL.not(in) : in;
    }

    @Override
    public UnresolvedExpression visitAndExpression(OpenSearchSQLParser.AndExpressionContext ctx) {
        return new And((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitOrExpression(OpenSearchSQLParser.OrExpressionContext ctx) {
        return new Or((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitNotExpression(OpenSearchSQLParser.NotExpressionContext ctx) {
        return new Not((UnresolvedExpression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public UnresolvedExpression visitString(OpenSearchSQLParser.StringContext ctx) {
        return AstDSL.stringLiteral(StringUtils.unquoteText(ctx.getText()));
    }

    @Override
    public UnresolvedExpression visitSignedDecimal(OpenSearchSQLParser.SignedDecimalContext ctx) {
        long number = Long.parseLong(ctx.getText());
        if (Integer.MIN_VALUE <= number && number <= Integer.MAX_VALUE) {
            return AstDSL.intLiteral((int)number);
        }
        return AstDSL.longLiteral(number);
    }

    @Override
    public UnresolvedExpression visitSignedReal(OpenSearchSQLParser.SignedRealContext ctx) {
        return AstDSL.doubleLiteral(Double.valueOf(ctx.getText()));
    }

    @Override
    public UnresolvedExpression visitBoolean(OpenSearchSQLParser.BooleanContext ctx) {
        return AstDSL.booleanLiteral(Boolean.valueOf(ctx.getText()));
    }

    @Override
    public UnresolvedExpression visitStringLiteral(OpenSearchSQLParser.StringLiteralContext ctx) {
        return AstDSL.stringLiteral(StringUtils.unquoteText(ctx.getText()));
    }

    @Override
    public UnresolvedExpression visitNullLiteral(OpenSearchSQLParser.NullLiteralContext ctx) {
        return AstDSL.nullLiteral();
    }

    @Override
    public UnresolvedExpression visitDateLiteral(OpenSearchSQLParser.DateLiteralContext ctx) {
        return AstDSL.dateLiteral(StringUtils.unquoteText(ctx.date.getText()));
    }

    @Override
    public UnresolvedExpression visitTimeLiteral(OpenSearchSQLParser.TimeLiteralContext ctx) {
        return AstDSL.timeLiteral(StringUtils.unquoteText(ctx.time.getText()));
    }

    @Override
    public UnresolvedExpression visitTimestampLiteral(OpenSearchSQLParser.TimestampLiteralContext ctx) {
        return AstDSL.timestampLiteral(StringUtils.unquoteText(ctx.timestamp.getText()));
    }

    @Override
    public UnresolvedExpression visitIntervalLiteral(OpenSearchSQLParser.IntervalLiteralContext ctx) {
        return new Interval((UnresolvedExpression)this.visit((ParseTree)ctx.expression()), IntervalUnit.of(ctx.intervalUnit().getText()));
    }

    @Override
    public UnresolvedExpression visitBinaryComparisonPredicate(OpenSearchSQLParser.BinaryComparisonPredicateContext ctx) {
        String functionName = ctx.comparisonOperator().getText();
        return new Function(functionName.equals("<>") ? "!=" : functionName, Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitCaseFunctionCall(OpenSearchSQLParser.CaseFunctionCallContext ctx) {
        UnresolvedExpression caseValue = ctx.expression() == null ? null : (UnresolvedExpression)this.visit((ParseTree)ctx.expression());
        List<When> whenStatements = ctx.caseFuncAlternative().stream().map(when -> (When)this.visit((ParseTree)when)).collect(Collectors.toList());
        UnresolvedExpression elseStatement = ctx.elseArg == null ? null : (UnresolvedExpression)this.visit((ParseTree)ctx.elseArg);
        return new Case(caseValue, whenStatements, Optional.ofNullable(elseStatement));
    }

    @Override
    public UnresolvedExpression visitCaseFuncAlternative(OpenSearchSQLParser.CaseFuncAlternativeContext ctx) {
        return new When((UnresolvedExpression)this.visit((ParseTree)ctx.condition), (UnresolvedExpression)this.visit((ParseTree)ctx.consequent));
    }

    @Override
    public UnresolvedExpression visitDataTypeFunctionCall(OpenSearchSQLParser.DataTypeFunctionCallContext ctx) {
        return new Cast((UnresolvedExpression)this.visit((ParseTree)ctx.expression()), (UnresolvedExpression)this.visit((ParseTree)ctx.convertedDataType()));
    }

    @Override
    public UnresolvedExpression visitConvertedDataType(OpenSearchSQLParser.ConvertedDataTypeContext ctx) {
        return AstDSL.stringLiteral(ctx.getText());
    }

    @Override
    public UnresolvedExpression visitPercentileApproxFunctionCall(OpenSearchSQLParser.PercentileApproxFunctionCallContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("percent", AstDSL.doubleLiteral(Double.valueOf(ctx.percentileApproxFunction().percent.getText()))));
        if (ctx.percentileApproxFunction().compression != null) {
            builder.add((Object)new UnresolvedArgument("compression", AstDSL.doubleLiteral(Double.valueOf(ctx.percentileApproxFunction().compression.getText()))));
        }
        return new AggregateFunction("percentile", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().aggField), (List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedExpression visitNoFieldRelevanceFunction(OpenSearchSQLParser.NoFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.noFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.noFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitSingleFieldRelevanceFunction(OpenSearchSQLParser.SingleFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.singleFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.singleFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitAltSingleFieldRelevanceFunction(OpenSearchSQLParser.AltSingleFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.altSyntaxFunctionName.getText().toLowerCase(Locale.ROOT), this.altSingleFieldRelevanceFunctionArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitMultiFieldRelevanceFunction(OpenSearchSQLParser.MultiFieldRelevanceFunctionContext ctx) {
        String funcName = StringUtils.unquoteText(ctx.multiFieldRelevanceFunctionName().getText());
        if ((funcName.equalsIgnoreCase(BuiltinFunctionName.MULTI_MATCH.toString()) || funcName.equalsIgnoreCase(BuiltinFunctionName.MULTIMATCH.toString()) || funcName.equalsIgnoreCase(BuiltinFunctionName.MULTIMATCHQUERY.toString())) && !ctx.getRuleContexts(OpenSearchSQLParser.AlternateMultiMatchQueryContext.class).isEmpty()) {
            return new Function(ctx.multiFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.alternateMultiMatchArguments(ctx));
        }
        return new Function(ctx.multiFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.multiFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitAltMultiFieldRelevanceFunction(OpenSearchSQLParser.AltMultiFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.altSyntaxFunctionName.getText().toLowerCase(Locale.ROOT), this.altMultiFieldRelevanceFunctionArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitScoreRelevanceFunction(OpenSearchSQLParser.ScoreRelevanceFunctionContext ctx) {
        Literal weight = ctx.weight == null ? new Literal(1.0, DataType.DOUBLE) : new Literal(Double.parseDouble(ctx.weight.getText()), DataType.DOUBLE);
        return new ScoreFunction((UnresolvedExpression)this.visit((ParseTree)ctx.relevanceFunction()), weight);
    }

    private Function buildFunction(String functionName, List<OpenSearchSQLParser.FunctionArgContext> arg) {
        return new Function(functionName, arg.stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitExtractFunctionCall(OpenSearchSQLParser.ExtractFunctionCallContext ctx) {
        return new Function(ctx.extractFunction().EXTRACT().toString(), this.getExtractFunctionArguments(ctx));
    }

    private QualifiedName visitIdentifiers(List<OpenSearchSQLParser.IdentContext> identifiers) {
        return new QualifiedName(identifiers.stream().map(RuleContext::getText).map(StringUtils::unquoteIdentifier).collect(Collectors.toList()));
    }

    private void fillRelevanceArgs(List<OpenSearchSQLParser.RelevanceArgContext> args, ImmutableList.Builder<UnresolvedExpression> builder) {
        args.forEach(v -> builder.add((Object)(v.argName == null ? new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(Locale.ROOT), new Literal(StringUtils.unquoteText(v.relevanceArgValue().getText()), DataType.STRING)) : new UnresolvedArgument(StringUtils.unquoteText(v.argName.getText()).toLowerCase(Locale.ROOT), new Literal(StringUtils.unquoteText(v.argVal.getText()), DataType.STRING)))));
    }

    private List<UnresolvedExpression> noFieldRelevanceArguments(OpenSearchSQLParser.NoFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> singleFieldRelevanceArguments(OpenSearchSQLParser.SingleFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("field", new QualifiedName(StringUtils.unquoteText(ctx.field.getText()))));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> altSingleFieldRelevanceFunctionArguments(OpenSearchSQLParser.AltSingleFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("field", new QualifiedName(StringUtils.unquoteText(ctx.field.getText()))));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> multiFieldRelevanceArguments(OpenSearchSQLParser.MultiFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        RelevanceFieldList fields = new RelevanceFieldList(ctx.getRuleContexts(OpenSearchSQLParser.RelevanceFieldAndWeightContext.class).stream().collect(Collectors.toMap(f -> StringUtils.unquoteText(f.field.getText()), f -> Float.valueOf(f.weight == null ? 1.0f : Float.parseFloat(f.weight.getText())))));
        builder.add((Object)new UnresolvedArgument("fields", fields));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> getFormatFunctionArguments(OpenSearchSQLParser.GetFormatFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.getFormatFunction().getFormatType().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.getFormatFunction().functionArg()));
        return args;
    }

    private List<UnresolvedExpression> timestampFunctionArguments(OpenSearchSQLParser.TimestampFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.timestampFunction().simpleDateTimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.timestampFunction().firstArg), (UnresolvedExpression)this.visitFunctionArg(ctx.timestampFunction().secondArg));
        return args;
    }

    private List<UnresolvedExpression> alternateMultiMatchArguments(OpenSearchSQLParser.MultiFieldRelevanceFunctionContext ctx) {
        String[] fieldAndWeights;
        ImmutableList.Builder builder = ImmutableList.builder();
        HashMap<String, Float> fieldAndWeightMap = new HashMap<String, Float>();
        for (String fieldAndWeight : fieldAndWeights = StringUtils.unquoteText(((OpenSearchSQLParser.AlternateMultiMatchFieldContext)((Object)ctx.getRuleContexts(OpenSearchSQLParser.AlternateMultiMatchFieldContext.class).stream().findFirst().get())).argVal.getText()).split(",")) {
            String[] splitFieldAndWeights = fieldAndWeight.split("\\^");
            fieldAndWeightMap.put(splitFieldAndWeights[0], Float.valueOf(splitFieldAndWeights.length > 1 ? Float.parseFloat(splitFieldAndWeights[1]) : 1.0f));
        }
        builder.add((Object)new UnresolvedArgument("fields", new RelevanceFieldList(fieldAndWeightMap)));
        ctx.getRuleContexts(OpenSearchSQLParser.AlternateMultiMatchQueryContext.class).stream().findFirst().ifPresent(arg -> builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(arg.argVal.getText()), DataType.STRING))));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> altMultiFieldRelevanceFunctionArguments(OpenSearchSQLParser.AltMultiFieldRelevanceFunctionContext ctx) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put(ctx.field.getText(), Float.valueOf(1.0f));
        ImmutableList.Builder builder = ImmutableList.builder();
        RelevanceFieldList fields = new RelevanceFieldList(map);
        builder.add((Object)new UnresolvedArgument("fields", fields));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        this.fillRelevanceArgs(ctx.relevanceArg(), (ImmutableList.Builder<UnresolvedExpression>)builder);
        return builder.build();
    }

    private List<UnresolvedExpression> getExtractFunctionArguments(OpenSearchSQLParser.ExtractFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.extractFunction().datetimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.extractFunction().functionArg()));
        return args;
    }
}

