/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.queryset;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.searchrelevance.model.QueryWithReference;
import reactor.util.annotation.NonNull;

public class PutQuerySetRequest
extends ActionRequest {
    private final String name;
    private final String description;
    private final String sampling;
    private final List<QueryWithReference> querySetQueries;

    public PutQuerySetRequest(@NonNull String name, String description, @NonNull String sampling, @NonNull List<QueryWithReference> querySetQueries) {
        this.name = name;
        this.description = description;
        this.sampling = sampling;
        this.querySetQueries = querySetQueries;
    }

    public PutQuerySetRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.description = in.readOptionalString();
        this.sampling = in.readString();
        this.querySetQueries = in.readList(QueryWithReference::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        out.writeString(this.sampling);
        out.writeList(this.querySetQueries);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getSampling() {
        return this.sampling;
    }

    public List<QueryWithReference> getQuerySetQueries() {
        return this.querySetQueries;
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

