/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.actionlevel.RoleBasedActionPrivileges;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.spi.resources.sharing.Recipient;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import reactor.util.annotation.NonNull;

public class ResourceAccessHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResourceAccessHandler.class);
    private final ThreadContext threadContext;
    private final ResourceSharingIndexHandler resourceSharingIndexHandler;
    private final AdminDNs adminDNs;
    private final PrivilegesEvaluator privilegesEvaluator;

    @Inject
    public ResourceAccessHandler(ThreadPool threadPool, ResourceSharingIndexHandler resourceSharingIndexHandler, AdminDNs adminDns, PrivilegesEvaluator evaluator) {
        this.threadContext = threadPool.getThreadContext();
        this.resourceSharingIndexHandler = resourceSharingIndexHandler;
        this.adminDNs = adminDns;
        this.privilegesEvaluator = evaluator;
    }

    public void getOwnAndSharedResourceIdsForCurrentUser(@NonNull String resourceIndex, ActionListener<Set<String>> listener) {
        User user;
        UserSubjectImpl userSub = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSub == null ? null : userSub.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user; returning empty set");
            listener.onResponse(Collections.emptySet());
            return;
        }
        if (this.adminDNs.isAdmin(user)) {
            this.loadAllResources(resourceIndex, (ActionListener<Set<String>>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        HashSet<String> users = new HashSet<String>();
        users.add(user.getName());
        users.add("*");
        HashSet<String> roles = new HashSet<String>((Collection<String>)user.getSecurityRoles());
        roles.add("*");
        HashSet<String> backendRoles = new HashSet<String>((Collection<String>)user.getRoles());
        backendRoles.add("*");
        Set<String> flatPrincipals = Stream.concat(users.stream().map(u -> "user:" + u), Stream.concat(roles.stream().map(r -> "role:" + r), backendRoles.stream().map(b -> "backend:" + b))).collect(Collectors.toSet());
        BoolQueryBuilder query = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"created_by.user", (String)user.getName())).should((QueryBuilder)QueryBuilders.termsQuery((String)"all_shared_principals", flatPrincipals)).minimumShouldMatch(1);
        this.resourceSharingIndexHandler.fetchAccessibleResourceIds(resourceIndex, flatPrincipals, query, listener);
    }

    public void hasPermission(@NonNull String resourceId, @NonNull String resourceIndex, @NonNull String action, PrivilegesEvaluationContext context, ActionListener<Boolean> listener) {
        User user;
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSubject == null ? null : userSubject.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user found. Access to resource {} is not authorized.", (Object)resourceId);
            listener.onResponse((Object)false);
            return;
        }
        LOGGER.info("Checking if user '{}' has permission to resource '{}'", (Object)user.getName(), (Object)resourceId);
        if (this.adminDNs.isAdmin(user)) {
            LOGGER.debug("User '{}' is admin, automatically granted permission on '{}'", (Object)user.getName(), (Object)resourceId);
            listener.onResponse((Object)true);
            return;
        }
        PrivilegesEvaluationContext effectiveContext = context != null ? context : this.privilegesEvaluator.createContext(user, action);
        HashSet<String> userRoles = new HashSet<String>((Collection<String>)user.getSecurityRoles());
        HashSet<String> userBackendRoles = new HashSet<String>((Collection<String>)user.getRoles());
        ActionPrivileges actionPrivileges = effectiveContext.getActionPrivileges();
        if (!(actionPrivileges instanceof RoleBasedActionPrivileges)) {
            LOGGER.debug("Plugin/Token access to resources is currently not supported. {} is not authorized to access resource {}.", (Object)user.getName(), (Object)resourceId);
            listener.onResponse((Object)false);
            return;
        }
        RoleBasedActionPrivileges roleBasedActionPrivileges = (RoleBasedActionPrivileges)actionPrivileges;
        this.resourceSharingIndexHandler.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)ActionListener.wrap(document -> {
            if (document == null) {
                LOGGER.warn("No sharing info found for '{}'. Action {} is not allowed.", (Object)resourceId, (Object)action);
                listener.onResponse((Object)false);
                return;
            }
            userRoles.add("*");
            userBackendRoles.add("*");
            if (document.isCreatedBy(user.getName())) {
                listener.onResponse((Object)true);
                return;
            }
            HashSet<String> accessLevels = new HashSet<String>();
            accessLevels.addAll(document.fetchAccessLevels(Recipient.USERS, Set.of(user.getName(), "*")));
            accessLevels.addAll(document.fetchAccessLevels(Recipient.ROLES, userRoles));
            accessLevels.addAll(document.fetchAccessLevels(Recipient.BACKEND_ROLES, userBackendRoles));
            if (accessLevels.isEmpty()) {
                listener.onResponse((Object)false);
                return;
            }
            ImmutableSet<String> allowedActions = roleBasedActionPrivileges.flattenedActionGroups().resolve(accessLevels);
            WildcardMatcher matcher = WildcardMatcher.from(allowedActions);
            listener.onResponse((Object)matcher.test(action));
        }, e -> {
            LOGGER.error("Error while checking permission for user {} on resource {}: {}", (Object)user.getName(), (Object)resourceId, (Object)e.getMessage());
            listener.onFailure(e);
        }));
    }

    public void patchSharingInfo(@NonNull String resourceId, @NonNull String resourceIndex, @Nullable ShareWith add, @Nullable ShareWith revoke, ActionListener<ResourceSharing> listener) {
        User user;
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSubject == null ? null : userSubject.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user found. Failed to patch resource sharing info {}", (Object)resourceId);
            listener.onFailure((Exception)new OpenSearchStatusException("No authenticated user found. Failed to patch resource sharing info " + resourceId, RestStatus.UNAUTHORIZED, new Object[0]));
            return;
        }
        LOGGER.debug("User {} is updating sharing info for resource {} in index {} with add: {}, revoke: {} ", (Object)user.getName(), (Object)resourceId, (Object)resourceIndex, (Object)add, (Object)revoke);
        this.resourceSharingIndexHandler.patchSharingInfo(resourceId, resourceIndex, add, revoke, (ActionListener<ResourceSharing>)ActionListener.wrap(sharingInfo -> {
            LOGGER.debug("Successfully patched sharing info for resource {} with add: {}, revoke: {}", (Object)resourceId, (Object)add, (Object)revoke);
            listener.onResponse(sharingInfo);
        }, e -> {
            LOGGER.error("Failed to patched sharing info for resource {} with add: {}, revoke: {} : {}", (Object)resourceId, (Object)add, (Object)revoke, (Object)e.getMessage());
            listener.onFailure(e);
        }));
    }

    public void getSharingInfo(@NonNull String resourceId, @NonNull String resourceIndex, ActionListener<ResourceSharing> listener) {
        User user;
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSubject == null ? null : userSubject.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user found. Failed to fetch resource sharing info {}", (Object)resourceId);
            listener.onFailure((Exception)new OpenSearchStatusException("No authenticated user found. Failed to fetch resource sharing info " + resourceId, RestStatus.UNAUTHORIZED, new Object[0]));
            return;
        }
        LOGGER.debug("User {} is fetching sharing info for resource {} in index {}", (Object)user.getName(), (Object)resourceId, (Object)resourceIndex);
        this.resourceSharingIndexHandler.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)ActionListener.wrap(sharingInfo -> {
            LOGGER.debug("Successfully fetched sharing info for resource {} in index {}", (Object)resourceId, (Object)resourceIndex);
            listener.onResponse(sharingInfo);
        }, e -> {
            LOGGER.error("Failed to fetched sharing info for resource {} in index {}: {}", (Object)resourceId, (Object)resourceIndex, (Object)e.getMessage());
            listener.onFailure(e);
        }));
    }

    public void share(@NonNull String resourceId, @NonNull String resourceIndex, @NonNull ShareWith target, ActionListener<ResourceSharing> listener) {
        User user;
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSubject == null ? null : userSubject.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user found. Failed to share resource {}", (Object)resourceId);
            listener.onFailure((Exception)new OpenSearchStatusException("No authenticated user found. Failed to share resource " + resourceId, RestStatus.UNAUTHORIZED, new Object[0]));
            return;
        }
        LOGGER.debug("Sharing resource {} created by {} with {}", (Object)resourceId, (Object)user.getName(), (Object)target.toString());
        this.resourceSharingIndexHandler.share(resourceId, resourceIndex, target, (ActionListener<ResourceSharing>)ActionListener.wrap(sharingInfo -> {
            LOGGER.debug("Successfully shared resource {} with {}", (Object)resourceId, (Object)target.toString());
            listener.onResponse(sharingInfo);
        }, e -> {
            LOGGER.error("Failed to share resource {} with {}: {}", (Object)resourceId, (Object)target.toString(), (Object)e.getMessage());
            listener.onFailure(e);
        }));
    }

    public void revoke(@NonNull String resourceId, @NonNull String resourceIndex, @NonNull ShareWith target, ActionListener<ResourceSharing> listener) {
        User user;
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadContext.getPersistent("_opendistro_security_authenticated_user");
        User user2 = user = userSubject == null ? null : userSubject.getUser();
        if (user == null) {
            LOGGER.warn("No authenticated user found. Failed to revoke access to resource {}", (Object)resourceId);
            listener.onFailure((Exception)new OpenSearchStatusException("No authenticated user found. Failed to revoke access to resource {}" + resourceId, RestStatus.UNAUTHORIZED, new Object[0]));
            return;
        }
        LOGGER.debug("User {} revoking access to resource {} for {}.", (Object)user.getName(), (Object)resourceId, (Object)target);
        this.resourceSharingIndexHandler.revoke(resourceId, resourceIndex, target, (ActionListener<ResourceSharing>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), exception -> {
            LOGGER.error("Failed to revoke access to resource {} in index {}: {}", (Object)resourceId, (Object)resourceIndex, (Object)exception.getMessage());
            listener.onFailure(exception);
        }));
    }

    private void loadAllResources(String resourceIndex, ActionListener<Set<String>> listener) {
        this.resourceSharingIndexHandler.fetchAllResourceIds(resourceIndex, listener);
    }
}

