/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import com.fasterxml.jackson.databind.InjectableValues;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Booleans;
import org.opensearch.common.network.NetworkModule;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.netty4.ssl.SecureNetty4HttpServerTransport;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SecureHttpTransportSettingsProvider;
import org.opensearch.plugins.SecureSettingsFactory;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.NonValidatingObjectMapper;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.ssl.OpenSearchSecureSettingsFactory;
import org.opensearch.security.ssl.SecureSSLSettings;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.SslSettingsManager;
import org.opensearch.security.ssl.http.netty.ValidatingDispatcher;
import org.opensearch.security.ssl.rest.SecuritySSLInfoAction;
import org.opensearch.security.ssl.transport.DefaultPrincipalExtractor;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.ssl.transport.SecuritySSLTransportInterceptor;
import org.opensearch.security.ssl.util.SSLConfigConstants;
import org.opensearch.security.support.SecuritySettings;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.netty4.ssl.SecureNetty4Transport;
import org.opensearch.watcher.ResourceWatcherService;

public class OpenSearchSecuritySSLPlugin
extends Plugin
implements SystemIndexPlugin,
NetworkPlugin {
    private static final Setting<Boolean> SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION = Setting.boolSetting((String)"plugins.security.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    private static final Setting<Boolean> SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME = Setting.boolSetting((String)"plugins.security.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    private static boolean USE_NETTY_DEFAULT_ALLOCATOR = Booleans.parseBoolean((String)System.getProperty("opensearch.unsafe.use_netty_default_allocator"), (boolean)false);
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final String CLIENT_TYPE = "client.type";
    protected final boolean client;
    protected final boolean httpSSLEnabled;
    protected final boolean transportSSLEnabled;
    protected final boolean extendedKeyUsageEnabled;
    protected final Settings settings;
    protected volatile SecurityRestFilter securityRestHandler;
    protected final SharedGroupFactory sharedGroupFactory;
    protected final SslSettingsManager sslSettingsManager;
    protected PrincipalExtractor principalExtractor;
    protected final Path configPath;
    private static final SslExceptionHandler NOOP_SSL_EXCEPTION_HANDLER = new SslExceptionHandler(){};
    protected final SSLConfig SSLConfig;
    protected volatile ThreadPool threadPool;

    protected OpenSearchSecuritySSLPlugin(Settings settings, Path configPath, boolean disabled) {
        SecurityManager sm;
        if (disabled) {
            this.settings = null;
            this.sharedGroupFactory = null;
            this.client = false;
            this.httpSSLEnabled = false;
            this.transportSSLEnabled = false;
            this.extendedKeyUsageEnabled = false;
            this.sslSettingsManager = null;
            this.configPath = null;
            this.SSLConfig = new SSLConfig(false, false);
            AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                    return null;
                }
            });
            return;
        }
        this.SSLConfig = new SSLConfig(settings);
        this.configPath = configPath;
        if (this.configPath != null) {
            this.log.info("OpenSearch Config path is {}", (Object)this.configPath.toAbsolutePath());
        } else {
            this.log.info("OpenSearch Config path is not set");
        }
        boolean allowClientInitiatedRenegotiation = settings.getAsBoolean("plugins.security.ssl.allow_client_initiated_renegotiation", Boolean.valueOf(false));
        boolean rejectClientInitiatedRenegotiation = Boolean.parseBoolean(System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation"));
        if (allowClientInitiatedRenegotiation && !rejectClientInitiatedRenegotiation) {
            String renegoMsg = "Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.";
            this.log.warn("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
        } else if (!rejectClientInitiatedRenegotiation) {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
                    return null;
                }
            });
            this.log.debug("Client side initiated TLS renegotiation forcibly disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation set to true).");
        } else {
            this.log.debug("Client side initiated TLS renegotiation already disabled.");
        }
        sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(this){

            @Override
            public Object run() {
                System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.sharedGroupFactory = new SharedGroupFactory(settings);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(Settings.class, (Object)settings);
        DefaultObjectMapper.inject(injectableValues);
        NonValidatingObjectMapper.inject(injectableValues);
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("plugins.security.ssl.transport.enabled", Boolean.valueOf(true));
        this.extendedKeyUsageEnabled = settings.getAsBoolean("plugins.security.ssl.transport.extended_key_usage_enabled", Boolean.valueOf(false));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.");
        }
        this.sslSettingsManager = new SslSettingsManager(new Environment(settings, configPath));
    }

    public Map<String, Supplier<HttpServerTransport>> getSecureHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        if (!this.client && this.httpSSLEnabled) {
            ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, NOOP_SSL_EXCEPTION_HANDLER);
            SecureNetty4HttpServerTransport sgsnht = new SecureNetty4HttpServerTransport(this.migrateSettings(settings), networkService, bigArrays, threadPool, xContentRegistry, (HttpServerTransport.Dispatcher)validatingDispatcher, clusterSettings, this.sharedGroupFactory, secureHttpTransportSettingsProvider, tracer);
            return Collections.singletonMap("org.opensearch.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport", () -> sgsnht);
        }
        return Collections.emptyMap();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client) {
            handlers.add((RestHandler)new SecuritySSLInfoAction(settings, this.configPath, this.sslSettingsManager, Objects.requireNonNull(this.principalExtractor)));
        }
        return handlers;
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (this.transportSSLEnabled && !this.client) {
            interceptors.add(new SecuritySSLTransportInterceptor(this.settings, null, null, this.SSLConfig, NOOP_SSL_EXCEPTION_HANDLER));
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getSecureTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.transportSSLEnabled) {
            transports.put("org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport", () -> new SecureNetty4Transport(this.migrateSettings(settings), Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sharedGroupFactory, secureTransportSettingsProvider, tracer));
        }
        return transports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.threadPool = threadPool;
        ArrayList<Object> components = new ArrayList<Object>(1);
        if (this.client) {
            return components;
        }
        String principalExtractorClass = this.settings.get("plugins.security.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to", (Object)principalExtractorClass, (Object)e);
                throw new OpenSearchException((Throwable)e);
            }
        }
        components.add(this.principalExtractor);
        return components;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SecureSSLSettings.getSecureSettings());
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (!settings.stream().anyMatch(s -> s.getKey().equalsIgnoreCase("transport.ssl.enforce_hostname_verification"))) {
            settings.add(SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION);
        }
        if (!settings.stream().anyMatch(s -> s.getKey().equalsIgnoreCase("transport.ssl.resolve_hostname"))) {
            settings.add(SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME);
        }
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.extended_key_usage_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (this.extendedKeyUsageEnabled) {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        } else {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"plugins.security.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enforce_cert_reload_dn_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enforce_cert_reload_dn_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.addAll(List.of(SSLConfigConstants.SECURITY_SSL_AUX_ENABLED, SSLConfigConstants.SECURITY_SSL_AUX_ENABLED_CIPHERS, SSLConfigConstants.SECURITY_SSL_AUX_ENABLED_PROTOCOLS, SSLConfigConstants.SECURITY_SSL_AUX_KEYSTORE_FILEPATH, SSLConfigConstants.SECURITY_SSL_AUX_PEMKEY_FILEPATH, SSLConfigConstants.SECURITY_SSL_AUX_PEMKEY_PASSWORD, SSLConfigConstants.SECURITY_SSL_AUX_PEMCERT_FILEPATH, SSLConfigConstants.SECURITY_SSL_AUX_CLIENTAUTH_MODE, SSLConfigConstants.SECURITY_SSL_AUX_TRUSTSTORE_FILEPATH, SSLConfigConstants.SECURITY_SSL_AUX_PEMTRUSTEDCAS_FILEPATH));
        return settings;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        if (!this.client && this.httpSSLEnabled) {
            if (this.settings.get("http.compression") == null) {
                builder.put("http.compression", false);
                this.log.info("Disabled https compression by default to mitigate BREACH attacks. You can enable it by setting 'http.compression: true' in opensearch.yml");
            }
            builder.put("http.type", "org.opensearch.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport");
        }
        if (this.transportSSLEnabled) {
            builder.put("transport.type", "org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport");
        }
        return builder.build();
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        settingsFilter.add("opendistro_security.*");
        settingsFilter.add("plugins.security.*");
        return settingsFilter;
    }

    public Optional<SecureSettingsFactory> getSecureSettingFactory(Settings settings) {
        return Optional.of(new OpenSearchSecureSettingsFactory(this.threadPool, this.sslSettingsManager, NOOP_SSL_EXCEPTION_HANDLER, this.securityRestHandler, this.SSLConfig));
    }

    protected Settings migrateSettings(Settings settings) {
        Settings.Builder builder = Settings.builder().put(settings);
        if (!NetworkModule.TRANSPORT_SSL_DUAL_MODE_ENABLED.exists(settings)) {
            builder.put("transport.ssl.dual_mode.enabled", ((Boolean)SecuritySettings.SSL_DUAL_MODE_SETTING.get(settings)).booleanValue());
        } else if (SecuritySettings.SSL_DUAL_MODE_SETTING.exists(settings)) {
            throw new OpenSearchException("Only one of the settings [transport.ssl.dual_mode.enabled, " + SecuritySettings.SSL_DUAL_MODE_SETTING.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        if (!NetworkModule.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.exists(settings)) {
            builder.put("transport.ssl.resolve_hostname", ((Boolean)SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.get(settings)).booleanValue());
        } else if (SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.exists(settings)) {
            throw new OpenSearchException("Only one of the settings [transport.ssl.resolve_hostname, " + SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        if (!NetworkModule.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION.exists(settings)) {
            builder.put("transport.ssl.enforce_hostname_verification", ((Boolean)SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.get(settings)).booleanValue());
        } else if (SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.exists(settings)) {
            throw new OpenSearchException("Only one of the settings [transport.ssl.enforce_hostname_verification, " + SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        return builder.build();
    }
}

