/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemorySearchResult;

public class MLSearchMemoriesResponse
extends ActionResponse
implements ToXContentObject {
    private List<MemorySearchResult> hits;
    private long totalHits;
    private float maxScore;
    private boolean timedOut;

    public MLSearchMemoriesResponse(List<MemorySearchResult> hits, long totalHits, float maxScore, boolean timedOut) {
        this.hits = hits != null ? hits : new ArrayList();
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.timedOut = timedOut;
    }

    public MLSearchMemoriesResponse(StreamInput in) throws IOException {
        super(in);
        int hitCount = in.readVInt();
        this.hits = new ArrayList<MemorySearchResult>(hitCount);
        for (int i = 0; i < hitCount; ++i) {
            this.hits.add(new MemorySearchResult(in));
        }
        this.totalHits = in.readVLong();
        this.maxScore = in.readFloat();
        this.timedOut = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.hits.size());
        for (MemorySearchResult hit : this.hits) {
            hit.writeTo(out);
        }
        out.writeVLong(this.totalHits);
        out.writeFloat(this.maxScore);
        out.writeBoolean(this.timedOut);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("timed_out", this.timedOut);
        builder.startObject("hits");
        builder.field("total", this.totalHits);
        builder.field("max_score", this.maxScore);
        builder.startArray("hits");
        for (MemorySearchResult hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLSearchMemoriesResponseBuilder builder() {
        return new MLSearchMemoriesResponseBuilder();
    }

    @Generated
    public List<MemorySearchResult> getHits() {
        return this.hits;
    }

    @Generated
    public long getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public float getMaxScore() {
        return this.maxScore;
    }

    @Generated
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Generated
    public static class MLSearchMemoriesResponseBuilder {
        @Generated
        private List<MemorySearchResult> hits;
        @Generated
        private long totalHits;
        @Generated
        private float maxScore;
        @Generated
        private boolean timedOut;

        @Generated
        MLSearchMemoriesResponseBuilder() {
        }

        @Generated
        public MLSearchMemoriesResponseBuilder hits(List<MemorySearchResult> hits) {
            this.hits = hits;
            return this;
        }

        @Generated
        public MLSearchMemoriesResponseBuilder totalHits(long totalHits) {
            this.totalHits = totalHits;
            return this;
        }

        @Generated
        public MLSearchMemoriesResponseBuilder maxScore(float maxScore) {
            this.maxScore = maxScore;
            return this;
        }

        @Generated
        public MLSearchMemoriesResponseBuilder timedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        @Generated
        public MLSearchMemoriesResponse build() {
            return new MLSearchMemoriesResponse(this.hits, this.totalHits, this.maxScore, this.timedOut);
        }

        @Generated
        public String toString() {
            return "MLSearchMemoriesResponse.MLSearchMemoriesResponseBuilder(hits=" + String.valueOf(this.hits) + ", totalHits=" + this.totalHits + ", maxScore=" + this.maxScore + ", timedOut=" + this.timedOut + ")";
        }
    }
}

