/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data;

import com.projectlibre1.association.AssociationList;
import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.company.UserUtil;
import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.field.FieldValues;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.grouping.core.VoidNodeImpl;
import com.projectlibre1.grouping.core.model.DefaultNodeModel;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.DependencyService;
import com.projectlibre1.pm.key.HasId;
import com.projectlibre1.pm.key.HasKey;
import com.projectlibre1.pm.key.uniqueid.UniqueIdException;
import com.projectlibre1.pm.resource.EnterpriseResource;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.resource.ResourcePoolFactory;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.server.access.ErrorLogger;
import com.projectlibre1.server.data.AssignmentData;
import com.projectlibre1.server.data.CommonDataObject;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.server.data.DistributionComparator;
import com.projectlibre1.server.data.DistributionConverter;
import com.projectlibre1.server.data.DistributionData;
import com.projectlibre1.server.data.DocumentData;
import com.projectlibre1.server.data.EnterpriseResourceData;
import com.projectlibre1.server.data.LinkData;
import com.projectlibre1.server.data.ProjectData;
import com.projectlibre1.server.data.ResourceData;
import com.projectlibre1.server.data.SerializeOptions;
import com.projectlibre1.server.data.SerializeUtil;
import com.projectlibre1.server.data.SerializedDataObject;
import com.projectlibre1.server.data.SerializedDataObjectFactory;
import com.projectlibre1.server.data.TaskData;
import com.projectlibre1.server.data.linker.Linker;
import com.projectlibre1.server.data.linker.ResourceLinker;
import com.projectlibre1.server.data.linker.TaskLinker;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.DataFactoryUndoController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class Serializer {
    public static final boolean TMP_FILES = false;
    protected Linker resourceLinker = new ResourceLinker(){

        @Override
        public Object addTransformedObjects(Object object) throws IOException, UniqueIdException {
            EnterpriseResourceData enterpriseResourceData;
            Project project = (Project)this.parent;
            ResourceImpl resourceImpl = (ResourceImpl)object;
            ResourceData resourceData = new ResourceData();
            resourceData.setUniqueId(resourceImpl.getUniqueId());
            resourceData.setRole(resourceImpl.getRole());
            if (resourceImpl.isDefault()) {
                return null;
            }
            if (project.isMaster()) {
                enterpriseResourceData = (EnterpriseResourceData)Serializer.this.serialize(resourceImpl.getGlobalResource(), EnterpriseResourceData.FACTORY, null);
            } else {
                enterpriseResourceData = new EnterpriseResourceData();
                enterpriseResourceData.setUniqueId(resourceImpl.getGlobalResource().getUniqueId());
            }
            String string = resourceImpl.getGlobalResource().getEmailAddress();
            enterpriseResourceData.setEmailAddress(string == null || string.length() == 0 ? null : string);
            resourceData.setEnterpriseResource(enterpriseResourceData);
            this.transformationMap.put(new Long(resourceImpl.getUniqueId()), resourceData);
            return resourceData;
        }

        @Override
        public void executeFinally() {
            ((ProjectData)this.getTransformedParent()).setResources(this.transformed);
        }

        @Override
        public boolean addOutlineElement(Object object, Object object2, long l) {
            if (object instanceof VoidNodeImpl) {
                return false;
            }
            ResourceData resourceData = (ResourceData)this.getTransformationMap().get(new Long(((Resource)object).getUniqueId()));
            ResourceData resourceData2 = object2 == null ? null : (ResourceData)this.getTransformationMap().get(new Long(((Resource)object2).getUniqueId()));
            EnterpriseResourceData enterpriseResourceData = resourceData.getEnterpriseResource();
            enterpriseResourceData.setParentResource(resourceData2 == null ? null : resourceData2.getEnterpriseResource());
            enterpriseResourceData.setChildPosition(l);
            return true;
        }
    };
    protected TaskLinker taskLinker = new TaskLinker(){

        @Override
        public Object addTransformedObjects(Object object) throws IOException, UniqueIdException {
            Collection collection;
            TaskData taskData;
            boolean bl;
            NormalTask normalTask = (NormalTask)object;
            Project project = (Project)this.getParent();
            if (normalTask.getOwningProject() != project || normalTask.isExternal()) {
                return null;
            }
            final Map map = (Map)this.args[0];
            boolean bl2 = bl = !this.incremental || normalTask.isDirty();
            if (bl) {
                taskData = (TaskData)Serializer.this.serialize(normalTask, TaskData.FACTORY, null);
                taskData.setNotes(normalTask.getNotes());
            } else {
                taskData = new TaskData();
                taskData.setUniqueId(normalTask.getUniqueId());
            }
            taskData.setStatus(bl ? 1 : 0);
            taskData.setProjectId(normalTask.getProjectId());
            if (normalTask.isSubproject()) {
                taskData.setSubprojectId(((SubProj)((Object)normalTask)).getSubprojectUniqueId());
            }
            Collection collection2 = collection = this.flatAssignments == null ? new ArrayList() : this.flatAssignments;
            if (bl) {
                Serializer.forAssignments(normalTask, new AssignmentClosure(){

                    @Override
                    public void execute(Assignment assignment, int n) {
                        try {
                            EnterpriseResourceData enterpriseResourceData;
                            ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                            AssignmentData assignmentData = (AssignmentData)Serializer.this.serialize(assignment, AssignmentData.FACTORY, null);
                            assignmentData.setStatus(1);
                            if (flatAssignments == null) {
                                assignmentData.setTask(taskData);
                            } else {
                                assignmentData.setTaskId(taskData.getUniqueId());
                            }
                            EnterpriseResourceData enterpriseResourceData2 = enterpriseResourceData = resourceImpl.isDefault() ? null : ((ResourceData)map.get(new Long(resourceImpl.getUniqueId()))).getEnterpriseResource();
                            if (flatAssignments == null) {
                                assignmentData.setResource(enterpriseResourceData);
                            } else {
                                assignmentData.setResourceId(enterpriseResourceData == null ? -1L : enterpriseResourceData.getUniqueId());
                            }
                            assignmentData.setSnapshotId(n);
                            assignmentData.setCachedStart(new Date(assignment.getStart()));
                            assignmentData.setCachedEnd(new Date(assignment.getEnd()));
                            assignmentData.setTimesheetStatus(assignment.getTimesheetStatus());
                            assignmentData.setLastTimesheetUpdate(new Date(assignment.getLastTimesheetUpdate()));
                            assignmentData.setWorkflowState(assignment.getWorkflowState());
                            assignmentData.setPercentComplete(assignment.getPercentComplete());
                            assignmentData.setDuration(assignment.getDuration());
                            collection.add(assignmentData);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
            }
            if (this.flatAssignments == null) {
                taskData.setAssignments(collection);
            }
            this.transformationMap.put(normalTask, taskData);
            return taskData;
        }

        @Override
        public void executeFinally() {
            ((ProjectData)this.getTransformedParent()).setTasks(this.transformed);
        }

        @Override
        public boolean addOutlineElement(Object object, Object object2, long l) {
            TaskData taskData;
            TaskData taskData2 = (TaskData)this.getTransformationMap().get(object);
            if (object instanceof VoidNodeImpl) {
                taskData2 = new TaskData();
                ((ProjectData)this.getTransformedParent()).getTasks().add(taskData2);
            }
            if (taskData2 == null) {
                return false;
            }
            TaskData taskData3 = taskData = object2 == null ? null : (TaskData)this.getTransformationMap().get(object2);
            if (taskData != null && taskData.isSubproject()) {
                taskData = null;
            }
            taskData2.setParentTask(taskData);
            taskData2.setChildPosition(l);
            if (object instanceof Task) {
                long l2;
                Task task = (Task)object;
                long l3 = l2 = taskData == null ? -1L : taskData.getUniqueId();
                if (l2 != task.getLastSavedParentId() || l != task.getLastSavedPosistion()) {
                    taskData2.setMoved(true);
                }
            }
            return true;
        }
    };
    protected File tmpDir = null;

    public Map saveResources(Project project, ProjectData projectData) throws Exception {
        this.resourceLinker.setParent(project);
        this.resourceLinker.setTransformedParent(projectData);
        this.resourceLinker.init();
        this.resourceLinker.addTransformedObjects();
        this.resourceLinker.addOutline(null);
        return this.resourceLinker.getTransformationMap();
    }

    public static void forAssignments(NormalTask normalTask, AssignmentClosure assignmentClosure) throws IOException {
        for (int i = 0; i < Settings.numBaselines(); ++i) {
            AssociationList associationList;
            TaskSnapshot taskSnapshot = (TaskSnapshot)normalTask.getSnapshot(new Integer(i));
            if (taskSnapshot == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
            Iterator iterator = associationList.iterator();
            while (iterator.hasNext()) {
                assignmentClosure.execute((Assignment)iterator.next(), i);
            }
        }
    }

    private void markAncestorsOfDirtyTasksDirty(Project project) {
        for (Object e : project.getTasks()) {
            Task task = (Task)e;
            if (!task.isDirty()) continue;
            for (Task task2 = task.getWbsParentTask(); task2 != null && !task2.isDirty(); task2 = task2.getWbsParentTask()) {
                task2.setDirty(true);
            }
        }
    }

    protected void saveTasks(Project project, ProjectData projectData, Map map, Collection collection, Collection collection2, boolean bl, SerializeOptions serializeOptions) throws Exception {
        Iterator iterator;
        TaskData taskData;
        Object object;
        ArrayList<Long> arrayList = null;
        ArrayList<Long> arrayList2 = null;
        if (bl) {
            arrayList = new ArrayList<Long>();
            arrayList2 = new ArrayList<Long>();
        }
        this.markAncestorsOfDirtyTasksDirty(project);
        this.taskLinker.setIncremental(bl);
        this.taskLinker.setFlatAssignments(collection);
        this.taskLinker.setParent(project);
        this.taskLinker.setTransformedParent(projectData);
        this.taskLinker.setArgs(new Object[]{map});
        this.taskLinker.init();
        this.taskLinker.setOptions(serializeOptions);
        this.taskLinker.addTransformedObjects();
        this.taskLinker.addOutline(project.getTaskOutlineRoot());
        long l = project.getUniqueId();
        Object object2 = project.getTaskOutlineIterator();
        while (object2.hasNext()) {
            object = (NormalTask)object2.next();
            if (((Task)object).getProjectId() != l || ((Task)object).isExternal() || (taskData = (TaskData)this.taskLinker.getTransformationMap().get(object)) == null || !(iterator = ((Task)object).getPredecessorList().iterator()).hasNext()) continue;
            ArrayList<LinkData> arrayList3 = new ArrayList<LinkData>();
            while (iterator.hasNext()) {
                boolean bl2;
                Dependency dependency = (Dependency)iterator.next();
                boolean bl3 = bl2 = !bl || dependency.isDirty();
                if (!bl2) {
                    arrayList2.add(dependency.getPredecessorId());
                    arrayList2.add(dependency.getSuccessorId());
                    continue;
                }
                LinkData linkData = (LinkData)this.serialize(dependency, LinkData.FACTORY, null);
                linkData.setDirty(dependency.isDirty());
                if (collection2 == null) {
                    linkData.setSuccessor(taskData);
                } else {
                    linkData.setSuccessorId(taskData.getUniqueId());
                }
                Task task = (Task)dependency.getPredecessor();
                TaskData taskData2 = (TaskData)this.taskLinker.getTransformationMap().get(task);
                if (collection2 == null) {
                    if (taskData2 != null && !taskData2.isExternal()) {
                        linkData.setPredecessor(taskData2);
                    } else {
                        linkData.setPredecessorId(task.getUniqueId());
                    }
                    arrayList3.add(linkData);
                    continue;
                }
                linkData.setPredecessorId(task.getUniqueId());
                collection2.add(linkData);
            }
            if (collection2 != null) continue;
            taskData.setPredecessors(arrayList3);
        }
        if (bl) {
            object2 = projectData.getTasks();
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    taskData = (TaskData)object.next();
                    if (taskData.isDirty() || taskData.isMoved()) continue;
                    arrayList.add(taskData.getUniqueId());
                    object.remove();
                }
            }
            if (arrayList.size() > 0) {
                object = new long[arrayList.size()];
                int n = 0;
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    object[n++] = l2;
                }
                projectData.setUnchangedTasks((long[])object);
            }
            if (arrayList2.size() > 0) {
                object = new long[arrayList2.size()];
                int n = 0;
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    long l3 = (Long)iterator.next();
                    object[n++] = l3;
                }
                projectData.setUnchangedLinks((long[])object);
            }
        }
    }

    public DocumentData serializeDocument(Project project) throws Exception {
        return this.serializeProject(project, null, null, false, null);
    }

    public ProjectData serializeProject(Project project) throws Exception {
        return this.serializeProject(project, null, null, false, null);
    }

    public ProjectData serializeProject(Project project, Collection collection, Collection collection2, boolean bl, SerializeOptions serializeOptions) throws Exception {
        Object object;
        Object object2;
        if (project.isForceNonIncremental()) {
            bl = false;
        }
        boolean bl2 = bl && !project.isForceNonIncrementalDistributions();
        Count count = new Count("Project");
        ProjectData projectData = (ProjectData)this.serialize(project, ProjectData.FACTORY, count);
        if (project.isForceNonIncremental()) {
            projectData.setVersion(0.0f);
        }
        projectData.setMaster(project.isMaster());
        count.dump();
        Map map = this.saveResources(project, projectData);
        this.saveTasks(project, projectData, map, collection, collection2, bl, serializeOptions);
        long l = System.currentTimeMillis();
        ArrayList<DistributionData> arrayList = new DistributionConverter().createDistributionData(project, bl2);
        if (arrayList == null) {
            arrayList = new ArrayList<DistributionData>();
        }
        projectData.setDistributions(arrayList);
        projectData.setIncrementalDistributions(bl2);
        TreeMap<DistributionData, DistributionData> treeMap = project.getDistributionMap();
        if (treeMap == null) {
            treeMap = new TreeMap(new DistributionComparator());
            project.setDistributionMap(treeMap);
        }
        TreeMap<DistributionData, DistributionData> treeMap2 = new TreeMap<DistributionData, DistributionData>(new DistributionComparator());
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (DistributionData)object3.next();
            if (bl2) {
                object = treeMap.get(object2);
                if (object == null) {
                    ((DistributionData)object2).setStatus(4);
                } else if (((DistributionData)object).getWork() == ((DistributionData)object2).getWork() && ((DistributionData)object).getCost() == ((DistributionData)object2).getCost()) {
                    ((DistributionData)object2).setStatus(0);
                    object3.remove();
                } else {
                    ((DistributionData)object2).setStatus(1);
                }
            } else {
                ((DistributionData)object2).setStatus(4);
            }
            treeMap2.put((DistributionData)object2, (DistributionData)object2);
        }
        if (bl2 && treeMap.size() > 0) {
            object3 = new HashSet();
            object = project.getTaskOutlineIterator();
            while (object.hasNext()) {
                object2 = (Task)object.next();
                if (!bl || ((Task)object2).isDirty()) continue;
                object3.add(((Task)object2).getUniqueId());
            }
            for (DistributionData distributionData : treeMap.values()) {
                if (treeMap2.containsKey(distributionData)) continue;
                if (object3.contains(distributionData.getTaskId())) {
                    distributionData.setStatus(0);
                    treeMap2.put(distributionData, distributionData);
                    continue;
                }
                distributionData.setStatus(8);
                arrayList.add(distributionData);
            }
        }
        project.setNewDistributionMap(treeMap2);
        System.out.println("Distributions generated in " + (System.currentTimeMillis() - l) + " ms");
        object3 = FieldValues.getValues(FieldDictionary.getInstance().getProjectFields(), project);
        if (project.getContainingSubprojectTask() != null) {
            object2 = Configuration.getFieldFromId("Field.duration").getValue(project.getContainingSubprojectTask(), null);
            ((HashMap)object3).put("Field.duration", object2);
        }
        projectData.setFieldValues((Map)object3);
        projectData.setGroup(project.getGroup());
        projectData.setDivision(project.getDivision());
        projectData.setExpenseType(project.getExpenseType());
        projectData.setProjectType(project.getProjectType());
        projectData.setProjectStatus(project.getProjectStatus());
        projectData.setExtraFields(project.getExtraFields());
        projectData.setAccessControlPolicy(project.getAccessControlPolicy());
        projectData.setCreationDate(project.getCreationDate());
        projectData.setLastModificationDate(project.getLastModificationDate());
        return projectData;
    }

    public Project deserializeLocalDocument(DocumentData documentData) throws IOException, ClassNotFoundException {
        return this.deserializeProject((ProjectData)documentData, false, SessionFactory.getInstance().getLocalSession(), null, null);
    }

    public Project deserializeProject(ProjectData projectData, boolean bl, Session session, Map map) throws IOException, ClassNotFoundException {
        return this.deserializeProject(projectData, bl, session, map, null, true);
    }

    public Project deserializeProject(ProjectData projectData, boolean bl, Session session, Map map, Closure closure) throws IOException, ClassNotFoundException {
        return this.deserializeProject(projectData, bl, session, map, closure, true);
    }

    public Project deserializeProject(ProjectData projectData, boolean bl, Session session, Map map, Closure closure, boolean bl2) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object32;
        Iterator iterator;
        Serializable serializable;
        Object object42;
        Serializable serializable22;
        Object object5;
        Object object6;
        DataObject dataObject;
        Serializable serializable32;
        DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
        Project project = (Project)Serializer.deserialize(projectData, session);
        project.setUndoController(dataFactoryUndoController);
        project.setMaster(projectData.isMaster());
        project.setLocal(projectData.isLocal());
        project.setReadOnly(!projectData.canBeUsed());
        project.setCreationDate(projectData.getCreationDate());
        project.setLastModificationDate(projectData.getLastModificationDate());
        boolean bl3 = false;
        WorkCalendar workCalendar = project.getWorkCalendar();
        if (workCalendar == null) {
            workCalendar = CalendarService.getInstance().getDefaultInstance();
        }
        project.setWorkCalendar(workCalendar);
        project.setExtraFields(projectData.getExtraFields());
        project.setGroup(projectData.getGroup());
        project.setDivision(projectData.getDivision());
        project.setExpenseType(projectData.getExpenseType());
        project.setProjectType(projectData.getProjectType());
        project.setProjectStatus(projectData.getProjectStatus());
        project.setAccessControlPolicy(projectData.getAccessControlPolicy());
        project.postDeserialization();
        final HashMap<EnterpriseResourceData, Node> hashMap = new HashMap<EnterpriseResourceData, Node>();
        ResourcePool resourcePool = ResourcePoolFactory.getInstance().createResourcePool(project.getName(), dataFactoryUndoController);
        resourcePool.setMaster(project.isMaster());
        resourcePool.setLocal(project.isLocal());
        resourcePool.updateOutlineTypes();
        Collection collection = projectData.getResources();
        if (collection != null) {
            Collections.sort((List)collection, new Comparator<ResourceData>(){

                @Override
                public int compare(ResourceData resourceData, ResourceData resourceData2) {
                    if (resourceData.getChildPosition() > resourceData2.getChildPosition()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        if (collection != null) {
            for (Serializable serializable32 : collection) {
                dataObject = Serializer.deserializeResourceAndAddToPool((ResourceData)serializable32, resourcePool, session, map);
                hashMap.put(((ResourceData)serializable32).getEnterpriseResource(), NodeFactory.getInstance().createNode(dataObject));
            }
        }
        project.setResourcePool(resourcePool);
        if (collection != null) {
            for (Serializable serializable32 : collection) {
                dataObject = ((ResourceData)serializable32).getEnterpriseResource();
                EnterpriseResourceData enterpriseResourceData = ((EnterpriseResourceData)dataObject).getParentResource();
                object6 = (Node)hashMap.get(dataObject);
                object5 = enterpriseResourceData == null ? null : (Node)hashMap.get(enterpriseResourceData);
                project.getResourcePool().addToDefaultOutline((Node)object5, (Node)object6, (int)((EnterpriseResourceData)dataObject).getChildPosition(), false);
                ((ResourceImpl)object6.getImpl()).getGlobalResource().setResourcePool(project.getResourcePool());
            }
            project.getResourcePool().getResourceOutline().getHierarchy().cleanVoidChildren();
            project.getResourcePool().getResourceOutline().getHierarchy().visitAll(new Closure(){
                int id = 1;

                @Override
                public void execute(Object object) {
                    HasId hasId;
                    Node node = (Node)object;
                    if (node.getImpl() instanceof HasId && (hasId = (HasId)node.getImpl()).getId() > 0L) {
                        hasId.setId(this.id++);
                    }
                }
            });
        }
        if (closure != null) {
            closure.execute(project);
            hashMap.clear();
            project.getResourcePool().getResourceOutline().getHierarchy().visitAll(new Closure(){

                @Override
                public void execute(Object object) {
                    Node node = (Node)object;
                    HasKey hasKey = (HasKey)node.getImpl();
                    hashMap.put(hasKey.getUniqueId(), node);
                }
            });
        }
        Collection collection2 = projectData.getTasks();
        serializable32 = new HashMap();
        long l = project.getUniqueId();
        if (collection2 != null) {
            UpdatesFromTimesheet updatesFromTimesheet;
            Collections.sort((List)collection2, new Comparator<TaskData>(){

                @Override
                public int compare(TaskData taskData, TaskData taskData2) {
                    if (!taskData.isExternal() && taskData2.isExternal()) {
                        return -1;
                    }
                    if (taskData.isExternal() && !taskData2.isExternal()) {
                        return 1;
                    }
                    if (taskData.getChildPosition() > taskData2.getChildPosition()) {
                        return 1;
                    }
                    if (taskData.getChildPosition() < taskData2.getChildPosition()) {
                        return -1;
                    }
                    return 0;
                }
            });
            object5 = collection2.iterator();
            while (object5.hasNext()) {
                object6 = null;
                serializable22 = (TaskData)object5.next();
                if (((SerializedDataObject)serializable22).isDirty()) {
                    bl3 = true;
                }
                if (((SerializedDataObject)serializable22).getSerialized() == null) {
                    if (!((TaskData)serializable22).isTimesheetCreated()) continue;
                    object6 = new NormalTask(project);
                    ((Task)object6).setName(((SerializedDataObject)serializable22).getName());
                    System.out.println("made new task in serializer " + object6 + " parent " + ((TaskData)serializable22).getParentTask().getName());
                } else {
                    try {
                        object6 = (NormalTask)Serializer.deserialize(serializable22, session);
                    }
                    catch (Exception exception) {
                        if (((TaskData)serializable22).isSubproject()) {
                            try {
                                object6 = (NormalTask)Class.forName(Messages.getMetaString("Subproject")).getConstructor(Project.class, Long.class).newInstance(project, ((TaskData)serializable22).getSubprojectId());
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                            ((Task)object6).setUniqueId(((SerializedDataObject)serializable22).getUniqueId());
                            ((Task)object6).setName(((SerializedDataObject)serializable22).getName());
                            ((SubProj)object6).setSubprojectFieldValues(((TaskData)serializable22).getSubprojectFieldValues());
                        }
                        exception.printStackTrace();
                        throw new IOException("Subproject:" + exception);
                    }
                }
                serializable32.put(serializable22, NodeFactory.getInstance().createNode(object6));
                ((Task)object6).setProject(project);
                project.initializeId((Task)object6);
                project.add((Task)object6);
                if (((TaskData)serializable22).isExternal()) {
                    ((Task)object6).setExternal(true);
                    ((Task)object6).setProjectId(((TaskData)serializable22).getProjectId());
                    ((Task)object6).setAllSchedulesToCurrentDates();
                    project.addExternalTask((Task)object6);
                } else {
                    ((Task)object6).setOwningProject(project);
                    ((Task)object6).setProjectId(l);
                }
                if (((TaskData)serializable22).isSubproject()) {
                    object42 = (SubProj)object6;
                    object42.setSubprojectUniqueId(((TaskData)serializable22).getSubprojectId());
                    object42.setSubprojectFieldValues(((TaskData)serializable22).getSubprojectFieldValues());
                    object42.setSchedulesFromSubprojectFieldValues();
                }
                if ((object42 = (WorkingCalendar)((NormalTask)object6).getWorkCalendar()) != null && (serializable = (WorkingCalendar)CalendarService.findBaseCalendar(((WorkingCalendar)object42).getName())) != null && serializable != object42) {
                    ((NormalTask)object6).setWorkCalendar((WorkCalendar)serializable);
                }
                serializable = new ArrayList();
                if (((TaskData)serializable22).getAssignments() != null) {
                    serializable.addAll(((TaskData)serializable22).getAssignments());
                }
                if (serializable.size() > 0) {
                    iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        object32 = iterator.next();
                        object2 = null;
                        object2 = (AssignmentData)object32;
                        if (((SerializedDataObject)object2).getSerialized() != null) continue;
                        System.out.println("==== no cached start found " + ((Task)object6).getName());
                        if (serializable.size() == 1) {
                            ((AssignmentData)object2).setResourceId(-1L);
                            continue;
                        }
                        iterator.remove();
                    }
                }
                if (serializable.size() <= 0) continue;
                iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    Object object7;
                    long l2;
                    object32 = iterator.next();
                    object2 = null;
                    updatesFromTimesheet = null;
                    boolean bl4 = true;
                    object2 = (AssignmentData)object32;
                    if (closure == null) {
                        EnterpriseResourceData enterpriseResourceData = ((AssignmentData)object2).getResource();
                        if (enterpriseResourceData == null) {
                            bl4 = false;
                        }
                        object = enterpriseResourceData == null ? ResourceImpl.getUnassignedInstance() : (Resource)((Node)hashMap.get(enterpriseResourceData)).getImpl();
                    } else {
                        l2 = ((AssignmentData)object2).getResourceId();
                        object7 = (Node)hashMap.get(l2);
                        Object object8 = object = object7 == null ? ResourceImpl.getUnassignedInstance() : (Resource)object7.getImpl();
                    }
                    if (((SerializedDataObject)object2).getSerialized() != null) {
                        try {
                            updatesFromTimesheet = (Assignment)Serializer.deserialize((DataObject)object2, session);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (((SerializedDataObject)object2).getSerialized() == null || ((SerializedDataObject)object2).getSerialized() != null && updatesFromTimesheet == null) {
                        updatesFromTimesheet = Assignment.getInstance((Task)object6, (Resource)object, 1.0, 0);
                        if (((Assignment)updatesFromTimesheet).getCachedStart() == null) {
                            System.out.println("==== no cached start found " + ((Task)object6).getName());
                        } else {
                            ((NormalTask)object6).setActualStart(((Assignment)updatesFromTimesheet).getCachedStart().getTime());
                            ((Task)object6).setActualFinish(((Assignment)updatesFromTimesheet).getCachedEnd().getTime());
                        }
                    }
                    ((Assignment)updatesFromTimesheet).setCachedStart(((AssignmentData)object2).getCachedStart());
                    ((Assignment)updatesFromTimesheet).setCachedEnd(((AssignmentData)object2).getCachedEnd());
                    ((Assignment)updatesFromTimesheet).setTimesheetStatus(((AssignmentData)object2).getTimesheetStatus());
                    l2 = ((AssignmentData)object2).getLastTimesheetUpdate() == null ? 0L : ((AssignmentData)object2).getLastTimesheetUpdate().getTime();
                    ((Assignment)updatesFromTimesheet).setLastTimesheetUpdate(l2);
                    ((Assignment)updatesFromTimesheet).setWorkflowState(((AssignmentData)object2).getWorkflowState());
                    int n = ((AssignmentData)object2).getSnapshotId();
                    ((Assignment)updatesFromTimesheet).getDetail().setTask((Task)object6);
                    ((Assignment)updatesFromTimesheet).getDetail().setResource((Resource)object);
                    object7 = new Integer(n);
                    TaskSnapshot taskSnapshot = (TaskSnapshot)((NormalTask)object6).getSnapshot(object7);
                    if (taskSnapshot == null) {
                        taskSnapshot = new TaskSnapshot();
                        taskSnapshot.setCurrentSchedule(((Task)object6).getCurrentSchedule());
                        ((NormalTask)object6).setSnapshot(object7, taskSnapshot);
                    }
                    if (Snapshottable.TIMESHEET.equals(object7)) {
                        ((Assignment)updatesFromTimesheet).setTimesheetAssignment(true);
                    }
                    taskSnapshot.addAssignment((Assignment)updatesFromTimesheet);
                    if (bl4 && Snapshottable.CURRENT.equals(object7)) {
                        object.addAssignment((Assignment)updatesFromTimesheet);
                    }
                    if (object2 == null) continue;
                    ((AssignmentData)object2).emtpy();
                }
            }
            object5 = projectData.getReferringSubprojectTasks();
            if (collection2 != null && object5 != null) {
                serializable22 = new ArrayList<Object>(object5.size());
                project.setReferringSubprojectTasks((Collection)((Object)serializable22));
                object42 = object5.iterator();
                while (object42.hasNext()) {
                    serializable = (TaskData)object42.next();
                    iterator = ((SerializedDataObject)serializable).getName();
                    object6 = null;
                    try {
                        object6 = (NormalTask)Serializer.deserialize((DataObject)serializable, session);
                    }
                    catch (Exception exception) {
                        if (((TaskData)serializable).isSubproject()) {
                            object6 = (NormalTask)((Object)project.getSubprojectHandler().createSubProj(((TaskData)serializable).getSubprojectId()));
                            ((Task)object6).setUniqueId(((SerializedDataObject)serializable).getUniqueId());
                            ((Task)object6).setName(((SerializedDataObject)serializable).getName());
                            ((SubProj)object6).setSubprojectFieldValues(((TaskData)serializable).getSubprojectFieldValues());
                        }
                        throw new IOException("Subproject:" + exception);
                    }
                    ((Task)object6).setName((String)((Object)iterator));
                    ((Task)object6).setProjectId(((TaskData)serializable).getProjectId());
                    serializable22.add(object6);
                }
            }
            for (Object object42 : projectData.getTasks()) {
                if (((TaskData)object42).getPredecessors() == null) continue;
                serializable = (Task)((Node)serializable32.get(object42)).getImpl();
                for (Object object32 : ((TaskData)object42).getPredecessors()) {
                    object2 = (Dependency)Serializer.deserialize((DataObject)object32, session);
                    if (((LinkData)object32).getPredecessor() == null) {
                        System.out.println("null pred - this shouldn't happen. skipping");
                        continue;
                    }
                    updatesFromTimesheet = (Task)((Node)serializable32.get(((LinkData)object32).getPredecessor())).getImpl();
                    Serializer.connectDependency((Dependency)object2, (Task)updatesFromTimesheet, (Task)serializable);
                    ((LinkData)object32).emtpy();
                }
            }
        }
        if (collection2 != null) {
            object5 = null;
            serializable22 = new HashMap();
            object42 = collection2.iterator();
            while (object42.hasNext()) {
                serializable = (TaskData)object42.next();
                iterator = ((TaskData)serializable).getParentTask();
                object32 = ((SerializedDataObject)serializable).getSerialized() == null && !((TaskData)serializable).isTimesheetCreated() ? NodeFactory.getInstance().createVoidNode() : (Node)serializable32.get(serializable);
                object2 = null;
                int n = -1;
                if (((TaskData)serializable).isExternal()) {
                    object = (Node)serializable22.get(((TaskData)serializable).getProjectId());
                    if (object != null) {
                        object2 = (Node)object.getParent();
                    }
                    if (object2 != null) {
                        n = object2.getIndex((TreeNode)object) + 1;
                        if (object2.isRoot()) {
                            object2 = null;
                        }
                    }
                }
                if (n == -1) {
                    object2 = iterator == null && object5 != null ? object5 : (iterator == null ? null : (Node)serializable32.get(iterator));
                    n = (int)((TaskData)serializable).getChildPosition();
                }
                if (((TaskData)serializable).isTimesheetCreated()) {
                    System.out.println("new task " + object32 + "parent node is " + object2);
                }
                if (object32.getImpl() instanceof SubProj) {
                    object = (SubProj)object32.getImpl();
                    serializable22.put(object.getSubprojectUniqueId(), object32);
                }
                project.addToDefaultOutline((Node)object2, (Node)object32, n, false);
                ((TaskData)serializable).emtpy();
            }
            project.getTaskOutline().getHierarchy().visitAll(new Closure(){
                int id = 1;

                @Override
                public void execute(Object object) {
                    HasId hasId;
                    Node node = (Node)object;
                    if (node.getImpl() instanceof HasId && (hasId = (HasId)node.getImpl()).getId() > 0L) {
                        hasId.setId(this.id++);
                    }
                }
            });
        }
        if (collection != null) {
            for (Serializable serializable22 : collection) {
                object42 = ((ResourceData)serializable22).getEnterpriseResource();
                ((ResourceData)serializable22).emtpy();
                ((EnterpriseResourceData)object42).emtpy();
            }
        }
        ((DefaultNodeModel)project.getTaskOutline()).setDataFactory(project);
        project.initialize(bl, bl2 && !bl3);
        projectData.emtpy();
        new DistributionConverter().substractDistributionFromProject(project);
        if (bl3) {
            project.setForceNonIncremental(true);
        }
        if ((double)project.getVersion() < 1.2) {
            project.setForceNonIncrementalDistributions(true);
        }
        project.setVersion(1.2f);
        return project;
    }

    public static void connectDependency(Dependency dependency, Task task, Task task2) {
        try {
            DependencyService.getInstance().initDependency(dependency, task, task2, null);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            dependency.setDisabled(true);
            try {
                DependencyService.getInstance().initDependency(dependency, task, task2, null);
            }
            catch (InvalidAssociationException invalidAssociationException2) {
                invalidAssociationException2.printStackTrace();
            }
            DependencyService.warnCircularCrossProjectLinkMessage(task, task2);
        }
    }

    public static ResourceImpl deserializeResourceAndAddToPool(EnterpriseResourceData enterpriseResourceData, ResourcePool resourcePool, Session session) throws IOException, ClassNotFoundException {
        ResourceData resourceData = new ResourceData();
        resourceData.setEnterpriseResource(enterpriseResourceData);
        ResourceImpl resourceImpl = Serializer.deserializeResourceAndAddToPool(resourceData, resourcePool, session, null);
        Serializer.setRoles(resourceImpl, resourceData);
        return resourceImpl;
    }

    public static ResourceImpl deserializeResourceAndAddToPool(ResourceData resourceData, ResourcePool resourcePool, Session session, Map map) throws IOException, ClassNotFoundException {
        DataObject dataObject;
        EnterpriseResource enterpriseResource;
        EnterpriseResourceData enterpriseResourceData = resourceData.getEnterpriseResource();
        if (map == null) {
            enterpriseResource = (EnterpriseResource)Serializer.deserialize(enterpriseResourceData, session);
            enterpriseResource.setUserAccount(enterpriseResourceData.getUserAccount());
        } else {
            dataObject = (EnterpriseResourceData)map.get(new Long(enterpriseResourceData.getUniqueId()));
            if (dataObject == null) {
                return null;
            }
            enterpriseResource = (EnterpriseResource)Serializer.deserialize(dataObject, session);
            enterpriseResource.setUserAccount(((EnterpriseResourceData)dataObject).getUserAccount());
        }
        enterpriseResource.setGlobalWorkVector(enterpriseResourceData.getGlobalWorkVector());
        enterpriseResource.setMaster(resourcePool.isMaster());
        dataObject = resourceData.getSerialized() == null ? Serializer.createResourceFromEnterpriseResource(enterpriseResource) : (ResourceImpl)Serializer.deserialize(resourceData, session);
        ((ResourceImpl)dataObject).setGlobalResource(enterpriseResource);
        Serializer.setRoles((ResourceImpl)dataObject, resourceData);
        WorkingCalendar workingCalendar = (WorkingCalendar)enterpriseResource.getWorkCalendar();
        if (workingCalendar == null) {
            enterpriseResource.setWorkCalendar(WorkingCalendar.getInstanceBasedOn(resourcePool.getDefaultCalendar()));
        } else {
            try {
                WorkCalendar workCalendar = CalendarService.findBaseCalendar(workingCalendar.getBaseCalendar().getName());
                if (workCalendar != null) {
                    workingCalendar.setBaseCalendar(workCalendar);
                }
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        resourcePool.initializeId(enterpriseResource);
        resourcePool.add((Resource)dataObject);
        return dataObject;
    }

    private static void setRoles(ResourceImpl resourceImpl, ResourceData resourceData) {
        resourceImpl.setRole(resourceData.getRole());
        int[] nArray = resourceData.getEnterpriseResource().getAuthorizedRoles();
        if (nArray != null) {
            EnterpriseResource enterpriseResource = resourceImpl.getGlobalResource();
            enterpriseResource.setDefaultRole(nArray.length > 0 ? nArray[0] : 0);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                hashSet.add(UserUtil.toExtendedRole(nArray[i], resourceImpl.isUser()));
            }
            enterpriseResource.setAuthorizedRoles(hashSet);
            enterpriseResource.setLicense(resourceData.getEnterpriseResource().getLicense());
            enterpriseResource.setLicenseOptions(resourceData.getEnterpriseResource().getLicenseOptions());
        }
    }

    private static ResourceImpl createResourceFromEnterpriseResource(EnterpriseResource enterpriseResource) {
        ResourceImpl resourceImpl = new ResourceImpl();
        return resourceImpl;
    }

    public static void setEnterpriseResources(Collection collection, ResourcePool resourcePool, Session session) throws IOException, ClassNotFoundException {
        if (collection != null) {
            DataObject dataObject;
            HashMap<EnterpriseResourceData, Node> hashMap = new HashMap<EnterpriseResourceData, Node>();
            for (EnterpriseResourceData enterpriseResourceData : collection) {
                dataObject = Serializer.deserializeResourceAndAddToPool(enterpriseResourceData, resourcePool, session);
                hashMap.put(enterpriseResourceData, NodeFactory.getInstance().createNode(dataObject));
            }
            for (EnterpriseResourceData enterpriseResourceData : collection) {
                dataObject = enterpriseResourceData.getParentResource();
                Node node = (Node)hashMap.get(enterpriseResourceData);
                Node node2 = dataObject == null ? null : (Node)hashMap.get(dataObject);
                resourcePool.addToDefaultOutline(node2, node, (int)enterpriseResourceData.getChildPosition(), false);
                ((ResourceImpl)node.getImpl()).getGlobalResource().setResourcePool(resourcePool);
            }
            resourcePool.getResourceOutline().getHierarchy().cleanVoidChildren();
        }
    }

    public static void forProjectDataDo(ProjectData projectData, Closure closure) {
        closure.execute(projectData);
        if (projectData.getCalendar() != null) {
            closure.execute(projectData.getCalendar());
        }
        for (SerializedDataObject serializedDataObject : projectData.getResources()) {
            closure.execute(serializedDataObject);
            closure.execute(((ResourceData)serializedDataObject).getEnterpriseResource());
        }
        for (SerializedDataObject serializedDataObject : projectData.getTasks()) {
            closure.execute(serializedDataObject);
            CollectionUtils.forAllDo(((TaskData)serializedDataObject).getAssignments(), closure);
            CollectionUtils.forAllDo(((TaskData)serializedDataObject).getPredecessors(), closure);
        }
    }

    public static void forProjectDataReversedDo(ProjectData projectData, Closure closure) {
        for (SerializedDataObject serializedDataObject : projectData.getTasks()) {
            CollectionUtils.forAllDo(((TaskData)serializedDataObject).getAssignments(), closure);
            CollectionUtils.forAllDo(((TaskData)serializedDataObject).getPredecessors(), closure);
            closure.execute(serializedDataObject);
        }
        for (SerializedDataObject serializedDataObject : projectData.getResources()) {
            closure.execute(((ResourceData)serializedDataObject).getEnterpriseResource());
            closure.execute(serializedDataObject);
        }
        if (projectData.getCalendar() != null) {
            closure.execute(projectData.getCalendar());
        }
        closure.execute(projectData);
    }

    public static void renumberProject(ProjectData projectData) {
        Serializer.forProjectDataDo(projectData, new IdClosure(){

            @Override
            public void execute(Object object) {
                ((CommonDataObject)object).setUniqueId(this.id++);
            }
        });
    }

    protected void initTmpDir() throws IOException {
        this.tmpDir = new File(System.getProperty("user.home"), "projectlibre_tmp");
        if (this.tmpDir.isDirectory()) {
            File[] fileArray = this.tmpDir.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i].delete();
                }
            }
        } else if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
    }

    protected void writeTmpFile(SerializedDataObject serializedDataObject, Count count) throws IOException {
        if (this.tmpDir != null && count != null) {
            try {
                File file = new File(this.tmpDir, serializedDataObject.getPrefix() + "_" + count.count);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (serializedDataObject.getSerialized() != null) {
                    fileOutputStream.write(serializedDataObject.getSerialized());
                }
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public DataObject serialize(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory, Count count) throws IOException {
        SerializedDataObject serializedDataObject = SerializeUtil.serialize(dataObject, serializedDataObjectFactory);
        byte[] byArray = serializedDataObject.getSerialized();
        if (count != null) {
            count.add(byArray == null ? 0 : byArray.length);
        }
        return serializedDataObject;
    }

    public static DataObject serializeSingle(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory, Count count) throws IOException {
        SerializedDataObject serializedDataObject = SerializeUtil.serialize(dataObject, serializedDataObjectFactory);
        byte[] byArray = serializedDataObject.getSerialized();
        if (count != null) {
            count.add(byArray == null ? 0 : byArray.length);
        }
        return serializedDataObject;
    }

    public static DataObject deserialize(DataObject dataObject, Session session) throws IOException, ClassNotFoundException {
        return SerializeUtil.deserialize((SerializedDataObject)dataObject, session);
    }

    protected Collection serialize(Collection collection, SerializedDataObjectFactory serializedDataObjectFactory) throws IOException {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<SerializedDataObject> arrayList = new ArrayList<SerializedDataObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SerializeUtil.serialize((DataObject)iterator.next(), serializedDataObjectFactory));
        }
        return arrayList;
    }

    protected Collection deserialize(Collection collection, Session session) throws IOException, ClassNotFoundException {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SerializeUtil.deserialize((SerializedDataObject)iterator.next(), session));
        }
        return arrayList;
    }

    public static void buildStructure(ProjectData projectData, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6, boolean bl) {
        if (collection5 != null) {
            collection2.addAll(collection5);
        }
        Map map = Serializer.createIdMap(collection);
        Map map2 = Serializer.createIdMap(collection2);
        Serializer.buildTaskStructure(projectData, collection2, map2);
        projectData.setTasks(collection2);
        projectData.setResources(collection);
        projectData.setReferringSubprojectTasks(collection6);
        Serializer.buildAssignmentsStructure(projectData, collection3, map, map2, bl);
        Serializer.buildLinksStructure(projectData, collection4, map2);
    }

    public static void buildTaskStructure(ProjectData projectData, Collection collection, Map map) {
        if (collection != null) {
            for (TaskData taskData : collection) {
                if (!(taskData.getParentTask() == null & taskData.getParentTaskId() != -1L)) continue;
                TaskData taskData2 = (TaskData)map.get(taskData.getParentTaskId());
                taskData.setParentTask(taskData2);
            }
        }
    }

    public static void buildAssignmentsStructure(ProjectData projectData, Collection collection) {
        Serializer.buildAssignmentsStructure(projectData, collection, null, null, false);
    }

    public static void buildAssignmentsStructure(ProjectData projectData, Collection collection, Map map, Map map2, boolean bl) {
        Map map3;
        Map map4 = map == null ? Serializer.createIdMap(projectData.getResources()) : map;
        Map map5 = map3 = map2 == null ? Serializer.createIdMap(projectData.getTasks()) : map2;
        if (collection != null) {
            for (AssignmentData assignmentData : collection) {
                TaskData taskData;
                ResourceData resourceData = (ResourceData)map4.get(new Long(assignmentData.getResourceId()));
                if (!bl) {
                    assignmentData.setResource(resourceData == null ? null : resourceData.getEnterpriseResource());
                }
                if ((taskData = (TaskData)map3.get(new Long(assignmentData.getTaskId()))) == null) {
                    ErrorLogger.logOnce("null task data", "null task data - project " + projectData.getName(), null);
                    continue;
                }
                taskData.addAssignment(assignmentData);
            }
        }
    }

    public static void buildLinksStructure(ProjectData projectData, Collection collection) {
        Serializer.buildLinksStructure(projectData, collection, null);
    }

    public static void buildLinksStructure(ProjectData projectData, Collection collection, Map map) {
        Map map2;
        Map map3 = map2 = map == null ? Serializer.createIdMap(projectData.getTasks()) : map;
        if (collection != null) {
            for (LinkData linkData : collection) {
                TaskData taskData = (TaskData)map2.get(new Long(linkData.getPredecessorId()));
                TaskData taskData2 = (TaskData)map2.get(new Long(linkData.getSuccessorId()));
                if (taskData == null || taskData2 == null) continue;
                taskData2.addPredecessor(linkData);
                linkData.setPredecessor(taskData);
            }
        }
    }

    public static Map createIdMap(Collection collection) {
        HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
        if (collection != null) {
            for (DataObject dataObject : collection) {
                hashMap.put(new Long(dataObject.getUniqueId()), dataObject);
            }
        }
        return hashMap;
    }

    public void printTaskDataHierarchy(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printTaskDataHierarchy(collection, stringBuffer);
        System.out.println(stringBuffer);
    }

    public void printTaskDataHierarchy(Collection collection, final StringBuffer stringBuffer) {
        HashMap<Long, TreeSet<TaskData>> hashMap = new HashMap<Long, TreeSet<TaskData>>();
        for (TaskData taskData : collection) {
            if (taskData == null) continue;
            Long l = new Long(taskData.getParentTaskId());
            TreeSet<TaskData> treeSet = (TreeSet<TaskData>)hashMap.get(l);
            if (treeSet == null) {
                treeSet = new TreeSet<TaskData>(new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        TaskData taskData = (TaskData)object;
                        TaskData taskData2 = (TaskData)object2;
                        int n2 = taskData.getChildPosition() < taskData2.getChildPosition() ? -1 : (n = taskData.getChildPosition() == taskData2.getChildPosition() ? 0 : 1);
                        if (n == 0) {
                            stringBuffer.append("Duplicates: task0=" + taskData.getName() + ", " + taskData.getParentTaskId() + ", " + taskData.getChildPosition() + " task1=" + taskData2.getName() + ", " + taskData2.getParentTaskId() + ", " + taskData2.getChildPosition() + "\n");
                        }
                        return n;
                    }
                });
            }
            treeSet.add(taskData);
            hashMap.put(l, treeSet);
        }
        this.buildTaskDataHierarchy(-1L, "\t", hashMap, stringBuffer);
    }

    private void buildTaskDataHierarchy(long l, String string, Map map, StringBuffer stringBuffer) {
        Object v = map.get(new Long(l));
        if (v == null) {
            return;
        }
        TreeSet treeSet = (TreeSet)((TreeSet)v).clone();
        for (TaskData taskData : treeSet) {
            stringBuffer.append(string).append(taskData.getName()).append(',').append(taskData.getUniqueId()).append('\n');
            if (taskData.getUniqueId() == -1L) continue;
            this.buildTaskDataHierarchy(taskData.getUniqueId(), string + "\t", map, stringBuffer);
        }
    }

    class Count {
        int count;
        int size;
        int max;
        int min = Integer.MAX_VALUE;
        String typeLabel;

        public Count(String string) {
            this.typeLabel = string;
        }

        void reset() {
            this.count = 0;
            this.size = 0;
            this.max = 0;
            this.min = Integer.MAX_VALUE;
        }

        void add(int n) {
            ++this.count;
            this.size += n;
            if (n < this.min) {
                this.min = n;
            }
            if (n > this.max) {
                this.max = n;
            }
        }

        void dump() {
            System.out.println("Serialized " + this.count + " " + this.typeLabel + ", total=" + this.size + ", average=" + (this.count == 0 ? 0 : this.size / this.count) + ", min=" + this.min + ", max=" + this.max);
        }
    }

    private static abstract class IdClosure
    implements Closure {
        long id = 1L;

        private IdClosure() {
        }
    }

    public static interface AssignmentClosure {
        public void execute(Assignment var1, int var2) throws IOException;
    }
}

