/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.parser;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.parser.IntermediateAsn1Field;
import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.asn1.parser.contentunpackers.ContentUnpacker;
import de.rub.nds.asn1.parser.contentunpackers.ContentUnpackerRegister;
import de.rub.nds.asn1.translator.Asn1Translator;
import de.rub.nds.util.ByteArrayBuffer;
import de.rub.nds.util.ByteArrayUtils;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Asn1Parser {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ByteArrayBuffer byteArrayBuffer;
    private final boolean isStrictMode;

    public Asn1Parser(byte[] bytes, boolean strictMode) {
        this.byteArrayBuffer = new ByteArrayBuffer(bytes);
        this.isStrictMode = strictMode;
    }

    public List<Asn1Encodable> parse(String contextName) throws ParserException {
        List<IntermediateAsn1Field> intermediateAsn1Fields = this.parseIntermediateFields();
        return this.translateIntermediateFields(contextName, intermediateAsn1Fields);
    }

    public List<IntermediateAsn1Field> parseIntermediateFields() throws ParserException {
        LinkedList<IntermediateAsn1Field> intermediateAsn1Fields = new LinkedList<IntermediateAsn1Field>();
        while (this.byteArrayBuffer.getNumberOfRemainingBytes() > 0) {
            IntermediateAsn1Field intermediateAsn1Field = this.parseAsn1Field();
            this.parseChildren(intermediateAsn1Field);
            intermediateAsn1Fields.add(intermediateAsn1Field);
        }
        return intermediateAsn1Fields;
    }

    private IntermediateAsn1Field parseAsn1Field() throws ParserException {
        try {
            int tag = this.parseTag();
            int tagClass = this.parseTagClass();
            boolean tagConstructed = this.parseTagConstructed();
            int tagNumber = this.parseTagNumber();
            BigInteger length = this.parseLength();
            byte[] content = this.parseContent(length);
            return new IntermediateAsn1Field(tag, tagClass, tagConstructed, tagNumber, length, content);
        }
        catch (RuntimeException e) {
            throw new ParserException(e);
        }
    }

    private int parseTag() {
        byte[] tagBytes = this.byteArrayBuffer.peekBytes(2);
        if (tagBytes[0] == 31) {
            return (tagBytes[0] & 0xFF) << 8 | tagBytes[1] & 0xFF;
        }
        return tagBytes[0] & 0xFF;
    }

    private int parseTagClass() {
        return this.byteArrayBuffer.peekByte() >> 6 & 3;
    }

    private boolean parseTagConstructed() {
        return (this.byteArrayBuffer.peekByte() >> 5 & 1) != 0;
    }

    private int parseTagNumber() {
        int tagNumber = this.byteArrayBuffer.readByte() & 0x1F;
        if (tagNumber == 31) {
            tagNumber = this.parseLongTagNumber();
        }
        return tagNumber;
    }

    private int parseLongTagNumber() {
        byte nextByte;
        int tagNumber = 0;
        do {
            nextByte = this.byteArrayBuffer.readByte();
            tagNumber = tagNumber << 7 | nextByte & 0x7F;
        } while ((nextByte & 0x80) > 0);
        return tagNumber;
    }

    private BigInteger parseLength() throws ParserException {
        BigInteger length = BigInteger.ZERO;
        byte lengthByte = this.byteArrayBuffer.readByte();
        if (lengthByte == 128) {
            throw new ParserException("Indefinite lengths are currently not supported!");
        }
        if (lengthByte == 255) {
            throw new ParserException("Reserved length value!");
        }
        if ((lengthByte & 0xFF) < 128) {
            length = BigInteger.valueOf(lengthByte & 0xFF);
        } else {
            int numberOfLengthBytes = lengthByte & 0x7F;
            for (int i = 0; i < numberOfLengthBytes; ++i) {
                length = length.shiftLeft(8);
                length = length.or(BigInteger.valueOf(this.byteArrayBuffer.readByte() & 0xFF));
            }
        }
        return length;
    }

    private byte[] parseContent(BigInteger length) {
        byte[] content = new byte[]{};
        while (length.compareTo(BigInteger.ZERO) > 0) {
            int bytesToRead = 65536;
            if (length.compareTo(BigInteger.valueOf(bytesToRead)) < 0) {
                bytesToRead = length.intValue();
            }
            content = ByteArrayUtils.merge(content, this.byteArrayBuffer.readBytes(bytesToRead));
            length = length.subtract(BigInteger.valueOf(bytesToRead));
        }
        return content;
    }

    private List<IntermediateAsn1Field> parseChildren(IntermediateAsn1Field intermediateAsn1Field) throws ParserException {
        List<IntermediateAsn1Field> children = new LinkedList<IntermediateAsn1Field>();
        List<ContentUnpacker> contentUnpackers = ContentUnpackerRegister.getInstance().getContentUnpackers();
        for (ContentUnpacker contentUnpacker : contentUnpackers) {
            try {
                byte[] unpacked = contentUnpacker.unpack(intermediateAsn1Field.getContent());
                Asn1Parser childParser = new Asn1Parser(unpacked, this.isStrictMode);
                children = childParser.parseIntermediateFields();
                intermediateAsn1Field.setChildren(children);
                break;
            }
            catch (Throwable e) {
                LOGGER.debug((Object)e);
            }
        }
        return children;
    }

    private List<Asn1Encodable> translateIntermediateFields(String contextName, List<IntermediateAsn1Field> intermediateAsn1Fields) {
        Asn1Translator asn1Translator = new Asn1Translator(contextName, intermediateAsn1Fields, this.isStrictMode);
        return asn1Translator.translate();
    }
}

