/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersionComparator;
import de.rub.nds.tlsattacker.core.exceptions.UnknownProtocolVersionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public enum ProtocolVersion {
    SSL2(new byte[]{0, 2}),
    SSL3(new byte[]{3, 0}),
    TLS10(new byte[]{3, 1}),
    TLS11(new byte[]{3, 2}),
    TLS12(new byte[]{3, 3}),
    TLS13(new byte[]{3, 4}),
    TLS13_DRAFT14(new byte[]{127, 14}),
    TLS13_DRAFT15(new byte[]{127, 15}),
    TLS13_DRAFT16(new byte[]{127, 16}),
    TLS13_DRAFT17(new byte[]{127, 17}),
    TLS13_DRAFT18(new byte[]{127, 18}),
    TLS13_DRAFT19(new byte[]{127, 19}),
    TLS13_DRAFT20(new byte[]{127, 20}),
    TLS13_DRAFT21(new byte[]{127, 21}),
    TLS13_DRAFT22(new byte[]{127, 22}),
    TLS13_DRAFT23(new byte[]{127, 23}),
    TLS13_DRAFT24(new byte[]{127, 24}),
    TLS13_DRAFT25(new byte[]{127, 25}),
    TLS13_DRAFT26(new byte[]{127, 26}),
    TLS13_DRAFT27(new byte[]{127, 27}),
    TLS13_DRAFT28(new byte[]{127, 28}),
    DTLS10(new byte[]{-2, -1}),
    DTLS12(new byte[]{-2, -3});

    private byte[] value;
    private static final Map<Integer, ProtocolVersion> MAP;

    private ProtocolVersion(byte[] value) {
        this.value = value;
    }

    private static Integer valueToInt(byte[] value) {
        if (value.length == 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        return null;
    }

    public boolean isDTLS() {
        return this == DTLS10 || this == DTLS12;
    }

    public static ProtocolVersion getProtocolVersion(byte[] value) {
        Integer i = ProtocolVersion.valueToInt(value);
        if (i == null) {
            return null;
        }
        return MAP.get(i);
    }

    public static void sort(List<ProtocolVersion> versions) {
        ProtocolVersion.sort(versions, true);
    }

    public static void sort(List<ProtocolVersion> versions, boolean ascending) {
        Comparator<ProtocolVersion> comparator = new ProtocolVersionComparator();
        if (!ascending) {
            comparator = comparator.reversed();
        }
        versions.sort(comparator);
    }

    public static List<ProtocolVersion> getProtocolVersions(byte[] values) {
        LinkedList<ProtocolVersion> versions = new LinkedList<ProtocolVersion>();
        if (values.length % 2 != 0) {
            throw new UnknownProtocolVersionException("Last ProtocolVersion are unknown!");
        }
        for (int pointer = 0; pointer < values.length; pointer += 2) {
            byte[] version = new byte[]{values[pointer], values[pointer + 1]};
            ProtocolVersion tempVersion = ProtocolVersion.getProtocolVersion(version);
            if (tempVersion == null) continue;
            versions.add(tempVersion);
        }
        return versions;
    }

    public static ProtocolVersion getRandom(Random random) {
        ProtocolVersion c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (ProtocolVersion)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte getMajor() {
        return this.value[0];
    }

    public byte getMinor() {
        return this.value[1];
    }

    public static ProtocolVersion fromString(String protocolVersion) {
        protocolVersion = protocolVersion.replaceFirst("v", "");
        protocolVersion = protocolVersion.replaceFirst("\\.", "");
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (!protocolVersion.equalsIgnoreCase(pv.toString())) continue;
            return pv;
        }
        throw new IllegalArgumentException("Value " + protocolVersion + " cannot be converted to a protocol version. Available values are: " + Arrays.toString((Object[])ProtocolVersion.values()));
    }

    public static ProtocolVersion getHighestProtocolVersion(List<ProtocolVersion> list) {
        ProtocolVersion highestProtocolVersion = null;
        for (ProtocolVersion pv : list) {
            if (highestProtocolVersion == null) {
                highestProtocolVersion = pv;
            }
            if (pv == null || ArrayConverter.bytesToInt((byte[])pv.getValue()) <= ArrayConverter.bytesToInt((byte[])highestProtocolVersion.getValue())) continue;
            highestProtocolVersion = pv;
        }
        return highestProtocolVersion;
    }

    public boolean isTLS13() {
        return this == TLS13 || this.getMajor() == 127;
    }

    public boolean isSSL() {
        return this == SSL2 || this == SSL3;
    }

    public boolean usesExplicitIv() {
        return this == TLS11 || this == TLS12 || this == DTLS10 || this == DTLS12;
    }

    public int compare(ProtocolVersion o1) {
        if (o1 == this) {
            return 0;
        }
        if (ArrayConverter.bytesToInt((byte[])this.getValue()) > ArrayConverter.bytesToInt((byte[])o1.getValue())) {
            return 1;
        }
        return -1;
    }

    static {
        MAP = new HashMap<Integer, ProtocolVersion>();
        for (ProtocolVersion c : ProtocolVersion.values()) {
            MAP.put(ProtocolVersion.valueToInt(c.value), c);
        }
    }
}

