/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.ComponentChangedEvent;
import org.zaproxy.zap.extension.httppanel.MessagePanelEventListener;
import org.zaproxy.zap.extension.httppanel.MessageViewSelectedEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.messagelocation.HighlightChangedEvent;
import org.zaproxy.zap.view.messagelocation.HighlightChangedListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightRenderersEditors;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusEvent;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationTableEntry;
import org.zaproxy.zap.view.messagelocation.MessageLocationsTableModel;
import org.zaproxy.zap.view.messagelocation.SelectMessageLocationsPanel;

public abstract class AbstractMessageLocationsPanel<T extends MessageLocationTableEntry, S extends MessageLocationsTableModel<T>>
extends AbstractMultipleOptionsBaseTablePanel<T> {
    private static final long serialVersionUID = -8990789229815588716L;
    private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("messagelocationspanel.dialog.remove.location.title");
    private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("messagelocationspanel.dialog.remove.location.text");
    private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.button.confirm");
    private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.button.cancel");
    private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.checkbox.label");
    private MessageLocationProducerFocusListener addButtonFocusListenerEnabler;
    private SelectMessageLocationsPanel selectMessageLocationsPanel;
    private final Component parent;

    public AbstractMessageLocationsPanel(Component parent, SelectMessageLocationsPanel selectMessageLocationsPanel, S model) {
        this(parent, selectMessageLocationsPanel, model, false);
    }

    public AbstractMessageLocationsPanel(Component parent, SelectMessageLocationsPanel selectMessageLocationsPanel, S model, boolean allowModifications) {
        super(model, allowModifications);
        this.parent = parent;
        this.selectMessageLocationsPanel = selectMessageLocationsPanel;
        this.selectMessageLocationsPanel.addMessagePanelEventListener(this.createMessagePanelEventListener());
        ((MessageLocationsTableModel)this.getModel()).addMessageLocationHighlightChangedListener(this.createHighlightChangedListener());
        this.addButton.setEnabled(false);
        this.addButton.setToolTipText(Constant.messages.getString("messagelocationspanel.add.location.tooltip"));
        this.addButtonFocusListenerEnabler = this.createFocusListener();
        this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        this.getTable().setDefaultRenderer(MessageLocationHighlight.class, new DefaultMessageLocationHighlightRenderer());
        this.getRemoveWithoutConfirmationCheckBox().setSelected(true);
    }

    protected MessagePanelEventListener createMessagePanelEventListener() {
        return new MessagePanelEventListener(){

            @Override
            public void componentChanged(ComponentChangedEvent event) {
                for (MessageLocationTableEntry entry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                    MessageLocationHighlight highlight = entry.getHighlight();
                    if (highlight == null) continue;
                    MessageLocationHighlight highlightReference = AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.highlight(entry.getLocation(), highlight);
                    entry.setHighlightReference(highlightReference);
                }
            }

            @Override
            public void viewSelected(MessageViewSelectedEvent event) {
                HttpPanelView view = event.getCurrentView();
                if (view instanceof MessageLocationHighlighter) {
                    MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)view);
                    for (MessageLocationTableEntry entry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                        MessageLocationHighlight highlight = entry.getHighlight();
                        if (highlight == null) continue;
                        MessageLocationHighlight highlightReference = highlighter.highlight(entry.getLocation(), highlight);
                        entry.setHighlightReference(highlightReference);
                    }
                } else {
                    for (MessageLocationTableEntry entry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                        entry.setHighlightReference(null);
                    }
                }
            }
        };
    }

    protected HighlightChangedListener<T> createHighlightChangedListener() {
        return new MessageLocationsHighlightChangedListener();
    }

    @Override
    protected JXTable createTable() {
        MessageLocationsTable table = new MessageLocationsTable();
        table.setSelectionMode(0);
        table.setColumnControlVisible(true);
        return table;
    }

    public MessageLocationProducerFocusListener getFocusListenerAddButtonEnabler() {
        return this.addButtonFocusListenerEnabler;
    }

    protected MessageLocationProducerFocusListener createFocusListener() {
        return new MessageLocationsFocusListener();
    }

    @Override
    public T showAddDialogue() {
        this.addButton.setEnabled(false);
        return this.addMessageLocationImpl(true, this.selectMessageLocationsPanel.getSelection());
    }

    public boolean addMessageLocation(MessageLocation messageLocation) {
        if (messageLocation == null) {
            throw new IllegalArgumentException("Parameter messageLocation must not be null.");
        }
        return this.addMessageLocationImpl(false, messageLocation) != null;
    }

    private T addMessageLocationImpl(boolean buttonAddedLocation, MessageLocation messageLocation) {
        T entry;
        for (MessageLocationTableEntry locationUI : ((MessageLocationsTableModel)this.getModel()).getElements()) {
            if (!locationUI.getLocation().overlaps(messageLocation)) continue;
            View.getSingleton().showWarningDialog(Constant.messages.getString("messagelocationspanel.add.location.warning.locations.overlap"));
            return null;
        }
        MessageLocationHighlight highlight = null;
        MessageLocationHighlight highlightReference = null;
        MessageLocationHighlightsManager highlightsManager = this.selectMessageLocationsPanel.create();
        if (highlightsManager != null) {
            highlight = highlightsManager.getHighlight(messageLocation);
            highlightReference = this.selectMessageLocationsPanel.highlight(messageLocation, highlight);
        }
        if ((entry = this.createMessageLocationTableEntry(buttonAddedLocation, messageLocation, highlight, highlightReference)) == null) {
            if (highlightsManager != null) {
                this.selectMessageLocationsPanel.removeHighlight(messageLocation, highlightReference);
            }
            return null;
        }
        ((AbstractMultipleOptionsBaseTableModel)this.getModel()).addElement(entry);
        int row = this.getTable().convertRowIndexToView(((MessageLocationsTableModel)this.getModel()).getRow((MessageLocationTableEntry)entry));
        this.getTable().setRowSelectionInterval(row, row);
        return null;
    }

    protected abstract T createMessageLocationTableEntry(boolean var1, MessageLocation var2, MessageLocationHighlight var3, MessageLocationHighlight var4);

    @Override
    public T showModifyDialogue(T e) {
        return null;
    }

    @Override
    public boolean showRemoveDialogue(T e) {
        if (!this.getRemoveWithoutConfirmationCheckBox().isSelected() && !this.showRemoveDialogueImpl(e)) {
            return false;
        }
        MessageLocationHighlight highlightReference = ((MessageLocationTableEntry)e).getHighlightReference();
        if (highlightReference != null) {
            this.selectMessageLocationsPanel.removeHighlight(((MessageLocationTableEntry)e).getLocation(), highlightReference);
        }
        return true;
    }

    protected Component getParentOwner() {
        return this.parent;
    }

    protected boolean showRemoveDialogueImpl(T e) {
        JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
        Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
        int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
        if (option == 0) {
            this.getRemoveWithoutConfirmationCheckBox().setSelected(removeWithoutConfirmationCheckBox.isSelected());
            return true;
        }
        return false;
    }

    @Override
    public boolean isRemoveWithoutConfirmation() {
        return false;
    }

    public void reset() {
        for (MessageLocationTableEntry entry : this.getMultipleOptionsModel().getElements()) {
            MessageLocationHighlight highlightReference = entry.getHighlightReference();
            if (highlightReference == null) continue;
            this.selectMessageLocationsPanel.removeHighlight(entry.getLocation(), highlightReference);
        }
        this.getMultipleOptionsModel().clear();
    }

    protected S getModel() {
        MessageLocationsTableModel model = (MessageLocationsTableModel)super.getMultipleOptionsModel();
        return (S)model;
    }

    protected class MessageLocationsFocusListener
    implements MessageLocationProducerFocusListener {
        protected MessageLocationsFocusListener() {
        }

        @Override
        public void focusLost(MessageLocationProducerFocusEvent e) {
            if (e.getFocusEvent().getOppositeComponent() != AbstractMessageLocationsPanel.this.addButton) {
                AbstractMessageLocationsPanel.this.addButton.setEnabled(false);
            }
        }

        @Override
        public void focusGained(MessageLocationProducerFocusEvent e) {
            AbstractMessageLocationsPanel.this.addButton.setEnabled(true);
        }
    }

    protected class MessageLocationsHighlightChangedListener
    implements HighlightChangedListener<T> {
        protected MessageLocationsHighlightChangedListener() {
        }

        @Override
        public void highlightChanged(HighlightChangedEvent<T> event) {
            MessageLocationHighlight highlight;
            MessageLocationTableEntry tableEntry = (MessageLocationTableEntry)event.getEntry();
            MessageLocationHighlight highlightReference = event.getHighlightReference();
            if (highlightReference != null) {
                AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.removeHighlight(tableEntry.getLocation(), event.getHighlightReference());
            }
            if ((highlight = tableEntry.getHighlight()) != null) {
                highlightReference = AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.highlight(tableEntry.getLocation(), tableEntry.getHighlight());
                tableEntry.setHighlightReference(highlightReference);
            }
        }
    }

    protected class MessageLocationsTable
    extends JXTable {
        private static final long serialVersionUID = -3277532157790764376L;

        protected MessageLocationsTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            TableCellEditor editor;
            Class<?> columnClass = ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getColumnClass(row, column);
            if (columnClass != null && MessageLocationHighlight.class.isAssignableFrom(columnClass) && (editor = MessageLocationHighlightRenderersEditors.getInstance().getEditor(columnClass)) != null) {
                return editor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer;
            Class<?> columnClass = ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getColumnClass(row, column);
            if (columnClass != null && MessageLocationHighlight.class.isAssignableFrom(columnClass) && (renderer = MessageLocationHighlightRenderersEditors.getInstance().getRenderer(columnClass)) != null) {
                return renderer;
            }
            return super.getCellRenderer(row, column);
        }
    }

    private static class DefaultMessageLocationHighlightRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 427590735065539815L;

        private DefaultMessageLocationHighlightRenderer() {
        }

        @Override
        protected void setValue(Object value) {
        }
    }
}

