/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.connection;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.ConnectedLDAPConfiguration;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.auth.ldap.group.UserGroupService;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.net.auth.TokenInjectingConnection;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    public static final String LDAP_ATTRIBUTE_PARAMETER = "guacConfigParameter";
    public static final String LDAP_ATTRIBUTE_PROTOCOL = "guacConfigProtocol";
    public static final String LDAP_ATTRIBUTE_PROXY_HOSTNAME = "guacConfigProxyHostname";
    public static final String LDAP_ATTRIBUTE_PROXY_PORT = "guacConfigProxyPort";
    public static final String LDAP_ATTRIBUTE_PROXY_ENCRYPTION = "guacConfigProxyEncryption";
    @Inject
    private ObjectQueryService queryService;
    @Inject
    private UserGroupService userGroupService;
    public static final String CONNECTION_LDAP_OBJECT_CLASS = "guacConfigGroup";
    public static final String LDAP_ATTRIBUTE_NAME_ID = "cn";
    public static final String LDAP_ATTRIBUTE_NAME_PROTOCOL = "guacConfigProtocol";
    public static final String LDAP_ATTRIBUTE_NAME_PARAMETER = "guacConfigParameter";
    public static final String LDAP_ATTRIBUTE_NAME_GROUPS = "seeAlso";
    public static final Collection<String> GUAC_CONFIG_LDAP_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cn", "guacConfigProtocol", "guacConfigParameter", "seeAlso")));

    public Map<String, Connection> getConnections(LDAPAuthenticatedUser user) throws GuacamoleException {
        ConnectedLDAPConfiguration ldapConfig = user.getLDAPConfiguration();
        Dn configurationBaseDN = ldapConfig.getConfigurationBaseDN();
        if (configurationBaseDN == null) {
            return Collections.emptyMap();
        }
        try {
            ExprNode connectionSearchFilter = this.getConnectionSearchFilter(user);
            List<Entry> results = this.queryService.search(ldapConfig, ldapConfig.getLDAPConnection(), configurationBaseDN, connectionSearchFilter, 0, GUAC_CONFIG_LDAP_ATTRIBUTES);
            return this.queryService.asMap(results, entry -> {
                GuacamoleProxyConfiguration proxyConfig;
                String cnName;
                Attribute cn = entry.get(LDAP_ATTRIBUTE_NAME_ID);
                if (cn == null) {
                    logger.warn("{} is missing a {}.", (Object)CONNECTION_LDAP_OBJECT_CLASS, (Object)LDAP_ATTRIBUTE_NAME_ID);
                    return null;
                }
                try {
                    cnName = cn.getString();
                }
                catch (LdapInvalidAttributeValueException e) {
                    logger.error("Invalid value for {} attribute: {}", (Object)LDAP_ATTRIBUTE_NAME_ID, (Object)e.getMessage());
                    logger.debug("LDAP exception while getting CN attribute.", (Throwable)e);
                    return null;
                }
                Attribute protocol = entry.get("guacConfigProtocol");
                if (protocol == null) {
                    logger.warn("{} \"{}\" is missing the required \"{}\" attribute.", new Object[]{CONNECTION_LDAP_OBJECT_CLASS, cnName, "guacConfigProtocol"});
                    return null;
                }
                GuacamoleConfiguration config = new GuacamoleConfiguration();
                try {
                    config.setProtocol(protocol.getString());
                }
                catch (LdapInvalidAttributeValueException e) {
                    logger.error("Invalid value of the protocol entry: {}", (Object)e.getMessage());
                    logger.debug("LDAP exception when getting protocol value.", (Throwable)e);
                    return null;
                }
                try {
                    proxyConfig = this.getProxyConfiguration((Entry)entry);
                }
                catch (GuacamoleException e) {
                    logger.error("Failed to retrieve proxy configuration.", (Object)e.getMessage());
                    logger.debug("Guacamole Exception when retrieving proxy configuration.", (Throwable)e);
                    return null;
                }
                Attribute parameterAttribute = entry.get("guacConfigParameter");
                if (parameterAttribute != null) {
                    while (parameterAttribute.size() > 0) {
                        String parameter;
                        try {
                            parameter = parameterAttribute.getString();
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            logger.warn("Parameter value not valid for {}: {}", (Object)cnName, (Object)e.getMessage());
                            logger.debug("LDAP exception when getting parameter value.", (Throwable)e);
                            return null;
                        }
                        parameterAttribute.remove(new String[]{parameter});
                        int equals = parameter.indexOf(61);
                        if (equals == -1) continue;
                        String name = parameter.substring(0, equals);
                        String value = parameter.substring(equals + 1);
                        config.setParameter(name, value);
                    }
                }
                SimpleConnection connection = new SimpleConnection(cnName, cnName, proxyConfig, config, true);
                connection.setParentIdentifier("ROOT");
                if (user instanceof LDAPAuthenticatedUser) {
                    connection = new TokenInjectingConnection((Connection)connection, user.getTokens());
                }
                return connection;
            });
        }
        catch (LdapException e) {
            throw new GuacamoleServerException("Error while querying for connections.", (Throwable)e);
        }
    }

    private ExprNode getConnectionSearchFilter(LDAPAuthenticatedUser user) throws LdapException, GuacamoleException {
        ConnectedLDAPConfiguration config = user.getLDAPConfiguration();
        Dn userDN = config.getBindDN();
        AndNode searchFilter = new AndNode();
        searchFilter.addNode((ExprNode)new EqualityNode("objectClass", CONNECTION_LDAP_OBJECT_CLASS));
        OrNode groupFilter = new OrNode();
        groupFilter.addNode((ExprNode)new EqualityNode(config.getMemberAttribute(), userDN.toString()));
        List<Entry> userGroups = this.userGroupService.getParentUserGroupEntries(config, userDN);
        if (!userGroups.isEmpty()) {
            userGroups.forEach(entry -> groupFilter.addNode((ExprNode)new EqualityNode(LDAP_ATTRIBUTE_NAME_GROUPS, entry.getDn().toString())));
        }
        searchFilter.addNode((ExprNode)groupFilter);
        return searchFilter;
    }

    private GuacamoleProxyConfiguration getProxyConfiguration(Entry connectionEntry) throws GuacamoleException {
        try {
            Attribute proxyEncryptionAttr;
            Attribute proxyPortAttr;
            GuacamoleProxyConfiguration proxyConfig = LocalEnvironment.getInstance().getDefaultGuacamoleProxyConfiguration();
            String proxyHostname = proxyConfig.getHostname();
            int proxyPort = proxyConfig.getPort();
            GuacamoleProxyConfiguration.EncryptionMethod proxyEncryption = proxyConfig.getEncryptionMethod();
            Attribute proxyHostAttr = connectionEntry.get(LDAP_ATTRIBUTE_PROXY_HOSTNAME);
            if (proxyHostAttr != null && proxyHostAttr.size() > 0) {
                proxyHostname = proxyHostAttr.getString();
            }
            if ((proxyPortAttr = connectionEntry.get(LDAP_ATTRIBUTE_PROXY_PORT)) != null && proxyPortAttr.size() > 0) {
                proxyPort = Integer.parseInt(proxyPortAttr.getString());
            }
            if ((proxyEncryptionAttr = connectionEntry.get(LDAP_ATTRIBUTE_PROXY_ENCRYPTION)) != null && proxyEncryptionAttr.size() > 0) {
                try {
                    proxyEncryption = GuacamoleProxyConfiguration.EncryptionMethod.valueOf((String)proxyEncryptionAttr.getString());
                }
                catch (IllegalArgumentException e) {
                    throw new GuacamoleServerException("Unknown encryption method specified, value must be either \"NONE\" or \"SSL\".", (Throwable)e);
                }
            }
            return new GuacamoleProxyConfiguration(proxyHostname, proxyPort, proxyEncryption);
        }
        catch (LdapInvalidAttributeValueException e) {
            logger.error("Invalid value in proxy configuration: {}", (Object)e.getMessage());
            logger.debug("LDAP exception fetching proxy attribute value.", (Throwable)e);
            throw new GuacamoleServerException("Invalid LDAP value in proxy configuration.", (Throwable)e);
        }
    }
}

