/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttachClassicLinkVpcRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private String instanceId;
    private String vpcId;
    private ListWithAutoConstructFlag<String> groups;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public AttachClassicLinkVpcRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public AttachClassicLinkVpcRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public AttachClassicLinkVpcRequest withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public AttachClassicLinkVpcRequest withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public AttachClassicLinkVpcRequest withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : ((Object)this.getGroups()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachClassicLinkVpcRequest)) {
            return false;
        }
        AttachClassicLinkVpcRequest other = (AttachClassicLinkVpcRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        return other.getGroups() == null || ((Object)other.getGroups()).equals(this.getGroups());
    }
}

