/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.filedialog;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

class CustomFileChooser
extends JFileChooser {
    private final FileDialogWrapper data;

    public CustomFileChooser(FileDialogWrapper data) {
        super(data.getCurrentDir() == null ? CommonFileUtils.CWD : data.getCurrentDir().toFile());
        this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        this.data = data;
    }

    public List<Path> showDialog() {
        int ret;
        this.setToolTipText(this.data.getTitle());
        this.setFileSelectionMode(this.data.getSelectionMode());
        this.setMultiSelectionEnabled(this.data.isOpen());
        this.setAcceptAllFileFilterUsed(true);
        List<String> fileExtList = this.data.getFileExtList();
        if (Utils.notEmpty(fileExtList)) {
            String description = NLS.str("file_dialog.supported_files") + ": (" + Utils.listToString(fileExtList) + ')';
            this.setFileFilter(new FileNameExtensionFilter(description, fileExtList.toArray(new String[0])));
        }
        if (this.data.getSelectedFile() != null) {
            this.setSelectedFile(this.data.getSelectedFile().toFile());
        }
        MainWindow mainWindow = this.data.getMainWindow();
        int n = ret = this.data.isOpen() ? this.showOpenDialog(mainWindow) : this.showSaveDialog(mainWindow);
        if (ret != 0) {
            return Collections.emptyList();
        }
        this.data.setCurrentDir(this.getCurrentDirectory().toPath());
        File[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles.length != 0) {
            return FileUtils.toPaths((File[])selectedFiles);
        }
        File chosenFile = this.getSelectedFile();
        if (chosenFile != null) {
            return Collections.singletonList(chosenFile.toPath());
        }
        return Collections.emptyList();
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        final JDialog dialog = super.createDialog(parent);
        dialog.setTitle(this.data.getTitle());
        dialog.setLocationRelativeTo(null);
        this.data.getMainWindow().getSettings().loadWindowPos(dialog);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CustomFileChooser.this.data.getMainWindow().getSettings().saveWindowPos(dialog);
                super.windowClosed(e);
            }
        });
        return dialog;
    }

    @Override
    public void approveSelection() {
        int option;
        File currentFile;
        if (this.data.getSelectionMode() == 2 && (currentFile = this.getSelectedFile()).isDirectory() && (option = JOptionPane.showConfirmDialog(this.data.getMainWindow(), NLS.str("file_dialog.load_dir_confirm") + "\n " + currentFile, NLS.str("file_dialog.load_dir_title"), 0)) != 0) {
            this.setCurrentDirectory(currentFile);
            this.updateUI();
            return;
        }
        super.approveSelection();
    }

    static {
        UIManager.put("FileChooser.noPlacesBar", Boolean.TRUE);
    }
}

