/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.Serializable;

public class MinOptMax
implements Serializable,
Cloneable {
    public int min;
    public int opt;
    public int max;

    public MinOptMax() {
        this(0);
    }

    public MinOptMax(int val) {
        this(val, val, val);
    }

    public MinOptMax(int min, int opt, int max) {
        this.min = min;
        this.opt = opt;
        this.max = max;
    }

    public MinOptMax(MinOptMax op) {
        this.min = op.min;
        this.opt = op.opt;
        this.max = op.max;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public static MinOptMax subtract(MinOptMax op1, MinOptMax op2) {
        return new MinOptMax(op1.min - op2.max, op1.opt - op2.opt, op1.max - op2.min);
    }

    public static MinOptMax add(MinOptMax op1, MinOptMax op2) {
        return new MinOptMax(op1.min + op2.min, op1.opt + op2.opt, op1.max + op2.max);
    }

    public static MinOptMax multiply(MinOptMax op1, double mult) {
        return new MinOptMax((int)((double)op1.min * mult), (int)((double)op1.opt * mult), (int)((double)op1.max * mult));
    }

    public void add(MinOptMax op) {
        this.min += op.min;
        this.opt += op.opt;
        this.max += op.max;
    }

    public void add(int min, int opt, int max) {
        this.min += min;
        this.opt += opt;
        this.max += max;
    }

    public void add(int len) {
        this.min += len;
        this.opt += len;
        this.max += len;
    }

    public void subtract(MinOptMax op) {
        this.min -= op.max;
        this.opt -= op.opt;
        this.max -= op.min;
    }

    public boolean isNonZero() {
        return this.min != 0 || this.max != 0;
    }

    public boolean isElastic() {
        return this.min != this.opt || this.opt != this.max;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MinOptMax[min=");
        if (this.min != this.opt) {
            sb.append(this.min).append("; ");
        }
        sb.append("opt=");
        if (this.opt != this.max) {
            sb.append(this.opt).append("; ");
        }
        sb.append("max=").append(this.max);
        sb.append("]");
        return sb.toString();
    }
}

