/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;

public abstract class ServerKeyExchangeMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray signatureAndHashAlgorithm;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger signatureLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.SIGNATURE)
    private ModifiableByteArray signature;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger publicKeyLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PUBLIC_KEY)
    private ModifiableByteArray publicKey;

    public ServerKeyExchangeMessage() {
        super(HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    public ServerKeyExchangeMessage(Config tlsConfig, HandshakeMessageType handshakeMessageType) {
        super(tlsConfig, handshakeMessageType);
    }

    public abstract KeyExchangeComputations getComputations();

    public abstract void prepareComputations();

    public ModifiableByteArray getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    public void setSignatureAndHashAlgorithm(ModifiableByteArray signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public void setSignatureAndHashAlgorithm(byte[] signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureAndHashAlgorithm, (byte[])signatureAndHashAlgorithm);
    }

    public ModifiableInteger getSignatureLength() {
        return this.signatureLength;
    }

    public void setSignatureLength(ModifiableInteger signatureLength) {
        this.signatureLength = signatureLength;
    }

    public void setSignatureLength(int length) {
        this.signatureLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureLength, (Integer)length);
    }

    public ModifiableByteArray getSignature() {
        return this.signature;
    }

    public void setSignature(ModifiableByteArray signature) {
        this.signature = signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signature, (byte[])signature);
    }

    public ModifiableInteger getPublicKeyLength() {
        return this.publicKeyLength;
    }

    public void setPublicKeyLength(ModifiableInteger publicKeyLength) {
        this.publicKeyLength = publicKeyLength;
    }

    public void setPublicKeyLength(Integer publicKeyLength) {
        this.publicKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.publicKeyLength, (Integer)publicKeyLength);
    }

    public ModifiableByteArray getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ModifiableByteArray publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.publicKey, (byte[])publicKey);
    }
}

