/*	$OpenBSD: if_bnxtreg.h,v 1.9 2025/11/21 04:24:04 jmatthew Exp $	*/
/*-
 *   BSD LICENSE
 *
 *   Copyright (c) 2025 Broadcom, All Rights Reserved.
 *   The term Broadcom refers to Broadcom Limited and/or its subsidiaries
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>

/*
 * Copyright(c) 2001-2025, Broadcom. All rights reserved. The
 * term Broadcom refers to Broadcom Inc. and/or its subsidiaries.
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without
 * the prior written consent of Broadcom Corporation.
 *
 * DO NOT MODIFY!!! This file is automatically generated.
 */

#ifndef _HSI_STRUCT_DEF_H_
#define _HSI_STRUCT_DEF_H_

#if defined(HAVE_STDINT_H)
#include <stdint.h>
#endif

/* This is the HWRM command header. */
/* hwrm_cmd_hdr (size:128b/16B) */

struct hwrm_cmd_hdr {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* This is the HWRM response header. */
/* hwrm_resp_hdr (size:64b/8B) */

struct hwrm_resp_hdr {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
} __attribute__((packed));

/*
 * TLV encapsulated message. Use the TLV type field of the
 * TLV to determine the type of message encapsulated.
 */
#define CMD_DISCR_TLV_ENCAP UINT32_C(0x8000)
#define CMD_DISCR_LAST	CMD_DISCR_TLV_ENCAP


/* HWRM request message */
#define TLV_TYPE_HWRM_REQUEST			UINT32_C(0x1)
/* HWRM response message */
#define TLV_TYPE_HWRM_RESPONSE		UINT32_C(0x2)
/* RoCE slow path command */
#define TLV_TYPE_ROCE_SP_COMMAND		UINT32_C(0x3)
/* RoCE slow path command to query CC Gen1 support. */
#define TLV_TYPE_QUERY_ROCE_CC_GEN1		UINT32_C(0x4)
/* RoCE slow path command to modify CC Gen1 support. */
#define TLV_TYPE_MODIFY_ROCE_CC_GEN1		UINT32_C(0x5)
/* RoCE slow path command to query CC Gen2 support. */
#define TLV_TYPE_QUERY_ROCE_CC_GEN2		UINT32_C(0x6)
/* RoCE slow path command to modify CC Gen2 support. */
#define TLV_TYPE_MODIFY_ROCE_CC_GEN2		UINT32_C(0x7)
/* Engine CKV - The Alias key EC curve and ECC public key information. */
#define TLV_TYPE_ENGINE_CKV_ALIAS_ECC_PUBLIC_KEY UINT32_C(0x8001)
/* Engine CKV - Initialization vector. */
#define TLV_TYPE_ENGINE_CKV_IV		UINT32_C(0x8003)
/* Engine CKV - Authentication tag. */
#define TLV_TYPE_ENGINE_CKV_AUTH_TAG		UINT32_C(0x8004)
/* Engine CKV - The encrypted data. */
#define TLV_TYPE_ENGINE_CKV_CIPHERTEXT	UINT32_C(0x8005)
/* Engine CKV - Supported host_algorithms. */
#define TLV_TYPE_ENGINE_CKV_HOST_ALGORITHMS	UINT32_C(0x8006)
/* Engine CKV - The Host EC curve name and ECC public key information. */
#define TLV_TYPE_ENGINE_CKV_HOST_ECC_PUBLIC_KEY  UINT32_C(0x8007)
/* Engine CKV - The ECDSA signature. */
#define TLV_TYPE_ENGINE_CKV_ECDSA_SIGNATURE	UINT32_C(0x8008)
/* Engine CKV - The firmware EC curve name and ECC public key information. */
#define TLV_TYPE_ENGINE_CKV_FW_ECC_PUBLIC_KEY	UINT32_C(0x8009)
/* Engine CKV - Supported firmware algorithms. */
#define TLV_TYPE_ENGINE_CKV_FW_ALGORITHMS	UINT32_C(0x800a)
#define TLV_TYPE_LAST			TLV_TYPE_ENGINE_CKV_FW_ALGORITHMS


/* tlv (size:64b/8B) */

struct tlv {
	/*
	 * The command discriminator is used to differentiate between various
	 * types of HWRM messages. This includes legacy HWRM and RoCE slowpath
	 * command messages as well as newer TLV encapsulated HWRM commands.
	 *
	 * For TLV encapsulated messages this field must be 0x8000.
	 */
	uint16_t	cmd_discr;
	uint8_t	reserved_8b;
	uint8_t	flags;
	/*
	 * Indicates the presence of additional TLV encapsulated data
	 * follows this TLV.
	 */
	#define TLV_FLAGS_MORE	UINT32_C(0x1)
	/* Last TLV in a sequence of TLVs. */
		#define TLV_FLAGS_MORE_LAST	UINT32_C(0x0)
	/* More TLVs follow this TLV. */
		#define TLV_FLAGS_MORE_NOT_LAST  UINT32_C(0x1)
	/*
	 * When an HWRM receiver detects a TLV type that it does not
	 * support with the TLV required flag set, the receiver must
	 * reject the HWRM message with an error code indicating an
	 * unsupported TLV type.
	 */
	#define TLV_FLAGS_REQUIRED	UINT32_C(0x2)
	/* No */
		#define TLV_FLAGS_REQUIRED_NO	(UINT32_C(0x0) << 1)
	/* Yes */
		#define TLV_FLAGS_REQUIRED_YES   (UINT32_C(0x1) << 1)
		#define TLV_FLAGS_REQUIRED_LAST TLV_FLAGS_REQUIRED_YES
	/*
	 * This field defines the TLV type value which is divided into
	 * two ranges to differentiate between global and local TLV types.
	 * Global TLV types must be unique across all defined TLV types.
	 * Local TLV types are valid only for extensions to a given
	 * HWRM message and may be repeated across different HWRM message
	 * types. There is a direct correlation of each HWRM message type
	 * to a single global TLV type value.
	 *
	 * Global TLV range: `0 - (63k-1)`
	 *
	 * Local TLV range: `63k - (64k-1)`
	 */
	uint16_t	tlv_type;
	/*
	 * Length of the message data encapsulated by this TLV in bytes.
	 * This length does not include the size of the TLV header itself
	 * and it must be an integer multiple of 8B.
	 */
	uint16_t	length;
} __attribute__((packed));

/* Input */
/* input (size:128b/16B) */

struct input {
	/*
	 * This value indicates what type of request this is. The format
	 * for the rest of the command is determined by this field.
	 */
	uint16_t	req_type;
	/*
	 * This value indicates the what completion ring the request will
	 * be optionally completed on. If the value is -1, then no
	 * CR completion will be generated. Any other value must be a
	 * valid CR ring_id value for this function.
	 */
	uint16_t	cmpl_ring;
	/* This value indicates the command sequence number. */
	uint16_t	seq_id;
	/*
	 * Target ID of this command.
	 *
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * This is the host address where the response will be written
	 * when the request is complete. This area must be 16B aligned
	 * and must be cleared to zero before the request is made.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* Output */
/* output (size:64b/8B) */

struct output {
	/*
	 * Pass/Fail or error type
	 *
	 * Note: receiver to verify the in parameters, and fail the call
	 * with an error when appropriate
	 */
	uint16_t	error_code;
	/* This field returns the type of original request. */
	uint16_t	req_type;
	/* This field provides original sequence number of the command. */
	uint16_t	seq_id;
	/*
	 * This field is the length of the response in bytes. The
	 * last byte of the response is a valid flag that will read
	 * as '1' when the command has been completely written to
	 * memory.
	 */
	uint16_t	resp_len;
} __attribute__((packed));

/* Short Command Structure */
/* hwrm_short_input (size:128b/16B) */

struct hwrm_short_input {
	/*
	 * This field indicates the type of request in the request buffer.
	 * The format for the rest of the command (request) is determined
	 * by this field.
	 */
	uint16_t	req_type;
	/*
	 * This field indicates a signature that is used to identify short
	 * form of the command listed here. This field shall be set to
	 * 17185 (0x4321).
	 */
	uint16_t	signature;
	/* Signature indicating this is a short form of HWRM command */
	#define HWRM_SHORT_INPUT_SIGNATURE_SHORT_CMD UINT32_C(0x4321)
	#define HWRM_SHORT_INPUT_SIGNATURE_LAST	HWRM_SHORT_INPUT_SIGNATURE_SHORT_CMD
	/* The target ID of the command */
	uint16_t	target_id;
	/* Default target_id (0x0) to maintain compatibility with old driver */
	#define HWRM_SHORT_INPUT_TARGET_ID_DEFAULT UINT32_C(0x0)
	/* Reserved for user-space HWRM interface */
	#define HWRM_SHORT_INPUT_TARGET_ID_TOOLS   UINT32_C(0xfffd)
	#define HWRM_SHORT_INPUT_TARGET_ID_LAST   HWRM_SHORT_INPUT_TARGET_ID_TOOLS
	/* This value indicates the length of the request. */
	uint16_t	size;
	/*
	 * This is the host address where the request was written.
	 * This area must be 16B aligned.
	 */
	uint64_t	req_addr;
} __attribute__((packed));

#define GET_HWRM_REQ_TYPE(x) \
	(((x) < 0x80) ? \
	((x) == 0x0 ? "HWRM_VER_GET": \
	((x) == 0xb ? "HWRM_FUNC_ECHO_RESPONSE": \
	((x) == 0xc ? "HWRM_ERROR_RECOVERY_QCFG": \
	((x) == 0xd ? "HWRM_FUNC_DRV_IF_CHANGE": \
	((x) == 0xe ? "HWRM_FUNC_BUF_UNRGTR": \
	((x) == 0xf ? "HWRM_FUNC_VF_CFG": \
	((x) == 0x10 ? "HWRM_RESERVED1": \
	((x) == 0x11 ? "HWRM_FUNC_RESET": \
	((x) == 0x12 ? "HWRM_FUNC_GETFID": \
	((x) == 0x13 ? "HWRM_FUNC_VF_ALLOC": \
	((x) == 0x14 ? "HWRM_FUNC_VF_FREE": \
	((x) == 0x15 ? "HWRM_FUNC_QCAPS": \
	((x) == 0x16 ? "HWRM_FUNC_QCFG": \
	((x) == 0x17 ? "HWRM_FUNC_CFG": \
	((x) == 0x18 ? "HWRM_FUNC_QSTATS": \
	((x) == 0x19 ? "HWRM_FUNC_CLR_STATS": \
	((x) == 0x1a ? "HWRM_FUNC_DRV_UNRGTR": \
	((x) == 0x1b ? "HWRM_FUNC_VF_RESC_FREE": \
	((x) == 0x1c ? "HWRM_FUNC_VF_VNIC_IDS_QUERY": \
	((x) == 0x1d ? "HWRM_FUNC_DRV_RGTR": \
	((x) == 0x1e ? "HWRM_FUNC_DRV_QVER": \
	((x) == 0x1f ? "HWRM_FUNC_BUF_RGTR": \
	((x) == 0x20 ? "HWRM_PORT_PHY_CFG": \
	((x) == 0x21 ? "HWRM_PORT_MAC_CFG": \
	((x) == 0x22 ? "HWRM_PORT_TS_QUERY": \
	((x) == 0x23 ? "HWRM_PORT_QSTATS": \
	((x) == 0x24 ? "HWRM_PORT_LPBK_QSTATS": \
	((x) == 0x25 ? "HWRM_PORT_CLR_STATS": \
	((x) == 0x26 ? "HWRM_PORT_LPBK_CLR_STATS": \
	((x) == 0x27 ? "HWRM_PORT_PHY_QCFG": \
	((x) == 0x28 ? "HWRM_PORT_MAC_QCFG": \
	((x) == 0x29 ? "HWRM_PORT_MAC_PTP_QCFG": \
	((x) == 0x2a ? "HWRM_PORT_PHY_QCAPS": \
	((x) == 0x2b ? "HWRM_PORT_PHY_I2C_WRITE": \
	((x) == 0x2c ? "HWRM_PORT_PHY_I2C_READ": \
	((x) == 0x2d ? "HWRM_PORT_LED_CFG": \
	((x) == 0x2e ? "HWRM_PORT_LED_QCFG": \
	((x) == 0x2f ? "HWRM_PORT_LED_QCAPS": \
	((x) == 0x30 ? "HWRM_QUEUE_QPORTCFG": \
	((x) == 0x31 ? "HWRM_QUEUE_QCFG": \
	((x) == 0x32 ? "HWRM_QUEUE_CFG": \
	((x) == 0x33 ? "HWRM_FUNC_VLAN_CFG": \
	((x) == 0x34 ? "HWRM_FUNC_VLAN_QCFG": \
	((x) == 0x35 ? "HWRM_QUEUE_PFCENABLE_QCFG": \
	((x) == 0x36 ? "HWRM_QUEUE_PFCENABLE_CFG": \
	((x) == 0x37 ? "HWRM_QUEUE_PRI2COS_QCFG": \
	((x) == 0x38 ? "HWRM_QUEUE_PRI2COS_CFG": \
	((x) == 0x39 ? "HWRM_QUEUE_COS2BW_QCFG": \
	((x) == 0x3a ? "HWRM_QUEUE_COS2BW_CFG": \
	((x) == 0x3b ? "HWRM_QUEUE_DSCP_QCAPS": \
	((x) == 0x3c ? "HWRM_QUEUE_DSCP2PRI_QCFG": \
	((x) == 0x3d ? "HWRM_QUEUE_DSCP2PRI_CFG": \
	((x) == 0x40 ? "HWRM_VNIC_ALLOC": \
	((x) == 0x41 ? "HWRM_VNIC_FREE": \
	((x) == 0x42 ? "HWRM_VNIC_CFG": \
	((x) == 0x43 ? "HWRM_VNIC_QCFG": \
	((x) == 0x44 ? "HWRM_VNIC_TPA_CFG": \
	((x) == 0x45 ? "HWRM_VNIC_TPA_QCFG": \
	((x) == 0x46 ? "HWRM_VNIC_RSS_CFG": \
	((x) == 0x47 ? "HWRM_VNIC_RSS_QCFG": \
	((x) == 0x48 ? "HWRM_VNIC_PLCMODES_CFG": \
	((x) == 0x49 ? "HWRM_VNIC_PLCMODES_QCFG": \
	((x) == 0x4a ? "HWRM_VNIC_QCAPS": \
	((x) == 0x4b ? "HWRM_VNIC_UPDATE": \
	((x) == 0x50 ? "HWRM_RING_ALLOC": \
	((x) == 0x51 ? "HWRM_RING_FREE": \
	((x) == 0x52 ? "HWRM_RING_CMPL_RING_QAGGINT_PARAMS": \
	((x) == 0x53 ? "HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS": \
	((x) == 0x54 ? "HWRM_RING_AGGINT_QCAPS": \
	((x) == 0x55 ? "HWRM_RING_SCHQ_ALLOC": \
	((x) == 0x56 ? "HWRM_RING_SCHQ_CFG": \
	((x) == 0x57 ? "HWRM_RING_SCHQ_FREE": \
	((x) == 0x5e ? "HWRM_RING_RESET": \
	((x) == 0x60 ? "HWRM_RING_GRP_ALLOC": \
	((x) == 0x61 ? "HWRM_RING_GRP_FREE": \
	((x) == 0x62 ? "HWRM_RING_CFG": \
	((x) == 0x63 ? "HWRM_RING_QCFG": \
	((x) == 0x64 ? "HWRM_RESERVED5": \
	((x) == 0x65 ? "HWRM_RESERVED6": \
	((x) == 0x70 ? "HWRM_VNIC_RSS_COS_LB_CTX_ALLOC": \
	((x) == 0x71 ? "HWRM_VNIC_RSS_COS_LB_CTX_FREE": \
	"Unknown decode" ))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x100) ? \
	((x) == 0x80 ? "HWRM_QUEUE_MPLS_QCAPS": \
	((x) == 0x81 ? "HWRM_QUEUE_MPLSTC2PRI_QCFG": \
	((x) == 0x82 ? "HWRM_QUEUE_MPLSTC2PRI_CFG": \
	((x) == 0x83 ? "HWRM_QUEUE_VLANPRI_QCAPS": \
	((x) == 0x84 ? "HWRM_QUEUE_VLANPRI2PRI_QCFG": \
	((x) == 0x85 ? "HWRM_QUEUE_VLANPRI2PRI_CFG": \
	((x) == 0x86 ? "HWRM_QUEUE_GLOBAL_CFG": \
	((x) == 0x87 ? "HWRM_QUEUE_GLOBAL_QCFG": \
	((x) == 0x88 ? "HWRM_QUEUE_ADPTV_QOS_RX_FEATURE_QCFG": \
	((x) == 0x89 ? "HWRM_QUEUE_ADPTV_QOS_RX_FEATURE_CFG": \
	((x) == 0x8a ? "HWRM_QUEUE_ADPTV_QOS_TX_FEATURE_QCFG": \
	((x) == 0x8b ? "HWRM_QUEUE_ADPTV_QOS_TX_FEATURE_CFG": \
	((x) == 0x8c ? "HWRM_QUEUE_QCAPS": \
	((x) == 0x8d ? "HWRM_QUEUE_ADPTV_QOS_RX_TUNING_QCFG": \
	((x) == 0x8e ? "HWRM_QUEUE_ADPTV_QOS_RX_TUNING_CFG": \
	((x) == 0x8f ? "HWRM_QUEUE_ADPTV_QOS_TX_TUNING_QCFG": \
	((x) == 0x90 ? "HWRM_CFA_L2_FILTER_ALLOC": \
	((x) == 0x91 ? "HWRM_CFA_L2_FILTER_FREE": \
	((x) == 0x92 ? "HWRM_CFA_L2_FILTER_CFG": \
	((x) == 0x93 ? "HWRM_CFA_L2_SET_RX_MASK": \
	((x) == 0x94 ? "HWRM_CFA_VLAN_ANTISPOOF_CFG": \
	((x) == 0x95 ? "HWRM_CFA_TUNNEL_FILTER_ALLOC": \
	((x) == 0x96 ? "HWRM_CFA_TUNNEL_FILTER_FREE": \
	((x) == 0x97 ? "HWRM_CFA_ENCAP_RECORD_ALLOC": \
	((x) == 0x98 ? "HWRM_CFA_ENCAP_RECORD_FREE": \
	((x) == 0x99 ? "HWRM_CFA_NTUPLE_FILTER_ALLOC": \
	((x) == 0x9a ? "HWRM_CFA_NTUPLE_FILTER_FREE": \
	((x) == 0x9b ? "HWRM_CFA_NTUPLE_FILTER_CFG": \
	((x) == 0x9c ? "HWRM_CFA_EM_FLOW_ALLOC": \
	((x) == 0x9d ? "HWRM_CFA_EM_FLOW_FREE": \
	((x) == 0x9e ? "HWRM_CFA_EM_FLOW_CFG": \
	((x) == 0xa0 ? "HWRM_TUNNEL_DST_PORT_QUERY": \
	((x) == 0xa1 ? "HWRM_TUNNEL_DST_PORT_ALLOC": \
	((x) == 0xa2 ? "HWRM_TUNNEL_DST_PORT_FREE": \
	((x) == 0xa3 ? "HWRM_QUEUE_ADPTV_QOS_TX_TUNING_CFG": \
	((x) == 0xaf ? "HWRM_STAT_CTX_ENG_QUERY": \
	((x) == 0xb0 ? "HWRM_STAT_CTX_ALLOC": \
	((x) == 0xb1 ? "HWRM_STAT_CTX_FREE": \
	((x) == 0xb2 ? "HWRM_STAT_CTX_QUERY": \
	((x) == 0xb3 ? "HWRM_STAT_CTX_CLR_STATS": \
	((x) == 0xb4 ? "HWRM_PORT_QSTATS_EXT": \
	((x) == 0xb5 ? "HWRM_PORT_PHY_MDIO_WRITE": \
	((x) == 0xb6 ? "HWRM_PORT_PHY_MDIO_READ": \
	((x) == 0xb7 ? "HWRM_PORT_PHY_MDIO_BUS_ACQUIRE": \
	((x) == 0xb8 ? "HWRM_PORT_PHY_MDIO_BUS_RELEASE": \
	((x) == 0xb9 ? "HWRM_PORT_QSTATS_EXT_PFC_WD": \
	((x) == 0xba ? "HWRM_RESERVED7": \
	((x) == 0xbb ? "HWRM_PORT_TX_FIR_CFG": \
	((x) == 0xbc ? "HWRM_PORT_TX_FIR_QCFG": \
	((x) == 0xbd ? "HWRM_PORT_ECN_QSTATS": \
	((x) == 0xbe ? "HWRM_FW_LIVEPATCH_QUERY": \
	((x) == 0xbf ? "HWRM_FW_LIVEPATCH": \
	((x) == 0xc0 ? "HWRM_FW_RESET": \
	((x) == 0xc1 ? "HWRM_FW_QSTATUS": \
	((x) == 0xc2 ? "HWRM_FW_HEALTH_CHECK": \
	((x) == 0xc3 ? "HWRM_FW_SYNC": \
	((x) == 0xc4 ? "HWRM_FW_STATE_QCAPS": \
	((x) == 0xc5 ? "HWRM_FW_STATE_QUIESCE": \
	((x) == 0xc6 ? "HWRM_FW_STATE_BACKUP": \
	((x) == 0xc7 ? "HWRM_FW_STATE_RESTORE": \
	((x) == 0xc8 ? "HWRM_FW_SET_TIME": \
	((x) == 0xc9 ? "HWRM_FW_GET_TIME": \
	((x) == 0xca ? "HWRM_FW_SET_STRUCTURED_DATA": \
	((x) == 0xcb ? "HWRM_FW_GET_STRUCTURED_DATA": \
	((x) == 0xcc ? "HWRM_FW_IPC_MAILBOX": \
	((x) == 0xcd ? "HWRM_FW_ECN_CFG": \
	((x) == 0xce ? "HWRM_FW_ECN_QCFG": \
	((x) == 0xcf ? "HWRM_FW_SECURE_CFG": \
	((x) == 0xd0 ? "HWRM_EXEC_FWD_RESP": \
	((x) == 0xd1 ? "HWRM_REJECT_FWD_RESP": \
	((x) == 0xd2 ? "HWRM_FWD_RESP": \
	((x) == 0xd3 ? "HWRM_FWD_ASYNC_EVENT_CMPL": \
	((x) == 0xd4 ? "HWRM_OEM_CMD": \
	((x) == 0xd5 ? "HWRM_PORT_PRBS_TEST": \
	((x) == 0xd6 ? "HWRM_PORT_SFP_SIDEBAND_CFG": \
	((x) == 0xd7 ? "HWRM_PORT_SFP_SIDEBAND_QCFG": \
	((x) == 0xd8 ? "HWRM_FW_STATE_UNQUIESCE": \
	((x) == 0xd9 ? "HWRM_PORT_DSC_DUMP": \
	((x) == 0xda ? "HWRM_PORT_EP_TX_QCFG": \
	((x) == 0xdb ? "HWRM_PORT_EP_TX_CFG": \
	((x) == 0xdc ? "HWRM_PORT_CFG": \
	((x) == 0xdd ? "HWRM_PORT_QCFG": \
	((x) == 0xdf ? "HWRM_PORT_MAC_QCAPS": \
	((x) == 0xe0 ? "HWRM_TEMP_MONITOR_QUERY": \
	((x) == 0xe1 ? "HWRM_REG_POWER_QUERY": \
	((x) == 0xe2 ? "HWRM_CORE_FREQUENCY_QUERY": \
	((x) == 0xe3 ? "HWRM_REG_POWER_HISTOGRAM": \
	((x) == 0xf0 ? "HWRM_WOL_FILTER_ALLOC": \
	((x) == 0xf1 ? "HWRM_WOL_FILTER_FREE": \
	((x) == 0xf2 ? "HWRM_WOL_FILTER_QCFG": \
	((x) == 0xf3 ? "HWRM_WOL_REASON_QCFG": \
	((x) == 0xf4 ? "HWRM_CFA_METER_QCAPS": \
	((x) == 0xf5 ? "HWRM_CFA_METER_PROFILE_ALLOC": \
	((x) == 0xf6 ? "HWRM_CFA_METER_PROFILE_FREE": \
	((x) == 0xf7 ? "HWRM_CFA_METER_PROFILE_CFG": \
	((x) == 0xf8 ? "HWRM_CFA_METER_INSTANCE_ALLOC": \
	((x) == 0xf9 ? "HWRM_CFA_METER_INSTANCE_FREE": \
	((x) == 0xfa ? "HWRM_CFA_METER_INSTANCE_CFG": \
	((x) == 0xfd ? "HWRM_CFA_VFR_ALLOC": \
	((x) == 0xfe ? "HWRM_CFA_VFR_FREE": \
	"Unknown decode" )))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x180) ? \
	((x) == 0x100 ? "HWRM_CFA_VF_PAIR_ALLOC": \
	((x) == 0x101 ? "HWRM_CFA_VF_PAIR_FREE": \
	((x) == 0x102 ? "HWRM_CFA_VF_PAIR_INFO": \
	((x) == 0x103 ? "HWRM_CFA_FLOW_ALLOC": \
	((x) == 0x104 ? "HWRM_CFA_FLOW_FREE": \
	((x) == 0x105 ? "HWRM_CFA_FLOW_FLUSH": \
	((x) == 0x106 ? "HWRM_CFA_FLOW_STATS": \
	((x) == 0x107 ? "HWRM_CFA_FLOW_INFO": \
	((x) == 0x108 ? "HWRM_CFA_DECAP_FILTER_ALLOC": \
	((x) == 0x109 ? "HWRM_CFA_DECAP_FILTER_FREE": \
	((x) == 0x10a ? "HWRM_CFA_VLAN_ANTISPOOF_QCFG": \
	((x) == 0x10b ? "HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC": \
	((x) == 0x10c ? "HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE": \
	((x) == 0x10d ? "HWRM_CFA_PAIR_ALLOC": \
	((x) == 0x10e ? "HWRM_CFA_PAIR_FREE": \
	((x) == 0x10f ? "HWRM_CFA_PAIR_INFO": \
	((x) == 0x110 ? "HWRM_FW_IPC_MSG": \
	((x) == 0x111 ? "HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO": \
	((x) == 0x112 ? "HWRM_CFA_REDIRECT_QUERY_TUNNEL_TYPE": \
	((x) == 0x113 ? "HWRM_CFA_FLOW_AGING_TIMER_RESET": \
	((x) == 0x114 ? "HWRM_CFA_FLOW_AGING_CFG": \
	((x) == 0x115 ? "HWRM_CFA_FLOW_AGING_QCFG": \
	((x) == 0x116 ? "HWRM_CFA_FLOW_AGING_QCAPS": \
	((x) == 0x117 ? "HWRM_CFA_CTX_MEM_RGTR": \
	((x) == 0x118 ? "HWRM_CFA_CTX_MEM_UNRGTR": \
	((x) == 0x119 ? "HWRM_CFA_CTX_MEM_QCTX": \
	((x) == 0x11a ? "HWRM_CFA_CTX_MEM_QCAPS": \
	((x) == 0x11b ? "HWRM_CFA_COUNTER_QCAPS": \
	((x) == 0x11c ? "HWRM_CFA_COUNTER_CFG": \
	((x) == 0x11d ? "HWRM_CFA_COUNTER_QCFG": \
	((x) == 0x11e ? "HWRM_CFA_COUNTER_QSTATS": \
	((x) == 0x11f ? "HWRM_CFA_TCP_FLAG_PROCESS_QCFG": \
	((x) == 0x120 ? "HWRM_CFA_EEM_QCAPS": \
	((x) == 0x121 ? "HWRM_CFA_EEM_CFG": \
	((x) == 0x122 ? "HWRM_CFA_EEM_QCFG": \
	((x) == 0x123 ? "HWRM_CFA_EEM_OP": \
	((x) == 0x124 ? "HWRM_CFA_ADV_FLOW_MGNT_QCAPS": \
	((x) == 0x125 ? "HWRM_CFA_TFLIB": \
	((x) == 0x126 ? "HWRM_CFA_LAG_GROUP_MEMBER_RGTR": \
	((x) == 0x127 ? "HWRM_CFA_LAG_GROUP_MEMBER_UNRGTR": \
	((x) == 0x128 ? "HWRM_CFA_TLS_FILTER_ALLOC": \
	((x) == 0x129 ? "HWRM_CFA_TLS_FILTER_FREE": \
	((x) == 0x12a ? "HWRM_CFA_RELEASE_AFM_FUNC": \
	((x) == 0x12e ? "HWRM_ENGINE_CKV_STATUS": \
	((x) == 0x12f ? "HWRM_ENGINE_CKV_CKEK_ADD": \
	((x) == 0x130 ? "HWRM_ENGINE_CKV_CKEK_DELETE": \
	((x) == 0x131 ? "HWRM_ENGINE_CKV_KEY_ADD": \
	((x) == 0x132 ? "HWRM_ENGINE_CKV_KEY_DELETE": \
	((x) == 0x133 ? "HWRM_ENGINE_CKV_FLUSH": \
	((x) == 0x134 ? "HWRM_ENGINE_CKV_RNG_GET": \
	((x) == 0x135 ? "HWRM_ENGINE_CKV_KEY_GEN": \
	((x) == 0x136 ? "HWRM_ENGINE_CKV_KEY_LABEL_CFG": \
	((x) == 0x137 ? "HWRM_ENGINE_CKV_KEY_LABEL_QCFG": \
	((x) == 0x13c ? "HWRM_ENGINE_QG_CONFIG_QUERY": \
	((x) == 0x13d ? "HWRM_ENGINE_QG_QUERY": \
	((x) == 0x13e ? "HWRM_ENGINE_QG_METER_PROFILE_CONFIG_QUERY": \
	((x) == 0x13f ? "HWRM_ENGINE_QG_METER_PROFILE_QUERY": \
	((x) == 0x140 ? "HWRM_ENGINE_QG_METER_PROFILE_ALLOC": \
	((x) == 0x141 ? "HWRM_ENGINE_QG_METER_PROFILE_FREE": \
	((x) == 0x142 ? "HWRM_ENGINE_QG_METER_QUERY": \
	((x) == 0x143 ? "HWRM_ENGINE_QG_METER_BIND": \
	((x) == 0x144 ? "HWRM_ENGINE_QG_METER_UNBIND": \
	((x) == 0x145 ? "HWRM_ENGINE_QG_FUNC_BIND": \
	((x) == 0x146 ? "HWRM_ENGINE_SG_CONFIG_QUERY": \
	((x) == 0x147 ? "HWRM_ENGINE_SG_QUERY": \
	((x) == 0x148 ? "HWRM_ENGINE_SG_METER_QUERY": \
	((x) == 0x149 ? "HWRM_ENGINE_SG_METER_CONFIG": \
	((x) == 0x14a ? "HWRM_ENGINE_SG_QG_BIND": \
	((x) == 0x14b ? "HWRM_ENGINE_QG_SG_UNBIND": \
	((x) == 0x154 ? "HWRM_ENGINE_CONFIG_QUERY": \
	((x) == 0x155 ? "HWRM_ENGINE_STATS_CONFIG": \
	((x) == 0x156 ? "HWRM_ENGINE_STATS_CLEAR": \
	((x) == 0x157 ? "HWRM_ENGINE_STATS_QUERY": \
	((x) == 0x158 ? "HWRM_ENGINE_STATS_QUERY_CONTINUOUS_ERROR": \
	((x) == 0x15e ? "HWRM_ENGINE_RQ_ALLOC": \
	((x) == 0x15f ? "HWRM_ENGINE_RQ_FREE": \
	((x) == 0x160 ? "HWRM_ENGINE_CQ_ALLOC": \
	((x) == 0x161 ? "HWRM_ENGINE_CQ_FREE": \
	((x) == 0x162 ? "HWRM_ENGINE_NQ_ALLOC": \
	((x) == 0x163 ? "HWRM_ENGINE_NQ_FREE": \
	((x) == 0x164 ? "HWRM_ENGINE_ON_DIE_RQE_CREDITS": \
	((x) == 0x165 ? "HWRM_ENGINE_FUNC_QCFG": \
	"Unknown decode" )))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x200) ? \
	((x) == 0x190 ? "HWRM_FUNC_RESOURCE_QCAPS": \
	((x) == 0x191 ? "HWRM_FUNC_VF_RESOURCE_CFG": \
	((x) == 0x192 ? "HWRM_FUNC_BACKING_STORE_QCAPS": \
	((x) == 0x193 ? "HWRM_FUNC_BACKING_STORE_CFG": \
	((x) == 0x194 ? "HWRM_FUNC_BACKING_STORE_QCFG": \
	((x) == 0x195 ? "HWRM_FUNC_VF_BW_CFG": \
	((x) == 0x196 ? "HWRM_FUNC_VF_BW_QCFG": \
	((x) == 0x197 ? "HWRM_FUNC_HOST_PF_IDS_QUERY": \
	((x) == 0x198 ? "HWRM_FUNC_QSTATS_EXT": \
	((x) == 0x199 ? "HWRM_STAT_EXT_CTX_QUERY": \
	((x) == 0x19a ? "HWRM_FUNC_SPD_CFG": \
	((x) == 0x19b ? "HWRM_FUNC_SPD_QCFG": \
	((x) == 0x19c ? "HWRM_FUNC_PTP_PIN_QCFG": \
	((x) == 0x19d ? "HWRM_FUNC_PTP_PIN_CFG": \
	((x) == 0x19e ? "HWRM_FUNC_PTP_CFG": \
	((x) == 0x19f ? "HWRM_FUNC_PTP_TS_QUERY": \
	((x) == 0x1a0 ? "HWRM_FUNC_PTP_EXT_CFG": \
	((x) == 0x1a1 ? "HWRM_FUNC_PTP_EXT_QCFG": \
	((x) == 0x1a2 ? "HWRM_FUNC_KEY_CTX_ALLOC": \
	((x) == 0x1a3 ? "HWRM_FUNC_BACKING_STORE_CFG_V2": \
	((x) == 0x1a4 ? "HWRM_FUNC_BACKING_STORE_QCFG_V2": \
	((x) == 0x1a5 ? "HWRM_FUNC_DBR_PACING_CFG": \
	((x) == 0x1a6 ? "HWRM_FUNC_DBR_PACING_QCFG": \
	((x) == 0x1a7 ? "HWRM_FUNC_DBR_PACING_BROADCAST_EVENT": \
	((x) == 0x1a8 ? "HWRM_FUNC_BACKING_STORE_QCAPS_V2": \
	((x) == 0x1a9 ? "HWRM_FUNC_DBR_PACING_NQLIST_QUERY": \
	((x) == 0x1aa ? "HWRM_FUNC_DBR_RECOVERY_COMPLETED": \
	((x) == 0x1ab ? "HWRM_FUNC_SYNCE_CFG": \
	((x) == 0x1ac ? "HWRM_FUNC_SYNCE_QCFG": \
	((x) == 0x1ad ? "HWRM_FUNC_KEY_CTX_FREE": \
	((x) == 0x1ae ? "HWRM_FUNC_LAG_MODE_CFG": \
	((x) == 0x1af ? "HWRM_FUNC_LAG_MODE_QCFG": \
	((x) == 0x1b0 ? "HWRM_FUNC_LAG_CREATE": \
	((x) == 0x1b1 ? "HWRM_FUNC_LAG_UPDATE": \
	((x) == 0x1b2 ? "HWRM_FUNC_LAG_FREE": \
	((x) == 0x1b3 ? "HWRM_FUNC_LAG_QCFG": \
	((x) == 0x1c2 ? "HWRM_FUNC_TIMEDTX_PACING_RATE_ADD": \
	((x) == 0x1c3 ? "HWRM_FUNC_TIMEDTX_PACING_RATE_DELETE": \
	((x) == 0x1c4 ? "HWRM_FUNC_TIMEDTX_PACING_RATE_QUERY": \
	"Unknown decode" ))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x280) ? \
	((x) == 0x200 ? "HWRM_SELFTEST_QLIST": \
	((x) == 0x201 ? "HWRM_SELFTEST_EXEC": \
	((x) == 0x202 ? "HWRM_SELFTEST_IRQ": \
	((x) == 0x203 ? "HWRM_SELFTEST_RETRIEVE_SERDES_DATA": \
	((x) == 0x204 ? "HWRM_PCIE_QSTATS": \
	((x) == 0x205 ? "HWRM_MFG_FRU_WRITE_CONTROL": \
	((x) == 0x206 ? "HWRM_MFG_TIMERS_QUERY": \
	((x) == 0x207 ? "HWRM_MFG_OTP_CFG": \
	((x) == 0x208 ? "HWRM_MFG_OTP_QCFG": \
	((x) == 0x209 ? "HWRM_MFG_HDMA_TEST": \
	((x) == 0x20a ? "HWRM_MFG_FRU_EEPROM_WRITE": \
	((x) == 0x20b ? "HWRM_MFG_FRU_EEPROM_READ": \
	((x) == 0x20c ? "HWRM_MFG_SOC_IMAGE": \
	((x) == 0x20d ? "HWRM_MFG_SOC_QSTATUS": \
	((x) == 0x20e ? "HWRM_MFG_PARAM_CRITICAL_DATA_FINALIZE": \
	((x) == 0x20f ? "HWRM_MFG_PARAM_CRITICAL_DATA_READ": \
	((x) == 0x210 ? "HWRM_MFG_PARAM_CRITICAL_DATA_HEALTH": \
	((x) == 0x211 ? "HWRM_MFG_PRVSN_EXPORT_CSR": \
	((x) == 0x212 ? "HWRM_MFG_PRVSN_IMPORT_CERT": \
	((x) == 0x213 ? "HWRM_MFG_PRVSN_GET_STATE": \
	((x) == 0x214 ? "HWRM_MFG_GET_NVM_MEASUREMENT": \
	((x) == 0x215 ? "HWRM_MFG_PSOC_QSTATUS": \
	((x) == 0x216 ? "HWRM_MFG_SELFTEST_QLIST": \
	((x) == 0x217 ? "HWRM_MFG_SELFTEST_EXEC": \
	((x) == 0x218 ? "HWRM_STAT_GENERIC_QSTATS": \
	((x) == 0x219 ? "HWRM_MFG_PRVSN_EXPORT_CERT": \
	((x) == 0x21a ? "HWRM_STAT_DB_ERROR_QSTATS": \
	((x) == 0x230 ? "HWRM_PORT_POE_CFG": \
	((x) == 0x231 ? "HWRM_PORT_POE_QCFG": \
	((x) == 0x258 ? "HWRM_UDCC_QCAPS": \
	((x) == 0x259 ? "HWRM_UDCC_CFG": \
	((x) == 0x25a ? "HWRM_UDCC_QCFG": \
	((x) == 0x25b ? "HWRM_UDCC_SESSION_CFG": \
	((x) == 0x25c ? "HWRM_UDCC_SESSION_QCFG": \
	((x) == 0x25d ? "HWRM_UDCC_SESSION_QUERY": \
	((x) == 0x25e ? "HWRM_UDCC_COMP_CFG": \
	((x) == 0x25f ? "HWRM_UDCC_COMP_QCFG": \
	((x) == 0x260 ? "HWRM_UDCC_COMP_QUERY": \
	((x) == 0x261 ? "HWRM_QUEUE_PFCWD_TIMEOUT_QCAPS": \
	((x) == 0x262 ? "HWRM_QUEUE_PFCWD_TIMEOUT_CFG": \
	((x) == 0x263 ? "HWRM_QUEUE_PFCWD_TIMEOUT_QCFG": \
	"Unknown decode" ))))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x300) ? \
	((x) == 0x2bc ? "HWRM_TF": \
	((x) == 0x2bd ? "HWRM_TF_VERSION_GET": \
	((x) == 0x2c6 ? "HWRM_TF_SESSION_OPEN": \
	((x) == 0x2c8 ? "HWRM_TF_SESSION_REGISTER": \
	((x) == 0x2c9 ? "HWRM_TF_SESSION_UNREGISTER": \
	((x) == 0x2ca ? "HWRM_TF_SESSION_CLOSE": \
	((x) == 0x2cb ? "HWRM_TF_SESSION_QCFG": \
	((x) == 0x2cc ? "HWRM_TF_SESSION_RESC_QCAPS": \
	((x) == 0x2cd ? "HWRM_TF_SESSION_RESC_ALLOC": \
	((x) == 0x2ce ? "HWRM_TF_SESSION_RESC_FREE": \
	((x) == 0x2cf ? "HWRM_TF_SESSION_RESC_FLUSH": \
	((x) == 0x2d0 ? "HWRM_TF_SESSION_RESC_INFO": \
	((x) == 0x2d1 ? "HWRM_TF_SESSION_HOTUP_STATE_SET": \
	((x) == 0x2d2 ? "HWRM_TF_SESSION_HOTUP_STATE_GET": \
	((x) == 0x2da ? "HWRM_TF_TBL_TYPE_GET": \
	((x) == 0x2db ? "HWRM_TF_TBL_TYPE_SET": \
	((x) == 0x2dc ? "HWRM_TF_TBL_TYPE_BULK_GET": \
	((x) == 0x2ea ? "HWRM_TF_EM_INSERT": \
	((x) == 0x2eb ? "HWRM_TF_EM_DELETE": \
	((x) == 0x2ec ? "HWRM_TF_EM_HASH_INSERT": \
	((x) == 0x2ed ? "HWRM_TF_EM_MOVE": \
	((x) == 0x2f8 ? "HWRM_TF_TCAM_SET": \
	((x) == 0x2f9 ? "HWRM_TF_TCAM_GET": \
	((x) == 0x2fa ? "HWRM_TF_TCAM_MOVE": \
	((x) == 0x2fb ? "HWRM_TF_TCAM_FREE": \
	((x) == 0x2fc ? "HWRM_TF_GLOBAL_CFG_SET": \
	((x) == 0x2fd ? "HWRM_TF_GLOBAL_CFG_GET": \
	((x) == 0x2fe ? "HWRM_TF_IF_TBL_SET": \
	((x) == 0x2ff ? "HWRM_TF_IF_TBL_GET": \
	"Unknown decode" ))))))))))))))))))))))))))))) : \
	(((x) < 0x380) ? \
	((x) == 0x300 ? "HWRM_TF_RESC_USAGE_SET": \
	((x) == 0x301 ? "HWRM_TF_RESC_USAGE_QUERY": \
	((x) == 0x302 ? "HWRM_TF_TBL_TYPE_ALLOC": \
	((x) == 0x303 ? "HWRM_TF_TBL_TYPE_FREE": \
	"Unknown decode" )))) : \
	(((x) < 0x400) ? \
	((x) == 0x380 ? "HWRM_TFC_TBL_SCOPE_QCAPS": \
	((x) == 0x381 ? "HWRM_TFC_TBL_SCOPE_ID_ALLOC": \
	((x) == 0x382 ? "HWRM_TFC_TBL_SCOPE_CONFIG": \
	((x) == 0x383 ? "HWRM_TFC_TBL_SCOPE_DECONFIG": \
	((x) == 0x384 ? "HWRM_TFC_TBL_SCOPE_FID_ADD": \
	((x) == 0x385 ? "HWRM_TFC_TBL_SCOPE_FID_REM": \
	((x) == 0x386 ? "HWRM_TFC_TBL_SCOPE_POOL_ALLOC": \
	((x) == 0x387 ? "HWRM_TFC_TBL_SCOPE_POOL_FREE": \
	((x) == 0x388 ? "HWRM_TFC_SESSION_ID_ALLOC": \
	((x) == 0x389 ? "HWRM_TFC_SESSION_FID_ADD": \
	((x) == 0x38a ? "HWRM_TFC_SESSION_FID_REM": \
	((x) == 0x38b ? "HWRM_TFC_IDENT_ALLOC": \
	((x) == 0x38c ? "HWRM_TFC_IDENT_FREE": \
	((x) == 0x38d ? "HWRM_TFC_IDX_TBL_ALLOC": \
	((x) == 0x38e ? "HWRM_TFC_IDX_TBL_ALLOC_SET": \
	((x) == 0x38f ? "HWRM_TFC_IDX_TBL_SET": \
	((x) == 0x390 ? "HWRM_TFC_IDX_TBL_GET": \
	((x) == 0x391 ? "HWRM_TFC_IDX_TBL_FREE": \
	((x) == 0x392 ? "HWRM_TFC_GLOBAL_ID_ALLOC": \
	((x) == 0x393 ? "HWRM_TFC_TCAM_SET": \
	((x) == 0x394 ? "HWRM_TFC_TCAM_GET": \
	((x) == 0x395 ? "HWRM_TFC_TCAM_ALLOC": \
	((x) == 0x396 ? "HWRM_TFC_TCAM_ALLOC_SET": \
	((x) == 0x397 ? "HWRM_TFC_TCAM_FREE": \
	((x) == 0x398 ? "HWRM_TFC_IF_TBL_SET": \
	((x) == 0x399 ? "HWRM_TFC_IF_TBL_GET": \
	((x) == 0x39a ? "HWRM_TFC_TBL_SCOPE_CONFIG_GET": \
	((x) == 0x39b ? "HWRM_TFC_RESC_USAGE_QUERY": \
	"Unknown decode" )))))))))))))))))))))))))))) : \
	(((x) < 0x480) ? \
	((x) == 0x400 ? "HWRM_SV": \
	"Unknown decode" ) : \
	(((x) < 0xff80) ? \
	((x) == 0xff0e ? "HWRM_DBG_SERDES_TEST": \
	((x) == 0xff0f ? "HWRM_DBG_LOG_BUFFER_FLUSH": \
	((x) == 0xff10 ? "HWRM_DBG_READ_DIRECT": \
	((x) == 0xff11 ? "HWRM_DBG_READ_INDIRECT": \
	((x) == 0xff12 ? "HWRM_DBG_WRITE_DIRECT": \
	((x) == 0xff13 ? "HWRM_DBG_WRITE_INDIRECT": \
	((x) == 0xff14 ? "HWRM_DBG_DUMP": \
	((x) == 0xff15 ? "HWRM_DBG_ERASE_NVM": \
	((x) == 0xff16 ? "HWRM_DBG_CFG": \
	((x) == 0xff17 ? "HWRM_DBG_COREDUMP_LIST": \
	((x) == 0xff18 ? "HWRM_DBG_COREDUMP_INITIATE": \
	((x) == 0xff19 ? "HWRM_DBG_COREDUMP_RETRIEVE": \
	((x) == 0xff1a ? "HWRM_DBG_FW_CLI": \
	((x) == 0xff1b ? "HWRM_DBG_I2C_CMD": \
	((x) == 0xff1c ? "HWRM_DBG_RING_INFO_GET": \
	((x) == 0xff1d ? "HWRM_DBG_CRASHDUMP_HEADER": \
	((x) == 0xff1e ? "HWRM_DBG_CRASHDUMP_ERASE": \
	((x) == 0xff1f ? "HWRM_DBG_DRV_TRACE": \
	((x) == 0xff20 ? "HWRM_DBG_QCAPS": \
	((x) == 0xff21 ? "HWRM_DBG_QCFG": \
	((x) == 0xff22 ? "HWRM_DBG_CRASHDUMP_MEDIUM_CFG": \
	((x) == 0xff23 ? "HWRM_DBG_USEQ_ALLOC": \
	((x) == 0xff24 ? "HWRM_DBG_USEQ_FREE": \
	((x) == 0xff25 ? "HWRM_DBG_USEQ_FLUSH": \
	((x) == 0xff26 ? "HWRM_DBG_USEQ_QCAPS": \
	((x) == 0xff27 ? "HWRM_DBG_USEQ_CW_CFG": \
	((x) == 0xff28 ? "HWRM_DBG_USEQ_SCHED_CFG": \
	((x) == 0xff29 ? "HWRM_DBG_USEQ_RUN": \
	((x) == 0xff2a ? "HWRM_DBG_USEQ_DELIVERY_REQ": \
	((x) == 0xff2b ? "HWRM_DBG_USEQ_RESP_HDR": \
	((x) == 0xff2c ? "HWRM_DBG_COREDUMP_CAPTURE": \
	((x) == 0xff2d ? "HWRM_DBG_PTRACE": \
	((x) == 0xff2e ? "HWRM_DBG_SIM_CABLE_STATE": \
	"Unknown decode" ))))))))))))))))))))))))))))))))) : \
	(((x) <= UINT16_MAX) ? \
	((x) == 0xffea ? "HWRM_NVM_GET_VPD_FIELD_INFO": \
	((x) == 0xffeb ? "HWRM_NVM_SET_VPD_FIELD_INFO": \
	((x) == 0xffec ? "HWRM_NVM_DEFRAG": \
	((x) == 0xffed ? "HWRM_NVM_REQ_ARBITRATION": \
	((x) == 0xffee ? "HWRM_NVM_FACTORY_DEFAULTS": \
	((x) == 0xffef ? "HWRM_NVM_VALIDATE_OPTION": \
	((x) == 0xfff0 ? "HWRM_NVM_FLUSH": \
	((x) == 0xfff1 ? "HWRM_NVM_GET_VARIABLE": \
	((x) == 0xfff2 ? "HWRM_NVM_SET_VARIABLE": \
	((x) == 0xfff3 ? "HWRM_NVM_INSTALL_UPDATE": \
	((x) == 0xfff4 ? "HWRM_NVM_MODIFY": \
	((x) == 0xfff5 ? "HWRM_NVM_VERIFY_UPDATE": \
	((x) == 0xfff6 ? "HWRM_NVM_GET_DEV_INFO": \
	((x) == 0xfff7 ? "HWRM_NVM_ERASE_DIR_ENTRY": \
	((x) == 0xfff8 ? "HWRM_NVM_MOD_DIR_ENTRY": \
	((x) == 0xfff9 ? "HWRM_NVM_FIND_DIR_ENTRY": \
	((x) == 0xfffa ? "HWRM_NVM_GET_DIR_ENTRIES": \
	((x) == 0xfffb ? "HWRM_NVM_GET_DIR_INFO": \
	((x) == 0xfffc ? "HWRM_NVM_RAW_DUMP": \
	((x) == 0xfffd ? "HWRM_NVM_READ": \
	((x) == 0xfffe ? "HWRM_NVM_WRITE": \
	((x) == 0xffff ? "HWRM_NVM_RAW_WRITE_BLK": \
	"Unknown decode" )))))))))))))))))))))) : \
	"Unknown decode" )))))))))))


/*
 * Command numbering
 * # NOTE - definitions already in hwrm_req_type, in hwrm_types.yaml
 * #	So only structure definition is provided here.
 */
/* cmd_nums (size:64b/8B) */

struct cmd_nums {
	/*
	 * This version of the specification defines the commands listed in
	 * the table below. The following are general implementation
	 * requirements for these commands:
	 *
	 * # All commands listed below that are marked neither
	 * reserved nor experimental shall be implemented by the HWRM.
	 * # A HWRM client compliant to this specification should not use
	 * commands outside of the list below.
	 * # A HWRM client compliant to this specification should not use
	 * command numbers marked reserved below.
	 * # A command marked experimental below may not be implemented
	 * by the HWRM.
	 * # A command marked experimental may change in the
	 * future version of the HWRM specification.
	 * # A command not listed below may be implemented by the HWRM.
	 * The behavior of commands that are not listed below is outside
	 * the scope of this specification.
	 */
	uint16_t	req_type;
	#define HWRM_VER_GET				UINT32_C(0x0)
	#define HWRM_FUNC_ECHO_RESPONSE		UINT32_C(0xb)
	#define HWRM_ERROR_RECOVERY_QCFG		UINT32_C(0xc)
	#define HWRM_FUNC_DRV_IF_CHANGE		UINT32_C(0xd)
	#define HWRM_FUNC_BUF_UNRGTR			UINT32_C(0xe)
	#define HWRM_FUNC_VF_CFG			UINT32_C(0xf)
	/* Reserved for future use. */
	#define HWRM_RESERVED1				UINT32_C(0x10)
	#define HWRM_FUNC_RESET			UINT32_C(0x11)
	#define HWRM_FUNC_GETFID			UINT32_C(0x12)
	#define HWRM_FUNC_VF_ALLOC			UINT32_C(0x13)
	#define HWRM_FUNC_VF_FREE			UINT32_C(0x14)
	#define HWRM_FUNC_QCAPS			UINT32_C(0x15)
	#define HWRM_FUNC_QCFG				UINT32_C(0x16)
	#define HWRM_FUNC_CFG				UINT32_C(0x17)
	#define HWRM_FUNC_QSTATS			UINT32_C(0x18)
	#define HWRM_FUNC_CLR_STATS			UINT32_C(0x19)
	#define HWRM_FUNC_DRV_UNRGTR			UINT32_C(0x1a)
	#define HWRM_FUNC_VF_RESC_FREE			UINT32_C(0x1b)
	#define HWRM_FUNC_VF_VNIC_IDS_QUERY		UINT32_C(0x1c)
	#define HWRM_FUNC_DRV_RGTR			UINT32_C(0x1d)
	#define HWRM_FUNC_DRV_QVER			UINT32_C(0x1e)
	#define HWRM_FUNC_BUF_RGTR			UINT32_C(0x1f)
	#define HWRM_PORT_PHY_CFG			UINT32_C(0x20)
	#define HWRM_PORT_MAC_CFG			UINT32_C(0x21)
	/* Experimental */
	#define HWRM_PORT_TS_QUERY			UINT32_C(0x22)
	#define HWRM_PORT_QSTATS			UINT32_C(0x23)
	#define HWRM_PORT_LPBK_QSTATS			UINT32_C(0x24)
	/* Experimental */
	#define HWRM_PORT_CLR_STATS			UINT32_C(0x25)
	/* Experimental */
	#define HWRM_PORT_LPBK_CLR_STATS		UINT32_C(0x26)
	#define HWRM_PORT_PHY_QCFG			UINT32_C(0x27)
	#define HWRM_PORT_MAC_QCFG			UINT32_C(0x28)
	/* Experimental */
	#define HWRM_PORT_MAC_PTP_QCFG			UINT32_C(0x29)
	#define HWRM_PORT_PHY_QCAPS			UINT32_C(0x2a)
	#define HWRM_PORT_PHY_I2C_WRITE		UINT32_C(0x2b)
	#define HWRM_PORT_PHY_I2C_READ			UINT32_C(0x2c)
	#define HWRM_PORT_LED_CFG			UINT32_C(0x2d)
	#define HWRM_PORT_LED_QCFG			UINT32_C(0x2e)
	#define HWRM_PORT_LED_QCAPS			UINT32_C(0x2f)
	#define HWRM_QUEUE_QPORTCFG			UINT32_C(0x30)
	#define HWRM_QUEUE_QCFG			UINT32_C(0x31)
	#define HWRM_QUEUE_CFG				UINT32_C(0x32)
	#define HWRM_FUNC_VLAN_CFG			UINT32_C(0x33)
	#define HWRM_FUNC_VLAN_QCFG			UINT32_C(0x34)
	#define HWRM_QUEUE_PFCENABLE_QCFG		UINT32_C(0x35)
	#define HWRM_QUEUE_PFCENABLE_CFG		UINT32_C(0x36)
	#define HWRM_QUEUE_PRI2COS_QCFG		UINT32_C(0x37)
	#define HWRM_QUEUE_PRI2COS_CFG			UINT32_C(0x38)
	#define HWRM_QUEUE_COS2BW_QCFG			UINT32_C(0x39)
	#define HWRM_QUEUE_COS2BW_CFG			UINT32_C(0x3a)
	#define HWRM_QUEUE_DSCP_QCAPS			UINT32_C(0x3b)
	#define HWRM_QUEUE_DSCP2PRI_QCFG		UINT32_C(0x3c)
	#define HWRM_QUEUE_DSCP2PRI_CFG		UINT32_C(0x3d)
	#define HWRM_VNIC_ALLOC			UINT32_C(0x40)
	#define HWRM_VNIC_FREE				UINT32_C(0x41)
	#define HWRM_VNIC_CFG				UINT32_C(0x42)
	#define HWRM_VNIC_QCFG				UINT32_C(0x43)
	#define HWRM_VNIC_TPA_CFG			UINT32_C(0x44)
	/* Experimental */
	#define HWRM_VNIC_TPA_QCFG			UINT32_C(0x45)
	#define HWRM_VNIC_RSS_CFG			UINT32_C(0x46)
	#define HWRM_VNIC_RSS_QCFG			UINT32_C(0x47)
	#define HWRM_VNIC_PLCMODES_CFG			UINT32_C(0x48)
	#define HWRM_VNIC_PLCMODES_QCFG		UINT32_C(0x49)
	#define HWRM_VNIC_QCAPS			UINT32_C(0x4a)
	/* Updates specific fields in RX VNIC structure */
	#define HWRM_VNIC_UPDATE			UINT32_C(0x4b)
	#define HWRM_RING_ALLOC			UINT32_C(0x50)
	#define HWRM_RING_FREE				UINT32_C(0x51)
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS	UINT32_C(0x52)
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS	UINT32_C(0x53)
	#define HWRM_RING_AGGINT_QCAPS			UINT32_C(0x54)
	#define HWRM_RING_SCHQ_ALLOC			UINT32_C(0x55)
	#define HWRM_RING_SCHQ_CFG			UINT32_C(0x56)
	#define HWRM_RING_SCHQ_FREE			UINT32_C(0x57)
	#define HWRM_RING_RESET			UINT32_C(0x5e)
	#define HWRM_RING_GRP_ALLOC			UINT32_C(0x60)
	#define HWRM_RING_GRP_FREE			UINT32_C(0x61)
	#define HWRM_RING_CFG				UINT32_C(0x62)
	#define HWRM_RING_QCFG				UINT32_C(0x63)
	/* Reserved for future use. */
	#define HWRM_RESERVED5				UINT32_C(0x64)
	/* Reserved for future use. */
	#define HWRM_RESERVED6				UINT32_C(0x65)
	#define HWRM_VNIC_RSS_COS_LB_CTX_ALLOC		UINT32_C(0x70)
	#define HWRM_VNIC_RSS_COS_LB_CTX_FREE		UINT32_C(0x71)
	#define HWRM_QUEUE_MPLS_QCAPS			UINT32_C(0x80)
	#define HWRM_QUEUE_MPLSTC2PRI_QCFG		UINT32_C(0x81)
	#define HWRM_QUEUE_MPLSTC2PRI_CFG		UINT32_C(0x82)
	#define HWRM_QUEUE_VLANPRI_QCAPS		UINT32_C(0x83)
	#define HWRM_QUEUE_VLANPRI2PRI_QCFG		UINT32_C(0x84)
	#define HWRM_QUEUE_VLANPRI2PRI_CFG		UINT32_C(0x85)
	#define HWRM_QUEUE_GLOBAL_CFG			UINT32_C(0x86)
	#define HWRM_QUEUE_GLOBAL_QCFG			UINT32_C(0x87)
	#define HWRM_QUEUE_ADPTV_QOS_RX_FEATURE_QCFG	UINT32_C(0x88)
	#define HWRM_QUEUE_ADPTV_QOS_RX_FEATURE_CFG	UINT32_C(0x89)
	#define HWRM_QUEUE_ADPTV_QOS_TX_FEATURE_QCFG	UINT32_C(0x8a)
	#define HWRM_QUEUE_ADPTV_QOS_TX_FEATURE_CFG	UINT32_C(0x8b)
	#define HWRM_QUEUE_QCAPS			UINT32_C(0x8c)
	#define HWRM_QUEUE_ADPTV_QOS_RX_TUNING_QCFG	UINT32_C(0x8d)
	#define HWRM_QUEUE_ADPTV_QOS_RX_TUNING_CFG	UINT32_C(0x8e)
	#define HWRM_QUEUE_ADPTV_QOS_TX_TUNING_QCFG	UINT32_C(0x8f)
	#define HWRM_CFA_L2_FILTER_ALLOC		UINT32_C(0x90)
	#define HWRM_CFA_L2_FILTER_FREE		UINT32_C(0x91)
	#define HWRM_CFA_L2_FILTER_CFG			UINT32_C(0x92)
	#define HWRM_CFA_L2_SET_RX_MASK		UINT32_C(0x93)
	#define HWRM_CFA_VLAN_ANTISPOOF_CFG		UINT32_C(0x94)
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC		UINT32_C(0x95)
	#define HWRM_CFA_TUNNEL_FILTER_FREE		UINT32_C(0x96)
	/* Experimental */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC		UINT32_C(0x97)
	/* Experimental */
	#define HWRM_CFA_ENCAP_RECORD_FREE		UINT32_C(0x98)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC		UINT32_C(0x99)
	#define HWRM_CFA_NTUPLE_FILTER_FREE		UINT32_C(0x9a)
	#define HWRM_CFA_NTUPLE_FILTER_CFG		UINT32_C(0x9b)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_ALLOC			UINT32_C(0x9c)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_FREE			UINT32_C(0x9d)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_CFG			UINT32_C(0x9e)
	#define HWRM_TUNNEL_DST_PORT_QUERY		UINT32_C(0xa0)
	#define HWRM_TUNNEL_DST_PORT_ALLOC		UINT32_C(0xa1)
	#define HWRM_TUNNEL_DST_PORT_FREE		UINT32_C(0xa2)
	#define HWRM_QUEUE_ADPTV_QOS_TX_TUNING_CFG	UINT32_C(0xa3)
	#define HWRM_STAT_CTX_ENG_QUERY		UINT32_C(0xaf)
	#define HWRM_STAT_CTX_ALLOC			UINT32_C(0xb0)
	#define HWRM_STAT_CTX_FREE			UINT32_C(0xb1)
	#define HWRM_STAT_CTX_QUERY			UINT32_C(0xb2)
	#define HWRM_STAT_CTX_CLR_STATS		UINT32_C(0xb3)
	#define HWRM_PORT_QSTATS_EXT			UINT32_C(0xb4)
	#define HWRM_PORT_PHY_MDIO_WRITE		UINT32_C(0xb5)
	#define HWRM_PORT_PHY_MDIO_READ		UINT32_C(0xb6)
	#define HWRM_PORT_PHY_MDIO_BUS_ACQUIRE		UINT32_C(0xb7)
	#define HWRM_PORT_PHY_MDIO_BUS_RELEASE		UINT32_C(0xb8)
	#define HWRM_PORT_QSTATS_EXT_PFC_WD		UINT32_C(0xb9)
	/* Reserved. */
	#define HWRM_RESERVED7				UINT32_C(0xba)
	#define HWRM_PORT_TX_FIR_CFG			UINT32_C(0xbb)
	#define HWRM_PORT_TX_FIR_QCFG			UINT32_C(0xbc)
	#define HWRM_PORT_ECN_QSTATS			UINT32_C(0xbd)
	#define HWRM_FW_LIVEPATCH_QUERY		UINT32_C(0xbe)
	#define HWRM_FW_LIVEPATCH			UINT32_C(0xbf)
	#define HWRM_FW_RESET				UINT32_C(0xc0)
	#define HWRM_FW_QSTATUS			UINT32_C(0xc1)
	#define HWRM_FW_HEALTH_CHECK			UINT32_C(0xc2)
	#define HWRM_FW_SYNC				UINT32_C(0xc3)
	#define HWRM_FW_STATE_QCAPS			UINT32_C(0xc4)
	#define HWRM_FW_STATE_QUIESCE			UINT32_C(0xc5)
	#define HWRM_FW_STATE_BACKUP			UINT32_C(0xc6)
	#define HWRM_FW_STATE_RESTORE			UINT32_C(0xc7)
	/* Experimental */
	#define HWRM_FW_SET_TIME			UINT32_C(0xc8)
	/* Experimental */
	#define HWRM_FW_GET_TIME			UINT32_C(0xc9)
	/* Experimental */
	#define HWRM_FW_SET_STRUCTURED_DATA		UINT32_C(0xca)
	/* Experimental */
	#define HWRM_FW_GET_STRUCTURED_DATA		UINT32_C(0xcb)
	/* Experimental */
	#define HWRM_FW_IPC_MAILBOX			UINT32_C(0xcc)
	#define HWRM_FW_ECN_CFG			UINT32_C(0xcd)
	#define HWRM_FW_ECN_QCFG			UINT32_C(0xce)
	#define HWRM_FW_SECURE_CFG			UINT32_C(0xcf)
	#define HWRM_EXEC_FWD_RESP			UINT32_C(0xd0)
	#define HWRM_REJECT_FWD_RESP			UINT32_C(0xd1)
	#define HWRM_FWD_RESP				UINT32_C(0xd2)
	#define HWRM_FWD_ASYNC_EVENT_CMPL		UINT32_C(0xd3)
	#define HWRM_OEM_CMD				UINT32_C(0xd4)
	/* Tells the fw to run PRBS test on a given port and lane. */
	#define HWRM_PORT_PRBS_TEST			UINT32_C(0xd5)
	#define HWRM_PORT_SFP_SIDEBAND_CFG		UINT32_C(0xd6)
	#define HWRM_PORT_SFP_SIDEBAND_QCFG		UINT32_C(0xd7)
	#define HWRM_FW_STATE_UNQUIESCE		UINT32_C(0xd8)
	/* Tells the fw to collect dsc dump on a given port and lane. */
	#define HWRM_PORT_DSC_DUMP			UINT32_C(0xd9)
	#define HWRM_PORT_EP_TX_QCFG			UINT32_C(0xda)
	#define HWRM_PORT_EP_TX_CFG			UINT32_C(0xdb)
	#define HWRM_PORT_CFG				UINT32_C(0xdc)
	#define HWRM_PORT_QCFG				UINT32_C(0xdd)
	/* Queries MAC capabilities for the specified port */
	#define HWRM_PORT_MAC_QCAPS			UINT32_C(0xdf)
	#define HWRM_TEMP_MONITOR_QUERY		UINT32_C(0xe0)
	#define HWRM_REG_POWER_QUERY			UINT32_C(0xe1)
	#define HWRM_CORE_FREQUENCY_QUERY		UINT32_C(0xe2)
	#define HWRM_REG_POWER_HISTOGRAM		UINT32_C(0xe3)
	#define HWRM_WOL_FILTER_ALLOC			UINT32_C(0xf0)
	#define HWRM_WOL_FILTER_FREE			UINT32_C(0xf1)
	#define HWRM_WOL_FILTER_QCFG			UINT32_C(0xf2)
	#define HWRM_WOL_REASON_QCFG			UINT32_C(0xf3)
	/* Experimental */
	#define HWRM_CFA_METER_QCAPS			UINT32_C(0xf4)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_ALLOC		UINT32_C(0xf5)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_FREE		UINT32_C(0xf6)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_CFG		UINT32_C(0xf7)
	/* Experimental */
	#define HWRM_CFA_METER_INSTANCE_ALLOC		UINT32_C(0xf8)
	/* Experimental */
	#define HWRM_CFA_METER_INSTANCE_FREE		UINT32_C(0xf9)
	/* Experimental */
	#define HWRM_CFA_METER_INSTANCE_CFG		UINT32_C(0xfa)
	/* Experimental */
	#define HWRM_CFA_VFR_ALLOC			UINT32_C(0xfd)
	/* Experimental */
	#define HWRM_CFA_VFR_FREE			UINT32_C(0xfe)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_ALLOC			UINT32_C(0x100)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_FREE			UINT32_C(0x101)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_INFO			UINT32_C(0x102)
	/* Experimental */
	#define HWRM_CFA_FLOW_ALLOC			UINT32_C(0x103)
	/* Experimental */
	#define HWRM_CFA_FLOW_FREE			UINT32_C(0x104)
	/* Experimental */
	#define HWRM_CFA_FLOW_FLUSH			UINT32_C(0x105)
	#define HWRM_CFA_FLOW_STATS			UINT32_C(0x106)
	#define HWRM_CFA_FLOW_INFO			UINT32_C(0x107)
	/* Experimental */
	#define HWRM_CFA_DECAP_FILTER_ALLOC		UINT32_C(0x108)
	/* Experimental */
	#define HWRM_CFA_DECAP_FILTER_FREE		UINT32_C(0x109)
	#define HWRM_CFA_VLAN_ANTISPOOF_QCFG		UINT32_C(0x10a)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC	UINT32_C(0x10b)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE	UINT32_C(0x10c)
	/* Experimental */
	#define HWRM_CFA_PAIR_ALLOC			UINT32_C(0x10d)
	/* Experimental */
	#define HWRM_CFA_PAIR_FREE			UINT32_C(0x10e)
	/* Experimental */
	#define HWRM_CFA_PAIR_INFO			UINT32_C(0x10f)
	/* Experimental */
	#define HWRM_FW_IPC_MSG			UINT32_C(0x110)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO	UINT32_C(0x111)
	#define HWRM_CFA_REDIRECT_QUERY_TUNNEL_TYPE	UINT32_C(0x112)
	/* Experimental */
	#define HWRM_CFA_FLOW_AGING_TIMER_RESET	UINT32_C(0x113)
	/* Experimental */
	#define HWRM_CFA_FLOW_AGING_CFG		UINT32_C(0x114)
	/* Experimental */
	#define HWRM_CFA_FLOW_AGING_QCFG		UINT32_C(0x115)
	/* Experimental */
	#define HWRM_CFA_FLOW_AGING_QCAPS		UINT32_C(0x116)
	/* Experimental */
	#define HWRM_CFA_CTX_MEM_RGTR			UINT32_C(0x117)
	/* Experimental */
	#define HWRM_CFA_CTX_MEM_UNRGTR		UINT32_C(0x118)
	/* Experimental */
	#define HWRM_CFA_CTX_MEM_QCTX			UINT32_C(0x119)
	/* Experimental */
	#define HWRM_CFA_CTX_MEM_QCAPS			UINT32_C(0x11a)
	/* Experimental */
	#define HWRM_CFA_COUNTER_QCAPS			UINT32_C(0x11b)
	/* Experimental */
	#define HWRM_CFA_COUNTER_CFG			UINT32_C(0x11c)
	/* Experimental */
	#define HWRM_CFA_COUNTER_QCFG			UINT32_C(0x11d)
	/* Experimental */
	#define HWRM_CFA_COUNTER_QSTATS		UINT32_C(0x11e)
	/* Experimental */
	#define HWRM_CFA_TCP_FLAG_PROCESS_QCFG		UINT32_C(0x11f)
	/* Experimental */
	#define HWRM_CFA_EEM_QCAPS			UINT32_C(0x120)
	/* Experimental */
	#define HWRM_CFA_EEM_CFG			UINT32_C(0x121)
	/* Experimental */
	#define HWRM_CFA_EEM_QCFG			UINT32_C(0x122)
	/* Experimental */
	#define HWRM_CFA_EEM_OP			UINT32_C(0x123)
	/* Experimental */
	#define HWRM_CFA_ADV_FLOW_MGNT_QCAPS		UINT32_C(0x124)
	/* Experimental - DEPRECATED */
	#define HWRM_CFA_TFLIB				UINT32_C(0x125)
	/* Experimental */
	#define HWRM_CFA_LAG_GROUP_MEMBER_RGTR		UINT32_C(0x126)
	/* Experimental */
	#define HWRM_CFA_LAG_GROUP_MEMBER_UNRGTR	UINT32_C(0x127)
	/* Experimental */
	#define HWRM_CFA_TLS_FILTER_ALLOC		UINT32_C(0x128)
	/* Experimental */
	#define HWRM_CFA_TLS_FILTER_FREE		UINT32_C(0x129)
	/* Release an AFM function for TF control */
	#define HWRM_CFA_RELEASE_AFM_FUNC		UINT32_C(0x12a)
	/*
	 * Engine CKV - Get the current allocation status of keys provisioned in
	 * the key vault.
	 */
	#define HWRM_ENGINE_CKV_STATUS			UINT32_C(0x12e)
	/* Engine CKV - Add a new CKEK used to encrypt keys. */
	#define HWRM_ENGINE_CKV_CKEK_ADD		UINT32_C(0x12f)
	/* Engine CKV - Delete a previously added CKEK. */
	#define HWRM_ENGINE_CKV_CKEK_DELETE		UINT32_C(0x130)
	/* Engine CKV - Add a new key to the key vault. */
	#define HWRM_ENGINE_CKV_KEY_ADD		UINT32_C(0x131)
	/* Engine CKV - Delete a key from the key vault. */
	#define HWRM_ENGINE_CKV_KEY_DELETE		UINT32_C(0x132)
	/* Engine CKV - Delete all keys from the key vault. */
	#define HWRM_ENGINE_CKV_FLUSH			UINT32_C(0x133)
	/* Engine CKV - Get random data. */
	#define HWRM_ENGINE_CKV_RNG_GET		UINT32_C(0x134)
	/* Engine CKV - Generate and encrypt a new AES key. */
	#define HWRM_ENGINE_CKV_KEY_GEN		UINT32_C(0x135)
	/* Engine CKV - Configure a label index with a label value. */
	#define HWRM_ENGINE_CKV_KEY_LABEL_CFG		UINT32_C(0x136)
	/* Engine CKV - Query a label */
	#define HWRM_ENGINE_CKV_KEY_LABEL_QCFG		UINT32_C(0x137)
	/* Engine - Query the available queue groups configuration. */
	#define HWRM_ENGINE_QG_CONFIG_QUERY		UINT32_C(0x13c)
	/* Engine - Query the queue groups assigned to a function. */
	#define HWRM_ENGINE_QG_QUERY			UINT32_C(0x13d)
	/* Engine - Query the available queue group meter profile configuration. */
	#define HWRM_ENGINE_QG_METER_PROFILE_CONFIG_QUERY UINT32_C(0x13e)
	/* Engine - Query the configuration of a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_QUERY	UINT32_C(0x13f)
	/* Engine - Allocate a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_ALLOC	UINT32_C(0x140)
	/* Engine - Free a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_FREE	UINT32_C(0x141)
	/* Engine - Query the meters assigned to a queue group. */
	#define HWRM_ENGINE_QG_METER_QUERY		UINT32_C(0x142)
	/* Engine - Bind a queue group meter profile to a queue group. */
	#define HWRM_ENGINE_QG_METER_BIND		UINT32_C(0x143)
	/* Engine - Unbind a queue group meter profile from a queue group. */
	#define HWRM_ENGINE_QG_METER_UNBIND		UINT32_C(0x144)
	/* Engine - Bind a queue group to a function. */
	#define HWRM_ENGINE_QG_FUNC_BIND		UINT32_C(0x145)
	/* Engine - Query the scheduling group configuration. */
	#define HWRM_ENGINE_SG_CONFIG_QUERY		UINT32_C(0x146)
	/* Engine - Query the queue groups assigned to a scheduling group. */
	#define HWRM_ENGINE_SG_QUERY			UINT32_C(0x147)
	/* Engine - Query the configuration of a scheduling group's meter profiles. */
	#define HWRM_ENGINE_SG_METER_QUERY		UINT32_C(0x148)
	/* Engine - Configure a scheduling group's meter profiles. */
	#define HWRM_ENGINE_SG_METER_CONFIG		UINT32_C(0x149)
	/* Engine - Bind a queue group to a scheduling group. */
	#define HWRM_ENGINE_SG_QG_BIND			UINT32_C(0x14a)
	/* Engine - Unbind a queue group from its scheduling group. */
	#define HWRM_ENGINE_QG_SG_UNBIND		UINT32_C(0x14b)
	/* Engine - Query the Engine configuration. */
	#define HWRM_ENGINE_CONFIG_QUERY		UINT32_C(0x154)
	/* Engine - Configure the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_CONFIG		UINT32_C(0x155)
	/* Engine - Clear the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_CLEAR		UINT32_C(0x156)
	/* Engine - Query the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_QUERY		UINT32_C(0x157)
	/*
	 * Engine - Query statistics counters for continuous errors from all CDDIP
	 * Engines.
	 */
	#define HWRM_ENGINE_STATS_QUERY_CONTINUOUS_ERROR  UINT32_C(0x158)
	/* Engine - Allocate an Engine RQ. */
	#define HWRM_ENGINE_RQ_ALLOC			UINT32_C(0x15e)
	/* Engine - Free an Engine RQ. */
	#define HWRM_ENGINE_RQ_FREE			UINT32_C(0x15f)
	/* Engine - Allocate an Engine CQ. */
	#define HWRM_ENGINE_CQ_ALLOC			UINT32_C(0x160)
	/* Engine - Free an Engine CQ. */
	#define HWRM_ENGINE_CQ_FREE			UINT32_C(0x161)
	/* Engine - Allocate an NQ. */
	#define HWRM_ENGINE_NQ_ALLOC			UINT32_C(0x162)
	/* Engine - Free an NQ. */
	#define HWRM_ENGINE_NQ_FREE			UINT32_C(0x163)
	/* Engine - Set the on-die RQE credit update location. */
	#define HWRM_ENGINE_ON_DIE_RQE_CREDITS		UINT32_C(0x164)
	/* Engine - Query the engine function configuration. */
	#define HWRM_ENGINE_FUNC_QCFG			UINT32_C(0x165)
	/* Experimental */
	#define HWRM_FUNC_RESOURCE_QCAPS		UINT32_C(0x190)
	/* Experimental */
	#define HWRM_FUNC_VF_RESOURCE_CFG		UINT32_C(0x191)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_QCAPS		UINT32_C(0x192)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_CFG		UINT32_C(0x193)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_QCFG		UINT32_C(0x194)
	/* Configures the BW of any VF */
	#define HWRM_FUNC_VF_BW_CFG			UINT32_C(0x195)
	/* Queries the BW of any VF */
	#define HWRM_FUNC_VF_BW_QCFG			UINT32_C(0x196)
	/* Queries pf ids belong to specified host(s) */
	#define HWRM_FUNC_HOST_PF_IDS_QUERY		UINT32_C(0x197)
	/* Queries extended stats per function */
	#define HWRM_FUNC_QSTATS_EXT			UINT32_C(0x198)
	/* Queries extended statistics context */
	#define HWRM_STAT_EXT_CTX_QUERY		UINT32_C(0x199)
	/* Configure SoC packet DMA settings */
	#define HWRM_FUNC_SPD_CFG			UINT32_C(0x19a)
	/* Query SoC packet DMA settings */
	#define HWRM_FUNC_SPD_QCFG			UINT32_C(0x19b)
	/* PTP - Queries configuration of timesync IO pins. */
	#define HWRM_FUNC_PTP_PIN_QCFG			UINT32_C(0x19c)
	/* PTP - Configuration of timesync IO pins. */
	#define HWRM_FUNC_PTP_PIN_CFG			UINT32_C(0x19d)
	/* PTP - Configuration for disciplining PHC. */
	#define HWRM_FUNC_PTP_CFG			UINT32_C(0x19e)
	/* PTP - Queries for PHC timestamps. */
	#define HWRM_FUNC_PTP_TS_QUERY			UINT32_C(0x19f)
	/* PTP - Extended PTP configuration. */
	#define HWRM_FUNC_PTP_EXT_CFG			UINT32_C(0x1a0)
	/* PTP - Query extended PTP configuration. */
	#define HWRM_FUNC_PTP_EXT_QCFG			UINT32_C(0x1a1)
	/* The command is used to allocate KTLS or QUIC key contexts. */
	#define HWRM_FUNC_KEY_CTX_ALLOC		UINT32_C(0x1a2)
	/* The is the new API to configure backing stores. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2		UINT32_C(0x1a3)
	/* The is the new API to query backing store configurations. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2	UINT32_C(0x1a4)
	/* To support doorbell pacing configuration. */
	#define HWRM_FUNC_DBR_PACING_CFG		UINT32_C(0x1a5)
	/* To query doorbell pacing configuration. */
	#define HWRM_FUNC_DBR_PACING_QCFG		UINT32_C(0x1a6)
	/*
	 * To broadcast the doorbell event to the drivers to
	 * initiate pacing of doorbells.
	 */
	#define HWRM_FUNC_DBR_PACING_BROADCAST_EVENT	UINT32_C(0x1a7)
	/* The is the new API to query backing store capabilities. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2	UINT32_C(0x1a8)
	/* To query doorbell pacing NQ id list configuration. */
	#define HWRM_FUNC_DBR_PACING_NQLIST_QUERY	UINT32_C(0x1a9)
	/*
	 * To notify the firmware that recovery cycle has been
	 * completed by host function drivers.
	 */
	#define HWRM_FUNC_DBR_RECOVERY_COMPLETED	UINT32_C(0x1aa)
	/* Configures SyncE configurations. */
	#define HWRM_FUNC_SYNCE_CFG			UINT32_C(0x1ab)
	/* Queries SyncE configurations. */
	#define HWRM_FUNC_SYNCE_QCFG			UINT32_C(0x1ac)
	/* The command is used to deallocate KTLS or QUIC key contexts. */
	#define HWRM_FUNC_KEY_CTX_FREE			UINT32_C(0x1ad)
	/* The command is used to configure link aggr group mode. */
	#define HWRM_FUNC_LAG_MODE_CFG			UINT32_C(0x1ae)
	/* The command is used to query link aggr group mode. */
	#define HWRM_FUNC_LAG_MODE_QCFG		UINT32_C(0x1af)
	/* The command is used to create a link aggr group. */
	#define HWRM_FUNC_LAG_CREATE			UINT32_C(0x1b0)
	/* The command is used to update a link aggr group. */
	#define HWRM_FUNC_LAG_UPDATE			UINT32_C(0x1b1)
	/* The command is used to free a link aggr group. */
	#define HWRM_FUNC_LAG_FREE			UINT32_C(0x1b2)
	/* The command is used to query a link aggr group. */
	#define HWRM_FUNC_LAG_QCFG			UINT32_C(0x1b3)
	/* This command is use to add TimeTX packet pacing rate. */
	#define HWRM_FUNC_TIMEDTX_PACING_RATE_ADD	UINT32_C(0x1c2)
	/*
	 * This command is use to delete TimeTX packet pacing rate
	 * from the rate table.
	 */
	#define HWRM_FUNC_TIMEDTX_PACING_RATE_DELETE	UINT32_C(0x1c3)
	/*
	 * This command is used to retrieve all the TimeTX pacing rates
	 * from the rate table that have been added for the function.
	 */
	#define HWRM_FUNC_TIMEDTX_PACING_RATE_QUERY	UINT32_C(0x1c4)
	/* Experimental */
	#define HWRM_SELFTEST_QLIST			UINT32_C(0x200)
	/* Experimental */
	#define HWRM_SELFTEST_EXEC			UINT32_C(0x201)
	/* Experimental */
	#define HWRM_SELFTEST_IRQ			UINT32_C(0x202)
	/* Experimental (deprecated) */
	#define HWRM_SELFTEST_RETRIEVE_SERDES_DATA	UINT32_C(0x203)
	/* Experimental */
	#define HWRM_PCIE_QSTATS			UINT32_C(0x204)
	/* Experimental */
	#define HWRM_MFG_FRU_WRITE_CONTROL		UINT32_C(0x205)
	/* Returns the current value of a free running counter from the device. */
	#define HWRM_MFG_TIMERS_QUERY			UINT32_C(0x206)
	/* Experimental */
	#define HWRM_MFG_OTP_CFG			UINT32_C(0x207)
	/* Experimental */
	#define HWRM_MFG_OTP_QCFG			UINT32_C(0x208)
	/*
	 * Tells the fw to run the DMA read from the host and DMA write
	 * to the host test.
	 */
	#define HWRM_MFG_HDMA_TEST			UINT32_C(0x209)
	/* Tells the fw to program the fru memory */
	#define HWRM_MFG_FRU_EEPROM_WRITE		UINT32_C(0x20a)
	/* Tells the fw to read the fru memory */
	#define HWRM_MFG_FRU_EEPROM_READ		UINT32_C(0x20b)
	/* Used to provision SoC software images */
	#define HWRM_MFG_SOC_IMAGE			UINT32_C(0x20c)
	/* Retrieves the SoC status and image provisioning information */
	#define HWRM_MFG_SOC_QSTATUS			UINT32_C(0x20d)
	/* Tells the fw to finalize the critical data (store and lock it) */
	#define HWRM_MFG_PARAM_CRITICAL_DATA_FINALIZE	UINT32_C(0x20e)
	/* Tells the fw to read the critical data */
	#define HWRM_MFG_PARAM_CRITICAL_DATA_READ	UINT32_C(0x20f)
	/* Tells the fw to get the health of critical data */
	#define HWRM_MFG_PARAM_CRITICAL_DATA_HEALTH	UINT32_C(0x210)
	/*
	 * The command is used for certificate provisioning to export a
	 * Certificate Signing Request (CSR) from the device.
	 */
	#define HWRM_MFG_PRVSN_EXPORT_CSR		UINT32_C(0x211)
	/*
	 * The command is used for certificate provisioning to import a
	 * CA-signed certificate chain to the device.
	 */
	#define HWRM_MFG_PRVSN_IMPORT_CERT		UINT32_C(0x212)
	/*
	 * The command is used for certificate provisioning to query the
	 * provisioned state.
	 */
	#define HWRM_MFG_PRVSN_GET_STATE		UINT32_C(0x213)
	/*
	 * The command is used to get the hash of the NVM configuration that is
	 * calculated during firmware boot.
	 */
	#define HWRM_MFG_GET_NVM_MEASUREMENT		UINT32_C(0x214)
	/* Retrieves the PSOC status and provisioning information. */
	#define HWRM_MFG_PSOC_QSTATUS			UINT32_C(0x215)
	/*
	 * This command allows manufacturing tool to determine which selftests
	 * are available to be run.
	 */
	#define HWRM_MFG_SELFTEST_QLIST		UINT32_C(0x216)
	/*
	 * This command allows manufacturing tool to request which selftests
	 * to run.
	 */
	#define HWRM_MFG_SELFTEST_EXEC			UINT32_C(0x217)
	/* Queries the generic stats */
	#define HWRM_STAT_GENERIC_QSTATS		UINT32_C(0x218)
	/*
	 * The command is used for certificate provisioning to export a
	 * certificate chain from the device.
	 */
	#define HWRM_MFG_PRVSN_EXPORT_CERT		UINT32_C(0x219)
	/* Query the statistics for doorbell drops due to various error conditions. */
	#define HWRM_STAT_DB_ERROR_QSTATS		UINT32_C(0x21a)
	/*
	 * The command is used to enable/disable the power on ethernet for
	 * a particular I/O expander port.
	 */
	#define HWRM_PORT_POE_CFG			UINT32_C(0x230)
	/*
	 * The command is used to query whether the power on ethernet
	 * is enabled/disabled for a particular I/O expander port.
	 */
	#define HWRM_PORT_POE_QCFG			UINT32_C(0x231)
	/*
	 * This command returns the capabilities related to User Defined
	 * Congestion Control on a function.
	 */
	#define HWRM_UDCC_QCAPS			UINT32_C(0x258)
	/* This command configures User Defined Congestion Control on a function. */
	#define HWRM_UDCC_CFG				UINT32_C(0x259)
	/*
	 * This command queries the configuration of User Defined Congestion
	 * Control on a function.
	 */
	#define HWRM_UDCC_QCFG				UINT32_C(0x25a)
	/* This command configures an existing UDCC session. */
	#define HWRM_UDCC_SESSION_CFG			UINT32_C(0x25b)
	/* This command queries the configuration of a UDCC session. */
	#define HWRM_UDCC_SESSION_QCFG			UINT32_C(0x25c)
	/* This command queries the UDCC session. */
	#define HWRM_UDCC_SESSION_QUERY		UINT32_C(0x25d)
	/* This command configures the computation unit. */
	#define HWRM_UDCC_COMP_CFG			UINT32_C(0x25e)
	/* This command queries the configuration of the computation unit. */
	#define HWRM_UDCC_COMP_QCFG			UINT32_C(0x25f)
	/* This command queries the status and statistics of the computation unit. */
	#define HWRM_UDCC_COMP_QUERY			UINT32_C(0x260)
	/*
	 * This command is used to query the pfc watchdog max configurable
	 * timeout value.
	 */
	#define HWRM_QUEUE_PFCWD_TIMEOUT_QCAPS		UINT32_C(0x261)
	/* This command is used to set the PFC watchdog timeout value. */
	#define HWRM_QUEUE_PFCWD_TIMEOUT_CFG		UINT32_C(0x262)
	/*
	 * This command is used to query the current configured pfc watchdog
	 * timeout value.
	 */
	#define HWRM_QUEUE_PFCWD_TIMEOUT_QCFG		UINT32_C(0x263)
	/* Experimental */
	#define HWRM_TF				UINT32_C(0x2bc)
	/* Experimental */
	#define HWRM_TF_VERSION_GET			UINT32_C(0x2bd)
	/* Experimental */
	#define HWRM_TF_SESSION_OPEN			UINT32_C(0x2c6)
	/* Experimental */
	#define HWRM_TF_SESSION_REGISTER		UINT32_C(0x2c8)
	/* Experimental */
	#define HWRM_TF_SESSION_UNREGISTER		UINT32_C(0x2c9)
	/* Experimental */
	#define HWRM_TF_SESSION_CLOSE			UINT32_C(0x2ca)
	/* Experimental */
	#define HWRM_TF_SESSION_QCFG			UINT32_C(0x2cb)
	/* Experimental */
	#define HWRM_TF_SESSION_RESC_QCAPS		UINT32_C(0x2cc)
	/* Experimental */
	#define HWRM_TF_SESSION_RESC_ALLOC		UINT32_C(0x2cd)
	/* Experimental */
	#define HWRM_TF_SESSION_RESC_FREE		UINT32_C(0x2ce)
	/* Experimental */
	#define HWRM_TF_SESSION_RESC_FLUSH		UINT32_C(0x2cf)
	/* Experimental */
	#define HWRM_TF_SESSION_RESC_INFO		UINT32_C(0x2d0)
	/* Experimental */
	#define HWRM_TF_SESSION_HOTUP_STATE_SET	UINT32_C(0x2d1)
	/* Experimental */
	#define HWRM_TF_SESSION_HOTUP_STATE_GET	UINT32_C(0x2d2)
	/* Experimental */
	#define HWRM_TF_TBL_TYPE_GET			UINT32_C(0x2da)
	/* Experimental */
	#define HWRM_TF_TBL_TYPE_SET			UINT32_C(0x2db)
	/* Experimental */
	#define HWRM_TF_TBL_TYPE_BULK_GET		UINT32_C(0x2dc)
	/* Experimental */
	#define HWRM_TF_EM_INSERT			UINT32_C(0x2ea)
	/* Experimental */
	#define HWRM_TF_EM_DELETE			UINT32_C(0x2eb)
	/* Experimental */
	#define HWRM_TF_EM_HASH_INSERT			UINT32_C(0x2ec)
	/* Experimental */
	#define HWRM_TF_EM_MOVE			UINT32_C(0x2ed)
	/* Experimental */
	#define HWRM_TF_TCAM_SET			UINT32_C(0x2f8)
	/* Experimental */
	#define HWRM_TF_TCAM_GET			UINT32_C(0x2f9)
	/* Experimental */
	#define HWRM_TF_TCAM_MOVE			UINT32_C(0x2fa)
	/* Experimental */
	#define HWRM_TF_TCAM_FREE			UINT32_C(0x2fb)
	/* Experimental */
	#define HWRM_TF_GLOBAL_CFG_SET			UINT32_C(0x2fc)
	/* Experimental */
	#define HWRM_TF_GLOBAL_CFG_GET			UINT32_C(0x2fd)
	/* Experimental */
	#define HWRM_TF_IF_TBL_SET			UINT32_C(0x2fe)
	/* Experimental */
	#define HWRM_TF_IF_TBL_GET			UINT32_C(0x2ff)
	/* Experimental */
	#define HWRM_TF_RESC_USAGE_SET			UINT32_C(0x300)
	/* Experimental */
	#define HWRM_TF_RESC_USAGE_QUERY		UINT32_C(0x301)
	/* Truflow command to allocate a table */
	#define HWRM_TF_TBL_TYPE_ALLOC			UINT32_C(0x302)
	/* Truflow command to free a table */
	#define HWRM_TF_TBL_TYPE_FREE			UINT32_C(0x303)
	/* TruFlow command to check firmware table scope capabilities. */
	#define HWRM_TFC_TBL_SCOPE_QCAPS		UINT32_C(0x380)
	/* TruFlow command to allocate a table scope ID and create the pools. */
	#define HWRM_TFC_TBL_SCOPE_ID_ALLOC		UINT32_C(0x381)
	/* TruFlow command to configure the table scope memory. */
	#define HWRM_TFC_TBL_SCOPE_CONFIG		UINT32_C(0x382)
	/* TruFlow command to deconfigure a table scope memory. */
	#define HWRM_TFC_TBL_SCOPE_DECONFIG		UINT32_C(0x383)
	/* TruFlow command to add a FID to a table scope. */
	#define HWRM_TFC_TBL_SCOPE_FID_ADD		UINT32_C(0x384)
	/* TruFlow command to remove a FID from a table scope. */
	#define HWRM_TFC_TBL_SCOPE_FID_REM		UINT32_C(0x385)
	/* DEPRECATED */
	#define HWRM_TFC_TBL_SCOPE_POOL_ALLOC		UINT32_C(0x386)
	/* DEPRECATED */
	#define HWRM_TFC_TBL_SCOPE_POOL_FREE		UINT32_C(0x387)
	/* Experimental */
	#define HWRM_TFC_SESSION_ID_ALLOC		UINT32_C(0x388)
	/* Experimental */
	#define HWRM_TFC_SESSION_FID_ADD		UINT32_C(0x389)
	/* Experimental */
	#define HWRM_TFC_SESSION_FID_REM		UINT32_C(0x38a)
	/* Experimental */
	#define HWRM_TFC_IDENT_ALLOC			UINT32_C(0x38b)
	/* Experimental */
	#define HWRM_TFC_IDENT_FREE			UINT32_C(0x38c)
	/* TruFlow command to allocate an index table entry */
	#define HWRM_TFC_IDX_TBL_ALLOC			UINT32_C(0x38d)
	/* TruFlow command to allocate and set an index table entry */
	#define HWRM_TFC_IDX_TBL_ALLOC_SET		UINT32_C(0x38e)
	/* TruFlow command to set an index table entry */
	#define HWRM_TFC_IDX_TBL_SET			UINT32_C(0x38f)
	/* TruFlow command to get an index table entry */
	#define HWRM_TFC_IDX_TBL_GET			UINT32_C(0x390)
	/* TruFlow command to free an index table entry */
	#define HWRM_TFC_IDX_TBL_FREE			UINT32_C(0x391)
	/* TruFlow command to allocate resources for a global id. */
	#define HWRM_TFC_GLOBAL_ID_ALLOC		UINT32_C(0x392)
	/* TruFlow command to set TCAM entry. */
	#define HWRM_TFC_TCAM_SET			UINT32_C(0x393)
	/* TruFlow command to get TCAM entry. */
	#define HWRM_TFC_TCAM_GET			UINT32_C(0x394)
	/* TruFlow command to allocate a TCAM entry. */
	#define HWRM_TFC_TCAM_ALLOC			UINT32_C(0x395)
	/* TruFlow command allocate and set TCAM entry. */
	#define HWRM_TFC_TCAM_ALLOC_SET		UINT32_C(0x396)
	/* TruFlow command to free a TCAM entry. */
	#define HWRM_TFC_TCAM_FREE			UINT32_C(0x397)
	/* Truflow command to set an interface table entry */
	#define HWRM_TFC_IF_TBL_SET			UINT32_C(0x398)
	/* Truflow command to get an interface table entry */
	#define HWRM_TFC_IF_TBL_GET			UINT32_C(0x399)
	/* TruFlow command to get configured info about a table scope. */
	#define HWRM_TFC_TBL_SCOPE_CONFIG_GET		UINT32_C(0x39a)
	/* TruFlow command to query the resource usage state. */
	#define HWRM_TFC_RESC_USAGE_QUERY		UINT32_C(0x39b)
	/* Experimental */
	#define HWRM_SV				UINT32_C(0x400)
	/* Run a PCIe or Ethernet serdes test and retrieve test data. */
	#define HWRM_DBG_SERDES_TEST			UINT32_C(0xff0e)
	/* Flush any trace buffer data that has not been sent to the host. */
	#define HWRM_DBG_LOG_BUFFER_FLUSH		UINT32_C(0xff0f)
	/* Experimental */
	#define HWRM_DBG_READ_DIRECT			UINT32_C(0xff10)
	/* Experimental */
	#define HWRM_DBG_READ_INDIRECT			UINT32_C(0xff11)
	/* Experimental */
	#define HWRM_DBG_WRITE_DIRECT			UINT32_C(0xff12)
	/* Experimental */
	#define HWRM_DBG_WRITE_INDIRECT		UINT32_C(0xff13)
	#define HWRM_DBG_DUMP				UINT32_C(0xff14)
	/* Experimental */
	#define HWRM_DBG_ERASE_NVM			UINT32_C(0xff15)
	/* Experimental */
	#define HWRM_DBG_CFG				UINT32_C(0xff16)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_LIST			UINT32_C(0xff17)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_INITIATE		UINT32_C(0xff18)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_RETRIEVE		UINT32_C(0xff19)
	/* Experimental */
	#define HWRM_DBG_FW_CLI			UINT32_C(0xff1a)
	/*  */
	#define HWRM_DBG_I2C_CMD			UINT32_C(0xff1b)
	/*  */
	#define HWRM_DBG_RING_INFO_GET			UINT32_C(0xff1c)
	/* Experimental */
	#define HWRM_DBG_CRASHDUMP_HEADER		UINT32_C(0xff1d)
	/* Experimental */
	#define HWRM_DBG_CRASHDUMP_ERASE		UINT32_C(0xff1e)
	/* Send driver debug information to firmware */
	#define HWRM_DBG_DRV_TRACE			UINT32_C(0xff1f)
	/* Query debug capabilities of firmware */
	#define HWRM_DBG_QCAPS				UINT32_C(0xff20)
	/* Retrieve debug settings of firmware */
	#define HWRM_DBG_QCFG				UINT32_C(0xff21)
	/* Set destination parameters for crashdump medium */
	#define HWRM_DBG_CRASHDUMP_MEDIUM_CFG		UINT32_C(0xff22)
	/* Experimental */
	#define HWRM_DBG_USEQ_ALLOC			UINT32_C(0xff23)
	/* Experimental */
	#define HWRM_DBG_USEQ_FREE			UINT32_C(0xff24)
	/* Experimental */
	#define HWRM_DBG_USEQ_FLUSH			UINT32_C(0xff25)
	/* Experimental */
	#define HWRM_DBG_USEQ_QCAPS			UINT32_C(0xff26)
	/* Experimental */
	#define HWRM_DBG_USEQ_CW_CFG			UINT32_C(0xff27)
	/* Experimental */
	#define HWRM_DBG_USEQ_SCHED_CFG		UINT32_C(0xff28)
	/* Experimental */
	#define HWRM_DBG_USEQ_RUN			UINT32_C(0xff29)
	/* Experimental */
	#define HWRM_DBG_USEQ_DELIVERY_REQ		UINT32_C(0xff2a)
	/* Experimental */
	#define HWRM_DBG_USEQ_RESP_HDR			UINT32_C(0xff2b)
	/*
	 * This command is used to request the firmware to store a coredump
	 * into Host memory previously specified with the
	 * HWRM_DBG_CRASHDUMP_MEDIUM_CFG API
	 */
	#define HWRM_DBG_COREDUMP_CAPTURE		UINT32_C(0xff2c)
	#define HWRM_DBG_PTRACE			UINT32_C(0xff2d)
	/*
	 * This command is used to request the firmware to simulate cable insert
	 * or removal.
	 */
	#define HWRM_DBG_SIM_CABLE_STATE		UINT32_C(0xff2e)
	#define HWRM_NVM_GET_VPD_FIELD_INFO		UINT32_C(0xffea)
	#define HWRM_NVM_SET_VPD_FIELD_INFO		UINT32_C(0xffeb)
	#define HWRM_NVM_DEFRAG			UINT32_C(0xffec)
	#define HWRM_NVM_REQ_ARBITRATION		UINT32_C(0xffed)
	/* Experimental */
	#define HWRM_NVM_FACTORY_DEFAULTS		UINT32_C(0xffee)
	#define HWRM_NVM_VALIDATE_OPTION		UINT32_C(0xffef)
	#define HWRM_NVM_FLUSH				UINT32_C(0xfff0)
	#define HWRM_NVM_GET_VARIABLE			UINT32_C(0xfff1)
	#define HWRM_NVM_SET_VARIABLE			UINT32_C(0xfff2)
	#define HWRM_NVM_INSTALL_UPDATE		UINT32_C(0xfff3)
	#define HWRM_NVM_MODIFY			UINT32_C(0xfff4)
	#define HWRM_NVM_VERIFY_UPDATE			UINT32_C(0xfff5)
	#define HWRM_NVM_GET_DEV_INFO			UINT32_C(0xfff6)
	#define HWRM_NVM_ERASE_DIR_ENTRY		UINT32_C(0xfff7)
	#define HWRM_NVM_MOD_DIR_ENTRY			UINT32_C(0xfff8)
	#define HWRM_NVM_FIND_DIR_ENTRY		UINT32_C(0xfff9)
	#define HWRM_NVM_GET_DIR_ENTRIES		UINT32_C(0xfffa)
	#define HWRM_NVM_GET_DIR_INFO			UINT32_C(0xfffb)
	#define HWRM_NVM_RAW_DUMP			UINT32_C(0xfffc)
	#define HWRM_NVM_READ				UINT32_C(0xfffd)
	#define HWRM_NVM_WRITE				UINT32_C(0xfffe)
	#define HWRM_NVM_RAW_WRITE_BLK			UINT32_C(0xffff)
	#define HWRM_LAST				HWRM_NVM_RAW_WRITE_BLK
	uint16_t	unused_0[3];
} __attribute__((packed));

/* Return Codes */
/* ret_codes (size:64b/8B) */

struct ret_codes {
	uint16_t	error_code;
	/* Request was successfully executed by the HWRM. */
	#define HWRM_ERR_CODE_SUCCESS			UINT32_C(0x0)
	/* The HWRM failed to execute the request. */
	#define HWRM_ERR_CODE_FAIL			UINT32_C(0x1)
	/*
	 * The request contains invalid argument(s) or input
	 * parameters.
	 */
	#define HWRM_ERR_CODE_INVALID_PARAMS		UINT32_C(0x2)
	/*
	 * The requester is not allowed to access the requested
	 * resource. This error code shall be provided in a
	 * response to a request to query or modify an existing
	 * resource that is not accessible by the requester.
	 */
	#define HWRM_ERR_CODE_RESOURCE_ACCESS_DENIED	UINT32_C(0x3)
	/*
	 * The HWRM is unable to allocate the requested resource.
	 * This code only applies to requests for HWRM resource
	 * allocations.
	 */
	#define HWRM_ERR_CODE_RESOURCE_ALLOC_ERROR	UINT32_C(0x4)
	/*
	 * Invalid combination of flags is specified in the
	 * request.
	 */
	#define HWRM_ERR_CODE_INVALID_FLAGS		UINT32_C(0x5)
	/*
	 * Invalid combination of enables fields is specified in
	 * the request.
	 */
	#define HWRM_ERR_CODE_INVALID_ENABLES		UINT32_C(0x6)
	/*
	 * Request contains a required TLV that is not supported by
	 * the installed version of firmware.
	 */
	#define HWRM_ERR_CODE_UNSUPPORTED_TLV		UINT32_C(0x7)
	/*
	 * No firmware buffer available to accept the request. Driver
	 * should retry the request.
	 */
	#define HWRM_ERR_CODE_NO_BUFFER			UINT32_C(0x8)
	/*
	 * This error code is only reported by firmware when some
	 * sub-option of a supported HWRM command is unsupported.
	 */
	#define HWRM_ERR_CODE_UNSUPPORTED_OPTION_ERR	UINT32_C(0x9)
	/*
	 * This error code is only reported by firmware when the specific
	 * request is not able to process when the HOT reset in progress.
	 */
	#define HWRM_ERR_CODE_HOT_RESET_PROGRESS	UINT32_C(0xa)
	/*
	 * This error code is only reported by firmware when the registered
	 * driver instances are not capable of hot reset.
	 */
	#define HWRM_ERR_CODE_HOT_RESET_FAIL		UINT32_C(0xb)
	/*
	 * This error code is only reported by the firmware when during
	 * flow allocation when a request for a flow counter fails because
	 * the number of flow counters are exhausted.
	 */
	#define HWRM_ERR_CODE_NO_FLOW_COUNTER_DURING_ALLOC UINT32_C(0xc)
	/*
	 * This error code is only reported by firmware when the registered
	 * driver instances requested to offloaded a flow but was unable to
	 * because the requested key's hash collides with the installed keys.
	 */
	#define HWRM_ERR_CODE_KEY_HASH_COLLISION	UINT32_C(0xd)
	/*
	 * This error code is only reported by firmware when the registered
	 * driver instances requested to offloaded a flow but was unable to
	 * because the same key has already been installed.
	 */
	#define HWRM_ERR_CODE_KEY_ALREADY_EXISTS	UINT32_C(0xe)
	/*
	 * Generic HWRM execution error that represents an
	 * internal error.
	 */
	#define HWRM_ERR_CODE_HWRM_ERROR		UINT32_C(0xf)
	/*
	 * Firmware is unable to service the request at the present time.
	 * Caller may try again later.
	 */
	#define HWRM_ERR_CODE_BUSY			UINT32_C(0x10)
	/*
	 * This error code is reported by Firmware when an operation requested
	 * by the host is not allowed due to a secure lock violation.
	 */
	#define HWRM_ERR_CODE_RESOURCE_LOCKED		UINT32_C(0x11)
	/*
	 * This error code is reported by Firmware when an operation requested
	 * by a VF cannot be forwarded to the parent PF as required, either
	 * because the PF is down or otherwise doesn't have an appropriate
	 * async completion ring or associated forwarding buffers configured.
	 */
	#define HWRM_ERR_CODE_PF_UNAVAILABLE		UINT32_C(0x12)
	/*
	 * This error code is reported by Firmware when the specific entity
	 * requested by the host is not present or does not exist.
	 */
	#define HWRM_ERR_CODE_ENTITY_NOT_PRESENT	UINT32_C(0x13)
	/*
	 * This value indicates that the HWRM response is in TLV format and
	 * should be interpreted as one or more TLVs starting with the
	 * hwrm_resp_hdr TLV. This value is not an indication of any error
	 * by itself, just an indication that the response should be parsed
	 * as TLV and the actual error code will be in the hwrm_resp_hdr TLV.
	 */
	#define HWRM_ERR_CODE_TLV_ENCAPSULATED_RESPONSE	UINT32_C(0x8000)
	/* Unknown error */
	#define HWRM_ERR_CODE_UNKNOWN_ERR		UINT32_C(0xfffe)
	/* Unsupported or invalid command */
	#define HWRM_ERR_CODE_CMD_NOT_SUPPORTED		UINT32_C(0xffff)
	#define HWRM_ERR_CODE_LAST			HWRM_ERR_CODE_CMD_NOT_SUPPORTED
	uint16_t	unused_0[3];
} __attribute__((packed));

#define GET_HWRM_ERROR_CODE(x) \
	(((x) < 0x80) ? \
	((x) == 0x0 ? "SUCCESS": \
	((x) == 0x1 ? "FAIL": \
	((x) == 0x2 ? "INVALID_PARAMS": \
	((x) == 0x3 ? "RESOURCE_ACCESS_DENIED": \
	((x) == 0x4 ? "RESOURCE_ALLOC_ERROR": \
	((x) == 0x5 ? "INVALID_FLAGS": \
	((x) == 0x6 ? "INVALID_ENABLES": \
	((x) == 0x7 ? "UNSUPPORTED_TLV": \
	((x) == 0x8 ? "NO_BUFFER": \
	((x) == 0x9 ? "UNSUPPORTED_OPTION_ERR": \
	((x) == 0xa ? "HOT_RESET_PROGRESS": \
	((x) == 0xb ? "HOT_RESET_FAIL": \
	((x) == 0xc ? "NO_FLOW_COUNTER_DURING_ALLOC": \
	((x) == 0xd ? "KEY_HASH_COLLISION": \
	((x) == 0xe ? "KEY_ALREADY_EXISTS": \
	((x) == 0xf ? "HWRM_ERROR": \
	((x) == 0x10 ? "BUSY": \
	((x) == 0x11 ? "RESOURCE_LOCKED": \
	((x) == 0x12 ? "PF_UNAVAILABLE": \
	((x) == 0x13 ? "ENTITY_NOT_PRESENT": \
	"Unknown decode" )))))))))))))))))))) : \
	(((x) < 0x8080) ? \
	((x) == 0x8000 ? "TLV_ENCAPSULATED_RESPONSE": \
	"Unknown decode" ) : \
	(((x) <= UINT16_MAX) ? \
	((x) == 0xfffe ? "UNKNOWN_ERR": \
	((x) == 0xffff ? "CMD_NOT_SUPPORTED": \
	"Unknown decode" )) : \
	"Unknown decode" )))


/* Output */
/* hwrm_err_output (size:128b/16B) */

struct hwrm_err_output {
	/*
	 * Pass/Fail or error type
	 *
	 * Note: receiver to verify the in parameters, and fail the call
	 * with an error when appropriate
	 */
	uint16_t	error_code;
	/* This field returns the type of original request. */
	uint16_t	req_type;
	/* This field provides original sequence number of the command. */
	uint16_t	seq_id;
	/*
	 * This field is the length of the response in bytes. The
	 * last byte of the response is a valid flag that will read
	 * as '1' when the command has been completely written to
	 * memory.
	 */
	uint16_t	resp_len;
	/* debug info for this error response. */
	uint32_t	opaque_0;
	/* debug info for this error response. */
	uint16_t	opaque_1;
	/*
	 * In the case of an error response, command specific error
	 * code is returned in this field.
	 */
	uint8_t	cmd_err;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*
 * Following is the signature for HWRM message field that indicates not
 * applicable (All F's). Need to cast it the size of the field if needed.
 */
#define HWRM_NA_SIGNATURE ((uint32_t)(-1))
/*
 * This is reflecting the size of the PF mailbox and not the maximum
 * command size for any of the HWRM command structures. To determine
 * the maximum size of an HWRM command supported by the firmware, see
 * the max_ext_req_len field in the response of the HWRM_VER_GET command.
 */
#define HWRM_MAX_REQ_LEN 128
/* hwrm_cfa_flow_info */
#define HWRM_MAX_RESP_LEN 704
/* 7 bit indirection table index. */
#define HW_HASH_INDEX_SIZE 0x80
#define HW_HASH_KEY_SIZE 40
/* valid key for HWRM response */
#define HWRM_RESP_VALID_KEY 1
/* Reserved for BONO processor */
#define HWRM_TARGET_ID_BONO 0xFFF8
/* Reserved for KONG processor */
#define HWRM_TARGET_ID_KONG 0xFFF9
/* Reserved for APE processor */
#define HWRM_TARGET_ID_APE 0xFFFA
/*
 * This value will be used by tools for User-space HWRM Interface.
 * When tool execute any HWRM command with this target_id, firmware
 * will copy the response and/or data payload via register space instead
 * of DMAing it.
 */
#define HWRM_TARGET_ID_TOOLS 0xFFFD
#define HWRM_VERSION_MAJOR 1
#define HWRM_VERSION_MINOR 10
#define HWRM_VERSION_UPDATE 3
/* non-zero means beta version */
#define HWRM_VERSION_RSVD 61
#define HWRM_VERSION_STR "1.10.3.61"

/****************
 * hwrm_ver_get *
 ****************/


/* hwrm_ver_get_input (size:192b/24B) */

struct hwrm_ver_get_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification.
	 */
	uint8_t	hwrm_intf_maj;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification.
	 * This can be due to addition or removal of functionality.
	 * HWRM interface specifications with the same major version
	 * but different minor versions are compatible.
	 */
	uint8_t	hwrm_intf_min;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * The interface update version is used to reflect minor
	 * changes or bug fixes to a released HWRM interface
	 * specification.
	 */
	uint8_t	hwrm_intf_upd;
	uint8_t	unused_0[5];
} __attribute__((packed));

/* hwrm_ver_get_output (size:1408b/176B) */

struct hwrm_ver_get_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 1 in this field.
	 */
	uint8_t	hwrm_intf_maj_8b;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification.
	 * This can be due to addition or removal of functionality.
	 * HWRM interface specifications with the same major version
	 * but different minor versions are compatible.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint8_t	hwrm_intf_min_8b;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface update version is used to reflect minor
	 * changes or bug fixes to a released HWRM interface
	 * specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint8_t	hwrm_intf_upd_8b;
	uint8_t	hwrm_intf_rsvd_8b;
	/*
	 * This field represents the major version of HWRM firmware.
	 * A change in firmware major version represents a major
	 * firmware release.
	 */
	uint8_t	hwrm_fw_maj_8b;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint8_t	hwrm_fw_min_8b;
	/*
	 * This field represents the build version of HWRM firmware.
	 * A change in firmware build version represents bug fixes
	 * to a released firmware.
	 */
	uint8_t	hwrm_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version of the
	 * HWRM firmware.
	 */
	uint8_t	hwrm_fw_rsvd_8b;
	/*
	 * This field represents the major version of mgmt firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	mgmt_fw_maj_8b;
	/*
	 * This field represents the minor version of mgmt firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	mgmt_fw_min_8b;
	/*
	 * This field represents the build version of mgmt firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	mgmt_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	mgmt_fw_rsvd_8b;
	/*
	 * This field represents the major version of network
	 * control firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	netctrl_fw_maj_8b;
	/*
	 * This field represents the minor version of network
	 * control firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	netctrl_fw_min_8b;
	/*
	 * This field represents the build version of network
	 * control firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	netctrl_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	netctrl_fw_rsvd_8b;
	/*
	 * This field is used to indicate device's capabilities and
	 * configurations.
	 */
	uint32_t	dev_caps_cfg;
	/*
	 * If set to 1, then secure firmware update behavior
	 * is supported.
	 * If set to 0, then secure firmware update behavior is
	 * not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SECURE_FW_UPD_SUPPORTED		UINT32_C(0x1)
	/*
	 * If set to 1, then firmware based DCBX agent is supported.
	 * If set to 0, then firmware based DCBX agent capability
	 * is not supported on this device.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_FW_DCBX_AGENT_SUPPORTED		UINT32_C(0x2)
	/*
	 * If set to 1, then HWRM short command format is supported.
	 * If set to 0, then HWRM short command format is not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_SUPPORTED			UINT32_C(0x4)
	/*
	 * If set to 1, then HWRM short command format is required.
	 * If set to 0, then HWRM short command format is not required.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_REQUIRED			UINT32_C(0x8)
	/*
	 * If set to 1, then the KONG host mailbox channel is supported.
	 * If set to 0, then the KONG host mailbox channel is not supported.
	 * By default, this flag should be 0 for older version of core
	 * firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_KONG_MB_CHNL_SUPPORTED		UINT32_C(0x10)
	/*
	 * If set to 1, then the 64bit flow handle is supported in addition
	 * to the legacy 16bit flow handle. If set to 0, then the 64bit flow
	 * handle is not supported. By default, this flag should be 0 for
	 * older version of core firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_FLOW_HANDLE_64BIT_SUPPORTED		UINT32_C(0x20)
	/*
	 * If set to 1, then filter type can be provided in filter_alloc or
	 * filter_cfg filter types like L2 for l2 traffic and ROCE for roce &
	 * l2 traffic. If set to 0, then filter types not supported. By
	 * default, this flag should be 0 for older version of core firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_L2_FILTER_TYPES_ROCE_OR_L2_SUPPORTED	UINT32_C(0x40)
	/*
	 * If set to 1, firmware is capable to support virtio vSwitch offload
	 * model. If set to 0, firmware can't supported virtio vSwitch
	 * offload model.
	 * By default, this flag should be 0 for older version of core
	 * firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_VIRTIO_VSWITCH_OFFLOAD_SUPPORTED	UINT32_C(0x80)
	/*
	 * If set to 1, firmware is capable to support trusted VF.
	 * If set to 0, firmware is not capable to support trusted VF.
	 * By default, this flag should be 0 for older version of core
	 * firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_TRUSTED_VF_SUPPORTED			UINT32_C(0x100)
	/*
	 * If set to 1, firmware is capable to support flow aging.
	 * If set to 0, firmware is not capable to support flow aging.
	 * By default, this flag should be 0 for older version of core
	 * firmware. (deprecated)
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_FLOW_AGING_SUPPORTED			UINT32_C(0x200)
	/*
	 * If set to 1, firmware is capable to support advanced flow counters
	 * like, Meter drop counters and EEM counters.
	 * If set to 0, firmware is not capable to support advanced flow
	 * counters. By default, this flag should be 0 for older version of
	 * core firmware. (deprecated)
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_ADV_FLOW_COUNTERS_SUPPORTED		UINT32_C(0x400)
	/*
	 * If set to 1, the firmware is able to support the use of the CFA
	 * Extended Exact Match(EEM) feature.
	 * If set to 0, firmware is not capable to support the use of the
	 * CFA EEM feature.
	 * By default, this flag should be 0 for older version of core
	 * firmware. (deprecated)
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_CFA_EEM_SUPPORTED			UINT32_C(0x800)
	/*
	 * If set to 1, the firmware is able to support advance CFA flow
	 * management features reported in the HWRM_CFA_FLOW_MGNT_QCAPS.
	 * If set to 0, then the firmware doesn't support the advance CFA
	 * flow management features.
	 * By default, this flag should be 0 for older version of core
	 * firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_CFA_ADV_FLOW_MGNT_SUPPORTED		UINT32_C(0x1000)
	/*
	 * Deprecated and replaced with cfa_truflow_supported.
	 * If set to 1, the firmware is able to support TFLIB features.
	 * If set to 0, then the firmware doesn't support TFLIB features.
	 * By default, this flag should be 0 for older version of core
	 * firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_CFA_TFLIB_SUPPORTED			UINT32_C(0x2000)
	/*
	 * If set to 1, the firmware is able to support TruFlow features.
	 * If set to 0, then the firmware doesn't support TruFlow features.
	 * By default, this flag should be 0 for older version of
	 * core firmware.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_CFA_TRUFLOW_SUPPORTED			UINT32_C(0x4000)
	/*
	 * If set to 1, then firmware supports secure boot.
	 * If set to 0, then firmware doesn't support secure boot.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SECURE_BOOT_CAPABLE			UINT32_C(0x8000)
	/*
	 * If set to 1, then firmware is able to support the secure solution
	 * feature.
	 * If set to 0, then firmware does not support the secure solution
	 * feature.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SECURE_SOC_CAPABLE			UINT32_C(0x10000)
	/*
	 * This field represents the major version of RoCE firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	roce_fw_maj_8b;
	/*
	 * This field represents the minor version of RoCE firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	roce_fw_min_8b;
	/*
	 * This field represents the build version of RoCE firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	roce_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	roce_fw_rsvd_8b;
	/*
	 * This field represents the name of HWRM FW (ASCII chars
	 * with NULL at the end).
	 */
	char	hwrm_fw_name[16];
	/*
	 * This field represents the name of mgmt FW (ASCII chars
	 * with NULL at the end).
	 */
	char	mgmt_fw_name[16];
	/*
	 * This field represents the name of network control
	 * firmware (ASCII chars with NULL at the end).
	 */
	char	netctrl_fw_name[16];
	/* This field represents the active board package name. */
	char	active_pkg_name[16];
	/*
	 * This field represents the name of RoCE FW (ASCII chars
	 * with NULL at the end).
	 */
	char	roce_fw_name[16];
	/* This field returns the chip number. */
	uint16_t	chip_num;
	/* This field returns the revision of chip. */
	uint8_t	chip_rev;
	/* This field returns the chip metal number. */
	uint8_t	chip_metal;
	/* This field returns the bond id of the chip. */
	uint8_t	chip_bond_id;
	/*
	 * This value indicates the type of platform used for chip
	 * implementation.
	 */
	uint8_t	chip_platform_type;
	/* ASIC */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_ASIC	UINT32_C(0x0)
	/* FPGA platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_FPGA	UINT32_C(0x1)
	/* Palladium platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_PALLADIUM UINT32_C(0x2)
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_LAST	HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_PALLADIUM
	/*
	 * This field returns the maximum value of request window that
	 * is supported by the HWRM. The request window is mapped
	 * into device address space using MMIO.
	 */
	uint16_t	max_req_win_len;
	/*
	 * This field returns the maximum value of response buffer in
	 * bytes.
	 */
	uint16_t	max_resp_len;
	/*
	 * This field returns the default request timeout value in
	 * milliseconds.
	 */
	uint16_t	def_req_timeout;
	/*
	 * This field will indicate if any subsystems is not fully
	 * initialized.
	 */
	uint8_t	flags;
	/*
	 * If set to 1, it will indicate to host drivers that firmware is
	 * not ready to start full blown HWRM commands. Host drivers should
	 * re-try HWRM_VER_GET with some timeout period. The timeout period
	 * can be selected up to 5 seconds. Host drivers should also check
	 * for dev_not_rdy_backing_store to identify if flag is set due to
	 * backing store not been available.
	 * For Example, PCIe hot-plug:
	 *	Hot plug timing is system dependent. It generally takes up to
	 *	600 milliseconds for firmware to clear DEV_NOT_RDY flag.
	 * If set to 0, device is ready to accept all HWRM commands.
	 */
	#define HWRM_VER_GET_OUTPUT_FLAGS_DEV_NOT_RDY		UINT32_C(0x1)
	/*
	 * If set to 1, external version present.
	 * If set to 0, external version not present.
	 */
	#define HWRM_VER_GET_OUTPUT_FLAGS_EXT_VER_AVAIL		UINT32_C(0x2)
	/*
	 * Firmware sets this flag along with dev_not_rdy flag to indicate
	 * host drivers that it has not completed resource initialization
	 * required for data path operations. Host drivers should not send
	 * any HWRM command that requires data path resources. Firmware will
	 * fail those commands with HWRM_ERR_CODE_BUSY. Host drivers can
	 * retry those commands once both the flags are cleared.
	 * If this flag and dev_not_rdy flag are set to 0, device is ready
	 * to accept all HWRM commands.
	 */
	#define HWRM_VER_GET_OUTPUT_FLAGS_DEV_NOT_RDY_BACKING_STORE	UINT32_C(0x4)
	uint8_t	unused_0[2];
	/*
	 * For backward compatibility this field must be set to 1.
	 * Older drivers might look for this field to be 1 before
	 * processing the message.
	 */
	uint8_t	always_1;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification. A HWRM implementation that is
	 * compliant with this specification shall provide value of 1
	 * in this field.
	 */
	uint16_t	hwrm_intf_major;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification. This can be due to addition or
	 * removal of functionality. HWRM interface specifications
	 * with the same major version but different minor versions are
	 * compatible. A HWRM implementation that is compliant with
	 * this specification shall provide value of 2 in this field.
	 */
	uint16_t	hwrm_intf_minor;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the HWRM implementation. The
	 * interface update version is used to reflect minor changes or
	 * bug fixes to a released HWRM interface specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint16_t	hwrm_intf_build;
	/*
	 * This field represents the patch version of HWRM interface
	 * specification supported by the HWRM implementation.
	 */
	uint16_t	hwrm_intf_patch;
	/*
	 * This field represents the major version of HWRM firmware.
	 * A change in firmware major version represents a major
	 * firmware release.
	 */
	uint16_t	hwrm_fw_major;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint16_t	hwrm_fw_minor;
	/*
	 * This field represents the build version of HWRM firmware.
	 * A change in firmware build version represents bug fixes to
	 * a released firmware.
	 */
	uint16_t	hwrm_fw_build;
	/*
	 * This field is a reserved field.
	 * This field can be used to represent firmware branches or customer
	 * specific releases tied to a specific (major,minor,update) version
	 * of the HWRM firmware.
	 */
	uint16_t	hwrm_fw_patch;
	/*
	 * This field represents the major version of mgmt firmware.
	 * A change in major version represents a major release.
	 */
	uint16_t	mgmt_fw_major;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint16_t	mgmt_fw_minor;
	/*
	 * This field represents the build version of mgmt firmware.
	 * A change in update version represents bug fixes.
	 */
	uint16_t	mgmt_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version.
	 */
	uint16_t	mgmt_fw_patch;
	/*
	 * This field represents the major version of network control
	 * firmware. A change in major version represents
	 * a major release.
	 */
	uint16_t	netctrl_fw_major;
	/*
	 * This field represents the minor version of network control
	 * firmware. A change in minor version represents significant
	 * functionality changes.
	 */
	uint16_t	netctrl_fw_minor;
	/*
	 * This field represents the build version of network control
	 * firmware. A change in update version represents bug fixes.
	 */
	uint16_t	netctrl_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint16_t	netctrl_fw_patch;
	/*
	 * This field represents the major version of RoCE firmware.
	 * A change in major version represents a major release.
	 */
	uint16_t	roce_fw_major;
	/*
	 * This field represents the minor version of RoCE firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint16_t	roce_fw_minor;
	/*
	 * This field represents the build version of RoCE firmware.
	 * A change in update version represents bug fixes.
	 */
	uint16_t	roce_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint16_t	roce_fw_patch;
	/*
	 * This field returns the maximum extended request length acceptable
	 * by the device which allows requests greater than mailbox size when
	 * used with the short cmd request format.
	 */
	uint16_t	max_ext_req_len;
	/*
	 * This field returns the maximum request timeout value in seconds.
	 * For backward compatibility, a value of zero should be interpreted
	 * as the default value of 40 seconds. Drivers should always honor the
	 * maximum timeout, but are permitted to warn if a longer duration than
	 * this default is advertised. Values larger than 40 seconds should
	 * only be used as a stopgap measure to address a device limitation or
	 * for the purposes of test and debugging. The long term goal is for
	 * firmware to significantly reduce this value in the passage of time.
	 */
	uint16_t	max_req_timeout;
	uint8_t	unused_1[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* cfa_bds_read_cmd_data_msg (size:128b/16B) */

struct cfa_bds_read_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/*
	 * This is read command. From 32 to 128B can be read from a table
	 * using this command.
	 */
	#define CFA_BDS_READ_CMD_DATA_MSG_OPCODE_READ UINT32_C(0x0)
	#define CFA_BDS_READ_CMD_DATA_MSG_OPCODE_LAST CFA_BDS_READ_CMD_DATA_MSG_OPCODE_READ
	/* This value selects the table type to be acted upon. */
	uint8_t	table_type;
	/* This value selects the table type to be acted upon. */
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_MASK  UINT32_C(0xf)
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_SFT   0
	/* This command acts on the action table of the specified scope. */
		#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_ACTION  UINT32_C(0x0)
	/* This command acts on the exact match table of the specified scope. */
		#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_EM	UINT32_C(0x1)
		#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_LAST   CFA_BDS_READ_CMD_DATA_MSG_TABLE_TYPE_EM
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed. A
	 * value of zero is invalid. Maximum value is 4.
	 */
	uint8_t	data_size;
	#define CFA_BDS_READ_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_READ_CMD_DATA_MSG_DATA_SIZE_SFT 0
	/* This is the 32B index into the selected table to access. */
	uint32_t	table_index;
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_BDS_READ_CMD_DATA_MSG_TABLE_INDEX_SFT 0
	/*
	 * This is the 64b host address where you want the data returned to. The
	 * data will be written to the same function as the one that owns the SQ
	 * this command is read from. The bottom two bits of this value must be
	 * zero. The size of the write is controlled by the data_size field.
	 */
	uint64_t	host_address;
} __attribute__((packed));

/* cfa_bds_write_cmd_data_msg (size:1152b/144B) */

struct cfa_bds_write_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/*
	 * This is write command. From 32 to 128B can be written to a table
	 * using this command.
	 */
	#define CFA_BDS_WRITE_CMD_DATA_MSG_OPCODE_WRITE UINT32_C(0x1)
	#define CFA_BDS_WRITE_CMD_DATA_MSG_OPCODE_LAST CFA_BDS_WRITE_CMD_DATA_MSG_OPCODE_WRITE
	/* This value selects the table type to be acted upon. */
	uint8_t	write_thru_table_type;
	/* This value selects the table type to be acted upon. */
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_MASK  UINT32_C(0xf)
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_SFT   0
	/* This command acts on the action table of the specified scope. */
		#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_ACTION  UINT32_C(0x0)
	/* This command acts on the exact match table of the specified scope. */
		#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_EM	UINT32_C(0x1)
		#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_LAST   CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_TYPE_EM
	/*
	 * Indicates write-through control. Indicates write-through when set,
	 * or write back when cleared.
	 */
	#define CFA_BDS_WRITE_CMD_DATA_MSG_WRITE_THRU	UINT32_C(0x10)
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed. A
	 * value of zero is invalid. Maximum value is 4.
	 */
	uint8_t	data_size;
	#define CFA_BDS_WRITE_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_WRITE_CMD_DATA_MSG_DATA_SIZE_SFT 0
	/* This is the 32B index into the selected table to access. */
	uint32_t	table_index;
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_BDS_WRITE_CMD_DATA_MSG_TABLE_INDEX_SFT 0
	uint32_t	unused0;
	uint32_t	unused1;
	/*
	 * This is the data to be written. Data length is determined by the
	 * data_size field. The bd_cnt in the encapsulating BD must also be set
	 * correctly to ensure that the BD is processed correctly and the full
	 * WRITE_CMD message is extracted from the BD.
	 */
	uint32_t	dta[32];
} __attribute__((packed));

/* cfa_bds_read_clr_cmd_data_msg (size:256b/32B) */

struct cfa_bds_read_clr_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/*
	 * This is read-clear command. 32B can be read from a table and
	 * a 16b mask can be used to clear specific 16b units after the
	 * read as an atomic operation.
	 */
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_OPCODE_READ_CLR UINT32_C(0x2)
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_OPCODE_LAST	CFA_BDS_READ_CLR_CMD_DATA_MSG_OPCODE_READ_CLR
	/* This value selects the table type to be acted upon. */
	uint8_t	table_type;
	/* This value selects the table type to be acted upon. */
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_MASK  UINT32_C(0xf)
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_SFT   0
	/* This command acts on the action table of the specified scope. */
		#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_ACTION  UINT32_C(0x0)
	/* This command acts on the exact match table of the specified scope. */
		#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_EM	UINT32_C(0x1)
		#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_LAST   CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_TYPE_EM
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed.
	 * Always set the value to 1.
	 */
	uint8_t	data_size;
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_DATA_SIZE_SFT 0
	/* This is the 32B index into the selected table to access. */
	uint32_t	table_index;
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_BDS_READ_CLR_CMD_DATA_MSG_TABLE_INDEX_SFT 0
	/*
	 * This is the 64b host address where you want the data returned to. The
	 * data will be written to the same function as the one that owns the SQ
	 * this command is read from. The bottom two bits of this value must be
	 * zero. The size of the write is controlled by the data_size field.
	 */
	uint64_t	host_address;
	/*
	 * This is active high clear mask for the 32B of data that this command
	 * can read. Bit 0 of the field will clear bits 15:0 of the first word
	 * of data read when set to '1'.
	 */
	uint16_t	clear_mask;
	uint16_t	unused0[3];
	uint16_t	unused1[4];
} __attribute__((packed));

/* cfa_bds_em_insert_cmd_data_msg (size:1152b/144B) */

struct cfa_bds_em_insert_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/*
	 * An exact match table insert will be attempted into the table.
	 * If there is a free location in the bucket, the payload will
	 * be written to the bucket.
	 */
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_OPCODE_EM_INSERT UINT32_C(0x3)
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_OPCODE_LAST	CFA_BDS_EM_INSERT_CMD_DATA_MSG_OPCODE_EM_INSERT
	/*
	 * Indicates write-through control. Indicates write-through when set,
	 * or write back when cleared.
	 */
	uint8_t	write_thru;
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_UNUSED_MASK	UINT32_C(0xf)
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_UNUSED_SFT	0
	/*
	 * Indicates write-through control. Indicates write-through when set,
	 * or write back when cleared.
	 */
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_WRITE_THRU	UINT32_C(0x10)
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed. A
	 * value of zero is invalid. Maximum value is 4.
	 */
	uint8_t	data_size;
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_DATA_SIZE_SFT 0
	/* This is the 32B index into the selected table to access. */
	uint32_t	table_index;
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_BDS_EM_INSERT_CMD_DATA_MSG_TABLE_INDEX_SFT 0
	/*
	 * This is the 64b host address where you want the data returned to. The
	 * data will be written to the same function as the one that owns the SQ
	 */
	uint64_t	host_address;
	/*
	 * This is the Exact Match Lookup Record. Data length is determined by
	 * the data_size field. The bd_cnt in the encapsulating BD must also be
	 */
	uint32_t	dta[32];
} __attribute__((packed));

/* cfa_bds_em_delete_cmd_data_msg (size:256b/32B) */

struct cfa_bds_em_delete_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/* An exact match table delete will be attempted. */
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_OPCODE_EM_DELETE UINT32_C(0x4)
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_OPCODE_LAST	CFA_BDS_EM_DELETE_CMD_DATA_MSG_OPCODE_EM_DELETE
	/*
	 * Indicates write-through control. Indicates write-through when set,
	 * or write back when cleared.
	 */
	uint8_t	write_thru;
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_UNUSED_MASK	UINT32_C(0xf)
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_UNUSED_SFT	0
	/*
	 * Indicates write-through control. Indicates write-through when set,
	 * or write back when cleared.
	 */
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_WRITE_THRU	UINT32_C(0x10)
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed. A
	 * value of zero is invalid. Maximum value is 4.
	 */
	uint8_t	data_size;
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_EM_DELETE_CMD_DATA_MSG_DATA_SIZE_SFT 0
	uint32_t	unused0;
	/*
	 * This is the 64b host address where you want the data returned to. The
	 * data will be written to the same function as the one that owns the SQ
	 */
	uint64_t	host_address;
	/*
	 * This is the Exact Match Lookup Record. Data length is determined by
	 * the data_size field. The bd_cnt in the encapsulating BD must also be
	 */
	uint64_t	dta;
	uint64_t	unused1;
} __attribute__((packed));

/* cfa_bds_invalidate_cmd_data_msg (size:128b/16B) */

struct cfa_bds_invalidate_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/*
	 * The specified table area will be invalidated. If it is needed.
	 * again, it will be read from the backing store.
	 */
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_OPCODE_INVALIDATE UINT32_C(0x5)
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_OPCODE_LAST	CFA_BDS_INVALIDATE_CMD_DATA_MSG_OPCODE_INVALIDATE
	/* This value selects the table type to be acted upon. */
	uint8_t	table_type;
	/* This value selects the table type to be acted upon. */
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_MASK  UINT32_C(0xf)
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_SFT   0
	/* This command acts on the action table of the specified scope. */
		#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_ACTION  UINT32_C(0x0)
	/* This command acts on the exact match table of the specified scope. */
		#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_EM	UINT32_C(0x1)
		#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_LAST   CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_TYPE_EM
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/* This value specifies the number of cache lines to invalidate. */
	uint8_t	data_size;
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_DATA_SIZE_SFT 0
	/* This is the 32B index into the selected table to access. */
	uint32_t	table_index;
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_BDS_INVALIDATE_CMD_DATA_MSG_TABLE_INDEX_SFT 0
	uint64_t	unused;
} __attribute__((packed));

/* cfa_bds_event_collect_cmd_data_msg (size:128b/16B) */

struct cfa_bds_event_collect_cmd_data_msg {
	/* This value selects the format for the mid-path command for the CFA. */
	uint8_t	opcode;
	/* Reads notification messages from the Host Notification Queue. */
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_OPCODE_EVENT_COLLECT UINT32_C(0x6)
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_OPCODE_LAST	CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_OPCODE_EVENT_COLLECT
	uint8_t	unused0;
	/* This value selects which table scope will be accessed. */
	uint8_t	table_scope;
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_TABLE_SCOPE_SFT 0
	/*
	 * This value identifies the number of 32B units will be accessed. A
	 * value of zero is invalid. Maximum value is 4.
	 */
	uint8_t	data_size;
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_DATA_SIZE_MASK UINT32_C(0x7)
	#define CFA_BDS_EVENT_COLLECT_CMD_DATA_MSG_DATA_SIZE_SFT 0
	uint32_t	unused1;
	/*
	 * This is the 64b host address where you want the data returned to. The
	 * data will be written to the same function as the one that owns the SQ
	 */
	uint64_t	host_address;
} __attribute__((packed));

/* ce_bds_add_data_msg (size:576b/72B) */

struct ce_bds_add_data_msg {
	uint32_t	version_algorithm_kid_opcode;
	/*
	 * This value selects the operation for the mid-path command for the
	 * crypto blocks.
	 */
	#define CE_BDS_ADD_DATA_MSG_OPCODE_MASK		UINT32_C(0xf)
	#define CE_BDS_ADD_DATA_MSG_OPCODE_SFT		0
	/*
	 * This is the add command. Using this opcode, Host Driver can add
	 * information required for kTLS processing. The information is
	 * updated in the CFCK context.
	 */
		#define CE_BDS_ADD_DATA_MSG_OPCODE_ADD		UINT32_C(0x1)
		#define CE_BDS_ADD_DATA_MSG_OPCODE_LAST		CE_BDS_ADD_DATA_MSG_OPCODE_ADD
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated kTLS offloaded connection.
	 */
	#define CE_BDS_ADD_DATA_MSG_KID_MASK		UINT32_C(0xfffff0)
	#define CE_BDS_ADD_DATA_MSG_KID_SFT		4
	/*
	 * Currently only two algorithms are supported, AES_GCM_128 and
	 * AES_GCM_256. Additional bits for future growth.
	 */
	#define CE_BDS_ADD_DATA_MSG_ALGORITHM_MASK		UINT32_C(0xf000000)
	#define CE_BDS_ADD_DATA_MSG_ALGORITHM_SFT		24
	/* AES_GCM_128 Algorithm */
	#define CE_BDS_ADD_DATA_MSG_ALGORITHM_AES_GCM_128	UINT32_C(0x1000000)
	/* AES_GCM_256 Algorithm */
	#define CE_BDS_ADD_DATA_MSG_ALGORITHM_AES_GCM_256	UINT32_C(0x2000000)
	/*
	 * Version number of TLS connection. HW will provide registers that
	 * converts the 4b encoded version number to 16b of actual version
	 * number in the TLS Header. This field is initialized/updated by
	 * this "KTLS crypto add" mid-path command.
	 */
	#define CE_BDS_ADD_DATA_MSG_VERSION_MASK		UINT32_C(0xf0000000)
	#define CE_BDS_ADD_DATA_MSG_VERSION_SFT		28
	/* TLS1.2 Version */
		#define CE_BDS_ADD_DATA_MSG__TLS1_2			(UINT32_C(0x0) << 28)
	/* TLS1.3 Version */
		#define CE_BDS_ADD_DATA_MSG__TLS1_3			(UINT32_C(0x1) << 28)
		#define CE_BDS_ADD_DATA_MSG__LAST			CE_BDS_ADD_DATA_MSG__TLS1_3
	uint8_t	ctx_kind;
	/* This field selects the context kind for the request. */
	#define CE_BDS_ADD_DATA_MSG_CTX_KIND_MASK UINT32_C(0x1f)
	#define CE_BDS_ADD_DATA_MSG_CTX_KIND_SFT  0
	/* Crypto key transmit context */
		#define CE_BDS_ADD_DATA_MSG_CTX_KIND_CK_TX  UINT32_C(0x11)
	/* Crypto key receive context */
		#define CE_BDS_ADD_DATA_MSG_CTX_KIND_CK_RX  UINT32_C(0x12)
		#define CE_BDS_ADD_DATA_MSG_CTX_KIND_LAST  CE_BDS_ADD_DATA_MSG_CTX_KIND_CK_RX
	uint8_t	unused0[3];
	/*
	 * Salt is part of the nonce that is used as the Initial Vector (IV) in
	 * AES-GCM cipher suites. These are exchanged as part of the handshake
	 * process and is either the client_write_iv (when the client is
	 * sending) or server_write_iv (when the server is sending). In
	 * TLS1.2, 4B of Salt is concatenated with 8B of explicit_nonce to
	 * generate the 12B of IV. In TLS1.3, 8B of TLS record sequence number
	 * is zero padded to 12B and then xor'ed with the 4B of salt to generate
	 * the 12B of IV. This value is initialized by this mid-path command.
	 */
	uint8_t	salt[4];
	uint8_t	unused1[4];
	/*
	 * This field keeps track of the TCP sequence number that is expected as
	 * the first byte in the next TCP packet. This field is calculated by HW
	 * using the output of the parser. The field is initialized as part of
	 * the Mid-path BD download/update of a kTLS connection. For every TCP
	 * packet processed, TCE HW will update the value to Current packet TCP
	 * sequence number + Current packet TCP Payload Length.
	 */
	uint32_t	pkt_tcp_seq_num;
	/*
	 * This field maintains the TCP sequence number of the first byte in the
	 * header of the active TLS record. This field is initialized as part of
	 * the Mid-path BD download/update of a kTLS connection. For every
	 * record that is processed, TCE HW copies the value from the
	 * next_tls_header_tcp_seq_num field.
	 */
	uint32_t	tls_header_tcp_seq_num;
	/*
	 * This is sequence number for the TLS record in a particular session.
	 * In TLS1.2, record sequence number is part of the Associated Data (AD)
	 * in the AEAD algorithm. In TLS1.3, record sequence number is part of
	 * the Initial Vector (IV). The field is initialized as part of the
	 * mid-path BD download/update of a kTLS connection. TCE HW increments
	 * the field after that for every record processed as it parses the TCP
	 * packet.
	 */
	uint64_t	record_seq_num;
	/*
	 * Key used for encrypting or decrypting TLS records. The Key is
	 * exchanged during the hand-shake protocol by the client-server and
	 * provided to HW through this mid-path BD.
	 */
	uint8_t	session_key[32];
	/*
	 * Additional IV that is exchanged as part of sessions setup between
	 * the two end points. This field is used for TLS1.3 only.
	 */
	uint8_t	addl_iv[8];
} __attribute__((packed));

/* ce_bds_delete_data_msg (size:32b/4B) */

struct ce_bds_delete_data_msg {
	uint32_t	kid_opcode_ctx_kind;
	/*
	 * This value selects the operation for the mid-path command for the
	 * crypto blocks.
	 */
	#define CE_BDS_DELETE_DATA_MSG_OPCODE_MASK	UINT32_C(0xf)
	#define CE_BDS_DELETE_DATA_MSG_OPCODE_SFT	0
	/*
	 * This is the delete command. Using this opcode, the host Driver
	 * can remove a key context from the CFCK. If context is deleted
	 * and packets with the same KID come through the pipeline, the
	 * following actions are taken. For transmit packets, no crypto
	 * operation will be performed, payload will be zero'ed out. For
	 * receive packets, no crypto operation will be performed,
	 * payload will be unmodified.
	 */
		#define CE_BDS_DELETE_DATA_MSG_OPCODE_DELETE	UINT32_C(0x2)
		#define CE_BDS_DELETE_DATA_MSG_OPCODE_LAST	CE_BDS_DELETE_DATA_MSG_OPCODE_DELETE
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated kTLS offloaded connection.
	 */
	#define CE_BDS_DELETE_DATA_MSG_KID_MASK	UINT32_C(0xfffff0)
	#define CE_BDS_DELETE_DATA_MSG_KID_SFT	4
	/* This field selects the context kind for the request. */
	#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_MASK   UINT32_C(0x1f000000)
	#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_SFT	24
	/* Crypto Key Transmit Context. */
		#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_CK_TX	(UINT32_C(0x11) << 24)
	/* Crypto Key Receive Context. */
		#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_CK_RX	(UINT32_C(0x12) << 24)
	/* QUIC Key Transmit Context. */
		#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_QUIC_TX  (UINT32_C(0x14) << 24)
	/* QUIC Key Receive Context. */
		#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_QUIC_RX  (UINT32_C(0x15) << 24)
		#define CE_BDS_DELETE_DATA_MSG_CTX_KIND_LAST	CE_BDS_DELETE_DATA_MSG_CTX_KIND_QUIC_RX
} __attribute__((packed));

/* ce_bds_resync_resp_ack_msg (size:128b/16B) */

struct ce_bds_resync_resp_ack_msg {
	uint32_t	resync_status_kid_opcode;
	/*
	 * This value selects the operation for the mid-path command for the
	 * crypto blocks.
	 */
	#define CE_BDS_RESYNC_RESP_ACK_MSG_OPCODE_MASK	UINT32_C(0xf)
	#define CE_BDS_RESYNC_RESP_ACK_MSG_OPCODE_SFT	0
	/*
	 * This command is used by the driver as a response to the resync
	 * request sent by the crypto engine.
	 */
		#define CE_BDS_RESYNC_RESP_ACK_MSG_OPCODE_RESYNC	UINT32_C(0x3)
		#define CE_BDS_RESYNC_RESP_ACK_MSG_OPCODE_LAST	CE_BDS_RESYNC_RESP_ACK_MSG_OPCODE_RESYNC
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated kTLS offloaded connection.
	 */
	#define CE_BDS_RESYNC_RESP_ACK_MSG_KID_MASK	UINT32_C(0xfffff0)
	#define CE_BDS_RESYNC_RESP_ACK_MSG_KID_SFT	4
	/*
	 * This field indicates if the resync request resulted in a success or
	 * a failure.
	 */
	#define CE_BDS_RESYNC_RESP_ACK_MSG_RESYNC_STATUS	UINT32_C(0x1000000)
	/*
	 * An ACK indicates that the driver was able to find the TLS record
	 * associated with TCP sequence number provided by the HW
	 */
		#define CE_BDS_RESYNC_RESP_ACK_MSG_RESYNC_STATUS_ACK   (UINT32_C(0x0) << 24)
		#define CE_BDS_RESYNC_RESP_ACK_MSG_RESYNC_STATUS_LAST CE_BDS_RESYNC_RESP_ACK_MSG_RESYNC_STATUS_ACK
	/*
	 * This field is the echo of the TCP sequence number provided in the
	 * resync request by the HW. If HW sent multiple resync requests, it
	 * only tracks the latest TCP sequence number. When the response from
	 * the Driver doesn't match the latest request, HW will drop the resync
	 * response.
	 */
	uint32_t	resync_record_tcp_seq_num;
	/*
	 * This field indicates the TLS record sequence number associated with
	 * the resync request. HW will take this number and add the delta records
	 * it has found since sending the resync request, update the context and
	 * resume decrypting records.
	 */
	uint64_t	resync_record_seq_num;
} __attribute__((packed));

/* ce_bds_resync_resp_nack_msg (size:64b/8B) */

struct ce_bds_resync_resp_nack_msg {
	uint32_t	resync_status_kid_opcode;
	/*
	 * This value selects the operation for the mid-path command for the
	 * crypto blocks.
	 */
	#define CE_BDS_RESYNC_RESP_NACK_MSG_OPCODE_MASK	UINT32_C(0xf)
	#define CE_BDS_RESYNC_RESP_NACK_MSG_OPCODE_SFT	0
	/*
	 * This command is used by the driver as a response to the resync
	 * request sent by the crypto engine.
	 */
		#define CE_BDS_RESYNC_RESP_NACK_MSG_OPCODE_RESYNC	UINT32_C(0x3)
		#define CE_BDS_RESYNC_RESP_NACK_MSG_OPCODE_LAST	CE_BDS_RESYNC_RESP_NACK_MSG_OPCODE_RESYNC
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated kTLS offloaded connection.
	 */
	#define CE_BDS_RESYNC_RESP_NACK_MSG_KID_MASK	UINT32_C(0xfffff0)
	#define CE_BDS_RESYNC_RESP_NACK_MSG_KID_SFT	4
	/*
	 * This field indicates if the resync request resulted in a success or
	 * a failure.
	 */
	#define CE_BDS_RESYNC_RESP_NACK_MSG_RESYNC_STATUS	UINT32_C(0x1000000)
	/*
	 * An NAK indicates that the driver wasn't able to find the TLS
	 * record associated with TCP sequence number provided by the HW
	 */
		#define CE_BDS_RESYNC_RESP_NACK_MSG_RESYNC_STATUS_NACK  (UINT32_C(0x1) << 24)
		#define CE_BDS_RESYNC_RESP_NACK_MSG_RESYNC_STATUS_LAST CE_BDS_RESYNC_RESP_NACK_MSG_RESYNC_STATUS_NACK
	/*
	 * This field is the echo of the TCP sequence number provided in the
	 * resync request by the HW. If HW sent multiple resync requests, it
	 * only tracks the latest TCP sequence number. When the response from
	 * the Driver doesn't match the latest request, HW will drop the resync
	 * response.
	 */
	uint32_t	resync_record_tcp_seq_num;
} __attribute__((packed));

/* crypto_presync_bd_cmd (size:256b/32B) */

struct crypto_presync_bd_cmd {
	uint8_t	flags;
	/*
	 * Typically, presync BDs are used for packet retransmissions. Source
	 * port sends all the packets in order over the network to destination
	 * port and packets get dropped in the network. The destination port
	 * will request retransmission of dropped packets and source port
	 * driver will send presync BD to setup the transmitter appropriately.
	 * It will provide the start and end TCP sequence number of the data to
	 * be transmitted. HW keeps two sets of context variable, one for in
	 * order traffic and one for retransmission traffic. HW is designed to
	 * transmit everything posted in the presync BD and return to in order
	 * mode after that. No inorder context variables are updated in the
	 * process. There is a special case where packets can be dropped
	 * between the TCP stack and Device Driver (Berkeley Packet Filter for
	 * ex) and HW still needs to transmit rest of the traffic. In this
	 * mode, driver will send a presync BD as if it is a retransmission but
	 * at the end of the transmission, the in order variables need to be
	 * updated. This flag is used by driver to indicate that in order
	 * variables needs to be updated at the end of completing the task
	 * associated with the presync BD.
	 */
	#define CRYPTO_PRESYNC_BD_CMD_FLAGS_UPDATE_IN_ORDER_VAR	UINT32_C(0x1)
	/*
	 * When packet with an authentication TAG is lost in the network,
	 * During retransmission Device driver will post the entire record for
	 * the hardware to recalculate the TAG. Hardware is set to retransmit
	 * only portions of the record, it does so by looking at the Header
	 * TCP Sequence Number and Start TCP Sequence Number. However, there
	 * is a case where the header packet gets dropped in the stack for ex
	 * BPF packet filter and it is impossible for the Hardware to
	 * determine if this is a case of full replay for only the TAG
	 * generation.
	 */
	#define CRYPTO_PRESYNC_BD_CMD_FLAGS_FULL_REPLAY_RETRAN	UINT32_C(0x2)
	uint8_t	unused0;
	uint16_t	unused1;
	/*
	 * This field maintains the TCP sequence number of the first byte in the
	 * Header of the active TLS record. This field is set to 0 during
	 * mid-path BD updates, but is set to correct value when a presync BD is
	 * detected. For every record that is processed, the value from the
	 * next_tls_header_tcp_seq_num field is copied.
	 */
	uint32_t	header_tcp_seq_num;
	/*
	 * When a retransmitted packet has a TLS authentication TAG present and
	 * the data spans multiple TCP Packets, HW is required to read the entire
	 * record to recalculate the TAG but only transmit what is required. This
	 * field is the start TCP sequence number of the packet(s) that need to
	 * be re-transmitted. This field is initialized to 0 during Mid-path BD
	 * add command and initialized to value provided by the driver when
	 * Pre-sync BD is detected. This field is never updated unless another
	 * Pre-sync BD signaling a new retransmission is scheduled.
	 */
	uint32_t	start_tcp_seq_num;
	/*
	 * When a retransmitted packet has a TLS authentication TAG present and
	 * the data spans multiple TCP Packets, HW is required to read the
	 * entire record to recalculate the TAG but only transmit what is
	 * required. This field is the end TCP sequence number of the packet(s)
	 * that need to be re-transmitted. This field is initialized to 0 during
	 * Mid-path BD add command and initialized to value provided by the
	 * driver when Pre-sync BD is detected. This field is never updated
	 * unless another Pre-sync BD signaling a new retransmission is
	 * scheduled.
	 */
	uint32_t	end_tcp_seq_num;
	/*
	 * For TLS1.2, an explicit nonce is used as part of the IV (concatenated
	 * with the SALT). For retrans packets, this field is extracted from the
	 * TLS record, field right after the TLS Header and stored in the
	 * context. This field needs to be stored in context as TCP segmentation
	 * could have split the field into multiple TCP packets. This value is
	 * initialized to 0 when presync BD is detected by taking the value from
	 * the first TLS header. When subsequent TLS Headers are detected, the
	 * value is extracted from packet.
	 */
	uint8_t	explicit_nonce[8];
	/*
	 * This is sequence number for the TLS record in a particular session. In
	 * TLS1.2, record sequence number is part of the Associated Data (AD) in
	 * the AEAD algorithm. In TLS1.3, record sequence number is part of the
	 * Initial Vector (IV). The field is initialized to 0 during Mid-path BD
	 * download. Is initialized to correct value when a pre-sync BD is
	 * detected. TCE HW increments the field after that for every record
	 * processed as it parses the TCP packet. Subsequent pre-sync BDs
	 * delivering more retransmission instruction will also update this
	 * field.
	 */
	uint64_t	record_seq_num;
} __attribute__((packed));

/* ce_bds_quic_add_data_msg (size:832b/104B) */

struct ce_bds_quic_add_data_msg {
	uint32_t	ver_algo_kid_opcode;
	/*
	 * This value selects the operation for the mid-path command for the
	 * crypto blocks.
	 */
	#define CE_BDS_QUIC_ADD_DATA_MSG_OPCODE_MASK	UINT32_C(0xf)
	#define CE_BDS_QUIC_ADD_DATA_MSG_OPCODE_SFT	0
	/*
	 * This is the add command. Using this opcode, Host Driver can add
	 * information required for QUIC processing. The information is
	 * updated in the CFCK context.
	 */
		#define CE_BDS_QUIC_ADD_DATA_MSG_OPCODE_ADD		UINT32_C(0x1)
		#define CE_BDS_QUIC_ADD_DATA_MSG_OPCODE_LAST	CE_BDS_QUIC_ADD_DATA_MSG_OPCODE_ADD
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated QUIC offloaded connection.
	 */
	#define CE_BDS_QUIC_ADD_DATA_MSG_KID_MASK		UINT32_C(0xfffff0)
	#define CE_BDS_QUIC_ADD_DATA_MSG_KID_SFT		4
	/* Algorithm used for encryption and decryption. */
	#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_MASK	UINT32_C(0xf000000)
	#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_SFT	24
	/* AES_GCM_128 Algorithm. */
		#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_AES_GCM_128  (UINT32_C(0x1) << 24)
	/* AES_GCM_256 Algorithm. */
		#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_AES_GCM_256  (UINT32_C(0x2) << 24)
	/* Chacha20 Algorithm. */
		#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_CHACHA20	(UINT32_C(0x3) << 24)
		#define CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_LAST	CE_BDS_QUIC_ADD_DATA_MSG_ALGORITHM_CHACHA20
	/* Version number of QUIC connection. */
	#define CE_BDS_QUIC_ADD_DATA_MSG_VERSION_MASK	UINT32_C(0xf0000000)
	#define CE_BDS_QUIC_ADD_DATA_MSG_VERSION_SFT	28
	/* TLS1.2 Version */
		#define CE_BDS_QUIC_ADD_DATA_MSG__TLS1_2		(UINT32_C(0x0) << 28)
	/* TLS1.3 Version */
		#define CE_BDS_QUIC_ADD_DATA_MSG__TLS1_3		(UINT32_C(0x1) << 28)
	/* DTLS1.2 Version */
		#define CE_BDS_QUIC_ADD_DATA_MSG__DTLS1_2		(UINT32_C(0x2) << 28)
	/* DTLS1.2 for RoCE Version */
		#define CE_BDS_QUIC_ADD_DATA_MSG__DTLS1_2_ROCE	(UINT32_C(0x3) << 28)
	/* QUIC Version */
		#define CE_BDS_QUIC_ADD_DATA_MSG__QUIC		(UINT32_C(0x4) << 28)
		#define CE_BDS_QUIC_ADD_DATA_MSG__LAST		CE_BDS_QUIC_ADD_DATA_MSG__QUIC
	uint32_t	ctx_kind_dcid_width_key_phase;
	/* Key phase. */
	#define CE_BDS_QUIC_ADD_DATA_MSG_KEY_PHASE	UINT32_C(0x1)
	/* Destination connection ID width. */
	#define CE_BDS_QUIC_ADD_DATA_MSG_DCID_WIDTH_MASK UINT32_C(0x3e)
	#define CE_BDS_QUIC_ADD_DATA_MSG_DCID_WIDTH_SFT  1
	/* This field selects the context kind for the request. */
	#define CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_MASK   UINT32_C(0x7c0)
	#define CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_SFT	6
	/* QUIC key transmit context */
		#define CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_QUIC_TX  (UINT32_C(0x14) << 6)
	/* QUIC key receive context */
		#define CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_QUIC_RX  (UINT32_C(0x15) << 6)
		#define CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_LAST	CE_BDS_QUIC_ADD_DATA_MSG_CTX_KIND_QUIC_RX
	uint64_t	unused_0;
	/*
	 * Least-significant 64 bits (of 96) of additional IV that is
	 * exchanged as part of sessions setup between the two end
	 * points for QUIC operations.
	 */
	uint8_t	quic_iv_lo[8];
	/*
	 * Most-significant 32 bits (of 96) of additional IV that is
	 * exchanged as part of sessions setup between the two end
	 * points for QUIC operations.
	 */
	uint8_t	quic_iv_hi[4];
	uint32_t	unused_1;
	/*
	 * Key used for encrypting or decrypting records. The Key is exchanged
	 * as part of sessions setup between the two end points through this
	 * mid-path BD.
	 */
	uint8_t	session_key[32];
	/* Header protection key. */
	uint8_t	hp_key[32];
	/* Packet number associated with the QUIC connection. */
	uint64_t	pkt_number;
} __attribute__((packed));

/* bd_base (size:64b/8B) */

struct bd_base {
	uint8_t	type;
	/* This value identifies the type of buffer descriptor. */
	#define BD_BASE_TYPE_MASK		UINT32_C(0x3f)
	#define BD_BASE_TYPE_SFT		0
	/*
	 * Indicates that this BD is 16B long and is used for
	 * normal L2 packet transmission.
	 */
		#define BD_BASE_TYPE_TX_BD_SHORT	UINT32_C(0x0)
	/*
	 * Indicates that this BD is 1BB long and is an empty
	 * TX BD. Not valid for use by the driver.
	 */
		#define BD_BASE_TYPE_TX_BD_EMPTY	UINT32_C(0x1)
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * (i.e. empty) buffer descriptor.
	 */
		#define BD_BASE_TYPE_RX_PROD_PKT	UINT32_C(0x4)
	/*
	 * Indicates that this BD is 16B long and is an RX
	 * Producer Buffer BD.
	 */
		#define BD_BASE_TYPE_RX_PROD_BFR	UINT32_C(0x5)
	/*
	 * Indicates that this BD is 16B long and is an
	 * RX Producer Assembly Buffer Descriptor.
	 */
		#define BD_BASE_TYPE_RX_PROD_AGG	UINT32_C(0x6)
	/*
	 * Indicates that this BD is used to issue a command to one of
	 * the mid-path destinations.
	 */
		#define BD_BASE_TYPE_TX_BD_MP_CMD	UINT32_C(0x8)
	/*
	 * Indicates that this BD is used to issue a cryptographic pre-
	 * sync command through the fast path and destined for TCE.
	 */
		#define BD_BASE_TYPE_TX_BD_PRESYNC_CMD  UINT32_C(0x9)
	/*
	 * Indicates a timed transmit BD. This is a 16b BD that is inserted
	 * into a packet BD chain immediately after the first BD. It is used
	 * to control the flow in a timed transmit operation.
	 */
		#define BD_BASE_TYPE_TX_BD_TIMEDTX	UINT32_C(0xa)
	/*
	 * Indicates that this BD is 32B long and is used for
	 * normal L2 packet transmission.
	 */
		#define BD_BASE_TYPE_TX_BD_LONG	UINT32_C(0x10)
	/*
	 * Indicates that this BD is 32B long and is used for
	 * L2 packet transmission for small packets that require
	 * low latency.
	 */
		#define BD_BASE_TYPE_TX_BD_LONG_INLINE  UINT32_C(0x11)
		#define BD_BASE_TYPE_LAST		BD_BASE_TYPE_TX_BD_LONG_INLINE
	uint8_t	unused_1[7];
} __attribute__((packed));

/* tx_bd_short (size:128b/16B) */

struct tx_bd_short {
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_SHORT_TYPE_MASK		UINT32_C(0x3f)
	#define TX_BD_SHORT_TYPE_SFT		0
	/*
	 * Indicates that this BD is 16B long and is used for
	 * normal L2 packet transmission.
	 */
		#define TX_BD_SHORT_TYPE_TX_BD_SHORT	UINT32_C(0x0)
		#define TX_BD_SHORT_TYPE_LAST		TX_BD_SHORT_TYPE_TX_BD_SHORT
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_BD_SHORT_FLAGS_SFT		6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor. This flag must be
	 * valid on every BD.
	 */
	#define TX_BD_SHORT_FLAGS_PACKET_END	UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in it's
	 * processing.
	 * If this bit
	 * is set to 0, then the packet will be completed normally.
	 *
	 * This bit must be valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_NO_CMPL	UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed
	 * in the ring by this packet.
	 * A value of 1 indicates that this BD is the only BD (and that
	 * it is a short BD). A value
	 * of 3 indicates either 3 short BDs or 1 long BD and one short
	 * BD in the packet. A value of 0 indicates
	 * that there are 32 BD locations in the packet (the maximum).
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_BD_CNT_MASK	UINT32_C(0x1f00)
	#define TX_BD_SHORT_FLAGS_BD_CNT_SFT	8
	/*
	 * This value is a hint for the length of the entire packet.
	 * It is used by the chip to optimize internal processing.
	 *
	 * The packet will be dropped if the hint is too short.
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_LHINT_MASK	UINT32_C(0x6000)
	#define TX_BD_SHORT_FLAGS_LHINT_SFT	13
	/* indicates packet length < 512B */
		#define TX_BD_SHORT_FLAGS_LHINT_LT512	(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
		#define TX_BD_SHORT_FLAGS_LHINT_LT1K	(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
		#define TX_BD_SHORT_FLAGS_LHINT_LT2K	(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
		#define TX_BD_SHORT_FLAGS_LHINT_GTE2K	(UINT32_C(0x3) << 13)
		#define TX_BD_SHORT_FLAGS_LHINT_LAST	TX_BD_SHORT_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_COAL_NOW	UINT32_C(0x8000)
	/*
	 * This is the length of the host physical buffer this BD describes
	 * in bytes.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD.
	 *
	 * This field must be valid on the first BD of a packet. If completion
	 * coalescing is enabled on the TX ring, it is suggested that the driver
	 * populate the opaque field to indicate the specific TX ring with which
	 * the completion is associated, then utilize the opaque and sq_cons_idx
	 * fields in the coalesced completion record to determine the specific
	 * packets that are to be completed on that ring.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD.
	 *
	 * This value must be valid on all BDs of a packet.
	 */
	uint64_t	addr;
} __attribute__((packed));

/* tx_bd_long (size:128b/16B) */

struct tx_bd_long {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/*
	 * This value indicates the type of buffer descriptor.
	 * packet.
	 */
	#define TX_BD_LONG_TYPE_MASK		UINT32_C(0x3f)
	#define TX_BD_LONG_TYPE_SFT		0
	/*
	 * Indicates that this BD is 32B long and is used for
	 * normal L2 packet transmission.
	 */
		#define TX_BD_LONG_TYPE_TX_BD_LONG	UINT32_C(0x10)
		#define TX_BD_LONG_TYPE_LAST		TX_BD_LONG_TYPE_TX_BD_LONG
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	#define TX_BD_LONG_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_BD_LONG_FLAGS_SFT		6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor. This flag must be
	 * valid on every BD.
	 */
	#define TX_BD_LONG_FLAGS_PACKET_END	UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in it's
	 * processing.
	 * If this bit
	 * is set to 0, then the packet will be completed normally.
	 *
	 * This bit must be valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_NO_CMPL	UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed
	 * in the ring by this packet.
	 * A value of 1 indicates that this BD is the only BD (and that
	 * it is a short BD). A value
	 * of 3 indicates either 3 short BDs or 1 long BD and one short
	 * BD in the packet. A value of 0 indicates
	 * that there are 32 BD locations in the packet (the maximum).
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_BD_CNT_MASK	UINT32_C(0x1f00)
	#define TX_BD_LONG_FLAGS_BD_CNT_SFT	8
	/*
	 * This value is a hint for the length of the entire packet.
	 * It is used by the chip to optimize internal processing.
	 *
	 * The packet will be dropped if the hint is too short.
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_LHINT_MASK	UINT32_C(0x6000)
	#define TX_BD_LONG_FLAGS_LHINT_SFT	13
	/* indicates packet length < 512B */
		#define TX_BD_LONG_FLAGS_LHINT_LT512	(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
		#define TX_BD_LONG_FLAGS_LHINT_LT1K	(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
		#define TX_BD_LONG_FLAGS_LHINT_LT2K	(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
		#define TX_BD_LONG_FLAGS_LHINT_GTE2K	(UINT32_C(0x3) << 13)
		#define TX_BD_LONG_FLAGS_LHINT_LAST	TX_BD_LONG_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_COAL_NOW	UINT32_C(0x8000)
	/*
	 * This is the length of the host physical buffer this BD describes
	 * in bytes.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is passed through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD.
	 *
	 * This field must be valid on the first BD of a packet. If completion
	 * coalescing is enabled on the TX ring, it is suggested that the driver
	 * populate the opaque field to indicate the specific TX ring with which
	 * the completion is associated, then utilize the opaque and sq_cons_idx
	 * fields in the coalesced completion record to determine the specific
	 * packets that are to be completed on that ring.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD.
	 *
	 * This value must be valid on all BDs of a packet.
	 */
	uint64_t	addr;
} __attribute__((packed));

/* Last 16 bytes of tx_bd_long. */
/* tx_bd_long_hi (size:128b/16B) */

struct tx_bd_long_hi {
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	uint16_t	lflags;
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum
	 * fields of normal TCP/UPD checksum, or the inner TCP/UDP
	 * checksum field of the encapsulated TCP/UDP packets with the
	 * hardware calculated TCP/UDP checksum for the packet associated
	 * with this descriptor. The flag is ignored if the LSO flag is set.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_TCP_UDP_CHKSUM	UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the
	 * normal packets, or the inner IP checksum of the encapsulated
	 * packets with the hardware calculated IP checksum for the
	 * packet associated with this descriptor.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_IP_CHKSUM	UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC
	 * to the end of the frame.
	 *
	 * This bit must be valid on the first BD of a packet.
	 *
	 * Packet must be 64B or longer when this flag is set. It is not
	 * useful to use this bit with any form of TX offload such as
	 * CSO or LSO. The intent is that the packet from the host already
	 * has a valid Ethernet CRC on the packet.
	 */
	#define TX_BD_LONG_LFLAGS_NOCRC		UINT32_C(0x4)
	/*
	 * This bit, in conjunction with the stamp_1step bit, controls whether
	 * a TX packet timestamp is collected and the type of timestamp that
	 * is collected.
	 *
	 * This bit must be valid on the first BD of a packet.
	 *
	 * Enumerations of the concatenation { stamp, stamp_1step } are
	 * as follows:
	 *
	 * - 2'b00: ts_none - no timestamp
	 * - 2'b01: ts_ptp_1step - 1-step PTP
	 * - 2'b10: ts_2cmpl - 2-step PTP timestamp or PA timestamp
	 * - 2'b11: ts_rsvd - reserved, same behavior as ts_none
	 * For the ts_2cmpl enumeration, an additional completion is returned.
	 * This additional completion may carry a 2-step PTP timestamp or a PA
	 * timestamp, depending on parsing of the transmitted packet.
	 */
	#define TX_BD_LONG_LFLAGS_STAMP		UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header
	 * of the packet associated with this descriptor.
	 *
	 * For outer UDP checksum, global outer UDP checksum TE_NIC register
	 * needs to be enabled. If the global outer UDP checksum TE_NIC
	 * register bit is set, outer UDP checksum will be calculated for
	 * the following cases:
	 * 1. Packets with tcp_udp_chksum flag set to offload checksum for
	 * inner packet AND the inner packet is TCP/UDP. If the inner packet
	 * is ICMP for example (non-TCP/UDP), even if the tcp_udp_chksum is
	 * set, the outer UDP checksum will not be calculated.
	 * 2. Packets with lso flag set which implies inner TCP checksum
	 * calculation as part of LSO operation.
	 */
	#define TX_BD_LONG_LFLAGS_T_IP_CHKSUM	UINT32_C(0x10)
	/*
	 * If set to 1, the device will treat this packet with LSO(Large
	 * Send Offload) processing for both normal or encapsulated
	 * packets, which is a form of TCP segmentation. When this bit
	 * is 1, the hdr_size and mss fields must be valid. The driver
	 * doesn't need to set ot_ip_chksum, t_ip_chksum, ip_chksum, and
	 * tcp_udp_chksum flags since the controller will replace the
	 * appropriate checksum fields for segmented packets.
	 *
	 * When this bit is 1, the hdr_size and mss fields must be valid.
	 */
	#define TX_BD_LONG_LFLAGS_LSO		UINT32_C(0x20)
	/*
	 * If set to zero when LSO is '1', then the IPID will be treated
	 * as a 16b number and will be wrapped if it exceeds a value of
	 * 0xffff.
	 *
	 * If set to one when LSO is '1', then the IPID will be treated
	 * as a 15b number and will be wrapped if it exceeds a value of
	 * 0x7fff.
	 */
	#define TX_BD_LONG_LFLAGS_IPID_FMT	UINT32_C(0x40)
	/*
	 * If set to zero when LSO is '1', then the IPID of the tunnel
	 * IP header will not be modified during LSO operations.
	 *
	 * If set to one when LSO is '1', then the IPID of the tunnel
	 * IP header will be incremented for each subsequent segment of an
	 * LSO operation.
	 *
	 * The flag is ignored if the LSO packet is a normal (non-tunneled)
	 * TCP packet.
	 */
	#define TX_BD_LONG_LFLAGS_T_IPID		UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the
	 * packet. Packet must be a valid RoCE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_ROCE_CRC	UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the
	 * packet. Packet must be a valid FCoE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_FCOE_CRC	UINT32_C(0x200)
	/*
	 * If set to '1', then the timestamp from the BD is used. If cleared
	 * to 0, then TWE provides the timestamp.
	 */
	/*
	 * The BD timestamp feature cannot be enabled concurrently with
	 * cryptography (KTLS), thus lflags.bd_ts_en and lflags.crypto_en
	 * shall never both be set in a BD.
	 */
	#define TX_BD_LONG_LFLAGS_BD_TS_EN	UINT32_C(0x400)
	/*
	 * If set to '1', this operation will cause a trace capture in each
	 * block it passes through.
	 */
	#define TX_BD_LONG_LFLAGS_DEBUG_TRACE	UINT32_C(0x800)
	/*
	 * This bit, in conjunction with the stamp bit, controls whether a
	 * TX packet timestamp is collected and the type of timestamp that
	 * is collected.
	 *
	 * See the stamp field for a description of the valid combinations of
	 * stamp and stamp_1step.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_STAMP_1STEP	UINT32_C(0x1000)
	/*
	 * If set to '1', the controller replaces the Outer-tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header of the
	 * packet associated with this descriptor. For outer UDP checksum, it
	 * will be the following behavior for all cases independent of
	 * settings of inner LSO and checksum offload BD flags.
	 * If outer UDP checksum is 0, then do not update it.
	 * If outer UDP checksum is non zero, then the hardware should
	 * compute and update it.
	 */
	#define TX_BD_LONG_LFLAGS_OT_IP_CHKSUM	UINT32_C(0x2000)
	/*
	 * If set to zero when LSO is '1', then the IPID of the Outer-tunnel
	 * IP header will not be modified during LSO operations. If set to one
	 * when LSO is '1', then the IPID of the Outer-tunnel IP header will
	 * be incremented for each subsequent segment of an LSO operation. The
	 * flag is ignored if the LSO packet is a normal (non-tunneled) TCP
	 * packet.
	 */
	#define TX_BD_LONG_LFLAGS_OT_IPID		UINT32_C(0x4000)
	/*
	 * If set to '1', When set to 1, KTLS encryption will be enabled for
	 * the packet.
	 */
	/*
	 * The BD timestamp feature cannot be enabled concurrently with
	 * cryptography (KTLS), thus lflags.bd_ts_en and lflags.crypto_en
	 * shall never both be set in a BD.
	 */
	#define TX_BD_LONG_LFLAGS_CRYPTO_EN	UINT32_C(0x8000)
	uint16_t	kid_or_ts_low_hdr_size;
	/*
	 * When LSO is '1', this field must contain the offset of the
	 * TCP payload from the beginning of the packet in as
	 * 16b words. In case of encapsulated/tunneling packet, this field
	 * contains the offset of the inner TCP payload from beginning of the
	 * packet as 16-bit words.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_HDR_SIZE_MASK	UINT32_C(0x1ff)
	#define TX_BD_LONG_HDR_SIZE_SFT	0
	/*
	 * If lflags.bd_ts_en is 1, this is the lower 7 bits of the 24-bit
	 * timestamp. If lflags.crypto_en is 1, this is the lower 7 bits of
	 * the 20-bit KID.
	 */
	/*
	 * The KID value of all-ones is reserved for non-KTLS packets, which
	 * only implies that this value must not be used when filling this
	 * field for crypto packets.
	 */
	#define TX_BD_LONG_KID_OR_TS_LOW_MASK UINT32_C(0xfe00)
	#define TX_BD_LONG_KID_OR_TS_LOW_SFT 9
	uint32_t	kid_or_ts_high_mss;
	/*
	 * This is the MSS value that will be used to do the LSO processing.
	 * The value is the length in bytes of the TCP payload for each
	 * segment generated by the LSO operation.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_MSS_MASK	UINT32_C(0x7fff)
	#define TX_BD_LONG_MSS_SFT		0
	/*
	 * If lflags.bd_ts_en is 1, this is the upper 17 bits of the 24-bit
	 * timestamp. If lflags.crypto_en is 1, the least significant 13 bits
	 * of this field contain the upper 13 bits of the 20-bit KID.
	 */
	/*
	 * The KID value of all-ones is reserved for non-KTLS packets, which
	 * only implies that this value must not be used when filling this
	 * field for crypto packets.
	 */
	#define TX_BD_LONG_KID_OR_TS_HIGH_MASK UINT32_C(0xffff8000)
	#define TX_BD_LONG_KID_OR_TS_HIGH_SFT 15
	/*
	 * This value selects bits 25:16 of the CFA action to perform on the
	 * packet. See the cfa_action field for more information.
	 */
	uint16_t	cfa_action_high;
	#define TX_BD_LONG_CFA_ACTION_HIGH_MASK UINT32_C(0x3ff)
	#define TX_BD_LONG_CFA_ACTION_HIGH_SFT 0
	/*
	 * This value selects a CFA action to perform on the packet.
	 * Set this value to zero if no CFA action is desired.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	uint16_t	cfa_action;
	/*
	 * This value is action meta-data that defines CFA edit operations
	 * that are done in addition to any action editing.
	 */
	uint32_t	cfa_meta;
	/* When key=1, This is the VLAN tag VID value. */
	#define TX_BD_LONG_CFA_META_VLAN_VID_MASK	UINT32_C(0xfff)
	#define TX_BD_LONG_CFA_META_VLAN_VID_SFT	0
	/* When key=1, This is the VLAN tag DE value. */
	#define TX_BD_LONG_CFA_META_VLAN_DE		UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define TX_BD_LONG_CFA_META_VLAN_PRI_MASK	UINT32_C(0xe000)
	#define TX_BD_LONG_CFA_META_VLAN_PRI_SFT	13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_MASK	UINT32_C(0x70000)
	#define TX_BD_LONG_CFA_META_VLAN_TPID_SFT	16
	/* 0x88a8 */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID88A8	(UINT32_C(0x0) << 16)
	/* 0x8100 */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID8100	(UINT32_C(0x1) << 16)
	/* 0x9100 */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9100	(UINT32_C(0x2) << 16)
	/* 0x9200 */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9200	(UINT32_C(0x3) << 16)
	/* 0x9300 */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9300	(UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
		#define TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG	(UINT32_C(0x5) << 16)
		#define TX_BD_LONG_CFA_META_VLAN_TPID_LAST	TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_MASK   UINT32_C(0xff80000)
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_SFT	19
	/*
	 * This field identifies the type of edit to be performed
	 * on the packet.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_CFA_META_KEY_MASK		UINT32_C(0xf0000000)
	#define TX_BD_LONG_CFA_META_KEY_SFT		28
	/* No editing */
		#define TX_BD_LONG_CFA_META_KEY_NONE		(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100).
	 * - meta[15:12] - PRI/DE value.
	 * - meta[11:0] - VID value.
	 */
		#define TX_BD_LONG_CFA_META_KEY_VLAN_TAG	(UINT32_C(0x1) << 28)
	/*
	 * Provide metadata
	 * - Wh+/SR - this option is not supported.
	 * - Thor - cfa_meta[15:0] is used for metadata output if en_bd_meta
	 *   is set in the Lookup Table.
	 * - SR2 - {4'd0, cfa_meta[27:0]} is used for metadata output if
	 *   en_bd_meta is set in the Lookup Table.
	 */
		#define TX_BD_LONG_CFA_META_KEY_METADATA_TRANSFER  (UINT32_C(0x2) << 28)
		#define TX_BD_LONG_CFA_META_KEY_LAST		TX_BD_LONG_CFA_META_KEY_METADATA_TRANSFER
} __attribute__((packed));

/*
 * This structure is used to inform the NIC of packet data that needs to
 * be transmitted with additional processing that requires extra data
 * such as VLAN insertion plus attached inline data.
 * This BD type may be used to improve latency for small packets needing
 * the additional extended features supported by long BDs.
 */
/* tx_bd_long_inline (size:256b/32B) */

struct tx_bd_long_inline {
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_LONG_INLINE_TYPE_MASK		UINT32_C(0x3f)
	#define TX_BD_LONG_INLINE_TYPE_SFT		0
	/*
	 * This type of BD is 32B long and is used for inline L2 packet
	 * transmission.
	 */
		#define TX_BD_LONG_INLINE_TYPE_TX_BD_LONG_INLINE  UINT32_C(0x11)
		#define TX_BD_LONG_INLINE_TYPE_LAST		TX_BD_LONG_INLINE_TYPE_TX_BD_LONG_INLINE
	/*
	 * All bits in this field may be set on the first BD of a packet.
	 * Only the packet_end bit may be set in non-first BDs.
	 */
	#define TX_BD_LONG_INLINE_FLAGS_MASK		UINT32_C(0xffc0)
	#define TX_BD_LONG_INLINE_FLAGS_SFT		6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor. This flag must be
	 * valid on every BD.
	 */
	#define TX_BD_LONG_INLINE_FLAGS_PACKET_END	UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in its processing.
	 * If this bit is set to 0, then the packet will be completed
	 * normally.
	 *
	 * This bit may be set only on the first BD of a packet.
	 */
	#define TX_BD_LONG_INLINE_FLAGS_NO_CMPL	UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed
	 * in the ring by this packet, including the BD and inline
	 * data.
	 */
	#define TX_BD_LONG_INLINE_FLAGS_BD_CNT_MASK	UINT32_C(0x1f00)
	#define TX_BD_LONG_INLINE_FLAGS_BD_CNT_SFT	8
	/* This field is deprecated. */
	#define TX_BD_LONG_INLINE_FLAGS_LHINT_MASK	UINT32_C(0x6000)
	#define TX_BD_LONG_INLINE_FLAGS_LHINT_SFT	13
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_INLINE_FLAGS_COAL_NOW	UINT32_C(0x8000)
	/*
	 * This is the length of the inline data, not including BD length, in
	 * bytes.
	 * The maximum value is 480.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	/*
	 * A fatal error will be generated if the value of this field
	 * does not correspond with the value of flags.bd_cnt. For example, if
	 * this field carries a value of 20, then bd_cnt must equal 4.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is passed through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD. This field must be valid on the first BD of a packet.
	 * If completion coalescing is enabled on the TX ring, it is suggested
	 * that the driver populate the opaque field to indicate the specific
	 * TX ring with which the completion is associated, then utilize the
	 * opaque and sq_cons_idx fields in the coalesced completion record to
	 * determine the specific packets that are to be completed on that ring.
	 *
	 * This field must be valid on the first BD of a packet.
	 */
	uint32_t	opaque;
	uint64_t	unused1;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet is ignored.
	 */
	uint16_t	lflags;
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum
	 * fields of normal TCP/UPD checksum, or the inner TCP/UDP
	 * checksum field of the encapsulated TCP/UDP packets with the
	 * hardware calculated TCP/UDP checksum for the packet associated
	 * with this descriptor. The flag is ignored if the LSO flag is set.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_TCP_UDP_CHKSUM	UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the
	 * normal packets, or the inner IP checksum of the encapsulated
	 * packets with the hardware calculated IP checksum for the
	 * packet associated with this descriptor.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_IP_CHKSUM	UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC
	 * to the end of the frame.
	 *
	 * Packet must be 64B or longer when this flag is set. It is not
	 * useful to use this bit with any form of TX offload such as
	 * CSO or LSO. The intent is that the packet from the host already
	 * has a valid Ethernet CRC on the packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_NOCRC		UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet
	 * was actually transmitted at the TX MAC for 2-step time sync. This
	 * bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_STAMP		UINT32_C(0x8)
	/*
	 * If set to 1, the controller replaces the tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header
	 * of the packet associated with this descriptor. The hardware
	 * updates an outer UDP checksum if it is non-zero.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_T_IP_CHKSUM	UINT32_C(0x10)
	/*
	 * This bit must be 0 for BDs of this type. LSO is not supported with
	 * inline BDs.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_LSO		UINT32_C(0x20)
	/* Since LSO is not supported with inline BDs, this bit is not used. */
	#define TX_BD_LONG_INLINE_LFLAGS_IPID_FMT	UINT32_C(0x40)
	/* Since LSO is not supported with inline BDs, this bit is not used. */
	#define TX_BD_LONG_INLINE_LFLAGS_T_IPID		UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the
	 * packet. Packet must be a valid RoCE format packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_ROCE_CRC	UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the
	 * packet. Packet must be a valid FCoE format packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_FCOE_CRC	UINT32_C(0x200)
	/*
	 * If set to '1', then the timestamp from the BD is used. If cleared
	 * to 0, then TWE provides the timestamp.
	 */
	/*
	 * The BD timestamp feature cannot be enabled concurrently with
	 * cryptography (KTLS), thus lflags.bd_ts_en and lflags.crypto_en
	 * shall never both be set in a BD.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_BD_TS_EN	UINT32_C(0x400)
	/*
	 * If set to '1', this operation will cause a trace capture in each
	 * block it passes through.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_DEBUG_TRACE	UINT32_C(0x800)
	/*
	 * If set to '1', the device will record the time at which the packet
	 * was actually transmitted at the TX MAC for 1-step time sync. This
	 * bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_STAMP_1STEP	UINT32_C(0x1000)
	/*
	 * If set to '1', the controller replaces the Outer-tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header of the
	 * packet associated with this descriptor. For outer UDP checksum, it
	 * will be the following behavior for all cases independent of settings
	 * of inner LSO and checksum offload BD flags. If outer UDP checksum
	 * is 0, then do not update it. If outer UDP checksum is non zero, then
	 * the hardware should compute and update it.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_OT_IP_CHKSUM	UINT32_C(0x2000)
	/*
	 * If set to zero when LSO is '1', then the IPID of the Outer-tunnel IP
	 * header will not be modified during LSO operations. If set to one
	 * when LSO is '1', then the IPID of the Outer-tunnel IP header will be
	 * incremented for each subsequent segment of an LSO operation. The
	 * flag is ignored if the LSO packet is a normal (non-tunneled) TCP
	 * packet.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_OT_IPID		UINT32_C(0x4000)
	/*
	 * If set to '1', When set to 1, KTLS encryption will be enabled for
	 * the packet.
	 */
	/*
	 * The BD timestamp feature cannot be enabled concurrently with
	 * cryptography (KTLS), thus lflags.bd_ts_en and lflags.crypto_en
	 * shall never both be set in a BD.
	 */
	#define TX_BD_LONG_INLINE_LFLAGS_CRYPTO_EN	UINT32_C(0x8000)
	uint8_t	unused2;
	uint8_t	kid_or_ts_low;
	#define TX_BD_LONG_INLINE_UNUSED		UINT32_C(0x1)
	/*
	 * If lflags.bd_ts_en is 1, this is the lower 7 bits of the 24-bit
	 * timestamp. If lflags.crypto_en is 1, this is the lower 7 bits of
	 * the 20-bit KID.
	 */
	/*
	 * The KID value of all-ones is reserved for non-KTLS packets, which
	 * only implies that this value must not be used when filling this
	 * field for crypto packets.
	 */
	#define TX_BD_LONG_INLINE_KID_OR_TS_LOW_MASK UINT32_C(0xfe)
	#define TX_BD_LONG_INLINE_KID_OR_TS_LOW_SFT 1
	uint32_t	kid_or_ts_high;
	#define TX_BD_LONG_INLINE_UNUSED_MASK	UINT32_C(0x7fff)
	#define TX_BD_LONG_INLINE_UNUSED_SFT	0
	/*
	 * If lflags.bd_ts_en is 1, this is the upper 17 bits of the 24-bit
	 * timestamp. If lflags.crypto_en is 1, the least significant 13 bits
	 * of this field contain the upper 13 bits of the 20-bit KID.
	 */
	/*
	 * The KID value of all-ones is reserved for non-KTLS packets, which
	 * only implies that this value must not be used when filling this
	 * field for crypto packets.
	 */
	#define TX_BD_LONG_INLINE_KID_OR_TS_HIGH_MASK UINT32_C(0xffff8000)
	#define TX_BD_LONG_INLINE_KID_OR_TS_HIGH_SFT 15
	/*
	 * This value selects bits 25:16 of the CFA action to perform on the
	 * packet. See the cfa_action field for more information.
	 */
	uint16_t	cfa_action_high;
	#define TX_BD_LONG_INLINE_CFA_ACTION_HIGH_MASK UINT32_C(0x3ff)
	#define TX_BD_LONG_INLINE_CFA_ACTION_HIGH_SFT 0
	/*
	 * This value selects a CFA action to perform on the packet.
	 * Set this value to zero if no CFA action is desired.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	uint16_t	cfa_action;
	/*
	 * This value is action meta-data that defines CFA edit operations
	 * that are done in addition to any action editing.
	 */
	uint32_t	cfa_meta;
	/* When key = 1, this is the VLAN tag VID value. */
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_VID_MASK	UINT32_C(0xfff)
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_VID_SFT	0
	/* When key = 1, this is the VLAN tag DE value. */
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_DE		UINT32_C(0x1000)
	/* When key = 1, this is the VLAN tag PRI value. */
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_PRI_MASK	UINT32_C(0xe000)
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_PRI_SFT	13
	/* When key = 1, this is the VLAN tag TPID select value. */
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_MASK	UINT32_C(0x70000)
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_SFT	16
	/* 0x88a8 */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPID88A8	(UINT32_C(0x0) << 16)
	/* 0x8100 */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPID8100	(UINT32_C(0x1) << 16)
	/* 0x9100 */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPID9100	(UINT32_C(0x2) << 16)
	/* 0x9200 */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPID9200	(UINT32_C(0x3) << 16)
	/* 0x9300 */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPID9300	(UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPIDCFG	(UINT32_C(0x5) << 16)
		#define TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_LAST	TX_BD_LONG_INLINE_CFA_META_VLAN_TPID_TPIDCFG
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_RESERVED_MASK   UINT32_C(0xff80000)
	#define TX_BD_LONG_INLINE_CFA_META_VLAN_RESERVED_SFT	19
	/*
	 * This field identifies the type of edit to be performed
	 * on the packet.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_INLINE_CFA_META_KEY_MASK		UINT32_C(0xf0000000)
	#define TX_BD_LONG_INLINE_CFA_META_KEY_SFT		28
	/* No editing */
		#define TX_BD_LONG_INLINE_CFA_META_KEY_NONE		(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100).
	 * - meta[15:12] - PRI/DE value.
	 * - meta[11:0] - VID value.
	 */
		#define TX_BD_LONG_INLINE_CFA_META_KEY_VLAN_TAG	(UINT32_C(0x1) << 28)
	/*
	 * Provide metadata
	 * - Wh+/SR - this option is not supported.
	 * - Thor - cfa_meta[15:0] is used for metadata output if en_bd_meta
	 *   is set in the Lookup Table.
	 * - SR2 - {4'd0, cfa_meta[27:0]} is used for metadata output if
	 *   en_bd_meta is set in the Lookup Table.
	 */
		#define TX_BD_LONG_INLINE_CFA_META_KEY_METADATA_TRANSFER  (UINT32_C(0x2) << 28)
		#define TX_BD_LONG_INLINE_CFA_META_KEY_LAST		TX_BD_LONG_INLINE_CFA_META_KEY_METADATA_TRANSFER
} __attribute__((packed));

/* tx_bd_empty (size:128b/16B) */

struct tx_bd_empty {
	/* This value identifies the type of buffer descriptor. */
	uint8_t	type;
	#define TX_BD_EMPTY_TYPE_MASK	UINT32_C(0x3f)
	#define TX_BD_EMPTY_TYPE_SFT	0
	/*
	 * Indicates that this BD is 1BB long and is an empty
	 * TX BD. Not valid for use by the driver.
	 */
		#define TX_BD_EMPTY_TYPE_TX_BD_EMPTY  UINT32_C(0x1)
		#define TX_BD_EMPTY_TYPE_LAST	TX_BD_EMPTY_TYPE_TX_BD_EMPTY
	uint8_t	unused_1[3];
	uint8_t	unused_2;
	uint8_t	unused_3[3];
	uint8_t	unused_4[8];
} __attribute__((packed));

/* tx_bd_mp_cmd (size:128b/16B) */

struct tx_bd_mp_cmd {
	/* Unless otherwise stated, sub-fields of this field are always valid. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_MP_CMD_TYPE_MASK	UINT32_C(0x3f)
	#define TX_BD_MP_CMD_TYPE_SFT	0
	/*
	 * Indicates that this BD is used to issue a command to one of
	 * the mid-path destinations.
	 */
		#define TX_BD_MP_CMD_TYPE_TX_BD_MP_CMD  UINT32_C(0x8)
		#define TX_BD_MP_CMD_TYPE_LAST	TX_BD_MP_CMD_TYPE_TX_BD_MP_CMD
	#define TX_BD_MP_CMD_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_BD_MP_CMD_FLAGS_SFT	6
	/*  */
	#define TX_BD_MP_CMD_FLAGS_UNUSED_MASK UINT32_C(0xc0)
	#define TX_BD_MP_CMD_FLAGS_UNUSED_SFT  6
	/*
	 * This value indicates the number of 16B BD locations (slots)
	 * consumed in the ring by this mid-path command BD, including the
	 * BD header and the command field.
	 */
	#define TX_BD_MP_CMD_FLAGS_BD_CNT_MASK UINT32_C(0x1f00)
	#define TX_BD_MP_CMD_FLAGS_BD_CNT_SFT  8
	/*
	 * This value defines the length of command field in bytes. The maximum
	 * value shall be 496.
	 */
	/*
	 * Note that a fatal error will be generated if the value of this field
	 * does not correspond with the value of flags.bd_cnt. For example, if
	 * this field carries a value of 20, then bd_cnt must equal 3.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * Tx mid-path command.
	 */
	uint32_t	opaque;
	uint64_t	unused1;
} __attribute__((packed));

/* tx_bd_presync_cmd (size:128b/16B) */

struct tx_bd_presync_cmd {
	/* Unless otherwise stated, sub-fields of this field are always valid. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_PRESYNC_CMD_TYPE_MASK		UINT32_C(0x3f)
	#define TX_BD_PRESYNC_CMD_TYPE_SFT		0
	/*
	 * Indicates that this BD is used to issue a cryptographic pre-
	 * sync command through the fast path and destined for TCE.
	 */
		#define TX_BD_PRESYNC_CMD_TYPE_TX_BD_PRESYNC_CMD  UINT32_C(0x9)
		#define TX_BD_PRESYNC_CMD_TYPE_LAST		TX_BD_PRESYNC_CMD_TYPE_TX_BD_PRESYNC_CMD
	#define TX_BD_PRESYNC_CMD_FLAGS_MASK		UINT32_C(0xffc0)
	#define TX_BD_PRESYNC_CMD_FLAGS_SFT		6
	/*  */
	#define TX_BD_PRESYNC_CMD_FLAGS_UNUSED_MASK	UINT32_C(0xc0)
	#define TX_BD_PRESYNC_CMD_FLAGS_UNUSED_SFT	6
	/*
	 * This value indicates the number of 16B BD locations (slots)
	 * consumed in the ring by this pre-sync command BD, including the
	 * BD header and the command field.
	 */
	#define TX_BD_PRESYNC_CMD_FLAGS_BD_CNT_MASK	UINT32_C(0x1f00)
	#define TX_BD_PRESYNC_CMD_FLAGS_BD_CNT_SFT	8
	/*
	 * This value defines the length of command field in bytes. The maximum
	 * value shall be 496.
	 */
	/*
	 * Note that a fatal error will be generated if the value of this field
	 * does not correspond with the value of flags.bd_cnt. For example, if
	 * this field carries a value of 20, then bd_cnt must equal 3.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to TCE and can be used for
	 * debug.
	 */
	uint32_t	opaque;
	/*
	 * This field is the Crypto Context ID to which the retransmit packet is
	 * applied. The KID references the context fields used by the
	 * associated kTLS offloaded connection.
	 */
	uint32_t	kid;
	/*
	 * The KID value of all-ones is reserved for non-KTLS packets, which
	 * only implies that this value must not be used when filling this
	 * field for crypto packets.
	 */
	#define TX_BD_PRESYNC_CMD_KID_VAL_MASK UINT32_C(0xfffff)
	#define TX_BD_PRESYNC_CMD_KID_VAL_SFT 0
	uint32_t	unused_1;
} __attribute__((packed));

/*
 * This structure is used to send additional information for transmitting
 * packets using timed transmit scheduling. It must only to be applied as
 * the second BD of a BD chain that represents a packet. Any subsequent
 * BDs will follow the timed transmit BD.
 */
/* tx_bd_timedtx (size:128b/16B) */

struct tx_bd_timedtx {
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_TIMEDTX_TYPE_MASK	UINT32_C(0x3f)
	#define TX_BD_TIMEDTX_TYPE_SFT		0
	/*
	 * Indicates a timed transmit BD. This is a 16b BD that is inserted
	 * into a packet BD chain immediately after the first BD. It is used
	 * to control the flow in a timed transmit operation.
	 */
		#define TX_BD_TIMEDTX_TYPE_TX_BD_TIMEDTX	UINT32_C(0xa)
		#define TX_BD_TIMEDTX_TYPE_LAST		TX_BD_TIMEDTX_TYPE_TX_BD_TIMEDTX
	/* Unless otherwise stated, sub-fields of this field are always valid. */
	#define TX_BD_TIMEDTX_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_BD_TIMEDTX_FLAGS_SFT	6
	/*
	 * This value identifies the kind of buffer timed transmit mode that
	 * is to be enabled for the packet.
	 */
	#define TX_BD_TIMEDTX_FLAGS_KIND_MASK	UINT32_C(0x1c0)
	#define TX_BD_TIMEDTX_FLAGS_KIND_SFT	6
	/*
	 * This timed transmit mode indicates that the packet will be
	 * scheduled and send immediately (or as soon as possible), once
	 * it is scheduled in the transmitter.
	 * Note: This mode is similar to regular (non-timed transmit)
	 * operation. Its main purpose is to cancel pace mode timed
	 * transmit.
	 */
		#define TX_BD_TIMEDTX_FLAGS_KIND_ASAP	(UINT32_C(0x0) << 6)
	/*
	 * This timed transmit mode is used to schedule transmission of
	 * the packet no earlier than the time given in the tx_time
	 * field of the BD.
	 * Note: In case subsequent packets don't include a timed transmit
	 * BD, they will be scheduled subsequently for transmission
	 * without any timed transmit constraint.
	 */
		#define TX_BD_TIMEDTX_FLAGS_KIND_SO_TXTIME   (UINT32_C(0x1) << 6)
	/*
	 * This timed transmit mode is used to enable rate control for the
	 * flow (QP) at a rate as defined by the rate field of this BD.
	 * Note: In case subsequent, adjacent packets on the same flow
	 * don't include a timed transmit BD, they will continue to be
	 * paced by the transmitter at the same rate as given in this BD.
	 */
		#define TX_BD_TIMEDTX_FLAGS_KIND_PACE	(UINT32_C(0x2) << 6)
		#define TX_BD_TIMEDTX_FLAGS_KIND_LAST	TX_BD_TIMEDTX_FLAGS_KIND_PACE
	/*
	 * This field exists in all Tx BDs. It doesn't apply to this particular
	 * BD type since the BD never represents an SGL or inline data; i.e. it
	 * is only a command. This field must be zero.
	 */
	/*
	 * Note that if this field is not zero, a fatal length error will be
	 * generated as it will be included in the aggregate of SGE lengths for
	 * the packet.
	 */
	uint16_t	len;
	/*
	 * This field represents the rate of the flow (QP) in terms of KB/s.
	 * This applies to pace mode timed transmit.
	 */
	uint32_t	rate;
	/*
	 * Applying this rate to a QP will result in this and all subsequent
	 * packets of the flow being paced at the given rate, until such time
	 * that the timed transmit mode is either changed or the rate is
	 * updated in a future packet on the flow.
	 * This field is applicable only if flags.kind is pace.
	 */
	#define TX_BD_TIMEDTX_RATE_VAL_MASK UINT32_C(0x1ffffff)
	#define TX_BD_TIMEDTX_RATE_VAL_SFT 0
	/*
	 * This field represents the nano-second time to transmit the
	 * corresponding packet using SO_TXTIME mode of timed transmit.
	 * This field is applicable only if flags.kind is so_txtime.
	 */
	uint64_t	tx_time;
} __attribute__((packed));

/* rx_prod_pkt_bd (size:128b/16B) */

struct rx_prod_pkt_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_PKT_BD_TYPE_MASK	UINT32_C(0x3f)
	#define RX_PROD_PKT_BD_TYPE_SFT	0
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * (i.e. empty) buffer descriptor.
	 */
		#define RX_PROD_PKT_BD_TYPE_RX_PROD_PKT	UINT32_C(0x4)
		#define RX_PROD_PKT_BD_TYPE_LAST	RX_PROD_PKT_BD_TYPE_RX_PROD_PKT
	#define RX_PROD_PKT_BD_FLAGS_MASK	UINT32_C(0xffc0)
	#define RX_PROD_PKT_BD_FLAGS_SFT	6
	/*
	 * If set to 1, the packet will be placed at the address plus
	 * 2B. The 2 Bytes of padding will be written as zero.
	 */
	/*
	 * This is intended to be used when the host buffer is
	 * cache-line aligned to produce packets that are easy to
	 * parse in host memory while still allowing writes to be cache
	 * line aligned.
	 */
	#define RX_PROD_PKT_BD_FLAGS_SOP_PAD	UINT32_C(0x40)
	/*
	 * If set to 1, the packet write will be padded out to the
	 * nearest cache-line with zero value padding.
	 */
	/*
	 * If receive buffers start/end on cache-line boundaries, this
	 * feature will ensure that all data writes on the PCI bus
	 * start/end on cache line boundaries.
	 */
	#define RX_PROD_PKT_BD_FLAGS_EOP_PAD	UINT32_C(0x80)
	/*
	 * This field has been deprecated. There can be no additional
	 * BDs for this packet from this ring.
	 *
	 * Old definition:
	 * This value is the number of additional buffers in the ring that
	 * describe the buffer space to be consumed for this packet.
	 * If the value is zero, then the packet must fit within the
	 * space described by this BD. If this value is 1 or more, it
	 * indicates how many additional "buffer" BDs are in the ring
	 * immediately following this BD to be used for the same
	 * network packet. Even if the packet to be placed does not need
	 * all the additional buffers, they will be consumed anyway.
	 */
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_MASK UINT32_C(0x300)
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_SFT  8
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provided end on a host cache line.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive buffer set.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provide start on a host cache line.
	 */
	uint64_t	addr;
} __attribute__((packed));

/* rx_prod_bfr_bd (size:128b/16B) */

struct rx_prod_bfr_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_BFR_BD_TYPE_MASK	UINT32_C(0x3f)
	#define RX_PROD_BFR_BD_TYPE_SFT	0
	/*
	 * Indicates that this BD is 16B long and is an RX
	 * Producer Buffer BD.
	 */
		#define RX_PROD_BFR_BD_TYPE_RX_PROD_BFR  UINT32_C(0x5)
		#define RX_PROD_BFR_BD_TYPE_LAST	RX_PROD_BFR_BD_TYPE_RX_PROD_BFR
	#define RX_PROD_BFR_BD_FLAGS_MASK	UINT32_C(0xffc0)
	#define RX_PROD_BFR_BD_FLAGS_SFT	6
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provided end on a host cache line.
	 */
	uint16_t	len;
	/* This field is not used. */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provide start on a host cache line.
	 */
	uint64_t	addr;
} __attribute__((packed));

/* rx_prod_agg_bd (size:128b/16B) */

struct rx_prod_agg_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_AGG_BD_TYPE_MASK	UINT32_C(0x3f)
	#define RX_PROD_AGG_BD_TYPE_SFT	0
	/*
	 * Indicates that this BD is 16B long and is an
	 * RX Producer Assembly Buffer Descriptor.
	 */
		#define RX_PROD_AGG_BD_TYPE_RX_PROD_AGG	UINT32_C(0x6)
		#define RX_PROD_AGG_BD_TYPE_LAST	RX_PROD_AGG_BD_TYPE_RX_PROD_AGG
	#define RX_PROD_AGG_BD_FLAGS_MASK	UINT32_C(0xffc0)
	#define RX_PROD_AGG_BD_FLAGS_SFT	6
	/*
	 * If set to 1, the packet write will be padded out to the
	 * nearest cache-line with zero value padding.
	 */
	/*
	 * If receive buffers start/end on cache-line boundaries, this
	 * feature will ensure that all data writes on the PCI bus
	 * end on cache line boundaries.
	 */
	#define RX_PROD_AGG_BD_FLAGS_EOP_PAD	UINT32_C(0x40)
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provided end on a host cache line.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive assembly buffer.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous
	 * to ensure that the buffers provide start on a host cache line.
	 */
	uint64_t	addr;
} __attribute__((packed));

/* cfa_cmpls_cmp_data_msg (size:128b/16B) */

struct cfa_cmpls_cmp_data_msg {
	uint32_t	mp_client_dma_length_opcode_status_type;
	/*
	 * This field represents the Mid-Path client that generated the
	 * completion.
	 */
	/*
	 * This field indicates the exact type of the completion. By
	 * convention, the LSB identifies the length of the record in 16B
	 * units. Even values indicate 16B records. Odd values indicate 32B
	 * records.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_TYPE_MASK		UINT32_C(0x3f)
	#define CFA_CMPLS_CMP_DATA_MSG_TYPE_SFT		0
	/* Mid Path Short Completion with length = 16B. */
		#define CFA_CMPLS_CMP_DATA_MSG_TYPE_MID_PATH_SHORT	UINT32_C(0x1e)
		#define CFA_CMPLS_CMP_DATA_MSG_TYPE_LAST		CFA_CMPLS_CMP_DATA_MSG_TYPE_MID_PATH_SHORT
	/* This value indicates the status for the command. */
	#define CFA_CMPLS_CMP_DATA_MSG_STATUS_MASK		UINT32_C(0x3c0)
	#define CFA_CMPLS_CMP_DATA_MSG_STATUS_SFT		6
	/* Completed without error. */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_OK		(UINT32_C(0x0) << 6)
	/* Indicates an unsupported CFA opcode in the command. */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_UNSPRT_ERR	(UINT32_C(0x1) << 6)
	/*
	 * Indicates a CFA command formatting error. This error can occur on
	 * any of the supported CFA commands.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_FMT_ERR		(UINT32_C(0x2) << 6)
	/*
	 * Indicates an SVIF-Table scope error. This error can occur on any
	 * of the supported CFA commands.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_SCOPE_ERR	(UINT32_C(0x3) << 6)
	/*
	 * Indicates that the table_index is either outside of the
	 * table_scope range set by its EM_SIZE or, for EM Insert, it is in
	 * the static bucket range. This error can occur on EM Insert
	 * commands. It can also occur on Read, Read Clear, Write, and
	 * Invalidate commands if the table_type is EM.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_ADDR_ERR		(UINT32_C(0x4) << 6)
	/*
	 * Cache operation responded with an error. This error can occur on
	 * Read, Read Clear, Write, EM Insert, and EM Delete commands.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_CACHE_ERR	(UINT32_C(0x5) << 6)
	/*
	 * Indicates failure on EM Insert or EM Delete Command. Hash index
	 * and hash msb are returned in table_index and hash_msb fields.
	 * Dma_length is set to 1 if the bucket is also returned (as dma
	 * data).
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_EM_FAIL		(UINT32_C(0x6) << 6)
	/*
	 * Indicates no notifications were available on an Event Collection
	 * command.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_EVENT_COLLECT_FAIL  (UINT32_C(0x7) << 6)
		#define CFA_CMPLS_CMP_DATA_MSG_STATUS_LAST		CFA_CMPLS_CMP_DATA_MSG_STATUS_EVENT_COLLECT_FAIL
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED0_MASK		UINT32_C(0xc00)
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED0_SFT		10
	/* This is the opcode from the command. */
	#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_MASK		UINT32_C(0xff000)
	#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_SFT		12
	/*
	 * This is read command. From 32 to 128B can be read from a table
	 * using this command.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_READ		(UINT32_C(0x0) << 12)
	/*
	 * This is write command. From 32 to 128B can be written to a table
	 * using this command.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_WRITE		(UINT32_C(0x1) << 12)
	/*
	 * This is read-clear command. 32B can be read from a table and a 16b
	 * mask can be used to clear specific 16b units after the read as an
	 * atomic operation.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_READ_CLR		(UINT32_C(0x2) << 12)
	/*
	 * An exact match table insert will be attempted into the table. If
	 * there is a free location in the bucket, the payload will be
	 * written to the bucket.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_EM_INSERT	(UINT32_C(0x3) << 12)
	/* An exact match table delete will be attempted. */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_EM_DELETE	(UINT32_C(0x4) << 12)
	/*
	 * The specified table area will be invalidated. If it is needed
	 * again, it will be read from the backing store.
	 */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_INVALIDATE	(UINT32_C(0x5) << 12)
	/* Reads notification messages from the Host Notification Queue. */
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_EVENT_COLLECT	(UINT32_C(0x6) << 12)
		#define CFA_CMPLS_CMP_DATA_MSG_OPCODE_LAST		CFA_CMPLS_CMP_DATA_MSG_OPCODE_EVENT_COLLECT
	/*
	 * This field indicates the length of the DMA that accompanies the
	 * completion. Specified in units of DWords (32b). Valid values are
	 * between 0 and 128. A value of zero indicates that there is no DMA
	 * that accompanies the completion.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_DMA_LENGTH_MASK	UINT32_C(0xff00000)
	#define CFA_CMPLS_CMP_DATA_MSG_DMA_LENGTH_SFT	20
	/*
	 * This field represents the Mid-Path client that generated the
	 * completion.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_MASK	UINT32_C(0xf0000000)
	#define CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_SFT		28
	/* TX configurable flow processing block. */
		#define CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_TE_CFA	(UINT32_C(0x2) << 28)
	/* RX configurable flow processing block. */
		#define CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_RE_CFA	(UINT32_C(0x3) << 28)
		#define CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_LAST		CFA_CMPLS_CMP_DATA_MSG_MP_CLIENT_RE_CFA
	/*
	 * This is a copy of the opaque field from the mid path BD of this
	 * command.
	 */
	uint32_t	opaque;
	uint16_t	hash_msb_v;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will
	 * write 1. The odd passes will write 0.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_V		UINT32_C(0x1)
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED1_MASK UINT32_C(0xe)
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED1_SFT  1
	/*
	 * This is the upper 12b of the hash, returned on Exact Match
	 * Insertion/Deletion Commands.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_HASH_MSB_MASK UINT32_C(0xfff0)
	#define CFA_CMPLS_CMP_DATA_MSG_HASH_MSB_SFT 4
	/* This is the table type from the command. */
	uint8_t	table_type;
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED2_MASK	UINT32_C(0xf)
	#define CFA_CMPLS_CMP_DATA_MSG_UNUSED2_SFT	0
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_MASK  UINT32_C(0xf0)
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_SFT   4
	/* This command acts on the action table of the specified scope. */
		#define CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_ACTION  (UINT32_C(0x0) << 4)
	/* This command acts on the exact match table of the specified scope. */
		#define CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_EM	(UINT32_C(0x1) << 4)
		#define CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_LAST   CFA_CMPLS_CMP_DATA_MSG_TABLE_TYPE_EM
	uint8_t	table_scope;
	/* This is the table scope from the command. */
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_SCOPE_MASK UINT32_C(0x1f)
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_SCOPE_SFT 0
	uint32_t	table_index;
	/*
	 * This is the table index from the command (if it exists). However, if
	 * an Exact Match Insertion/Deletion command failed, then this is the
	 * table index of the calculated static hash bucket.
	 */
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_INDEX_MASK UINT32_C(0x3ffffff)
	#define CFA_CMPLS_CMP_DATA_MSG_TABLE_INDEX_SFT 0
} __attribute__((packed));

/* CFA Mid-Path 32B DMA Message */
/* cfa_dma32b_data_msg (size:256b/32B) */

struct cfa_dma32b_data_msg {
	/* DMA data value. */
	uint32_t	dta[8];
} __attribute__((packed));

/* CFA Mid-Path 64B DMA Message */
/* cfa_dma64b_data_msg (size:512b/64B) */

struct cfa_dma64b_data_msg {
	/* DMA data value. */
	uint32_t	dta[16];
} __attribute__((packed));

/* CFA Mid-Path 96B DMA Message */
/* cfa_dma96b_data_msg (size:768b/96B) */

struct cfa_dma96b_data_msg {
	/* DMA data value. */
	uint32_t	dta[24];
} __attribute__((packed));

/* CFA Mid-Path 128B DMA Message */
/* cfa_dma128b_data_msg (size:1024b/128B) */

struct cfa_dma128b_data_msg {
	/* DMA data value. */
	uint32_t	dta[32];
} __attribute__((packed));

/* ce_cmpls_cmp_data_msg (size:128b/16B) */

struct ce_cmpls_cmp_data_msg {
	uint16_t	client_subtype_type;
	/*
	 * This field indicates the exact type of the completion. By
	 * convention, the LSB identifies the length of the record in 16B
	 * units. Even values indicate 16B records. Odd values indicate 32B
	 * records.
	 */
	#define CE_CMPLS_CMP_DATA_MSG_TYPE_MASK	UINT32_C(0x3f)
	#define CE_CMPLS_CMP_DATA_MSG_TYPE_SFT	0
	/* Completion of a Mid Path Command. Length = 16B */
		#define CE_CMPLS_CMP_DATA_MSG_TYPE_MID_PATH_SHORT  UINT32_C(0x1e)
		#define CE_CMPLS_CMP_DATA_MSG_TYPE_LAST	CE_CMPLS_CMP_DATA_MSG_TYPE_MID_PATH_SHORT
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED0_MASK	UINT32_C(0xc0)
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED0_SFT	6
	/*
	 * This value indicates the CE sub-type operation that is being
	 * completed.
	 */
	#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_MASK	UINT32_C(0xf00)
	#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_SFT	8
	/* Completion Response for a Solicited Command. */
		#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_SOLICITED	(UINT32_C(0x0) << 8)
	/* Error Completion (Unsolicited). */
		#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_ERR	(UINT32_C(0x1) << 8)
	/* Re-Sync Completion (Unsolicited) */
		#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_RESYNC	(UINT32_C(0x2) << 8)
		#define CE_CMPLS_CMP_DATA_MSG_SUBTYPE_LAST	CE_CMPLS_CMP_DATA_MSG_SUBTYPE_RESYNC
	/*
	 * This field represents the Mid-Path client that generated the
	 * completion.
	 */
	#define CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_MASK	UINT32_C(0xf000)
	#define CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_SFT	12
	/* TX crypto engine block. */
		#define CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_TCE	(UINT32_C(0x0) << 12)
	/* RX crypto engine block. */
		#define CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_RCE	(UINT32_C(0x1) << 12)
		#define CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_LAST	CE_CMPLS_CMP_DATA_MSG_MP_CLIENT_RCE
	uint16_t	status;
	/* This value indicates the status for the command. */
	#define CE_CMPLS_CMP_DATA_MSG_STATUS_MASK	UINT32_C(0xf)
	#define CE_CMPLS_CMP_DATA_MSG_STATUS_SFT	0
	/* Completed without error. */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_OK	UINT32_C(0x0)
	/* CFCK load error. */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_CTX_LD_ERR   UINT32_C(0x1)
	/* FID check error. */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_FID_CHK_ERR  UINT32_C(0x2)
	/* Context kind / MP version mismatch error. */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_CTX_VER_ERR  UINT32_C(0x3)
	/* Unsupported Destination Connection ID Length. */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_DST_ID_ERR   UINT32_C(0x4)
	/*
	 * Invalid MP Command [anything other than ADD or DELETE
	 * triggers this for QUIC].
	 */
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_MP_CMD_ERR   UINT32_C(0x5)
		#define CE_CMPLS_CMP_DATA_MSG_STATUS_LAST	CE_CMPLS_CMP_DATA_MSG_STATUS_MP_CMD_ERR
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED1_MASK	UINT32_C(0xfff0)
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED1_SFT	4
	/*
	 * This is a copy of the opaque field from the mid path BD of this
	 * command.
	 */
	uint32_t	opaque;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes will
	 * write 1. The odd passes will write 0.
	 */
	#define CE_CMPLS_CMP_DATA_MSG_V	UINT32_C(0x1)
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED2_MASK UINT32_C(0xfffffffe)
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED2_SFT 1
	uint32_t	kid;
	/*
	 * This field is the Crypto Context ID. The KID is used to store
	 * information used by the associated kTLS offloaded connection.
	 */
	#define CE_CMPLS_CMP_DATA_MSG_KID_MASK	UINT32_C(0xfffff)
	#define CE_CMPLS_CMP_DATA_MSG_KID_SFT	0
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED3_MASK UINT32_C(0xfff00000)
	#define CE_CMPLS_CMP_DATA_MSG_UNUSED3_SFT 20
} __attribute__((packed));

/* cmpl_base (size:128b/16B) */

struct cmpl_base {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define CMPL_BASE_TYPE_MASK		UINT32_C(0x3f)
	#define CMPL_BASE_TYPE_SFT		0
	/*
	 * TX L2 completion:
	 * Completion of TX packet. Length = 16B
	 */
		#define CMPL_BASE_TYPE_TX_L2		UINT32_C(0x0)
	/*
	 * NO-OP completion:
	 * Completion of NO-OP. Length = 16B
	 */
		#define CMPL_BASE_TYPE_NO_OP		UINT32_C(0x1)
	/*
	 * TX L2 coalesced completion:
	 * Completion of coalesced TX packet. Length = 16B
	 */
		#define CMPL_BASE_TYPE_TX_L2_COAL	UINT32_C(0x2)
	/*
	 * TX L2 Packet Timestamp completion:
	 * Completion of an L2 Packet Timestamp Packet. Length = 16B
	 */
		#define CMPL_BASE_TYPE_TX_L2_PKT_TS	UINT32_C(0x4)
	/*
	 * RX L2 TPA Start V2 Completion:
	 * Completion of and L2 RX packet. Length = 32B
	 * This is the new version of the RX_TPA_START completion used
	 * in SR2 and later chips.
	 */
		#define CMPL_BASE_TYPE_RX_TPA_START_V2   UINT32_C(0xd)
	/*
	 * RX L2 V2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 * This is the new version of the RX_L2 completion used in SR2
	 * and later chips.
	 */
		#define CMPL_BASE_TYPE_RX_L2_V2	UINT32_C(0xf)
	/*
	 * RX L2 completion:
	 * This is the compressed version of Rx Completion for performance
	 * applications. Length = 16B
	 */
		#define CMPL_BASE_TYPE_RX_L2_COMPRESS	UINT32_C(0x10)
	/*
	 * RX L2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 */
		#define CMPL_BASE_TYPE_RX_L2		UINT32_C(0x11)
	/*
	 * RX Aggregation Buffer completion:
	 * Completion of an L2 aggregation buffer in support of
	 * TPA, HDS, or Jumbo packet completion. Length = 16B
	 */
		#define CMPL_BASE_TYPE_RX_AGG		UINT32_C(0x12)
	/*
	 * RX L2 TPA Start Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 */
		#define CMPL_BASE_TYPE_RX_TPA_START	UINT32_C(0x13)
	/*
	 * RX L2 TPA End Completion:
	 * Completion at the end of a TPA operation.
	 * Length = 32B
	 */
		#define CMPL_BASE_TYPE_RX_TPA_END	UINT32_C(0x15)
	/*
	 * RX TPA Aggregation Buffer Completion:
	 * Completion of an L2 aggregation buffer in support of TPA packet
	 * completion.
	 * Length = 16B
	 */
		#define CMPL_BASE_TYPE_RX_TPA_AGG	UINT32_C(0x16)
	/*
	 * RX L2 completion: Completion of and L2 RX packet.
	 * Length = 32B
	 */
		#define CMPL_BASE_TYPE_RX_L2_V3	UINT32_C(0x17)
	/*
	 * RX L2 TPA Start completion: Completion at the beginning of a TPA
	 * operation.
	 * Length = 32B
	 */
		#define CMPL_BASE_TYPE_RX_TPA_START_V3   UINT32_C(0x19)
	/*
	 * Statistics Ejection Completion:
	 * Completion of statistics data ejection buffer.
	 * Length = 16B
	 */
		#define CMPL_BASE_TYPE_STAT_EJECT	UINT32_C(0x1a)
	/*
	 * VEE Flush Completion:
	 * This completion is inserted manually by
	 * the Primate and processed by the VEE hardware to ensure that
	 * all completions on a VEE function have been processed by the
	 * VEE hardware before FLR process is completed.
	 */
		#define CMPL_BASE_TYPE_VEE_FLUSH	UINT32_C(0x1c)
	/*
	 * Mid Path Short Completion :
	 * Completion of a Mid Path Command. Length = 16B
	 */
		#define CMPL_BASE_TYPE_MID_PATH_SHORT	UINT32_C(0x1e)
	/*
	 * Mid Path Long Completion :
	 * Completion of a Mid Path Command. Length = 32B
	 */
		#define CMPL_BASE_TYPE_MID_PATH_LONG	UINT32_C(0x1f)
	/*
	 * HWRM Command Completion:
	 * Completion of an HWRM command.
	 */
		#define CMPL_BASE_TYPE_HWRM_DONE	UINT32_C(0x20)
	/* Forwarded HWRM Request */
		#define CMPL_BASE_TYPE_HWRM_FWD_REQ	UINT32_C(0x22)
	/* Forwarded HWRM Response */
		#define CMPL_BASE_TYPE_HWRM_FWD_RESP	UINT32_C(0x24)
	/* HWRM Asynchronous Event Information */
		#define CMPL_BASE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
	/* CQ Notification */
		#define CMPL_BASE_TYPE_CQ_NOTIFICATION   UINT32_C(0x30)
	/* SRQ Threshold Event */
		#define CMPL_BASE_TYPE_SRQ_EVENT	UINT32_C(0x32)
	/* DBQ Threshold Event */
		#define CMPL_BASE_TYPE_DBQ_EVENT	UINT32_C(0x34)
	/* QP Async Notification */
		#define CMPL_BASE_TYPE_QP_EVENT	UINT32_C(0x38)
	/* Function Async Notification */
		#define CMPL_BASE_TYPE_FUNC_EVENT	UINT32_C(0x3a)
		#define CMPL_BASE_TYPE_LAST		CMPL_BASE_TYPE_FUNC_EVENT
	/* info1 is 16 b */
	uint16_t	info1;
	/* info2 is 32 b */
	uint32_t	info2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	uint32_t	info3_v;
	#define CMPL_BASE_V	UINT32_C(0x1)
	#define CMPL_BASE_INFO3_MASK UINT32_C(0xfffffffe)
	#define CMPL_BASE_INFO3_SFT 1
	/* info4 is 32 b */
	uint32_t	info4;
} __attribute__((packed));

/* tx_cmpl (size:128b/16B) */

struct tx_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define TX_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define TX_CMPL_TYPE_SFT	0
	/*
	 * TX L2 completion:
	 * Completion of TX packet. Length = 16B
	 */
		#define TX_CMPL_TYPE_TX_L2	UINT32_C(0x0)
		#define TX_CMPL_TYPE_LAST	TX_CMPL_TYPE_TX_L2
	#define TX_CMPL_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_CMPL_FLAGS_SFT	6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define TX_CMPL_FLAGS_ERROR	UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet completed
	 * was transmitted using the push acceleration data provided
	 * by the driver. When this bit is '0', it indicates that the
	 * packet had not push acceleration data written or was executed
	 * as a normal packet even though push data was provided.
	 */
	#define TX_CMPL_FLAGS_PUSH	UINT32_C(0x80)
	/* unused1 is 16 b */
	uint16_t	unused_0;
	/*
	 * This is a copy of the opaque field from the first TX BD of this
	 * transmitted packet. Note that, if the packet was described by a short
	 * CSO or short CSO inline BD, then the 16-bit opaque field from the
	 * short CSO BD will appear in the bottom 16 bits of this field.
	 */
	uint32_t	opaque;
	uint16_t	errors_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define TX_CMPL_V				UINT32_C(0x1)
	#define TX_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define TX_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem
	 * with the BDs for the packet.
	 */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define TX_CMPL_ERRORS_BUFFER_ERROR_SFT		1
	/* No error */
		#define TX_CMPL_ERRORS_BUFFER_ERROR_NO_ERROR	(UINT32_C(0x0) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT	(UINT32_C(0x2) << 1)
		#define TX_CMPL_ERRORS_BUFFER_ERROR_LAST		TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT
	/*
	 * When this bit is '1', it indicates that the length of
	 * the packet was zero. No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_ZERO_LENGTH_PKT		UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates that the packet
	 * was longer than the programmed limit in TDI. No
	 * packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_EXCESSIVE_BD_LENGTH	UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that one or more of the
	 * BDs associated with this packet generated a PCI error.
	 * This probably means the address was not valid.
	 */
	#define TX_CMPL_ERRORS_DMA_ERROR			UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet was longer
	 * than indicated by the hint. No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_HINT_TOO_SHORT		UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates that the packet was
	 * dropped due to Poison TLP error on one or more of the
	 * TLPs in the PXP completion.
	 */
	#define TX_CMPL_ERRORS_POISON_TLP_ERROR		UINT32_C(0x100)
	/*
	 * When this bit is '1', it indicates that the packet was dropped
	 * due to a transient internal error in TDC. The packet or LSO can
	 * be retried and may transmit successfully on a subsequent attempt.
	 */
	#define TX_CMPL_ERRORS_INTERNAL_ERROR		UINT32_C(0x200)
	/*
	 * When this bit is '1', it was not possible to collect a timestamp
	 * for a PTP completion, in which case the timestamp_hi and
	 * timestamp_lo fields are invalid. When this bit is '0' for a PTP
	 * completion, the timestamp_hi and timestamp_lo fields are valid.
	 * RJRN will copy the value of this bit into the field of the same
	 * name in all TX completions, regardless of whether such completions
	 * are PTP completions or other TX completions.
	 */
	#define TX_CMPL_ERRORS_TIMESTAMP_INVALID_ERROR	UINT32_C(0x400)
	/* unused2 is 16 b */
	uint16_t	unused_1;
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* tx_cmpl_coal (size:128b/16B) */

struct tx_cmpl_coal {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define TX_CMPL_COAL_TYPE_MASK	UINT32_C(0x3f)
	#define TX_CMPL_COAL_TYPE_SFT	0
	/*
	 * TX L2 coalesced completion:
	 * Completion of TX packet. Length = 16B
	 */
		#define TX_CMPL_COAL_TYPE_TX_L2_COAL   UINT32_C(0x2)
		#define TX_CMPL_COAL_TYPE_LAST	TX_CMPL_COAL_TYPE_TX_L2_COAL
	#define TX_CMPL_COAL_FLAGS_MASK	UINT32_C(0xffc0)
	#define TX_CMPL_COAL_FLAGS_SFT	6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define TX_CMPL_COAL_FLAGS_ERROR	UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet completed
	 * was transmitted using the push acceleration data provided
	 * by the driver. When this bit is '0', it indicates that the
	 * packet had not push acceleration data written or was executed
	 * as a normal packet even though push data was provided.
	 */
	#define TX_CMPL_COAL_FLAGS_PUSH	UINT32_C(0x80)
	/* unused1 is 16 b */
	uint16_t	unused_0;
	/*
	 * This is a copy of the opaque field from the first TX BD of the packet
	 * which corresponds with the reported sq_cons_idx. Note that, with
	 * coalesced completions, completions are generated for only some of the
	 * packets. The driver will see the opaque field for only those packets.
	 * Note that, if the packet was described by a short CSO or short CSO
	 * inline BD, then the 16-bit opaque field from the short CSO BD will
	 * appear in the bottom 16 bits of this field. For TX rings with
	 * completion coalescing enabled (which would use the coalesced
	 * completion record), it is suggested that the driver populate the
	 * opaque field to indicate the specific TX ring with which the
	 * completion is associated, then utilize the opaque and sq_cons_idx
	 * fields in the coalesced completion record to determine the specific
	 * packets that are to be completed on that ring.
	 */
	uint32_t	opaque;
	uint16_t	errors_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define TX_CMPL_COAL_V				UINT32_C(0x1)
	#define TX_CMPL_COAL_ERRORS_MASK			UINT32_C(0xfffe)
	#define TX_CMPL_COAL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem
	 * with the BDs for the packet.
	 */
	#define TX_CMPL_COAL_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define TX_CMPL_COAL_ERRORS_BUFFER_ERROR_SFT		1
	/* No error */
		#define TX_CMPL_COAL_ERRORS_BUFFER_ERROR_NO_ERROR	(UINT32_C(0x0) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define TX_CMPL_COAL_ERRORS_BUFFER_ERROR_BAD_FMT	(UINT32_C(0x2) << 1)
		#define TX_CMPL_COAL_ERRORS_BUFFER_ERROR_LAST		TX_CMPL_COAL_ERRORS_BUFFER_ERROR_BAD_FMT
	/*
	 * When this bit is '1', it indicates that the length of
	 * the packet was zero. No packet was transmitted.
	 */
	#define TX_CMPL_COAL_ERRORS_ZERO_LENGTH_PKT		UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates that the packet
	 * was longer than the programmed limit in TDI. No
	 * packet was transmitted.
	 */
	#define TX_CMPL_COAL_ERRORS_EXCESSIVE_BD_LENGTH	UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that one or more of the
	 * BDs associated with this packet generated a PCI error.
	 * This probably means the address was not valid.
	 */
	#define TX_CMPL_COAL_ERRORS_DMA_ERROR			UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet was longer
	 * than indicated by the hint. No packet was transmitted.
	 */
	#define TX_CMPL_COAL_ERRORS_HINT_TOO_SHORT		UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates that the packet was
	 * dropped due to Poison TLP error on one or more of the
	 * TLPs in the PXP completion.
	 */
	#define TX_CMPL_COAL_ERRORS_POISON_TLP_ERROR		UINT32_C(0x100)
	/*
	 * When this bit is '1', it indicates that the packet was dropped
	 * due to a transient internal error in TDC. The packet or LSO can
	 * be retried and may transmit successfully on a subsequent attempt.
	 */
	#define TX_CMPL_COAL_ERRORS_INTERNAL_ERROR		UINT32_C(0x200)
	/*
	 * When this bit is '1', it was not possible to collect a a timestamp
	 * for a PTP completion, in which case the timestamp_hi and
	 * timestamp_lo fields are invalid. When this bit is '0' for a PTP
	 * completion, the timestamp_hi and timestamp_lo fields are valid.
	 * RJRN will copy the value of this bit into the field of the same
	 * name in all TX completions, regardless of whether such
	 * completions are PTP completions or other TX completions.
	 */
	#define TX_CMPL_COAL_ERRORS_TIMESTAMP_INVALID_ERROR	UINT32_C(0x400)
	/* unused2 is 16 b */
	uint16_t	unused_1;
	uint32_t	sq_cons_idx;
	/*
	 * This value is SQ index for the start of the packet following the
	 * last completed packet.
	 */
	#define TX_CMPL_COAL_SQ_CONS_IDX_MASK UINT32_C(0xffffff)
	#define TX_CMPL_COAL_SQ_CONS_IDX_SFT 0
} __attribute__((packed));

/* tx_cmpl_packet_timestamp (size:128b/16B) */

struct tx_cmpl_packet_timestamp {
	uint16_t	ts_sub_ns_flags_type;
	/*
	 * This field indicates the exact type of the completion. By
	 * convention, the LSB identifies the length of the record in 16B
	 * units. Even values indicate 16B records. Odd values indicate
	 * 32B records.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_TYPE_MASK		UINT32_C(0x3f)
	#define TX_CMPL_PACKET_TIMESTAMP_TYPE_SFT		0
	/*
	 * TX L2 Packet Timestamp completion:
	 * Completion of an L2 Packet Timestamp Packet. Length = 16B
	 */
		#define TX_CMPL_PACKET_TIMESTAMP_TYPE_TX_L2_PKT_TS	UINT32_C(0x4)
		#define TX_CMPL_PACKET_TIMESTAMP_TYPE_LAST		TX_CMPL_PACKET_TIMESTAMP_TYPE_TX_L2_PKT_TS
	#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_MASK		UINT32_C(0xfc0)
	#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_SFT		6
	/*
	 * When this bit is '1', it indicates a packet that has an error
	 * of some type. Type of error is indicated in error_flags.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_ERROR		UINT32_C(0x40)
	/*
	 * This field indicates the TX packet timestamp type that is
	 * represented by a TX Packet Timestamp Completion. Note that
	 * this field is invalid if the timestamp_invalid_error flag
	 * is set.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_TYPE	UINT32_C(0x80)
	/* The packet timestamp came from PM. */
		#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_TYPE_TS_PM	(UINT32_C(0x0) << 7)
	/* The packet timestamp came from PA. */
		#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_TYPE_TS_PA	(UINT32_C(0x1) << 7)
		#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_TYPE_LAST	TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_TYPE_TS_PA
	/*
	 * This flag indicates that the timestamp should have come from PM,
	 * but came instead from PA because all PM timestamp resources were
	 * in use. This can occur in the following circumstances:
	 * 1. The BD specified ts_2cmpl_auto and the packet was a PTP packet
	 *	but PA could not request a PM timestamp
	 * 2. The BD specified ts_2cmpl_pm, but PA could not request a PM
	 *	timestamp
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_FLAGS_TS_FALLBACK	UINT32_C(0x100)
	/*
	 * For 2-step PTP timestamps, bits[3:0] of this field represent the
	 * sub-nanosecond portion of the packet timestamp, returned from PM
	 * for 2-step PTP timestamps. For PA timestamps, this field also
	 * represents the sub-nanosecond portion of the packet timestamp;
	 * however, due to synchronization uncertainties, the accuracy of
	 * PA timestamps is limited to approximately +/- 4 ns. Therefore
	 * this field is of dubious value for PA timestamps.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_TS_SUB_NS_MASK	UINT32_C(0xf000)
	#define TX_CMPL_PACKET_TIMESTAMP_TS_SUB_NS_SFT	12
	/*
	 * This is bits [47:32] of the nanoseconds portion of the packet
	 * timestamp, returned from PM for 2-step PTP timestamps or from
	 * PA for PA timestamps. This field is in units of 2^32 ns.
	 */
	uint16_t	ts_ns_mid;
	/*
	 * This is a copy of the opaque field from the first TX BD of this
	 * transmitted packet. Note that, if the packet was described by a
	 * short CSO or short CSO inline BD, then the 16-bit opaque field
	 * from the short CSO BD will appear in the bottom 16 bits of this
	 * field.
	 */
	uint32_t	opaque;
	uint16_t	errors_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_V				UINT32_C(0x1)
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_MASK			UINT32_C(0xfffe)
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_SFT			1
	/*
	 * This field was previously used to indicate fatal errors, which
	 * now result in aborting and bringing down the ring. This field
	 * is deprecated.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_SFT		1
	/* No error. */
		#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_NO_ERROR	(UINT32_C(0x0) << 1)
	/* Deprecated. */
		#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_BAD_FMT	(UINT32_C(0x2) << 1)
		#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_LAST		TX_CMPL_PACKET_TIMESTAMP_ERRORS_BUFFER_ERROR_BAD_FMT
	/*
	 * This error is fatal and results in aborting and bringing down the
	 * ring, thus is deprecated.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_ZERO_LENGTH_PKT		UINT32_C(0x10)
	/*
	 * This error is fatal and results in aborting and bringing down the
	 * ring, thus is deprecated.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_EXCESSIVE_BD_LENGTH	UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that one or more of the BDs
	 * associated with this packet generated a PCI error when accessing
	 * header/payload data from host memory. It most likely indicates
	 * that the address was not valid. Note that this bit has no meaning
	 * for the timestamp completion and will always be '0'.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_DMA_ERROR			UINT32_C(0x40)
	/*
	 * This error is fatal and results in aborting and bringing down the
	 * ring, thus is deprecated.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_HINT_TOO_SHORT		UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates that the packet was dropped
	 * due to Poison TLP error on one or more of the TLPs in one or more
	 * of the associated PXP completion(s) when accessing header/payload
	 * data from host memory. Note that this bit has no meaning for the
	 * timestamp completion, and will always be '0'.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_POISON_TLP_ERROR		UINT32_C(0x100)
	/*
	 * When this bit is '1', it indicates that the packet was dropped
	 * due to a transient internal error in TDC. The packet or LSO can
	 * be retried and may transmit successfully on a subsequent attempt.
	 * Note that this bit has no meaning for the timestamp completion
	 * and will always be '0'.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_INTERNAL_ERROR		UINT32_C(0x200)
	/*
	 * When this bit is '1', it was not possible to collect a timestamp
	 * for a timestamp completion, in which case the ts_ns and ts_sub_ns
	 * fields are invalid. When this bit is '0' in a timestamp
	 * completion record, the ts_sub_ns, ts_ns_lo, and ts_ns_mid fields
	 * are valid. Note that this bit has meaning only for the timestamp
	 * completion. For types other than the timestamp completion, this
	 * bit will always be '0'.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_TIMESTAMP_INVALID_ERROR	UINT32_C(0x400)
	/*
	 * When this bit is '1', it indicates that a Timed Transmit
	 * SO-TXTIME packet violated the max_ttx_overtime constraint i.e.,
	 * the time the packet was processed for transmission in TWE was
	 * later than the time given by (TimedTx_BD.tx_time +
	 * max_ttx_overtime) and as result, the packet was dropped.
	 * Note that max_ttx_overtime is a global configuration in TWE.
	 * Note that this bit has no meaning in a timestamp completion,
	 * and will always be '0'.
	 */
	#define TX_CMPL_PACKET_TIMESTAMP_ERRORS_TTX_OVERTIME_ERROR	UINT32_C(0x800)
	/* unused2 is 16 b */
	uint16_t	unused_2;
	/*
	 * This is bits [31:0] of the nanoseconds portion of the packet
	 * timestamp, returned from PM for 2-step PTP timestamp or from
	 * PA for PA timestamps. This field is in units of ns.
	 */
	uint32_t	ts_ns_lo;
} __attribute__((packed));

/* rx_pkt_cmpl (size:128b/16B) */

struct rx_pkt_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_PKT_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PKT_CMPL_TYPE_SFT			0
	/*
	 * RX L2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 */
		#define RX_PKT_CMPL_TYPE_RX_L2			UINT32_C(0x11)
		#define RX_PKT_CMPL_TYPE_LAST			RX_PKT_CMPL_TYPE_RX_L2
	#define RX_PKT_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PKT_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_PKT_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Normal:
	 * Packet was placed using normal algorithm.
	 */
		#define RX_PKT_CMPL_FLAGS_PLACEMENT_NORMAL		(UINT32_C(0x0) << 7)
	/*
	 * Jumbo:
	 * Packet was placed using jumbo algorithm.
	 */
		#define RX_PKT_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_PKT_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
		#define RX_PKT_CMPL_FLAGS_PLACEMENT_LAST		RX_PKT_CMPL_FLAGS_PLACEMENT_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory.
	 */
	#define RX_PKT_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_PKT_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * Not Known:
	 * Indicates that the packet type was not known.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_NOT_KNOWN		(UINT32_C(0x0) << 12)
	/*
	 * IP Packet:
	 * Indicates that the packet was an IP packet, but further
	 * classification was not possible.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_IP			(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet:
	 * Indicates that the packet was IP and UDP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_UDP		(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet:
	 * Indicates that the packet was recognized as a FCoE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_FCOE		(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet:
	 * Indicates that the packet was recognized as a RoCE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_ROCE		(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet:
	 * Indicates that the packet was recognized as ICMP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_ICMP		(UINT32_C(0x7) << 12)
	/*
	 * PTP packet wo/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP	(UINT32_C(0x8) << 12)
	/*
	 * PTP packet w/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet and that a timestamp was taken for the packet.
	 */
		#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP	(UINT32_C(0x9) << 12)
		#define RX_PKT_CMPL_FLAGS_ITYPE_LAST		RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	/*
	 * This is the length of the data for the packet stored in the
	 * buffer(s) identified by the opaque value. This includes
	 * the packet BD and any associated buffer BDs. This does not include
	 * the length of any data places in aggregation BDs.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	uint8_t	agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V1	UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided for the packet in the RX ring.
	 */
	#define RX_PKT_CMPL_AGG_BUFS_MASK UINT32_C(0x3e)
	#define RX_PKT_CMPL_AGG_BUFS_SFT 1
	/* unused1 is 2 b */
	#define RX_PKT_CMPL_UNUSED1_MASK UINT32_C(0xc0)
	#define RX_PKT_CMPL_UNUSED1_SFT  6
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * Note that 4-tuples values listed below are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 */
	#define RX_PKT_CMPL_RSS_HASH_TYPE_ENUM_0 UINT32_C(0x0)
	/*
	 * The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 */
	#define RX_PKT_CMPL_RSS_HASH_TYPE_ENUM_1 UINT32_C(0x1)
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
	#define RX_PKT_CMPL_RSS_HASH_TYPE_ENUM_2 UINT32_C(0x2)
	/*
	 * The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
	#define RX_PKT_CMPL_RSS_HASH_TYPE_ENUM_3 UINT32_C(0x3)
	#define RX_PKT_CMPL_RSS_HASH_TYPE_LAST  RX_PKT_CMPL_RSS_HASH_TYPE_ENUM_3
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets.
	 *
	 * A value of zero indicates that header is 256B into the packet.
	 */
	uint8_t	payload_offset;
	/* unused2 is 8 b */
	uint8_t	unused1;
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/* Last 16 bytes of rx_pkt_cmpl. */
/* rx_pkt_cmpl_hi (size:128b/16B) */

struct rx_pkt_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the
	 * inner packet and that the ip_cs_error field indicates if there
	 * was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_CS_CALC		UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was
	 * calculated for the inner packet and that the l4_cs_error field
	 * indicates if there was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_L4_CS_CALC		UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the
	 * tunnel header and that the t_ip_cs_error field indicates if there
	 * was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_IP_CS_CALC		UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was
	 * calculated for the tunnel packet and that the t_l4_cs_error field
	 * indicates if there was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_L4_CS_CALC		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_SFT		4
	/* No metadata information. Value is zero. */
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value.
	 * - metadata[11:0] contains the vlan VID value.
	 * - metadata[12] contains the vlan DE value.
	 * - metadata[15:13] contains the vlan PRI value.
	 * - metadata[31:16] contains the vlan TPID value.
	 */
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_VLAN		(UINT32_C(0x1) << 4)
	/*
	 * If ext_meta_format is equal to 1, the metadata field
	 * contains the lower 16b of the tunnel ID value, justified
	 * to LSB
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier.
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. zero if K = 0
	 * - IPV4 = 0 (not populated)
	 * - IPV6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * if ext_meta_format is equal to 1, metadata field contains
	 * 16b metadata from the prepended header (chdr_data).
	 */
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * If ext_meta_format is equal to 1, the metadata field contains
	 * the outer_l3_offset, inner_l2_offset, inner_l3_offset and
	 * inner_l4_size.
	 * - metadata[8:0] contains the outer_l3_offset.
	 * - metadata[17:9] contains the inner_l2_offset.
	 * - metadata[26:18] contains the inner_l3_offset.
	 * - metadata[31:27] contains the inner_l4_size.
	 */
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_PKT_CMPL_FLAGS2_META_FORMAT_LAST		RX_PKT_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet.
	 */
	#define RX_PKT_CMPL_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * The combination of this value and meta_format indicated what
	 * format the metadata field is.
	 */
	#define RX_PKT_CMPL_FLAGS2_EXT_META_FORMAT_MASK	UINT32_C(0xc00)
	#define RX_PKT_CMPL_FLAGS2_EXT_META_FORMAT_SFT	10
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set.
	 */
	#define RX_PKT_CMPL_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_PKT_CMPL_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint32_t	metadata;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_PKT_CMPL_METADATA_VID_MASK UINT32_C(0xfff)
	#define RX_PKT_CMPL_METADATA_VID_SFT  0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_PKT_CMPL_METADATA_DE	UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_PKT_CMPL_METADATA_PRI_MASK UINT32_C(0xe000)
	#define RX_PKT_CMPL_METADATA_PRI_SFT  13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_PKT_CMPL_METADATA_TPID_MASK UINT32_C(0xffff0000)
	#define RX_PKT_CMPL_METADATA_TPID_SFT 16
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V2					UINT32_C(0x1)
	#define RX_PKT_CMPL_ERRORS_MASK				UINT32_C(0xfffe)
	#define RX_PKT_CMPL_ERRORS_SFT				1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_SFT		1
	/* No buffer error */
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER		(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit:
	 * Packet did not fit into packet buffer provided.
	 * For regular placement, this means the packet did not fit
	 * in the buffer provided. For HDS and jumbo placement, this
	 * means that the packet could not be placed into 7 physical
	 * buffers or less.
	 */
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT		(UINT32_C(0x1) << 1)
	/*
	 * Not On Chip:
	 * All BDs needed for the packet were not on-chip when
	 * the packet arrived.
	 */
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP		(UINT32_C(0x2) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT		(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_FLUSH		(UINT32_C(0x5) << 1)
		#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_LAST		RX_PKT_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	/*
	 * This indicates that there was an error in the IP header
	 * checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_IP_CS_ERROR			UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP
	 * or ICMP checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_L4_CS_ERROR			UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel
	 * IP header checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_T_IP_CS_ERROR			UINT32_C(0x40)
	/*
	 * This indicates that there was an error in the tunnel
	 * UDP checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_T_L4_CS_ERROR			UINT32_C(0x80)
	/*
	 * This indicates that there was a CRC error on either an FCoE
	 * or RoCE packet. The itype indicates the packet type.
	 */
	#define RX_PKT_CMPL_ERRORS_CRC_ERROR			UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_MASK		UINT32_C(0xe00)
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_SFT			9
	/*
	 * No additional error occurred on the tunnel portion
	 * or the packet of the packet does not have a tunnel.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6
	 * in the tunnel header.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION	(UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the
	 * tunnel header. Valid for
	 * IPv4.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the PPPoE header length for a tunnel PPPoE
	 * packet.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_TUNNEL_TOTAL_ERROR	(UINT32_C(0x3) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6
	 * tunnel packet packets.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR	(UINT32_C(0x4) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the tunnel UDP header length for a tunnel
	 * UDP packet that is not fragmented.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR	(UINT32_C(0x5) << 9)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0) in the tunnel header. Valid
	 * for IPv4, and IPv6.
	 */
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL		(UINT32_C(0x6) << 9)
		#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_LAST			RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL
	/*
	 * This indicates that there was an error in the inner
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_MASK			UINT32_C(0xf000)
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_SFT			12
	/*
	 * No additional error occurred on the tunnel portion
	 * or the packet of the packet does not have a tunnel.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6 or that
	 * option other than VFT was parsed on
	 * FCoE packet.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_VERSION		(UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for
	 * IPv4 and RoCE
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN		(UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_TTL		(UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that
	 * claimed by the l3 header length. Valid for IPv4,
	 * IPv6 packet or RoCE packets.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_IP_TOTAL_ERROR		(UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR		(UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for
	 * TCP packets only.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN		(UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL   (UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header
	 * size that does not match data offset in TCP header. Valid
	 * for TCP.
	 */
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN		(UINT32_C(0x8) << 12)
		#define RX_PKT_CMPL_ERRORS_PKT_ERROR_LAST			RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint16_t	cfa_code;
	uint32_t	reorder;
	/*
	 * This value holds the reordering sequence number for the packet.
	 * If the reordering sequence is not valid, then this value is zero.
	 * The reordering domain for the packet is in the bottom 8 to 10b of
	 * the rss_hash value. The bottom 20b of this value contain the
	 * ordering domain value for the packet.
	 */
	#define RX_PKT_CMPL_REORDER_MASK UINT32_C(0xffffff)
	#define RX_PKT_CMPL_REORDER_SFT 0
} __attribute__((packed));

/* rx_pkt_v2_cmpl (size:128b/16B) */

struct rx_pkt_v2_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_PKT_V2_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PKT_V2_CMPL_TYPE_SFT			0
	/*
	 * RX L2 V2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 * This is the new version of the RX_L2 completion used in SR2
	 * and later chips.
	 */
		#define RX_PKT_V2_CMPL_TYPE_RX_L2_V2			UINT32_C(0xf)
		#define RX_PKT_V2_CMPL_TYPE_LAST			RX_PKT_V2_CMPL_TYPE_RX_L2_V2
	#define RX_PKT_V2_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PKT_V2_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_PKT_V2_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Normal:
	 * Packet was placed using normal algorithm.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_NORMAL		(UINT32_C(0x0) << 7)
	/*
	 * Jumbo:
	 * Packet was placed using jumbo algorithm.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * Truncation:
	 * Packet was placed using truncation algorithm. The
	 * placed (truncated) length is indicated in the payload_offset
	 * field. The original length is indicated in the len field.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_TRUNCATION	(UINT32_C(0x3) << 7)
		#define RX_PKT_V2_CMPL_FLAGS_PLACEMENT_LAST		RX_PKT_V2_CMPL_FLAGS_PLACEMENT_TRUNCATION
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_V2_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement.
	 * It starts at the first 32B boundary after the end of the header
	 * for HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_PKT_V2_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_PKT_V2_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_PKT_V2_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * Not Known:
	 * Indicates that the packet type was not known.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_NOT_KNOWN		(UINT32_C(0x0) << 12)
	/*
	 * IP Packet:
	 * Indicates that the packet was an IP packet, but further
	 * classification was not possible.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_IP			(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet:
	 * Indicates that the packet was IP and UDP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_UDP		(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet:
	 * Indicates that the packet was recognized as a FCoE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_FCOE		(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet:
	 * Indicates that the packet was recognized as a RoCE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_ROCE		(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet:
	 * Indicates that the packet was recognized as ICMP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_ICMP		(UINT32_C(0x7) << 12)
	/*
	 * PTP packet wo/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP	(UINT32_C(0x8) << 12)
	/*
	 * PTP packet w/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet and that a timestamp was taken for the packet.
	 */
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP	(UINT32_C(0x9) << 12)
		#define RX_PKT_V2_CMPL_FLAGS_ITYPE_LAST		RX_PKT_V2_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	/*
	 * This is the length of the data for the packet stored in the
	 * buffer(s) identified by the opaque value. This includes
	 * the packet BD and any associated buffer BDs. This does not include
	 * the length of any data places in aggregation BDs.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	uint8_t	agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_V2_CMPL_V1	UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided for the packet in the RX ring.
	 */
	#define RX_PKT_V2_CMPL_AGG_BUFS_MASK UINT32_C(0x3e)
	#define RX_PKT_V2_CMPL_AGG_BUFS_SFT 1
	/* unused1 is 2 b */
	#define RX_PKT_V2_CMPL_UNUSED1_MASK UINT32_C(0xc0)
	#define RX_PKT_V2_CMPL_UNUSED1_SFT  6
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * Note that 4-tuples values listed below are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 */
	#define RX_PKT_V2_CMPL_RSS_HASH_TYPE_ENUM_0 UINT32_C(0x0)
	/*
	 * The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 */
	#define RX_PKT_V2_CMPL_RSS_HASH_TYPE_ENUM_1 UINT32_C(0x1)
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
	#define RX_PKT_V2_CMPL_RSS_HASH_TYPE_ENUM_2 UINT32_C(0x2)
	/*
	 * The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
	#define RX_PKT_V2_CMPL_RSS_HASH_TYPE_ENUM_3 UINT32_C(0x3)
	#define RX_PKT_V2_CMPL_RSS_HASH_TYPE_LAST  RX_PKT_V2_CMPL_RSS_HASH_TYPE_ENUM_3
	uint16_t	metadata1_payload_offset;
	/*
	 * This is data from the CFA as indicated by the meta_format field.
	 * If truncation placement is not used, this value indicates the offset
	 * in bytes from the beginning of the packet where the inner payload
	 * starts. This value is valid for TCP, UDP, FCoE, and RoCE packets. If
	 * truncation placement is used, this value represents the placed
	 * (truncated) length of the packet.
	 */
	#define RX_PKT_V2_CMPL_PAYLOAD_OFFSET_MASK	UINT32_C(0x1ff)
	#define RX_PKT_V2_CMPL_PAYLOAD_OFFSET_SFT	0
	/* This is data from the CFA as indicated by the meta_format field. */
	#define RX_PKT_V2_CMPL_METADATA1_MASK		UINT32_C(0xf000)
	#define RX_PKT_V2_CMPL_METADATA1_SFT		12
	/* When meta_format != 0, this value is the VLAN TPID_SEL. */
	#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_MASK	UINT32_C(0x7000)
	#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_SFT	12
	/* 0x88a8 */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPID88A8   (UINT32_C(0x0) << 12)
	/* 0x8100 */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPID8100   (UINT32_C(0x1) << 12)
	/* 0x9100 */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPID9100   (UINT32_C(0x2) << 12)
	/* 0x9200 */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPID9200   (UINT32_C(0x3) << 12)
	/* 0x9300 */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPID9300   (UINT32_C(0x4) << 12)
	/* Value programmed in CFA VLANTPID register. */
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPIDCFG	(UINT32_C(0x5) << 12)
		#define RX_PKT_V2_CMPL_METADATA1_TPID_SEL_LAST	RX_PKT_V2_CMPL_METADATA1_TPID_SEL_TPIDCFG
	/* When meta_format != 0, this value is the VLAN valid. */
	#define RX_PKT_V2_CMPL_METADATA1_VALID		UINT32_C(0x8000)
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC. When vee_cmpl_mode
	 * is set in VNIC context, this is the lower 32b of the host address
	 * from the first BD used to place the packet.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/* Last 16 bytes of RX Packet V2 Completion Record */
/* rx_pkt_v2_cmpl_hi (size:128b/16B) */

struct rx_pkt_v2_cmpl_hi {
	uint32_t	flags2;
	/*
	 * When this bit is '0', the cs_ok field has the following definition:-
	 * ip_cs_ok[2:0] = The number of header groups with a valid IP checksum
	 * in the delivered packet, counted from the outer-most header group to
	 * the inner-most header group, stopping at the first error. -
	 * l4_cs_ok[5:3] = The number of header groups with a valid L4 checksum
	 * in the delivered packet, counted from the outer-most header group to
	 * the inner-most header group, stopping at the first error. When this
	 * bit is '1', the cs_ok field has the following definition: -
	 * hdr_cnt[2:0] = The number of header groups that were parsed by the
	 * chip and passed in the delivered packet. - ip_cs_all_ok[3] =This bit
	 * will be '1' if all the parsed header groups with an IP checksum are
	 * valid. - l4_cs_all_ok[4] = This bit will be '1' if all the parsed
	 * header groups with an L4 checksum are valid.
	 */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_CS_ALL_OK_MODE		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_SFT		4
	/* There is no metadata information. Values are zero. */
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information: - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],
	 * de, vid[11:0]} The metadata2 field contains the table scope
	 * and action record pointer. - metadata2[25:0] contains the
	 * action record pointer. - metadata2[31:26] contains the table
	 * scope.
	 */
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_ACT_REC_PTR	(UINT32_C(0x1) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the Tunnel ID
	 * value, justified to LSB.
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. zero if K=0
	 * - IPv4 = 0 (not populated)
	 * - IPv6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],de, vid[11:0]}
	 * The metadata2 field contains the 32b metadata from the prepended
	 * header (chdr_data).
	 */
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the outer_l3_offset,
	 * inner_l2_offset, inner_l3_offset, and inner_l4_size.
	 * - metadata2[8:0] contains the outer_l3_offset.
	 * - metadata2[17:9] contains the inner_l2_offset.
	 * - metadata2[26:18] contains the inner_l3_offset.
	 * - metadata2[31:27] contains the inner_l4_size.
	 */
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_LAST		RX_PKT_V2_CMPL_HI_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet.
	 */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * This field indicates the status of IP and L4 CS calculations done
	 * by the chip. The format of this field is indicated by the
	 * cs_all_ok_mode bit.
	 */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_CS_OK_MASK		UINT32_C(0xfc00)
	#define RX_PKT_V2_CMPL_HI_FLAGS2_CS_OK_SFT		10
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set.
	 */
	#define RX_PKT_V2_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_PKT_V2_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 * - meta_format 0 - none - metadata2 = 0 - not valid/not stripped
	 * - meta_format 1 - act_rec_ptr - metadata2 = {table_scope[5:0],
	 *   act_rec_ptr[25:0]}
	 * - meta_format 2 - tunnel_id - metadata2 = tunnel_id[31:0]
	 * - meta_format 3 - chdr_data - metadata2 = updated_chdr_data[31:0]
	 * - meta_format 4 - hdr_offsets - metadata2 = hdr_offsets[31:0]
	 * When vee_cmpl_mode is set in VNIC context, this is the upper 32b
	 * of the host address from the first BD used to place the packet.
	 */
	uint32_t	metadata2;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_V2_CMPL_HI_V2					UINT32_C(0x1)
	#define RX_PKT_V2_CMPL_HI_ERRORS_MASK				UINT32_C(0xfffe)
	#define RX_PKT_V2_CMPL_HI_ERRORS_SFT				1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_SFT		1
	/* No buffer error */
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_NO_BUFFER		(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit: Packet did not fit into packet buffer provided.
	 * For regular placement, this means the packet did not fit in
	 * the buffer provided. For HDS and jumbo placement, this means
	 * that the packet could not be placed into 8 physical buffers
	 * (if fixed-size buffers are used), or that the packet could
	 * not be placed in the number of physical buffers configured
	 * for the VNIC (if variable-size buffers are used)
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_DID_NOT_FIT		(UINT32_C(0x1) << 1)
	/*
	 * Not On Chip: All BDs needed for the packet were not on-chip
	 * when the packet arrived. For regular placement, this error is
	 * not valid. For HDS and jumbo placement, this means that not
	 * enough agg BDs were posted to place the packet.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_NOT_ON_CHIP		(UINT32_C(0x2) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_BAD_FORMAT		(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_FLUSH		(UINT32_C(0x5) << 1)
		#define RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_LAST		RX_PKT_V2_CMPL_HI_ERRORS_BUFFER_ERROR_FLUSH
	/*
	 * This indicates that there was an error in the outer tunnel
	 * portion of the packet when this field is non-zero.
	 */
	#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_MASK		UINT32_C(0x70)
	#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_SFT		4
	/*
	 * No additional error occurred on the outer tunnel portion
	 * of the packet or the packet does not have a outer tunnel.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 4)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the outer tunnel header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_L3_BAD_VERSION	(UINT32_C(0x1) << 4)
	/*
	 * Indicates that header length is out of range in the outer
	 * tunnel header. Valid for IPv4.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 4)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the outer tunnel l3 header length. Valid for IPv4, or
	 * IPv6 outer tunnel packets.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_IP_TOTAL_ERROR	(UINT32_C(0x3) << 4)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the outer tunnel UDP header length for a outer
	 * tunnel UDP packet that is not fragmented.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_UDP_TOTAL_ERROR	(UINT32_C(0x4) << 4)
	/*
	 * Indicates that the IPv4 TTL or IPv6 hop limit check have
	 * failed (e.g. TTL = 0) in the outer tunnel header. Valid for
	 * IPv4, and IPv6.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_L3_BAD_TTL	(UINT32_C(0x5) << 4)
	/*
	 * Indicates that the IP checksum failed its check in the outer
	 * tunnel header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_IP_CS_ERROR	(UINT32_C(0x6) << 4)
	/*
	 * Indicates that the L4 checksum failed its check in the outer
	 * tunnel header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_L4_CS_ERROR	(UINT32_C(0x7) << 4)
		#define RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_LAST		RX_PKT_V2_CMPL_HI_ERRORS_OT_PKT_ERROR_OT_L4_CS_ERROR
	/*
	 * This indicates that there was a CRC error on either an FCoE
	 * or RoCE packet. The itype indicates the packet type.
	 */
	#define RX_PKT_V2_CMPL_HI_ERRORS_CRC_ERROR			UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel portion
	 * of the packet when this field is non-zero.
	 */
	#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_MASK		UINT32_C(0xe00)
	#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_SFT			9
	/*
	 * No additional error occurred on the tunnel portion
	 * of the packet or the packet does not have a tunnel.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the tunnel header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION	(UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the tunnel
	 * header. Valid for IPv4.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6 tunnel
	 * packet packets.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR	(UINT32_C(0x3) << 9)
	/*
	 * Indicates that the physical packet is shorter than that claimed
	 * by the tunnel UDP header length for a tunnel UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR	(UINT32_C(0x4) << 9)
	/*
	 * Indicates that the IPv4 TTL or IPv6 hop limit check have failed
	 * (e.g. TTL = 0) in the tunnel header. Valid for IPv4, and IPv6.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL		(UINT32_C(0x5) << 9)
	/*
	 * Indicates that the IP checksum failed its check in the tunnel
	 * header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_IP_CS_ERROR		(UINT32_C(0x6) << 9)
	/*
	 * Indicates that the L4 checksum failed its check in the tunnel
	 * header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_L4_CS_ERROR		(UINT32_C(0x7) << 9)
		#define RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_LAST			RX_PKT_V2_CMPL_HI_ERRORS_T_PKT_ERROR_T_L4_CS_ERROR
	/*
	 * This indicates that there was an error in the inner
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_MASK			UINT32_C(0xf000)
	#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_SFT			12
	/*
	 * No additional error occurred on the tunnel portion
	 * or the packet of the packet does not have a tunnel.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6 or that
	 * option other than VFT was parsed on
	 * FCoE packet.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_VERSION		(UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for
	 * IPv4 and RoCE
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN		(UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_TTL		(UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that
	 * claimed by the l3 header length. Valid for IPv4,
	 * IPv6 packet or RoCE packets.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_IP_TOTAL_ERROR		(UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR		(UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for
	 * TCP packets only.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN		(UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL   (UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header
	 * size that does not match data offset in TCP header. Valid
	 * for TCP.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN		(UINT32_C(0x8) << 12)
	/*
	 * Indicates that the IP checksum failed its check in the
	 * inner header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_IP_CS_ERROR		(UINT32_C(0x9) << 12)
	/*
	 * Indicates that the L4 checksum failed its check in the
	 * inner header.
	 */
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L4_CS_ERROR		(UINT32_C(0xa) << 12)
		#define RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_LAST			RX_PKT_V2_CMPL_HI_ERRORS_PKT_ERROR_L4_CS_ERROR
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint16_t	metadata0;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_PKT_V2_CMPL_HI_METADATA0_VID_MASK UINT32_C(0xfff)
	#define RX_PKT_V2_CMPL_HI_METADATA0_VID_SFT 0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_PKT_V2_CMPL_HI_METADATA0_DE	UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_PKT_V2_CMPL_HI_METADATA0_PRI_MASK UINT32_C(0xe000)
	#define RX_PKT_V2_CMPL_HI_METADATA0_PRI_SFT 13
	/*
	 * The timestamp field contains the 32b timestamp for the packet from
	 * the MAC.
	 */
	uint32_t	timestamp;
} __attribute__((packed));

/* rx_pkt_v3_cmpl (size:128b/16B) */

struct rx_pkt_v3_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_PKT_V3_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PKT_V3_CMPL_TYPE_SFT			0
	/*
	 * RX L2 V3 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 * This is the new version of the RX_L2 completion used in Thor2
	 * and later chips.
	 */
		#define RX_PKT_V3_CMPL_TYPE_RX_L2_V3			UINT32_C(0x17)
		#define RX_PKT_V3_CMPL_TYPE_LAST			RX_PKT_V3_CMPL_TYPE_RX_L2_V3
	#define RX_PKT_V3_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PKT_V3_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_PKT_V3_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Normal:
	 * Packet was placed using normal algorithm.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_NORMAL		(UINT32_C(0x0) << 7)
	/*
	 * Jumbo:
	 * Packet was placed using jumbo algorithm.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * Truncation:
	 * Packet was placed using truncation algorithm. The
	 * placed (truncated) length is indicated in the payload_offset
	 * field. The original length is indicated in the len field.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_TRUNCATION	(UINT32_C(0x3) << 7)
		#define RX_PKT_V3_CMPL_FLAGS_PLACEMENT_LAST		RX_PKT_V3_CMPL_FLAGS_PLACEMENT_TRUNCATION
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_V3_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement.
	 * It starts at the first 32B boundary after the end of the header
	 * for HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_PKT_V3_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_PKT_V3_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_PKT_V3_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * Not Known:
	 * Indicates that the packet type was not known.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_NOT_KNOWN		(UINT32_C(0x0) << 12)
	/*
	 * IP Packet:
	 * Indicates that the packet was an IP packet, but further
	 * classification was not possible.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_IP			(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet:
	 * Indicates that the packet was IP and UDP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_UDP		(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet:
	 * Indicates that the packet was recognized as a FCoE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_FCOE		(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet:
	 * Indicates that the packet was recognized as a RoCE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_ROCE		(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet:
	 * Indicates that the packet was recognized as ICMP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_ICMP		(UINT32_C(0x7) << 12)
	/*
	 * PTP packet wo/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP	(UINT32_C(0x8) << 12)
	/*
	 * PTP packet w/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet and that a timestamp was taken for the packet.
	 * The 4b sub-nanosecond portion of the timestamp is in
	 * the payload_offset field.
	 */
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP	(UINT32_C(0x9) << 12)
		#define RX_PKT_V3_CMPL_FLAGS_ITYPE_LAST		RX_PKT_V3_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	/*
	 * This is the length of the data for the packet stored in the
	 * buffer(s) identified by the opaque value. This includes
	 * the packet BD and any associated buffer BDs. This does not include
	 * the length of any data places in aggregation BDs.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	uint16_t	rss_hash_type_agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_V3_CMPL_V1		UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided for the packet in the RX ring.
	 */
	#define RX_PKT_V3_CMPL_AGG_BUFS_MASK	UINT32_C(0x3e)
	#define RX_PKT_V3_CMPL_AGG_BUFS_SFT	1
	/* unused1 is 1 b */
	#define RX_PKT_V3_CMPL_UNUSED1		UINT32_C(0x40)
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * Note that 4-tuples values listed below are applicable
	 * for layer 4 protocols supported and enabled for RSS in the
	 * hardware, HWRM firmware, and drivers. For example, if RSS hash
	 * is supported and enabled for TCP traffic only, then the values of
	 * tuple_extract_op corresponding to 4-tuples are only valid for
	 * TCP traffic.
	 */
	#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_MASK   UINT32_C(0xff80)
	#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_SFT	7
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * inner IP and TCP or UDP headers.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_0   (UINT32_C(0x0) << 7)
	/*
	 * The RSS hash was computed over source IP address and
	 * destination IP address of inner IP header.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_1   (UINT32_C(0x1) << 7)
	/*
	 * The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_2   (UINT32_C(0x2) << 7)
	/*
	 * The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_3   (UINT32_C(0x3) << 7)
	/*
	 * The RSS hash was computed over source IP address of the inner
	 * IP header.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_4   (UINT32_C(0x4) << 7)
	/*
	 * The RSS hash was computed over destination IP address of the
	 * inner IP header.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_5   (UINT32_C(0x5) << 7)
	/*
	 * The RSS hash was computed over source IP address of the outer
	 * IP header.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_6   (UINT32_C(0x6) << 7)
	/*
	 * The RSS hash was computed over destination IP address of the
	 * outer IP header.
	 * Note: For non-tunneled packets, this value is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_7   (UINT32_C(0x7) << 7)
	/*
	 * The RSS hash was computed over source IP address, destination
	 * IP address, and flow label of the inner IP header.
	 * Note: For packets without an inner IPv6 header, this value is not
	 * this value is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_8   (UINT32_C(0x8) << 7)
	/*
	 * The RSS hash was computed over the flow label of the inner
	 * IP header.
	 * Note: For packets without an inner IPv6 header, this value
	 * is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_9   (UINT32_C(0x9) << 7)
	/*
	 * The RSS hash was computed over source IP address, destination
	 * IP address, and flow label of the outer IP header.
	 * Note: For packets without an outer IPv6 header, this value is not
	 * applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_10  (UINT32_C(0xa) << 7)
	/*
	 * The RSS hash was computed over the flow label of the outer
	 * IP header.
	 * Note: For packets without an outer IPv6 header, this value
	 * is not applicable.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_11  (UINT32_C(0xb) << 7)
	/* The RSS hash was computed over tunnel context and tunnel ID field. */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_12  (UINT32_C(0xc) << 7)
	/*
	 * The RSS hash was computed over tunnel source IP address, tunnel
	 * destination IP address, and tunnel ID field.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_13  (UINT32_C(0xd) << 7)
	/*
	 * The RSS hash was computed over tunnel source IP address, tunnel
	 * destination IP address, tunnel context, and tunnel ID field.
	 */
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_14  (UINT32_C(0xe) << 7)
		#define RX_PKT_V3_CMPL_RSS_HASH_TYPE_LAST	RX_PKT_V3_CMPL_RSS_HASH_TYPE_ENUM_14
	uint16_t	metadata1_payload_offset;
	/*
	 * If truncation placement is not used, this value indicates the offset
	 * in bytes from the beginning of the packet where the inner payload
	 * starts. This value is valid for TCP, UDP, FCoE, and RoCE packets.
	 * For PTP packets with timestamp (as indicated by the flags_itype
	 * field), this field contains the 4b sub-nanosecond portion of the
	 * timestamp.
	 *
	 * If truncation placement is used, this value represents the placed
	 * (truncated) length of the packet.
	 */
	#define RX_PKT_V3_CMPL_PAYLOAD_OFFSET_MASK	UINT32_C(0x1ff)
	#define RX_PKT_V3_CMPL_PAYLOAD_OFFSET_SFT	0
	/* This is data from the CFA as indicated by the meta_format field. */
	#define RX_PKT_V3_CMPL_METADATA1_MASK		UINT32_C(0xf000)
	#define RX_PKT_V3_CMPL_METADATA1_SFT		12
	/* When meta_format != 0, this value is the VLAN TPID_SEL. */
	#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_MASK	UINT32_C(0x7000)
	#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_SFT	12
	/* 0x88a8 */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPID88A8   (UINT32_C(0x0) << 12)
	/* 0x8100 */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPID8100   (UINT32_C(0x1) << 12)
	/* 0x9100 */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPID9100   (UINT32_C(0x2) << 12)
	/* 0x9200 */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPID9200   (UINT32_C(0x3) << 12)
	/* 0x9300 */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPID9300   (UINT32_C(0x4) << 12)
	/* Value programmed in CFA VLANTPID register. */
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPIDCFG	(UINT32_C(0x5) << 12)
		#define RX_PKT_V3_CMPL_METADATA1_TPID_SEL_LAST	RX_PKT_V3_CMPL_METADATA1_TPID_SEL_TPIDCFG
	/* When meta_format != 0, this value is the VLAN valid. */
	#define RX_PKT_V3_CMPL_METADATA1_VALID		UINT32_C(0x8000)
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC. When hairpin_en
	 * is set in VNIC context, this is the lower 32b of the host address
	 * from the first BD used to place the packet.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/* Last 16 bytes of RX Packet V3 Completion Record */
/* rx_pkt_v3_cmpl_hi (size:128b/16B) */

struct rx_pkt_v3_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_IP_CS_CALC		UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated
	 * for the inner packet and that the l4_cs_error field indicates if
	 * there was an error.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_L4_CS_CALC		UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the t_ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_CS_CALC		UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the t_l4_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_T_L4_CS_CALC		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_SFT		4
	/* There is no metadata information. Values are zero. */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information: - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],
	 * de, vid[11:0]} The metadata2 field contains the table scope
	 * and action record pointer. - metadata2[25:0] contains the
	 * action record pointer. - metadata2[31:26] contains the table
	 * scope.
	 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_ACT_REC_PTR	(UINT32_C(0x1) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the Tunnel ID
	 * value, justified to LSB.
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. zero if K=0
	 * - IPv4 = 0 (not populated)
	 * - IPv6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],de, vid[11:0]}
	 * The metadata2 field contains the 32b metadata from the prepended
	 * header (chdr_data).
	 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the outer_l3_offset,
	 * inner_l2_offset, inner_l3_offset, and inner_l4_size.
	 * - metadata2[8:0] contains the outer_l3_offset.
	 * - metadata2[17:9] contains the inner_l2_offset.
	 * - metadata2[26:18] contains the inner_l3_offset.
	 * - metadata2[31:27] contains the inner_l4_size.
	 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_LAST		RX_PKT_V3_CMPL_HI_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * This field indicates the status of IP and L4 CS calculations done
	 * by the chip. The format of this field is indicated by the
	 * cs_all_ok_mode bit.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_TYPE		UINT32_C(0x400)
	/* Indicates that the Tunnel IP type was IPv4 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_TYPE_IPV4		(UINT32_C(0x0) << 10)
	/* Indicates that the Tunnel IP type was IPv6 */
		#define RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_TYPE_IPV6		(UINT32_C(0x1) << 10)
		#define RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_TYPE_LAST		RX_PKT_V3_CMPL_HI_FLAGS2_T_IP_TYPE_IPV6
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set.
	 */
	#define RX_PKT_V3_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_PKT_V3_CMPL_HI_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 * - meta_format 0 - none - metadata2 = 0 - not valid/not stripped
	 * - meta_format 1 - act_rec_ptr - metadata2 = {table_scope[5:0],
	 *   act_rec_ptr[25:0]}
	 * - meta_format 2 - tunnel_id - metadata2 = tunnel_id[31:0]
	 * - meta_format 3 - chdr_data - metadata2 = updated_chdr_data[31:0]
	 * - meta_format 4 - hdr_offsets - metadata2 = hdr_offsets[31:0]
	 */
	uint32_t	metadata2;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_V3_CMPL_HI_V2					UINT32_C(0x1)
	#define RX_PKT_V3_CMPL_HI_ERRORS_MASK				UINT32_C(0xfffe)
	#define RX_PKT_V3_CMPL_HI_ERRORS_SFT				1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_SFT		1
	/* No buffer error */
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_NO_BUFFER		(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit: Packet did not fit into packet buffer provided.
	 * For regular placement, this means the packet did not fit in
	 * the buffer provided. For HDS and jumbo placement, this means
	 * that the packet could not be placed into 8 physical buffers.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_DID_NOT_FIT		(UINT32_C(0x1) << 1)
	/*
	 * Not On Chip: All BDs needed for the packet were not on-chip
	 * when the packet arrived. For regular placement, this error is
	 * not valid. For HDS and jumbo placement, this means that not
	 * enough agg BDs were posted to place the packet.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_NOT_ON_CHIP		(UINT32_C(0x2) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_BAD_FORMAT		(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_FLUSH		(UINT32_C(0x5) << 1)
		#define RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_LAST		RX_PKT_V3_CMPL_HI_ERRORS_BUFFER_ERROR_FLUSH
	/* This indicates that there was an error in the IP header checksum. */
	#define RX_PKT_V3_CMPL_HI_ERRORS_IP_CS_ERROR			UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP or ICMP
	 * checksum.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_L4_CS_ERROR			UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel IP header
	 * checksum.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_T_IP_CS_ERROR			UINT32_C(0x40)
	/* This indicates that there was an error in the tunnel UDP checksum. */
	#define RX_PKT_V3_CMPL_HI_ERRORS_T_L4_CS_ERROR			UINT32_C(0x80)
	/*
	 * This indicates that there was a CRC error on either an FCoE
	 * or RoCE packet. The itype indicates the packet type.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_CRC_ERROR			UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel portion
	 * of the packet when this field is non-zero.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_MASK		UINT32_C(0xe00)
	#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_SFT			9
	/*
	 * No additional error occurred on the tunnel portion
	 * of the packet or the packet does not have a tunnel.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the tunnel header.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION	(UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the tunnel
	 * header. Valid for IPv4.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6 tunnel
	 * packet packets.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR	(UINT32_C(0x3) << 9)
	/*
	 * Indicates that the physical packet is shorter than that claimed
	 * by the tunnel UDP header length for a tunnel UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR	(UINT32_C(0x4) << 9)
	/*
	 * Indicates that the IPv4 TTL or IPv6 hop limit check have failed
	 * (e.g. TTL = 0) in the tunnel header. Valid for IPv4, and IPv6.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL		(UINT32_C(0x5) << 9)
	/*
	 * Indicates that the physical packet is shorter than that claimed
	 * by the tunnel header length. Valid for GTPv1-U packets.
	 * header.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_TOTAL_ERROR		(UINT32_C(0x6) << 9)
		#define RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_LAST			RX_PKT_V3_CMPL_HI_ERRORS_T_PKT_ERROR_T_TOTAL_ERROR
	/*
	 * This indicates that there was an error in the inner
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_MASK			UINT32_C(0xf000)
	#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_SFT			12
	/*
	 * No additional error occurred on the tunnel portion
	 * or the packet of the packet does not have a tunnel.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6 or that
	 * option other than VFT was parsed on
	 * FCoE packet.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_VERSION		(UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for
	 * IPv4 and RoCE
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN		(UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L3_BAD_TTL		(UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that
	 * claimed by the l3 header length. Valid for IPv4,
	 * IPv6 packet or RoCE packets.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_IP_TOTAL_ERROR		(UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR		(UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for
	 * TCP packets only.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN		(UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL   (UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header
	 * size that does not match data offset in TCP header. Valid
	 * for TCP.
	 */
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN		(UINT32_C(0x8) << 12)
		#define RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_LAST			RX_PKT_V3_CMPL_HI_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint16_t	metadata0;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_PKT_V3_CMPL_HI_METADATA0_VID_MASK UINT32_C(0xfff)
	#define RX_PKT_V3_CMPL_HI_METADATA0_VID_SFT 0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_PKT_V3_CMPL_HI_METADATA0_DE	UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_PKT_V3_CMPL_HI_METADATA0_PRI_MASK UINT32_C(0xe000)
	#define RX_PKT_V3_CMPL_HI_METADATA0_PRI_SFT 13
	/*
	 * The timestamp field contains the 32b timestamp for the packet from
	 * the MAC.
	 *
	 * When hairpin_en is set in VNIC context, this is the upper 32b of the
	 * host address from the first BD used to place the packet.
	 */
	uint32_t	timestamp;
} __attribute__((packed));

/* rx_pkt_compress_cmpl (size:128b/16B) */

struct rx_pkt_compress_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_PKT_COMPRESS_CMPL_TYPE_MASK		UINT32_C(0x3f)
	#define RX_PKT_COMPRESS_CMPL_TYPE_SFT			0
	/*
	 * RX L2 completion:
	 * This is the compressed version of Rx Completion for performance
	 * applications. Length = 16B
	 * This version of the completion record is used in Thor2 and later
	 * chips.
	 */
		#define RX_PKT_COMPRESS_CMPL_TYPE_RX_L2_COMPRESS	UINT32_C(0x10)
		#define RX_PKT_COMPRESS_CMPL_TYPE_LAST			RX_PKT_COMPRESS_CMPL_TYPE_RX_L2_COMPRESS
	#define RX_PKT_COMPRESS_CMPL_FLAGS_MASK		UINT32_C(0xffc0)
	#define RX_PKT_COMPRESS_CMPL_FLAGS_SFT		6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_PKT_COMPRESS_CMPL_FLAGS_ERROR		UINT32_C(0x40)
	/*
	 * This field indicates the status of IP and L4 CS calculations done
	 * by the chip. The format of this field is indicated by the
	 * cs_all_ok_mode bit.
	 */
	#define RX_PKT_COMPRESS_CMPL_FLAGS_T_IP_TYPE		UINT32_C(0x100)
	/* Indicates that the Tunnel IP type was IPv4 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_T_IP_TYPE_IPV4	(UINT32_C(0x0) << 8)
	/* Indicates that the Tunnel IP type was IPv6 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_T_IP_TYPE_IPV6	(UINT32_C(0x1) << 8)
		#define RX_PKT_COMPRESS_CMPL_FLAGS_T_IP_TYPE_LAST	RX_PKT_COMPRESS_CMPL_FLAGS_T_IP_TYPE_IPV6
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_PKT_COMPRESS_CMPL_FLAGS_IP_TYPE		UINT32_C(0x200)
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_COMPRESS_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * Not Known:
	 * Indicates that the packet type was not known.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_NOT_KNOWN	(UINT32_C(0x0) << 12)
	/*
	 * IP Packet:
	 * Indicates that the packet was an IP packet, but further
	 * classification was not possible.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_IP		(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet:
	 * Indicates that the packet was IP and UDP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_UDP		(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet:
	 * Indicates that the packet was recognized as a FCoE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_FCOE		(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet:
	 * Indicates that the packet was recognized as a RoCE.
	 * This also indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_ROCE		(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet:
	 * Indicates that the packet was recognized as ICMP.
	 * This indicates that the payload_offset field is valid.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_ICMP		(UINT32_C(0x7) << 12)
	/*
	 * PTP packet wo/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP   (UINT32_C(0x8) << 12)
	/*
	 * PTP packet w/timestamp:
	 * Indicates that the packet was recognized as a PTP
	 * packet and that a timestamp was taken for the packet.
	 * The 4b sub-nanosecond portion of the timestamp is in
	 * the payload_offset field.
	 */
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP	(UINT32_C(0x9) << 12)
		#define RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_LAST		RX_PKT_COMPRESS_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	/*
	 * This is the length of the data for the packet stored in the
	 * buffer(s) identified by the opaque value. This includes
	 * the packet BD and any associated buffer BDs. This does not include
	 * the length of any data places in aggregation BDs.
	 */
	uint16_t	len;
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC. When hairpin_en
	 * is set in VNIC context, this is the lower 32b of the host address
	 * from the first BD used to place the packet.
	 */
	uint32_t	rss_hash;
	uint16_t	metadata1_cs_error_calc_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_PKT_COMPRESS_CMPL_V1				UINT32_C(0x1)
	/* unused is 3 b */
	#define RX_PKT_COMPRESS_CMPL_UNUSED_MASK			UINT32_C(0xe)
	#define RX_PKT_COMPRESS_CMPL_UNUSED_SFT			1
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_MASK		UINT32_C(0xff0)
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_SFT		4
	/* This indicates that there was an error in the IP header checksum. */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_IP_CS_ERROR	UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP or ICMP
	 * checksum.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_L4_CS_ERROR	UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel IP header
	 * checksum.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_T_IP_CS_ERROR	UINT32_C(0x40)
	/* This indicates that there was an error in the tunnel UDP checksum. */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_T_L4_CS_ERROR	UINT32_C(0x80)
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_IP_CS_CALC	UINT32_C(0x100)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated
	 * for the inner packet and that the l4_cs_error field indicates if
	 * there was an error.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_L4_CS_CALC	UINT32_C(0x200)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the t_ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_T_IP_CS_CALC	UINT32_C(0x400)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the t_l4_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_COMPRESS_CMPL_CS_ERROR_CALC_T_L4_CS_CALC	UINT32_C(0x800)
	/* This is data from the CFA as indicated by the meta_format field. */
	#define RX_PKT_COMPRESS_CMPL_METADATA1_MASK		UINT32_C(0xf000)
	#define RX_PKT_COMPRESS_CMPL_METADATA1_SFT		12
	/* When meta_format != 0, this value is the VLAN TPID_SEL. */
	#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_MASK	UINT32_C(0x7000)
	#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_SFT	12
	/* 0x88a8 */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPID88A8	(UINT32_C(0x0) << 12)
	/* 0x8100 */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPID8100	(UINT32_C(0x1) << 12)
	/* 0x9100 */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPID9100	(UINT32_C(0x2) << 12)
	/* 0x9200 */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPID9200	(UINT32_C(0x3) << 12)
	/* 0x9300 */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPID9300	(UINT32_C(0x4) << 12)
	/* Value programmed in CFA VLANTPID register. */
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPIDCFG	(UINT32_C(0x5) << 12)
		#define RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_LAST	RX_PKT_COMPRESS_CMPL_METADATA1_TPID_SEL_TPIDCFG
	/* When meta_format != 0, this value is the VLAN valid. */
	#define RX_PKT_COMPRESS_CMPL_METADATA1_VALID		UINT32_C(0x8000)
	/* This is data from the CFA as indicated by the meta_format field. */
	uint16_t	vlanc_tcid;
	/* When meta_format!=0, this value is the VLAN VID. */
	#define RX_PKT_COMPRESS_CMPL_VLANC_TCID_VID_MASK UINT32_C(0xfff)
	#define RX_PKT_COMPRESS_CMPL_VLANC_TCID_VID_SFT 0
	/* When meta_format!=0, this value is the VLAN DE. */
	#define RX_PKT_COMPRESS_CMPL_VLANC_TCID_DE	UINT32_C(0x1000)
	/* When meta_format!=0, this value is the VLAN PRI. */
	#define RX_PKT_COMPRESS_CMPL_VLANC_TCID_PRI_MASK UINT32_C(0xe000)
	#define RX_PKT_COMPRESS_CMPL_VLANC_TCID_PRI_SFT 13
	uint32_t	errors_agg_bufs_opaque;
	/* Lower 16bits of the Opaque field provided in the Rx BD. */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_OPAQUE_MASK				UINT32_C(0xffff)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_OPAQUE_SFT				0
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided for the packet in the RX ring.
	 */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_AGG_BUFS_MASK				UINT32_C(0x1f0000)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_AGG_BUFS_SFT				16
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_MASK				UINT32_C(0x1fe00000)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_SFT				21
	/*
	 * This indicates that there was an error in the inner
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_MASK			UINT32_C(0x1e00000)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_SFT			21
	/*
	 * No additional error occurred on the tunnel portion
	 * or the packet of the packet does not have a tunnel.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 21)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6 or that
	 * option other than VFT was parsed on
	 * FCoE packet.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L3_BAD_VERSION		(UINT32_C(0x1) << 21)
	/*
	 * indicates that header length is out of range. Valid for
	 * IPv4 and RoCE
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN		(UINT32_C(0x2) << 21)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L3_BAD_TTL		(UINT32_C(0x3) << 21)
	/*
	 * Indicates that physical packet is shorter than that
	 * claimed by the l3 header length. Valid for IPv4,
	 * IPv6 packet or RoCE packets.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_IP_TOTAL_ERROR		(UINT32_C(0x4) << 21)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR		(UINT32_C(0x5) << 21)
	/*
	 * Indicates that TCP header length > IP payload. Valid for
	 * TCP packets only.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN		(UINT32_C(0x6) << 21)
	/* Indicates that TCP header length < 5. Valid for TCP. */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL   (UINT32_C(0x7) << 21)
	/*
	 * Indicates that TCP option headers result in a TCP header
	 * size that does not match data offset in TCP header. Valid
	 * for TCP.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN		(UINT32_C(0x8) << 21)
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_LAST			RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	/*
	 * This indicates that there was an error in the tunnel portion
	 * of the packet when this field is non-zero.
	 */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_MASK		UINT32_C(0xe000000)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_SFT			25
	/*
	 * No additional error occurred on the tunnel portion
	 * of the packet or the packet does not have a tunnel.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 25)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the tunnel header.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION	(UINT32_C(0x1) << 25)
	/*
	 * Indicates that header length is out of range in the tunnel
	 * header. Valid for IPv4.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 25)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6 tunnel
	 * packet packets.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR	(UINT32_C(0x3) << 25)
	/*
	 * Indicates that the physical packet is shorter than that claimed
	 * by the tunnel UDP header length for a tunnel UDP packet that is
	 * not fragmented.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR	(UINT32_C(0x4) << 25)
	/*
	 * Indicates that the IPv4 TTL or IPv6 hop limit check have failed
	 * (e.g. TTL = 0) in the tunnel header. Valid for IPv4, and IPv6.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL		(UINT32_C(0x5) << 25)
	/*
	 * Indicates that the IP checksum failed its check in the tunnel
	 * header.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_IP_CS_ERROR		(UINT32_C(0x6) << 25)
	/*
	 * Indicates that the L4 checksum failed its check in the tunnel
	 * header.
	 */
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_L4_CS_ERROR		(UINT32_C(0x7) << 25)
		#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_LAST			RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_T_PKT_ERROR_T_L4_CS_ERROR
	/*
	 * This indicates that there was a CRC error on either an FCoE
	 * or RoCE packet. The itype indicates the packet type.
	 */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_ERRORS_CRC_ERROR			UINT32_C(0x10000000)
	/* unused1 is 3 b */
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_UNUSED1_MASK				UINT32_C(0xe0000000)
	#define RX_PKT_COMPRESS_CMPL_ERRORS_AGG_BUFS_OPAQUE_UNUSED1_SFT				29
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_start_cmpl (size:128b/16B) */

struct rx_tpa_start_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_START_CMPL_TYPE_MASK		UINT32_C(0x3f)
	#define RX_TPA_START_CMPL_TYPE_SFT		0
	/*
	 * RX L2 TPA Start Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 */
		#define RX_TPA_START_CMPL_TYPE_RX_TPA_START	UINT32_C(0x13)
		#define RX_TPA_START_CMPL_TYPE_LAST		RX_TPA_START_CMPL_TYPE_RX_TPA_START
	#define RX_TPA_START_CMPL_FLAGS_MASK		UINT32_C(0xffc0)
	#define RX_TPA_START_CMPL_FLAGS_SFT		6
	/* This bit will always be '0' for TPA start completions. */
	#define RX_TPA_START_CMPL_FLAGS_ERROR		UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_MASK	UINT32_C(0x380)
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_SFT	7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_JUMBO	(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_HDS	(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_JUMBO   (UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
		#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_LAST	RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_START_CMPL_FLAGS_RSS_VALID	UINT32_C(0x400)
	/* unused is 1 b */
	#define RX_TPA_START_CMPL_FLAGS_UNUSED		UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_MASK	UINT32_C(0xf000)
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_SFT	12
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 */
		#define RX_TPA_START_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
		#define RX_TPA_START_CMPL_FLAGS_ITYPE_LAST	RX_TPA_START_CMPL_FLAGS_ITYPE_TCP
	/*
	 * This value indicates the amount of packet data written to the
	 * buffer the opaque field in this completion corresponds to.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	uint8_t	v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V1 UINT32_C(0x1)
	#define RX_TPA_START_CMPL_LAST RX_TPA_START_CMPL_V1
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 1: The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/* unused2 is 9 b */
	#define RX_TPA_START_CMPL_UNUSED2_MASK UINT32_C(0x1ff)
	#define RX_TPA_START_CMPL_UNUSED2_SFT 0
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_START_CMPL_AGG_ID_MASK UINT32_C(0xfe00)
	#define RX_TPA_START_CMPL_AGG_ID_SFT  9
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/*
 * Last 16 bytes of rx_tpa_start_cmpl.
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_start_cmpl_hi (size:128b/16B) */

struct rx_tpa_start_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the
	 * inner packet and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_CS_CALC	UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was
	 * calculated for the inner packet and that the sum passed
	 * for all segments included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_L4_CS_CALC	UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the
	 * tunnel header and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_IP_CS_CALC	UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was
	 * calculated for the tunnel packet and that the sum passed for
	 * all segments included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_L4_CS_CALC	UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_MASK UINT32_C(0xf0)
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_SFT  4
	/* No metadata information. Value is zero. */
		#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_NONE   (UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value.
	 * - metadata[11:0] contains the vlan VID value.
	 * - metadata[12] contains the vlan DE value.
	 * - metadata[15:13] contains the vlan PRI value.
	 * - metadata[31:16] contains the vlan TPID value.
	 */
		#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN   (UINT32_C(0x1) << 4)
		#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_LAST  RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_TYPE	UINT32_C(0x100)
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint32_t	metadata;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_TPA_START_CMPL_METADATA_VID_MASK UINT32_C(0xfff)
	#define RX_TPA_START_CMPL_METADATA_VID_SFT  0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_TPA_START_CMPL_METADATA_DE	UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_TPA_START_CMPL_METADATA_PRI_MASK UINT32_C(0xe000)
	#define RX_TPA_START_CMPL_METADATA_PRI_SFT  13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_TPA_START_CMPL_METADATA_TPID_MASK UINT32_C(0xffff0000)
	#define RX_TPA_START_CMPL_METADATA_TPID_SFT 16
	uint16_t	v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V2	UINT32_C(0x1)
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint16_t	cfa_code;
	/*
	 * This is the size in bytes of the inner most L4 header.
	 * This can be subtracted from the payload_offset to determine
	 * the start of the inner most L4 header.
	 */
	uint32_t	inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset;
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the outer L3 header. If there is no outer L3 header, then this
	 * value is zero.
	 */
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_MASK UINT32_C(0x1ff)
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_SFT 0
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L2 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_MASK UINT32_C(0x3fe00)
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_SFT 9
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L3 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_MASK UINT32_C(0x7fc0000)
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_SFT 18
	/*
	 * This is the size in bytes of the inner most L4 header.
	 * This can be subtracted from the payload_offset to determine
	 * the start of the inner most L4 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_MASK  UINT32_C(0xf8000000)
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_SFT   27
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 * RX L2 TPA Start V2 Completion Record (32 bytes split to 2 16-byte
 * struct)
 */
/* rx_tpa_start_v2_cmpl (size:128b/16B) */

struct rx_tpa_start_v2_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_START_V2_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_START_V2_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA Start V2 Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 * This is the new version of the RX_TPA_START completion used
	 * in SR2 and later chips.
	 */
		#define RX_TPA_START_V2_CMPL_TYPE_RX_TPA_START_V2		UINT32_C(0xd)
		#define RX_TPA_START_V2_CMPL_TYPE_LAST			RX_TPA_START_V2_CMPL_TYPE_RX_TPA_START_V2
	#define RX_TPA_START_V2_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_START_V2_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an error
	 * of some type. Type of error is indicated in error_flags.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * IOC/Jumbo:
	 * Packet will be placed using In-Order Completion/Jumbo where
	 * the first packet of the aggregation is placed using Jumbo
	 * Placement. Subsequent packets will be placed such that each
	 * packet starts at the beginning of an aggregation buffer.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_IOC_JUMBO	(UINT32_C(0x4) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	/*
	 * IOC/Header-Data Separation:
	 * Packet will be placed using In-Order Completion/HDS where
	 * the header is in the first packet buffer. Payload of each
	 * packet will be placed such that each packet starts at the
	 * beginning of an aggregation buffer.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_IOC_HDS	(UINT32_C(0x7) << 7)
		#define RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_LAST		RX_TPA_START_V2_CMPL_FLAGS_PLACEMENT_IOC_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_START_V2_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement. It
	 * starts at the first 32B boundary after the end of the header for
	 * HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_START_V2_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
		#define RX_TPA_START_V2_CMPL_FLAGS_ITYPE_LAST		RX_TPA_START_V2_CMPL_FLAGS_ITYPE_TCP
	/*
	 * This value indicates the amount of packet data written to the
	 * buffer the opaque field in this completion corresponds to.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to. If the VNIC is configured to not use an Rx BD for
	 * the TPA Start completion, then this is a copy of the opaque field
	 * from the first BD used to place the TPA Start packet.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	uint8_t	v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_V2_CMPL_V1 UINT32_C(0x1)
	#define RX_TPA_START_V2_CMPL_LAST RX_TPA_START_V2_CMPL_V1
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 1: The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_START_V2_CMPL_AGG_ID_MASK		UINT32_C(0xfff)
	#define RX_TPA_START_V2_CMPL_AGG_ID_SFT		0
	#define RX_TPA_START_V2_CMPL_METADATA1_MASK		UINT32_C(0xf000)
	#define RX_TPA_START_V2_CMPL_METADATA1_SFT		12
	/* When meta_format != 0, this value is the VLAN TPID_SEL. */
	#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_MASK	UINT32_C(0x7000)
	#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_SFT	12
	/* 0x88a8 */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPID88A8   (UINT32_C(0x0) << 12)
	/* 0x8100 */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPID8100   (UINT32_C(0x1) << 12)
	/* 0x9100 */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPID9100   (UINT32_C(0x2) << 12)
	/* 0x9200 */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPID9200   (UINT32_C(0x3) << 12)
	/* 0x9300 */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPID9300   (UINT32_C(0x4) << 12)
	/* Value programmed in CFA VLANTPID register. */
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPIDCFG	(UINT32_C(0x5) << 12)
		#define RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_LAST	RX_TPA_START_V2_CMPL_METADATA1_TPID_SEL_TPIDCFG
	/* When meta_format != 0, this value is the VLAN valid. */
	#define RX_TPA_START_V2_CMPL_METADATA1_VALID		UINT32_C(0x8000)
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 * When vee_cmpl_mode is set in VNIC context, this is the lower
	 * 32b of the host address from the first BD used to place the packet.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/*
 * Last 16 bytes of RX L2 TPA Start V2 Completion Record
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_start_v2_cmpl_hi (size:128b/16B) */

struct rx_tpa_start_v2_cmpl_hi {
	uint32_t	flags2;
	/* This indicates that the aggregation was done using GRO rules. */
	#define RX_TPA_START_V2_CMPL_FLAGS2_AGG_GRO			UINT32_C(0x4)
	/*
	 * When this bit is '0', the cs_ok field has the following definition:-
	 * ip_cs_ok[2:0] = The number of header groups with a valid IP checksum
	 * in the delivered packet, counted from the outer-most header group to
	 * the inner-most header group, stopping at the first error. -
	 * l4_cs_ok[5:3] = The number of header groups with a valid L4 checksum
	 * in the delivered packet, counted from the outer-most header group to
	 * the inner-most header group, stopping at the first error. When this
	 * bit is '1', the cs_ok field has the following definition: -
	 * hdr_cnt[2:0] = The number of header groups that were parsed by the
	 * chip and passed in the delivered packet. - ip_cs_all_ok[3] =This bit
	 * will be '1' if all the parsed header groups with an IP checksum are
	 * valid. - l4_cs_all_ok[4] = This bit will be '1' if all the parsed
	 * header groups with an L4 checksum are valid.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS2_CS_ALL_OK_MODE		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_SFT		4
	/* There is no metadata information. Values are zero. */
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information: - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],
	 * de, vid[11:0]} The metadata2 field contains the table scope
	 * and action record pointer. - metadata2[25:0] contains the
	 * action record pointer. - metadata2[31:26] contains the table
	 * scope.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_ACT_REC_PTR	(UINT32_C(0x1) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the Tunnel ID
	 * value, justified to LSB.
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. zero if K=0
	 * - IPv4 = 0 (not populated)
	 * - IPv6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],de, vid[11:0]}
	 * The metadata2 field contains the 32b metadata from the prepended
	 * header (chdr_data).
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the outer_l3_offset,
	 * inner_l2_offset, inner_l3_offset, and inner_l4_size.
	 * - metadata2[8:0] contains the outer_l3_offset.
	 * - metadata2[17:9] contains the inner_l2_offset.
	 * - metadata2[26:18] contains the inner_l3_offset.
	 * - metadata2[31:27] contains the inner_l4_size.
	 */
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_LAST		RX_TPA_START_V2_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet in the aggregation.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * This field indicates the status of IP and L4 CS calculations done
	 * by the chip. The format of this field is indicated by the
	 * cs_all_ok_mode bit.
	 * CS status for TPA packets is always valid. This means that "all_ok"
	 * status will always be set. The ok count status will be set
	 * appropriately for the packet header, such that all existing CS
	 * values are ok.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS2_CS_OK_MASK		UINT32_C(0xfc00)
	#define RX_TPA_START_V2_CMPL_FLAGS2_CS_OK_SFT		10
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set. For TPA Start completions,
	 * the complete checksum is calculated for the first packet in the
	 * aggregation only.
	 */
	#define RX_TPA_START_V2_CMPL_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_TPA_START_V2_CMPL_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 * - meta_format 0 - none - metadata2 = 0 - not valid/not stripped
	 * - meta_format 1 - act_rec_ptr - metadata2 = {table_scope[5:0],
	 *   act_rec_ptr[25:0]}
	 * - meta_format 2 - tunnel_id - metadata2 = tunnel_id[31:0]
	 * - meta_format 3 - chdr_data - metadata2 = updated_chdr_data[31:0]
	 * - meta_format 4 - hdr_offsets - metadata2 = hdr_offsets[31:0]
	 * When vee_cmpl_mode is set in VNIC context, this is the upper 32b
	 * of the host address from the first BD used to place the packet.
	 */
	uint32_t	metadata2;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_V2_CMPL_V2				UINT32_C(0x1)
	#define RX_TPA_START_V2_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define RX_TPA_START_V2_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packetThe packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/* No buffer error */
		#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit:
	 * Packet did not fit into packet buffer provided. This means
	 * that the TPA Start packet was too big to be placed into the
	 * per-packet maximum number of physical buffers configured for
	 * the VNIC, or that it was too big to be placed into the
	 * per-aggregation maximum number of physical buffers configured
	 * for the VNIC. This error only occurs when the VNIC is
	 * configured for variable size receive buffers.
	 */
		#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT   (UINT32_C(0x1) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT	(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_FLUSH	(UINT32_C(0x5) << 1)
		#define RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_START_V2_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint16_t	metadata0;
	/* When meta_format != 0, this value is the VLAN VID. */
	#define RX_TPA_START_V2_CMPL_METADATA0_VID_MASK UINT32_C(0xfff)
	#define RX_TPA_START_V2_CMPL_METADATA0_VID_SFT 0
	/* When meta_format != 0, this value is the VLAN DE. */
	#define RX_TPA_START_V2_CMPL_METADATA0_DE	UINT32_C(0x1000)
	/* When meta_format != 0, this value is the VLAN PRI. */
	#define RX_TPA_START_V2_CMPL_METADATA0_PRI_MASK UINT32_C(0xe000)
	#define RX_TPA_START_V2_CMPL_METADATA0_PRI_SFT 13
	/*
	 * This field contains the outer_l3_offset, inner_l2_offset,
	 * inner_l3_offset, and inner_l4_size.
	 *
	 * hdr_offsets[8:0] contains the outer_l3_offset.
	 * hdr_offsets[17:9] contains the inner_l2_offset.
	 * hdr_offsets[26:18] contains the inner_l3_offset.
	 * hdr_offsets[31:27] contains the inner_l4_size.
	 */
	uint32_t	hdr_offsets;
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 * RX L2 TPA Start V3 Completion Record (32 bytes split to 2 16-byte
 * struct)
 */
/* rx_tpa_start_v3_cmpl (size:128b/16B) */

struct rx_tpa_start_v3_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_START_V3_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_START_V3_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA Start V3 completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 * This is the new version of the RX_TPA_START completion used
	 * in Thor2 and later chips.
	 */
		#define RX_TPA_START_V3_CMPL_TYPE_RX_TPA_START_V3		UINT32_C(0x19)
		#define RX_TPA_START_V3_CMPL_TYPE_LAST			RX_TPA_START_V3_CMPL_TYPE_RX_TPA_START_V3
	#define RX_TPA_START_V3_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_START_V3_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an error
	 * of some type. Type of error is indicated in error_flags.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * IOC/Jumbo:
	 * Packet will be placed using In-Order Completion/Jumbo where
	 * the first packet of the aggregation is placed using Jumbo
	 * Placement. Subsequent packets will be placed such that each
	 * packet starts at the beginning of an aggregation buffer.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_IOC_JUMBO	(UINT32_C(0x4) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	/*
	 * IOC/Header-Data Separation:
	 * Packet will be placed using In-Order Completion/HDS where
	 * the header is in the first packet buffer. Payload of each
	 * packet will be placed such that each packet starts at the
	 * beginning of an aggregation buffer.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_IOC_HDS	(UINT32_C(0x7) << 7)
		#define RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_LAST		RX_TPA_START_V3_CMPL_FLAGS_PLACEMENT_IOC_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_START_V3_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement. It
	 * starts at the first 32B boundary after the end of the header for
	 * HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_START_V3_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
		#define RX_TPA_START_V3_CMPL_FLAGS_ITYPE_LAST		RX_TPA_START_V3_CMPL_FLAGS_ITYPE_TCP
	/*
	 * This value indicates the amount of packet data written to the
	 * buffer the opaque field in this completion corresponds to.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to. If the VNIC is configured to not use an Rx BD for
	 * the TPA Start completion, then this is a copy of the opaque field
	 * from the first BD used to place the TPA Start packet.
	 */
	uint32_t	opaque;
	uint16_t	rss_hash_type_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_V3_CMPL_V1		UINT32_C(0x1)
	/* unused1 is 6 b. */
	#define RX_TPA_START_V3_CMPL_UNUSED1_MASK	UINT32_C(0x7e)
	#define RX_TPA_START_V3_CMPL_UNUSED1_SFT	1
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers.
	 * * 1: The RSS hash was computed over source IP address and
	 * destination IP address of inner IP header.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 4: The RSS hash was computed over source IP address of the inner
	 * IP header.
	 * * 5: The RSS hash was computed over destination IP address of the
	 * inner IP header.
	 * * 6: The RSS hash was computed over source IP address of the outer
	 * IP header. Note: For non-tunneled packets, this value is not
	 * applicable
	 * * 7: The RSS hash was computed over destination IP address of the
	 * outer IP header.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 8: The RSS hash was computed over source IP address, destination
	 * IP address, and flow label of the inner IP header.
	 * Note: For packets without an inner IPv6 header, this value is not
	 * applicable.
	 * * 9: The RSS hash was computed over the flow label of the inner
	 * IP header.
	 * Note: For packets without an inner IPv6 header, this value
	 * is not applicable.
	 * * 10: The RSS hash was computed over source IP address, destination
	 * IP address, and flow label of the outer IP header.
	 * Note: For packets without an outer IPv6 header, this value is not
	 * applicable.
	 * * 11: The RSS hash was computed over the flow label of the outer
	 * IP header. Note: For packets without an outer IPv6 header, this
	 * value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported
	 * and enabled for TCP traffic only, then the values of
	 * tuple_extract_op corresponding to 4-tuples are only valid for TCP
	 * traffic
	 */
	#define RX_TPA_START_V3_CMPL_RSS_HASH_TYPE_MASK UINT32_C(0xff80)
	#define RX_TPA_START_V3_CMPL_RSS_HASH_TYPE_SFT 7
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_START_V3_CMPL_AGG_ID_MASK		UINT32_C(0xfff)
	#define RX_TPA_START_V3_CMPL_AGG_ID_SFT		0
	#define RX_TPA_START_V3_CMPL_METADATA1_MASK		UINT32_C(0xf000)
	#define RX_TPA_START_V3_CMPL_METADATA1_SFT		12
	/* When meta_format != 0, this value is the VLAN TPID_SEL. */
	#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_MASK	UINT32_C(0x7000)
	#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_SFT	12
	/* 0x88a8 */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPID88A8   (UINT32_C(0x0) << 12)
	/* 0x8100 */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPID8100   (UINT32_C(0x1) << 12)
	/* 0x9100 */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPID9100   (UINT32_C(0x2) << 12)
	/* 0x9200 */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPID9200   (UINT32_C(0x3) << 12)
	/* 0x9300 */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPID9300   (UINT32_C(0x4) << 12)
	/* Value programmed in CFA VLANTPID register. */
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPIDCFG	(UINT32_C(0x5) << 12)
		#define RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_LAST	RX_TPA_START_V3_CMPL_METADATA1_TPID_SEL_TPIDCFG
	/* When meta_format != 0, this value is the VLAN valid. */
	#define RX_TPA_START_V3_CMPL_METADATA1_VALID		UINT32_C(0x8000)
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 * When vee_cmpl_mode is set in VNIC context, this is the lower
	 * 32b of the host address from the first BD used to place the packet.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/*
 * Last 16 bytes of RX L2 TPA Start V3 Completion Record
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_start_v3_cmpl_hi (size:128b/16B) */

struct rx_tpa_start_v3_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_IP_CS_CALC		UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated
	 * for the inner packet and that the l4_cs_error field indicates if
	 * there was an error.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_L4_CS_CALC		UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the t_ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_T_IP_CS_CALC		UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the t_l4_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_T_L4_CS_CALC		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_SFT		4
	/* There is no metadata information. Values are zero. */
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information: - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],
	 * de, vid[11:0]} The metadata2 field contains the table scope
	 * and action record pointer. - metadata2[25:0] contains the
	 * action record pointer. - metadata2[31:26] contains the table
	 * scope.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_ACT_REC_PTR	(UINT32_C(0x1) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the Tunnel ID
	 * value, justified to LSB.
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. zero if K=0
	 * - IPv4 = 0 (not populated)
	 * - IPv6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0],de, vid[11:0]}
	 * The metadata2 field contains the 32b metadata from the prepended
	 * header (chdr_data).
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * The {metadata1, metadata0} fields contain the vtag
	 * information:
	 * - vtag[19:0] = {valid, tpid_sel[2:0], pri[2:0], de, vid[11:0]}
	 * The metadata2 field contains the outer_l3_offset,
	 * inner_l2_offset, inner_l3_offset, and inner_l4_size.
	 * - metadata2[8:0] contains the outer_l3_offset.
	 * - metadata2[17:9] contains the inner_l2_offset.
	 * - metadata2[26:18] contains the inner_l3_offset.
	 * - metadata2[31:27] contains the inner_l4_size.
	 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_LAST		RX_TPA_START_V3_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * This field indicates the status of IP and L4 CS calculations done
	 * by the chip. The format of this field is indicated by the
	 * cs_all_ok_mode bit.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_T_IP_TYPE		UINT32_C(0x400)
	/* Indicates that the Tunnel IP type was IPv4 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_T_IP_TYPE_IPV4		(UINT32_C(0x0) << 10)
	/* Indicates that the Tunnel IP type was IPv6 */
		#define RX_TPA_START_V3_CMPL_FLAGS2_T_IP_TYPE_IPV6		(UINT32_C(0x1) << 10)
		#define RX_TPA_START_V3_CMPL_FLAGS2_T_IP_TYPE_LAST		RX_TPA_START_V3_CMPL_FLAGS2_T_IP_TYPE_IPV6
	/* This indicates that the aggregation was done using GRO rules. */
	#define RX_TPA_START_V3_CMPL_FLAGS2_AGG_GRO			UINT32_C(0x800)
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set. For TPA Start completions,
	 * the complete checksum is calculated for the first packet in the
	 * aggregation only.
	 */
	#define RX_TPA_START_V3_CMPL_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_TPA_START_V3_CMPL_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 * - meta_format 0 - none - metadata2 = 0 - not valid/not stripped
	 * - meta_format 1 - act_rec_ptr - metadata2 = {table_scope[5:0],
	 *   act_rec_ptr[25:0]}
	 * - meta_format 2 - tunnel_id - metadata2 = tunnel_id[31:0]
	 * - meta_format 3 - chdr_data - metadata2 = updated_chdr_data[31:0]
	 * - meta_format 4 - hdr_offsets - metadata2 = hdr_offsets[31:0]
	 * When vee_cmpl_mode is set in VNIC context, this is the upper 32b
	 * of the host address from the first BD used to place the packet.
	 */
	uint32_t	metadata2;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_START_V3_CMPL_V2				UINT32_C(0x1)
	#define RX_TPA_START_V3_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define RX_TPA_START_V3_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packetThe packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/* No buffer error */
		#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit:
	 * Packet did not fit into packet buffer provided. This means
	 * that the TPA Start packet was too big to be placed into the
	 * per-packet maximum number of physical buffers configured for
	 * the VNIC, or that it was too big to be placed into the
	 * per-aggregation maximum number of physical buffers configured
	 * for the VNIC. This error only occurs when the VNIC is
	 * configured for variable size receive buffers.
	 */
		#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT   (UINT32_C(0x1) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT	(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_FLUSH	(UINT32_C(0x5) << 1)
		#define RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_START_V3_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint16_t	metadata0;
	/* When meta_format != 0, this value is the VLAN VID. */
	#define RX_TPA_START_V3_CMPL_METADATA0_VID_MASK UINT32_C(0xfff)
	#define RX_TPA_START_V3_CMPL_METADATA0_VID_SFT 0
	/* When meta_format != 0, this value is the VLAN DE. */
	#define RX_TPA_START_V3_CMPL_METADATA0_DE	UINT32_C(0x1000)
	/* When meta_format != 0, this value is the VLAN PRI. */
	#define RX_TPA_START_V3_CMPL_METADATA0_PRI_MASK UINT32_C(0xe000)
	#define RX_TPA_START_V3_CMPL_METADATA0_PRI_SFT 13
	/*
	 * This field contains the outer_l3_offset, inner_l2_offset,
	 * inner_l3_offset, and inner_l4_size.
	 *
	 * hdr_offsets[8:0] contains the outer_l3_offset.
	 * hdr_offsets[17:9] contains the inner_l2_offset.
	 * hdr_offsets[26:18] contains the inner_l3_offset.
	 * hdr_offsets[31:27] contains the inner_l4_size.
	 */
	uint32_t	hdr_offsets;
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_end_cmpl (size:128b/16B) */

struct rx_tpa_end_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_END_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_END_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA End Completion:
	 * Completion at the end of a TPA operation.
	 * Length = 32B
	 */
		#define RX_TPA_END_CMPL_TYPE_RX_TPA_END		UINT32_C(0x15)
		#define RX_TPA_END_CMPL_TYPE_LAST			RX_TPA_END_CMPL_TYPE_RX_TPA_END
	#define RX_TPA_END_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_END_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * IOC/Jumbo:
	 * Packet will be placed using In-Order Completion/Jumbo where
	 * the first packet of the aggregation is placed using Jumbo
	 * Placement. Subsequent packets will be placed such that each
	 * packet starts at the beginning of an aggregation buffer.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_IOC_JUMBO	(UINT32_C(0x4) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	/*
	 * IOC/Header-Data Separation:
	 * Packet will be placed using In-Order Completion/HDS where
	 * the header is in the first packet buffer. Payload of each
	 * packet will be placed such that each packet starts at the
	 * beginning of an aggregation buffer.
	 */
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_IOC_HDS	(UINT32_C(0x7) << 7)
		#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_LAST		RX_TPA_END_CMPL_FLAGS_PLACEMENT_IOC_HDS
	/* When set, this bit indicates that the timestamp field is valid. */
	#define RX_TPA_END_CMPL_FLAGS_TIMESTAMP_VALID	UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement.
	 * It starts at the first 32B boundary after the end of the header
	 * for HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 * - 2 TCP Packet
	 *	Indicates that the packet was IP and TCP. This indicates
	 *	that the ip_cs field is valid and that the tcp_udp_cs
	 *	field is valid and contains the TCP checksum.
	 *	This also indicates that the payload_offset field is valid.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * This value is zero for TPA End completions.
	 * There is no data in the buffer that corresponds to the opaque
	 * value in this completion.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	uint8_t	agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V1	UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this aggregation
	 * packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided in the aggregation start completion.
	 */
	#define RX_TPA_END_CMPL_AGG_BUFS_MASK UINT32_C(0x7e)
	#define RX_TPA_END_CMPL_AGG_BUFS_SFT 1
	/* This value is the number of segments in the TPA operation. */
	uint8_t	tpa_segs;
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets.
	 *
	 * A value of zero indicates an offset of 256 bytes.
	 */
	uint8_t	payload_offset;
	uint8_t	agg_id;
	/* unused2 is 1 b */
	#define RX_TPA_END_CMPL_UNUSED2	UINT32_C(0x1)
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_END_CMPL_AGG_ID_MASK UINT32_C(0xfe)
	#define RX_TPA_END_CMPL_AGG_ID_SFT  1
	/*
	 * For non-GRO packets, this value is the
	 * timestamp delta between earliest and latest timestamp values for
	 * TPA packet. If packets were not time stamped, then delta will be
	 * zero.
	 *
	 * For GRO packets, this field is zero except for the following
	 * sub-fields.
	 * - tsdelta[31]
	 *	Timestamp present indication. When '0', no Timestamp
	 *	option is in the packet. When '1', then a Timestamp
	 *	option is present in the packet.
	 */
	uint32_t	tsdelta;
} __attribute__((packed));

/*
 * Last 16 bytes of rx_tpa_end_cmpl.
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is 0.
 */
/* rx_tpa_end_cmpl_hi (size:128b/16B) */

struct rx_tpa_end_cmpl_hi {
	uint32_t	tpa_dup_acks;
	/*
	 * This value is the number of duplicate ACKs that have been
	 * received as part of the TPA operation.
	 */
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_MASK UINT32_C(0xf)
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_SFT 0
	/*
	 * This value is the valid when TPA completion is active. It
	 * indicates the length of the longest segment of the TPA operation
	 * for LRO mode and the length of the first segment in GRO mode.
	 *
	 * This value may be used by GRO software to re-construct the original
	 * packet stream from the TPA packet. This is the length of all
	 * but the last segment for GRO. In LRO mode this value may be used
	 * to indicate MSS size to the stack.
	 */
	uint16_t	tpa_seg_len;
	/*
	 * The lower 16b of the timestamp of the last packet added to the
	 * aggregation. Only valid when flags.timestamp_valid is set.
	 */
	uint16_t	timestamp_lower;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V2				UINT32_C(0x1)
	#define RX_TPA_END_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define RX_TPA_END_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/*
	 * This error occurs when there is a fatal HW problem in
	 * the chip only. It indicates that there were not
	 * BDs on chip but that there was adequate reservation.
	 * provided by the TPA block.
	 */
		#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP   (UINT32_C(0x2) << 1)
	/*
	 * This error occurs when TPA block was not configured to
	 * reserve adequate BDs for TPA operations on this RX
	 * ring. All data for the TPA operation was not placed.
	 *
	 * This error can also be generated when the number of
	 * segments is not programmed correctly in TPA and the
	 * 33 total aggregation buffers allowed for the TPA
	 * operation has been exceeded.
	 */
		#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR	(UINT32_C(0x4) << 1)
		#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR
	/*
	 * The upper 16b of the timestamp of the last packet added to the
	 * aggregation. Only valid when flags.timestamp_valid is set.
	 */
	uint16_t	timestamp_upper;
	/*
	 * This is the opaque value that was completed for the TPA start
	 * completion that corresponds to this TPA end completion.
	 */
	uint32_t	start_opaque;
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is greater than 0.
 */
/* rx_tpa_v2_start_cmpl (size:128b/16B) */

struct rx_tpa_v2_start_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_V2_START_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_V2_START_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA Start Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 */
		#define RX_TPA_V2_START_CMPL_TYPE_RX_TPA_START		UINT32_C(0x13)
		#define RX_TPA_V2_START_CMPL_TYPE_LAST			RX_TPA_V2_START_CMPL_TYPE_RX_TPA_START
	#define RX_TPA_V2_START_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_V2_START_CMPL_FLAGS_SFT			6
	/* This bit will always be '0' for TPA start completions. */
	#define RX_TPA_V2_START_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
		#define RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_LAST		RX_TPA_V2_START_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_V2_START_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/*
	 * For devices that support timestamps, when this bit is cleared the
	 * `inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset`
	 * field contains the 32b timestamp for
	 * the packet from the MAC. When this bit is set, the
	 * `inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset`
	 * field contains the outer_l3_offset, inner_l2_offset,
	 * inner_l3_offset, and inner_l4_size.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS_TIMESTAMP_FLD_FORMAT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_V2_START_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
		#define RX_TPA_V2_START_CMPL_FLAGS_ITYPE_LAST		RX_TPA_V2_START_CMPL_FLAGS_ITYPE_TCP
	/*
	 * This value indicates the amount of packet data written to the
	 * buffer the opaque field in this completion corresponds to.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	uint8_t	v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_V2_START_CMPL_V1 UINT32_C(0x1)
	#define RX_TPA_V2_START_CMPL_LAST RX_TPA_V2_START_CMPL_V1
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 1: The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/*
 * Last 16 bytes of rx_tpa_v2_start_cmpl.
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is greater than 0.
 */
/* rx_tpa_v2_start_cmpl_hi (size:128b/16B) */

struct rx_tpa_v2_start_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the
	 * inner packet and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_IP_CS_CALC		UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was
	 * calculated for the inner packet and that the sum passed
	 * for all segments included in the aggregation.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_L4_CS_CALC		UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the
	 * tunnel header and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_T_IP_CS_CALC		UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was
	 * calculated for the tunnel packet and that the sum passed for
	 * all segments included in the aggregation.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_T_L4_CS_CALC		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_SFT		4
	/* No metadata information. Value is zero. */
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value.
	 * - metadata[11:0] contains the vlan VID value.
	 * - metadata[12] contains the vlan DE value.
	 * - metadata[15:13] contains the vlan PRI value.
	 * - metadata[31:16] contains the vlan TPID value.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_VLAN		(UINT32_C(0x1) << 4)
	/*
	 * If ext_meta_format is equal to 1, the metadata field
	 * contains the lower 16b of the tunnel ID value, justified
	 * to LSB
	 * - VXLAN = VNI[23:0] -> VXLAN Network ID
	 * - Geneve (NGE) = VNI[23:0] a-> Virtual Network Identifier.
	 * - NVGRE = TNI[23:0] -> Tenant Network ID
	 * - GRE = KEY[31:0] -> key field with bit mask. Zero if K = 0
	 * - IPV4 = 0 (not populated)
	 * - IPV6 = Flow Label[19:0]
	 * - PPPoE = sessionID[15:0]
	 * - MPLs = Outer label[19:0]
	 * - UPAR = Selected[31:0] with bit mask
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_TUNNEL_ID	(UINT32_C(0x2) << 4)
	/*
	 * if ext_meta_format is equal to 1, metadata field contains
	 * 16b metadata from the prepended header (chdr_data).
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_CHDR_DATA	(UINT32_C(0x3) << 4)
	/*
	 * If ext_meta_format is equal to 1, the metadata field contains
	 * the outer_l3_offset, inner_l2_offset, inner_l3_offset and
	 * inner_l4_size.
	 * - metadata[8:0] contains the outer_l3_offset.
	 * - metadata[17:9] contains the inner_l2_offset.
	 * - metadata[26:18] contains the inner_l3_offset.
	 * - metadata[31:27] contains the inner_l4_size.
	 */
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET	(UINT32_C(0x4) << 4)
		#define RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_LAST		RX_TPA_V2_START_CMPL_FLAGS2_META_FORMAT_HDR_OFFSET
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_IP_TYPE			UINT32_C(0x100)
	/*
	 * This indicates that the complete 1's complement checksum was
	 * calculated for the packet.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_COMPLETE_CHECKSUM_CALC	UINT32_C(0x200)
	/*
	 * The combination of this value and meta_format indicated what
	 * format the metadata field is.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_EXT_META_FORMAT_MASK	UINT32_C(0xc00)
	#define RX_TPA_V2_START_CMPL_FLAGS2_EXT_META_FORMAT_SFT	10
	/*
	 * This value is the complete 1's complement checksum calculated from
	 * the start of the outer L3 header to the end of the packet (not
	 * including the ethernet crc). It is valid when the
	 * 'complete_checksum_calc' flag is set. For TPA Start completions,
	 * the complete checksum is calculated for the first packet in the
	 * aggregation only.
	 */
	#define RX_TPA_V2_START_CMPL_FLAGS2_COMPLETE_CHECKSUM_MASK	UINT32_C(0xffff0000)
	#define RX_TPA_V2_START_CMPL_FLAGS2_COMPLETE_CHECKSUM_SFT	16
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint32_t	metadata;
	/* When {ext_meta_format,meta_format}=1, this value is the VLAN VID. */
	#define RX_TPA_V2_START_CMPL_METADATA_VID_MASK UINT32_C(0xfff)
	#define RX_TPA_V2_START_CMPL_METADATA_VID_SFT  0
	/* When {ext_meta_format,meta_format}=1, this value is the VLAN DE. */
	#define RX_TPA_V2_START_CMPL_METADATA_DE	UINT32_C(0x1000)
	/* When {ext_meta_format,meta_format}=1, this value is the VLAN PRI. */
	#define RX_TPA_V2_START_CMPL_METADATA_PRI_MASK UINT32_C(0xe000)
	#define RX_TPA_V2_START_CMPL_METADATA_PRI_SFT  13
	/* When {ext_meta_format,meta_format}=1, this value is the VLAN TPID. */
	#define RX_TPA_V2_START_CMPL_METADATA_TPID_MASK UINT32_C(0xffff0000)
	#define RX_TPA_V2_START_CMPL_METADATA_TPID_SFT 16
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_V2_START_CMPL_V2				UINT32_C(0x1)
	#define RX_TPA_V2_START_CMPL_ERRORS_MASK		UINT32_C(0xfffe)
	#define RX_TPA_V2_START_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/* No buffer error */
		#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT   (UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_FLUSH	(UINT32_C(0x5) << 1)
		#define RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_V2_START_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint16_t	cfa_code;
	/*
	 * For devices that support timestamps this field is overridden
	 * with the timestamp value. When `flags.timestamp_fld_format` is
	 * cleared, this field contains the 32b timestamp for the packet from the
	 * MAC.
	 *
	 * When `flags.timestamp_fld_format` is set, this field contains the
	 * outer_l3_offset, inner_l2_offset, inner_l3_offset, and inner_l4_size
	 * as defined below.
	 */
	uint32_t	inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset;
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the outer L3 header. If there is no outer L3 header, then this
	 * value is zero.
	 */
	#define RX_TPA_V2_START_CMPL_OUTER_L3_OFFSET_MASK UINT32_C(0x1ff)
	#define RX_TPA_V2_START_CMPL_OUTER_L3_OFFSET_SFT 0
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L2 header.
	 */
	#define RX_TPA_V2_START_CMPL_INNER_L2_OFFSET_MASK UINT32_C(0x3fe00)
	#define RX_TPA_V2_START_CMPL_INNER_L2_OFFSET_SFT 9
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L3 header.
	 */
	#define RX_TPA_V2_START_CMPL_INNER_L3_OFFSET_MASK UINT32_C(0x7fc0000)
	#define RX_TPA_V2_START_CMPL_INNER_L3_OFFSET_SFT 18
	/*
	 * This is the size in bytes of the inner most L4 header.
	 * This can be subtracted from the payload_offset to determine
	 * the start of the inner most L4 header.
	 */
	#define RX_TPA_V2_START_CMPL_INNER_L4_SIZE_MASK  UINT32_C(0xf8000000)
	#define RX_TPA_V2_START_CMPL_INNER_L4_SIZE_SFT   27
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is greater than 0.
 */
/* rx_tpa_v2_end_cmpl (size:128b/16B) */

struct rx_tpa_v2_end_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_V2_END_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_V2_END_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA End Completion:
	 * Completion at the end of a TPA operation.
	 * Length = 32B
	 */
		#define RX_TPA_V2_END_CMPL_TYPE_RX_TPA_END		UINT32_C(0x15)
		#define RX_TPA_V2_END_CMPL_TYPE_LAST			RX_TPA_V2_END_CMPL_TYPE_RX_TPA_END
	#define RX_TPA_V2_END_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_V2_END_CMPL_FLAGS_SFT			6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define RX_TPA_V2_END_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm. This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	/*
	 * IOC/Header-Data Separation:
	 * Packet will be placed using In-Order Completion/HDS where
	 * the header is in the first packet buffer. Payload of each
	 * packet will be placed such that each packet starts at the
	 * beginning of an aggregation buffer.
	 */
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_IOC_HDS	(UINT32_C(0x7) << 7)
		#define RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_LAST		RX_TPA_V2_END_CMPL_FLAGS_PLACEMENT_IOC_HDS
	/* unused is 1 b */
	#define RX_TPA_V2_END_CMPL_FLAGS_UNUSED			UINT32_C(0x400)
	/*
	 * This bit is '1' if metadata has been added to the end of the
	 * packet in host memory. Metadata starts at the first 32B boundary
	 * after the end of the packet for regular and jumbo placement.
	 * It starts at the first 32B boundary after the end of the header
	 * for HDS placement. The length of the metadata is indicated in the
	 * metadata itself.
	 */
	#define RX_TPA_V2_END_CMPL_FLAGS_PKT_METADATA_PRESENT	UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 * - 2 TCP Packet
	 *	Indicates that the packet was IP and TCP. This indicates
	 *	that the ip_cs field is valid and that the tcp_udp_cs
	 *	field is valid and contains the TCP checksum.
	 *	This also indicates that the payload_offset field is valid.
	 */
	#define RX_TPA_V2_END_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_V2_END_CMPL_FLAGS_ITYPE_SFT		12
	/*
	 * This value is zero for TPA End completions.
	 * There is no data in the buffer that corresponds to the opaque
	 * value in this completion.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	uint8_t	v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_V2_END_CMPL_V1	UINT32_C(0x1)
	/* This value is the number of segments in the TPA operation. */
	uint8_t	tpa_segs;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with. Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/*
	 * For non-GRO packets, this value is the
	 * timestamp delta between earliest and latest timestamp values for
	 * TPA packet. If packets were not time stamped, then delta will be
	 * zero.
	 *
	 * For GRO packets, this field is zero except for the following
	 * sub-fields.
	 * - tsdelta[31]
	 *	Timestamp present indication. When '0', no Timestamp
	 *	option is in the packet. When '1', then a Timestamp
	 *	option is present in the packet.
	 */
	uint32_t	tsdelta;
} __attribute__((packed));

/*
 * Last 16 bytes of rx_tpa_v2_end_cmpl.
 *
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is greater than 0.
 */
/* rx_tpa_v2_end_cmpl_hi (size:128b/16B) */

struct rx_tpa_v2_end_cmpl_hi {
	/*
	 * This value is the number of duplicate ACKs that have been
	 * received as part of the TPA operation.
	 */
	uint16_t	tpa_dup_acks;
	/*
	 * This value is the number of duplicate ACKs that have been
	 * received as part of the TPA operation.
	 */
	#define RX_TPA_V2_END_CMPL_TPA_DUP_ACKS_MASK UINT32_C(0xf)
	#define RX_TPA_V2_END_CMPL_TPA_DUP_ACKS_SFT 0
	/*
	 * This value indicated the offset in bytes from the beginning of
	 * the packet where the inner payload starts. This value is valid
	 * for TCP, UDP, FCoE and RoCE packets
	 */
	uint8_t	payload_offset;
	/*
	 * The value is the total number of aggregation buffers that were
	 * used in the TPA operation. All TPA aggregation buffer completions
	 * precede the TPA End completion. If the value is zero, then the
	 * aggregation is completely contained in the buffer space provided
	 * in the aggregation start completion.
	 * Note that the field is simply provided as a cross check.
	 */
	uint8_t	tpa_agg_bufs;
	/*
	 * This value is the valid when TPA completion is active. It
	 * indicates the length of the longest segment of the TPA operation
	 * for LRO mode and the length of the first segment in GRO mode.
	 *
	 * This value may be used by GRO software to re-construct the original
	 * packet stream from the TPA packet. This is the length of all
	 * but the last segment for GRO. In LRO mode this value may be used
	 * to indicate MSS size to the stack.
	 */
	uint16_t	tpa_seg_len;
	uint16_t	unused_1;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_V2_END_CMPL_V2				UINT32_C(0x1)
	#define RX_TPA_V2_END_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define RX_TPA_V2_END_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed. The packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/* No buffer error */
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * This error occurs when there is a fatal HW problem in
	 * the chip only. It indicates that there were not
	 * BDs on chip but that there was adequate reservation.
	 * provided by the TPA block.
	 */
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP   (UINT32_C(0x2) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT	(UINT32_C(0x3) << 1)
	/*
	 * This error occurs when TPA block was not configured to
	 * reserve adequate BDs for TPA operations on this RX
	 * ring. All data for the TPA operation was not placed.
	 *
	 * This error can also be generated when the number of
	 * segments is not programmed correctly in TPA and the
	 * 33 total aggregation buffers allowed for the TPA
	 * operation has been exceeded.
	 */
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR	(UINT32_C(0x4) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_FLUSH	(UINT32_C(0x5) << 1)
		#define RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_V2_END_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	uint16_t	unused_2;
	/*
	 * This is the opaque value that was completed for the TPA start
	 * completion that corresponds to this TPA end completion.
	 */
	uint32_t	start_opaque;
} __attribute__((packed));

/*
 * This TPA completion structure is used on devices where the
 * `hwrm_vnic_qcaps.max_aggs_supported` value is greater than 0.
 */
/* rx_tpa_v2_abuf_cmpl (size:128b/16B) */

struct rx_tpa_v2_abuf_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_V2_ABUF_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define RX_TPA_V2_ABUF_CMPL_TYPE_SFT	0
	/*
	 * RX TPA Aggregation Buffer completion:
	 * Completion of an L2 aggregation buffer in support of
	 * TPA packet completion. Length = 16B
	 */
		#define RX_TPA_V2_ABUF_CMPL_TYPE_RX_TPA_AGG  UINT32_C(0x16)
		#define RX_TPA_V2_ABUF_CMPL_TYPE_LAST	RX_TPA_V2_ABUF_CMPL_TYPE_RX_TPA_AGG
	/*
	 * This is the length of the data for the packet stored in this
	 * aggregation buffer identified by the opaque value. This does not
	 * include the length of any
	 * data placed in other aggregation BDs or in the packet or buffer
	 * BDs. This length does not include any space added due to
	 * hdr_offset register during HDS placement mode.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this aggregation
	 * buffer corresponds to.
	 */
	uint32_t	opaque;
	uint16_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_TPA_V2_ABUF_CMPL_V	UINT32_C(0x1)
	/*
	 * This is the aggregation ID that the completion is associated with. Use
	 * this number to correlate the TPA agg completion with the TPA start
	 * completion and the TPA end completion.
	 */
	uint16_t	agg_id;
	uint32_t	unused_1;
} __attribute__((packed));

/* rx_abuf_cmpl (size:128b/16B) */

struct rx_abuf_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define RX_ABUF_CMPL_TYPE_MASK  UINT32_C(0x3f)
	#define RX_ABUF_CMPL_TYPE_SFT   0
	/*
	 * RX Aggregation Buffer completion:
	 * Completion of an L2 aggregation buffer in support of
	 * TPA, HDS, or Jumbo packet completion. Length = 16B
	 */
		#define RX_ABUF_CMPL_TYPE_RX_AGG  UINT32_C(0x12)
		#define RX_ABUF_CMPL_TYPE_LAST   RX_ABUF_CMPL_TYPE_RX_AGG
	/*
	 * This is the length of the data for the packet stored in this
	 * aggregation buffer identified by the opaque value. This does not
	 * include the length of any
	 * data placed in other aggregation BDs or in the packet or buffer
	 * BDs. This length does not include any space added due to
	 * hdr_offset register during HDS placement mode.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this aggregation
	 * buffer corresponds to.
	 */
	uint32_t	opaque;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define RX_ABUF_CMPL_V	UINT32_C(0x1)
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* VEE FLUSH Completion Record (16 bytes) */
/* vee_flush (size:128b/16B) */

struct vee_flush {
	uint32_t	downstream_path_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define VEE_FLUSH_TYPE_MASK	UINT32_C(0x3f)
	#define VEE_FLUSH_TYPE_SFT		0
	/*
	 * VEE Flush Completion:
	 * This completion is inserted manually by the Primate and processed
	 * by the VEE hardware to ensure that all completions on a VEE
	 * function have been processed by the VEE hardware before FLR
	 * process is completed.
	 */
		#define VEE_FLUSH_TYPE_VEE_FLUSH	UINT32_C(0x1c)
		#define VEE_FLUSH_TYPE_LAST		VEE_FLUSH_TYPE_VEE_FLUSH
	/* downstream_path is 1 b */
	#define VEE_FLUSH_DOWNSTREAM_PATH	UINT32_C(0x40)
	/* This completion is associated with VEE Transmit */
		#define VEE_FLUSH_DOWNSTREAM_PATH_TX	(UINT32_C(0x0) << 6)
	/* This completion is associated with VEE Receive */
		#define VEE_FLUSH_DOWNSTREAM_PATH_RX	(UINT32_C(0x1) << 6)
		#define VEE_FLUSH_DOWNSTREAM_PATH_LAST VEE_FLUSH_DOWNSTREAM_PATH_RX
	/*
	 * This is an opaque value that is passed through the completion
	 * to the VEE handler SW and is used to indicate what VEE VQ or
	 * function has completed FLR processing.
	 */
	uint32_t	opaque;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes will
	 * write 1. The odd passes will write 0.
	 */
	#define VEE_FLUSH_V	UINT32_C(0x1)
	/* unused3 is 32 b */
	uint32_t	unused_3;
} __attribute__((packed));

/* eject_cmpl (size:128b/16B) */

struct eject_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define EJECT_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define EJECT_CMPL_TYPE_SFT	0
	/*
	 * Statistics Ejection Completion:
	 * Completion of statistics data ejection buffer.
	 * Length = 16B
	 */
		#define EJECT_CMPL_TYPE_STAT_EJECT   UINT32_C(0x1a)
		#define EJECT_CMPL_TYPE_LAST	EJECT_CMPL_TYPE_STAT_EJECT
	#define EJECT_CMPL_FLAGS_MASK	UINT32_C(0xffc0)
	#define EJECT_CMPL_FLAGS_SFT	6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type. Type of error is indicated in
	 * error_flags.
	 */
	#define EJECT_CMPL_FLAGS_ERROR	UINT32_C(0x40)
	/*
	 * This is the length of the statistics data stored in this
	 * buffer.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this ejection
	 * buffer corresponds to.
	 */
	uint32_t	opaque;
	uint16_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define EJECT_CMPL_V				UINT32_C(0x1)
	#define EJECT_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define EJECT_CMPL_ERRORS_SFT			1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for statistics ejection. The statistics ejection should
	 * be treated as invalid
	 */
	#define EJECT_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define EJECT_CMPL_ERRORS_BUFFER_ERROR_SFT	1
	/* No buffer error */
		#define EJECT_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit:
	 * Statistics did not fit into aggregation buffer provided.
	 */
		#define EJECT_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT   (UINT32_C(0x1) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
		#define EJECT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT	(UINT32_C(0x3) << 1)
	/*
	 * Flush:
	 * There was a bad_format error on the previous operation
	 */
		#define EJECT_CMPL_ERRORS_BUFFER_ERROR_FLUSH	(UINT32_C(0x5) << 1)
		#define EJECT_CMPL_ERRORS_BUFFER_ERROR_LAST	EJECT_CMPL_ERRORS_BUFFER_ERROR_FLUSH
	/* reserved16 is 16 b */
	uint16_t	reserved16;
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* hwrm_cmpl (size:128b/16B) */

struct hwrm_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_CMPL_TYPE_SFT	0
	/*
	 * HWRM Command Completion:
	 * Completion of an HWRM command.
	 */
		#define HWRM_CMPL_TYPE_HWRM_DONE  UINT32_C(0x20)
		#define HWRM_CMPL_TYPE_LAST	HWRM_CMPL_TYPE_HWRM_DONE
	/* This is the sequence_id of the HWRM command that has completed. */
	uint16_t	sequence_id;
	/* unused2 is 32 b */
	uint32_t	unused_1;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_CMPL_V	UINT32_C(0x1)
	/* unused4 is 32 b */
	uint32_t	unused_3;
} __attribute__((packed));

/* hwrm_fwd_req_cmpl (size:128b/16B) */

struct hwrm_fwd_req_cmpl {
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	uint16_t	req_len_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_FWD_REQ_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_FWD_REQ_CMPL_TYPE_SFT	0
	/* Forwarded HWRM Request */
		#define HWRM_FWD_REQ_CMPL_TYPE_HWRM_FWD_REQ  UINT32_C(0x22)
		#define HWRM_FWD_REQ_CMPL_TYPE_LAST	HWRM_FWD_REQ_CMPL_TYPE_HWRM_FWD_REQ
	/* Length of forwarded request in bytes. */
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_MASK	UINT32_C(0xffc0)
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_SFT	6
	/*
	 * Source ID of this request.
	 * Typically used in forwarding requests and responses.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	source_id;
	/* unused1 is 32 b */
	uint32_t	unused0;
	/* Address of forwarded request. */
	uint64_t	req_buf_addr_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_FWD_REQ_CMPL_V		UINT32_C(0x1)
	/* Address of forwarded request. */
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_MASK UINT32_C(0xfffffffe)
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_SFT 1
} __attribute__((packed));

/* hwrm_fwd_resp_cmpl (size:128b/16B) */

struct hwrm_fwd_resp_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_FWD_RESP_CMPL_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_FWD_RESP_CMPL_TYPE_SFT	0
	/* Forwarded HWRM Response */
		#define HWRM_FWD_RESP_CMPL_TYPE_HWRM_FWD_RESP  UINT32_C(0x24)
		#define HWRM_FWD_RESP_CMPL_TYPE_LAST	HWRM_FWD_RESP_CMPL_TYPE_HWRM_FWD_RESP
	/*
	 * Source ID of this response.
	 * Typically used in forwarding requests and responses.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	source_id;
	/* Length of forwarded response in bytes. */
	uint16_t	resp_len;
	/* unused2 is 16 b */
	uint16_t	unused_1;
	/* Address of forwarded request. */
	uint64_t	resp_buf_addr_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_FWD_RESP_CMPL_V		UINT32_C(0x1)
	/* Address of forwarded request. */
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_MASK UINT32_C(0xfffffffe)
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_SFT 1
} __attribute__((packed));

/* hwrm_async_event_cmpl (size:128b/16B) */

struct hwrm_async_event_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_STATUS_CHANGE		UINT32_C(0x0)
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_MTU_CHANGE		UINT32_C(0x1)
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CHANGE		UINT32_C(0x2)
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DCB_CONFIG_CHANGE		UINT32_C(0x3)
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_CONN_NOT_ALLOWED	UINT32_C(0x4)
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED	UINT32_C(0x5)
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_CHANGE	UINT32_C(0x6)
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_PHY_CFG_CHANGE		UINT32_C(0x7)
	/* Reset notification to clients */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_RESET_NOTIFY			UINT32_C(0x8)
	/* Master function selection event */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_ERROR_RECOVERY		UINT32_C(0x9)
	/*
	 * An event signifying that a ring has been disabled by
	 * hw due to error.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_RING_MONITOR_MSG		UINT32_C(0xa)
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_UNLOAD		UINT32_C(0x10)
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_LOAD		UINT32_C(0x11)
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_FLR_PROC_CMPLT		UINT32_C(0x12)
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_UNLOAD		UINT32_C(0x20)
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_LOAD			UINT32_C(0x21)
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_FLR			UINT32_C(0x30)
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_MAC_ADDR_CHANGE		UINT32_C(0x31)
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_VF_COMM_STATUS_CHANGE	UINT32_C(0x32)
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_CFG_CHANGE		UINT32_C(0x33)
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LLFC_PFC_CHANGE		UINT32_C(0x34)
	/* Default VNIC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DEFAULT_VNIC_CHANGE		UINT32_C(0x35)
	/* HW flow aged */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HW_FLOW_AGED			UINT32_C(0x36)
	/*
	 * A debug notification being posted to the driver. These
	 * notifications are purely for diagnostic purpose and should not be
	 * used for functional purpose. The driver is not supposed to act
	 * on these messages except to log/record it.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DEBUG_NOTIFICATION		UINT32_C(0x37)
	/*
	 * An EEM flow cached memory flush for all flows request event being
	 * posted to the PF driver.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_EEM_CACHE_FLUSH_REQ		UINT32_C(0x38)
	/*
	 * An EEM flow cache memory flush completion event being posted to the
	 * firmware by the PF driver. This is indication that host EEM flush
	 * has completed by the PF.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_EEM_CACHE_FLUSH_DONE		UINT32_C(0x39)
	/*
	 * A tcp flag action change event being posted to the PF or trusted VF
	 * driver by the firmware. The PF or trusted VF driver should query
	 * the firmware for the new TCP flag action update after receiving
	 * this async event.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_TCP_FLAG_ACTION_CHANGE	UINT32_C(0x3a)
	/*
	 * An EEM flow active event being posted to the PF or trusted VF driver
	 * by the firmware. The PF or trusted VF driver should update the
	 * flow's aging timer after receiving this async event.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_EEM_FLOW_ACTIVE		UINT32_C(0x3b)
	/*
	 * A eem cfg change event being posted to the trusted VF driver by the
	 * firmware if the parent PF EEM configuration changed.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_EEM_CFG_CHANGE		UINT32_C(0x3c)
	/*
	 * Deprecated.
	 * TFLIB unique default VNIC Configuration Change
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_TFLIB_DEFAULT_VNIC_CHANGE	UINT32_C(0x3d)
	/*
	 * Deprecated.
	 * TFLIB unique link status changed
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_TFLIB_LINK_STATUS_CHANGE	UINT32_C(0x3e)
	/*
	 * An event signifying completion for HWRM_FW_STATE_QUIESCE
	 * (completion, timeout, or error)
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_QUIESCE_DONE			UINT32_C(0x3f)
	/*
	 * An event signifying a HWRM command is in progress and its
	 * response will be deferred. This event is used on crypto controllers
	 * only.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DEFERRED_RESPONSE		UINT32_C(0x40)
	/*
	 * An event signifying that a PFC WatchDog configuration
	 * has changed on any port / cos.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PFC_WATCHDOG_CFG_CHANGE	UINT32_C(0x41)
	/*
	 * An echo request from the firmware. An echo response is expected by
	 * the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_ECHO_REQUEST			UINT32_C(0x42)
	/*
	 * An event from firmware indicating who has been selected as the
	 * PHC Master or secondary. Also indicates the last time a failover
	 * happens. Event will also be sent when PHC rolls over.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PHC_UPDATE			UINT32_C(0x43)
	/*
	 * An event from firmware showing the last PPS timestamp that has been
	 * latched.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PPS_TIMESTAMP		UINT32_C(0x44)
	/*
	 * An event from firmware indicating that an error has occurred.
	 * The driver should log the event so that an administrator can be
	 * aware that a problem has occurred that may need attention.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_ERROR_REPORT			UINT32_C(0x45)
	/*
	 * An event from firmware indicating that the programmed pacing
	 * threshold for the doorbell global FIFO has been crossed. The driver
	 * needs to take appropriate action to pace the doorbells when this
	 * event is received from the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DOORBELL_PACING_THRESHOLD	UINT32_C(0x46)
	/*
	 * An event from firmware indicating that the RSS capabilities have
	 * changed.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_RSS_CHANGE			UINT32_C(0x47)
	/*
	 * An event from firmware indicating that list of nq ids used for
	 * doorbell pacing DBQ event notification has been updated. The driver
	 * needs to take appropriate action and retrieve the new list when this
	 * event is received from the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DOORBELL_PACING_NQ_UPDATE	UINT32_C(0x48)
	/*
	 * An event from firmware indicating that hardware ran into an error
	 * while trying to read the host based doorbell copy region. The driver
	 * needs to take the appropriate action and maintain the corresponding
	 * doorbell copy region.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HW_DOORBELL_RECOVERY_READ_ERROR UINT32_C(0x49)
	/*
	 * An event from firmware indicating that the XID partition was not
	 * allocated/freed by the FW successfully for the request that is
	 * encapsulated in the HWRM_EXEC_FWD_RESP by the PF driver for VF.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_CTX_ERROR			UINT32_C(0x4a)
	/*
	 * A UDCC session has been modified in the FW. The session_id can be
	 * used by the driver to retrieve information related to the UDCC
	 * session.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_UDCC_SESSION_CHANGE		UINT32_C(0x4b)
	/*
	 * Used to notify the host that the firmware has DMA-ed additional
	 * debug data to the host buffer. This is effectively a producer index
	 * update. The host driver can utilize this information to determine
	 * how much of its host buffer has been populated by the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DBG_BUF_PRODUCER		UINT32_C(0x4c)
	/*
	 * Memory mapping between GPA and HPA has been configured for
	 * a peer device. Inform driver to pick up the new mapping.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PEER_MMAP_CHANGE		UINT32_C(0x4d)
	/*
	 * Used to notify representor endpoint in the driver about pair creation
	 * in the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_REPRESENTOR_PAIR_CHANGE	UINT32_C(0x4e)
	/*
	 * VF statistics context change. Informs PF driver that a VF
	 * statistics context has either been allocated or freed.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_STAT_CHANGE		UINT32_C(0x4f)
	/*
	 * coredump collection into host DMA address. Informs PF driver that
	 * the coredump has been captured.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HOST_COREDUMP		UINT32_C(0x50)
	/* Maximum Registrable event id. */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_MAX_RGTR_EVENT_ID		UINT32_C(0x51)
	/*
	 * A trace log message. This contains firmware trace logs string
	 * embedded in the asynchronous message. This is an experimental
	 * event, not meant for production use at this time.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FW_TRACE_MSG			UINT32_C(0xfe)
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HWRM_ERROR			UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HWRM_ERROR
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

#define GET_EVENT_ID(x) \
	(((x) < 0x80) ? \
	((x) == 0x0 ? "LINK_STATUS_CHANGE": \
	((x) == 0x1 ? "LINK_MTU_CHANGE": \
	((x) == 0x2 ? "LINK_SPEED_CHANGE": \
	((x) == 0x3 ? "DCB_CONFIG_CHANGE": \
	((x) == 0x4 ? "PORT_CONN_NOT_ALLOWED": \
	((x) == 0x5 ? "LINK_SPEED_CFG_NOT_ALLOWED": \
	((x) == 0x6 ? "LINK_SPEED_CFG_CHANGE": \
	((x) == 0x7 ? "PORT_PHY_CFG_CHANGE": \
	((x) == 0x8 ? "RESET_NOTIFY": \
	((x) == 0x9 ? "ERROR_RECOVERY": \
	((x) == 0xa ? "RING_MONITOR_MSG": \
	((x) == 0x10 ? "FUNC_DRVR_UNLOAD": \
	((x) == 0x11 ? "FUNC_DRVR_LOAD": \
	((x) == 0x12 ? "FUNC_FLR_PROC_CMPLT": \
	((x) == 0x20 ? "PF_DRVR_UNLOAD": \
	((x) == 0x21 ? "PF_DRVR_LOAD": \
	((x) == 0x30 ? "VF_FLR": \
	((x) == 0x31 ? "VF_MAC_ADDR_CHANGE": \
	((x) == 0x32 ? "PF_VF_COMM_STATUS_CHANGE": \
	((x) == 0x33 ? "VF_CFG_CHANGE": \
	((x) == 0x34 ? "LLFC_PFC_CHANGE": \
	((x) == 0x35 ? "DEFAULT_VNIC_CHANGE": \
	((x) == 0x36 ? "HW_FLOW_AGED": \
	((x) == 0x37 ? "DEBUG_NOTIFICATION": \
	((x) == 0x38 ? "EEM_CACHE_FLUSH_REQ": \
	((x) == 0x39 ? "EEM_CACHE_FLUSH_DONE": \
	((x) == 0x3a ? "TCP_FLAG_ACTION_CHANGE": \
	((x) == 0x3b ? "EEM_FLOW_ACTIVE": \
	((x) == 0x3c ? "EEM_CFG_CHANGE": \
	((x) == 0x3d ? "TFLIB_DEFAULT_VNIC_CHANGE": \
	((x) == 0x3e ? "TFLIB_LINK_STATUS_CHANGE": \
	((x) == 0x3f ? "QUIESCE_DONE": \
	((x) == 0x40 ? "DEFERRED_RESPONSE": \
	((x) == 0x41 ? "PFC_WATCHDOG_CFG_CHANGE": \
	((x) == 0x42 ? "ECHO_REQUEST": \
	((x) == 0x43 ? "PHC_UPDATE": \
	((x) == 0x44 ? "PPS_TIMESTAMP": \
	((x) == 0x45 ? "ERROR_REPORT": \
	((x) == 0x46 ? "DOORBELL_PACING_THRESHOLD": \
	((x) == 0x47 ? "RSS_CHANGE": \
	((x) == 0x48 ? "DOORBELL_PACING_NQ_UPDATE": \
	((x) == 0x49 ? "HW_DOORBELL_RECOVERY_READ_ERROR": \
	((x) == 0x4a ? "CTX_ERROR": \
	((x) == 0x4b ? "UDCC_SESSION_CHANGE": \
	((x) == 0x4c ? "DBG_BUF_PRODUCER": \
	((x) == 0x4d ? "PEER_MMAP_CHANGE": \
	((x) == 0x4e ? "REPRESENTOR_PAIR_CHANGE": \
	((x) == 0x4f ? "VF_STAT_CHANGE": \
	((x) == 0x50 ? "HOST_COREDUMP": \
	((x) == 0x51 ? "MAX_RGTR_EVENT_ID": \
	"Unknown decode" )))))))))))))))))))))))))))))))))))))))))))))))))) : \
	(((x) < 0x100) ? \
	((x) == 0xfe ? "FW_TRACE_MSG": \
	((x) == 0xff ? "HWRM_ERROR": \
	"Unknown decode" )) : \
	"Unknown decode" ))


/* hwrm_async_event_cmpl_link_status_change (size:128b/16B) */

struct hwrm_async_event_cmpl_link_status_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LINK_STATUS_CHANGE UINT32_C(0x0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LINK_STATUS_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates link status change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE	UINT32_C(0x1)
	/*
	 * If this bit set to 0, then it indicates that the link
	 * was up and it went down.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_DOWN  UINT32_C(0x0)
	/*
	 * If this bit is set to 1, then it indicates that the link
	 * was down and it went up.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP	UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_LAST HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP
	/* Indicates the physical port this link status change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_MASK	UINT32_C(0xe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_SFT	1
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_MASK	UINT32_C(0xffff0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_SFT	4
	/* Indicates the physical function this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PF_ID_MASK	UINT32_C(0xff00000)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PF_ID_SFT	20
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_mtu_change (size:128b/16B) */

struct hwrm_async_event_cmpl_link_mtu_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LINK_MTU_CHANGE UINT32_C(0x1)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LINK_MTU_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* The new MTU of the link in bytes. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_change (size:128b/16B) */

struct hwrm_async_event_cmpl_link_speed_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LINK_SPEED_CHANGE UINT32_C(0x2)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LINK_SPEED_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * When this bit is '1', the link was forced to the
	 * force_link_speed value.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_FORCE			UINT32_C(0x1)
	/* The new link speed in 100 Mbps units. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_MASK UINT32_C(0xfffe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_SFT  1
	/* 100Mb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100MB  (UINT32_C(0x1) << 1)
	/* 1Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_1GB	(UINT32_C(0xa) << 1)
	/* 2Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2GB	(UINT32_C(0x14) << 1)
	/* 25Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2_5GB  (UINT32_C(0x19) << 1)
	/* 10Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_10GB   (UINT32_C(0x64) << 1)
	/* 20Mb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_20GB   (UINT32_C(0xc8) << 1)
	/* 25Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_25GB   (UINT32_C(0xfa) << 1)
	/* 40Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_40GB   (UINT32_C(0x190) << 1)
	/* 50Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_50GB   (UINT32_C(0x1f4) << 1)
	/* 100Gb link speed */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB  (UINT32_C(0x3e8) << 1)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_LAST  HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_MASK		UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_SFT		16
} __attribute__((packed));

/* hwrm_async_event_cmpl_dcb_config_change (size:128b/16B) */

struct hwrm_async_event_cmpl_dcb_config_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_DCB_CONFIG_CHANGE UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_DCB_CONFIG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/* ETS configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_ETS	UINT32_C(0x1)
	/* PFC configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_PFC	UINT32_C(0x2)
	/* APP configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_APP	UINT32_C(0x4)
	/* DSCP configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_DSCP	UINT32_C(0x8)
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_MASK		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_SFT		0
	/* Priority recommended for RoCE traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_SFT 16
	/* none is 255 */
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE  (UINT32_C(0xff) << 16)
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_LAST HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE
	/* Priority recommended for L2 traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_MASK  UINT32_C(0xff000000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_SFT   24
	/* none is 255 */
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE	(UINT32_C(0xff) << 24)
		#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_LAST   HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE
} __attribute__((packed));

/* hwrm_async_event_cmpl_port_conn_not_allowed (size:128b/16B) */

struct hwrm_async_event_cmpl_port_conn_not_allowed {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_PORT_CONN_NOT_ALLOWED UINT32_C(0x4)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_PORT_CONN_NOT_ALLOWED
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT		0
	/*
	 * This value indicates the current port level enforcement policy
	 * for the optics module when there is an optical module mismatch
	 * and port is not connected.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_MASK	UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_SFT	16
	/* No enforcement */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_NONE	(UINT32_C(0x0) << 16)
	/* Disable Transmit side Laser. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_DISABLETX   (UINT32_C(0x1) << 16)
	/* Raise a warning message. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_WARNINGMSG  (UINT32_C(0x2) << 16)
	/* Power down the module. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN	(UINT32_C(0x3) << 16)
		#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_LAST	HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_cfg_not_allowed (size:128b/16B) */

struct hwrm_async_event_cmpl_link_speed_cfg_not_allowed {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED UINT32_C(0x5)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_cfg_change (size:128b/16B) */

struct hwrm_async_event_cmpl_link_speed_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LINK_SPEED_CFG_CHANGE UINT32_C(0x6)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LINK_SPEED_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK			UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT			0
	/*
	 * If set to 1, it indicates that the supported link speeds
	 * configuration on the port has changed.
	 * If set to 0, then there is no change in supported link speeds
	 * configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_SUPPORTED_LINK_SPEEDS_CHANGE	UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the link speed configuration
	 * on the port has become illegal or invalid.
	 * If set to 0, then the link speed configuration on the port is
	 * legal or valid.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_ILLEGAL_LINK_SPEED_CFG	UINT32_C(0x20000)
} __attribute__((packed));

/* hwrm_async_event_cmpl_port_phy_cfg_change (size:128b/16B) */

struct hwrm_async_event_cmpl_port_phy_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_PORT_PHY_CFG_CHANGE UINT32_C(0x7)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_PORT_PHY_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/*
	 * This value indicates the current status of the optics module on
	 * this port. the same information can be found in the module_status
	 * field of the HWRM_PORT_PHY_QCFG response
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_SFT	0
	/* Module is inserted and accepted */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_NONE	UINT32_C(0x0)
	/* Module is rejected and transmit side Laser is disabled. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_DISABLETX	UINT32_C(0x1)
	/* Module mismatch warning. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_MISMATCH	UINT32_C(0x2)
	/* Module is rejected and powered down. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_PWRDOWN	UINT32_C(0x3)
	/* Module is not inserted. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_NOTINSERTED	UINT32_C(0x4)
	/* Module is powered down because of over current fault. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_CURRENTFAULT   UINT32_C(0x5)
	/* Module is overheated. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_OVERHEATED	UINT32_C(0x6)
	/* Module status is not applicable. */
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_NOTAPPLICABLE  UINT32_C(0xff)
		#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_LAST	HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA2_MODULE_STATUS_NOTAPPLICABLE
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK	UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT	0
	/*
	 * If set to 1, it indicates that the FEC
	 * configuration on the port has changed.
	 * If set to 0, then there is no change in FEC configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_FEC_CFG_CHANGE	UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the EEE configuration
	 * on the port has changed.
	 * If set to 0, then there is no change in EEE configuration
	 * on the port.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_EEE_CFG_CHANGE	UINT32_C(0x20000)
	/*
	 * If set to 1, it indicates that the pause configuration
	 * on the PHY has changed.
	 * If set to 0, then there is no change in the pause
	 * configuration on the PHY.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PAUSE_CFG_CHANGE	UINT32_C(0x40000)
} __attribute__((packed));

/* hwrm_async_event_cmpl_reset_notify (size:128b/16B) */

struct hwrm_async_event_cmpl_reset_notify {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notify clients of imminent reset. */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_ID_RESET_NOTIFY UINT32_C(0x8)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_ID_RESET_NOTIFY
	/* Event specific data. The data is for internal debug use only. */
	uint32_t	event_data2;
	/*
	 * These bits indicate the status as being reported by the firmware.
	 * This value is exactly the same as status code in fw_status register.
	 * If the status code is equal to 0x8000, then the reset is initiated
	 * by the Host using the FW_RESET command when the FW is in a healthy
	 * state. If the status code is not equal to 0x8000, then the reset is
	 * initiated by the FW to recover from the error or FATAL state.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA2_FW_STATUS_CODE_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA2_FW_STATUS_CODE_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_OPAQUE_SFT 1
	/*
	 * 8-lsb timestamp (100-msec resolution)
	 * The Minimum time required for the Firmware readiness after sending
	 * this notification to the driver instances.
	 */
	uint8_t	timestamp_lo;
	/*
	 * 16-lsb timestamp (100-msec resolution)
	 * The Maximum Firmware Reset bail out value in the order of 100
	 * milliseconds. The driver instances will use this value to reinitiate
	 * the registration process again if the core firmware didn't set the
	 * state bit.
	 */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates driver action requested */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_MASK		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_SFT		0
	/*
	 * If set to 1, it indicates that the l2 client should
	 * stop sending in band traffic to Nitro.
	 * if set to 0, there is no change in L2 client behavior.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_DRIVER_STOP_TX_QUEUE	UINT32_C(0x1)
	/*
	 * If set to 1, it indicates that the L2 client should
	 * bring down the interface.
	 * If set to 0, then there is no change in L2 client behavior.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_DRIVER_IFDOWN	UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_LAST		HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DRIVER_ACTION_DRIVER_IFDOWN
	/* Indicates reason for reset. */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_MASK			UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_SFT			8
	/* A management client has requested reset. */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_MANAGEMENT_RESET_REQUEST  (UINT32_C(0x1) << 8)
	/* A fatal firmware exception has occurred. */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_FW_EXCEPTION_FATAL	(UINT32_C(0x2) << 8)
	/* A non-fatal firmware exception has occurred. */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_FW_EXCEPTION_NON_FATAL	(UINT32_C(0x3) << 8)
	/* Fast reset */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_FAST_RESET		(UINT32_C(0x4) << 8)
	/*
	 * Reset was a result of a firmware activation. That is, the
	 * fw_activation flag was set in a FW_RESET operation.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_FW_ACTIVATION		(UINT32_C(0x5) << 8)
		#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_LAST			HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_REASON_CODE_FW_ACTIVATION
	/*
	 * Minimum time before driver should attempt access - units 100ms
	 * ticks.
	 * Range 0-65535
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DELAY_IN_100MS_TICKS_MASK	UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_RESET_NOTIFY_EVENT_DATA1_DELAY_IN_100MS_TICKS_SFT		16
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_recovery (size:128b/16B) */

struct hwrm_async_event_cmpl_error_recovery {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message can be used for selecting or
	 * deselecting master function for error recovery,
	 * and to communicate to all the functions whether error recovery
	 * was enabled/disabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_ID_ERROR_RECOVERY UINT32_C(0x9)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_ID_ERROR_RECOVERY
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates driver action requested */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_DATA1_FLAGS_MASK		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_DATA1_FLAGS_SFT		0
	/*
	 * If set to 1, this function is selected as Master function.
	 * This function has responsibility to do 'chip reset' when it
	 * detects a fatal error. If set to 0, master function functionality
	 * is disabled on this function.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_DATA1_FLAGS_MASTER_FUNC	UINT32_C(0x1)
	/*
	 * If set to 1, error recovery is enabled.
	 * If set to 0, error recovery is disabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_RECOVERY_EVENT_DATA1_FLAGS_RECOVERY_ENABLED	UINT32_C(0x2)
} __attribute__((packed));

/* hwrm_async_event_cmpl_ring_monitor_msg (size:128b/16B) */

struct hwrm_async_event_cmpl_ring_monitor_msg {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Ring Monitor Message. */
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_ID_RING_MONITOR_MSG UINT32_C(0xa)
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_ID_RING_MONITOR_MSG
	/* Event specific data */
	uint32_t	event_data2;
	/* Type of Ring disabled. */
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_SFT 0
	/* tx ring disabled. */
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_TX	UINT32_C(0x0)
	/* rx ring disabled. */
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_RX	UINT32_C(0x1)
	/* cmpl ring disabled. */
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_CMPL  UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_LAST HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_EVENT_DATA2_DISABLE_RING_TYPE_CMPL
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_RING_MONITOR_MSG_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/*
	 * Event specific data. If ring_type_disabled indicates a tx, rx or cmpl
	 * then this field will indicate the ring id.
	 */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_drvr_unload (size:128b/16B) */

struct hwrm_async_event_cmpl_func_drvr_unload {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_FUNC_DRVR_UNLOAD UINT32_C(0x10)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_FUNC_DRVR_UNLOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_drvr_load (size:128b/16B) */

struct hwrm_async_event_cmpl_func_drvr_load {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_FUNC_DRVR_LOAD UINT32_C(0x11)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_FUNC_DRVR_LOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_flr_proc_cmplt (size:128b/16B) */

struct hwrm_async_event_cmpl_func_flr_proc_cmplt {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_FUNC_FLR_PROC_CMPLT UINT32_C(0x12)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_FUNC_FLR_PROC_CMPLT
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_drvr_unload (size:128b/16B) */

struct hwrm_async_event_cmpl_pf_drvr_unload {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_PF_DRVR_UNLOAD UINT32_C(0x20)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_PF_DRVR_UNLOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_MASK   UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_SFT	16
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_drvr_load (size:128b/16B) */

struct hwrm_async_event_cmpl_pf_drvr_load {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_PF_DRVR_LOAD UINT32_C(0x21)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_PF_DRVR_LOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_MASK   UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_SFT	16
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_flr (size:128b/16B) */

struct hwrm_async_event_cmpl_vf_flr {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_VF_FLR UINT32_C(0x30)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_LAST  HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_VF_FLR
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_SFT 0
	/* Indicates the physical function this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_PF_ID_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_PF_ID_SFT 16
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_mac_addr_change (size:128b/16B) */

struct hwrm_async_event_cmpl_vf_mac_addr_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_VF_MAC_ADDR_CHANGE UINT32_C(0x31)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_VF_MAC_ADDR_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_vf_comm_status_change (size:128b/16B) */

struct hwrm_async_event_cmpl_pf_vf_comm_status_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_PF_VF_COMM_STATUS_CHANGE UINT32_C(0x32)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_PF_VF_COMM_STATUS_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * If this bit is set to 1, then it indicates that the PF-VF
	 * communication was lost and it is established.
	 * If this bit set to 0, then it indicates that the PF-VF
	 * communication was established and it is lost.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_DATA1_COMM_ESTABLISHED	UINT32_C(0x1)
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_cfg_change (size:128b/16B) */

struct hwrm_async_event_cmpl_vf_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_VF_CFG_CHANGE UINT32_C(0x33)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_VF_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/*
	 * This value indicates the VF ID of the VF whose configuration
	 * is changing if this async. event is sent to the parent PF.
	 * The firmware supports sending this to the parent PF if the
	 * `hwrm_func_qcaps.vf_cfg_async_for_pf_supported` value is 1.
	 * This value is undefined when the async. event is sent to the
	 * VF.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA2_VF_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA2_VF_ID_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/*
	 * Each flag provided in this field indicates a specific VF
	 * configuration change. At least one of these flags shall be set to 1
	 * when an asynchronous event completion of this type is provided
	 * by the HWRM.
	 */
	uint32_t	event_data1;
	/*
	 * If this bit is set to 1, then the value of MTU
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MTU_CHANGE		UINT32_C(0x1)
	/*
	 * If this bit is set to 1, then the value of MRU
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MRU_CHANGE		UINT32_C(0x2)
	/*
	 * If this bit is set to 1, then the value of default MAC
	 * address was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_MAC_ADDR_CHANGE	UINT32_C(0x4)
	/*
	 * If this bit is set to 1, then the value of default VLAN
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_VLAN_CHANGE	UINT32_C(0x8)
	/*
	 * If this bit is set to 1, then the value of trusted VF enable
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_TRUSTED_VF_CFG_CHANGE	UINT32_C(0x10)
	/*
	 * If this bit is set to 1, then the control of VF was relinquished
	 * back to the firmware flow manager following the function takeover
	 * by TruFlow.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_TF_OWNERSHIP_RELEASE	UINT32_C(0x20)
} __attribute__((packed));

/* hwrm_async_event_cmpl_llfc_pfc_change (size:128b/16B) */

struct hwrm_async_event_cmpl_llfc_pfc_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* unused1 is 10 b */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_UNUSED1_MASK	UINT32_C(0xffc0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_UNUSED1_SFT	6
	/* Identifiers of events. */
	uint16_t	event_id;
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LLFC_PFC_CHANGE UINT32_C(0x34)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LLFC_PFC_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates llfc pfc status change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_MASK UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_SFT 0
	/*
	 * If this field set to 1, then it indicates that llfc is
	 * enabled.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LLFC  UINT32_C(0x1)
	/*
	 * If this field is set to 2, then it indicates that pfc
	 * is enabled.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC   UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LAST HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC
	/* Indicates the physical port this llfc pfc change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_MASK	UINT32_C(0x1c)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_SFT	2
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0x1fffe0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_SFT  5
} __attribute__((packed));

/* hwrm_async_event_cmpl_default_vnic_change (size:128b/16B) */

struct hwrm_async_event_cmpl_default_vnic_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* unused1 is 10 b */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_UNUSED1_MASK	UINT32_C(0xffc0)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_UNUSED1_SFT	6
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of a default vnic allocation or free */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_ID_ALLOC_FREE_NOTIFICATION UINT32_C(0x35)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_ID_ALLOC_FREE_NOTIFICATION
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates default vnic configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_MASK	UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_SFT	0
	/*
	 * If this field is set to 1, then it indicates that
	 * a default VNIC has been allocate.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_DEF_VNIC_ALLOC  UINT32_C(0x1)
	/*
	 * If this field is set to 2, then it indicates that
	 * a default VNIC has been freed.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_DEF_VNIC_FREE   UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_LAST	HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_DEF_VNIC_STATE_DEF_VNIC_FREE
	/* Indicates the physical function this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_PF_ID_MASK		UINT32_C(0x3fc)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_PF_ID_SFT			2
	/* Indicates the virtual function this event occurred on */
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_VF_ID_MASK		UINT32_C(0x3fffc00)
	#define HWRM_ASYNC_EVENT_CMPL_DEFAULT_VNIC_CHANGE_EVENT_DATA1_VF_ID_SFT			10
} __attribute__((packed));

/* hwrm_async_event_cmpl_hw_flow_aged (size:128b/16B) */

struct hwrm_async_event_cmpl_hw_flow_aged {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of a hw flow aged */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_ID_HW_FLOW_AGED UINT32_C(0x36)
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_ID_HW_FLOW_AGED
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates flow ID this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_ID_MASK	UINT32_C(0x7fffffff)
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_ID_SFT	0
	/* Indicates flow direction this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_DIRECTION	UINT32_C(0x80000000)
	/*
	 * If this bit set to 0, then it indicates that the aged
	 * event was rx flow.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_DIRECTION_RX	(UINT32_C(0x0) << 31)
	/*
	 * If this bit is set to 1, then it indicates that the aged
	 * event was tx flow.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_DIRECTION_TX	(UINT32_C(0x1) << 31)
		#define HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_DIRECTION_LAST HWRM_ASYNC_EVENT_CMPL_HW_FLOW_AGED_EVENT_DATA1_FLOW_DIRECTION_TX
} __attribute__((packed));

/* hwrm_async_event_cmpl_eem_cache_flush_req (size:128b/16B) */

struct hwrm_async_event_cmpl_eem_cache_flush_req {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of a eem_cache_flush request */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_EVENT_ID_EEM_CACHE_FLUSH_REQ UINT32_C(0x38)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_EVENT_ID_EEM_CACHE_FLUSH_REQ
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_REQ_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_eem_cache_flush_done (size:128b/16B) */

struct hwrm_async_event_cmpl_eem_cache_flush_done {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * Notification of a host eem_cache_flush has completed. This event
	 * is generated by the host driver.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_EVENT_ID_EEM_CACHE_FLUSH_DONE UINT32_C(0x39)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_EVENT_ID_EEM_CACHE_FLUSH_DONE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates function ID that this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_EVENT_DATA1_FID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CACHE_FLUSH_DONE_EVENT_DATA1_FID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_tcp_flag_action_change (size:128b/16B) */

struct hwrm_async_event_cmpl_tcp_flag_action_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of tcp flag action change */
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_EVENT_ID_TCP_FLAG_ACTION_CHANGE UINT32_C(0x3a)
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_EVENT_ID_TCP_FLAG_ACTION_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_TCP_FLAG_ACTION_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_eem_flow_active (size:128b/16B) */

struct hwrm_async_event_cmpl_eem_flow_active {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of an active eem flow */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_ID_EEM_FLOW_ACTIVE UINT32_C(0x3b)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_ID_EEM_FLOW_ACTIVE
	/* Event specific data */
	uint32_t	event_data2;
	/* Indicates the 2nd global id this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_GLOBAL_ID_2_MASK   UINT32_C(0x3fffffff)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_GLOBAL_ID_2_SFT	0
	/*
	 * Indicates flow direction of the flow identified by
	 * the global_id_2.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_FLOW_DIRECTION	UINT32_C(0x40000000)
	/* If this bit is set to 0, then it indicates that this rx flow. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_FLOW_DIRECTION_RX	(UINT32_C(0x0) << 30)
	/* If this bit is set to 1, then it indicates that this tx flow. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_FLOW_DIRECTION_TX	(UINT32_C(0x1) << 30)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_FLOW_DIRECTION_LAST HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA2_FLOW_DIRECTION_TX
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the 1st global id this event occurred on. */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_GLOBAL_ID_1_MASK   UINT32_C(0x3fffffff)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_GLOBAL_ID_1_SFT	0
	/*
	 * Indicates flow direction of the flow identified by the
	 * global_id_1.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_FLOW_DIRECTION	UINT32_C(0x40000000)
	/* If this bit is set to 0, then it indicates that this is rx flow. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_FLOW_DIRECTION_RX	(UINT32_C(0x0) << 30)
	/* If this bit is set to 1, then it indicates that this is tx flow. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_FLOW_DIRECTION_TX	(UINT32_C(0x1) << 30)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_FLOW_DIRECTION_LAST HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_FLOW_DIRECTION_TX
	/*
	 * Indicates EEM flow aging mode this event occurred on. If
	 * this bit is set to 0, the event_data1 is the EEM global
	 * ID. If this bit is set to 1, the event_data1 is the number
	 * of global ID in the context memory.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_MODE		UINT32_C(0x80000000)
	/* EEM flow aging mode 0. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_MODE_0		(UINT32_C(0x0) << 31)
	/* EEM flow aging mode 1. */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_MODE_1		(UINT32_C(0x1) << 31)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_MODE_LAST	HWRM_ASYNC_EVENT_CMPL_EEM_FLOW_ACTIVE_EVENT_DATA1_MODE_1
} __attribute__((packed));

/* hwrm_async_event_cmpl_eem_cfg_change (size:128b/16B) */

struct hwrm_async_event_cmpl_eem_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Notification of EEM configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_EVENT_ID_EEM_CFG_CHANGE UINT32_C(0x3c)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_EVENT_ID_EEM_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * Value of 1 to indicate EEM TX configuration is enabled. Value of
	 * 0 to indicate the EEM TX configuration is disabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_EVENT_DATA1_EEM_TX_ENABLE	UINT32_C(0x1)
	/*
	 * Value of 1 to indicate EEM RX configuration is enabled. Value of 0
	 * to indicate the EEM RX configuration is disabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_EEM_CFG_CHANGE_EVENT_DATA1_EEM_RX_ENABLE	UINT32_C(0x2)
} __attribute__((packed));

/* hwrm_async_event_cmpl_quiesce_done (size:128b/16B) */

struct hwrm_async_event_cmpl_quiesce_done {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* An event signifying completion of HWRM_FW_STATE_QUIESCE */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_ID_QUIESCE_DONE UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_ID_QUIESCE_DONE
	/* Event specific data */
	uint32_t	event_data2;
	/* Status of HWRM_FW_STATE_QUIESCE completion */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_MASK		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_SFT		0
	/*
	 * The quiesce operation started by HWRM_FW_STATE_QUIESCE
	 * completed successfully.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_SUCCESS		UINT32_C(0x0)
	/*
	 * The quiesce operation started by HWRM_FW_STATE_QUIESCE timed
	 * out.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_TIMEOUT		UINT32_C(0x1)
	/*
	 * The quiesce operation started by HWRM_FW_STATE_QUIESCE
	 * encountered an error.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_ERROR		UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_LAST		HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_QUIESCE_STATUS_ERROR
	/* opaque is 8 b */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_OPAQUE_MASK			UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_OPAQUE_SFT			8
	/*
	 * Additional information about internal hardware state related to
	 * idle/quiesce state. QUIESCE may succeed per quiesce_status
	 * regardless of idle_state_flags. If QUIESCE fails, the host may
	 * inspect idle_state_flags to determine whether a retry is warranted.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_MASK		UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_SFT		16
	/*
	 * Failure to quiesce is caused by host not updating the NQ consumer
	 * index.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_INCOMPLETE_NQ	UINT32_C(0x10000)
	/* Flag 1 indicating partial non-idle state. */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_IDLE_STATUS_1	UINT32_C(0x20000)
	/* Flag 2 indicating partial non-idle state. */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_IDLE_STATUS_2	UINT32_C(0x40000)
	/* Flag 3 indicating partial non-idle state. */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA2_IDLE_STATE_FLAGS_IDLE_STATUS_3	UINT32_C(0x80000)
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Time stamp for error event */
	#define HWRM_ASYNC_EVENT_CMPL_QUIESCE_DONE_EVENT_DATA1_TIMESTAMP	UINT32_C(0x1)
} __attribute__((packed));

/* hwrm_async_event_cmpl_deferred_response (size:128b/16B) */

struct hwrm_async_event_cmpl_deferred_response {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * An event signifying a HWRM command is in progress and its
	 * response will be deferred
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_EVENT_ID_DEFERRED_RESPONSE UINT32_C(0x40)
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_EVENT_ID_DEFERRED_RESPONSE
	/* Event specific data */
	uint32_t	event_data2;
	/*
	 * The PF's mailbox is clear to issue another command.
	 * A command with this seq_id is still in progress
	 * and will return a regular HWRM completion when done.
	 * 'event_data1' field, if non-zero, contains the estimated
	 * execution time for the command.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_EVENT_DATA2_SEQ_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_EVENT_DATA2_SEQ_ID_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DEFERRED_RESPONSE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Estimated remaining time of command execution in ms (if not zero) */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_pfc_watchdog_cfg_change (size:128b/16B) */

struct hwrm_async_event_cmpl_pfc_watchdog_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PFC watchdog configuration change for given port/cos */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_ID_PFC_WATCHDOG_CFG_CHANGE UINT32_C(0x41)
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_ID_PFC_WATCHDOG_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * 1 in bit position X indicates PFC watchdog should
	 * be on for COSX
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_MASK		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_SFT		0
	/* 1 means PFC WD for COS0 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS0	UINT32_C(0x1)
	/* 1 means PFC WD for COS1 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS1	UINT32_C(0x2)
	/* 1 means PFC WD for COS2 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS2	UINT32_C(0x4)
	/* 1 means PFC WD for COS3 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS3	UINT32_C(0x8)
	/* 1 means PFC WD for COS4 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS4	UINT32_C(0x10)
	/* 1 means PFC WD for COS5 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS5	UINT32_C(0x20)
	/* 1 means PFC WD for COS6 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS6	UINT32_C(0x40)
	/* 1 means PFC WD for COS7 is on, 0 - off. */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PFC_WD_COS_PFC_WD_COS7	UINT32_C(0x80)
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK		UINT32_C(0xffff00)
	#define HWRM_ASYNC_EVENT_CMPL_PFC_WATCHDOG_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT		8
} __attribute__((packed));

/* hwrm_async_event_cmpl_echo_request (size:128b/16B) */

struct hwrm_async_event_cmpl_echo_request {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * An echo request from the firmware. An echo response is expected by
	 * the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_EVENT_ID_ECHO_REQUEST UINT32_C(0x42)
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_EVENT_ID_ECHO_REQUEST
	/* Event specific data that should be provided in the echo response */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ECHO_REQUEST_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data that should be provided in the echo response */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_phc_update (size:128b/16B) */

struct hwrm_async_event_cmpl_phc_update {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async event is used to notify driver of changes
	 * in PHC master. Only one master function can configure
	 * PHC.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_ID_PHC_UPDATE UINT32_C(0x43)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_ID_PHC_UPDATE
	/* Event specific data */
	uint32_t	event_data2;
	/* This field provides the current master function. */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA2_PHC_MASTER_FID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA2_PHC_MASTER_FID_SFT 0
	/* This field provides the current secondary function. */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA2_PHC_SEC_FID_MASK   UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA2_PHC_SEC_FID_SFT	16
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates to the driver the type of PHC event. */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_MASK	UINT32_C(0xf)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_SFT	0
	/*
	 * Indicates PHC Master selection event. The master fid is
	 * specified in event_data2.phc_master_fid.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_PHC_MASTER	UINT32_C(0x1)
	/*
	 * Indicates PHC Secondary selection event. The secondary fid is
	 * specified in event_data2.phc_sec_fid.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_PHC_SECONDARY   UINT32_C(0x2)
	/*
	 * Indicates PHC failover event. Failover happens from
	 * event_data2.phc_master_fid to event_data2.phc_sec_fid.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_PHC_FAILOVER	UINT32_C(0x3)
	/*
	 * Indicates that the 64bit Real time clock upper 16bits
	 * have been updated due to PHC rollover. The updated
	 * upper 16bits is in event_data1.phc_time_msb
	 */
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_PHC_RTC_UPDATE  UINT32_C(0x4)
		#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_LAST	HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_FLAGS_PHC_RTC_UPDATE
	/*
	 * This field provides the upper 16bits of the 64bit real
	 * time clock.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_PHC_TIME_MSB_MASK   UINT32_C(0xffff0)
	#define HWRM_ASYNC_EVENT_CMPL_PHC_UPDATE_EVENT_DATA1_PHC_TIME_MSB_SFT	4
} __attribute__((packed));

/* hwrm_async_event_cmpl_pps_timestamp (size:128b/16B) */

struct hwrm_async_event_cmpl_pps_timestamp {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message can be used to inform
	 * driver of the latest PPS timestamp that has been latched.
	 * When driver enables PPS event, Firmware will generate
	 * PPS timestamps every second, Firmware informs driver
	 * of this timestamp through the async event.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_ID_PPS_TIMESTAMP UINT32_C(0x44)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_ID_PPS_TIMESTAMP
	/* Event specific data */
	uint32_t	event_data2;
	/* Indicates the PPS event type */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_EVENT_TYPE		UINT32_C(0x1)
	/* This is an internal event. */
		#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_EVENT_TYPE_INTERNAL	UINT32_C(0x0)
	/* This is an external event. */
		#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_EVENT_TYPE_EXTERNAL	UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_EVENT_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_EVENT_TYPE_EXTERNAL
	/*
	 * Indicates the pin number on which the event is
	 * received.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_PIN_NUMBER_MASK	UINT32_C(0xe)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_PIN_NUMBER_SFT	1
	/*
	 * Contains bits[47:32] of the upper PPS timestamp.
	 * Lower 32 bits are in event_data1. Together they
	 * provide the 48 bit PPS timestamp.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_PPS_TIMESTAMP_UPPER_MASK UINT32_C(0xffff0)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA2_PPS_TIMESTAMP_UPPER_SFT 4
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Contains the lower 32 bits of the PPS timestamp. */
	uint32_t	event_data1;
	/* Contains the lower 32 bit PPS timestamp */
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA1_PPS_TIMESTAMP_LOWER_MASK UINT32_C(0xffffffff)
	#define HWRM_ASYNC_EVENT_CMPL_PPS_TIMESTAMP_EVENT_DATA1_PPS_TIMESTAMP_LOWER_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * Indicates the type of error being reported. See section on Error
	 * Report event error_types for details on each error.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_EVENT_DATA1_ERROR_TYPE_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_EVENT_DATA1_ERROR_TYPE_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_doorbell_pacing_threshold (size:128b/16B) */

struct hwrm_async_event_cmpl_doorbell_pacing_threshold {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the driver
	 * that the programmable pacing threshold for the doorbell FIFO is
	 * reached. The driver will take appropriate action to pace the
	 * doorbells when this async event is received from the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_EVENT_ID_DOORBELL_PACING_THRESHOLD UINT32_C(0x46)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_EVENT_ID_DOORBELL_PACING_THRESHOLD
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_THRESHOLD_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_rss_change (size:128b/16B) */

struct hwrm_async_event_cmpl_rss_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the driver
	 * that the RSS capabilities have changed. The driver will need
	 * to query hwrm_vnic_qcaps.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_EVENT_ID_RSS_CHANGE UINT32_C(0x47)
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_EVENT_ID_RSS_CHANGE
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_RSS_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_doorbell_pacing_nq_update (size:128b/16B) */

struct hwrm_async_event_cmpl_doorbell_pacing_nq_update {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * An event from firmware indicating that list of nq ids used for
	 * doorbell pacing DBQ event notification has been updated. The driver
	 * needs to take appropriate action and retrieve the new list when this
	 * event is received from the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_EVENT_ID_DOORBELL_PACING_NQ_UPDATE UINT32_C(0x48)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_EVENT_ID_DOORBELL_PACING_NQ_UPDATE
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DOORBELL_PACING_NQ_UPDATE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_hw_doorbell_recovery_read_error (size:128b/16B) */

struct hwrm_async_event_cmpl_hw_doorbell_recovery_read_error {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the driver
	 * that hardware ran into an error while trying to read the host
	 * based doorbell copy region. The driver will take the appropriate
	 * action to maintain the corresponding functions doorbell copy
	 * region in the correct format.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_ID_HW_DOORBELL_RECOVERY_READ_ERROR UINT32_C(0x49)
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_ID_LAST			HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_ID_HW_DOORBELL_RECOVERY_READ_ERROR
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * Indicates that there is an error while reading the doorbell copy
	 * regions.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_MASK	UINT32_C(0xf)
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_SFT	0
	/*
	 * If set to 1, indicates that there is an error while reading the
	 * SQ doorbell copy region for this function.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_SQ_ERR	UINT32_C(0x1)
	/*
	 * If set to 1, indicates that there is an error while reading the
	 * RQ doorbell copy region for this function.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_RQ_ERR	UINT32_C(0x2)
	/*
	 * If set to 1, indicates that there is an error while reading the
	 * SRQ doorbell copy region for this function.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_SRQ_ERR	UINT32_C(0x4)
	/*
	 * If set to 1, indicates that there is an error while reading the
	 * CQ doorbell copy region for this function.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HW_DOORBELL_RECOVERY_READ_ERROR_EVENT_DATA1_READ_ERROR_FLAGS_CQ_ERR	UINT32_C(0x8)
} __attribute__((packed));

/* hwrm_async_event_cmpl_ctx_error (size:128b/16B) */

struct hwrm_async_event_cmpl_ctx_error {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the PF driver
	 * that firmware fails to allocate/free the contexts requested. This
	 * message is only valid in the XID partition scheme. Given the start
	 * xid and the number of contexts in error, the PF driver will figure
	 * out the corresponding XID partition(s) in error.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_ID_CTX_ERROR UINT32_C(0x4a)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_ID_CTX_ERROR
	/* Event specific data */
	uint32_t	event_data2;
	/* Context operation code */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_CTX_OP_CODE	UINT32_C(0x1)
	/* Context alloc failure */
		#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_CTX_OP_CODE_ALLOC  UINT32_C(0x0)
	/* Context free failure */
		#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_CTX_OP_CODE_FREE   UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_CTX_OP_CODE_LAST  HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_CTX_OP_CODE_FREE
	/* Number of contexts in error */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_NUM_CTXS_MASK	UINT32_C(0xfffe)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_NUM_CTXS_SFT	1
	/* Function ID which the XID partitions are associated with */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_FID_MASK	UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA2_FID_SFT	16
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Starting XID that has error */
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA1_START_XID_MASK UINT32_C(0xffffffff)
	#define HWRM_ASYNC_EVENT_CMPL_CTX_ERROR_EVENT_DATA1_START_XID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_udcc_session_change (size:128b/16B) */

struct hwrm_async_event_udcc_session_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the PF driver
	 * that firmware has modified a UDCC session.
	 */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_ID_UDCC_SESSION_CHANGE UINT32_C(0x4b)
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_ID_UDCC_SESSION_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/* UDCC Session id operation code */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_MASK   UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_SFT	0
	/* session_id has been created */
		#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_CREATED  UINT32_C(0x0)
	/* session_id has been freed */
		#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_FREED	UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_LAST	HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA2_SESSION_ID_OP_CODE_FREED
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* UDCC session id which was modified */
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA1_UDCC_SESSION_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_UDCC_SESSION_CHANGE_EVENT_DATA1_UDCC_SESSION_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_representor_pair_change (size:128b/16B) */

struct hwrm_async_event_representor_pair_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the driver
	 * that firmware has modified a representor pair.
	 */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_ID_REPRESENTOR_PAIR_CHANGE UINT32_C(0x4e)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_ID_REPRESENTOR_PAIR_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/* Representor pair operation code */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_MASK   UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_SFT	0
	/* pair has been created */
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_CREATED  UINT32_C(0x0)
	/* pair has been deleted */
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_DELETED  UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_LAST	HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_PAIR_OP_CODE_DELETED
	/* DSCP insert operation code */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_MASK   UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_SFT	8
	/* allow dscp modification */
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_MODIFY   (UINT32_C(0x0) << 8)
	/* skip dscp modification */
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_IGNORE   (UINT32_C(0x1) << 8)
		#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_LAST	HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA2_DSCP_OP_CODE_IGNORE
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Representor endpoint fid which was modified */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA1_PAIR_EP_FID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA1_PAIR_EP_FID_SFT  0
	/* Representor uplink fid which was modified */
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA1_PAIR_REP_FID_MASK UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_REPRESENTOR_PAIR_CHANGE_EVENT_DATA1_PAIR_REP_FID_SFT 16
} __attribute__((packed));

/* hwrm_async_event_cmpl_dbg_buf_producer (size:128b/16B) */

struct hwrm_async_event_cmpl_dbg_buf_producer {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * Used to notify the host that the firmware has DMA-ed additional
	 * debug data to the host buffer. This is effectively a producer index
	 * update. The host driver can utilize this information to determine
	 * how much of its host buffer has been populated by the firmware.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_ID_DBG_BUF_PRODUCER UINT32_C(0x4c)
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_ID_DBG_BUF_PRODUCER
	/* Event specific data */
	uint32_t	event_data2;
	/*
	 * Specifies the current host buffer offset. Data up to this offset
	 * has been populated by the firmware. For example, if the firmware
	 * has DMA-ed 8192 bytes to the host buffer, then this field has a
	 * value of 8192. This field rolls over to zero once the firmware
	 * writes the last page of the host buffer
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA2_CURRENT_BUFFER_OFFSET_MASK UINT32_C(0xffffffff)
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA2_CURRENT_BUFFER_OFFSET_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Type of trace buffer that has been updated. */
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_MASK	UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_SFT		0
	/* SRT trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_SRT_TRACE	UINT32_C(0x0)
	/* SRT2 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_SRT2_TRACE	UINT32_C(0x1)
	/* CRT trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_CRT_TRACE	UINT32_C(0x2)
	/* CRT2 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_CRT2_TRACE	UINT32_C(0x3)
	/* RIGP0 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_RIGP0_TRACE	UINT32_C(0x4)
	/* L2 HWRM trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_L2_HWRM_TRACE	UINT32_C(0x5)
	/* RoCE HWRM trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_ROCE_HWRM_TRACE  UINT32_C(0x6)
	/* Context Accelerator CPU 0 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_CA0_TRACE	UINT32_C(0x7)
	/* Context Accelerator CPU 1 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_CA1_TRACE	UINT32_C(0x8)
	/* Context Accelerator CPU 2 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_CA2_TRACE	UINT32_C(0x9)
	/* RIGP1 trace. */
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_RIGP1_TRACE	UINT32_C(0xa)
		#define HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_DBG_BUF_PRODUCER_EVENT_DATA1_TYPE_RIGP1_TRACE
} __attribute__((packed));

/* hwrm_async_event_cmpl_peer_mmap_change (size:128b/16B) */

struct hwrm_async_event_cmpl_peer_mmap_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform the driver
	 * that the memory mapping for a peer device is set. The driver
	 * will need to query using get_structured_data.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_EVENT_ID_PEER_MMAP_CHANGE UINT32_C(0x4d)
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_EVENT_ID_LAST		HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_EVENT_ID_PEER_MMAP_CHANGE
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PEER_MMAP_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_fw_trace_msg (size:128b/16B) */

struct hwrm_async_event_cmpl_fw_trace_msg {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Firmware trace log message */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_ID_FW_TRACE_MSG UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_ID_FW_TRACE_MSG
	/* Trace byte 0 to 3 */
	uint32_t	event_data2;
	/* Trace byte0 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE0_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE0_SFT 0
	/* Trace byte1 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE1_MASK UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE1_SFT 8
	/* Trace byte2 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE2_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE2_SFT 16
	/* Trace byte3 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE3_MASK UINT32_C(0xff000000)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA2_BYTE3_SFT 24
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_OPAQUE_SFT 1
	/* Trace flags */
	uint8_t	timestamp_lo;
	/* Indicates if the string is partial or complete. */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_STRING		UINT32_C(0x1)
	/* Complete string */
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_STRING_COMPLETE	UINT32_C(0x0)
	/* Partial string */
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_STRING_PARTIAL	UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_STRING_LAST	HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_STRING_PARTIAL
	/* Indicates the firmware that sent the trace message. */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_FIRMWARE	UINT32_C(0x2)
	/* Primary firmware */
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_FIRMWARE_PRIMARY	(UINT32_C(0x0) << 1)
	/* Secondary firmware */
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_FIRMWARE_SECONDARY  (UINT32_C(0x1) << 1)
		#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_FIRMWARE_LAST	HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_LO_FIRMWARE_SECONDARY
	/* Trace byte 4 to 5 */
	uint16_t	timestamp_hi;
	/* Trace byte4 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_HI_BYTE4_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_HI_BYTE4_SFT 0
	/* Trace byte5 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_HI_BYTE5_MASK UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_TIMESTAMP_HI_BYTE5_SFT 8
	/* Trace byte 6 to 9 */
	uint32_t	event_data1;
	/* Trace byte6 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE6_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE6_SFT 0
	/* Trace byte7 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE7_MASK UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE7_SFT 8
	/* Trace byte8 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE8_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE8_SFT 16
	/* Trace byte9 */
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE9_MASK UINT32_C(0xff000000)
	#define HWRM_ASYNC_EVENT_CMPL_FW_TRACE_MSG_EVENT_DATA1_BYTE9_SFT 24
} __attribute__((packed));

/* hwrm_async_event_cmpl_hwrm_error (size:128b/16B) */

struct hwrm_async_event_cmpl_hwrm_error {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_HWRM_ERROR UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_HWRM_ERROR
	/* Event specific data */
	uint32_t	event_data2;
	/* Severity of HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_SFT	0
	/* Warning */
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_WARNING   UINT32_C(0x0)
	/* Non-fatal Error */
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_NONFATAL  UINT32_C(0x1)
	/* Fatal Error */
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL	UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_LAST	HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Time stamp for error event */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA1_TIMESTAMP	UINT32_C(0x1)
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_base (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_base {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_MASK			UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_SFT			0
	/* Reserved */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_RESERVED			UINT32_C(0x0)
	/*
	 * The NIC was subjected to an extended pause storm which caused it
	 * to disable flow control in order to avoid stalling the Tx path.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_PAUSE_STORM		UINT32_C(0x1)
	/*
	 * The NIC received an interrupt storm on a TSIO pin being used as
	 * PPS_IN which caused it to disable the interrupt. The signal
	 * should be fixed to be a proper 1 PPS signal before re-enabling
	 * it. The pin number on which this signal was received is stored
	 * in event_data2 as pin_id.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_INVALID_SIGNAL		UINT32_C(0x2)
	/*
	 * There was a low level error with an NVM write or erase.
	 * See nvm_err_type for more details.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_NVM			UINT32_C(0x3)
	/*
	 * This indicates doorbell drop threshold was hit. When this
	 * threshold is crossed, it indicates one or more doorbells for
	 * the function were dropped by hardware.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_DOORBELL_DROP_THRESHOLD	UINT32_C(0x4)
	/*
	 * Indicates the NIC's temperature has crossed one of the thermal
	 * thresholds.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_THERMAL_THRESHOLD		UINT32_C(0x5)
	/*
	 * Speed change not supported with dual rate transceivers
	 * on this board.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_DUAL_DATA_RATE_NOT_SUPPORTED  UINT32_C(0x6)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_LAST			HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_BASE_EVENT_DATA1_ERROR_TYPE_DUAL_DATA_RATE_NOT_SUPPORTED
} __attribute__((packed));

#define GET_ERROR_REPORT_TYPE(x) \
	(((x) < 0x80) ? \
	((x) == 0x0 ? "RESERVED": \
	((x) == 0x1 ? "PAUSE_STORM": \
	((x) == 0x2 ? "INVALID_SIGNAL": \
	((x) == 0x3 ? "NVM": \
	((x) == 0x4 ? "DOORBELL_DROP_THRESHOLD": \
	((x) == 0x5 ? "THERMAL_THRESHOLD": \
	((x) == 0x6 ? "DUAL_DATA_RATE_NOT_SUPPORTED": \
	"Unknown decode" ))))))) : \
	"Unknown decode" )


/* hwrm_async_event_cmpl_error_report_pause_storm (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_pause_storm {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_DATA1_ERROR_TYPE_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_DATA1_ERROR_TYPE_SFT	0
	/*
	 * The NIC was subjected to an extended pause storm which caused it
	 * to disable flow control in order to avoid stalling the Tx path.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_DATA1_ERROR_TYPE_PAUSE_STORM  UINT32_C(0x1)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_DATA1_ERROR_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_PAUSE_STORM_EVENT_DATA1_ERROR_TYPE_PAUSE_STORM
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_invalid_signal (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_invalid_signal {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	/* Indicates the TSIO pin on which invalid signal is detected. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA2_PIN_ID_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA2_PIN_ID_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA1_ERROR_TYPE_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA1_ERROR_TYPE_SFT	0
	/*
	 * The NIC received an interrupt storm on a TSIO pin being used as
	 * PPS_IN which caused it to disable the interrupt. The signal
	 * should be fixed to be a proper 1 PPS signal before re-enabling
	 * it. The pin number on which this signal was received is stored
	 * in event_data2 as pin_id.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA1_ERROR_TYPE_INVALID_SIGNAL  UINT32_C(0x2)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA1_ERROR_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_INVALID_SIGNAL_EVENT_DATA1_ERROR_TYPE_INVALID_SIGNAL
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_nvm (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_nvm {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	/* Indicates the address where error was detected */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA2_ERR_ADDR_MASK UINT32_C(0xffffffff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA2_ERR_ADDR_SFT 0
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_ERROR_TYPE_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_ERROR_TYPE_SFT	0
	/*
	 * There was a low level error with an NVM operation.
	 * See nvm_err_type for more details.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_ERROR_TYPE_NVM_ERROR  UINT32_C(0x3)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_ERROR_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_ERROR_TYPE_NVM_ERROR
	/* The specific type of NVM error */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_MASK   UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_SFT	8
	/*
	 * There was a low level error with an NVM write operation.
	 * Verification of written data did not match.
	 * event_data2 will be the failing address.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_WRITE	(UINT32_C(0x1) << 8)
	/*
	 * There was a low level error with an NVM erase operation.
	 * All the bits were not erased.
	 * event_data2 will be the failing address.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_ERASE	(UINT32_C(0x2) << 8)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_NVM_EVENT_DATA1_NVM_ERR_TYPE_ERASE
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_doorbell_drop_threshold (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_doorbell_drop_threshold {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_ERROR_TYPE_MASK		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_ERROR_TYPE_SFT			0
	/*
	 * This indicates doorbell drop threshold was hit. When this
	 * threshold is crossed, it indicates one or more doorbells for
	 * the function were dropped by hardware.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_ERROR_TYPE_DOORBELL_DROP_THRESHOLD  UINT32_C(0x4)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_ERROR_TYPE_LAST			HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_ERROR_TYPE_DOORBELL_DROP_THRESHOLD
	/*
	 * The epoch value to be sent from firmware to the driver to track
	 * a doorbell recovery cycle.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_EPOCH_MASK			UINT32_C(0xffffff00)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DOORBELL_DROP_THRESHOLD_EVENT_DATA1_EPOCH_SFT			8
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_thermal (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_thermal {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	/* Current temperature. In Celsius */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA2_CURRENT_TEMP_MASK  UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA2_CURRENT_TEMP_SFT   0
	/*
	 * The temperature setting of the threshold that was just crossed.
	 * In Celsius
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA2_THRESHOLD_TEMP_MASK UINT32_C(0xff00)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA2_THRESHOLD_TEMP_SFT 8
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_ERROR_TYPE_MASK	UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_ERROR_TYPE_SFT	0
	/*
	 * There was thermal event. The type will be specified in the
	 * field threshold_type. event_data2 will contain the current
	 * temperature and the configured value for the threshold that
	 * was just crossed. The threshold values are lower thresholds,
	 * so the event will trigger with an active flag when the
	 * temperature is on an increasing trajectory.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_ERROR_TYPE_THERMAL_EVENT   UINT32_C(0x5)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_ERROR_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_ERROR_TYPE_THERMAL_EVENT
	/* The specific type of thermal threshold error */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_MASK	UINT32_C(0x700)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_SFT	8
	/* Warning thermal threshold was crossed */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_WARN	(UINT32_C(0x0) << 8)
	/* Critical thermal threshold was crossed */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_CRITICAL	(UINT32_C(0x1) << 8)
	/* Fatal thermal threshold was crossed */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_FATAL	(UINT32_C(0x2) << 8)
	/*
	 * Thermal shutdown threshold was crossed and a shutdown is
	 * imminent. This event will not occur if self shutdown
	 * is disabled.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_SHUTDOWN	(UINT32_C(0x3) << 8)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_THRESHOLD_TYPE_SHUTDOWN
	/*
	 * Indicates if the thermal crossing occurs while the temperature is
	 * increasing or decreasing.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_TRANSITION_DIR	UINT32_C(0x800)
	/* Threshold is crossed while the temperature is falling. */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_TRANSITION_DIR_DECREASING  (UINT32_C(0x0) << 11)
	/* Threshold is crossed while the temperature is rising. */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_TRANSITION_DIR_INCREASING  (UINT32_C(0x1) << 11)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_TRANSITION_DIR_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_THERMAL_EVENT_DATA1_TRANSITION_DIR_INCREASING
} __attribute__((packed));

/* hwrm_async_event_cmpl_error_report_dual_data_rate_not_supported (size:128b/16B) */

struct hwrm_async_event_cmpl_error_report_dual_data_rate_not_supported {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * This async notification message is used to inform
	 * the driver that an error has occurred which may need
	 * the attention of the administrator.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_ID_ERROR_REPORT UINT32_C(0x45)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_ID_ERROR_REPORT
	/* Event specific data. */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates the type of error being reported. */
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_DATA1_ERROR_TYPE_MASK			UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_DATA1_ERROR_TYPE_SFT			0
	/*
	 * Speed change not supported with dual rate transceivers
	 * on this board.
	 */
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_DATA1_ERROR_TYPE_DUAL_DATA_RATE_NOT_SUPPORTED  UINT32_C(0x6)
		#define HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_DATA1_ERROR_TYPE_LAST			HWRM_ASYNC_EVENT_CMPL_ERROR_REPORT_DUAL_DATA_RATE_NOT_SUPPORTED_EVENT_DATA1_ERROR_TYPE_DUAL_DATA_RATE_NOT_SUPPORTED
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_stat_change (size:128b/16B) */

struct hwrm_async_event_cmpl_vf_stat_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * VF statistics context change. Informs PF driver that a VF
	 * statistics context has either been allocated or freed.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_ID_VF_STAT_CHANGE UINT32_C(0x4f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_ID_VF_STAT_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/*
	 * VF ID that allocated the stats context. This is zero-based and
	 * relative to each PF.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA2_VF_ID_MASK		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA2_VF_ID_SFT		0
	/*
	 * A value of zero signals to the PF driver that it can free the host
	 * buffer associated with the statistics context.
	 * A non-zero values signals to the PF driver that it should allocate
	 * a host buffer for the statistics context and inform the firmware
	 * via HWRM_STAT_CTX_ALLOC. The PF driver must provide the sequence id
	 * in the corresponding HWRM_STAT_CTX_ALLOC request so that firmware
	 * can correlate it to the VF statistics context.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA2_ACTION_SEQUENCE_ID_MASK UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA2_ACTION_SEQUENCE_ID_SFT 16
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* VF statistics context identifier */
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA1_STAT_CTX_ID_MASK UINT32_C(0xffffffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_STAT_CHANGE_EVENT_DATA1_STAT_CTX_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_host_coredump (size:128b/16B) */

struct hwrm_async_event_cmpl_host_coredump {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units. Even values indicate 16B
	 * records. Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
		#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
		#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_TYPE_LAST		HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/*
	 * coredump collection into host DMA address. Informs PF driver that
	 * the coredump has been captured.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_EVENT_ID_HOST_COREDUMP UINT32_C(0x50)
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_EVENT_ID_LAST	HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_EVENT_ID_HOST_COREDUMP
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue. The even passes
	 * will write 1. The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HOST_COREDUMP_OPAQUE_SFT 1
	/* 8-lsb timestamp (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* metadata_base_msg (size:64b/8B) */

struct metadata_base_msg {
	uint16_t	md_type_link;
	/* This field classifies the data present in the meta-data. */
	#define METADATA_BASE_MSG_MD_TYPE_MASK	UINT32_C(0x1f)
	#define METADATA_BASE_MSG_MD_TYPE_SFT	0
	/* Meta data fields are not valid */
		#define METADATA_BASE_MSG_MD_TYPE_NONE	UINT32_C(0x0)
	/*
	 * This setting is used when packets are coming in-order. Depending on
	 * the state of the receive context, the meta-data will carry
	 * different information.
	 */
		#define METADATA_BASE_MSG_MD_TYPE_TLS_INSYNC  UINT32_C(0x1)
	/*
	 * With this setting HW passes the TCP sequence number of the TLS
	 * record that it is requesting a resync on in the meta data.
	 */
		#define METADATA_BASE_MSG_MD_TYPE_TLS_RESYNC  UINT32_C(0x2)
	/* This setting is used for QUIC packets. */
		#define METADATA_BASE_MSG_MD_TYPE_QUIC	UINT32_C(0x3)
	/*
	 * This setting is used for crypto packets with an unsupported
	 * protocol.
	 */
		#define METADATA_BASE_MSG_MD_TYPE_ILLEGAL	UINT32_C(0x1f)
		#define METADATA_BASE_MSG_MD_TYPE_LAST	METADATA_BASE_MSG_MD_TYPE_ILLEGAL
	/*
	 * This field indicates where the next metadata block starts, relative
	 * to the current metadata block. It is the offset to the next metadata
	 * header, counted in 16B units. A value of zero indicates that there is
	 * no additional metadata, and that the current metadata block is the
	 * last one.
	 */
	#define METADATA_BASE_MSG_LINK_MASK	UINT32_C(0x1e0)
	#define METADATA_BASE_MSG_LINK_SFT	5
	uint16_t	unused0;
	uint32_t	unused1;
} __attribute__((packed));

/* tls_metadata_base_msg (size:64b/8B) */

struct tls_metadata_base_msg {
	uint32_t	md_type_link_flags_kid_lo;
	/* This field classifies the data present in the meta-data. */
	#define TLS_METADATA_BASE_MSG_MD_TYPE_MASK				UINT32_C(0x1f)
	#define TLS_METADATA_BASE_MSG_MD_TYPE_SFT				0
	/*
	 * This setting is used when packets are coming in-order. Depending
	 * on the state of the receive context, the meta-data will carry
	 * different information.
	 */
		#define TLS_METADATA_BASE_MSG_MD_TYPE_TLS_INSYNC				UINT32_C(0x1)
	/*
	 * With this setting HW passes the TCP sequence number of the TLS
	 * record that it is requesting a resync on in the meta data.
	 */
		#define TLS_METADATA_BASE_MSG_MD_TYPE_TLS_RESYNC				UINT32_C(0x2)
		#define TLS_METADATA_BASE_MSG_MD_TYPE_LAST				TLS_METADATA_BASE_MSG_MD_TYPE_TLS_RESYNC
	/*
	 * This field indicates where the next metadata block starts. It is
	 * counted in 16B units. A value of zero indicates that there is no
	 * metadata.
	 */
	#define TLS_METADATA_BASE_MSG_LINK_MASK					UINT32_C(0x1e0)
	#define TLS_METADATA_BASE_MSG_LINK_SFT					5
	/* These are flags present in the metadata. */
	#define TLS_METADATA_BASE_MSG_FLAGS_MASK				UINT32_C(0x1fffe00)
	#define TLS_METADATA_BASE_MSG_FLAGS_SFT					9
	/*
	 * A value of 1 implies that the packet was decrypted by HW. Otherwise
	 * the packet is passed on as it came in on the wire.
	 */
	#define TLS_METADATA_BASE_MSG_FLAGS_DECRYPTED				UINT32_C(0x200)
	/*
	 * This field indicates the state of the ghash field passed in the
	 * meta-data.
	 */
	#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_MASK				UINT32_C(0xc00)
	#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_SFT				10
	/*
	 * This enumeration states that the ghash is not valid in the
	 * meta-data.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_NOT_VALID			(UINT32_C(0x0) << 10)
	/*
	 * This enumeration indicates that this pkt contains the record's
	 * tag and this pkt was received ooo, the partial_ghash field
	 * contains the ghash.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_CUR_REC				(UINT32_C(0x1) << 10)
	/*
	 * This enumeration indicates that the current record's tag wasn't
	 * seen and the chip is moving on to the next record, the
	 * partial_ghash field contains the ghash.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_PRIOR_REC			(UINT32_C(0x2) << 10)
		#define TLS_METADATA_BASE_MSG_FLAGS_GHASH_LAST				TLS_METADATA_BASE_MSG_FLAGS_GHASH_PRIOR_REC
	/* This field indicates the status of tag authentication. */
	#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_MASK			UINT32_C(0x3000)
	#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_SFT			12
	/*
	 * This enumeration is set when HW was not able to authenticate a
	 * TAG.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_NOT_CHECKED		(UINT32_C(0x0) << 12)
	/*
	 * This enumeration states that there is at least one tag in the
	 * packet and every tag is valid.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_SUCCESS		(UINT32_C(0x1) << 12)
	/*
	 * This enumeration states that there is at least one tag in the
	 * packet and at least one of the tag is invalid. The entire packet
	 * is sent decrypted to the host.
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_FAILURE		(UINT32_C(0x2) << 12)
		#define TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_LAST			TLS_METADATA_BASE_MSG_FLAGS_TAG_AUTH_STATUS_FAILURE
	/*
	 * A value of 1 indicates that this packet contains a record that
	 * starts in the packet and extends beyond the packet.
	 */
	#define TLS_METADATA_BASE_MSG_FLAGS_HEADER_FLDS_VALID			UINT32_C(0x4000)
	/*
	 * A value of 1 indicates that the packet experienced a context load
	 * error. In this case, the packet is sent to the host without the
	 * header or payload decrypted and the context is not updated.
	 */
	#define TLS_METADATA_BASE_MSG_FLAGS_CTX_LOAD_ERR				UINT32_C(0x8000)
	/* This field indicates the packet operation state. */
	#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_MASK		UINT32_C(0x70000)
	#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_SFT		16
	/* Packet is in order. */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_IN_ORDER		(UINT32_C(0x0) << 16)
	/* Packet is out of order, no header loss. */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_OUT_OF_ORDER	(UINT32_C(0x1) << 16)
	/* Packet is header search (out of order with header loss). */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_HEADER_SEARCH	(UINT32_C(0x2) << 16)
	/* Packet is resync (resync record ongoing). */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC		(UINT32_C(0x3) << 16)
	/*
	 * Packet is resync wait (resync record completes, waiting for
	 * result).
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT	(UINT32_C(0x4) << 16)
	/*
	 * Packet is resync wait for partial tag (waiting for resync record
	 * tag).
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT_PARTIAL   (UINT32_C(0x5) << 16)
	/* Packet is resync success (got resync record success). */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS	(UINT32_C(0x6) << 16)
	/*
	 * Packet is resync success wait (got midpath ACK, waiting for
	 * resync record success).
	 */
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT   (UINT32_C(0x7) << 16)
		#define TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_LAST		TLS_METADATA_BASE_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT
	/*
	 * This value indicates the lower 7-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_BASE_MSG_KID_LO_MASK				UINT32_C(0xfe000000)
	#define TLS_METADATA_BASE_MSG_KID_LO_SFT				25
	uint16_t	kid_hi;
	/*
	 * This value indicates the upper 13-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_BASE_MSG_KID_HI_MASK UINT32_C(0x1fff)
	#define TLS_METADATA_BASE_MSG_KID_HI_SFT 0
	uint16_t	unused0;
} __attribute__((packed));

/* tls_metadata_insync_msg (size:192b/24B) */

struct tls_metadata_insync_msg {
	uint32_t	md_type_link_flags_kid_lo;
	/* This field classifies the data present in the meta-data. */
	#define TLS_METADATA_INSYNC_MSG_MD_TYPE_MASK				UINT32_C(0x1f)
	#define TLS_METADATA_INSYNC_MSG_MD_TYPE_SFT				0
	/*
	 * This setting is used when packets are coming in-order. Depending on
	 * the state of the receive context, the meta-data will carry
	 * different information.
	 */
		#define TLS_METADATA_INSYNC_MSG_MD_TYPE_TLS_INSYNC				UINT32_C(0x1)
		#define TLS_METADATA_INSYNC_MSG_MD_TYPE_LAST				TLS_METADATA_INSYNC_MSG_MD_TYPE_TLS_INSYNC
	/*
	 * This field indicates where the next metadata block starts. It is
	 * counted in 16B units. A value of zero indicates that there is no
	 * metadata.
	 */
	#define TLS_METADATA_INSYNC_MSG_LINK_MASK					UINT32_C(0x1e0)
	#define TLS_METADATA_INSYNC_MSG_LINK_SFT					5
	/* These are flags present in the metadata. */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_MASK				UINT32_C(0x1fffe00)
	#define TLS_METADATA_INSYNC_MSG_FLAGS_SFT					9
	/*
	 * A value of 1 implies that the packet was decrypted by HW. Otherwise
	 * the packet is passed on as it came in on the wire.
	 */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_DECRYPTED				UINT32_C(0x200)
	/*
	 * This field indicates the state of the ghash field passed in the
	 * meta-data.
	 */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_MASK				UINT32_C(0xc00)
	#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_SFT				10
	/*
	 * This enumeration states that the ghash is not valid in the
	 * meta-data.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_NOT_VALID			(UINT32_C(0x0) << 10)
	/*
	 * This enumeration indicates that this pkt contains the record's
	 * tag and this pkt was received ooo, the partial_ghash field
	 * contains the ghash.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_CUR_REC				(UINT32_C(0x1) << 10)
	/*
	 * This enumeration indicates that the current record's tag wasn't
	 * seen and the chip is moving on to the next record, the
	 * partial_ghash field contains the ghash.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_PRIOR_REC			(UINT32_C(0x2) << 10)
		#define TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_LAST				TLS_METADATA_INSYNC_MSG_FLAGS_GHASH_PRIOR_REC
	/* This field indicates the status of tag authentication. */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_MASK			UINT32_C(0x3000)
	#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_SFT			12
	/*
	 * This enumeration is set when HW was not able to authenticate a
	 * TAG.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_NOT_CHECKED		(UINT32_C(0x0) << 12)
	/*
	 * This enumeration states that there is at least one tag in the
	 * packet and every tag is valid.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_SUCCESS		(UINT32_C(0x1) << 12)
	/*
	 * This enumeration states that there is at least one tag in the
	 * packet and at least one of the tag is invalid. The entire packet
	 * is sent decrypted to the host.
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_FAILURE		(UINT32_C(0x2) << 12)
		#define TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_LAST			TLS_METADATA_INSYNC_MSG_FLAGS_TAG_AUTH_STATUS_FAILURE
	/*
	 * A value of 1 indicates that this packet contains a record that
	 * starts in the packet and extends beyond the packet.
	 */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_HEADER_FLDS_VALID			UINT32_C(0x4000)
	/*
	 * A value of 1 indicates that the packet experienced a context load
	 * error. In this case, the packet is sent to the host without the
	 * header or payload decrypted and the context is not updated.
	 */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_CTX_LOAD_ERR				UINT32_C(0x8000)
	/* This field indicates the packet operation state. */
	#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_MASK		UINT32_C(0x70000)
	#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_SFT		16
	/* Packet is in order. */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_IN_ORDER		(UINT32_C(0x0) << 16)
	/* Packet is out of order, no header loss. */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_OUT_OF_ORDER	(UINT32_C(0x1) << 16)
	/* Packet is header search (out of order with header loss). */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_HEADER_SEARCH	(UINT32_C(0x2) << 16)
	/* Packet is resync (resync record ongoing). */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC		(UINT32_C(0x3) << 16)
	/*
	 * Packet is resync wait (resync record completes, waiting for
	 * result).
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT	(UINT32_C(0x4) << 16)
	/*
	 * Packet is resync wait for partial tag (waiting for resync record
	 * tag).
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT_PARTIAL   (UINT32_C(0x5) << 16)
	/* Packet is resync success (got resync record success). */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS	(UINT32_C(0x6) << 16)
	/*
	 * Packet is resync success wait (got midpath ACK, waiting for
	 * resync record success).
	 */
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT   (UINT32_C(0x7) << 16)
		#define TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_LAST		TLS_METADATA_INSYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT
	/*
	 * This value indicates the lower 7-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_INSYNC_MSG_KID_LO_MASK				UINT32_C(0xfe000000)
	#define TLS_METADATA_INSYNC_MSG_KID_LO_SFT				25
	uint16_t	kid_hi;
	/*
	 * This value indicates the upper 13-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_INSYNC_MSG_KID_HI_MASK UINT32_C(0x1fff)
	#define TLS_METADATA_INSYNC_MSG_KID_HI_SFT 0
	/*
	 * This field is only valid when md_type is set to tls_insync. This
	 * field indicates the offset within the current TCP packet where the
	 * TLS header starts. If there are multiple TLS headers in the packet,
	 * this provides the offset of the last TLS header.
	 *
	 * The field is calculated by subtracting TCP sequence number of the
	 * first byte of the TCP payload of the packet from the TCP sequence
	 * number of the last TLS header in the packet.
	 */
	uint16_t	tls_header_offset;
	/*
	 * This is the sequence Number of the record that was processed by the HW.
	 * If there are multiple records in a packet, this would be the sequence
	 * number of the last record.
	 */
	uint64_t	record_seq_num;
	/*
	 * This field contains cumulative partial GHASH value of all the packets
	 * decrypted by the HW associated with a TLS record. This field is valid
	 * on when packets belonging to have arrived out-of-order and HW could
	 * not decrypt every packet and authenticate the record. Partial GHASH is
	 * only sent out with packet having the TAG field.
	 */
	uint8_t	partial_ghash[8];
} __attribute__((packed));

/* tls_metadata_resync_msg (size:256b/32B) */

struct tls_metadata_resync_msg {
	uint32_t	md_type_link_flags_kid_lo;
	/* This field classifies the data present in the meta-data. */
	#define TLS_METADATA_RESYNC_MSG_MD_TYPE_MASK				UINT32_C(0x1f)
	#define TLS_METADATA_RESYNC_MSG_MD_TYPE_SFT				0
	/*
	 * With this setting HW passes the TCP sequence number of the TLS
	 * record that it is requesting a resync on in the meta data.
	 */
		#define TLS_METADATA_RESYNC_MSG_MD_TYPE_TLS_RESYNC				UINT32_C(0x2)
		#define TLS_METADATA_RESYNC_MSG_MD_TYPE_LAST				TLS_METADATA_RESYNC_MSG_MD_TYPE_TLS_RESYNC
	/*
	 * This field indicates where the next metadata block starts. It is
	 * counted in 16B units. A value of zero indicates that there is no
	 * metadata.
	 */
	#define TLS_METADATA_RESYNC_MSG_LINK_MASK					UINT32_C(0x1e0)
	#define TLS_METADATA_RESYNC_MSG_LINK_SFT					5
	/* These are flags present in the metadata. */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_MASK				UINT32_C(0x1fffe00)
	#define TLS_METADATA_RESYNC_MSG_FLAGS_SFT					9
	/*
	 * A value of 1 implies that the packet was decrypted by HW. Otherwise
	 * the packet is passed on as it came in on the wire.
	 */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_DECRYPTED				UINT32_C(0x200)
	/*
	 * This field indicates the state of the ghash field passed in the
	 * meta-data.
	 */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_GHASH_MASK				UINT32_C(0xc00)
	#define TLS_METADATA_RESYNC_MSG_FLAGS_GHASH_SFT				10
	/*
	 * This enumeration states that the ghash is not valid in the
	 * meta-data.
	 */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_GHASH_NOT_VALID			(UINT32_C(0x0) << 10)
		#define TLS_METADATA_RESYNC_MSG_FLAGS_GHASH_LAST				TLS_METADATA_RESYNC_MSG_FLAGS_GHASH_NOT_VALID
	/* This field indicates the status of tag authentication. */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_TAG_AUTH_STATUS_MASK			UINT32_C(0x3000)
	#define TLS_METADATA_RESYNC_MSG_FLAGS_TAG_AUTH_STATUS_SFT			12
	/*
	 * This enumeration is set when HW was not able to authenticate a
	 * TAG.
	 */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_TAG_AUTH_STATUS_NOT_CHECKED		(UINT32_C(0x0) << 12)
		#define TLS_METADATA_RESYNC_MSG_FLAGS_TAG_AUTH_STATUS_LAST			TLS_METADATA_RESYNC_MSG_FLAGS_TAG_AUTH_STATUS_NOT_CHECKED
	/*
	 * A value of 1 indicates that this packet contains a record that
	 * starts in the packet and extends beyond the packet.
	 */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_HEADER_FLDS_VALID			UINT32_C(0x4000)
	/*
	 * A value of 1 indicates that the packet experienced a context load
	 * error. In this case, the packet is sent to the host without the
	 * header or payload decrypted and the context is not updated.
	 */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_CTX_LOAD_ERR				UINT32_C(0x8000)
	/* This field indicates the packet operation state. */
	#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_MASK		UINT32_C(0x70000)
	#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_SFT		16
	/* Packet is in order. */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_IN_ORDER		(UINT32_C(0x0) << 16)
	/* Packet is out of order, no header loss. */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_OUT_OF_ORDER	(UINT32_C(0x1) << 16)
	/* Packet is header search (out of order with header loss). */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_HEADER_SEARCH	(UINT32_C(0x2) << 16)
	/* Packet is resync (resync record ongoing). */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC		(UINT32_C(0x3) << 16)
	/*
	 * Packet is resync wait (resync record completes, waiting for
	 * result).
	 */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT	(UINT32_C(0x4) << 16)
	/*
	 * Packet is resync wait for partial tag (waiting for resync record
	 * tag).
	 */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_WAIT_PARTIAL   (UINT32_C(0x5) << 16)
	/* Packet is resync success (got resync record success). */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS	(UINT32_C(0x6) << 16)
	/*
	 * Packet is resync success wait (got midpath ACK, waiting for
	 * resync record success).
	 */
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT   (UINT32_C(0x7) << 16)
		#define TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_LAST		TLS_METADATA_RESYNC_MSG_FLAGS_PKT_OPERATION_STATE_RESYNC_SUCCESS_WAIT
	/*
	 * This value indicates the lower 7-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_RESYNC_MSG_KID_LO_MASK				UINT32_C(0xfe000000)
	#define TLS_METADATA_RESYNC_MSG_KID_LO_SFT				25
	uint16_t	kid_hi;
	/*
	 * This value indicates the upper 13-bit of the Crypto Key ID
	 * associated with this operation.
	 */
	#define TLS_METADATA_RESYNC_MSG_KID_HI_MASK UINT32_C(0x1fff)
	#define TLS_METADATA_RESYNC_MSG_KID_HI_SFT 0
	/* This field is unused in this context. */
	uint16_t	metadata_0;
	/*
	 * This field indicates the TCP sequence number of the TLS record that HW
	 * is requesting a resync on from the Driver. HW will keep a count of the
	 * TLS records it found after this record (delta_records). Driver will
	 * provide the TLS Record Sequence Number associated with the record. HW
	 * will add the delta_records to the Record Sequence Number provided by
	 * the driver and get back on sync.
	 */
	uint32_t	resync_record_tcp_seq_num;
	uint32_t	unused0;
	/* This field is unused in this context. */
	uint64_t	metadata_2;
	/* This field is unused in this context. */
	uint64_t	metadata_3;
} __attribute__((packed));

/* tx_doorbell (size:32b/4B) */

struct tx_doorbell {
	uint32_t	key_idx;
	/*
	 * BD Index of next BD that will be used to transmit data
	 * on the TX ring mapped to this door bell. NIC may
	 * read and process all BDs up to, but not including this
	 * index.
	 */
	#define TX_DOORBELL_IDX_MASK UINT32_C(0xffffff)
	#define TX_DOORBELL_IDX_SFT 0
	/*
	 * This value indicates the type of door bell operation
	 * that is begin requested. This value is '0' for TX
	 * door bell operations.
	 */
	#define TX_DOORBELL_KEY_MASK UINT32_C(0xf0000000)
	#define TX_DOORBELL_KEY_SFT 28
	/* TX Operation */
		#define TX_DOORBELL_KEY_TX	(UINT32_C(0x0) << 28)
		#define TX_DOORBELL_KEY_LAST TX_DOORBELL_KEY_TX
} __attribute__((packed));

/* rx_doorbell (size:32b/4B) */

struct rx_doorbell {
	uint32_t	key_idx;
	/*
	 * BD Index of next BD that will be used for an empty receive
	 * buffer on the RX ring mapped to this door bell. NIC may
	 * read and process all BDs up to, but not including this
	 * index.
	 */
	#define RX_DOORBELL_IDX_MASK UINT32_C(0xffffff)
	#define RX_DOORBELL_IDX_SFT 0
	/*
	 * This value indicates the type of door bell operation
	 * that is begin requested. This value is '1' for RX
	 * door bell operations.
	 */
	#define RX_DOORBELL_KEY_MASK UINT32_C(0xf0000000)
	#define RX_DOORBELL_KEY_SFT 28
	/* RX Operation */
		#define RX_DOORBELL_KEY_RX	(UINT32_C(0x1) << 28)
		#define RX_DOORBELL_KEY_LAST RX_DOORBELL_KEY_RX
} __attribute__((packed));

/* cmpl_doorbell (size:32b/4B) */

struct cmpl_doorbell {
	uint32_t	key_mask_valid_idx;
	/*
	 * BD Index of the most recently handed completion record
	 * on the completion ring mapped to this door bell.
	 * NIC may
	 * write this location again with a new completion.
	 */
	#define CMPL_DOORBELL_IDX_MASK	UINT32_C(0xffffff)
	#define CMPL_DOORBELL_IDX_SFT	0
	/*
	 * This indicates if the BDIDX value is valid for this
	 * update when it is '1'. When it is '0', the BDIDX
	 * value should be ignored.
	 */
	#define CMPL_DOORBELL_IDX_VALID	UINT32_C(0x4000000)
	/*
	 * This bit indicates the new interrupt mask state for the
	 * interrupt associated with the BDIDX. A '1', means the
	 * interrupt is to be masked. A '0' indicates the interrupt
	 * is to be unmasked.
	 */
	#define CMPL_DOORBELL_MASK	UINT32_C(0x8000000)
	/*
	 * This value indicates the type of door bell operation
	 * that is begin requested. This value is '2' for CMP
	 * door bell operations.
	 */
	#define CMPL_DOORBELL_KEY_MASK	UINT32_C(0xf0000000)
	#define CMPL_DOORBELL_KEY_SFT	28
	/* Completion Operation */
		#define CMPL_DOORBELL_KEY_CMPL	(UINT32_C(0x2) << 28)
		#define CMPL_DOORBELL_KEY_LAST	CMPL_DOORBELL_KEY_CMPL
} __attribute__((packed));

/* status_doorbell (size:32b/4B) */

struct status_doorbell {
	uint32_t	key_idx;
	/*
	 * BD Index of the status record for which space is now
	 * available to the NIC.
	 */
	/*
	 * While there is no actual BD associated with the index,
	 * the similar scheme is being used to communicate to
	 * the NIC that space is available for status completions.
	 */
	#define STATUS_DOORBELL_IDX_MASK UINT32_C(0xffffff)
	#define STATUS_DOORBELL_IDX_SFT 0
	/*
	 * This value indicates the type of door bell operation
	 * that is begin requested. This value is '3' for Status
	 * door bell operations.
	 */
	#define STATUS_DOORBELL_KEY_MASK UINT32_C(0xf0000000)
	#define STATUS_DOORBELL_KEY_SFT 28
	/* Status Operation */
		#define STATUS_DOORBELL_KEY_STAT  (UINT32_C(0x3) << 28)
		#define STATUS_DOORBELL_KEY_LAST STATUS_DOORBELL_KEY_STAT
} __attribute__((packed));

/* push32_doorbell (size:1024b/128B) */

struct push32_doorbell {
	uint32_t	key_sz_idx;
	/*
	 * This is the BD Index of last BD of the push packet
	 * that will be used to transmit data on the TX ring mapped
	 * to this door bell.
	 */
	#define PUSH32_DOORBELL_IDX_MASK UINT32_C(0xffffff)
	#define PUSH32_DOORBELL_IDX_SFT 0
	/*
	 * This is the number of 16B BDs spaces consumed in the TX
	 * Ring by the "backup" version of the packet being pushed.
	 * A value of 1 is invalid since backup must start with a
	 * long 32B BE.
	 * A value of 2 indicates just the first 32B BE.
	 * A value of 3 indicates 32B+16B BD. etc.
	 * A value of 0 indicates 16x16B BD spaces are consumed.
	 */
	#define PUSH32_DOORBELL_SZ_MASK UINT32_C(0xf000000)
	#define PUSH32_DOORBELL_SZ_SFT  24
	/*
	 * This value indicates the type of door bell operation
	 * that is begin requested. This value is 4 for push
	 * door bell operations.
	 */
	#define PUSH32_DOORBELL_KEY_MASK UINT32_C(0xf0000000)
	#define PUSH32_DOORBELL_KEY_SFT 28
	/* Push Operation */
		#define PUSH32_DOORBELL_KEY_PUSH  (UINT32_C(0x4) << 28)
		#define PUSH32_DOORBELL_KEY_LAST PUSH32_DOORBELL_KEY_PUSH
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define PUSH32_DOORBELL_TYPE_MASK		UINT32_C(0x3f)
	#define PUSH32_DOORBELL_TYPE_SFT		0
	/*
	 * Indicates that this BD is 32B long and is used for
	 * normal L2 packet transmission.
	 */
		#define PUSH32_DOORBELL_TYPE_TX_BD_LONG	UINT32_C(0x10)
		#define PUSH32_DOORBELL_TYPE_LAST		PUSH32_DOORBELL_TYPE_TX_BD_LONG
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_MASK	UINT32_C(0xffc0)
	#define PUSH32_DOORBELL_FLAGS_SFT		6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor. This flag must be
	 * valid on every BD.
	 *
	 *	This bit must be set on all push doorbells.
	 */
	#define PUSH32_DOORBELL_FLAGS_PACKET_END	UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in it's
	 * processing.
	 * If this bit
	 * is set to 0, then the packet will be completed normally.
	 *
	 * This bit must be valid only on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_NO_CMPL	UINT32_C(0x80)
	/*
	 * This value must match the sz field in the first
	 * 32b of the push operation except that if
	 * 16x16B BD locations
	 * are consumed in the ring by this packet, then
	 * this value must be 16 (not zero).
	 */
	#define PUSH32_DOORBELL_FLAGS_BD_CNT_MASK	UINT32_C(0x1f00)
	#define PUSH32_DOORBELL_FLAGS_BD_CNT_SFT	8
	/*
	 * This value is a hint for the length of the entire packet.
	 * It is used by the chip to optimize internal processing.
	 *
	 * The packet will be dropped if the hint is too short.
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_LHINT_MASK	UINT32_C(0x6000)
	#define PUSH32_DOORBELL_FLAGS_LHINT_SFT	13
	/* indicates packet length < 512B */
		#define PUSH32_DOORBELL_FLAGS_LHINT_LT512	(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
		#define PUSH32_DOORBELL_FLAGS_LHINT_LT1K	(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
		#define PUSH32_DOORBELL_FLAGS_LHINT_LT2K	(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
		#define PUSH32_DOORBELL_FLAGS_LHINT_GTE2K	(UINT32_C(0x3) << 13)
		#define PUSH32_DOORBELL_FLAGS_LHINT_LAST	PUSH32_DOORBELL_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_COAL_NOW	UINT32_C(0x8000)
	/*
	 * This is the length of the host physical buffer this BD describes
	 * in bytes.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD.
	 *
	 * This field must be valid on the first BD of a packet.
	 */
	uint32_t	opaque;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	uint16_t	lflags;
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum
	 * fields of normal TCP/UPD checksum, or the inner TCP/UDP
	 * checksum field of the encapsulated TCP/UDP packets with the
	 * hardware calculated TCP/UDP checksum for the packet associated
	 * with this descriptor. The flag is ignored if the LSO flag is set.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_TCP_UDP_CHKSUM	UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the
	 * normal packets, or the inner IP checksum of the encapsulated
	 * packets with the hardware calculated IP checksum for the
	 * packet associated with this descriptor.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_IP_CHKSUM	UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC
	 * to the end of the frame.
	 *
	 * This bit must be valid on the first BD of a packet.
	 *
	 * Packet must be 64B or longer when this flag is set. It is not
	 * useful to use this bit with any form of TX offload such as
	 * CSO or LSO. The intent is that the packet from the host already
	 * has a valid Ethernet CRC on the packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_NOCRC		UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet
	 * was actually transmitted at the TX MAC.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_STAMP		UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header
	 * of the packet associated with this descriptor.
	 *
	 * For outer UDP checksum, global outer UDP checksum TE_NIC register
	 * needs to be enabled. If the global outer UDP checksum TE_NIC
	 * register bit is set, outer UDP checksum will be calculated for the
	 * following cases:
	 * 1. Packets with tcp_udp_chksum flag set to offload checksum for
	 * inner packet AND the inner packet is TCP/UDP. If the inner packet is
	 * ICMP for example (non-TCP/UDP), even if the tcp_udp_chksum is set,
	 * the outer UDP checksum will not be calculated.
	 * 2. Packets with lso flag set which implies inner TCP checksum
	 * calculation as part of LSO operation.
	 */
	#define PUSH32_DOORBELL_LFLAGS_T_IP_CHKSUM	UINT32_C(0x10)
	/*
	 * If set to 1, the device will treat this packet with LSO(Large
	 * Send Offload) processing for both normal or encapsulated
	 * packets, which is a form of TCP segmentation. When this bit
	 * is 1, the hdr_size and mss fields must be valid. The driver
	 * doesn't need to set t_ip_chksum, ip_chksum, and tcp_udp_chksum
	 * flags since the controller will replace the appropriate
	 * checksum fields for segmented packets.
	 *
	 * When this bit is 1, the hdr_size and mss fields must be valid.
	 */
	#define PUSH32_DOORBELL_LFLAGS_LSO		UINT32_C(0x20)
	/*
	 * If set to zero when LSO is '1', then the IPID will be treated
	 * as a 16b number and will be wrapped if it exceeds a value of
	 * 0xffff.
	 *
	 * If set to one when LSO is '1', then the IPID will be treated
	 * as a 15b number and will be wrapped if it exceeds a value of
	 * 0x7fff.
	 */
	#define PUSH32_DOORBELL_LFLAGS_IPID_FMT	UINT32_C(0x40)
	/*
	 * If set to zero when LSO is '1', then the IPID of the tunnel
	 * IP header will not be modified during LSO operations.
	 *
	 * If set to one when LSO is '1', then the IPID of the tunnel
	 * IP header will be incremented for each subsequent segment of an
	 * LSO operation.
	 *
	 * The flag is ignored if the LSO packet is a normal (non-tunneled)
	 * TCP packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_T_IPID		UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the
	 * packet. Packet must be a valid RoCE format packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_ROCE_CRC	UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the
	 * packet. Packet must be a valid FCoE format packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_FCOE_CRC	UINT32_C(0x200)
	uint16_t	hdr_size;
	/*
	 * When LSO is '1', this field must contain the offset of the
	 * TCP payload from the beginning of the packet in as
	 * 16b words. In case of encapsulated/tunneling packet, this field
	 * contains the offset of the inner TCP payload from beginning of the
	 * packet as 16-bit words.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_HDR_SIZE_MASK UINT32_C(0x1ff)
	#define PUSH32_DOORBELL_HDR_SIZE_SFT 0
	uint32_t	mss;
	/*
	 * This is the MSS value that will be used to do the LSO processing.
	 * The value is the length in bytes of the TCP payload for each
	 * segment generated by the LSO operation.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_MSS_MASK UINT32_C(0x7fff)
	#define PUSH32_DOORBELL_MSS_SFT 0
	uint16_t	unused_2;
	/*
	 * This value selects a CFA action to perform on the packet.
	 * Set this value to zero if no CFA action is desired.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	uint16_t	cfa_action;
	/*
	 * This value is action meta-data that defines CFA edit operations
	 * that are done in addition to any action editing.
	 */
	uint32_t	cfa_meta;
	/* When key=1, This is the VLAN tag VID value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_VID_MASK	UINT32_C(0xfff)
	#define PUSH32_DOORBELL_CFA_META_VLAN_VID_SFT	0
	/* When key=1, This is the VLAN tag DE value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_DE	UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_PRI_MASK	UINT32_C(0xe000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_PRI_SFT	13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_MASK	UINT32_C(0x70000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_SFT	16
	/* 0x88a8 */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID88A8  (UINT32_C(0x0) << 16)
	/* 0x8100 */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID8100  (UINT32_C(0x1) << 16)
	/* 0x9100 */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9100  (UINT32_C(0x2) << 16)
	/* 0x9200 */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9200  (UINT32_C(0x3) << 16)
	/* 0x9300 */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9300  (UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPIDCFG   (UINT32_C(0x5) << 16)
		#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_LAST	PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_RESERVED_MASK UINT32_C(0xff80000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_RESERVED_SFT 19
	/*
	 * This field identifies the type of edit to be performed
	 * on the packet.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_CFA_META_KEY_MASK	UINT32_C(0xf0000000)
	#define PUSH32_DOORBELL_CFA_META_KEY_SFT	28
	/* No editing */
		#define PUSH32_DOORBELL_CFA_META_KEY_NONE		(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100).
	 * - meta[15:12] - PRI/DE value.
	 * - meta[11:0] - VID value.
	 */
		#define PUSH32_DOORBELL_CFA_META_KEY_VLAN_TAG	(UINT32_C(0x1) << 28)
		#define PUSH32_DOORBELL_CFA_META_KEY_LAST	PUSH32_DOORBELL_CFA_META_KEY_VLAN_TAG
	/*
	 * This is the data for the push packet. If the packet
	 * data does not fit in the first pass, data writing
	 * can continue at offset 4 of the doorbell for up to 4 additional
	 * passes for a total data size of 512B maximum.
	 */
	uint32_t	data[25];
} __attribute__((packed));

/*******************
 * hwrm_func_reset *
 *******************/


/* hwrm_func_reset_input (size:192b/24B) */

struct hwrm_func_reset_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id_valid field to be
	 * configured.
	 */
	#define HWRM_FUNC_RESET_INPUT_ENABLES_VF_ID_VALID	UINT32_C(0x1)
	/*
	 * The ID of the VF that this PF is trying to reset.
	 * Only the parent PF shall be allowed to reset a child VF.
	 *
	 * A parent PF driver shall use this field only when a specific child
	 * VF is requested to be reset.
	 */
	uint16_t	vf_id;
	/* This value indicates the level of a function reset. */
	uint8_t	func_reset_level;
	/*
	 * Reset the caller function and its children VFs (if any). If no
	 * children functions exist, then reset the caller function only.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETALL	UINT32_C(0x0)
	/* Reset the caller function only */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETME	UINT32_C(0x1)
	/*
	 * Reset all children VFs of the caller function driver if the
	 * caller is a PF driver.
	 * It is an error to specify this level by a VF driver.
	 * It is an error to specify this level by a PF driver with
	 * no children VFs.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETCHILDREN UINT32_C(0x2)
	/*
	 * Reset a specific VF of the caller function driver if the caller
	 * is the parent PF driver.
	 * It is an error to specify this level by a VF driver.
	 * It is an error to specify this level by a PF driver that is not
	 * the parent of the VF that is being requested to reset.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETVF	UINT32_C(0x3)
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_LAST	HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETVF
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_func_reset_output (size:128b/16B) */

struct hwrm_func_reset_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_func_getfid *
 ********************/


/* hwrm_func_getfid_input (size:192b/24B) */

struct hwrm_func_getfid_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the pci_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_GETFID_INPUT_ENABLES_PCI_ID	UINT32_C(0x1)
	/*
	 * This value is the PCI ID of the queried function.
	 * If ARI is enabled, then it is
	 * Bus Number (8b):Function Number(8b). Otherwise, it is
	 * Bus Number (8b):Device Number (5b):Function Number(3b).
	 */
	uint16_t	pci_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_func_getfid_output (size:128b/16B) */

struct hwrm_func_getfid_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value. This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_vf_alloc *
 **********************/


/* hwrm_func_vf_alloc_input (size:192b/24B) */

struct hwrm_func_vf_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the first_vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_ALLOC_INPUT_ENABLES_FIRST_VF_ID	UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	first_vf_id;
	/* The number of virtual functions requested. */
	uint16_t	num_vfs;
} __attribute__((packed));

/* hwrm_func_vf_alloc_output (size:128b/16B) */

struct hwrm_func_vf_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The ID of the first VF allocated. */
	uint16_t	first_vf_id;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_func_vf_free *
 *********************/


/* hwrm_func_vf_free_input (size:192b/24B) */

struct hwrm_func_vf_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the first_vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_FREE_INPUT_ENABLES_FIRST_VF_ID	UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	first_vf_id;
	/*
	 * The number of virtual functions requested.
	 * 0xFFFF - Cleanup all children of this PF.
	 */
	uint16_t	num_vfs;
} __attribute__((packed));

/* hwrm_func_vf_free_output (size:128b/16B) */

struct hwrm_func_vf_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_func_vf_cfg *
 ********************/


/* hwrm_func_vf_cfg_input (size:576b/72B) */

struct hwrm_func_vf_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the mtu field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_MTU			UINT32_C(0x1)
	/*
	 * This bit must be '1' for the guest_vlan field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_GUEST_VLAN		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the async_event_cr field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_ASYNC_EVENT_CR	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the dflt_mac_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_DFLT_MAC_ADDR		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the num_rsscos_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_RSSCOS_CTXS	UINT32_C(0x10)
	/*
	 * This bit must be '1' for the num_cmpl_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_CMPL_RINGS	UINT32_C(0x20)
	/*
	 * This bit must be '1' for the num_tx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_TX_RINGS		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the num_rx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_RX_RINGS		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the num_l2_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_L2_CTXS		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the num_vnics field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_VNICS		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the num_stat_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_STAT_CTXS		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the num_hw_ring_grps field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_HW_RING_GRPS	UINT32_C(0x800)
	/*
	 * This bit must be '1' for the num_ktls_tx_key_ctxs field to
	 * be configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_KTLS_TX_KEY_CTXS	UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the num_ktls_rx_key_ctxs field to
	 * be configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_KTLS_RX_KEY_CTXS	UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the num_quic_tx_key_ctxs field to
	 * be configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_QUIC_TX_KEY_CTXS	UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the num_quic_rx_key_ctxs field to
	 * be configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_QUIC_RX_KEY_CTXS	UINT32_C(0x8000)
	/*
	 * The maximum transmission unit requested on the function.
	 * The HWRM should make sure that the mtu of
	 * the function does not exceed the mtu of the physical
	 * port that this function is associated with.
	 *
	 * In addition to requesting mtu per function, it is
	 * possible to configure mtu per transmit ring.
	 * By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function.
	 * The HWRM should make sure that the mtu of each transmit
	 * ring that is assigned to a function has a valid mtu.
	 */
	uint16_t	mtu;
	/*
	 * The guest VLAN for the function being configured.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	guest_vlan;
	/*
	 * ID of the target completion ring for receiving asynchronous
	 * event completions. If this field is not valid, then the
	 * HWRM shall use the default completion ring of the function
	 * that is being configured as the target completion ring for
	 * providing any asynchronous event completions for that
	 * function.
	 * If this field is valid, then the HWRM shall use the
	 * completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event
	 * completions for the function that is being configured.
	 */
	uint16_t	async_event_cr;
	/*
	 * This value is the current MAC address requested by the VF
	 * driver to be configured on this VF. A value of
	 * 00-00-00-00-00-00 indicates no MAC address configuration
	 * is requested by the VF driver.
	 * The parent PF driver may reject or overwrite this
	 * MAC address.
	 */
	uint8_t	dflt_mac_addr[6];
	uint32_t	flags;
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of TX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_TX_ASSETS_TEST		UINT32_C(0x1)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RX_ASSETS_TEST		UINT32_C(0x2)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of CMPL rings) are
	 * available. The firmware will return an error if the requested
	 * assets are not available. The firmware will NOT reserve the assets
	 * if they are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_CMPL_ASSETS_TEST	UINT32_C(0x4)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RSS ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RSSCOS_CTX_ASSETS_TEST	UINT32_C(0x8)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of ring groups) are
	 * available. The firmware will return an error if the requested
	 * assets are not available. The firmware will NOT reserve the assets
	 * if they are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RING_GRP_ASSETS_TEST	UINT32_C(0x10)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of stat ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_STAT_CTX_ASSETS_TEST	UINT32_C(0x20)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of VNICs) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_VNIC_ASSETS_TEST	UINT32_C(0x40)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of L2 ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_L2_CTX_ASSETS_TEST	UINT32_C(0x80)
	/*
	 * If this bit is set to 1, the VF driver is requesting FW to enable
	 * PPP TX PUSH feature on all the TX rings specified in the
	 * num_tx_rings field. By default, the PPP TX push feature is
	 * disabled for all the TX rings of the VF. This flag is ignored if
	 * the num_tx_rings field is not specified or the VF doesn't support
	 * PPP tx push feature.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_PPP_PUSH_MODE_ENABLE	UINT32_C(0x100)
	/*
	 * If this bit is set to 1, the VF driver is requesting FW to disable
	 * PPP TX PUSH feature on all the TX rings of the VF. This flag is
	 * ignored if the VF doesn't support PPP tx push feature.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_PPP_PUSH_MODE_DISABLE	UINT32_C(0x200)
	/* The number of RSS/COS contexts requested for the VF. */
	uint16_t	num_rsscos_ctxs;
	/* The number of completion rings requested for the VF. */
	uint16_t	num_cmpl_rings;
	/* The number of transmit rings requested for the VF. */
	uint16_t	num_tx_rings;
	/* The number of receive rings requested for the VF. */
	uint16_t	num_rx_rings;
	/* The number of L2 contexts requested for the VF. */
	uint16_t	num_l2_ctxs;
	/* The number of vnics requested for the VF. */
	uint16_t	num_vnics;
	/* The number of statistic contexts requested for the VF. */
	uint16_t	num_stat_ctxs;
	/* The number of HW ring groups requested for the VF. */
	uint16_t	num_hw_ring_grps;
	/* Number of KTLS Tx Key Contexts requested. */
	uint32_t	num_ktls_tx_key_ctxs;
	/* Number of KTLS Rx Key Contexts requested. */
	uint32_t	num_ktls_rx_key_ctxs;
	/* The number of MSI-X vectors requested for the VF. */
	uint16_t	num_msix;
	uint8_t	unused[2];
	/* Number of QUIC Tx Key Contexts requested. */
	uint32_t	num_quic_tx_key_ctxs;
	/* Number of QUIC Rx Key Contexts requested. */
	uint32_t	num_quic_rx_key_ctxs;
} __attribute__((packed));

/* hwrm_func_vf_cfg_output (size:128b/16B) */

struct hwrm_func_vf_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_func_qcaps *
 *******************/


/* hwrm_func_qcaps_input (size:192b/24B) */

struct hwrm_func_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 * 0xFFFE (REQUESTING_PARENT_FID) This is a special FID
	 * to be used by a trusted VF to query its parent PF.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_qcaps_output (size:1152b/144B) */

struct hwrm_func_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value. This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	/*
	 * Port ID of port that this function is associated with.
	 * Valid only for the PF.
	 * 0xFF... (All Fs) if this function is not associated with
	 * any port.
	 * 0xFF... (All Fs) if this function is called from a VF.
	 */
	uint16_t	port_id;
	uint32_t	flags;
	/* If 1, then Push mode is supported on this function. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PUSH_MODE_SUPPORTED		UINT32_C(0x1)
	/*
	 * If 1, then the global MSI-X auto-masking is enabled for the
	 * device.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GLOBAL_MSIX_AUTOMASKING		UINT32_C(0x2)
	/*
	 * If 1, then the Precision Time Protocol (PTP) processing
	 * is supported on this function.
	 * The HWRM should enable PTP on only a single Physical
	 * Function (PF) per port.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PTP_SUPPORTED			UINT32_C(0x4)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v1
	 * is supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V1_SUPPORTED			UINT32_C(0x8)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v2
	 * is supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V2_SUPPORTED			UINT32_C(0x10)
	/*
	 * If 1, then control and configuration of WoL magic packet
	 * are supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_MAGICPKT_SUPPORTED		UINT32_C(0x20)
	/*
	 * If 1, then control and configuration of bitmap pattern
	 * packet are supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_BMP_SUPPORTED			UINT32_C(0x40)
	/*
	 * If set to 1, then the control and configuration of rate limit
	 * of an allocated TX ring on the queried function is supported.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_RING_RL_SUPPORTED		UINT32_C(0x80)
	/*
	 * If 1, then control and configuration of minimum and
	 * maximum bandwidths are supported on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_BW_CFG_SUPPORTED		UINT32_C(0x100)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to set the rate limits
	 * on the TX rings of its children VFs.
	 * If this query is for a PF and this flag is set to 0, then
	 * the PF does not have the capability to set the rate limits
	 * on the TX rings of its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_TX_RING_RL_SUPPORTED		UINT32_C(0x200)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to set the minimum and/or
	 * maximum bandwidths for its children VFs.
	 * If this query is for a PF and this flag is set to 0, then
	 * the PF does not have the capability to set the minimum or
	 * maximum bandwidths for its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_BW_CFG_SUPPORTED		UINT32_C(0x400)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is supported
	 * on the queried function.
	 * If set to 0, then standard TX ring mode is not available
	 * on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_STD_TX_RING_MODE_SUPPORTED		UINT32_C(0x800)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect GENEVE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GENEVE_TUN_FLAGS_SUPPORTED		UINT32_C(0x1000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect NVGRE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_NVGRE_TUN_FLAGS_SUPPORTED		UINT32_C(0x2000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect GRE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GRE_TUN_FLAGS_SUPPORTED		UINT32_C(0x4000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect MPLS tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_MPLS_TUN_FLAGS_SUPPORTED		UINT32_C(0x8000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to support pcie stats.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PCIE_STATS_SUPPORTED		UINT32_C(0x10000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to adopt the VF's belonging
	 * to another PF.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ADOPTED_PF_SUPPORTED		UINT32_C(0x20000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the administrative privilege to configure another
	 * PF.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ADMIN_PF_SUPPORTED			UINT32_C(0x40000)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1, then
	 * the PF will know that the firmware has the capability to track
	 * the virtual link status.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_LINK_ADMIN_STATUS_SUPPORTED	UINT32_C(0x80000)
	/*
	 * If 1, then this function supports the push mode that uses
	 * write combine buffers and the long inline tx buffer descriptor.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WCB_PUSH_MODE			UINT32_C(0x100000)
	/*
	 * If 1, then FW has capability to allocate TX rings dynamically
	 * in ring alloc even if PF reserved pool is zero.
	 * This bit will be used only for PFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_DYNAMIC_TX_RING_ALLOC		UINT32_C(0x200000)
	/*
	 * When this bit is '1', it indicates that core firmware is
	 * capable of Hot Reset.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_HOT_RESET_CAPABLE			UINT32_C(0x400000)
	/*
	 * This flag will be set to 1 by the FW if FW supports adapter error
	 * recovery.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ERROR_RECOVERY_CAPABLE		UINT32_C(0x800000)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1, then
	 * the PF has the capability to support extended stats.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_STATS_SUPPORTED		UINT32_C(0x1000000)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1, then host
	 * must initiate reset or reload (or fastboot) the firmware image
	 * upon detection of device shutdown state.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ERR_RECOVER_RELOAD			UINT32_C(0x2000000)
	/*
	 * If the query is for a VF, then this flag (always set to 0) shall
	 * be ignored. If this query is for a PF and this flag is set to 1,
	 * host, when registered for the default vnic change async event,
	 * receives async notification whenever a default vnic state is
	 * changed for any of child or adopted VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_NOTIFY_VF_DEF_VNIC_CHNG_SUPPORTED	UINT32_C(0x4000000)
	/* If set to 1, then the vlan acceleration for TX is disabled. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VLAN_ACCELERATION_TX_DISABLED	UINT32_C(0x8000000)
	/*
	 * When this bit is '1', it indicates that core firmware supports
	 * DBG_COREDUMP_XXX commands.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_COREDUMP_CMD_SUPPORTED		UINT32_C(0x10000000)
	/*
	 * When this bit is '1', it indicates that core firmware supports
	 * DBG_CRASHDUMP_XXX commands.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_CRASHDUMP_CMD_SUPPORTED		UINT32_C(0x20000000)
	/*
	 * If the query is for a VF, then this flag should be ignored.
	 * If the query is for a PF and this flag is set to 1, then
	 * the PF has the capability to support retrieval of
	 * rx_port_stats_ext_pfc_wd statistics (supported by the PFC
	 * WatchDog feature) via the hwrm_port_qstats_ext_pfc_wd command.
	 * If this flag is set to 1, only that (supported) command should
	 * be used for retrieval of PFC related statistics (rather than
	 * hwrm_port_qstats_ext command, which could previously be used).
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PFC_WD_STATS_SUPPORTED		UINT32_C(0x40000000)
	/*
	 * When this bit is '1', it indicates that core firmware supports
	 * DBG_QCAPS command
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_DBG_QCAPS_CMD_SUPPORTED		UINT32_C(0x80000000)
	/*
	 * This value is current MAC address configured for this
	 * function. A value of 00-00-00-00-00-00 indicates no
	 * MAC address is currently configured.
	 */
	uint8_t	mac_address[6];
	/*
	 * The maximum number of RSS/COS contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_rsscos_ctx;
	/*
	 * The maximum number of completion rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_cmpl_rings;
	/*
	 * The maximum number of transmit rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_tx_rings;
	/*
	 * The maximum number of receive rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_rx_rings;
	/*
	 * The maximum number of L2 contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_l2_ctxs;
	/*
	 * The maximum number of VNICs that can be
	 * allocated to the function.
	 */
	uint16_t	max_vnics;
	/*
	 * The identifier for the first VF enabled on a PF. This
	 * is valid only on the PF with SR-IOV enabled.
	 * 0xFF... (All Fs) if this command is called on a PF with
	 * SR-IOV disabled or on a VF.
	 */
	uint16_t	first_vf_id;
	/*
	 * The maximum number of VFs that can be
	 * allocated to the function. This is valid only on the
	 * PF with SR-IOV enabled. 0xFF... (All Fs) if this
	 * command is called on a PF with SR-IOV disabled or
	 * on a VF.
	 */
	uint16_t	max_vfs;
	/*
	 * The maximum number of statistic contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_stat_ctx;
	/*
	 * The maximum number of Encapsulation records that can be
	 * offloaded by this function.
	 */
	uint32_t	max_encap_records;
	/*
	 * The maximum number of decapsulation records that can
	 * be offloaded by this function.
	 */
	uint32_t	max_decap_records;
	/*
	 * The maximum number of Exact Match (EM) flows that can be
	 * offloaded by this function on the TX side.
	 */
	uint32_t	max_tx_em_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can
	 * be offloaded by this function on the TX side.
	 */
	uint32_t	max_tx_wm_flows;
	/*
	 * The maximum number of Exact Match (EM) flows that can be
	 * offloaded by this function on the RX side.
	 */
	uint32_t	max_rx_em_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can
	 * be offloaded by this function on the RX side.
	 */
	uint32_t	max_rx_wm_flows;
	/*
	 * The maximum number of multicast filters that can
	 * be supported by this function on the RX side.
	 */
	uint32_t	max_mcast_filters;
	/*
	 * The maximum value of flow_id that can be supported
	 * in completion records.
	 */
	uint32_t	max_flow_id;
	/*
	 * The maximum number of HW ring groups that can be
	 * supported on this function.
	 */
	uint32_t	max_hw_ring_grps;
	/*
	 * The maximum number of strict priority transmit rings
	 * that can be allocated to the function.
	 * This number indicates the maximum number of TX rings
	 * that can be assigned strict priorities out of the
	 * maximum number of TX rings that can be allocated
	 * (max_tx_rings) to the function.
	 */
	uint16_t	max_sp_tx_rings;
	/*
	 * The maximum number of MSI-X vectors that may be allocated across
	 * all VFs for the function. This is valid only on the PF with SR-IOV
	 * enabled. Returns zero if this command is called on a PF with
	 * SR-IOV disabled or on a VF.
	 */
	uint16_t	max_msix_vfs;
	uint32_t	flags_ext;
	/*
	 * If 1, the device can be configured to set the ECN bits in the
	 * IP header of received packets if the receive queue length
	 * exceeds a given threshold.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_ECN_MARK_SUPPORTED			UINT32_C(0x1)
	/*
	 * If 1, the device can report the number of received packets
	 * that it marked as having experienced congestion.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_ECN_STATS_SUPPORTED			UINT32_C(0x2)
	/*
	 * If 1, the device can report extended hw statistics (including
	 * additional tpa statistics).
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_EXT_HW_STATS_SUPPORTED			UINT32_C(0x4)
	/*
	 * If set to 1, then the core firmware has support to enable/
	 * disable hot reset support for interface dynamically through
	 * HWRM_FUNC_CFG.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_HOT_RESET_IF_SUPPORT			UINT32_C(0x8)
	/* If 1, the proxy mode is supported on this function */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PROXY_MODE_SUPPORT			UINT32_C(0x10)
	/*
	 * If 1, the tx rings source interface override feature is supported
	 * on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_TX_PROXY_SRC_INTF_OVERRIDE_SUPPORT	UINT32_C(0x20)
	/*
	 * If 1, the device supports scheduler queues. SCHQs can be managed
	 * using RING_SCHQ_ALLOC/CFG/FREE commands.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_SCHQ_SUPPORTED				UINT32_C(0x40)
	/*
	 * If set to 1, then this function supports the TX push mode that
	 * uses ping-pong buffers from the push pages.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PPP_PUSH_MODE_SUPPORTED			UINT32_C(0x80)
	/*
	 * If set to 1, then this function doesn't have the privilege to
	 * configure the EVB mode of the port it uses.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_EVB_MODE_CFG_NOT_SUPPORTED		UINT32_C(0x100)
	/*
	 * If set to 1, then the HW and FW support the SoC packet DMA
	 * datapath between SoC and NIC. This function can act as the
	 * HWRM communication transport agent on behalf of the SoC SPD
	 * software module. This capability is only advertised to the
	 * SoC PFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_SOC_SPD_SUPPORTED			UINT32_C(0x200)
	/*
	 * If set to 1, then this function supports FW_LIVEPATCH for
	 * firmware livepatch commands.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_FW_LIVEPATCH_SUPPORTED			UINT32_C(0x400)
	/*
	 * When this bit is '1', it indicates that core firmware is
	 * capable of fast Reset.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_FAST_RESET_CAPABLE			UINT32_C(0x800)
	/*
	 * When this bit is '1', it indicates that firmware and hardware
	 * are capable of updating tx_metadata via hwrm_ring_cfg command.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_TX_METADATA_CFG_CAPABLE			UINT32_C(0x1000)
	/*
	 * If set to 1, then the device can report the action
	 * needed to activate set nvm options.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_NVM_OPTION_ACTION_SUPPORTED		UINT32_C(0x2000)
	/*
	 * When this bit is '1', it indicates that the BD metadata feature
	 * is supported for this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_BD_METADATA_SUPPORTED			UINT32_C(0x4000)
	/*
	 * When this bit is '1', it indicates that the echo request feature
	 * is supported for this function. If the driver registers for the
	 * echo request asynchronous event, then the firmware can send an
	 * unsolicited echo request to the driver and expect an echo
	 * response.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_ECHO_REQUEST_SUPPORTED			UINT32_C(0x8000)
	/*
	 * When this bit is '1', it indicates that core firmware supports
	 * NPAR 1.2 on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_NPAR_1_2_SUPPORTED			UINT32_C(0x10000)
	/* When this bit is '1', it indicates that PTM feature is supported. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PTP_PTM_SUPPORTED			UINT32_C(0x20000)
	/* When this bit is '1', it indicates that PPS feature is supported. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PTP_PPS_SUPPORTED			UINT32_C(0x40000)
	/*
	 * When this bit is '1', it indicates that VF config. change
	 * async event is supported on the parent PF if the async.
	 * event is registered by the PF.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_VF_CFG_ASYNC_FOR_PF_SUPPORTED		UINT32_C(0x80000)
	/*
	 * When this bit is '1', the NIC supports configuration of
	 * partition_min_bw and partition_max_bw. Configuration of a
	 * minimum guaranteed bandwidth is only supported if the
	 * min_bw_supported flag is also set.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PARTITION_BW_SUPPORTED			UINT32_C(0x100000)
	/*
	 * When this bit is '1', the FW supports configuration of
	 * PCP and TPID values of the default VLAN.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_DFLT_VLAN_TPID_PCP_SUPPORTED		UINT32_C(0x200000)
	/* When this bit is '1', it indicates that HW and FW support KTLS. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_KTLS_SUPPORTED				UINT32_C(0x400000)
	/*
	 * When this bit is '1', the firmware supports HWRM_PORT_EP_TX_CFG
	 * and HWRM_PORT_EP_TX_QCFG for endpoint rate control, and additions
	 * to HWRM_QUEUE_GLOBAL_CFG and HWRM_QUEUE_GLOBAL_QCFG for receive
	 * rate control. Configuration of a minimum guaranteed bandwidth
	 * is only supported if the min_bw_supported flag is also set.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_EP_RATE_CONTROL				UINT32_C(0x800000)
	/*
	 * When this bit is '1', the firmware supports enforcement of
	 * minimum guaranteed bandwidth. A minimum guaranteed bandwidth
	 * could be configured for a partition or for an endpoint. Firmware
	 * only sets this flag if one or both of the ep_rate_control and
	 * partition_bw_supported flags are set.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_MIN_BW_SUPPORTED				UINT32_C(0x1000000)
	/*
	 * When this bit is '1', HW supports TX coalesced completion
	 * records.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_TX_COAL_CMPL_CAP				UINT32_C(0x2000000)
	/*
	 * When this bit is '1', it indicates the FW has full support
	 * for all backing store types with the BACKING_STORE_CFG/QCFG
	 * V2 APIs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_BS_V2_SUPPORTED				UINT32_C(0x4000000)
	/*
	 * When this bit is '1', it indicates the FW forces to use the
	 * BACKING_STORE_CFG/QCFG V2 APIs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_BS_V2_REQUIRED				UINT32_C(0x8000000)
	/*
	 * When this bit is '1', it indicates that FW will support a single
	 * 64bit real time clock for PTP.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_PTP_64BIT_RTC_SUPPORTED			UINT32_C(0x10000000)
	/*
	 * When this bit is '1', it indicates the FW is capable of
	 * supporting Doorbell Pacing.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_DBR_PACING_SUPPORTED			UINT32_C(0x20000000)
	/*
	 * When this bit is '1', it indicates the FW is capable of
	 * supporting HW based doorbell drop recovery.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_HW_DBR_DROP_RECOV_SUPPORTED		UINT32_C(0x40000000)
	/*
	 * When this bit is '1', it indicates the driver can disable the CQ
	 * overflow detection and can also skip the index updates for CQ.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT_DISABLE_CQ_OVERFLOW_DETECTION_SUPPORTED	UINT32_C(0x80000000)
	/* The maximum number of SCHQs supported by this device. */
	uint8_t	max_schqs;
	uint8_t	mpc_chnls_cap;
	/*
	 * When this bit is '1', it indicates that HW and firmware
	 * supports the use of a MPC channel with destination set
	 * to the TX crypto engine block.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_MPC_CHNLS_CAP_TCE	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that HW and firmware
	 * supports the use of a MPC channel with destination set
	 * to the RX crypto engine block.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_MPC_CHNLS_CAP_RCE	UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates that HW and firmware
	 * supports the use of a MPC channel with destination set
	 * to the TX configurable flow processing block.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_MPC_CHNLS_CAP_TE_CFA	UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates that HW and firmware
	 * supports the use of a MPC channel with destination set
	 * to the RX configurable flow processing block.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_MPC_CHNLS_CAP_RE_CFA	UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates that HW and firmware
	 * supports the use of a MPC channel with destination set
	 * to the primate processor block.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_MPC_CHNLS_CAP_PRIMATE	UINT32_C(0x10)
	/*
	 * Maximum number of Key Contexts supported per HWRM
	 * function call for allocating Key Contexts.
	 */
	uint16_t	max_key_ctxs_alloc;
	uint32_t	flags_ext2;
	/*
	 * When this bit is '1', it indicates that FW will support
	 * timestamping on all RX packets, not just PTP type packets.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_RX_ALL_PKTS_TIMESTAMPS_SUPPORTED	UINT32_C(0x1)
	/* When this bit is '1', it indicates that HW and FW support QUIC. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_QUIC_SUPPORTED			UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates that KDNet mode is
	 * supported on the port for this function. This bit is
	 * never set for a VF.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_KDNET_SUPPORTED			UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates the FW is capable of
	 * supporting Enhanced Doorbell Pacing.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_DBR_PACING_EXT_SUPPORTED		UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates that FW is capable of
	 * supporting software based doorbell drop recovery.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SW_DBR_DROP_RECOVERY_SUPPORTED	UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates the FW supports collection
	 * and query of the generic statistics.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_GENERIC_STATS_SUPPORTED		UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that the HW is capable of
	 * supporting UDP GSO on the function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_UDP_GSO_SUPPORTED			UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that SyncE feature is
	 * supported.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SYNCE_SUPPORTED			UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates the FW is capable of
	 * supporting doorbell pacing version 0. As doorbell pacing
	 * notification from hardware for Thor2 is completely different
	 * from Thor1, this flag is used to differentiate the doorbell
	 * pacing notification between Thor1 and Thor2. Thor1 uses
	 * dbr_pacing_supported and dbr_pacing_ext_supported flags for
	 * doorbell pacing whereas Thor2 uses dbr_pacing_v0_supported flag.
	 * These flags will never be set at the same time for Thor2.
	 * Based on this flag, host drivers assume doorbell pacing is needed
	 * for Thor2.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_DBR_PACING_V0_SUPPORTED		UINT32_C(0x100)
	/*
	 * When this bit is '1', it indicates that the HW supports
	 * two-completion TX packet timestamp feature, a second completion
	 * carrying packet TX timestamp in addition to the standard
	 * completion returned for packets. Host driver should not use
	 * HWRM port timestamp query (HWRM_PORT_TS_QUERY) command for
	 * TX timestamp read when two-completion timestamp feature is
	 * supported.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_TX_PKT_TS_CMPL_SUPPORTED		UINT32_C(0x200)
	/*
	 * When this bit is '1', it indicates that the hardware based
	 * link aggregation group (L2 and RoCE) feature is supported.
	 * This LAG feature is only supported on the THOR2 or newer NIC
	 * with multiple ports.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_HW_LAG_SUPPORTED			UINT32_C(0x400)
	/*
	 * When this bit is '1', it indicates all contexts can be stored
	 * on chip instead of using host based backing store memory.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_ON_CHIP_CTX_SUPPORTED		UINT32_C(0x800)
	/*
	 * When this bit is '1', it indicates that the HW supports
	 * using a steering tag in the memory transactions targeting
	 * L2 or RoCE ring resources.
	 * Steering Tags are system-specific values that must follow the
	 * encoding requirements of the hardware platform. On devices that
	 * support steering to multiple address domains, a value of 0 in
	 * bit 0 of the steering tag specifies the address is associated
	 * with the SOC address space, and a value of 1 indicates the
	 * address is associated with the host address space.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_STEERING_TAG_SUPPORTED		UINT32_C(0x1000)
	/*
	 * When this bit is '1', it indicates that driver can enable
	 * support for an enhanced VF scale.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_ENHANCED_VF_SCALE_SUPPORTED	UINT32_C(0x2000)
	/*
	 * When this bit is '1', it indicates that FW is capable of
	 * supporting partition based XID management for KTLS/QUIC
	 * Tx/Rx Key Context types.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_KEY_XID_PARTITION_SUPPORTED	UINT32_C(0x4000)
	/*
	 * This bit is only valid on the condition that both
	 * 'ktls_supported' and 'quic_supported' flags are set. When this
	 * bit is valid, it conveys information below:
	 * 1. If it is set to '1', it indicates that the firmware allows the
	 *	driver to run KTLS and QUIC concurrently;
	 * 2. If it is cleared to '0', it indicates that the driver has to
	 *	make sure all crypto connections on all functions are of the
	 *	same type, i.e., either KTLS or QUIC.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_CONCURRENT_KTLS_QUIC_SUPPORTED	UINT32_C(0x8000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * setting a cross TC cap on a scheduler queue.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SCHQ_CROSS_TC_CAP_SUPPORTED	UINT32_C(0x10000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * setting a per TC cap on a scheduler queue.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SCHQ_PER_TC_CAP_SUPPORTED		UINT32_C(0x20000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * setting a per TC reservation on a scheduler queues.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SCHQ_PER_TC_RESERVATION_SUPPORTED	UINT32_C(0x40000)
	/*
	 * When this bit is '1', it indicates that firmware supports query
	 * for statistics related to invalid doorbell errors and drops.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_DB_ERROR_STATS_SUPPORTED		UINT32_C(0x80000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * VF RoCE resource management.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_ROCE_VF_RESOURCE_MGMT_SUPPORTED	UINT32_C(0x100000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * UDCC management.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_UDCC_SUPPORTED			UINT32_C(0x200000)
	/*
	 * When this bit is '1', it indicates that the device supports Timed
	 * Transmit TxTime scheduling; this is applicable to L2 flows only.
	 * It is expected that host software assigns each packet a transmit
	 * time and posts packets for transmit in time order. NIC hardware
	 * transmits the packet at time assigned by software.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_TIMED_TX_SO_TXTIME_SUPPORTED	UINT32_C(0x400000)
	/*
	 * This bit indicates the method used for the advertisement of the
	 * max resource limit for the PF and its VFs.
	 * When this bit is '1', it indicates that the maximum resource
	 * limits for both RoCE and L2 are software defined. These limits
	 * are queried using the HWRM backing store qcaps v1
	 * and v2(max_num_entries). For RoCE, the resource limits are
	 * derived from nvm options. For L2, the resources will continue
	 * to use FW enforced SW limits based on chip config and per PF
	 * function NVM resource parameters.
	 * If this bit is '0', the FW will use to legacy behavior.
	 * For RoCE, the maximum resource values supported by the chip will
	 * be returned. For L2, the maximum resource values returned will
	 * be the FW enforced SW limits based on chip config and per PF
	 * function NVM resource parameters.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_SW_MAX_RESOURCE_LIMITS_SUPPORTED	UINT32_C(0x800000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * migrating ingress NIC flows to Truflow.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_TF_INGRESS_NIC_FLOW_SUPPORTED	UINT32_C(0x1000000)
	/*
	 * When this bit is '1', it indicates that the Firmware supports
	 * query and clear of the port loopback statistics.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_LPBK_STATS_SUPPORTED		UINT32_C(0x2000000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * migrating egress NIC flows to Truflow.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_TF_EGRESS_NIC_FLOW_SUPPORTED	UINT32_C(0x4000000)
	/*
	 * When this bit is '1', it indicates that the device supports
	 * multiple lossless CoS queues.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_MULTI_LOSSLESS_QUEUES_SUPPORTED	UINT32_C(0x8000000)
	/*
	 * When this bit is '1', it indicates that the firmware supports
	 * peer memory map storing feature.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_PEER_MMAP_SUPPORTED		UINT32_C(0x10000000)
	/*
	 * When this bit is '1', it indicates that the device supports Timed
	 * Transmit packet pacing; this is applicable to L2 flows only.
	 * Host software passes the transmit rate of an L2 flow to the
	 * hardware and hardware uses this rate to derive the transmit time
	 * for scheduling packet transmission of the flow.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_TIMED_TX_PACING_SUPPORTED		UINT32_C(0x20000000)
	/*
	 * When this bit is '1', it indicates that the device supports VF
	 * statistics ejection. Firmware is capable of copying VF statistics
	 * to two host buffers - one buffer allocated by VF driver and
	 * another buffer allocated by the parent PF driver. This bit is
	 * only set on a PF.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_VF_STAT_EJECTION_SUPPORTED		UINT32_C(0x40000000)
	/*
	 * When this bit is '1', it indicates that the parent PF allocated
	 * the Host DMA buffer to capture the coredump. So that any VF
	 * driver instance can issue HWRM_DBG_COREDUMP_CAPTURE command
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT2_HOST_COREDUMP_SUPPORTED		UINT32_C(0x80000000)
	uint16_t	tunnel_disable_flag;
	/*
	 * When this bit is '1', it indicates that the VXLAN parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_VXLAN	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that the NGE parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_NGE	UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates that the NVGRE parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_NVGRE	UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates that the L2GRE parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_L2GRE	UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates that the GRE parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_GRE	UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates that the IPINIP parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_IPINIP	UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that the MPLS parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_MPLS	UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the PPPOE parsing
	 * is disabled in hardware
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_TUNNEL_DISABLE_FLAG_DISABLE_PPPOE	UINT32_C(0x80)
	uint16_t	xid_partition_cap;
	/*
	 * When this bit is '1', it indicates that FW is capable of
	 * supporting partition based XID management for Tx crypto
	 * key contexts.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_XID_PARTITION_CAP_TX_CK	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that FW is capable of
	 * supporting partition based XID management for Rx crypto
	 * key contexts.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_XID_PARTITION_CAP_RX_CK	UINT32_C(0x2)
	/*
	 * This value uniquely identifies the hardware NIC used by the
	 * function. The value returned will be the same for all functions.
	 * A value of 00-00-00-00-00-00-00-00 indicates no device serial number
	 * is currently configured. This is the same value that is returned by
	 * PCIe Capability Device Serial Number.
	 */
	uint8_t	device_serial_number[8];
	/*
	 * This field is only valid in the XID partition mode. It indicates
	 * the number contexts per partition.
	 */
	uint16_t	ctxs_per_partition;
	/*
	 * The maximum number of tso segments that NIC can handle during the
	 * large segmentation offload.
	 * If this field is zero, that means there is no limit on the TSO
	 * segment limit.
	 * Note that this field will be zero for older firmware that
	 * doesn't report the max TSO segment limit.
	 */
	uint16_t	max_tso_segs;
	/*
	 * The maximum number of address vectors that may be allocated across
	 * all VFs for the function. This is valid only on the PF with VF RoCE
	 * (SR-IOV) enabled. Returns zero if this command is called on a PF
	 * with VF RoCE (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_av;
	/*
	 * The maximum number of completion queues that may be allocated across
	 * all VFs for the function. This is valid only on the PF with VF RoCE
	 * (SR-IOV) enabled. Returns zero if this command is called on a PF
	 * with VF RoCE (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_cq;
	/*
	 * The maximum number of memory regions plus memory windows that may be
	 * allocated across all VFs for the function. This is valid only on the
	 * PF with VF RoCE (SR-IOV) enabled. Returns zero if this command is
	 * called on a PF with VF RoCE (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_mrw;
	/*
	 * The maximum number of queue pairs that may be allocated across
	 * all VFs for the function. This is valid only on the PF with VF RoCE
	 * (SR-IOV) enabled. Returns zero if this command is called on a PF
	 * with VF RoCE (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_qp;
	/*
	 * The maximum number of shared receive queues that may be allocated
	 * across all VFs for the function. This is valid only on the PF with
	 * VF RoCE (SR-IOV) enabled. Returns zero if this command is called on
	 * a PF with VF RoCE (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_srq;
	/*
	 * The maximum number of GIDs that may be allocated across all VFs for
	 * the function. This is valid only on the PF with VF RoCE (SR-IOV)
	 * enabled. Returns zero if this command is called on a PF with VF RoCE
	 * (SR-IOV) disabled or on a VF.
	 */
	uint32_t	roce_vf_max_gid;
	uint32_t	flags_ext3;
	/*
	 * When this bit is '1', firmware supports the driver using
	 * FUNC_CFG (or FUNC_VF_CFG) to decrease resource reservations
	 * while some resources are still allocated. An error is returned
	 * if the driver tries to set the reservation to be less than the
	 * number of allocated resources.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_EXT3_RM_RSV_WHILE_ALLOC_CAP	UINT32_C(0x1)
	uint8_t	unused_3[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal
	 * processor, the order of writes has to be such that this field is
	 * written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_func_qcfg *
 ******************/


/* hwrm_func_qcfg_input (size:192b/24B) */

struct hwrm_func_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 * 0xFFFE (REQUESTING_PARENT_FID) This is a special FID
	 * to be used by a trusted VF to query its parent PF.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_qcfg_output (size:1280b/160B) */

struct hwrm_func_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value. This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	/*
	 * Port ID of port that this function is associated with.
	 * 0xFF... (All Fs) if this function is not associated with
	 * any port.
	 */
	uint16_t	port_id;
	/*
	 * This value is the current VLAN setting for this
	 * function. The value of 0 for this field indicates
	 * no priority tagging or VLAN is used.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	vlan;
	uint16_t	flags;
	/*
	 * If 1, then magic packet based Out-Of-Box WoL is enabled on
	 * the port associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_MAGICPKT_ENABLED	UINT32_C(0x1)
	/*
	 * If 1, then bitmap pattern based Out-Of-Box WoL packet is enabled
	 * on the port associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_BMP_ENABLED	UINT32_C(0x2)
	/*
	 * If set to 1, then FW based DCBX agent is enabled and running on
	 * the port associated with this function.
	 * If set to 0, then DCBX agent is not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_DCBX_AGENT_ENABLED	UINT32_C(0x4)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is enabled
	 * on the queried function.
	 * If set to 0, then the standard TX ring mode is disabled
	 * on the queried function. In this extended TX ring resource
	 * mode, the minimum and maximum bandwidth settings are not
	 * supported to allow the allocation of TX rings to span multiple
	 * scheduler nodes.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_STD_TX_RING_MODE_ENABLED	UINT32_C(0x8)
	/*
	 * If set to 1 then FW based LLDP agent is enabled and running on
	 * the port associated with this function.
	 * If set to 0 then the LLDP agent is not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_LLDP_AGENT_ENABLED	UINT32_C(0x10)
	/*
	 * If set to 1, then multi-host mode is active for this function.
	 * The NIC is attached to two or more independent host systems
	 * through two or more PCIe endpoints.
	 * If set to 0, then multi-host mode is inactive for this function
	 * or not applicable for this device.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_MULTI_HOST		UINT32_C(0x20)
	/*
	 * If the function that is being queried is a PF, then the HWRM shall
	 * set this field to 0 and the HWRM client shall ignore this field.
	 * If the function that is being queried is a VF, then the HWRM shall
	 * set this field to 1 if the queried VF is trusted, otherwise the
	 * HWRM shall set this field to 0.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_TRUSTED_VF		UINT32_C(0x40)
	/*
	 * If set to 1, then secure mode is enabled for this function or
	 * device. If set to 0, then secure mode is disabled (or normal mode)
	 * for this function or device.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_SECURE_MODE_ENABLED	UINT32_C(0x80)
	/*
	 * If set to 1, then this PF is enabled with a preboot driver that
	 * requires access to the legacy L2 ring model and legacy 32b
	 * doorbells. If set to 0, then this PF is not allowed to use
	 * the legacy L2 rings. This feature is not allowed on VFs and
	 * is only relevant for devices that require a context backing
	 * store.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_PREBOOT_LEGACY_L2_RINGS	UINT32_C(0x100)
	/*
	 * If set to 1, then the firmware and all currently registered driver
	 * instances support hot reset. The hot reset support will be updated
	 * dynamically based on the driver interface advertisement.
	 * If set to 0, then the adapter is not currently able to initiate
	 * hot reset.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_HOT_RESET_ALLOWED		UINT32_C(0x200)
	/*
	 * If set to 1, then the PPP tx push mode is enabled for all the
	 * reserved TX rings of this function. If set to 0, then PPP tx push
	 * mode is disabled for all the reserved TX rings of this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_PPP_PUSH_MODE_ENABLED	UINT32_C(0x400)
	/*
	 * If set to 1, then the firmware will notify driver using async
	 * event when a ring is disabled due to a Hardware error.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_RING_MONITOR_ENABLED	UINT32_C(0x800)
	/*
	 * If set to 1, then the firmware and all currently registered driver
	 * instances support fast reset. The fast reset support will be
	 * updated dynamically based on the driver interface advertisement.
	 * If set to 0, then the adapter is not currently able to initiate
	 * fast reset.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FAST_RESET_ALLOWED	UINT32_C(0x1000)
	/*
	 * If set to 1, then multi-root mode is active for this function.
	 * The NIC is attached to a single host with a single operating
	 * system, but through two or more PCIe endpoints.
	 * If set to 0, then multi-root mode is inactive for this function
	 * or not applicable for this device.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_MULTI_ROOT		UINT32_C(0x2000)
	/*
	 * This flag indicates RDMA support for child VFS of
	 * a physical function.
	 * If set to 1, RoCE is supported on all child VFs.
	 * If set to 0, RoCE is disabled on all child VFs.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_ENABLE_RDMA_SRIOV		UINT32_C(0x4000)
	/*
	 * When set to 1, indicates the field roce_vnic_id in the structure
	 * is valid. If this bit is 0, the driver should not use the
	 * 'roce_vnic_id' field.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_ROCE_VNIC_ID_VALID	UINT32_C(0x8000)
	/*
	 * This value is current MAC address configured for this
	 * function. A value of 00-00-00-00-00-00 indicates no
	 * MAC address is currently configured.
	 */
	uint8_t	mac_address[6];
	/*
	 * This value is current PCI ID of this
	 * function. If ARI is enabled, then it is
	 * Bus Number (8b):Function Number(8b). Otherwise, it is
	 * Bus Number (8b):Device Number (4b):Function Number(4b).
	 * If multi-host mode is active, the 4 lsb will indicate
	 * the PF index for this function.
	 */
	uint16_t	pci_id;
	/*
	 * The number of RSS/COS contexts currently
	 * allocated to the function.
	 */
	uint16_t	alloc_rsscos_ctx;
	/*
	 * The number of completion rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_cmpl_rings;
	/*
	 * The number of transmit rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_tx_rings;
	/*
	 * The number of receive rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_rx_rings;
	/* The allocated number of L2 contexts to the function. */
	uint16_t	alloc_l2_ctx;
	/* The allocated number of vnics to the function. */
	uint16_t	alloc_vnics;
	/*
	 * The maximum transmission unit of the function
	 * configured by the admin pf.
	 * If the reported mtu value is non-zero then it will be used for the
	 * rings allocated on this function, otherwise the default
	 * value is used if ring MTU is not specified.
	 * The driver cannot use any MTU bigger than this value
	 * if it is non-zero.
	 */
	uint16_t	admin_mtu;
	/*
	 * The maximum receive unit of the function.
	 * For vnics allocated on this function, this default
	 * value is used if vnic MRU is not specified.
	 */
	uint16_t	mru;
	/* The statistics context assigned to a function. */
	uint16_t	stat_ctx_id;
	/*
	 * The HWRM shall return Unknown value for this field
	 * when this command is used to query VF's configuration.
	 */
	uint8_t	port_partition_type;
	/* Single physical function */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_SPF	UINT32_C(0x0)
	/* Multiple physical functions */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_MPFS	UINT32_C(0x1)
	/* Network Partitioning 1.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_0 UINT32_C(0x2)
	/* Network Partitioning 1.5 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_5 UINT32_C(0x3)
	/* Network Partitioning 2.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR2_0 UINT32_C(0x4)
	/* Network Partitioning 1.2 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_2 UINT32_C(0x5)
	/* Unknown */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_UNKNOWN UINT32_C(0xff)
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_LAST   HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_UNKNOWN
	/*
	 * This field will indicate number of physical functions on this
	 * port_partition. HWRM shall return unavail (i.e. value of 0) for this
	 * field when this command is used to query VF's configuration or from
	 * older firmware that doesn't support this field.
	 */
	uint8_t	port_pf_cnt;
	/* number of PFs is not available */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_UNAVAIL UINT32_C(0x0)
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_LAST   HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_UNAVAIL
	/*
	 * The default VNIC ID assigned to a function that is
	 * being queried.
	 */
	uint16_t	dflt_vnic_id;
	uint16_t	max_mtu_configured;
	/*
	 * Minimum guaranteed transmit bandwidth for this function. When
	 * specified for a PF, does not affect traffic from the PF's child VFs.
	 * A value of 0 indicates the minimum bandwidth is not configured.
	 */
	uint32_t	min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_LAST		HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of link bandwidth. */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
	/* Invalid unit */
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID	(UINT32_C(0x7) << 29)
		#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum transmit rate for this function. When specified for a PF,
	 * does not affect traffic from the PF's child VFs.
	 * A value of 0 indicates that the maximum bandwidth is not configured.
	 */
	uint32_t	max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_LAST		HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of link bandwidth. */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
	/* Invalid unit */
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID	(UINT32_C(0x7) << 29)
		#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	/*
	 * This value indicates the Edge virtual bridge mode for the
	 * domain that this function belongs to.
	 */
	uint8_t	evb_mode;
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_NO_EVB UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEB	UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEPA   UINT32_C(0x2)
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_LAST  HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEPA
	uint8_t	options;
	/*
	 * This value indicates the PCIE device cache line size.
	 * The cache line size allows the DMA writes to terminate and
	 * start at the cache boundary.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_MASK	UINT32_C(0x3)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SFT	0
	/* Cache Line Size 64 bytes */
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_64	UINT32_C(0x0)
	/* Cache Line Size 128 bytes */
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_128	UINT32_C(0x1)
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_LAST	HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_128
	/* This value is the virtual link admin state setting. */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_MASK	UINT32_C(0xc)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_SFT	2
	/* Admin link state is in forced down mode. */
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_FORCED_DOWN  (UINT32_C(0x0) << 2)
	/* Admin link state is in forced up mode. */
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_FORCED_UP	(UINT32_C(0x1) << 2)
	/*
	 * Admin link state is in auto mode - follows the physical link
	 * state.
	 */
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_AUTO	(UINT32_C(0x2) << 2)
		#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_LAST	HWRM_FUNC_QCFG_OUTPUT_OPTIONS_LINK_ADMIN_STATE_AUTO
	/* Reserved for future. */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_RSVD_MASK		UINT32_C(0xf0)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_RSVD_SFT			4
	/*
	 * The number of VFs that are allocated to the function.
	 * This is valid only on the PF with SR-IOV enabled.
	 * 0xFF... (All Fs) if this command is called on a PF with
	 * SR-IOV disabled or on a VF.
	 */
	uint16_t	alloc_vfs;
	/*
	 * The number of allocated multicast filters for this
	 * function on the RX side.
	 */
	uint32_t	alloc_mcast_filters;
	/*
	 * The number of allocated HW ring groups for this
	 * function.
	 */
	uint32_t	alloc_hw_ring_grps;
	/*
	 * The number of strict priority transmit rings out of
	 * currently allocated TX rings to the function
	 * (alloc_tx_rings).
	 */
	uint16_t	alloc_sp_tx_rings;
	/*
	 * The number of statistics contexts
	 * currently reserved for the function.
	 */
	uint16_t	alloc_stat_ctx;
	/*
	 * This field specifies how many NQs are reserved for the PF.
	 * Remaining NQs that belong to the PF are available for VFs.
	 * Once a PF has created VFs, it cannot change how many NQs are
	 * reserved for itself (since the NQs must be contiguous in HW).
	 */
	uint16_t	alloc_msix;
	/*
	 * The number of registered VF's associated with the PF. This field
	 * should be ignored when the request received on the VF interface.
	 * This field will be updated on the PF interface to initiate
	 * the unregister request on PF in the HOT Reset Process.
	 */
	uint16_t	registered_vfs;
	/*
	 * The size of the doorbell BAR in KBytes reserved for L2 including
	 * any area that is shared between L2 and RoCE. The L2 driver
	 * should only map the L2 portion of the doorbell BAR. Any rounding
	 * of the BAR size to the native CPU page size should be performed
	 * by the driver. If the value is zero, no special partitioning
	 * of the doorbell BAR between L2 and RoCE is required.
	 */
	uint16_t	l2_doorbell_bar_size_kb;
	/*
	 * A bitmask indicating the active endpoints. Each bit represents a
	 * specific endpoint, with bit 0 indicating EP 0 and bit 3 indicating
	 * EP 3. For example:
	 * - a single root system would return 0x1
	 * - a 2x8 system (where EPs 0 and 2 are active) would return 0x5
	 * - a 4x4 system (where EPs 0-3 are active) would return 0xF
	 */
	uint8_t	active_endpoints;
	/*
	 * For backward compatibility this field must be set to 1.
	 * Older drivers might look for this field to be 1 before
	 * processing the message.
	 */
	uint8_t	always_1;
	/*
	 * This GRC address location is used by the Host driver interfaces to
	 * poll the adapter ready state to re-initiate the registration process
	 * again after receiving the RESET Notify event.
	 */
	uint32_t	reset_addr_poll;
	/*
	 * This field specifies legacy L2 doorbell size in KBytes. Drivers
	 * should use this value to find out the doorbell page offset from the
	 * BAR.
	 */
	uint16_t	legacy_l2_db_size_kb;
	uint16_t	svif_info;
	/*
	 * This field specifies the source virtual interface of the function
	 * being queried. Drivers can use this to program svif field in the
	 * L2 context table
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_SVIF_INFO_SVIF_MASK	UINT32_C(0x7fff)
	#define HWRM_FUNC_QCFG_OUTPUT_SVIF_INFO_SVIF_SFT	0
	/* This field specifies whether svif is valid or not */
	#define HWRM_FUNC_QCFG_OUTPUT_SVIF_INFO_SVIF_VALID	UINT32_C(0x8000)
	uint8_t	mpc_chnls;
	/*
	 * When this bit is '1', it indicates that a MPC channel with
	 * destination set to the TX crypto engine block is enabled.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_MPC_CHNLS_TCE_ENABLED	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that a MPC channel with
	 * destination set to the RX crypto engine block is enabled.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_MPC_CHNLS_RCE_ENABLED	UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates that a MPC channel with
	 * destination set to the TX configurable flow processing block is
	 * enabled.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_MPC_CHNLS_TE_CFA_ENABLED	UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates that a MPC channel with
	 * destination set to the RX configurable flow processing block is
	 * enabled.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_MPC_CHNLS_RE_CFA_ENABLED	UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates that a MPC channel with
	 * destination set to the primate processor block is enabled.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_MPC_CHNLS_PRIMATE_ENABLED	UINT32_C(0x10)
	/*
	 * Configured doorbell page size for this function.
	 * This field is valid for PF only.
	 */
	uint8_t	db_page_size;
	/* DB page size is 4KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_4KB   UINT32_C(0x0)
	/* DB page size is 8KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_8KB   UINT32_C(0x1)
	/* DB page size is 16KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_16KB  UINT32_C(0x2)
	/* DB page size is 32KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_32KB  UINT32_C(0x3)
	/* DB page size is 64KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_64KB  UINT32_C(0x4)
	/* DB page size is 128KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_128KB UINT32_C(0x5)
	/* DB page size is 256KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_256KB UINT32_C(0x6)
	/* DB page size is 512KB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_512KB UINT32_C(0x7)
	/* DB page size is 1MB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_1MB   UINT32_C(0x8)
	/* DB page size is 2MB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_2MB   UINT32_C(0x9)
	/* DB page size is 4MB. */
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_4MB   UINT32_C(0xa)
	#define HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_LAST HWRM_FUNC_QCFG_OUTPUT_DB_PAGE_SIZE_4MB
	/*
	 * RoCE VNIC ID for the function. If the function does not have a valid
	 * RoCE vnic id, then the roce_vnic_id_valid bit in flags is set to 0.
	 */
	uint16_t	roce_vnic_id;
	/*
	 * Minimum guaranteed bandwidth for the network partition made up
	 * of the caller physical function and all its child virtual
	 * functions. The rate is specified as a percentage of the bandwidth
	 * of the link the partition is associated with. A value of 0
	 * indicates that no minimum bandwidth is configured.
	 * The format of this field is defined to match min_bw, even though
	 * the partition minimum rate is always specified as a percentage.
	 */
	uint32_t	partition_min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_SFT		0
	/*
	 * The granularity of the value (bits or bytes). Firmware never sets
	 * this field.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_SCALE_LAST		HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_SCALE_BYTES
	/* Always percentage of link bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Bandwidth value is in hundredths of a percent of link bandwidth. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_PERCENT1_100
	/*
	 * The maximum bandwidth that may be used by the network partition
	 * made up of the caller physical function and all its child virtual
	 * functions. The rate is specified as a percentage of the bandwidth
	 * of the link the partition is associated with. A value of 0
	 * indicates that no maximum bandwidth is configured.
	 * The format of this field is defined to match max_bw, even though
	 * the partition bandwidth must be specified as a percentage.
	 */
	uint32_t	partition_max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_SFT		0
	/*
	 * The granularity of the value (bits or bytes). Firmware never sets
	 * this field.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_SCALE_LAST		HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_SCALE_BYTES
	/* Always a percentage of link bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in hundredths of a percent of link bandwidth. */
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
		#define HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_PERCENT1_100
	/*
	 * The maximum transmission unit of the function
	 * configured by the host pf/vf.
	 * If the reported mtu value is non-zero then it will be used for the
	 * rings allocated on this function, otherwise the default
	 * value is used if ring MTU is not specified.
	 */
	uint16_t	host_mtu;
	uint16_t	flags2;
	/*
	 * If set to 1, then VF drivers are requested to insert a DSCP
	 * value into all outgoing L2 packets such that DSCP=VF ID modulo 64
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS2_SRIOV_DSCP_INSERT_ENABLED	UINT32_C(0x1)
	uint8_t	unused_4[2];
	/*
	 * KDNet mode for the port for this function. If a VF, KDNet
	 * mode is always disabled.
	 */
	uint8_t	port_kdnet_mode;
	/* KDNet mode is not enabled on the port for this function. */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_KDNET_MODE_DISABLED UINT32_C(0x0)
	/* KDNet mode is enabled on the port for this function. */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_KDNET_MODE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_KDNET_MODE_LAST	HWRM_FUNC_QCFG_OUTPUT_PORT_KDNET_MODE_ENABLED
	/*
	 * If KDNet mode is enabled, the PCI function number of the
	 * KDNet partition.
	 */
	uint8_t	kdnet_pcie_function;
	/*
	 * Function ID of the KDNET function on this port. If the
	 * KDNET partition does not exist and the FW supports this
	 * feature, 0xffff will be returned.
	 */
	uint16_t	port_kdnet_fid;
	uint8_t	unused_5[2];
	/* Number of KTLS Tx Key Contexts allocated. */
	uint32_t	num_ktls_tx_key_ctxs;
	/* Number of KTLS Rx Key Contexts allocated. */
	uint32_t	num_ktls_rx_key_ctxs;
	/*
	 * The LAG idx of this function. The lag_id is per port and the
	 * valid lag_id is from 0 to 7, if there is no valid lag_id,
	 * 0xff will be returned.
	 * This HW lag id is used for Truflow programming only.
	 */
	uint8_t	lag_id;
	/* Partition interface for this function. */
	uint8_t	parif;
	/*
	 * The LAG ID of a hardware link aggregation group (LAG) whose
	 * member ports include the port of this function. The LAG was
	 * previously created using HWRM_FUNC_LAG_CREATE. If the port of this
	 * function is not a member of any LAG, the fw_lag_id will be 0xff.
	 */
	uint8_t	fw_lag_id;
	uint8_t	unused_6;
	/* Number of QUIC Tx Key Contexts allocated. */
	uint32_t	num_quic_tx_key_ctxs;
	/* Number of QUIC Rx Key Contexts allocated. */
	uint32_t	num_quic_rx_key_ctxs;
	/*
	 * Number of AVs per VF. Only valid for PF. This field is ignored
	 * when the flag, l2_vf_resource_mgmt, is not set in RoCE
	 * initialize_fw.
	 */
	uint32_t	roce_max_av_per_vf;
	/*
	 * Number of CQs per VF. Only valid for PF. This field is ignored when
	 * the flag, l2_vf_resource_mgmt, is not set in RoCE initialize_fw.
	 */
	uint32_t	roce_max_cq_per_vf;
	/*
	 * Number of MR/MWs per VF. Only valid for PF. This field is ignored
	 * when the flag, l2_vf_resource_mgmt, is not set in RoCE
	 * initialize_fw.
	 */
	uint32_t	roce_max_mrw_per_vf;
	/*
	 * Number of QPs per VF. Only valid for PF. This field is ignored when
	 * the flag, l2_vf_resource_mgmt, is not set in RoCE initialize_fw.
	 */
	uint32_t	roce_max_qp_per_vf;
	/*
	 * Number of SRQs per VF. Only valid for PF. This field is ignored
	 * when the flag, l2_vf_resource_mgmt, is not set in RoCE
	 * initialize_fw.
	 */
	uint32_t	roce_max_srq_per_vf;
	/*
	 * Number of GIDs per VF. Only valid for PF. This field is ignored
	 * when the flag, l2_vf_resource_mgmt, is not set in RoCE
	 * initialize_fw.
	 */
	uint32_t	roce_max_gid_per_vf;
	/*
	 * Bitmap of context types that have XID partition enabled.
	 * Only valid for PF.
	 */
	uint16_t	xid_partition_cfg;
	/*
	 * When this bit is '1', it indicates that driver enables XID
	 * partition on Tx crypto key contexts.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_XID_PARTITION_CFG_TX_CK	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that driver enables XID
	 * partition on Rx crypto key contexts.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_XID_PARTITION_CFG_RX_CK	UINT32_C(0x2)
	uint8_t	unused_7;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************
 * hwrm_func_cfg *
 *****************/


/* hwrm_func_cfg_input (size:1280b/160B) */

struct hwrm_func_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being
	 * configured.
	 * If set to 0xFF... (All Fs), then the configuration is
	 * for the requesting function.
	 */
	uint16_t	fid;
	/*
	 * This field specifies how many NQs will be reserved for the PF.
	 * Remaining NQs that belong to the PF become available for VFs.
	 * Once a PF has created VFs, it cannot change how many NQs are
	 * reserved for itself (since the NQs must be contiguous in HW).
	 */
	uint16_t	num_msix;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function is disabled with
	 * source MAC address check.
	 * This is an anti-spoofing check. If this flag is set,
	 * then the function shall be configured to disallow
	 * transmission of frames with the source MAC address that
	 * is configured for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_DISABLE	UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is enabled with
	 * source MAC address check.
	 * This is an anti-spoofing check. If this flag is set,
	 * then the function shall be configured to allow
	 * transmission of frames with the source MAC address that
	 * is configured for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_ENABLE	UINT32_C(0x2)
	/* reserved. */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_MASK			UINT32_C(0x1fc)
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_SFT			2
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is requested to be
	 * enabled on the function being configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_ENABLE	UINT32_C(0x200)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then the standard TX ring mode is requested to
	 * be disabled on the function being configured. In this extended
	 * TX ring resource mode, the minimum and maximum bandwidth settings
	 * are not supported to allow the allocation of TX rings to
	 * span multiple scheduler nodes.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_DISABLE	UINT32_C(0x400)
	/*
	 * If this bit is set, virtual mac address configured
	 * in this command will be persistent over warm boot.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_VIRT_MAC_PERSIST		UINT32_C(0x800)
	/*
	 * This bit only applies to the VF. If this bit is set, the statistic
	 * context counters will not be cleared when the statistic context is
	 * freed or a function reset is called on VF. This bit will be
	 * cleared when the PF is unloaded or a function reset is called on
	 * the PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_NO_AUTOCLEAR_STATISTIC	UINT32_C(0x1000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of TX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_TX_ASSETS_TEST		UINT32_C(0x2000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RX_ASSETS_TEST		UINT32_C(0x4000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of CMPL rings) are
	 * available. The firmware will return an error if the requested
	 * assets are not available. The firmware will NOT reserve the assets
	 * if they are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_CMPL_ASSETS_TEST		UINT32_C(0x8000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RSS ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSSCOS_CTX_ASSETS_TEST	UINT32_C(0x10000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of ring groups) are
	 * available. The firmware will return an error if the requested
	 * assets are not available. The firmware will NOT reserve the assets
	 * if they are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RING_GRP_ASSETS_TEST	UINT32_C(0x20000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of stat ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STAT_CTX_ASSETS_TEST	UINT32_C(0x40000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of VNICs) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_VNIC_ASSETS_TEST		UINT32_C(0x80000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of L2 ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_L2_CTX_ASSETS_TEST		UINT32_C(0x100000)
	/*
	 * This configuration change can be initiated by a PF driver. This
	 * configuration request shall be targeted to a VF. From local host
	 * resident HWRM clients, only the parent PF driver shall be allowed
	 * to initiate this change on one of its children VFs. If this bit is
	 * set to 1, then the VF that is being configured is requested to be
	 * trusted.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_TRUSTED_VF_ENABLE		UINT32_C(0x200000)
	/*
	 * When this bit it set, even if PF reserved pool size is zero,
	 * FW will allow driver to create TX rings in ring alloc,
	 * by reserving TX ring, S3 node dynamically.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_DYNAMIC_TX_RING_ALLOC	UINT32_C(0x400000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of NQ rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firmware will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_NQ_ASSETS_TEST		UINT32_C(0x800000)
	/*
	 * This configuration change can be initiated by a PF driver. This
	 * configuration request shall be targeted to a VF. From local host
	 * resident HWRM clients, only the parent PF driver shall be allowed
	 * to initiate this change on one of its children VFs. If this bit is
	 * set to 1, then the VF that is being configured is requested to be
	 * untrusted.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_TRUSTED_VF_DISABLE		UINT32_C(0x1000000)
	/*
	 * This bit is used by preboot drivers on a PF that require access
	 * to the legacy L2 ring model and legacy 32b doorbells. This
	 * feature is not allowed on VFs and is only relevant for devices
	 * that require a context backing store.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_PREBOOT_LEGACY_L2_RINGS	UINT32_C(0x2000000)
	/*
	 * If this bit is set to 0, then the interface does not support hot
	 * reset capability which it advertised with the hot_reset_support
	 * flag in HWRM_FUNC_DRV_RGTR. If any of the function has set this
	 * flag to 0, adapter cannot do the hot reset. In this state, if the
	 * firmware receives a hot reset request, firmware must fail the
	 * request. If this bit is set to 1, then interface is renabling the
	 * hot reset capability.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_HOT_RESET_IF_EN_DIS		UINT32_C(0x4000000)
	/*
	 * If this bit is set to 1, the PF driver is requesting FW
	 * to enable PPP TX PUSH feature on all the TX rings specified in
	 * the num_tx_rings field. By default, the PPP TX push feature is
	 * disabled for all the TX rings of the function. This flag is
	 * ignored if num_tx_rings field is not specified or the function
	 * doesn't support PPP tx push feature.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_PPP_PUSH_MODE_ENABLE	UINT32_C(0x8000000)
	/*
	 * If this bit is set to 1, the PF driver is requesting FW
	 * to disable PPP TX PUSH feature on all the TX rings specified in
	 * the num_tx_rings field. This flag is ignored if num_tx_rings
	 * field is not specified or the function doesn't support PPP tx
	 * push feature.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_PPP_PUSH_MODE_DISABLE	UINT32_C(0x10000000)
	/*
	 * If this bit is set to 1, the driver is requesting FW to enable
	 * the BD_METADATA feature for this function. The FW returns error
	 * on this request if the TX_METADATA is enabled for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_BD_METADATA_ENABLE		UINT32_C(0x20000000)
	/*
	 * If this bit is set to 1, the driver is requesting FW to disable
	 * the BD_METADATA feature for this function. The FW returns error
	 * on this request if the TX_METADATA is enabled for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_BD_METADATA_DISABLE		UINT32_C(0x40000000)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the admin_mtu field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ADMIN_MTU		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the mru field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MRU			UINT32_C(0x2)
	/*
	 * This bit must be '1' for the num_rsscos_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RSSCOS_CTXS	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the num_cmpl_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_CMPL_RINGS	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the num_tx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_TX_RINGS		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the num_rx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RX_RINGS		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the num_l2_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_L2_CTXS		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the num_vnics field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_VNICS		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the num_stat_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_STAT_CTXS		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the dflt_mac_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_MAC_ADDR		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the dflt_vlan field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_VLAN		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the dflt_ip_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_IP_ADDR		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the min_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MIN_BW		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the max_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MAX_BW		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the async_event_cr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ASYNC_EVENT_CR	UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the vlan_antispoof_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_VLAN_ANTISPOOF_MODE	UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the allowed_vlan_pris field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ALLOWED_VLAN_PRIS	UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the evb_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_EVB_MODE		UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the num_mcast_filters field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_MCAST_FILTERS	UINT32_C(0x40000)
	/*
	 * This bit must be '1' for the num_hw_ring_grps field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_HW_RING_GRPS	UINT32_C(0x80000)
	/*
	 * This bit must be '1' for the cache_linesize field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_CACHE_LINESIZE	UINT32_C(0x100000)
	/*
	 * This bit must be '1' for the num_msix field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_MSIX		UINT32_C(0x200000)
	/*
	 * This bit must be '1' for the link admin state field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ADMIN_LINK_STATE	UINT32_C(0x400000)
	/*
	 * This bit must be '1' for the hot_reset_if_en_dis field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_HOT_RESET_IF_SUPPORT	UINT32_C(0x800000)
	/*
	 * This bit must be '1' for the schq_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_SCHQ_ID		UINT32_C(0x1000000)
	/*
	 * This bit must be '1' for the mpc_chnls field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MPC_CHNLS		UINT32_C(0x2000000)
	/*
	 * This bit must be '1' for the partition_min_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_PARTITION_MIN_BW	UINT32_C(0x4000000)
	/*
	 * This bit must be '1' for the partition_max_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_PARTITION_MAX_BW	UINT32_C(0x8000000)
	/*
	 * This bit must be '1' for the tpid field to be
	 * configured. This bit is only valid when dflt_vlan enable
	 * bit is set.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_TPID			UINT32_C(0x10000000)
	/*
	 * This bit must be '1' for the host_mtu field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_HOST_MTU		UINT32_C(0x20000000)
	/*
	 * This bit must be '1' for the num_ktls_tx_key_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_KTLS_TX_KEY_CTXS	UINT32_C(0x40000000)
	/*
	 * This bit must be '1' for the num_ktls_rx_key_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_KTLS_RX_KEY_CTXS	UINT32_C(0x80000000)
	/*
	 * This field can be used by the admin PF to configure
	 * mtu of foster PFs.
	 * The maximum transmission unit of the function.
	 * The HWRM should make sure that the mtu of
	 * the function does not exceed the mtu of the physical
	 * port that this function is associated with.
	 *
	 * In addition to configuring mtu per function, it is
	 * possible to configure mtu per transmit ring.
	 * By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function.
	 * The HWRM should make sure that the mtu of each transmit
	 * ring that is assigned to a function has a valid mtu.
	 */
	uint16_t	admin_mtu;
	/*
	 * The maximum receive unit of the function.
	 * The HWRM should make sure that the mru of
	 * the function does not exceed the mru of the physical
	 * port that this function is associated with.
	 *
	 * In addition to configuring mru per function, it is
	 * possible to configure mru per vnic.
	 * By default, the mru of each vnic associated
	 * with a function is equal to the mru of the function.
	 * The HWRM should make sure that the mru of each vnic
	 * that is assigned to a function has a valid mru.
	 */
	uint16_t	mru;
	/*
	 * The number of RSS/COS contexts requested for the
	 * function.
	 */
	uint16_t	num_rsscos_ctxs;
	/*
	 * The number of completion rings requested for the
	 * function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	num_cmpl_rings;
	/*
	 * The number of transmit rings requested for the function.
	 * This does not include the rings allocated to any
	 * children functions if any.
	 */
	uint16_t	num_tx_rings;
	/*
	 * The number of receive rings requested for the function.
	 * This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	num_rx_rings;
	/* The requested number of L2 contexts for the function. */
	uint16_t	num_l2_ctxs;
	/* The requested number of vnics for the function. */
	uint16_t	num_vnics;
	/* The requested number of statistic contexts for the function. */
	uint16_t	num_stat_ctxs;
	/*
	 * The number of HW ring groups that should
	 * be reserved for this function.
	 */
	uint16_t	num_hw_ring_grps;
	/* The default MAC address for the function being configured. */
	uint8_t	dflt_mac_addr[6];
	/*
	 * The default VLAN for the function being configured.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	dflt_vlan;
	/*
	 * The default IP address for the function being configured.
	 * This address is only used in enabling source property check.
	 */
	uint32_t	dflt_ip_addr[4];
	/*
	 * Minimum guaranteed transmit bandwidth for this function. When
	 * specified for a PF, does not affect traffic from the PF's child VFs.
	 * A value of 0 indicates the minimum bandwidth is not configured.
	 */
	uint32_t	min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_LAST		HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
	/* Invalid unit */
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID	(UINT32_C(0x7) << 29)
		#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum transmit rate for this function. When specified for a PF,
	 * does not affect traffic from the PF's child VFs.
	 * A value of 0 indicates that the maximum bandwidth is not configured.
	 */
	uint32_t	max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_LAST		HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
	/* Invalid unit */
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID	(UINT32_C(0x7) << 29)
		#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	/*
	 * ID of the target completion ring for receiving asynchronous
	 * event completions. If this field is not valid, then the
	 * HWRM shall use the default completion ring of the function
	 * that is being configured as the target completion ring for
	 * providing any asynchronous event completions for that
	 * function.
	 * If this field is valid, then the HWRM shall use the
	 * completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event
	 * completions for the function that is being configured.
	 */
	uint16_t	async_event_cr;
	/* VLAN Anti-spoofing mode. */
	uint8_t	vlan_antispoof_mode;
	/* No VLAN anti-spoofing checks are enabled */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_NOCHECK		UINT32_C(0x0)
	/* Validate VLAN against the configured VLAN(s) */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_VALIDATE_VLAN	UINT32_C(0x1)
	/* Insert VLAN if it does not exist, otherwise discard */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_IF_VLANDNE	UINT32_C(0x2)
	/* Insert VLAN if it does not exist, override VLAN if it exists */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_OR_OVERRIDE_VLAN UINT32_C(0x3)
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_LAST		HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_OR_OVERRIDE_VLAN
	/*
	 * This bit field defines VLAN PRIs that are allowed on
	 * this function.
	 * If nth bit is set, then VLAN PRI n is allowed on this
	 * function.
	 */
	uint8_t	allowed_vlan_pris;
	/*
	 * The evb_mode is configured on a per port basis. The default evb_mode
	 * is configured based on the NVM EVB mode setting upon firmware
	 * initialization. The HWRM allows a PF driver to change EVB mode for a
	 * port used by the PF only when one of the following conditions is
	 * satisfied.
	 * 1. The current operating mode is single function mode.
	 *	(ie. one PF per port)
	 * 2. For SmartNIC, any one of the PAXC PFs is permitted to change the
	 *	EVB mode of the port used by the PAXC PF. None of the X86 PFs
	 *	should have privileges.
	 * The HWRM doesn't permit any PFs to change the underlying EVB mode
	 * when running as MHB or NPAR mode in performance NIC configuration.
	 * The HWRM doesn't permit a VF driver to change the EVB mode.
	 * Once the HWRM determines a function doesn't meet the conditions
	 * to configure the EVB mode, it sets the evb_mode_cfg_not_supported
	 * flag in HWRM_FUNC_QCAPS command response for the function.
	 * The HWRM takes into account the switching of EVB mode from one to
	 * another and reconfigure hardware resources as required. The
	 * switching from VEB to VEPA mode requires the disabling of the
	 * loopback traffic. Additionally, source knockouts are handled
	 * differently in VEB and VEPA modes.
	 */
	uint8_t	evb_mode;
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_NO_EVB UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEB	UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEPA   UINT32_C(0x2)
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_LAST  HWRM_FUNC_CFG_INPUT_EVB_MODE_VEPA
	uint8_t	options;
	/*
	 * This value indicates the PCIE device cache line size.
	 * The cache line size allows the DMA writes to terminate and
	 * start at the cache boundary.
	 */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_MASK	UINT32_C(0x3)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SFT	0
	/* Cache Line Size 64 bytes */
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_64	UINT32_C(0x0)
	/* Cache Line Size 128 bytes */
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_128	UINT32_C(0x1)
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_LAST	HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_128
	/* This value is the virtual link admin state setting. */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_MASK	UINT32_C(0xc)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_SFT	2
	/* Admin state is forced down. */
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_FORCED_DOWN  (UINT32_C(0x0) << 2)
	/* Admin state is forced up. */
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_FORCED_UP	(UINT32_C(0x1) << 2)
	/*
	 * Admin state is in auto mode - is to follow the physical link
	 * state.
	 */
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_AUTO	(UINT32_C(0x2) << 2)
		#define HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_LAST	HWRM_FUNC_CFG_INPUT_OPTIONS_LINK_ADMIN_STATE_AUTO
	/* Reserved for future. */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_RSVD_MASK		UINT32_C(0xf0)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_RSVD_SFT			4
	/*
	 * The number of multicast filters that should
	 * be reserved for this function on the RX side.
	 */
	uint16_t	num_mcast_filters;
	/* Used by a PF driver to associate a SCHQ with a VF. */
	uint16_t	schq_id;
	uint16_t	mpc_chnls;
	/*
	 * When this bit is '1', the caller requests to enable a MPC
	 * channel with destination to the TX crypto engine block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_TCE_ENABLE	UINT32_C(0x1)
	/*
	 * When this bit is '1', the caller requests to disable a MPC
	 * channel with destination to the TX crypto engine block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_TCE_DISABLE	UINT32_C(0x2)
	/*
	 * When this bit is '1', the caller requests to enable a MPC
	 * channel with destination to the RX crypto engine block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_RCE_ENABLE	UINT32_C(0x4)
	/*
	 * When this bit is '1', the caller requests to disable a MPC
	 * channel with destination to the RX crypto engine block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_RCE_DISABLE	UINT32_C(0x8)
	/*
	 * When this bit is '1', the caller requests to enable a MPC
	 * channel with destination to the TX configurable flow processing
	 * block. When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_TE_CFA_ENABLE	UINT32_C(0x10)
	/*
	 * When this bit is '1', the caller requests to disable a MPC
	 * channel with destination to the TX configurable flow processing
	 * block. When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_TE_CFA_DISABLE	UINT32_C(0x20)
	/*
	 * When this bit is '1', the caller requests to enable a MPC
	 * channel with destination to the RX configurable flow processing
	 * block. When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_RE_CFA_ENABLE	UINT32_C(0x40)
	/*
	 * When this bit is '1', the caller requests to disable a MPC
	 * channel with destination to the RX configurable flow processing
	 * block. When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_RE_CFA_DISABLE	UINT32_C(0x80)
	/*
	 * When this bit is '1', the caller requests to enable a MPC
	 * channel with destination to the primate processor block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_PRIMATE_ENABLE	UINT32_C(0x100)
	/*
	 * When this bit is '1', the caller requests to disable a MPC
	 * channel with destination to the primate processor block.
	 * When this bit is '0', this flag has no effect.
	 */
	#define HWRM_FUNC_CFG_INPUT_MPC_CHNLS_PRIMATE_DISABLE	UINT32_C(0x200)
	/*
	 * Minimum guaranteed bandwidth for the network partition made up
	 * of the caller physical function and all its child virtual
	 * functions. The rate is specified as a percentage of the bandwidth
	 * of the link the partition is associated with. A value of 0
	 * indicates that no minimum bandwidth is configured. The sum of the
	 * minimum bandwidths for all partitions on a link must not exceed
	 * 100%.
	 * The format of this field is defined to match min_bw, even though
	 * it does not allow all the options for min_bw at this time.
	 */
	uint32_t	partition_min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_SFT		0
	/*
	 * The granularity of the value (bits or bytes). Firmware ignores
	 * this field.
	 */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_SCALE_LAST		HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_SCALE_BYTES
	/* Bandwidth units. Must be set to percent1_100. */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in hundredths of a percent of link bandwidth. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_PARTITION_MIN_BW_BW_VALUE_UNIT_PERCENT1_100
	/*
	 * The maximum bandwidth that may be used by the network partition
	 * made up of the caller physical function and all its child virtual
	 * functions. The rate is specified as a percentage of the bandwidth
	 * of the link the partition is associated with. A value of 0
	 * indicates that no maximum bandwidth is configured.
	 * The format of this field is defined to match max_bw, even though it
	 * does not allow all the options for max_bw at this time.
	 */
	uint32_t	partition_max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_MASK		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_SFT		0
	/*
	 * The granularity of the value (bits or bytes). Firmware ignores
	 * this field.
	 */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_SCALE			UINT32_C(0x10000000)
	/* Value is in bits. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_SCALE_LAST		HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_SCALE_BYTES
	/* Bandwidth units. Must be set to percent1_100. */
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in hundredths of a percent of link bandwidth. */
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_PERCENT1_100  (UINT32_C(0x1) << 29)
		#define HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_PARTITION_MAX_BW_BW_VALUE_UNIT_PERCENT1_100
	/*
	 * The TPID for the function for which default VLAN
	 * is configured. If the dflt_vlan is not specified
	 * with the TPID, FW returns error. If the TPID is
	 * not specified with dflt_vlan, the default TPID of
	 * 0x8100 will be used. This field is specified in
	 * network byte order.
	 */
	uint16_t	tpid;
	/*
	 * This field can be used by the host PF to configure
	 * mtu value.
	 * The maximum transmission unit of the function.
	 * The HWRM should make sure that the mtu of
	 * the function does not exceed the mtu of the physical
	 * port that this function is associated with.
	 *
	 * In addition to configuring mtu per function, it is
	 * possible to configure mtu per transmit ring.
	 * By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function.
	 * The HWRM should make sure that the mtu of each transmit
	 * ring that is assigned to a function has a valid mtu.
	 */
	uint16_t	host_mtu;
	uint32_t	flags2;
	/*
	 * If this bit is set to 1, the driver is requesting the firmware
	 * to see if the assets (i.e., the number of KTLS key contexts)
	 * requested in this command are available. The firmware will return
	 * an error if the requested assets are not available. The firmware
	 * will NOT reserve the assets if they are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS2_KTLS_KEY_CTX_ASSETS_TEST	UINT32_C(0x1)
	/*
	 * If this bit is set to 1, the driver is requesting the firmware
	 * to see if the assets (i.e., the number of QUIC key contexts)
	 * requested in this command are available. The firmware will return
	 * an error if the requested assets are not available. The firmware
	 * will NOT reserve the assets if they are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS2_QUIC_KEY_CTX_ASSETS_TEST	UINT32_C(0x2)
	uint32_t	enables2;
	/*
	 * This bit must be '1' for the kdnet_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_KDNET		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the db_page_size field to be
	 * configured. Legacy controller core FW may silently ignore
	 * the db_page_size programming request through this command.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_DB_PAGE_SIZE		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the num_quic_tx_key_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_QUIC_TX_KEY_CTXS	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the num_quic_rx_key_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_QUIC_RX_KEY_CTXS	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the roce_max_av_per_vf field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_AV_PER_VF	UINT32_C(0x10)
	/*
	 * This bit must be '1' for the roce_max_cq_per_vf field to be
	 * configured. Only valid for PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_CQ_PER_VF	UINT32_C(0x20)
	/*
	 * This bit must be '1' for the roce_max_mrw_per_vf field to be
	 * configured. Only valid for PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_MRW_PER_VF	UINT32_C(0x40)
	/*
	 * This bit must be '1' for the roce_max_qp_per_vf field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_QP_PER_VF	UINT32_C(0x80)
	/*
	 * This bit must be '1' for the roce_max_srq_per_vf field to be
	 * configured. Only valid for PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_SRQ_PER_VF	UINT32_C(0x100)
	/*
	 * This bit must be '1' for the roce_max_gid_per_vf field to be
	 * configured. Only valid for PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_ROCE_MAX_GID_PER_VF	UINT32_C(0x200)
	/*
	 * This bit must be '1' for the xid_partition_cfg field to be
	 * configured. Only valid for PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES2_XID_PARTITION_CFG	UINT32_C(0x400)
	/*
	 * KDNet mode for the port for this function. If NPAR is
	 * also configured on this port, it takes precedence. KDNet
	 * mode is ignored for a VF.
	 */
	uint8_t	port_kdnet_mode;
	/* KDNet mode is not enabled. */
	#define HWRM_FUNC_CFG_INPUT_PORT_KDNET_MODE_DISABLED UINT32_C(0x0)
	/* KDNet mode enabled. */
	#define HWRM_FUNC_CFG_INPUT_PORT_KDNET_MODE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_CFG_INPUT_PORT_KDNET_MODE_LAST	HWRM_FUNC_CFG_INPUT_PORT_KDNET_MODE_ENABLED
	/*
	 * This field can be used by the PF driver to configure the doorbell
	 * page size. L2 driver can use different pages to ring the doorbell
	 * for L2 push operation. The doorbell page size should be configured
	 * to match the native CPU page size for proper RoCE and L2 doorbell
	 * operations. This value supersedes the older method of configuring
	 * the doorbell page size by the RoCE driver using the command queue
	 * method. The default is 4K.
	 */
	uint8_t	db_page_size;
	/* DB page size is 4KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_4KB   UINT32_C(0x0)
	/* DB page size is 8KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_8KB   UINT32_C(0x1)
	/* DB page size is 16KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_16KB  UINT32_C(0x2)
	/* DB page size is 32KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_32KB  UINT32_C(0x3)
	/* DB page size is 64KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_64KB  UINT32_C(0x4)
	/* DB page size is 128KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_128KB UINT32_C(0x5)
	/* DB page size is 256KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_256KB UINT32_C(0x6)
	/* DB page size is 512KB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_512KB UINT32_C(0x7)
	/* DB page size is 1MB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_1MB   UINT32_C(0x8)
	/* DB page size is 2MB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_2MB   UINT32_C(0x9)
	/* DB page size is 4MB. */
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_4MB   UINT32_C(0xa)
	#define HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_LAST HWRM_FUNC_CFG_INPUT_DB_PAGE_SIZE_4MB
	uint8_t	unused_1[2];
	/* Number of KTLS Tx Key Contexts requested. */
	uint32_t	num_ktls_tx_key_ctxs;
	/* Number of KTLS Rx Key Contexts requested. */
	uint32_t	num_ktls_rx_key_ctxs;
	/* Number of QUIC Tx Key Contexts requested. */
	uint32_t	num_quic_tx_key_ctxs;
	/* Number of QUIC Rx Key Contexts requested. */
	uint32_t	num_quic_rx_key_ctxs;
	/* Number of AVs per VF. Only valid for PF. */
	uint32_t	roce_max_av_per_vf;
	/* Number of CQs per VF. Only valid for PF. */
	uint32_t	roce_max_cq_per_vf;
	/* Number of MR/MWs per VF. Only valid for PF. */
	uint32_t	roce_max_mrw_per_vf;
	/* Number of QPs per VF. Only valid for PF. */
	uint32_t	roce_max_qp_per_vf;
	/* Number of SRQs per VF. Only valid for PF. */
	uint32_t	roce_max_srq_per_vf;
	/* Number of GIDs per VF. Only valid for PF. */
	uint32_t	roce_max_gid_per_vf;
	/*
	 * Bitmap of context types that have XID partition enabled.
	 * Only valid for PF.
	 */
	uint16_t	xid_partition_cfg;
	/*
	 * When this bit is '1', it indicates that driver enables XID
	 * partition on Tx crypto key contexts.
	 */
	#define HWRM_FUNC_CFG_INPUT_XID_PARTITION_CFG_TX_CK	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates that driver enables XID
	 * partition on Rx crypto key contexts.
	 */
	#define HWRM_FUNC_CFG_INPUT_XID_PARTITION_CFG_RX_CK	UINT32_C(0x2)
	uint16_t	unused_2;
} __attribute__((packed));

/* hwrm_func_cfg_output (size:128b/16B) */

struct hwrm_func_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_func_cfg_cmd_err (size:64b/8B) */

struct hwrm_func_cfg_cmd_err {
	/* command specific error codes for the cmd_err field in hwrm_err_output */
	uint8_t	code;
	/* Unknown error. */
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_UNKNOWN			UINT32_C(0x0)
	/* The partition minimum bandwidth is out of range. */
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_PARTITION_MIN_BW_RANGE	UINT32_C(0x1)
	/* The minimum bandwidth is more than the maximum bandwidth. */
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_PARTITION_MIN_MORE_THAN_MAX  UINT32_C(0x2)
	/*
	 * The NIC does not support enforcement of a minimum guaranteed
	 * bandwidth for a partition.
	 */
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_PARTITION_MIN_BW_UNSUPPORTED UINT32_C(0x3)
	/* Partition bandwidths must be specified as a percentage. */
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_PARTITION_BW_PERCENT	UINT32_C(0x4)
	#define HWRM_FUNC_CFG_CMD_ERR_CODE_LAST			HWRM_FUNC_CFG_CMD_ERR_CODE_PARTITION_BW_PERCENT
	uint8_t	unused_0[7];
} __attribute__((packed));

/********************
 * hwrm_func_qstats *
 ********************/


/* hwrm_func_qstats_input (size:192b/24B) */

struct hwrm_func_qstats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 * A privileged PF can query for other function's statistics.
	 */
	uint16_t	fid;
	uint8_t	flags;
	/*
	 * This bit should be set to 1 when request is for only RoCE
	 * statistics. This will be honored only if the caller_fid is
	 * a privileged PF. In all other cases FID and caller_fid should
	 * be the same.
	 */
	#define HWRM_FUNC_QSTATS_INPUT_FLAGS_ROCE_ONLY	UINT32_C(0x1)
	/*
	 * This bit should be set to 1 when request is for the counter mask,
	 * representing the width of each of the stats counters, rather
	 * than counters themselves.
	 */
	#define HWRM_FUNC_QSTATS_INPUT_FLAGS_COUNTER_MASK	UINT32_C(0x2)
	/*
	 * This bit should be set to 1 when request is for only L2
	 * statistics. This will be honored only if the caller_fid is
	 * a privileged PF. In all other cases FID and caller_fid should
	 * be the same.
	 */
	#define HWRM_FUNC_QSTATS_INPUT_FLAGS_L2_ONLY	UINT32_C(0x4)
	uint8_t	unused_0[5];
} __attribute__((packed));

/* hwrm_func_qstats_output (size:1408b/176B) */

struct hwrm_func_qstats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of transmitted unicast packets on the function. */
	uint64_t	tx_ucast_pkts;
	/* Number of transmitted multicast packets on the function. */
	uint64_t	tx_mcast_pkts;
	/* Number of transmitted broadcast packets on the function. */
	uint64_t	tx_bcast_pkts;
	/*
	 * Number of transmitted packets that were discarded due to
	 * internal NIC resource problems. For transmit, this
	 * can only happen if TMP is configured to allow dropping
	 * in HOL blocking conditions, which is not a normal
	 * configuration.
	 */
	uint64_t	tx_discard_pkts;
	/*
	 * Number of dropped packets on transmit path on the function.
	 * These are packets that have been marked for drop by
	 * the TE CFA block or are packets that exceeded the
	 * transmit MTU limit for the function.
	 */
	uint64_t	tx_drop_pkts;
	/* Number of transmitted bytes for unicast traffic on the function. */
	uint64_t	tx_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic on the function. */
	uint64_t	tx_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic on the function. */
	uint64_t	tx_bcast_bytes;
	/* Number of received unicast packets on the function. */
	uint64_t	rx_ucast_pkts;
	/* Number of received multicast packets on the function. */
	uint64_t	rx_mcast_pkts;
	/* Number of received broadcast packets on the function. */
	uint64_t	rx_bcast_pkts;
	/*
	 * Number of received packets that were discarded on the function
	 * due to resource limitations. This can happen for 3 reasons.
	 * # The BD used for the packet has a bad format.
	 * # There were no BDs available in the ring for the packet.
	 * # There were no BDs available on-chip for the packet.
	 */
	uint64_t	rx_discard_pkts;
	/*
	 * Number of dropped packets on received path on the function.
	 * These are packets that have been marked for drop by the
	 * RE CFA.
	 */
	uint64_t	rx_drop_pkts;
	/* Number of received bytes for unicast traffic on the function. */
	uint64_t	rx_ucast_bytes;
	/* Number of received bytes for multicast traffic on the function. */
	uint64_t	rx_mcast_bytes;
	/* Number of received bytes for broadcast traffic on the function. */
	uint64_t	rx_bcast_bytes;
	/* Number of aggregated unicast packets on the function. */
	uint64_t	rx_agg_pkts;
	/* Number of aggregated unicast bytes on the function. */
	uint64_t	rx_agg_bytes;
	/* Number of aggregation events on the function. */
	uint64_t	rx_agg_events;
	/* Number of aborted aggregations on the function. */
	uint64_t	rx_agg_aborts;
	/*
	 * This field is the sequence of the statistics of a function being
	 * cleared. Firmware starts the sequence from zero. It increments
	 * the sequence number every time the statistics of the function
	 * are cleared, which can be triggered by a clear statistics request
	 * or by freeing all statistics contexts of the function. If a user
	 * is interested in knowing if the statistics have been cleared
	 * since the last query, it can keep track of this sequence number
	 * between queries.
	 */
	uint8_t	clear_seq;
	uint8_t	unused_0[6];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_func_qstats_ext *
 ************************/


/* hwrm_func_qstats_ext_input (size:256b/32B) */

struct hwrm_func_qstats_ext_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 * A privileged PF can query for other function's statistics.
	 */
	uint16_t	fid;
	uint8_t	flags;
	/*
	 * This bit should be set to 1 when request is for only RoCE
	 * statistics. This will be honored only if the caller_fid is
	 * a privileged PF. In all other cases FID and caller_fid should
	 * be the same.
	 */
	#define HWRM_FUNC_QSTATS_EXT_INPUT_FLAGS_ROCE_ONLY	UINT32_C(0x1)
	/*
	 * This bit should be set to 1 when request is for the counter mask
	 * representing the width of each of the stats counters, rather
	 * than counters themselves.
	 */
	#define HWRM_FUNC_QSTATS_EXT_INPUT_FLAGS_COUNTER_MASK	UINT32_C(0x2)
	uint8_t	unused_0[1];
	uint32_t	enables;
	/*
	 * This bit must be '1' for the schq_id and traffic_class fields to
	 * be configured.
	 */
	#define HWRM_FUNC_QSTATS_EXT_INPUT_ENABLES_SCHQ_ID	UINT32_C(0x1)
	/* Specifies the SCHQ for which to gather statistics */
	uint16_t	schq_id;
	/*
	 * Specifies the traffic class for which to gather statistics. Valid
	 * values are 0 through (max_configurable_queues - 1), where
	 * max_configurable_queues is in the response of HWRM_QUEUE_QPORTCFG
	 */
	uint16_t	traffic_class;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_func_qstats_ext_output (size:1536b/192B) */

struct hwrm_func_qstats_ext_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of received unicast packets */
	uint64_t	rx_ucast_pkts;
	/* Number of received multicast packets */
	uint64_t	rx_mcast_pkts;
	/* Number of received broadcast packets */
	uint64_t	rx_bcast_pkts;
	/* Number of discarded packets on received path */
	uint64_t	rx_discard_pkts;
	/* Number of packets on receive path with error */
	uint64_t	rx_error_pkts;
	/* Number of received bytes for unicast traffic */
	uint64_t	rx_ucast_bytes;
	/* Number of received bytes for multicast traffic */
	uint64_t	rx_mcast_bytes;
	/* Number of received bytes for broadcast traffic */
	uint64_t	rx_bcast_bytes;
	/* Number of transmitted unicast packets */
	uint64_t	tx_ucast_pkts;
	/* Number of transmitted multicast packets */
	uint64_t	tx_mcast_pkts;
	/* Number of transmitted broadcast packets */
	uint64_t	tx_bcast_pkts;
	/* Number of packets on transmit path with error */
	uint64_t	tx_error_pkts;
	/* Number of discarded packets on transmit path */
	uint64_t	tx_discard_pkts;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t	tx_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t	tx_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t	tx_bcast_bytes;
	/* Number of TPA eligible packets */
	uint64_t	rx_tpa_eligible_pkt;
	/* Number of TPA eligible bytes */
	uint64_t	rx_tpa_eligible_bytes;
	/* Number of TPA packets */
	uint64_t	rx_tpa_pkt;
	/* Number of TPA bytes */
	uint64_t	rx_tpa_bytes;
	/* Number of TPA errors */
	uint64_t	rx_tpa_errors;
	/* Number of TPA errors */
	uint64_t	rx_tpa_events;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_func_clr_stats *
 ***********************/


/* hwrm_func_clr_stats_input (size:192b/24B) */

struct hwrm_func_clr_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_clr_stats_output (size:128b/16B) */

struct hwrm_func_clr_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_vf_resc_free *
 **************************/


/* hwrm_func_vf_resc_free_input (size:192b/24B) */

struct hwrm_func_vf_resc_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_vf_resc_free_output (size:128b/16B) */

struct hwrm_func_vf_resc_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_drv_rgtr *
 **********************/


/* hwrm_func_drv_rgtr_input (size:896b/112B) */

struct hwrm_func_drv_rgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function driver is requesting
	 * all requests from its children VF drivers to be
	 * forwarded to itself.
	 * This flag can only be set by the PF driver.
	 * If a VF driver sets this flag, it should be ignored
	 * by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_ALL_MODE			UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is requesting none of
	 * the requests from its children VF drivers to be
	 * forwarded to itself.
	 * This flag can only be set by the PF driver.
	 * If a VF driver sets this flag, it should be ignored
	 * by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_NONE_MODE			UINT32_C(0x2)
	/*
	 * When this bit is '1', then ver_maj_8b, ver_min_8b, ver_upd_8b
	 * fields shall be ignored and ver_maj, ver_min, ver_upd
	 * and ver_patch shall be used for the driver version information.
	 * When this bit is '0', then ver_maj_8b, ver_min_8b, ver_upd_8b
	 * fields shall be used for the driver version information and
	 * ver_maj, ver_min, ver_upd and ver_patch shall be ignored.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_16BIT_VER_MODE		UINT32_C(0x4)
	/*
	 * When this bit is '1', the function is indicating support of
	 * 64bit flow handle. The firmware that only supports 64bit flow
	 * handle should check this bit before allowing processing of
	 * HWRM_CFA_FLOW_XXX commands from the requesting function as
	 * firmware with 64bit flow handle support can only be compatible
	 * with drivers that support 64bit flow handle. The legacy drivers
	 * that don't support 64bit flow handle won't be able to use
	 * HWRM_CFA_FLOW_XXX commands when running with new firmware that
	 * only supports 64bit flow handle. The new firmware support 64bit
	 * flow handle returns HWRM_ERR_CODE_CMD_NOT_SUPPORTED
	 * status to the legacy driver when encounters these commands.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FLOW_HANDLE_64BIT_MODE	UINT32_C(0x8)
	/*
	 * When this bit is '1', the function is indicating support of
	 * Hot Reset. The driver interface will destroy the resources,
	 * unregister the function and register again up on receiving
	 * the RESET_NOTIFY Async notification from the core firmware.
	 * The core firmware will this use flag and trigger the Hot Reset
	 * process only if all the registered driver instances are capable
	 * of this support.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_HOT_RESET_SUPPORT		UINT32_C(0x10)
	/*
	 * When this bit is 1, the function is indicating the support of the
	 * error recovery capability. Error recovery support will be used by
	 * firmware only if all the driver instances support error recovery
	 * process. By setting this bit, driver is indicating support for
	 * corresponding async event completion message. These will be
	 * delivered to the driver even if they did not register for it.
	 * If supported, after receiving reset notify async event with fatal
	 * flag set in event data1, then all the drivers have to tear down
	 * their resources without sending any HWRM commands to FW.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_ERROR_RECOVERY_SUPPORT	UINT32_C(0x20)
	/*
	 * When this bit is 1, the function is indicating the support of the
	 * Master capability. The Firmware will use this capability to select
	 * the Master function. The master function will be used to initiate
	 * designated functionality like error recovery etc. If none of the
	 * registered PF's or trusted VF's indicate this support, then
	 * firmware will select the 1st registered PF as Master capable
	 * instance.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_MASTER_SUPPORT		UINT32_C(0x40)
	/*
	 * When this bit is 1, the function is indicating the support of the
	 * fast reset capability. Fast reset support will be used by
	 * firmware only if all the driver instances support fast reset
	 * process. By setting this bit, driver is indicating support for
	 * corresponding async event completion message. These will be
	 * delivered to the driver even if they did not register for it.
	 * If supported, after receiving reset notify async event with fast
	 * reset flag set in event data1, then all the drivers have to tear
	 * down their resources without sending any HWRM commands to FW.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FAST_RESET_SUPPORT		UINT32_C(0x80)
	/*
	 * When this bit is 1, the function's driver is indicating the
	 * support of handling the vnic_rss_cfg's INVALID_PARAM error
	 * returned by firmware. Firmware returns error, if host driver
	 * configures the invalid hash_types bit combination for a given
	 * IP version.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_RSS_STRICT_HASH_TYPE_SUPPORT	UINT32_C(0x100)
	/*
	 * When this bit is 1, the function's driver is indicating the
	 * support of handling the NPAR 1.2 feature where the s-tag may be
	 * a value other than 0x8100 or 0x88a8.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_NPAR_1_2_SUPPORT		UINT32_C(0x200)
	/*
	 * When this bit is 1, the function's driver is indicating the
	 * support for asymmetric queue configuration, such that queue
	 * ids and service profiles on TX side are not the same as the
	 * corresponding queue configuration on the RX side
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_ASYM_QUEUE_CFG_SUPPORT	UINT32_C(0x400)
	/*
	 * When this bit is 1, the function's driver is indicating to the
	 * firmware that the Ingress NIC flows will be programmed by the
	 * TruFlow application and the firmware flow manager should reject
	 * flow-create commands that programs ingress lookup flows for this
	 * function.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_TF_INGRESS_NIC_FLOW_MODE	UINT32_C(0x800)
	/*
	 * When this bit is 1, the function's driver is indicating to the
	 * firmware that the Egress NIC flows will be programmed by the
	 * TruFlow application and the firmware flow manager should reject
	 * flow-create commands that programs Egress lookup flows for this
	 * function.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_TF_EGRESS_NIC_FLOW_MODE	UINT32_C(0x1000)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the os_type field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_OS_TYPE		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the ver field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VER		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the timestamp field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_TIMESTAMP	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vf_req_fwd field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VF_REQ_FWD	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the async_event_fwd field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_ASYNC_EVENT_FWD	UINT32_C(0x10)
	/*
	 * This value indicates the type of OS. The values are based on
	 * CIM_OperatingSystem.mof file as published by the DMTF.
	 */
	uint16_t	os_type;
	/* Unknown */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UNKNOWN   UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_OTHER	UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_MSDOS	UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WINDOWS   UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_SOLARIS   UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_LINUX	UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_FREEBSD   UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_ESXI	UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN864	UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN2012R2 UINT32_C(0x74)
	/* UEFI driver. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UEFI	UINT32_C(0x8000)
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_LAST	HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UEFI
	/* This is the 8bit major version of the driver. */
	uint8_t	ver_maj_8b;
	/* This is the 8bit minor version of the driver. */
	uint8_t	ver_min_8b;
	/* This is the 8bit update version of the driver. */
	uint8_t	ver_upd_8b;
	uint8_t	unused_0[3];
	/*
	 * This is a 32-bit timestamp provided by the driver for
	 * keep alive.
	 * The timestamp is in multiples of 1ms.
	 */
	uint32_t	timestamp;
	uint8_t	unused_1[4];
	/*
	 * This is a 256-bit bit mask provided by the PF driver for
	 * letting the HWRM know what commands issued by the VF driver
	 * to the HWRM should be forwarded to the PF driver.
	 * Nth bit refers to the Nth req_type.
	 *
	 * Setting Nth bit to 1 indicates that requests from the
	 * VF driver with req_type equal to N shall be forwarded to
	 * the parent PF driver.
	 *
	 * This field is not valid for the VF driver.
	 */
	uint32_t	vf_req_fwd[8];
	/*
	 * This is a 256-bit bit mask provided by the function driver
	 * (PF or VF driver) to indicate the list of asynchronous event
	 * completions to be forwarded.
	 *
	 * Nth bit refers to the Nth event_id.
	 *
	 * Setting Nth bit to 1 by the function driver shall result in
	 * the HWRM forwarding asynchronous event completion with
	 * event_id equal to N.
	 *
	 * If all bits are set to 0 (value of 0), then the HWRM shall
	 * not forward any asynchronous event completion to this
	 * function driver.
	 */
	uint32_t	async_event_fwd[8];
	/* This is the 16bit major version of the driver. */
	uint16_t	ver_maj;
	/* This is the 16bit minor version of the driver. */
	uint16_t	ver_min;
	/* This is the 16bit update version of the driver. */
	uint16_t	ver_upd;
	/* This is the 16bit patch version of the driver. */
	uint16_t	ver_patch;
} __attribute__((packed));

/* hwrm_func_drv_rgtr_output (size:128b/16B) */

struct hwrm_func_drv_rgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When this bit is '1', it indicates that the
	 * HWRM_FUNC_DRV_IF_CHANGE call is supported.
	 */
	#define HWRM_FUNC_DRV_RGTR_OUTPUT_FLAGS_IF_CHANGE_SUPPORTED	UINT32_C(0x1)
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_func_drv_unrgtr *
 ************************/


/* hwrm_func_drv_unrgtr_input (size:192b/24B) */

struct hwrm_func_drv_unrgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function driver is notifying
	 * the HWRM to prepare for the shutdown.
	 */
	#define HWRM_FUNC_DRV_UNRGTR_INPUT_FLAGS_PREPARE_FOR_SHUTDOWN	UINT32_C(0x1)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_drv_unrgtr_output (size:128b/16B) */

struct hwrm_func_drv_unrgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_buf_rgtr *
 **********************/


/* hwrm_func_buf_rgtr_input (size:1024b/128B) */

struct hwrm_func_buf_rgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_VF_ID		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the err_buf_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_ERR_BUF_ADDR	UINT32_C(0x2)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	/*
	 * This field represents the number of pages used for request
	 * buffer(s).
	 */
	uint16_t	req_buf_num_pages;
	/*
	 * This field represents the page size used for request
	 * buffer(s).
	 */
	uint16_t	req_buf_page_size;
	/* 16 bytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_16B UINT32_C(0x4)
	/* 4 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4K  UINT32_C(0xc)
	/* 8 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_8K  UINT32_C(0xd)
	/* 64 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_64K UINT32_C(0x10)
	/* 2 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_2M  UINT32_C(0x15)
	/* 4 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4M  UINT32_C(0x16)
	/* 1 Gbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_1G  UINT32_C(0x1e)
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_LAST HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_1G
	/* The length of the request buffer per VF in bytes. */
	uint16_t	req_buf_len;
	/* The length of the response buffer in bytes. */
	uint16_t	resp_buf_len;
	uint8_t	unused_0[2];
	/* This field represents the page address of page #0. */
	uint64_t	req_buf_page_addr0;
	/* This field represents the page address of page #1. */
	uint64_t	req_buf_page_addr1;
	/* This field represents the page address of page #2. */
	uint64_t	req_buf_page_addr2;
	/* This field represents the page address of page #3. */
	uint64_t	req_buf_page_addr3;
	/* This field represents the page address of page #4. */
	uint64_t	req_buf_page_addr4;
	/* This field represents the page address of page #5. */
	uint64_t	req_buf_page_addr5;
	/* This field represents the page address of page #6. */
	uint64_t	req_buf_page_addr6;
	/* This field represents the page address of page #7. */
	uint64_t	req_buf_page_addr7;
	/* This field represents the page address of page #8. */
	uint64_t	req_buf_page_addr8;
	/* This field represents the page address of page #9. */
	uint64_t	req_buf_page_addr9;
	/*
	 * This field is used to receive the error reporting from
	 * the chipset. Only applicable for PFs.
	 */
	uint64_t	error_buf_addr;
	/*
	 * This field is used to receive the response forwarded by the
	 * HWRM.
	 */
	uint64_t	resp_buf_addr;
} __attribute__((packed));

/* hwrm_func_buf_rgtr_output (size:128b/16B) */

struct hwrm_func_buf_rgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_func_buf_unrgtr *
 ************************/


/* hwrm_func_buf_unrgtr_input (size:192b/24B) */

struct hwrm_func_buf_unrgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_UNRGTR_INPUT_ENABLES_VF_ID	UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_func_buf_unrgtr_output (size:128b/16B) */

struct hwrm_func_buf_unrgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_drv_qver *
 **********************/


/* hwrm_func_drv_qver_input (size:192b/24B) */

struct hwrm_func_drv_qver_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Reserved for future use. */
	uint32_t	reserved;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	/*
	 * This field is used to indicate the driver type.
	 * L2 or RoCE
	 */
	uint8_t	driver_type;
	/* L2 driver version */
	#define HWRM_FUNC_DRV_QVER_INPUT_DRIVER_TYPE_L2   UINT32_C(0x0)
	/* RoCE driver version */
	#define HWRM_FUNC_DRV_QVER_INPUT_DRIVER_TYPE_ROCE UINT32_C(0x1)
	#define HWRM_FUNC_DRV_QVER_INPUT_DRIVER_TYPE_LAST HWRM_FUNC_DRV_QVER_INPUT_DRIVER_TYPE_ROCE
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_func_drv_qver_output (size:256b/32B) */

struct hwrm_func_drv_qver_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This value indicates the type of OS. The values are based on
	 * CIM_OperatingSystem.mof file as published by the DMTF.
	 */
	uint16_t	os_type;
	/* Unknown */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UNKNOWN   UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_OTHER	UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_MSDOS	UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WINDOWS   UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_SOLARIS   UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_LINUX	UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_FREEBSD   UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_ESXI	UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN864	UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN2012R2 UINT32_C(0x74)
	/* UEFI driver. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UEFI	UINT32_C(0x8000)
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_LAST	HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UEFI
	/* This is the 8bit major version of the driver. */
	uint8_t	ver_maj_8b;
	/* This is the 8bit minor version of the driver. */
	uint8_t	ver_min_8b;
	/* This is the 8bit update version of the driver. */
	uint8_t	ver_upd_8b;
	uint8_t	unused_0[3];
	/* This is the 16bit major version of the driver. */
	uint16_t	ver_maj;
	/* This is the 16bit minor version of the driver. */
	uint16_t	ver_min;
	/* This is the 16bit update version of the driver. */
	uint16_t	ver_upd;
	/* This is the 16bit patch version of the driver. */
	uint16_t	ver_patch;
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_func_resource_qcaps *
 ****************************/


/* hwrm_func_resource_qcaps_input (size:192b/24B) */

struct hwrm_func_resource_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_resource_qcaps_output (size:704b/88B) */

struct hwrm_func_resource_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Maximum guaranteed number of VFs supported by PF. Not applicable for
	 * VFs.
	 */
	uint16_t	max_vfs;
	/* Maximum guaranteed number of MSI-X vectors supported by function. */
	uint16_t	max_msix;
	/*
	 * Hint of strategy to be used by PF driver to reserve resources for
	 * its VF.
	 */
	uint16_t	vf_reservation_strategy;
	/*
	 * The PF driver should evenly divide its remaining resources among
	 * all VFs.
	 */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MAXIMAL	UINT32_C(0x0)
	/* The PF driver should only reserve minimal resources for each VF. */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL	UINT32_C(0x1)
	/*
	 * The PF driver should not reserve any resources for each VF until
	 * the VF interface is brought up.
	 */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL_STATIC UINT32_C(0x2)
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_LAST	HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL_STATIC
	/* Minimum guaranteed number of RSS/COS contexts. */
	uint16_t	min_rsscos_ctx;
	/* Maximum non-guaranteed number of RSS/COS contexts */
	uint16_t	max_rsscos_ctx;
	/* Minimum guaranteed number of completion rings */
	uint16_t	min_cmpl_rings;
	/* Maximum non-guaranteed number of completion rings */
	uint16_t	max_cmpl_rings;
	/* Minimum guaranteed number of transmit rings */
	uint16_t	min_tx_rings;
	/* Maximum non-guaranteed number of transmit rings */
	uint16_t	max_tx_rings;
	/* Minimum guaranteed number of receive rings */
	uint16_t	min_rx_rings;
	/* Maximum non-guaranteed number of receive rings */
	uint16_t	max_rx_rings;
	/* Minimum guaranteed number of L2 contexts */
	uint16_t	min_l2_ctxs;
	/* Maximum non-guaranteed number of L2 contexts */
	uint16_t	max_l2_ctxs;
	/* Minimum guaranteed number of VNICs */
	uint16_t	min_vnics;
	/* Maximum non-guaranteed number of VNICs */
	uint16_t	max_vnics;
	/* Minimum guaranteed number of statistic contexts */
	uint16_t	min_stat_ctx;
	/* Maximum non-guaranteed number of statistic contexts */
	uint16_t	max_stat_ctx;
	/* Minimum guaranteed number of ring groups */
	uint16_t	min_hw_ring_grps;
	/* Maximum non-guaranteed number of ring groups */
	uint16_t	max_hw_ring_grps;
	/*
	 * Maximum number of inputs into the transmit scheduler for this
	 * function. The number of TX rings assigned to the function cannot
	 * exceed this value.
	 */
	uint16_t	max_tx_scheduler_inputs;
	uint16_t	flags;
	/*
	 * When this bit is '1', it indicates that VF_RESOURCE_CFG supports
	 * feature to reserve all minimum resources when minimum >= 1,
	 * otherwise returns an error.
	 */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_FLAGS_MIN_GUARANTEED	UINT32_C(0x1)
	/* Minimum guaranteed number of MSI-X vectors supported by function */
	uint16_t	min_msix;
	/* Minimum guaranteed number of KTLS Tx Key Contexts */
	uint32_t	min_ktls_tx_key_ctxs;
	/* Maximum non-guaranteed number of KTLS Tx Key Contexts */
	uint32_t	max_ktls_tx_key_ctxs;
	/* Minimum guaranteed number of KTLS Rx Key Contexts */
	uint32_t	min_ktls_rx_key_ctxs;
	/* Maximum non-guaranteed number of KTLS Rx Key Contexts */
	uint32_t	max_ktls_rx_key_ctxs;
	/* Minimum guaranteed number of QUIC Tx Key Contexts */
	uint32_t	min_quic_tx_key_ctxs;
	/* Maximum non-guaranteed number of QUIC Tx Key Contexts */
	uint32_t	max_quic_tx_key_ctxs;
	/* Minimum guaranteed number of QUIC Rx Key Contexts */
	uint32_t	min_quic_rx_key_ctxs;
	/* Maximum non-guaranteed number of QUIC Rx Key Contexts */
	uint32_t	max_quic_rx_key_ctxs;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_func_vf_resource_cfg *
 *****************************/


/* hwrm_func_vf_resource_cfg_input (size:704b/88B) */

struct hwrm_func_vf_resource_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VF ID that is being configured by PF */
	uint16_t	vf_id;
	/* Maximum guaranteed number of MSI-X vectors for the function */
	uint16_t	max_msix;
	/* Minimum guaranteed number of RSS/COS contexts */
	uint16_t	min_rsscos_ctx;
	/* Maximum non-guaranteed number of RSS/COS contexts */
	uint16_t	max_rsscos_ctx;
	/* Minimum guaranteed number of completion rings */
	uint16_t	min_cmpl_rings;
	/* Maximum non-guaranteed number of completion rings */
	uint16_t	max_cmpl_rings;
	/* Minimum guaranteed number of transmit rings */
	uint16_t	min_tx_rings;
	/* Maximum non-guaranteed number of transmit rings */
	uint16_t	max_tx_rings;
	/* Minimum guaranteed number of receive rings */
	uint16_t	min_rx_rings;
	/* Maximum non-guaranteed number of receive rings */
	uint16_t	max_rx_rings;
	/* Minimum guaranteed number of L2 contexts */
	uint16_t	min_l2_ctxs;
	/* Maximum non-guaranteed number of L2 contexts */
	uint16_t	max_l2_ctxs;
	/* Minimum guaranteed number of VNICs */
	uint16_t	min_vnics;
	/* Maximum non-guaranteed number of VNICs */
	uint16_t	max_vnics;
	/* Minimum guaranteed number of statistic contexts */
	uint16_t	min_stat_ctx;
	/* Maximum non-guaranteed number of statistic contexts */
	uint16_t	max_stat_ctx;
	/* Minimum guaranteed number of ring groups */
	uint16_t	min_hw_ring_grps;
	/* Maximum non-guaranteed number of ring groups */
	uint16_t	max_hw_ring_grps;
	uint16_t	flags;
	/*
	 * If this bit is set, all minimum resources requested should be
	 * reserved if minimum >= 1, otherwise return error. In case of
	 * error, keep all existing reservations before the call.
	 */
	#define HWRM_FUNC_VF_RESOURCE_CFG_INPUT_FLAGS_MIN_GUARANTEED	UINT32_C(0x1)
	/* Minimum guaranteed number of MSI-X vectors for the function */
	uint16_t	min_msix;
	/* Minimum guaranteed number of KTLS Tx Key Contexts */
	uint32_t	min_ktls_tx_key_ctxs;
	/* Maximum non-guaranteed number of KTLS Tx Key Contexts */
	uint32_t	max_ktls_tx_key_ctxs;
	/* Minimum guaranteed number of KTLS Rx Key Contexts */
	uint32_t	min_ktls_rx_key_ctxs;
	/* Maximum non-guaranteed number of KTLS Rx Key Contexts */
	uint32_t	max_ktls_rx_key_ctxs;
	/* Minimum guaranteed number of QUIC Tx Key Contexts */
	uint32_t	min_quic_tx_key_ctxs;
	/* Maximum non-guaranteed number of QUIC Tx Key Contexts */
	uint32_t	max_quic_tx_key_ctxs;
	/* Minimum guaranteed number of QUIC Rx Key Contexts */
	uint32_t	min_quic_rx_key_ctxs;
	/* Maximum non-guaranteed number of QUIC Rx Key Contexts */
	uint32_t	max_quic_rx_key_ctxs;
} __attribute__((packed));

/* hwrm_func_vf_resource_cfg_output (size:384b/48B) */

struct hwrm_func_vf_resource_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Reserved number of RSS/COS contexts */
	uint16_t	reserved_rsscos_ctx;
	/* Reserved number of completion rings */
	uint16_t	reserved_cmpl_rings;
	/* Reserved number of transmit rings */
	uint16_t	reserved_tx_rings;
	/* Reserved number of receive rings */
	uint16_t	reserved_rx_rings;
	/* Reserved number of L2 contexts */
	uint16_t	reserved_l2_ctxs;
	/* Reserved number of VNICs */
	uint16_t	reserved_vnics;
	/* Reserved number of statistic contexts */
	uint16_t	reserved_stat_ctx;
	/* Reserved number of ring groups */
	uint16_t	reserved_hw_ring_grps;
	/* Actual number of KTLS Tx Key Contexts reserved */
	uint32_t	reserved_ktls_tx_key_ctxs;
	/* Actual number of KTLS Rx Key Contexts reserved */
	uint32_t	reserved_ktls_rx_key_ctxs;
	/* Actual number of QUIC Tx Key Contexts reserved */
	uint32_t	reserved_quic_tx_key_ctxs;
	/* Actual number of QUIC Rx Key Contexts reserved */
	uint32_t	reserved_quic_rx_key_ctxs;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************************
 * hwrm_func_backing_store_qcaps *
 *********************************/


/* hwrm_func_backing_store_qcaps_input (size:128b/16B) */

struct hwrm_func_backing_store_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_func_backing_store_qcaps_output (size:832b/104B) */

struct hwrm_func_backing_store_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Maximum number of QP context entries supported for this function. */
	uint32_t	qp_max_entries;
	/*
	 * Minimum number of QP context entries that are needed to be reserved
	 * for QP1 for the PF and its VFs. PF drivers must allocate at least
	 * this many QP context entries, even if RoCE will not be used.
	 */
	uint16_t	qp_min_qp1_entries;
	/*
	 * Maximum number of QP context entries that can be used for L2 and
	 * mid-path.
	 */
	uint16_t	qp_max_l2_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	qp_entry_size;
	/* Maximum number of SRQ context entries that can be used for L2. */
	uint16_t	srq_max_l2_entries;
	/* Maximum number of SRQ context entries supported for this function. */
	uint32_t	srq_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	srq_entry_size;
	/* Maximum number of CQ context entries that can be used for L2. */
	uint16_t	cq_max_l2_entries;
	/* Maximum number of CQ context entries supported for this function. */
	uint32_t	cq_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	cq_entry_size;
	/* Maximum number of VNIC context entries supported for this function. */
	uint16_t	vnic_max_vnic_entries;
	/*
	 * Maximum number of Ring table context entries supported for this
	 * function.
	 */
	uint16_t	vnic_max_ring_table_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	vnic_entry_size;
	/*
	 * Maximum number of statistic context entries supported for this
	 * function.
	 */
	uint32_t	stat_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	stat_entry_size;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	tqm_entry_size;
	/* Minimum number of TQM context entries required per ring. */
	uint32_t	tqm_min_entries_per_ring;
	/*
	 * Maximum number of TQM context entries supported per ring. This is
	 * actually a recommended TQM queue size based on worst case usage of
	 * the TQM queue.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * TQM slowpath rings should be sized as follows:
	 *
	 * num_entries = num_vnics + num_l2_tx_rings + 2 * num_roce_qps + tqm_min_size
	 *
	 * Where:
	 *   num_vnics is the number of VNICs allocated in the VNIC backing
	 *   store
	 *   num_l2_tx_rings is the number of L2 rings in the QP backing store
	 *   num_roce_qps is the number of RoCE QPs in the QP backing store
	 *   tqm_min_size is tqm_min_entries_per_ring reported by
	 *	HWRM_FUNC_BACKING_STORE_QCAPS
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_max_entries_per_ring;
	/*
	 * Maximum number of MR plus AV context entries supported for this
	 * function.
	 */
	uint32_t	mrav_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	mrav_entry_size;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	tim_entry_size;
	/* Maximum number of Timer context entries supported for this function. */
	uint32_t	tim_max_entries;
	/*
	 * When this field is zero, the 32b `mrav_num_entries` field in the
	 * `backing_store_cfg` and `backing_store_qcfg` commands represents
	 * the total number of MR plus AV entries allowed in the MR/AV backing
	 * store PBL.
	 *
	 * When this field is non-zero, the 32b `mrav_num_entries` field in
	 * the `backing_store_cfg` and `backing_store_qcfg` commands is
	 * logically divided into two 16b fields. Bits `[31:16]` represents
	 * the `mr_num_entries` and bits `[15:0]` represents `av_num_entries`.
	 * Both of these values are represented in a unit granularity
	 * specified by this field. For example, if this field is 16 and
	 * `mrav_num_entries` is `0x02000100`, then the number of MR entries
	 * is 8192 and the number of AV entries is 4096.
	 */
	uint16_t	mrav_num_entries_units;
	/*
	 * The number of entries specified for any TQM ring must be a
	 * multiple of this value to prevent any resource allocation
	 * limitations.
	 */
	uint8_t	tqm_entries_multiple;
	/*
	 * Initializer to be used by drivers
	 * to initialize context memory to ensure
	 * context subsystem flags an error for an attack
	 * before the first time context load.
	 */
	uint8_t	ctx_kind_initializer;
	/*
	 * Specifies which context kinds need to be initialized with the
	 * ctx_kind_initializer.
	 */
	uint16_t	ctx_init_mask;
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_QP	UINT32_C(0x1)
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_SRQ	UINT32_C(0x2)
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_CQ	UINT32_C(0x4)
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_VNIC	UINT32_C(0x8)
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_STAT	UINT32_C(0x10)
	/*
	 * If this bit is '1' then this context type should be initialized
	 * with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_MRAV	UINT32_C(0x20)
	/*
	 * If this bit is '1' then the Tx KTLS context type should be
	 * initialized with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_TKC	UINT32_C(0x40)
	/*
	 * If this bit is '1' then the Rx KTLS context type should be
	 * initialized with the ctx_kind_initializer at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_OUTPUT_CTX_INIT_MASK_RKC	UINT32_C(0x80)
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	qp_init_offset;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	srq_init_offset;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	cq_init_offset;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	vnic_init_offset;
	/*
	 * Count of TQM fastpath rings to be used for allocating backing store.
	 * Backing store configuration must be specified for each TQM ring from
	 * this count in `backing_store_cfg`.
	 * Only first 8 TQM FP rings will be advertised with this field.
	 */
	uint8_t	tqm_fp_rings_count;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	stat_init_offset;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for this
	 * context type.
	 */
	uint8_t	mrav_init_offset;
	/*
	 * Count of TQM extended fastpath rings to be used for allocating
	 * backing store beyond 8 rings(rings 9,10,11)
	 * Backing store configuration must be specified for each TQM ring from
	 * this count in `backing_store_cfg`.
	 */
	uint8_t	tqm_fp_rings_count_ext;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for Tx
	 * KTLS context type.
	 */
	uint8_t	tkc_init_offset;
	/*
	 * Specifies the doubleword offset of ctx_kind_initializer for Rx
	 * KTLS context type.
	 */
	uint8_t	rkc_init_offset;
	/* Tx KTLS context entry size in bytes. */
	uint16_t	tkc_entry_size;
	/* Rx KTLS context entry size in bytes. */
	uint16_t	rkc_entry_size;
	/*
	 * Maximum number of Tx KTLS context entries supported for this
	 * function.
	 */
	uint32_t	tkc_max_entries;
	/*
	 * Maximum number of Rx KTLS context entries supported for this
	 * function.
	 */
	uint32_t	rkc_max_entries;
	/*
	 * Additional number of RoCE QP context entries required for this
	 * function to support fast QP destroy feature.
	 */
	uint16_t	fast_qpmd_qp_num_entries;
	/* Reserved for future. */
	uint8_t	rsvd1[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* tqm_fp_ring_cfg (size:128b/16B) */

struct tqm_fp_ring_cfg {
	/* TQM ring page size and level. */
	uint8_t	tqm_ring_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_LAST	TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_LAST   TQM_FP_RING_CFG_TQM_RING_CFG_TQM_RING_PG_SIZE_PG_1G
	uint8_t	unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring_page_dir;
} __attribute__((packed));

/*******************************
 * hwrm_func_backing_store_cfg *
 *******************************/


/* hwrm_func_backing_store_cfg_input (size:2688b/336B) */

struct hwrm_func_backing_store_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When set, the firmware only uses on-chip resources and does not
	 * expect any backing store to be provided by the host driver. This
	 * mode provides minimal L2 functionality (e.g. limited L2 resources,
	 * no RoCE).
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_FLAGS_PREBOOT_MODE		UINT32_C(0x1)
	/*
	 * When set, the 32b `mrav_num_entries` field is logically divided
	 * into two 16b fields, `mr_num_entries` and `av_num_entries`.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_FLAGS_MRAV_RESERVATION_SPLIT	UINT32_C(0x2)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the qp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_QP		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the srq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_SRQ		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_CQ		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vnic fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_VNIC		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the stat fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_STAT		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the tqm_sp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_SP	UINT32_C(0x20)
	/*
	 * This bit must be '1' for the tqm_ring0 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING0	UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tqm_ring1 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING1	UINT32_C(0x80)
	/*
	 * This bit must be '1' for the tqm_ring2 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING2	UINT32_C(0x100)
	/*
	 * This bit must be '1' for the tqm_ring3 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING3	UINT32_C(0x200)
	/*
	 * This bit must be '1' for the tqm_ring4 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING4	UINT32_C(0x400)
	/*
	 * This bit must be '1' for the tqm_ring5 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING5	UINT32_C(0x800)
	/*
	 * This bit must be '1' for the tqm_ring6 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING6	UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the tqm_ring7 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING7	UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the mrav fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_MRAV		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the tim fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TIM		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the tqm_ring8 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING8	UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the tqm_ring9 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING9	UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the tqm_ring10 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING10	UINT32_C(0x40000)
	/*
	 * This bit must be '1' for the Tx KTLS context
	 * fields to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TKC		UINT32_C(0x80000)
	/*
	 * This bit must be '1' for the Rx KTLS context
	 * fields to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_RKC		UINT32_C(0x100000)
	/*
	 * This bit must be '1' for the number of QPs reserved for fast
	 * qp modify destroy feature to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_QP_FAST_QPMD	UINT32_C(0x200000)
	/* QPC page size and level. */
	uint8_t	qpc_pg_size_qpc_lvl;
	/* QPC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_2
	/* QPC page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_1G
	/* SRQ page size and level. */
	uint8_t	srq_pg_size_srq_lvl;
	/* SRQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_2
	/* SRQ page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_1G
	/* CQ page size and level. */
	uint8_t	cq_pg_size_cq_lvl;
	/* CQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_2
	/* CQ page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_1G
	/* VNIC page size and level. */
	uint8_t	vnic_pg_size_vnic_lvl;
	/* VNIC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_2
	/* VNIC page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_1G
	/* Stat page size and level. */
	uint8_t	stat_pg_size_stat_lvl;
	/* Stat PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_2
	/* Stat page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_1G
	/* TQM slow path page size and level. */
	uint8_t	tqm_sp_pg_size_tqm_sp_lvl;
	/* TQM slow path PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_2
	/* TQM slow path page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_1G
	/* TQM ring 0 page size and level. */
	uint8_t	tqm_ring0_pg_size_tqm_ring0_lvl;
	/* TQM ring 0 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_2
	/* TQM ring 0 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_1G
	/* TQM ring 1 page size and level. */
	uint8_t	tqm_ring1_pg_size_tqm_ring1_lvl;
	/* TQM ring 1 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_2
	/* TQM ring 1 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_1G
	/* TQM ring 2 page size and level. */
	uint8_t	tqm_ring2_pg_size_tqm_ring2_lvl;
	/* TQM ring 2 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_2
	/* TQM ring 2 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_1G
	/* TQM ring 3 page size and level. */
	uint8_t	tqm_ring3_pg_size_tqm_ring3_lvl;
	/* TQM ring 3 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_2
	/* TQM ring 3 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_1G
	/* TQM ring 4 page size and level. */
	uint8_t	tqm_ring4_pg_size_tqm_ring4_lvl;
	/* TQM ring 4 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_2
	/* TQM ring 4 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_1G
	/* TQM ring 5 page size and level. */
	uint8_t	tqm_ring5_pg_size_tqm_ring5_lvl;
	/* TQM ring 5 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_2
	/* TQM ring 5 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_1G
	/* TQM ring 6 page size and level. */
	uint8_t	tqm_ring6_pg_size_tqm_ring6_lvl;
	/* TQM ring 6 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_2
	/* TQM ring 6 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_1G
	/* TQM ring 7 page size and level. */
	uint8_t	tqm_ring7_pg_size_tqm_ring7_lvl;
	/* TQM ring 7 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_2
	/* TQM ring 7 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_1G
	/* MR/AV page size and level. */
	uint8_t	mrav_pg_size_mrav_lvl;
	/* MR/AV PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_2
	/* MR/AV page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_1G
	/* Timer page size and level. */
	uint8_t	tim_pg_size_tim_lvl;
	/* Timer PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_2
	/* Timer page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_1G
	/* QP page directory. */
	uint64_t	qpc_page_dir;
	/* SRQ page directory. */
	uint64_t	srq_page_dir;
	/* CQ page directory. */
	uint64_t	cq_page_dir;
	/* VNIC page directory. */
	uint64_t	vnic_page_dir;
	/* Stat page directory. */
	uint64_t	stat_page_dir;
	/* TQM slowpath page directory. */
	uint64_t	tqm_sp_page_dir;
	/* TQM ring 0 page directory. */
	uint64_t	tqm_ring0_page_dir;
	/* TQM ring 1 page directory. */
	uint64_t	tqm_ring1_page_dir;
	/* TQM ring 2 page directory. */
	uint64_t	tqm_ring2_page_dir;
	/* TQM ring 3 page directory. */
	uint64_t	tqm_ring3_page_dir;
	/* TQM ring 4 page directory. */
	uint64_t	tqm_ring4_page_dir;
	/* TQM ring 5 page directory. */
	uint64_t	tqm_ring5_page_dir;
	/* TQM ring 6 page directory. */
	uint64_t	tqm_ring6_page_dir;
	/* TQM ring 7 page directory. */
	uint64_t	tqm_ring7_page_dir;
	/* MR/AV page directory. */
	uint64_t	mrav_page_dir;
	/* Timer page directory. */
	uint64_t	tim_page_dir;
	/* Number of QPs. */
	uint32_t	qp_num_entries;
	/* Number of SRQs. */
	uint32_t	srq_num_entries;
	/* Number of CQs. */
	uint32_t	cq_num_entries;
	/* Number of Stats. */
	uint32_t	stat_num_entries;
	/*
	 * Number of TQM slowpath entries.
	 *
	 * TQM slowpath rings should be sized as follows:
	 *
	 * num_entries = num_vnics + num_l2_tx_rings + 2 * num_roce_qps + tqm_min_size
	 *
	 * Where:
	 *   num_vnics is the number of VNICs allocated in the VNIC backing
	 *   store num_l2_tx_rings is the number of L2 rings in the QP backing
	 *   store num_roce_qps is the number of RoCE QPs in the QP backing
	 *   store tqm_min_size is tqm_min_entries_per_ring reported by
	 *   HWRM_FUNC_BACKING_STORE_QCAPS
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_sp_num_entries;
	/*
	 * Number of TQM ring 0 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring0_num_entries;
	/*
	 * Number of TQM ring 1 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring1_num_entries;
	/*
	 * Number of TQM ring 2 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring2_num_entries;
	/*
	 * Number of TQM ring 3 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring3_num_entries;
	/*
	 * Number of TQM ring 4 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring4_num_entries;
	/*
	 * Number of TQM ring 5 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring5_num_entries;
	/*
	 * Number of TQM ring 6 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring6_num_entries;
	/*
	 * Number of TQM ring 7 entries.
	 *
	 * TQM fastpath rings should be sized large enough to accommodate the
	 * maximum number of QPs (either L2 or RoCE, or both if shared)
	 * that can be enqueued to the TQM ring.
	 *
	 * Note that TQM ring sizes cannot be extended while the system is
	 * operational. If a PF driver needs to extend a TQM ring, it needs
	 * to reset the function (e.g. HWRM_FUNC_RESET) and then reallocate
	 * the backing store.
	 */
	uint32_t	tqm_ring7_num_entries;
	/*
	 * If the MR/AV split reservation flag is not set, then this field
	 * represents the total number of MR plus AV entries. For versions
	 * of firmware that support the split reservation, when it is not
	 * specified half of the entries will be reserved for MRs and the
	 * other half for AVs.
	 *
	 * If the MR/AV split reservation flag is set, then this
	 * field is logically divided into two 16b fields. Bits `[31:16]`
	 * represents the `mr_num_entries` and bits `[15:0]` represents
	 * `av_num_entries`. The granularity of these values is defined by
	 * the `mrav_num_entries_unit` field returned by the
	 * `backing_store_qcaps` command.
	 */
	uint32_t	mrav_num_entries;
	/* Number of Timer entries. */
	uint32_t	tim_num_entries;
	/* Number of entries to reserve for QP1 */
	uint16_t	qp_num_qp1_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	qp_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	qp_entry_size;
	/* Number of entries to reserve for L2 */
	uint16_t	srq_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	srq_entry_size;
	/* Number of entries to reserve for L2 */
	uint16_t	cq_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	cq_entry_size;
	/* Number of entries to reserve for VNIC entries */
	uint16_t	vnic_num_vnic_entries;
	/* Number of entries to reserve for Ring table entries */
	uint16_t	vnic_num_ring_table_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	vnic_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	stat_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	tqm_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	mrav_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	tim_entry_size;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring8_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING8_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring8_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring8_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring8_page_dir;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring9_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING9_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring9_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring9_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring9_page_dir;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring10_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_RING10_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring10_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring10_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring10_page_dir;
	/* Number of Tx KTLS context entries allocated. */
	uint32_t	tkc_num_entries;
	/* Number of Rx KTLS context entries allocated. */
	uint32_t	rkc_num_entries;
	/* Tx KTLS context page directory. */
	uint64_t	tkc_page_dir;
	/* Rx KTLS context page directory. */
	uint64_t	rkc_page_dir;
	/* Number of bytes allocated for each Tx KTLS context entry. */
	uint16_t	tkc_entry_size;
	/* Number of bytes allocated for each Rx KTLS context entry. */
	uint16_t	rkc_entry_size;
	/* Tx KTLS context page size and level. */
	uint8_t	tkc_pg_size_tkc_lvl;
	/* Tx KTLS context PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_LVL_LVL_2
	/* Tx KTLS context page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_TKC_PG_SIZE_PG_1G
	/* Rx KTLS context page size and level. */
	uint8_t	rkc_pg_size_rkc_lvl;
	/* Rx KTLS context PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_LAST	HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_LVL_LVL_2
	/* Rx KTLS context page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_INPUT_RKC_PG_SIZE_PG_1G
	/*
	 * Number of RoCE QP context entries reserved for this
	 * function to support fast QP modify destroy feature.
	 */
	uint16_t	qp_num_fast_qpmd_entries;
} __attribute__((packed));

/* hwrm_func_backing_store_cfg_output (size:128b/16B) */

struct hwrm_func_backing_store_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_func_backing_store_qcfg *
 ********************************/


/* hwrm_func_backing_store_qcfg_input (size:128b/16B) */

struct hwrm_func_backing_store_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_func_backing_store_qcfg_output (size:2496b/312B) */

struct hwrm_func_backing_store_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When set, the firmware only uses on-chip resources and does not
	 * expect any backing store to be provided by the host driver. This
	 * mode provides minimal L2 functionality (e.g. limited L2 resources,
	 * no RoCE).
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_FLAGS_PREBOOT_MODE		UINT32_C(0x1)
	/*
	 * When set, the 32b `mrav_num_entries` field is logically divided
	 * into two 16b fields, `mr_num_entries` and `av_num_entries`.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_FLAGS_MRAV_RESERVATION_SPLIT	UINT32_C(0x2)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the qp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_QP		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the srq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_SRQ		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_CQ		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vnic fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_VNIC		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the stat fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_STAT		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the tqm_sp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_SP	UINT32_C(0x20)
	/*
	 * This bit must be '1' for the tqm_ring0 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING0	UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tqm_ring1 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING1	UINT32_C(0x80)
	/*
	 * This bit must be '1' for the tqm_ring2 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING2	UINT32_C(0x100)
	/*
	 * This bit must be '1' for the tqm_ring3 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING3	UINT32_C(0x200)
	/*
	 * This bit must be '1' for the tqm_ring4 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING4	UINT32_C(0x400)
	/*
	 * This bit must be '1' for the tqm_ring5 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING5	UINT32_C(0x800)
	/*
	 * This bit must be '1' for the tqm_ring6 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING6	UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the tqm_ring7 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING7	UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the mrav fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_MRAV		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the tim fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TIM		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the tqm_ring8 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING8	UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the tqm_ring9 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING9	UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the tqm_ring10 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TQM_RING10	UINT32_C(0x40000)
	/*
	 * This bit must be '1' for the Tx KTLS context
	 * fields to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_TKC		UINT32_C(0x80000)
	/*
	 * This bit must be '1' for the Rx KTLS context
	 * fields to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_RKC		UINT32_C(0x100000)
	/*
	 * This bit must be '1' for the number of QPs reserved for fast
	 * qp modify destroy feature to be configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_ENABLES_QP_FAST_QPMD	UINT32_C(0x200000)
	/* QPC page size and level. */
	uint8_t	qpc_pg_size_qpc_lvl;
	/* QPC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_2
	/* QPC page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_1G
	/* SRQ page size and level. */
	uint8_t	srq_pg_size_srq_lvl;
	/* SRQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_2
	/* SRQ page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_1G
	/* CQ page size and level. */
	uint8_t	cq_pg_size_cq_lvl;
	/* CQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_2
	/* CQ page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_1G
	/* VNIC page size and level. */
	uint8_t	vnic_pg_size_vnic_lvl;
	/* VNIC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_2
	/* VNIC page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_1G
	/* Stat page size and level. */
	uint8_t	stat_pg_size_stat_lvl;
	/* Stat PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_2
	/* Stat page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_1G
	/* TQM slow path page size and level. */
	uint8_t	tqm_sp_pg_size_tqm_sp_lvl;
	/* TQM slow path PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_2
	/* TQM slow path page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_1G
	/* TQM ring 0 page size and level. */
	uint8_t	tqm_ring0_pg_size_tqm_ring0_lvl;
	/* TQM ring 0 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_2
	/* TQM ring 0 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_1G
	/* TQM ring 1 page size and level. */
	uint8_t	tqm_ring1_pg_size_tqm_ring1_lvl;
	/* TQM ring 1 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_2
	/* TQM ring 1 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_1G
	/* TQM ring 2 page size and level. */
	uint8_t	tqm_ring2_pg_size_tqm_ring2_lvl;
	/* TQM ring 2 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_2
	/* TQM ring 2 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_1G
	/* TQM ring 3 page size and level. */
	uint8_t	tqm_ring3_pg_size_tqm_ring3_lvl;
	/* TQM ring 3 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_2
	/* TQM ring 3 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_1G
	/* TQM ring 4 page size and level. */
	uint8_t	tqm_ring4_pg_size_tqm_ring4_lvl;
	/* TQM ring 4 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_2
	/* TQM ring 4 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_1G
	/* TQM ring 5 page size and level. */
	uint8_t	tqm_ring5_pg_size_tqm_ring5_lvl;
	/* TQM ring 5 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_2
	/* TQM ring 5 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_1G
	/* TQM ring 6 page size and level. */
	uint8_t	tqm_ring6_pg_size_tqm_ring6_lvl;
	/* TQM ring 6 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_2
	/* TQM ring 6 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_1G
	/* TQM ring 7 page size and level. */
	uint8_t	tqm_ring7_pg_size_tqm_ring7_lvl;
	/* TQM ring 7 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_2
	/* TQM ring 7 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_1G
	/* MR/AV page size and level. */
	uint8_t	mrav_pg_size_mrav_lvl;
	/* MR/AV PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_2
	/* MR/AV page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_1G
	/* Timer page size and level. */
	uint8_t	tim_pg_size_tim_lvl;
	/* Timer PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to PTE
	 * tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_2
	/* Timer page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_1G
	/* QP page directory. */
	uint64_t	qpc_page_dir;
	/* SRQ page directory. */
	uint64_t	srq_page_dir;
	/* CQ page directory. */
	uint64_t	cq_page_dir;
	/* VNIC page directory. */
	uint64_t	vnic_page_dir;
	/* Stat page directory. */
	uint64_t	stat_page_dir;
	/* TQM slowpath page directory. */
	uint64_t	tqm_sp_page_dir;
	/* TQM ring 0 page directory. */
	uint64_t	tqm_ring0_page_dir;
	/* TQM ring 1 page directory. */
	uint64_t	tqm_ring1_page_dir;
	/* TQM ring 2 page directory. */
	uint64_t	tqm_ring2_page_dir;
	/* TQM ring 3 page directory. */
	uint64_t	tqm_ring3_page_dir;
	/* TQM ring 4 page directory. */
	uint64_t	tqm_ring4_page_dir;
	/* TQM ring 5 page directory. */
	uint64_t	tqm_ring5_page_dir;
	/* TQM ring 6 page directory. */
	uint64_t	tqm_ring6_page_dir;
	/* TQM ring 7 page directory. */
	uint64_t	tqm_ring7_page_dir;
	/* MR/AV page directory. */
	uint64_t	mrav_page_dir;
	/* Timer page directory. */
	uint64_t	tim_page_dir;
	/* Number of entries to reserve for QP1 */
	uint16_t	qp_num_qp1_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	qp_num_l2_entries;
	/* Number of QPs. */
	uint32_t	qp_num_entries;
	/* Number of SRQs. */
	uint32_t	srq_num_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	srq_num_l2_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	cq_num_l2_entries;
	/* Number of CQs. */
	uint32_t	cq_num_entries;
	/* Number of entries to reserve for VNIC entries */
	uint16_t	vnic_num_vnic_entries;
	/* Number of entries to reserve for Ring table entries */
	uint16_t	vnic_num_ring_table_entries;
	/* Number of Stats. */
	uint32_t	stat_num_entries;
	/* Number of TQM slowpath entries. */
	uint32_t	tqm_sp_num_entries;
	/* Number of TQM ring 0 entries. */
	uint32_t	tqm_ring0_num_entries;
	/* Number of TQM ring 1 entries. */
	uint32_t	tqm_ring1_num_entries;
	/* Number of TQM ring 2 entries. */
	uint32_t	tqm_ring2_num_entries;
	/* Number of TQM ring 3 entries. */
	uint32_t	tqm_ring3_num_entries;
	/* Number of TQM ring 4 entries. */
	uint32_t	tqm_ring4_num_entries;
	/* Number of TQM ring 5 entries. */
	uint32_t	tqm_ring5_num_entries;
	/* Number of TQM ring 6 entries. */
	uint32_t	tqm_ring6_num_entries;
	/* Number of TQM ring 7 entries. */
	uint32_t	tqm_ring7_num_entries;
	/*
	 * If the MR/AV split reservation flag is not set, then this field
	 * represents the total number of MR plus AV entries. For versions
	 * of firmware that support the split reservation, when it is not
	 * specified half of the entries will be reserved for MRs and the
	 * other half for AVs.
	 *
	 * If the MR/AV split reservation flag is set, then this
	 * field is logically divided into two 16b fields. Bits `[31:16]`
	 * represents the `mr_num_entries` and bits `[15:0]` represents
	 * `av_num_entries`. The granularity of these values is defined by
	 * the `mrav_num_entries_unit` field returned by the
	 * `backing_store_qcaps` command.
	 */
	uint32_t	mrav_num_entries;
	/* Number of Timer entries. */
	uint32_t	tim_num_entries;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring8_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING8_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring8_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring8_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring8_page_dir;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring9_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING9_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring9_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring9_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring9_page_dir;
	/* TQM ring page size and level. */
	uint8_t	tqm_ring10_pg_size_tqm_ring_lvl;
	/* TQM ring PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_LVL_LVL_2
	/* TQM ring page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RING10_TQM_RING_PG_SIZE_PG_1G
	uint8_t	ring10_unused[3];
	/* Number of TQM ring entries. */
	uint32_t	tqm_ring10_num_entries;
	/* TQM ring page directory. */
	uint64_t	tqm_ring10_page_dir;
	/* Number of Tx KTLS context entries. */
	uint32_t	tkc_num_entries;
	/* Number of Rx KTLS context entries. */
	uint32_t	rkc_num_entries;
	/* Tx KTLS context page directory. */
	uint64_t	tkc_page_dir;
	/* Rx KTLS context page directory. */
	uint64_t	rkc_page_dir;
	/* Tx KTLS context page size and level. */
	uint8_t	tkc_pg_size_tkc_lvl;
	/* Tx KTLS context PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_LVL_LVL_2
	/* Tx KTLS context page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TKC_PG_SIZE_PG_1G
	/* Rx KTLS context page size and level. */
	uint8_t	rkc_pg_size_rkc_lvl;
	/* Rx KTLS context PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_MASK	UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_SFT	0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_LVL_0	UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_LVL_1	UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_LVL_2	UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_LAST	HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_LVL_LVL_2
	/* Rx KTLS context page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_RKC_PG_SIZE_PG_1G
	/*
	 * Number of RoCE QP context entries required for this
	 * function to support fast QP modify destroy feature.
	 */
	uint16_t	qp_num_fast_qpmd_entries;
	uint8_t	unused_1[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as 1
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal
	 * processor, the order of writes has to be such that this field
	 * is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_error_recovery_qcfg *
 ****************************/


/* hwrm_error_recovery_qcfg_input (size:192b/24B) */

struct hwrm_error_recovery_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	unused_0[8];
} __attribute__((packed));

/* hwrm_error_recovery_qcfg_output (size:1664b/208B) */

struct hwrm_error_recovery_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When this flag is set to 1, error recovery will be initiated
	 * through master function driver.
	 */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FLAGS_HOST	UINT32_C(0x1)
	/*
	 * When this flag is set to 1, error recovery will be performed
	 * through Co processor.
	 */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FLAGS_CO_CPU	UINT32_C(0x2)
	/*
	 * Driver Polling frequency. This value is in units of 100msec.
	 * Typical value would be 10 to indicate 1sec.
	 * Drivers can poll FW health status, Heartbeat, reset_counter with
	 * this frequency.
	 */
	uint32_t	driver_polling_freq;
	/*
	 * This value is in units of 100msec.
	 * Typical value would be 30 to indicate 3sec.
	 * Master function wait period from detecting a fatal error to
	 * initiating reset. In this time period Master PF expects every
	 * active driver will detect fatal error.
	 */
	uint32_t	master_func_wait_period;
	/*
	 * This value is in units of 100msec.
	 * Typical value would be 50 to indicate 5sec.
	 * Normal function wait period from fatal error detection to
	 * polling FW health status. In this time period, drivers should not
	 * do any PCIe MMIO transaction and should not send any HWRM commands.
	 */
	uint32_t	normal_func_wait_period;
	/*
	 * This value is in units of 100msec.
	 * Typical value would be 20 to indicate 2sec.
	 * This field indicates that, master function wait period after chip
	 * reset. After this time, master function should reinitialize with
	 * FW.
	 */
	uint32_t	master_func_wait_period_after_reset;
	/*
	 * This value is in units of 100msec.
	 * Typical value would be 60 to indicate 6sec.
	 * This field is applicable to both master and normal functions.
	 * Even after chip reset, if FW status not changed to ready,
	 * then all the functions can poll for this much time and bailout.
	 */
	uint32_t	max_bailout_time_after_reset;
	/*
	 * FW health status register.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates upper 30bits of the register address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	fw_health_status_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEALTH_STATUS_REG_ADDR_SFT	2
	/*
	 * FW HeartBeat register.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates actual address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	fw_heartbeat_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_HEARTBEAT_REG_ADDR_SFT	2
	/*
	 * FW reset counter.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates actual address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	fw_reset_cnt_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_FW_RESET_CNT_REG_ADDR_SFT	2
	/*
	 * Reset Inprogress Register address for PFs.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates actual address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	reset_inprogress_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_INPROGRESS_REG_ADDR_SFT	2
	/* This field indicates the mask value for reset_inprogress_reg. */
	uint32_t	reset_inprogress_reg_mask;
	uint8_t	unused_0[3];
	/*
	 * Array of registers and value count to reset the Chip
	 * Each array count has reset_reg, reset_reg_val, delay_after_reset
	 * in TLV format. Depending upon Chip type, number of reset registers
	 * will vary. Drivers have to write reset_reg_val in the reset_reg
	 * location in the same sequence in order to recover from a fatal
	 * error.
	 */
	uint8_t	reg_array_cnt;
	/*
	 * Reset register.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates actual address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	reset_reg[16];
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_RESET_REG_ADDR_SFT	2
	/* Value to be written in reset_reg to reset the controller. */
	uint32_t	reset_reg_val[16];
	/*
	 * This value is in units of 1msec.
	 * Typical value would be 10 to indicate 10msec.
	 * Some of the operations like Core reset require delay before
	 * accessing PCIE MMIO register space.
	 * If this value is non-zero, drivers have to wait for
	 * this much time after writing reset_reg_val in reset_reg.
	 */
	uint8_t	delay_after_reset[16];
	/*
	 * Error recovery counter.
	 * Lower 2 bits indicates address space location and upper 30 bits
	 * indicates actual address.
	 * A value of 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	err_recovery_cnt_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_LAST	HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_ERROR_RECOVERY_QCFG_OUTPUT_ERR_RECOVERY_CNT_REG_ADDR_SFT	2
	uint8_t	unused_1[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal
	 * processor, the order of writes has to be such that this field
	 * is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_func_echo_response *
 ***************************/


/* hwrm_func_echo_response_input (size:192b/24B) */

struct hwrm_func_echo_response_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	event_data1;
	uint32_t	event_data2;
} __attribute__((packed));

/* hwrm_func_echo_response_output (size:128b/16B) */

struct hwrm_func_echo_response_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_ptp_pin_qcfg *
 **************************/


/* hwrm_func_ptp_pin_qcfg_input (size:192b/24B) */

struct hwrm_func_ptp_pin_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	unused_0[8];
} __attribute__((packed));

/* hwrm_func_ptp_pin_qcfg_output (size:128b/16B) */

struct hwrm_func_ptp_pin_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * The number of TSIO pins that are configured on this board
	 * Up to 4 pins can be returned in the response.
	 */
	uint8_t	num_pins;
	/* Pin state */
	uint8_t	state;
	/*
	 * When this bit is '1', TSIO pin 0 is enabled.
	 * When this bit is '0', TSIO pin 0 is disabled.
	 */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_STATE_PIN0_ENABLED	UINT32_C(0x1)
	/*
	 * When this bit is '1', TSIO pin 1 is enabled.
	 * When this bit is '0', TSIO pin 1 is disabled.
	 */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_STATE_PIN1_ENABLED	UINT32_C(0x2)
	/*
	 * When this bit is '1', TSIO pin 2 is enabled.
	 * When this bit is '0', TSIO pin 2 is disabled.
	 */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_STATE_PIN2_ENABLED	UINT32_C(0x4)
	/*
	 * When this bit is '1', TSIO pin 3 is enabled.
	 * When this bit is '0', TSIO pin 3 is disabled.
	 */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_STATE_PIN3_ENABLED	UINT32_C(0x8)
	/* Type of function for Pin #0. */
	uint8_t	pin0_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_NONE	UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_PPS_IN   UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_PPS_OUT  UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_SYNC_IN  UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_SYNC_OUT UINT32_C(0x4)
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_LAST	HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN0_USAGE_SYNC_OUT
	/* Type of function for Pin #1. */
	uint8_t	pin1_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_NONE	UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_PPS_IN   UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_PPS_OUT  UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_SYNC_IN  UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_SYNC_OUT UINT32_C(0x4)
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_LAST	HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN1_USAGE_SYNC_OUT
	/* Type of function for Pin #2. */
	uint8_t	pin2_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_NONE			UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_PPS_IN			UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_PPS_OUT		UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_SYNC_IN		UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_SYNC_OUT		UINT32_C(0x4)
	/* SYNCE primary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_SYNCE_PRIMARY_CLOCK_OUT   UINT32_C(0x5)
	/* SYNCE secondary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_SYNCE_SECONDARY_CLOCK_OUT UINT32_C(0x6)
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_LAST			HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN2_USAGE_SYNCE_SECONDARY_CLOCK_OUT
	/* Type of function for Pin #3. */
	uint8_t	pin3_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_NONE			UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_PPS_IN			UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_PPS_OUT		UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_SYNC_IN		UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_SYNC_OUT		UINT32_C(0x4)
	/* SYNCE primary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_SYNCE_PRIMARY_CLOCK_OUT   UINT32_C(0x5)
	/* SYNCE secondary OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_SYNCE_SECONDARY_CLOCK_OUT UINT32_C(0x6)
	#define HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_LAST			HWRM_FUNC_PTP_PIN_QCFG_OUTPUT_PIN3_USAGE_SYNCE_SECONDARY_CLOCK_OUT
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_func_ptp_pin_cfg *
 *************************/


/* hwrm_func_ptp_pin_cfg_input (size:256b/32B) */

struct hwrm_func_ptp_pin_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the pin0_state field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN0_STATE	UINT32_C(0x1)
	/*
	 * This bit must be '1' for the pin0_usage field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN0_USAGE	UINT32_C(0x2)
	/*
	 * This bit must be '1' for the pin1_state field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN1_STATE	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the pin1_usage field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN1_USAGE	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the pin2_state field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN2_STATE	UINT32_C(0x10)
	/*
	 * This bit must be '1' for the pin2_usage field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN2_USAGE	UINT32_C(0x20)
	/*
	 * This bit must be '1' for the pin3_state field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN3_STATE	UINT32_C(0x40)
	/*
	 * This bit must be '1' for the pin3_usage field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_ENABLES_PIN3_USAGE	UINT32_C(0x80)
	/* Enable or disable functionality of Pin #0. */
	uint8_t	pin0_state;
	/* Disabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_STATE_DISABLED UINT32_C(0x0)
	/* Enabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_STATE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_STATE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_STATE_ENABLED
	/* Configure function for TSIO pin#0. */
	uint8_t	pin0_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_NONE	UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_PPS_IN   UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_PPS_OUT  UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_SYNC_IN  UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_SYNC_OUT UINT32_C(0x4)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN0_USAGE_SYNC_OUT
	/* Enable or disable functionality of Pin #1. */
	uint8_t	pin1_state;
	/* Disabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_STATE_DISABLED UINT32_C(0x0)
	/* Enabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_STATE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_STATE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_STATE_ENABLED
	/* Configure function for TSIO pin#1. */
	uint8_t	pin1_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_NONE	UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_PPS_IN   UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_PPS_OUT  UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_SYNC_IN  UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_SYNC_OUT UINT32_C(0x4)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN1_USAGE_SYNC_OUT
	/* Enable or disable functionality of Pin #2. */
	uint8_t	pin2_state;
	/* Disabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_STATE_DISABLED UINT32_C(0x0)
	/* Enabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_STATE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_STATE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_STATE_ENABLED
	/* Configure function for TSIO pin#2. */
	uint8_t	pin2_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_NONE			UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_PPS_IN			UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_PPS_OUT		UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_SYNC_IN		UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_SYNC_OUT		UINT32_C(0x4)
	/* SYNCE primary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_SYNCE_PRIMARY_CLOCK_OUT   UINT32_C(0x5)
	/* SYNCE secondary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_SYNCE_SECONDARY_CLOCK_OUT UINT32_C(0x6)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_LAST			HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN2_USAGE_SYNCE_SECONDARY_CLOCK_OUT
	/* Enable or disable functionality of Pin #3. */
	uint8_t	pin3_state;
	/* Disabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_STATE_DISABLED UINT32_C(0x0)
	/* Enabled */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_STATE_ENABLED  UINT32_C(0x1)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_STATE_LAST	HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_STATE_ENABLED
	/* Configure function for TSIO pin#3. */
	uint8_t	pin3_usage;
	/* No function is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_NONE			UINT32_C(0x0)
	/* PPS IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_PPS_IN			UINT32_C(0x1)
	/* PPS OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_PPS_OUT		UINT32_C(0x2)
	/* SYNC IN is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_SYNC_IN		UINT32_C(0x3)
	/* SYNC OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_SYNC_OUT		UINT32_C(0x4)
	/* SYNCE primary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_SYNCE_PRIMARY_CLOCK_OUT   UINT32_C(0x5)
	/* SYNCE secondary clock OUT is configured. */
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_SYNCE_SECONDARY_CLOCK_OUT UINT32_C(0x6)
	#define HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_LAST			HWRM_FUNC_PTP_PIN_CFG_INPUT_PIN3_USAGE_SYNCE_SECONDARY_CLOCK_OUT
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_ptp_pin_cfg_output (size:128b/16B) */

struct hwrm_func_ptp_pin_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_func_ptp_cfg *
 *********************/


/* hwrm_func_ptp_cfg_input (size:384b/48B) */

struct hwrm_func_ptp_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint16_t	enables;
	/*
	 * This bit must be '1' for the ptp_pps_event field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_PPS_EVENT		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the ptp_freq_adj_dll_source field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_FREQ_ADJ_DLL_SOURCE	UINT32_C(0x2)
	/*
	 * This bit must be '1' for the ptp_freq_adj_dll_phase field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_FREQ_ADJ_DLL_PHASE	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the ptp_freq_adj_ext_period field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_FREQ_ADJ_EXT_PERIOD	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the ptp_freq_adj_ext_up field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_FREQ_ADJ_EXT_UP	UINT32_C(0x10)
	/*
	 * This bit must be '1' for the ptp_freq_adj_ext_phase field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_FREQ_ADJ_EXT_PHASE	UINT32_C(0x20)
	/* This bit must be '1' for ptp_set_time field to be configured. */
	#define HWRM_FUNC_PTP_CFG_INPUT_ENABLES_PTP_SET_TIME		UINT32_C(0x40)
	/* This field is used to enable interrupt for a specific PPS event. */
	uint8_t	ptp_pps_event;
	/*
	 * When this bit is set to '1', interrupt is enabled for internal
	 * PPS event. Latches timestamp on PPS_OUT TSIO Pin. If user does
	 * not configure PPS_OUT on a TSIO pin, then firmware will allocate
	 * PPS_OUT to an unallocated pin.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_PPS_EVENT_INTERNAL	UINT32_C(0x1)
	/*
	 * When this bit is set to '1', interrupt is enabled for external
	 * PPS event. Latches timestamp on PPS_IN TSIO pin.
	 */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_PPS_EVENT_EXTERNAL	UINT32_C(0x2)
	/*
	 * This field is used to set the source signal used to discipline
	 * PHC (PTP Hardware Clock)
	 */
	uint8_t	ptp_freq_adj_dll_source;
	/* No source is selected. Use servo to discipline PHC */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_NONE	UINT32_C(0x0)
	/* TSIO Pin #0 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_TSIO_0  UINT32_C(0x1)
	/* TSIO Pin #1 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_TSIO_1  UINT32_C(0x2)
	/* TSIO Pin #2 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_TSIO_2  UINT32_C(0x3)
	/* TSIO Pin #3 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_TSIO_3  UINT32_C(0x4)
	/* Port #0 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_PORT_0  UINT32_C(0x5)
	/* Port #1 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_PORT_1  UINT32_C(0x6)
	/* Port #2 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_PORT_2  UINT32_C(0x7)
	/* Port #3 is selected as source signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_PORT_3  UINT32_C(0x8)
	/* Invalid signal. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_INVALID UINT32_C(0xff)
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_LAST   HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_SOURCE_INVALID
	/*
	 * This field is used to provide phase adjustment for DLL
	 * used to discipline PHC (PTP Hardware clock)
	 */
	uint8_t	ptp_freq_adj_dll_phase;
	/* No Phase adjustment. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_NONE UINT32_C(0x0)
	/* 4Khz sync in frequency. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_4K   UINT32_C(0x1)
	/* 8Khz sync in frequency. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_8K   UINT32_C(0x2)
	/* 10Mhz sync in frequency. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_10M  UINT32_C(0x3)
	/* 25Mhz sync in frequency. */
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_25M  UINT32_C(0x4)
	#define HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_LAST HWRM_FUNC_PTP_CFG_INPUT_PTP_FREQ_ADJ_DLL_PHASE_25M
	uint8_t	unused_0[3];
	/*
	 * Period in nanoseconds (ns) for external signal
	 * input.
	 */
	uint32_t	ptp_freq_adj_ext_period;
	/*
	 * Up time in nanoseconds (ns) of the duty cycle
	 * of the external signal. This value should be
	 * less than ptp_freq_adj_ext_period.
	 */
	uint32_t	ptp_freq_adj_ext_up;
	/*
	 * Phase value is provided. This field provides the
	 * least significant 32 bits of the phase input. The
	 * most significant 16 bits come from
	 * ptp_freq_adj_ext_phase_upper field. Setting this
	 * field requires setting ptp_freq_adj_ext_period
	 * field as well to identify the external signal
	 * pin.
	 */
	uint32_t	ptp_freq_adj_ext_phase_lower;
	/*
	 * Phase value is provided. The lower 16 bits of this field is used
	 * with the 32 bit value from ptp_freq_adj_ext_phase_lower
	 * to provide a 48 bit value input for Phase.
	 */
	uint32_t	ptp_freq_adj_ext_phase_upper;
	/*
	 * Allows driver to set the full 64bit time in FW. The upper 16 bits
	 * will be stored in FW and the lower 48bits will be programmed in
	 * PHC. Firmware will send a broadcast async event to all functions
	 * to indicate the programmed upper 16 bits.
	 */
	uint64_t	ptp_set_time;
} __attribute__((packed));

/* hwrm_func_ptp_cfg_output (size:128b/16B) */

struct hwrm_func_ptp_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_ptp_ts_query *
 **************************/


/* hwrm_func_ptp_ts_query_input (size:192b/24B) */

struct hwrm_func_ptp_ts_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* If set, the response includes PPS event timestamps */
	#define HWRM_FUNC_PTP_TS_QUERY_INPUT_FLAGS_PPS_TIME	UINT32_C(0x1)
	/* If set, the response includes PTM timestamps */
	#define HWRM_FUNC_PTP_TS_QUERY_INPUT_FLAGS_PTM_TIME	UINT32_C(0x2)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_ptp_ts_query_output (size:320b/40B) */

struct hwrm_func_ptp_ts_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Timestamp value of last PPS event latched. */
	uint64_t	pps_event_ts;
	/*
	 * PHC timestamp value when PTM responseD request is received
	 * at downstream port (t4'). This is a 48 bit timestamp in nanoseconds.
	 */
	uint64_t	ptm_local_ts;
	/*
	 * PTM System timestamp value corresponding to t4' at
	 * root complex (T4'). Together with ptm_local_ts, these
	 * two timestamps provide the cross-trigger timestamps.
	 * Driver can directly use these values for cross-trigger.
	 * This is a 48 bit timestamp in nanoseconds.
	 */
	uint64_t	ptm_system_ts;
	/*
	 * PTM Link delay. This is the time taken at root complex (RC)
	 * between receiving PTM request and sending PTM response to
	 * downstream port. This is a 32 bit value in nanoseconds.
	 */
	uint32_t	ptm_link_delay;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_func_ptp_ext_cfg *
 *************************/


/* hwrm_func_ptp_ext_cfg_input (size:256b/32B) */

struct hwrm_func_ptp_ext_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint16_t	enables;
	/*
	 * This bit must be '1' for the phc_master_fid field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_ENABLES_PHC_MASTER_FID	UINT32_C(0x1)
	/*
	 * This bit must be '1' for the phc_sec_fid field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_ENABLES_PHC_SEC_FID	UINT32_C(0x2)
	/*
	 * This bit must be '1' for the phc_sec_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_ENABLES_PHC_SEC_MODE	UINT32_C(0x4)
	/*
	 * This bit must be '1' for the failover_timer field to be
	 * configured.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_ENABLES_FAILOVER_TIMER	UINT32_C(0x8)
	/*
	 * This field is used to configure the Master function. Only this
	 * function can modify or condition the PHC. Only driver calls from
	 * this function are allowed to adjust frequency of PHC or configure
	 * PPS functionality.
	 * If driver does not specify this FID, then firmware will auto select
	 * the first function that makes the call to modify PHC as the Master.
	 */
	uint16_t	phc_master_fid;
	/*
	 * This field is used to configure the secondary function. This
	 * function becomes the Master function in case of failover from
	 * Master function.
	 * If driver does not specify this FID, firmware will auto select
	 * the last non-master function to make a call to condition PHC as
	 * secondary.
	 */
	uint16_t	phc_sec_fid;
	/*
	 * This field is used to configure conditions under which a function
	 * can become a secondary function.
	 */
	uint8_t	phc_sec_mode;
	/*
	 * Immediately failover to the current secondary function. If there
	 * is no secondary function available, failover does not happen.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_PHC_SEC_MODE_SWITCH  UINT32_C(0x0)
	/*
	 * All functions (PF and VF) can be used during auto selection
	 * of a secondary function. This is not used in case of admin
	 * configured secondary function.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_PHC_SEC_MODE_ALL	UINT32_C(0x1)
	/*
	 * Only PF's can be selected as a secondary function during auto
	 * selection. This is not used in case of admin configured secondary
	 * function.
	 */
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_PHC_SEC_MODE_PF_ONLY UINT32_C(0x2)
	#define HWRM_FUNC_PTP_EXT_CFG_INPUT_PHC_SEC_MODE_LAST   HWRM_FUNC_PTP_EXT_CFG_INPUT_PHC_SEC_MODE_PF_ONLY
	uint8_t	unused_0;
	/*
	 * This field indicates the failover time is milliseconds. If the
	 * timeout expires, firmware will failover PTP configurability from
	 * current master to secondary fid.
	 * 0 - Failover timer is automatically selected based on the last
	 * adjFreq() call. If adjFreq() is not called for 3 * (last interval)
	 * the failover kicks in. For example, if last interval between
	 * adjFreq() calls was 2 seconds and the next adjFreq() is not made for
	 * at least 6 seconds, then secondary takes over as master to condition
	 * PHC. Firmware rounds up the failover timer to be a multiple of 250
	 * ms. Firmware checks every 250 ms to see if timer expired.
	 * 0xFFFFFFFF - If driver specifies this value, then failover never
	 * happens. Admin or auto selected Master will always be used for
	 * conditioning PHC.
	 * X - If driver specifies any other value, this is admin indicated
	 * failover timeout. If no adjFreq() call is made within this timeout
	 * value, then failover happens. This value should be a multiple of
	 * 250 ms. Firmware checks every 250 ms to see if timer expired.
	 */
	uint32_t	failover_timer;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_func_ptp_ext_cfg_output (size:128b/16B) */

struct hwrm_func_ptp_ext_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_ptp_ext_qcfg *
 **************************/


/* hwrm_func_ptp_ext_qcfg_input (size:192b/24B) */

struct hwrm_func_ptp_ext_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	unused_0[8];
} __attribute__((packed));

/* hwrm_func_ptp_ext_qcfg_output (size:256b/32B) */

struct hwrm_func_ptp_ext_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Firmware returns the current PHC master function. This function
	 * could either be admin selected or auto selected.
	 */
	uint16_t	phc_master_fid;
	/*
	 * Firmware returns the current PHC secondary function. This function
	 * could either be admin selected or auto selected.
	 */
	uint16_t	phc_sec_fid;
	/*
	 * Firmware returns the last non-master/non-secondary function to
	 * make a call to condition PHC.
	 */
	uint16_t	phc_active_fid0;
	/*
	 * Firmware returns the second last non-master/non-secondary function
	 * to make a call to condition PHC.
	 */
	uint16_t	phc_active_fid1;
	/*
	 * Timestamp indicating the last time a failover happened. The master
	 * and secondary functions in the failover event is indicated in the
	 * next two fields.
	 */
	uint32_t	last_failover_event;
	/*
	 * Last failover happened from this function. This was the master
	 * function at the time of failover.
	 */
	uint16_t	from_fid;
	/*
	 * Last failover happened to this function. This was the secondary
	 * function at the time of failover.
	 */
	uint16_t	to_fid;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************************
 * hwrm_func_timedtx_pacing_rate_add *
 *************************************/


/* hwrm_func_timedtx_pacing_rate_add_input (size:192b/24B) */

struct hwrm_func_timedtx_pacing_rate_add_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This field indicates TimedTx pacing rate in kbps.
	 * The driver needs to add the rate into the hardware rate table
	 * before requesting the pacing rate for a flow in TimedTX BD and
	 * this addition should be done for each function rather than for
	 * each flow/QP within the function.
	 */
	uint32_t	rate;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_timedtx_pacing_rate_add_output (size:128b/16B) */

struct hwrm_func_timedtx_pacing_rate_add_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This field indicates the logical rate ID that is assigned to the
	 * rate in the rate table. The driver should use this ID for future
	 * reference to this rate.
	 */
	uint16_t	rate_id;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************************
 * hwrm_func_timedtx_pacing_rate_delete *
 ****************************************/


/* hwrm_func_timedtx_pacing_rate_delete_input (size:192b/24B) */

struct hwrm_func_timedtx_pacing_rate_delete_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * The logical rate ID that is returned in the TimedTX pacing rate
	 * add operation.
	 */
	uint16_t	rate_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_timedtx_pacing_rate_delete_output (size:128b/16B) */

struct hwrm_func_timedtx_pacing_rate_delete_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************************
 * hwrm_func_timedtx_pacing_rate_query *
 ***************************************/


/* hwrm_func_timedtx_pacing_rate_query_input (size:192b/24B) */

struct hwrm_func_timedtx_pacing_rate_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	unused_0[8];
} __attribute__((packed));

/* hwrm_func_timedtx_pacing_rate_query_output (size:4224b/528B) */

struct hwrm_func_timedtx_pacing_rate_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This field indicates the rates that the function has added into
	 * the hardware rate table. This is an array of 128 entries. Starting
	 * with index 0, registered rates are populated in the initial entries
	 * of the array, remaining entries are filled up with 0.
	 */
	uint32_t	rates[128];
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_func_key_ctx_alloc *
 ***************************/


/* hwrm_func_key_ctx_alloc_input (size:384b/48B) */

struct hwrm_func_key_ctx_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Function ID. */
	uint16_t	fid;
	/*
	 * Number of Key Contexts to be allocated.
	 * When running in the XID partition mode, if the call is made by
	 * a VF driver, this field specifies the number of XIDs requested
	 * by the VF driver. The XID partitions are managed by the PF
	 * driver in XID partition mode and the VF command will be
	 * redirected to the PF driver. The PF driver may reduce this
	 * number if it cannot allocate a big enough block of XID
	 * partitions to satisfy the request.
	 * This field must not exceed the maximum batch size specified in
	 * the max_key_ctxs_alloc field of the HWRM_FUNC_QCAPS response,
	 * must not be zero, and must be integer multiples of the
	 * partition size specified in the ctxs_per_partition field of
	 * the HWRM_FUNC_QCAPS response.
	 */
	uint16_t	num_key_ctxs;
	/*
	 * DMA buffer size in bytes. This field in invalid in the XID
	 * partition mode.
	 */
	uint32_t	dma_bufr_size_bytes;
	/* Key Context type. */
	uint8_t	key_ctx_type;
	/* KTLS Tx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_TX	UINT32_C(0x0)
	/* KTLS Rx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_RX	UINT32_C(0x1)
	/* QUIC Tx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_QUIC_TX UINT32_C(0x2)
	/* QUIC Rx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_QUIC_RX UINT32_C(0x3)
	#define HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_LAST   HWRM_FUNC_KEY_CTX_ALLOC_INPUT_KEY_CTX_TYPE_QUIC_RX
	uint8_t	unused_0[7];
	/*
	 * Host DMA address to send back KTLS context IDs. This field is
	 * invalid in the XID partition mode.
	 */
	uint64_t	host_dma_addr;
	/*
	 * This field is only used by the PF driver that manages the XID
	 * partitions. This field specifies the starting XID of one or
	 * more contiguous XID partitions allocated by the PF driver.
	 * This field is not used by the VF driver.
	 * If the call is successful, this starting XID value will be
	 * returned in the partition_start_xid field of the response.
	 */
	uint32_t	partition_start_xid;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_func_key_ctx_alloc_output (size:192b/24B) */

struct hwrm_func_key_ctx_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of Key Contexts that have been allocated. */
	uint16_t	num_key_ctxs_allocated;
	/* Control flags. */
	uint8_t	flags;
	/*
	 * When set, it indicates that all key contexts allocated by this
	 * command are contiguous. As a result, the driver has to read the
	 * start context ID from the first entry of the DMA data buffer
	 * and figures out the end context ID by 'start context ID +
	 * num_key_ctxs_allocated - 1'. In XID partition mode,
	 * this bit should always be set.
	 */
	#define HWRM_FUNC_KEY_CTX_ALLOC_OUTPUT_FLAGS_KEY_CTXS_CONTIGUOUS	UINT32_C(0x1)
	uint8_t	unused_0;
	/*
	 * This field is only valid in the XID partition mode. It indicates
	 * the starting XID that has been allocated.
	 */
	uint32_t	partition_start_xid;
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written. When
	 * writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_key_ctx_free *
 **************************/


/* hwrm_func_key_ctx_free_input (size:256b/32B) */

struct hwrm_func_key_ctx_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Function ID. */
	uint16_t	fid;
	/* Key Context type. */
	uint8_t	key_ctx_type;
	/* KTLS Tx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_TX	UINT32_C(0x0)
	/* KTLS Rx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_RX	UINT32_C(0x1)
	/* QUIC Tx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_QUIC_TX UINT32_C(0x2)
	/* QUIC Rx Key Context type. */
	#define HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_QUIC_RX UINT32_C(0x3)
	#define HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_LAST   HWRM_FUNC_KEY_CTX_FREE_INPUT_KEY_CTX_TYPE_QUIC_RX
	uint8_t	unused_0;
	/* Starting XID of the partition that needs to be freed. */
	uint32_t	partition_start_xid;
	/*
	 * Number of entries to be freed.
	 * When running in the XID partition mode, this field is only
	 * used by the PF driver that manages the XID partitions.
	 * The PF driver specifies the number of XIDs to be freed and
	 * this number is always equal to the number of XIDs previously
	 * allocated successfully using HWRM_FUNC_KEY_CTX_ALLOC.
	 * This field is not used by the VF driver.
	 */
	uint16_t	num_entries;
	uint8_t	unused_1[6];
} __attribute__((packed));

/* hwrm_func_key_ctx_free_output (size:128b/16B) */

struct hwrm_func_key_ctx_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	rsvd0[7];
	/*
	 * This field is used in Output records to indicate that the
	 * output is completely written to RAM. This field should be
	 * read as '1' to indicate that the output has been completely
	 * written. When writing a command completion or response to
	 * an internal processor, the order of writes has to be such
	 * that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************************
 * hwrm_func_backing_store_cfg_v2 *
 **********************************/


/* hwrm_func_backing_store_cfg_v2_input (size:448b/56B) */

struct hwrm_func_backing_store_cfg_v2_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Type of backing store to be configured. */
	uint16_t	type;
	/* Queue pair. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_QP		UINT32_C(0x0)
	/* Shared receive queue. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SRQ		UINT32_C(0x1)
	/* Completion queue. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CQ		UINT32_C(0x2)
	/* Virtual NIC. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_VNIC		UINT32_C(0x3)
	/* Statistic context. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_STAT		UINT32_C(0x4)
	/* Slow-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SP_TQM_RING	UINT32_C(0x5)
	/* Fast-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_FP_TQM_RING	UINT32_C(0x6)
	/* Memory Region and Memory Address Vector Context. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_MRAV		UINT32_C(0xe)
	/* TIM. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_TIM		UINT32_C(0xf)
	/* Tx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_TX_CK		UINT32_C(0x13)
	/* Rx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_RX_CK		UINT32_C(0x14)
	/* Mid-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_MP_TQM_RING	UINT32_C(0x15)
	/* SQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SQ_DB_SHADOW	UINT32_C(0x16)
	/* RQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_RQ_DB_SHADOW	UINT32_C(0x17)
	/* SRQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SRQ_DB_SHADOW	UINT32_C(0x18)
	/* CQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CQ_DB_SHADOW	UINT32_C(0x19)
	/* CFA table scope context. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_TBL_SCOPE	UINT32_C(0x1c)
	/* XID partition context. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_XID_PARTITION	UINT32_C(0x1d)
	/* SRT trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SRT_TRACE	UINT32_C(0x1e)
	/* SRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_SRT2_TRACE	UINT32_C(0x1f)
	/* CRT trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CRT_TRACE	UINT32_C(0x20)
	/* CRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CRT2_TRACE	UINT32_C(0x21)
	/* RIGP0 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_RIGP0_TRACE	UINT32_C(0x22)
	/* L2 HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_L2_HWRM_TRACE	UINT32_C(0x23)
	/* RoCE HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_ROCE_HWRM_TRACE	UINT32_C(0x24)
	/* TimedTx pacing TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_TTX_PACING_TQM_RING UINT32_C(0x25)
	/* Context Accelerator CPU 0 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CA0_TRACE	UINT32_C(0x26)
	/* Context Accelerator CPU 1 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CA1_TRACE	UINT32_C(0x27)
	/* Context Accelerator CPU 2 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_CA2_TRACE	UINT32_C(0x28)
	/* RIGP1 trace. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_RIGP1_TRACE	UINT32_C(0x29)
	/* Invalid type. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_INVALID		UINT32_C(0xffff)
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_LAST		HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_TYPE_INVALID
	/*
	 * Instance of the backing store type. It is zero-based,
	 * which means "0" indicates the first instance. For backing
	 * stores with single instance only, leave this field to 0.
	 * 1. If the backing store type is MPC TQM ring, use the following
	 *	instance value to map to MPC clients:
	 *	TCE (0), RCE (1), TE_CFA(2), RE_CFA (3), PRIMATE(4)
	 * 2. If the backing store type is TBL_SCOPE, use the following
	 *	instance value to map to table scope regions:
	 *	RE_CFA_LKUP (0), RE_CFA_ACT (1), TE_CFA_LKUP(2), TE_CFA_ACT (3)
	 * 3. If the backing store type is XID partition, use the following
	 *	instance value to map to context types:
	 *	TX_CK (0), RX_CK (1)
	 */
	uint16_t	instance;
	/* Control flags. */
	uint32_t	flags;
	/*
	 * When set, the firmware only uses on-chip resources and
	 * does not expect any backing store to be provided by the
	 * host driver. This mode provides minimal L2 functionality
	 * (e.g. limited L2 resources, no RoCE).
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_FLAGS_PREBOOT_MODE	UINT32_C(0x1)
	/*
	 * When set, the driver indicates that the backing store type
	 * to be configured in this command is the last one to do for
	 * the associated PF. That means all backing store type
	 * configurations are done for the corresponding PF after this
	 * command. As a result, the firmware has to do the necessary
	 * post configurations.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_FLAGS_BS_CFG_ALL_DONE	UINT32_C(0x2)
	/*
	 * When set, the driver indicates extending the size of the specific
	 * backing store type instead of configuring the corresponding PBLs.
	 * The size specified in the command will be the new size to be
	 * configured. The operation is only valid when the specific backing
	 * store has been configured before. Otherwise, the firmware will
	 * return an error. The driver needs to zero out the 'entry_size',
	 * 'flags', 'page_dir', and 'page_size_pbl_level' fields, and the
	 * firmware will ignore these inputs. Further, the firmware expects
	 * the 'num_entries' and any valid split entries to be no less than
	 * the initial value that has been configured. If not, it will
	 * return an error code.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_FLAGS_BS_EXTEND	UINT32_C(0x4)
	/* Page directory. */
	uint64_t	page_dir;
	/* Number of entries */
	uint32_t	num_entries;
	/* Number of bytes allocated for each entry */
	uint16_t	entry_size;
	/* Page size and pbl level. */
	uint8_t	page_size_pbl_level;
	/* PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_MASK  UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_SFT   0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_LVL_0   UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_LVL_1   UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_LVL_2   UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_LAST   HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PBL_LEVEL_LVL_2
	/* Page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_LAST   HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_PAGE_SIZE_PG_1G
	/*
	 * This field counts how many split entries contain valid data.
	 * Below is the table that maps the count value:
	 * | Count |			Indication			|
	 * | ----- | -------------------------------------------------- |
	 * |   0   | None of the split entries has valid data.	|
	 * |   1   | Only "split_entry_0" contains valid data.	|
	 * |   2   | Only "split_entry_0" and "1" have valid data.	|
	 * |   3   | Only "split_entry_0", "1" and "2" have valid data. |
	 * |   4   | All four split entries have valid data.		|
	 */
	uint8_t	subtype_valid_cnt;
	/*
	 * Split entry #0. Note that the four split entries (as a group)
	 * must be cast to a type-specific data structure first before
	 * accessing it! Below is the table that maps a backing store
	 * type to the associated split entry casting data structure.
	 * | Type |	Split Entry Casting Data Structure	|
	 * | ---- | -------------------------------------------------- |
	 * | QPC  |		qpc_split_entries			|
	 * | SRQ  |		srq_split_entries			|
	 * | CQ   |		cq_split_entries			|
	 * | VINC |		vnic_split_entries			|
	 * | MRAV |		mrav_split_entries			|
	 * | TS   |		ts_split_entries			|
	 * | CK   |		ck_split_entries			|
	 */
	uint32_t	split_entry_0;
	/* Split entry #1. */
	uint32_t	split_entry_1;
	/* Split entry #2. */
	uint32_t	split_entry_2;
	/* Split entry #3. */
	uint32_t	split_entry_3;
	uint32_t        enables;
       /*
        * This bit must be '1' for the next_bs_offset field to be
        * configured.
        */
       #define HWRM_FUNC_BACKING_STORE_CFG_V2_INPUT_ENABLES_NEXT_BS_OFFSET     UINT32_C(0x1)
       /*
        * This field specifies the next byte offset of the backing store
        * for the firmware to use. The driver can use this field to
        * direct the firmware to resume the logging-to-host from
        * the host buffer where the firmware was lastly written
        * before it restarts, e.g. due to an error recovery.
        */
        uint32_t        next_bs_offset;
} __attribute__((packed));

/* hwrm_func_backing_store_cfg_v2_output (size:128b/16B) */

struct hwrm_func_backing_store_cfg_v2_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	rsvd0[7];
	/*
	 * This field is used in Output records to indicate that the
	 * output is completely written to RAM. This field should be
	 * read as '1' to indicate that the output has been completely
	 * written. When writing a command completion or response to
	 * an internal processor, the order of writes has to be such
	 * that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************************
 * hwrm_func_backing_store_qcfg_v2 *
 ***********************************/


/* hwrm_func_backing_store_qcfg_v2_input (size:192b/24B) */

struct hwrm_func_backing_store_qcfg_v2_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Type of backing store to be configured. */
	uint16_t	type;
	/* Queue pair. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_QP		UINT32_C(0x0)
	/* Shared receive queue. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SRQ		UINT32_C(0x1)
	/* Completion queue. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CQ		UINT32_C(0x2)
	/* Virtual NIC. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_VNIC		UINT32_C(0x3)
	/* Statistic context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_STAT		UINT32_C(0x4)
	/* Slow-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SP_TQM_RING	UINT32_C(0x5)
	/* Fast-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_FP_TQM_RING	UINT32_C(0x6)
	/* Memory Region and Memory Address Vector Context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_MRAV		UINT32_C(0xe)
	/* TIM. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_TIM		UINT32_C(0xf)
	/* Tx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_TX_CK		UINT32_C(0x13)
	/* Rx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_RX_CK		UINT32_C(0x14)
	/* Mid-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_MP_TQM_RING	UINT32_C(0x15)
	/* SQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SQ_DB_SHADOW	UINT32_C(0x16)
	/* RQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_RQ_DB_SHADOW	UINT32_C(0x17)
	/* SRQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SRQ_DB_SHADOW	UINT32_C(0x18)
	/* CQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CQ_DB_SHADOW	UINT32_C(0x19)
	/* CFA table scope context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_TBL_SCOPE	UINT32_C(0x1c)
	/* VF XID partition in-use table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_XID_PARTITION_TABLE UINT32_C(0x1d)
	/* SRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SRT_TRACE	UINT32_C(0x1e)
	/* SRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_SRT2_TRACE	UINT32_C(0x1f)
	/* CRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CRT_TRACE	UINT32_C(0x20)
	/* CRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CRT2_TRACE	UINT32_C(0x21)
	/* RIGP0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_RIGP0_TRACE	UINT32_C(0x22)
	/* L2 HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_L2_HWRM_TRACE	UINT32_C(0x23)
	/* RoCE HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_ROCE_HWRM_TRACE	UINT32_C(0x24)
	/* TimedTx pacing TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_TTX_PACING_TQM_RING UINT32_C(0x25)
	/* Context Accelerator CPU 0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CA0_TRACE	UINT32_C(0x26)
	/* Context Accelerator CPU 1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CA1_TRACE	UINT32_C(0x27)
	/* Context Accelerator CPU 2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_CA2_TRACE	UINT32_C(0x28)
	/* RIGP1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_RIGP1_TRACE	UINT32_C(0x29)
	/* Invalid type. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_INVALID		UINT32_C(0xffff)
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_LAST		HWRM_FUNC_BACKING_STORE_QCFG_V2_INPUT_TYPE_INVALID
	/*
	 * Instance of the backing store type. It is zero-based,
	 * which means "0" indicates the first instance. For backing
	 * stores with single instance only, leave this field to 0.
	 * 1. If the backing store type is MPC TQM ring, use the following
	 *	instance value to map to MPC clients:
	 *	TCE (0), RCE (1), TE_CFA(2), RE_CFA (3), PRIMATE(4)
	 * 2. If the backing store type is TBL_SCOPE, use the following
	 *	instance value to map to table scope regions:
	 *	RE_CFA_LKUP (0), RE_CFA_ACT (1), TE_CFA_LKUP(2), TE_CFA_ACT (3)
	 * 3. If the backing store type is XID partition, use the following
	 *	instance value to map to context types:
	 *	TX_CK (0), RX_CK (1)
	 */
	uint16_t	instance;
	uint8_t	rsvd[4];
} __attribute__((packed));

/* hwrm_func_backing_store_qcfg_v2_output (size:448b/56B) */

struct hwrm_func_backing_store_qcfg_v2_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Type of backing store to be configured. */
	uint16_t	type;
	/* Queue pair. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_QP		UINT32_C(0x0)
	/* Shared receive queue. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_SRQ		UINT32_C(0x1)
	/* Completion queue. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CQ		UINT32_C(0x2)
	/* Virtual NIC. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_VNIC		UINT32_C(0x3)
	/* Statistic context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_STAT		UINT32_C(0x4)
	/* Slow-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_SP_TQM_RING	UINT32_C(0x5)
	/* Fast-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_FP_TQM_RING	UINT32_C(0x6)
	/* Memory Region and Memory Address Vector Context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_MRAV		UINT32_C(0xe)
	/* TIM. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_TIM		UINT32_C(0xf)
	/* Tx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_TX_CK		UINT32_C(0x13)
	/* Rx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_RX_CK		UINT32_C(0x14)
	/* Mid-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_MP_TQM_RING	UINT32_C(0x15)
	/* CFA table scope context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_TBL_SCOPE	UINT32_C(0x1c)
	/* XID partition context. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_XID_PARTITION	UINT32_C(0x1d)
	/* SRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_SRT_TRACE	UINT32_C(0x1e)
	/* SRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_SRT2_TRACE	UINT32_C(0x1f)
	/* CRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CRT_TRACE	UINT32_C(0x20)
	/* CRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CRT2_TRACE	UINT32_C(0x21)
	/* RIGP0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_RIGP0_TRACE	UINT32_C(0x22)
	/* L2 HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_L2_HWRM_TRACE	UINT32_C(0x23)
	/* RoCE HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_ROCE_HWRM_TRACE	UINT32_C(0x24)
	/* TimedTx pacing TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_TTX_PACING_TQM_RING UINT32_C(0x25)
	/* Context Accelerator CPU 0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CA0_TRACE	UINT32_C(0x26)
	/* Context Accelerator CPU 1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CA1_TRACE	UINT32_C(0x27)
	/* Context Accelerator CPU 2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_CA2_TRACE	UINT32_C(0x28)
	/* RIGP1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_RIGP1_TRACE	UINT32_C(0x29)
	/* Invalid type. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_INVALID		UINT32_C(0xffff)
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_LAST		HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_TYPE_INVALID
	/*
	 * Instance of the backing store type. It is zero-based,
	 * which means "0" indicates the first instance. For backing
	 * stores with single instance only, leave this field to 0.
	 * 1. If the backing store type is MPC TQM ring, use the following
	 *	instance value to map to MPC clients:
	 *	TCE (0), RCE (1), TE_CFA(2), RE_CFA (3), PRIMATE(4)
	 * 2. If the backing store type is TBL_SCOPE, use the following
	 *	instance value to map to table scope regions:
	 *	RE_CFA_LKUP (0), RE_CFA_ACT (1), TE_CFA_LKUP(2), TE_CFA_ACT (3)
	 * 3. If the backing store type is XID partition, use the following
	 *	instance value to map to context types:
	 *	TX_CK (0), RX_CK (1)
	 */
	uint16_t	instance;
	/* Control flags. */
	uint32_t	flags;
	/* Page directory. */
	uint64_t	page_dir;
	/* Number of entries */
	uint32_t	num_entries;
	/* Page size and pbl level. */
	uint8_t	page_size_pbl_level;
	/* PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_MASK  UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_SFT   0
	/* PBL pointer is physical start address. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_LVL_0   UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_LVL_1   UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_LVL_2   UINT32_C(0x2)
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_LAST   HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PBL_LEVEL_LVL_2
	/* Page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_MASK  UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_SFT   4
	/* 4KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_4K   (UINT32_C(0x0) << 4)
	/* 8KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_8K   (UINT32_C(0x1) << 4)
	/* 64KB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_64K  (UINT32_C(0x2) << 4)
	/* 2MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_2M   (UINT32_C(0x3) << 4)
	/* 8MB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_8M   (UINT32_C(0x4) << 4)
	/* 1GB. */
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_1G   (UINT32_C(0x5) << 4)
		#define HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_LAST   HWRM_FUNC_BACKING_STORE_QCFG_V2_OUTPUT_PAGE_SIZE_PG_1G
	/*
	 * This field counts how many split entries contain valid data.
	 * Below is the table that maps the count value:
	 * | count |			Indication			|
	 * | ----- | -------------------------------------------------- |
	 * |   0   | None of the split entries has valid data.	|
	 * |   1   | Only "split_entry_0" contains valid data.	|
	 * |   2   | Only "split_entry_0" and "1" have valid data.	|
	 * |   3   | Only "split_entry_0", "1" and "2" have valid data. |
	 * |   4   | All four split entries have valid data.		|
	 */
	uint8_t	subtype_valid_cnt;
	uint8_t	rsvd[2];
	/*
	 * Split entry #0. Note that the four split entries (as a group)
	 * must be cast to a type-specific data structure first before
	 * accessing it! Below is the table that maps a backing store
	 * type to the associated split entry casting data structure.
	 * | Type |	Split Entry Casting Data Structure	|
	 * | ---- | -------------------------------------------------- |
	 * | QPC  |		qpc_split_entries			|
	 * | SRQ  |		srq_split_entries			|
	 * | CQ   |		cq_split_entries			|
	 * | VINC |		vnic_split_entries			|
	 * | MRAV |		mrav_split_entries			|
	 * | TS   |		ts_split_entries			|
	 * | CK   |		ck_split_entries			|
	 */
	uint32_t	split_entry_0;
	/* Split entry #1. */
	uint32_t	split_entry_1;
	/* Split entry #2. */
	uint32_t	split_entry_2;
	/* Split entry #3. */
	uint32_t	split_entry_3;
	uint8_t	rsvd2[7];
	/*
	 * This field is used in Output records to indicate that the
	 * output is completely written to RAM. This field should be
	 * read as '1' to indicate that the output has been completely
	 * written. When writing a command completion or response to
	 * an internal processor, the order of writes has to be such
	 * that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* Common structure to cast QPC split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is QPC. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* qpc_split_entries (size:128b/16B) */

struct qpc_split_entries {
	/* Number of L2 QP backing store entries. */
	uint32_t	qp_num_l2_entries;
	/* Number of QP1 entries. */
	uint32_t	qp_num_qp1_entries;
	/*
	 * Number of RoCE QP context entries required for this
	 * function to support fast QP modify destroy feature.
	 */
	uint32_t	qp_num_fast_qpmd_entries;
	uint32_t	rsvd;
} __attribute__((packed));

/* Common structure to cast SRQ split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is SRQ. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* srq_split_entries (size:128b/16B) */

struct srq_split_entries {
	/* Number of L2 SRQ backing store entries. */
	uint32_t	srq_num_l2_entries;
	uint32_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/* Common structure to cast CQ split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is CQ. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* cq_split_entries (size:128b/16B) */

struct cq_split_entries {
	/* Number of L2 CQ backing store entries. */
	uint32_t	cq_num_l2_entries;
	uint32_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/* Common structure to cast VNIC split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is VNIC. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* vnic_split_entries (size:128b/16B) */

struct vnic_split_entries {
	/* Number of VNIC backing store entries. */
	uint32_t	vnic_num_vnic_entries;
	uint32_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/* Common structure to cast MRAV split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is MRAV. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* mrav_split_entries (size:128b/16B) */

struct mrav_split_entries {
	/* Number of AV backing store entries. */
	uint32_t	mrav_num_av_entries;
	uint32_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/* Common structure to cast TBL_SCOPE split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is TBL_SCOPE. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* ts_split_entries (size:128b/16B) */

struct ts_split_entries {
	/* Max number of TBL_SCOPE region entries (QCAPS). */
	uint32_t	region_num_entries;
	/* tsid to configure (CFG). */
	uint8_t	tsid;
	/*
	 * Lkup static bucket count (power of 2).
	 * Array is indexed by enum cfa_dir
	 */
	uint8_t	lkup_static_bkt_cnt_exp[2];
	uint8_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/* Common structure to cast crypto key split entries. This casting is required in the following HWRM command inputs/outputs if the backing store type is TX_CK or RX_CK. 1. hwrm_func_backing_store_cfg_v2_input 2. hwrm_func_backing_store_qcfg_v2_output 3. hwrm_func_backing_store_qcaps_v2_output */
/* ck_split_entries (size:128b/16B) */

struct ck_split_entries {
	/*
	 * Number of QUIC backing store entries. That means the number of KTLS
	 * backing store entries is the difference between this number and the
	 * total number of crypto key entries.
	 */
	uint32_t	num_quic_entries;
	uint32_t	rsvd;
	uint64_t	rsvd2;
} __attribute__((packed));

/************************************
 * hwrm_func_backing_store_qcaps_v2 *
 ************************************/


/* hwrm_func_backing_store_qcaps_v2_input (size:192b/24B) */

struct hwrm_func_backing_store_qcaps_v2_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Type of backing store to be queried. */
	uint16_t	type;
	/* Queue pair. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_QP		UINT32_C(0x0)
	/* Shared receive queue. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SRQ		UINT32_C(0x1)
	/* Completion queue. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CQ		UINT32_C(0x2)
	/* Virtual NIC. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_VNIC		UINT32_C(0x3)
	/* Statistic context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_STAT		UINT32_C(0x4)
	/* Slow-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SP_TQM_RING	UINT32_C(0x5)
	/* Fast-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_FP_TQM_RING	UINT32_C(0x6)
	/* Memory Region and Memory Address Vector Context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_MRAV		UINT32_C(0xe)
	/* TIM. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_TIM		UINT32_C(0xf)
	/* Tx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_TX_CK		UINT32_C(0x13)
	/* Rx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_RX_CK		UINT32_C(0x14)
	/* Mid-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_MP_TQM_RING	UINT32_C(0x15)
	/* SQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SQ_DB_SHADOW	UINT32_C(0x16)
	/* RQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_RQ_DB_SHADOW	UINT32_C(0x17)
	/* SRQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SRQ_DB_SHADOW	UINT32_C(0x18)
	/* CQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CQ_DB_SHADOW	UINT32_C(0x19)
	/* CFA table scope context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_TBL_SCOPE	UINT32_C(0x1c)
	/* XID partition context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_XID_PARTITION	UINT32_C(0x1d)
	/* SRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SRT_TRACE	UINT32_C(0x1e)
	/* SRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_SRT2_TRACE	UINT32_C(0x1f)
	/* CRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CRT_TRACE	UINT32_C(0x20)
	/* CRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CRT2_TRACE	UINT32_C(0x21)
	/* RIGP0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_RIGP0_TRACE	UINT32_C(0x22)
	/* L2 HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_L2_HWRM_TRACE	UINT32_C(0x23)
	/* RoCE HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_ROCE_HWRM_TRACE	UINT32_C(0x24)
	/* TimedTx pacing TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_TTX_PACING_TQM_RING UINT32_C(0x25)
	/* Context Accelerator CPU 0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CA0_TRACE	UINT32_C(0x26)
	/* Context Accelerator CPU 1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CA1_TRACE	UINT32_C(0x27)
	/* Context Accelerator CPU 2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_CA2_TRACE	UINT32_C(0x28)
	/* RIGP1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_RIGP1_TRACE	UINT32_C(0x29)
	/* Invalid type. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_INVALID		UINT32_C(0xffff)
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_LAST		HWRM_FUNC_BACKING_STORE_QCAPS_V2_INPUT_TYPE_INVALID
	uint8_t	rsvd[6];
} __attribute__((packed));

/* hwrm_func_backing_store_qcaps_v2_output (size:448b/56B) */

struct hwrm_func_backing_store_qcaps_v2_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Type of backing store to be queried. */
	uint16_t	type;
	/* Queue pair. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_QP		UINT32_C(0x0)
	/* Shared receive queue. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SRQ		UINT32_C(0x1)
	/* Completion queue. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CQ		UINT32_C(0x2)
	/* Virtual NIC. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_VNIC		UINT32_C(0x3)
	/* Statistic context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_STAT		UINT32_C(0x4)
	/* Slow-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SP_TQM_RING	UINT32_C(0x5)
	/* Fast-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_FP_TQM_RING	UINT32_C(0x6)
	/* Memory Region and Memory Address Vector Context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_MRAV		UINT32_C(0xe)
	/* TIM. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_TIM		UINT32_C(0xf)
	/* Tx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_TX_CK		UINT32_C(0x13)
	/* Rx crypto key. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_RX_CK		UINT32_C(0x14)
	/* Mid-path TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_MP_TQM_RING	UINT32_C(0x15)
	/* SQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SQ_DB_SHADOW	UINT32_C(0x16)
	/* RQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_RQ_DB_SHADOW	UINT32_C(0x17)
	/* SRQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SRQ_DB_SHADOW	UINT32_C(0x18)
	/* CQ Doorbell shadow region. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CQ_DB_SHADOW	UINT32_C(0x19)
	/* CFA table scope context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_TBL_SCOPE	UINT32_C(0x1c)
	/* XID partition context. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_XID_PARTITION	UINT32_C(0x1d)
	/* SRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SRT_TRACE	UINT32_C(0x1e)
	/* SRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_SRT2_TRACE	UINT32_C(0x1f)
	/* CRT trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CRT_TRACE	UINT32_C(0x20)
	/* CRT2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CRT2_TRACE	UINT32_C(0x21)
	/* RIGP0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_RIGP0_TRACE	UINT32_C(0x22)
	/* L2 HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_L2_HWRM_TRACE	UINT32_C(0x23)
	/* RoCE HWRM trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_ROCE_HWRM_TRACE	UINT32_C(0x24)
	/* TimedTx pacing TQM ring. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_TTX_PACING_TQM_RING UINT32_C(0x25)
	/* Context Accelerator CPU 0 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CA0_TRACE	UINT32_C(0x26)
	/* Context Accelerator CPU 1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CA1_TRACE	UINT32_C(0x27)
	/* Context Accelerator CPU 2 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_CA2_TRACE	UINT32_C(0x28)
	/* RIGP1 trace. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_RIGP1_TRACE	UINT32_C(0x29)
	/* Invalid type. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_INVALID		UINT32_C(0xffff)
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_LAST		HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_TYPE_INVALID
	/* Number of bytes per backing store entry. */
	uint16_t	entry_size;
	/* Control flags. */
	uint32_t	flags;
	/*
	 * When set, it indicates the context type should be initialized
	 * with the 'ctx_init_value' at the specified offset.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_ENABLE_CTX_KIND_INIT		UINT32_C(0x1)
	/* When set, it indicates the context type is valid. */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_TYPE_VALID			UINT32_C(0x2)
	/*
	 * When set, it indicates the region for this type is not a regular
	 * context memory but a driver managed memory that is created,
	 * initialized and managed by the driver.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_DRIVER_MANAGED_MEMORY	UINT32_C(0x4)
	/*
	 * When set, it indicates the support of the following capability
	 * that is specific to the QP type:
	 * - For 2-port adapters, the ability to extend the RoCE QP
	 *   entries configured on a PF, during some network events such as
	 *   Link Down. These additional entries count is included in the
	 *   advertised 'max_num_entries'.
	 * - The count of RoCE QP entries, derived from 'max_num_entries'
	 *   (max_num_entries - qp_num_qp1_entries - qp_num_l2_entries -
	 *   qp_num_fast_qpmd_entries, note qp_num_fast_qpmd_entries is
	 *   always zero when QPs are pseudo-statically allocated), includes
	 *   the count of QPs that can be migrated from the other PF (e.g.,
	 *   during network link down). Therefore, during normal operation
	 *   when both PFs are active, the supported number of RoCE QPs for
	 *   each of the PF is half of the advertised value.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_ROCE_QP_PSEUDO_STATIC_ALLOC	UINT32_C(0x8)
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_FW_DBG_TRACE                      UINT32_C(0x10)

	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_FW_BIN_DBG_TRACE          UINT32_C(0x20)

	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_FLAGS_NEXT_BS_OFFSET            UINT32_C(0x40)
	/*
	 * Bit map of the valid instances associated with the
	 * backing store type.
	 * 1. If the backing store type is MPC TQM ring, use the following
	 *	bits to map to MPC clients:
	 *	TCE (0), RCE (1), TE_CFA(2), RE_CFA (3), PRIMATE(4)
	 * 2. If the backing store type is TBL_SCOPE, use the following
	 *	bits to map to table scope regions:
	 *	RE_CFA_LKUP (0), RE_CFA_ACT (1), TE_CFA_LKUP(2), TE_CFA_ACT (3)
	 * 3. If the backing store type is VF XID partition in-use table, use
	 *	the following bits to map to context types:
	 *	TX_CK (0), RX_CK (1)
	 */
	uint32_t	instance_bit_map;
	/*
	 * Initializer to be used by drivers to initialize context memory
	 * to ensure context subsystem flags an error for an attack before
	 * the first time context load.
	 */
	uint8_t	ctx_init_value;
	/*
	 * Specifies the doubleword offset of ctx_init_value for this
	 * context type.
	 */
	uint8_t	ctx_init_offset;
	/*
	 * Some backing store types, e.g., TQM rings, require the number
	 * of entries to be a multiple of this value to prevent any
	 * resource allocation limitations. If not applicable, leave
	 * this field with "0".
	 */
	uint8_t	entry_multiple;
	uint8_t	rsvd;
	/* Maximum number of backing store entries supported for this type. */
	uint32_t	max_num_entries;
	/*
	 * Minimum number of backing store entries required for this type.
	 * This field is only valid for some backing store types, e.g.,
	 * TQM rings. If not applicable, leave this field with "0".
	 */
	uint32_t	min_num_entries;
	/*
	 * Next valid backing store type. If current type queried is already
	 * the last valid type, firmware must set this field to invalid type.
	 */
	uint16_t	next_valid_type;
	/*
	 * This field counts how many split entries contain valid data.
	 * Below is the table that maps the count value:
	 * | count |			Indication			|
	 * | ----- | -------------------------------------------------- |
	 * |   0   | None of the split entries has valid data.	|
	 * |   1   | Only "split_entry_0" contains valid data.	|
	 * |   2   | Only "split_entry_0" and "1" have valid data.	|
	 * |   3   | Only "split_entry_0", "1" and "2" have valid data. |
	 * |   4   | All four split entries have valid data.		|
	 */
	uint8_t	subtype_valid_cnt;
	/*
	 * Bitmap that indicates if each of the 'split_entry' denotes an
	 * exact count (i.e., min = max). When the exact count bit is set,
	 * it indicates the exact number of entries as advertised has to be
	 * configured. The 'split_entry' to be set to contain exact count by
	 * this bitmap needs to be a valid split entry specified by
	 * 'subtype_valid_cnt'.
	 */
	uint8_t	exact_cnt_bit_map;
	/*
	 * When this bit is '1', it indicates 'split_entry_0' contains
	 * an exact count.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_SPLIT_ENTRY_0_EXACT	UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates 'split_entry_1' contains
	 * an exact count.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_SPLIT_ENTRY_1_EXACT	UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates 'split_entry_2' contains
	 * an exact count.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_SPLIT_ENTRY_2_EXACT	UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates 'split_entry_3' contains
	 * an exact count.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_SPLIT_ENTRY_3_EXACT	UINT32_C(0x8)
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_UNUSED_MASK		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCAPS_V2_OUTPUT_EXACT_CNT_BIT_MAP_UNUSED_SFT		4
	/*
	 * Split entry #0. Note that the four split entries (as a group)
	 * must be cast to a type-specific data structure first before
	 * accessing it! Below is the table that maps a backing store
	 * type to the associated split entry casting data structure.
	 * | Type |	Split Entry Casting Data Structure	|
	 * | ---- | -------------------------------------------------- |
	 * | QPC  |		qpc_split_entries			|
	 * | SRQ  |		srq_split_entries			|
	 * | CQ   |		cq_split_entries			|
	 * | VINC |		vnic_split_entries			|
	 * | MRAV |		mrav_split_entries			|
	 * | TS   |		ts_split_entries			|
	 */
	uint32_t	split_entry_0;
	/* Split entry #1. */
	uint32_t	split_entry_1;
	/* Split entry #2. */
	uint32_t	split_entry_2;
	/* Split entry #3. */
	uint32_t	split_entry_3;
	uint8_t	rsvd3[3];
	/*
	 * This field is used in Output records to indicate that the
	 * output is completely written to RAM. This field should be
	 * read as '1' to indicate that the output has been completely
	 * written. When writing a command completion or response to
	 * an internal processor, the order of writes has to be such
	 * that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_func_dbr_pacing_cfg *
 ****************************/


/* hwrm_func_dbr_pacing_cfg_input (size:320b/40B) */

struct hwrm_func_dbr_pacing_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * This bit must be '1' to enable DBR NQ events. The NQ ID to
	 * receive the events must be specified in the primary_nq_id
	 * field.
	 */
	#define HWRM_FUNC_DBR_PACING_CFG_INPUT_FLAGS_DBR_NQ_EVENT_ENABLE	UINT32_C(0x1)
	/* This bit must be '1' to disable DBR NQ events. */
	#define HWRM_FUNC_DBR_PACING_CFG_INPUT_FLAGS_DBR_NQ_EVENT_DISABLE	UINT32_C(0x2)
	uint8_t	unused_0[7];
	uint32_t	enables;
	/*
	 * This bit must be '1' for the primary_nq_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_DBR_PACING_CFG_INPUT_ENABLES_PRIMARY_NQ_ID_VALID	UINT32_C(0x1)
	/*
	 * This bit must be '1' for the pacing_threshold field to be
	 * configured.
	 */
	#define HWRM_FUNC_DBR_PACING_CFG_INPUT_ENABLES_PACING_THRESHOLD_VALID	UINT32_C(0x2)
	/*
	 * Specify primary function's NQ ID to receive the doorbell pacing
	 * threshold crossing events.
	 */
	uint32_t	primary_nq_id;
	/*
	 * Specify pacing threshold value, as a percentage of the max
	 * doorbell FIFO depth. The range is 1 to 36.
	 */
	uint32_t	pacing_threshold;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_func_dbr_pacing_cfg_output (size:128b/16B) */

struct hwrm_func_dbr_pacing_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM. This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal
	 * processor, the order of writes has to be such that this field is
	 * written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_func_dbr_pacing_qcfg *
 *****************************/


/* hwrm_func_dbr_pacing_qcfg_input (size:128b/16B) */

struct hwrm_func_dbr_pacing_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFC, 0xFFFE - Reserved for internal processors
	 * * 0xFFFD - Reserved for user-space HWRM interface
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_func_dbr_pacing_qcfg_output (size:512b/64B) */

struct hwrm_func_dbr_pacing_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	flags;
	/* When this bit is '1', it indicates DBR NQ events are enabled. */
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_FLAGS_DBR_NQ_EVENT_ENABLED	UINT32_C(0x1)
	uint8_t	unused_0[7];
	/*
	 * The Doorbell global FIFO occupancy register. This field should be
	 * used by the driver and user library in the doorbell pacing
	 * algorithm. Lower 2 bits indicates address space location and upper
	 * 30 bits indicates upper 30bits of the register address. A value of
	 * 0xFFFF-FFFF indicates this register does not exist.
	 */
	uint32_t	dbr_stat_db_fifo_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2, this register is located in first BAR address
	 * space. Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_BAR0	UINT32_C(0x2)
	/*
	 * If value is 3, this register is located in second BAR address
	 * space. Drivers have to map appropriate window to access this
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_BAR1	UINT32_C(0x3)
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_LAST	HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SPACE_BAR1
	/* Upper 30bits of the register address. */
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_MASK	UINT32_C(0xfffffffc)
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_STAT_DB_FIFO_REG_ADDR_SFT	2
	/*
	 * This field indicates the mask value for dbr_stat_db_fifo_reg
	 * to get the high watermark for doorbell FIFO.
	 */
	uint32_t	dbr_stat_db_fifo_reg_watermark_mask;
	/*
	 * This field indicates the shift value for dbr_stat_db_fifo_reg
	 * to get the high watermark for doorbell FIFO.
	 */
	uint8_t	dbr_stat_db_fifo_reg_watermark_shift;
	uint8_t	unused_1[3];
	/*
	 * This field indicates the mask value for dbr_stat_db_fifo_reg
	 * to get the amount of room left for doorbell FIFO.
	 */
	uint32_t	dbr_stat_db_fifo_reg_fifo_room_mask;
	/*
	 * This field indicates the shift value for dbr_stat_db_fifo_reg
	 * to get the amount of room left for doorbell FIFO.
	 */
	uint8_t	dbr_stat_db_fifo_reg_fifo_room_shift;
	uint8_t	unused_2[3];
	/*
	 * DBR_REG_AEQ_ARM register. This field should be used by the driver
	 * to rearm the interrupt for regeneration of a notification to the
	 * host from the hardware when the global doorbell occupancy threshold
	 * is above the threshold value. Lower 2 bits indicates address space
	 * location and upper 30 bits indicates upper 30bits of the register
	 * address. A value of 0xFFFF-FFFF indicates this register does not
	 * exist.
	 */
	uint32_t	dbr_throttling_aeq_arm_reg;
	/* Lower 2 bits indicates address space location. */
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_THROTTLING_AEQ_ARM_REG_ADDR_SPACE_MASK	UINT32_C(0x3)
	#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_THROTTLING_AEQ_ARM_REG_ADDR_SPACE_SFT	0
	/*
	 * If value is 0, this register is located in PCIe config space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_THROTTLING_AEQ_ARM_REG_ADDR_SPACE_PCIE_CFG  UINT32_C(0x0)
	/*
	 * If value is 1, this register is located in GRC address space.
	 * Drivers have to map appropriate window to access this
	 * register.
	 */
		#define HWRM_FUNC_DBR_PACING_QCFG_OUTPUT_DBR_THROTTLING_AEQ_ARM_REG_ADDR_SPACE_GRC	UINT32_C(0x1)
	/*
	 * If value is 2,