/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSRecord.class.getName());
    private int ttl;
    private long created;
    private InetAddress source;

    DNSRecord(String name, int type, int clazz, int ttl) {
        super(name, type, clazz);
        this.ttl = ttl;
        this.created = System.currentTimeMillis();
    }

    public boolean equals(Object other) {
        return other instanceof DNSRecord && this.sameAs((DNSRecord)other);
    }

    boolean sameAs(DNSRecord other) {
        return super.equals(other) && this.sameValue(other);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord other) {
        return this.type == other.type;
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    abstract DNSOutgoing addAnswer(JmDNSImpl var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming msg) {
        try {
            int i = msg.numAnswers;
            while (i-- > 0) {
                if (!this.suppressedBy((DNSRecord)msg.answers.get(i))) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "suppressedBy() message " + msg + " exception ", e);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord other) {
        return this.sameAs(other) && other.ttl > this.ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this.created + (long)(percent * this.ttl) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    void resetTTL(DNSRecord other) {
        this.created = other.created;
        this.ttl = other.ttl;
    }

    abstract void write(DNSOutgoing var1) throws IOException;

    public void setRecordSource(InetAddress source) {
        this.source = source;
    }

    public InetAddress getRecordSource() {
        return this.source;
    }

    public String toString(String other) {
        return this.toString("record", this.ttl + "/" + this.getRemainingTTL(System.currentTimeMillis()) + "," + other);
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getTtl() {
        return this.ttl;
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Service.class.getName());
        int priority;
        int weight;
        int port;
        String server;

        public Service(String name, int type, int clazz, int ttl, int priority, int weight, int port, String server) {
            super(name, type, clazz, ttl);
            this.priority = priority;
            this.weight = weight;
            this.port = port;
            this.server = server;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeShort(this.priority);
            out.writeShort(this.weight);
            out.writeShort(this.port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                out.writeName(this.server, false);
            } else {
                out.writeUTF(this.server, 0, this.server.length());
                out.writeByte(0);
            }
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.write(this.name.getBytes("UTF8"));
                dout.writeShort(this.type);
                dout.writeShort(this.clazz);
                dout.writeShort(this.priority);
                dout.writeShort(this.weight);
                dout.writeShort(this.port);
                dout.write(this.server.getBytes("UTF8"));
                dout.close();
                return bout.toByteArray();
            }
            catch (IOException e) {
                throw new InternalError();
            }
        }

        private int lexCompare(Service that) {
            byte[] thisBytes = this.toByteArray();
            byte[] thatBytes = that.toByteArray();
            int n = Math.min(thisBytes.length, thatBytes.length);
            for (int i = 0; i < n; ++i) {
                if (thisBytes[i] > thatBytes[i]) {
                    return 1;
                }
                if (thisBytes[i] >= thatBytes[i]) continue;
                return -1;
            }
            return thisBytes.length - thatBytes.length;
        }

        boolean sameValue(DNSRecord other) {
            Service s = (Service)other;
            return this.priority == s.priority && this.weight == s.weight && this.port == s.port && this.server.equals(s.server);
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.name.toLowerCase());
            if (!(info == null || this.port == info.port && this.server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger.finer("handleQuery() Conflicting probe detected from: " + this.getRecordSource());
                Service localService = new Service(info.getQualifiedName(), 33, 32769, 3600, info.priority, info.weight, info.port, dns.getLocalHost().getName());
                try {
                    if (dns.getInterface().equals(this.getRecordSource())) {
                        logger.warning("Got conflicting probe from ourselves\nincoming: " + this.toString() + "\n" + "local   : " + localService.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int comparison = this.lexCompare(localService);
                if (comparison == 0) {
                    logger.finer("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!info.getState().isProbing() || comparison <= 0) {
                    return false;
                }
                String oldName = info.getQualifiedName().toLowerCase();
                info.setName(dns.incrementName(info.getName()));
                dns.getServices().remove(oldName);
                dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                logger.finer("handleQuery() Lost tie break: new unique name chosen:" + info.getName());
                info.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.name.toLowerCase());
            if (!(info == null || this.port == info.port && this.server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger.finer("handleResponse() Denial detected");
                if (info.getState().isProbing()) {
                    String oldName = info.getQualifiedName().toLowerCase();
                    info.setName(dns.incrementName(info.getName()));
                    dns.getServices().remove(oldName);
                    dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                    logger.finer("handleResponse() New unique name chose:" + info.getName());
                }
                info.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.name.toLowerCase());
            if (info != null && this.port == info.port != this.server.equals(dns.getLocalHost().getName())) {
                return dns.addAnswer(in, addr, port, out, new Service(info.getQualifiedName(), 33, 32769, 3600, info.priority, info.weight, info.port, dns.getLocalHost().getName()));
            }
            return out;
        }

        public String toString() {
            return this.toString(this.server + ":" + this.port);
        }
    }

    public static class Text
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Text.class.getName());
        byte[] text;

        public Text(String name, int type, int clazz, int ttl, byte[] text) {
            super(name, type, clazz, ttl);
            this.text = text;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeBytes(this.text, 0, this.text.length);
        }

        boolean sameValue(DNSRecord other) {
            Text txt = (Text)other;
            if (txt.text.length != this.text.length) {
                return false;
            }
            int i = this.text.length;
            while (i-- > 0) {
                if (txt.text[i] == this.text[i]) continue;
                return false;
            }
            return true;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public String toString() {
            return this.toString(this.text.length > 10 ? new String(this.text, 0, 7) + "..." : new String(this.text));
        }
    }

    public static class Pointer
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Pointer.class.getName());
        String alias;

        public Pointer(String name, int type, int clazz, int ttl, String alias) {
            super(name, type, clazz, ttl);
            this.alias = alias;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeName(this.alias);
        }

        boolean sameValue(DNSRecord other) {
            return this.alias.equals(((Pointer)other).alias);
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        String getAlias() {
            return this.alias;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public String toString() {
            return this.toString(this.alias);
        }
    }

    static class Address
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Address.class.getName());
        InetAddress addr;

        Address(String name, int type, int clazz, int ttl, InetAddress addr) {
            super(name, type, clazz, ttl);
            this.addr = addr;
        }

        Address(String name, int type, int clazz, int ttl, byte[] rawAddress) {
            super(name, type, clazz, ttl);
            try {
                this.addr = InetAddress.getByAddress(rawAddress);
            }
            catch (UnknownHostException exception) {
                logger.log(Level.WARNING, "Address() exception ", exception);
            }
        }

        void write(DNSOutgoing out) throws IOException {
            if (this.addr != null) {
                byte[] tempbuffer;
                byte[] buffer = this.addr.getAddress();
                if (1 == this.type) {
                    if (!(this.addr instanceof Inet4Address)) {
                        tempbuffer = buffer;
                        buffer = new byte[4];
                        System.arraycopy(tempbuffer, 12, buffer, 0, 4);
                    }
                } else if (this.addr instanceof Inet4Address) {
                    tempbuffer = buffer;
                    buffer = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
                    }
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        boolean same(DNSRecord other) {
            return this.sameName(other) && this.sameValue(other);
        }

        boolean sameName(DNSRecord other) {
            return this.name.equalsIgnoreCase(((Address)other).name);
        }

        boolean sameValue(DNSRecord other) {
            return this.addr.equals(((Address)other).getAddress());
        }

        InetAddress getAddress() {
            return this.addr;
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.write(this.name.getBytes("UTF8"));
                dout.writeShort(this.type);
                dout.writeShort(this.clazz);
                byte[] buffer = this.addr.getAddress();
                for (int i = 0; i < buffer.length; ++i) {
                    dout.writeByte(buffer[i]);
                }
                dout.close();
                return bout.toByteArray();
            }
            catch (IOException e) {
                throw new InternalError();
            }
        }

        private int lexCompare(Address that) {
            byte[] thisBytes = this.toByteArray();
            byte[] thatBytes = that.toByteArray();
            int n = Math.min(thisBytes.length, thatBytes.length);
            for (int i = 0; i < n; ++i) {
                if (thisBytes[i] > thatBytes[i]) {
                    return 1;
                }
                if (thisBytes[i] >= thatBytes[i]) continue;
                return -1;
            }
            return thisBytes.length - thatBytes.length;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger.finer("handleQuery() Conflicting probe detected. dns state " + dns.getState() + " lex compare " + this.lexCompare(dnsAddress));
                if (dns.getState().isProbing() && this.lexCompare(dnsAddress) >= 0) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfoImpl info : dns.getServices().values()) {
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger.finer("handleResponse() Denial detected");
                if (dns.getState().isProbing()) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfoImpl info : dns.getServices().values()) {
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public String toString() {
            return this.toString(" address '" + (this.addr != null ? this.addr.getHostAddress() : "null") + "'");
        }
    }
}

