/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class TlsUtil {
    private static final String PEM_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final List<KeyFactory> SUPPORTED_KEY_FACTORIES = new ArrayList<KeyFactory>();

    private TlsUtil() {
    }

    public static X509KeyManager keyManager(byte[] privateKeyPem, byte[] certificatePem) throws SSLException {
        Objects.requireNonNull(privateKeyPem, "privateKeyPem");
        Objects.requireNonNull(certificatePem, "certificatePem");
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(TlsUtil.decodePem(privateKeyPem));
            PrivateKey key = TlsUtil.generatePrivateKey(keySpec, SUPPORTED_KEY_FACTORIES);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(certificatePem);
            List chain = (List)cf.generateCertificates(is);
            ks.setKeyEntry("trusted", key, "".toCharArray(), chain.toArray(new Certificate[0]));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "".toCharArray());
            return (X509KeyManager)kmf.getKeyManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SSLException("Could not build KeyManagerFactory from clientKeysPem.", e);
        }
    }

    static PrivateKey generatePrivateKey(PKCS8EncodedKeySpec keySpec, List<KeyFactory> keyFactories) throws SSLException {
        for (KeyFactory factory : keyFactories) {
            try {
                return factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        throw new SSLException("Unable to generate key from supported algorithms: " + keyFactories.stream().map(KeyFactory::getAlgorithm).collect(Collectors.joining(",", "[", "]")));
    }

    public static X509TrustManager trustManager(byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ByteArrayInputStream is = new ByteArrayInputStream(trustedCertificatesPem);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            int i = 0;
            List certificates = (List)factory.generateCertificates(is);
            for (Certificate certificate : certificates) {
                ks.setCertificateEntry("cert_" + i, certificate);
                ++i;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            return (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSLException("Could not build TrustManagerFactory from trustedCertificatesPem.", e);
        }
    }

    static byte[] decodePem(byte[] pem) {
        String pemStr = new String(pem, StandardCharsets.UTF_8).trim();
        if (!pemStr.startsWith(PEM_KEY_HEADER) || !pemStr.endsWith(PEM_KEY_FOOTER)) {
            return pem;
        }
        String contentWithNewLines = pemStr.substring(PEM_KEY_HEADER.length(), pemStr.length() - PEM_KEY_FOOTER.length());
        String content = contentWithNewLines.replaceAll("\\s", "");
        return Base64.getDecoder().decode(content);
    }

    static {
        try {
            SUPPORTED_KEY_FACTORIES.add(KeyFactory.getInstance("RSA"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            SUPPORTED_KEY_FACTORIES.add(KeyFactory.getInstance("EC"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

