/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import java.util.Date;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.OctetStringEncoder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPUtil;

public abstract class NamedParameterCondition
implements Condition {
    private String parameterName;
    private boolean binary;

    public NamedParameterCondition(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public void updateParameterName(String modelParamName, String ldapParamName) {
        if (this.parameterName.equalsIgnoreCase(modelParamName)) {
            this.parameterName = ldapParamName;
        }
    }

    @Override
    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    @Override
    public boolean isBinary() {
        return this.binary;
    }

    public String escapeValue(Object value) {
        if (Date.class.isInstance(value)) {
            value = LDAPUtil.formatDate((Date)value);
        }
        return new OctetStringEncoder(EscapeStrategy.DEFAULT).encode(value, this.isBinary());
    }
}

