/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.spi.infinispan.impl.embedded;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StatisticsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.metrics.config.MicrometerMeterRegisterConfigurationBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfigurationBuilder;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.spi.infinispan.CacheEmbeddedConfigProvider;
import org.keycloak.spi.infinispan.CacheEmbeddedConfigProviderFactory;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;
import org.keycloak.spi.infinispan.impl.Util;
import org.keycloak.spi.infinispan.impl.embedded.CacheConfigurator;
import org.keycloak.spi.infinispan.impl.embedded.JGroupsConfigurator;

public class DefaultCacheEmbeddedConfigProviderFactory
implements CacheEmbeddedConfigProviderFactory,
CacheEmbeddedConfigProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROVIDER_ID = "default";
    public static final String CONFIG = "configFile";
    public static final String CONFIG_MUTATE = "configMutate";
    public static final String TRACING = "tracingEnabled";
    private static final String HISTOGRAMS = "metricsHistogramsEnabled";
    public static final String STACK = "stack";
    public static final String NODE_NAME = "nodeName";
    public static final String SITE_NAME = "siteName";
    public static final String MACHINE_NAME = "machineName";
    public static final String RACK_NAME = "rackName";
    private volatile ConfigurationBuilderHolder builderHolder;
    private volatile Config.Scope keycloakConfig;

    public CacheEmbeddedConfigProvider create(KeycloakSession session) {
        this.lazyInit(session.getKeycloakSessionFactory());
        return this;
    }

    public void init(Config.Scope config) {
        this.keycloakConfig = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.lazyInit(factory);
    }

    @Override
    public ConfigurationBuilderHolder configuration() {
        return this.builderHolder;
    }

    @Override
    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        Util.copyFromOption(builder, CONFIG, "file", "String", CachingOptions.CACHE_CONFIG_FILE, false);
        Util.copyFromOption(builder, HISTOGRAMS, "enabled", "boolean", CachingOptions.CACHE_METRICS_HISTOGRAMS_ENABLED, false);
        Stream.concat(Arrays.stream(InfinispanConnectionProvider.LOCAL_MAX_COUNT_CACHES), Arrays.stream(InfinispanConnectionProvider.CLUSTERED_MAX_COUNT_CACHES)).forEach(name -> Util.copyFromOption(builder, CacheConfigurator.maxCountConfigKey(name), "max-count", "Integer", CachingOptions.maxCountOption((String)name), false));
        Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NUM_OWNERS).forEach(name -> builder.property().name(CacheConfigurator.numOwnerConfigKey(name)).helpText("Sets the number of owners for the %s distributed cache. It defines the number of copies of your data in the cluster.".formatted(name)).label("owners").type("Integer").add());
        DefaultCacheEmbeddedConfigProviderFactory.createTopologyProperties(builder);
        JGroupsConfigurator.createJGroupsProperties(builder);
        return builder.build();
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(JGroupsCertificateProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSessionFactory factory) {
        if (this.builderHolder != null) {
            return;
        }
        DefaultCacheEmbeddedConfigProviderFactory defaultCacheEmbeddedConfigProviderFactory = this;
        synchronized (defaultCacheEmbeddedConfigProviderFactory) {
            if (this.builderHolder != null) {
                return;
            }
            try {
                this.builderHolder = this.createConfiguration(factory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ConfigurationBuilderHolder createConfiguration(KeycloakSessionFactory factory) throws IOException {
        ConfigurationBuilderHolder holder = DefaultCacheEmbeddedConfigProviderFactory.parseConfiguration(this.keycloakConfig, factory);
        if (InfinispanUtils.isRemoteInfinispan()) {
            return DefaultCacheEmbeddedConfigProviderFactory.configureMultiSite(holder, this.keycloakConfig);
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            return DefaultCacheEmbeddedConfigProviderFactory.configureSingleSiteWithPersistentSessions(holder, this.keycloakConfig, factory);
        }
        return DefaultCacheEmbeddedConfigProviderFactory.configureSingleSiteWithVolatileSessions(holder, this.keycloakConfig, factory);
    }

    private static ConfigurationBuilderHolder configureSingleSiteWithVolatileSessions(ConfigurationBuilderHolder holder, Config.Scope keycloakConfig, KeycloakSessionFactory factory) {
        DefaultCacheEmbeddedConfigProviderFactory.singleSiteConfiguration(keycloakConfig, holder, factory);
        CacheConfigurator.configureSessionsCachesForVolatileSessions(keycloakConfig, holder);
        return holder;
    }

    private static ConfigurationBuilderHolder configureSingleSiteWithPersistentSessions(ConfigurationBuilderHolder holder, Config.Scope keycloakConfig, KeycloakSessionFactory factory) {
        DefaultCacheEmbeddedConfigProviderFactory.singleSiteConfiguration(keycloakConfig, holder, factory);
        CacheConfigurator.configureSessionsCachesForPersistentSessions(keycloakConfig, holder);
        return holder;
    }

    private static ConfigurationBuilderHolder configureMultiSite(ConfigurationBuilderHolder holder, Config.Scope keycloakConfig) {
        logger.debug((Object)"Configuring Infinispan for multi-site deployment");
        CacheConfigurator.removeClusteredCaches(holder);
        CacheConfigurator.checkCachesExist(holder, Arrays.stream(InfinispanConnectionProvider.LOCAL_CACHE_NAMES));
        DefaultCacheEmbeddedConfigProviderFactory.configureMetrics(keycloakConfig, holder);
        holder.getGlobalConfigurationBuilder().nonClusteredDefault();
        return holder;
    }

    private static ConfigurationBuilderHolder parseConfiguration(Config.Scope keycloakConfig, KeycloakSessionFactory factory) throws IOException {
        String configFile = keycloakConfig.get(CONFIG);
        if (configFile == null) {
            throw new IllegalArgumentException("Option 'configFile' needs to be specified");
        }
        Path configPath = Paths.get(configFile, new String[0]);
        String path = configPath.toFile().exists() ? configPath.toFile().getAbsolutePath() : configPath.getFileName().toString();
        logger.debugf("Parsing Infinispan configuration from file: %s", (Object)path);
        ConfigurationBuilderHolder holder = new ParserRegistry(DefaultCacheEmbeddedConfigProviderFactory.class.getClassLoader()).parseFile(path);
        holder.getGlobalConfigurationBuilder().shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        Marshalling.configure(holder.getGlobalConfigurationBuilder());
        ((KeycloakConfigurationBuilder)holder.getGlobalConfigurationBuilder().addModule(KeycloakConfigurationBuilder.class)).setKeycloakSessionFactory(factory);
        CacheConfigurator.applyDefaultConfiguration(holder, keycloakConfig.getBoolean(CONFIG_MUTATE, Boolean.FALSE) == false);
        CacheConfigurator.configureLocalCaches(keycloakConfig, holder);
        JGroupsConfigurator.configureTopology(keycloakConfig, holder);
        return holder;
    }

    private static void singleSiteConfiguration(Config.Scope config, ConfigurationBuilderHolder holder, KeycloakSessionFactory factory) {
        logger.debug((Object)"Configuring Infinispan for single-site deployment");
        CacheConfigurator.checkCachesExist(holder, Arrays.stream(InfinispanConnectionProvider.ALL_CACHES_NAME));
        CacheConfigurator.configureNumOwners(config, holder);
        CacheConfigurator.validateWorkCacheConfiguration(holder);
        CacheConfigurator.ensureMinimumOwners(holder);
        if (JGroupsConfigurator.isClustered(holder)) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> JGroupsConfigurator.configureJGroups(config, holder, session));
        }
        DefaultCacheEmbeddedConfigProviderFactory.configureMetrics(config, holder);
    }

    private static void configureMetrics(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder) {
        if (keycloakConfig.root().getBoolean(MetricsOptions.METRICS_ENABLED.getKey(), Boolean.FALSE).booleanValue()) {
            logger.debug((Object)"Enabling Infinispan metrics");
            GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
            ((MicrometerMeterRegisterConfigurationBuilder)builder.addModule(MicrometerMeterRegisterConfigurationBuilder.class)).meterRegistry((MeterRegistry)Metrics.globalRegistry);
            builder.cacheContainer().statistics(true);
            builder.metrics().namesAsTags(true).histograms(keycloakConfig.getBoolean(HISTOGRAMS, Boolean.FALSE).booleanValue());
            holder.getNamedConfigurationBuilders().values().stream().map(ConfigurationBuilder::statistics).forEach(StatisticsConfigurationBuilder::enable);
        }
    }

    private static void createTopologyProperties(ProviderConfigurationBuilder builder) {
        builder.property().name(NODE_NAME).helpText("Sets the name of the current node. This is a friendly name to make logs, etc. make more sense.").label("name").type("String").add();
        builder.property().name(SITE_NAME).helpText("The name of the site (availability zone) where this instance runs. It can be set if running Keycloak in different availability zones. Infinispan takes into consideration this value to keep the backup data spread between different sites.").label("name").type("String").add();
        builder.property().name(MACHINE_NAME).helpText("The name of the physical machine where this instance runs. It can be set if multiple Keycloak instances are running in the same physical machines. Infinispan takes into consideration this value to keep the backup data spread between different machines.").label("name").type("String").add();
        builder.property().name(RACK_NAME).helpText("The name of the rack where this instance runs. It can be set if multiple Keycloak instances are running in the same physical rack. Infinispan takes into consideration this value to keep the backup data spread between different racks.").label("name").type("String").add();
    }
}

