/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.logging;

import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;
import org.keycloak.common.Profile;
import org.keycloak.logging.MappedDiagnosticContextProvider;
import org.keycloak.logging.NoopMappedDiagnosticContextProvider;
import org.keycloak.models.KeycloakSession;

public final class MappedDiagnosticContextUtil {
    private static final Logger log = Logger.getLogger(MappedDiagnosticContextUtil.class);
    private static final MappedDiagnosticContextProvider NOOP_PROVIDER = new NoopMappedDiagnosticContextProvider();
    private static volatile Collection<String> keysToClear = Collections.emptySet();

    public static MappedDiagnosticContextProvider getMappedDiagnosticContextProvider(KeycloakSession session) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.LOG_MDC)) {
            return NOOP_PROVIDER;
        }
        if (session == null) {
            log.warn((Object)"Cannot obtain session from thread to init MappedDiagnosticContextProvider. Return Noop provider.");
            return NOOP_PROVIDER;
        }
        MappedDiagnosticContextProvider provider = (MappedDiagnosticContextProvider)session.getProvider(MappedDiagnosticContextProvider.class);
        if (provider == null) {
            return NOOP_PROVIDER;
        }
        return provider;
    }

    public static void setKeysToClear(Collection<String> keys) {
        keysToClear = keys;
    }

    public static void clearMdc() {
        for (String key : keysToClear) {
            MDC.remove((String)key);
        }
    }
}

