/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.reactivemessaging;

import io.opentelemetry.context.Context;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.TracingMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ReactiveMessagingTracingOutgoingDecorator
implements SubscriberDecorator {
    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> toBeSubscribed, List<String> channelName, boolean isConnector) {
        Multi multi = toBeSubscribed;
        if (isConnector) {
            multi = multi.map(m -> {
                Message message = m;
                if (m.getMetadata(TracingMetadata.class).isEmpty()) {
                    Context otelContext = QuarkusContextStorage.INSTANCE.current();
                    message = m.addMetadata((Object)TracingMetadata.withCurrent((Context)otelContext));
                }
                return message;
            });
        }
        return multi;
    }
}

