/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.StandardLocation;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.nbbuild.CustomJavac;

final class CustomJavacClassLoader
extends URLClassLoader {
    private static final String MAIN_COMPILER_CP = "nbjavac.class.path";
    private static final String MAIN_COMPILER_CLASS = "com.sun.tools.javac.Main";
    private final Map<String, Class<?>> priorityLoaded = new ConcurrentHashMap();

    private CustomJavacClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    static synchronized Class<?> findMainCompilerClass(Project prj) throws MalformedURLException, ClassNotFoundException, URISyntaxException {
        String cp = prj.getProperty(MAIN_COMPILER_CP);
        if (cp == null) {
            return null;
        }
        Class<?> c = System.getProperties().get(MAIN_COMPILER_CLASS);
        if (!(c instanceof Class)) {
            FileSet fs = new FileSet();
            File cpPath = new File(cp);
            if (cpPath.isAbsolute()) {
                fs.setDir(cpPath.getParentFile());
                fs.setIncludes(cpPath.getName());
            } else {
                String nball = prj.getProperty("nb_all");
                if (nball != null) {
                    fs.setDir(new File(nball));
                } else {
                    fs.setDir(prj.getBaseDir());
                }
                fs.setIncludes(cp);
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            DirectoryScanner scan = fs.getDirectoryScanner(prj);
            File base = scan.getBasedir();
            for (String relative : scan.getIncludedFiles()) {
                File file = new File(base, relative);
                URL url = FileUtils.getFileUtils().getFileURL(file);
                urls.add(url);
            }
            if (urls.isEmpty()) {
                throw new BuildException("Cannot find nb-javac JAR libraries in " + base + " and " + cp);
            }
            CustomJavacClassLoader loader = new CustomJavacClassLoader(urls.toArray(new URL[0]), CustomJavac.class.getClassLoader().getParent());
            Class<?> newCompilerClass = Class.forName(MAIN_COMPILER_CLASS, true, loader);
            CustomJavacClassLoader.assertIsolatedClassLoader(newCompilerClass, loader);
            System.getProperties().put(MAIN_COMPILER_CLASS, newCompilerClass);
            c = newCompilerClass;
        }
        return c;
    }

    static Javac13 createCompiler(Class<?> mainClass) {
        return new NbJavacCompiler(mainClass);
    }

    private static void assertIsolatedClassLoader(Class<?> c, URLClassLoader loader) throws ClassNotFoundException, BuildException {
        if (c.getClassLoader() != loader) {
            throw new BuildException("Class " + c + " loaded by " + c.getClassLoader() + " and not " + loader);
        }
        Class<?> stdLoc = c.getClassLoader().loadClass(StandardLocation.class.getName());
        if (stdLoc.getClassLoader() != loader) {
            throw new BuildException("Class " + stdLoc + " loaded by " + stdLoc.getClassLoader() + " and not " + loader);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (CustomJavacClassLoader.isNbJavacClass(name)) {
            Class<?> clazz = this.priorityLoaded.get(name);
            if (clazz == null) {
                clazz = this.findClass(name);
                this.priorityLoaded.put(name, clazz);
            }
            return clazz;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    private static boolean isNbJavacClass(String name) {
        return name.startsWith("javax.annotation.") || name.startsWith("javax.tools.") || name.startsWith("javax.lang.model.") || name.startsWith("com.sun.source.") || name.startsWith("com.sun.tools.");
    }

    private static final class NbJavacCompiler
    extends Javac13 {
        private final Class<?> mainClazz;

        NbJavacCompiler(Class<?> mainClazz) {
            this.mainClazz = mainClazz;
        }

        public boolean execute() throws BuildException {
            int i;
            this.attributes.log("Using modern compiler", 3);
            Commandline cmd = this.setupModernJavacCommand();
            String[] args = cmd.getArguments();
            boolean bootClasspath = false;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-Xbootclasspath/p:")) continue;
                bootClasspath = true;
            }
            for (i = 0; i < args.length; ++i) {
                if (bootClasspath || !"-target".equals(args[i]) && !"-source".equals(args[i])) continue;
                args[i] = "--release";
                if (!args[i + 1].startsWith("1.")) continue;
                args[i + 1] = "8";
            }
            Object[] args2 = new String[args.length + 1];
            args2[0] = "-Xlint:-classfile";
            System.arraycopy(args, 0, args2, 1, args.length);
            try {
                Method compile = this.mainClazz.getMethod("compile", String[].class);
                int result = (Integer)compile.invoke(null, new Object[]{args2});
                return result == 0;
            }
            catch (Exception ex) {
                this.attributes.log("Compiler arguments: " + Arrays.toString(args2), 0);
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error starting modern compiler", (Throwable)ex, this.location);
            }
        }
    }
}

