/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;

public class GroupByNode
implements GroupBy {
    private List<Column> _columnList;

    public GroupByNode() {
    }

    public GroupByNode(List columnList) {
        this._columnList = columnList;
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = " GROUP BY ";
        if (this._columnList.size() > 0) {
            res = res + ((ColumnNode)this._columnList.get(0)).genText(quoter);
            for (int i = 1; i < this._columnList.size(); ++i) {
                res = res + ", " + ((ColumnNode)this._columnList.get(i)).genText(quoter);
            }
        }
        return res;
    }

    public void setColumnList(List columnList) {
        this._columnList = columnList;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        if (this._columnList != null) {
            columns.addAll(this._columnList);
        }
    }

    public void addColumn(Column col) {
        this._columnList.add(col);
    }

    public void addColumn(String tableSpec, String columnName) {
        this._columnList.add(new ColumnNode(tableSpec, columnName));
    }

    public void removeColumn(String tableSpec, String columnName) {
        for (int i = this._columnList.size() - 1; i >= 0; --i) {
            ColumnNode c = (ColumnNode)this._columnList.get(i);
            if (!c.getTableSpec().equals(tableSpec) || !c.getColumnName().equals(columnName)) continue;
            this._columnList.remove(i);
        }
    }

    void removeTable(String tableSpec) {
        for (int i = this._columnList.size() - 1; i >= 0; --i) {
            ColumnNode c = (ColumnNode)this._columnList.get(i);
            if (!c.getTableSpec().equals(tableSpec)) continue;
            this._columnList.remove(i);
        }
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        for (int i = 0; i < this._columnList.size(); ++i) {
            ((ColumnNode)this._columnList.get(i)).renameTableSpec(oldTableSpec, corrName);
        }
    }
}

