/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.netbeans.spi.queries.VisibilityQueryChangeEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;

public class PhpSourcesFilter
implements ChangeListener,
ChangeableDataFilter {
    private static final long serialVersionUID = -743974567467955L;
    private final PhpProject project;
    private final FileObject rootFolder;
    private final PhpVisibilityQuery phpVisibilityQuery;
    private final FileObject nbProject;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public PhpSourcesFilter(PhpProject project) {
        this(project, null);
    }

    public PhpSourcesFilter(PhpProject project, FileObject rootFolder) {
        assert (project != null);
        this.project = project;
        this.rootFolder = rootFolder;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(project);
        this.nbProject = project.getProjectDirectory().getFileObject("nbproject");
        ProjectPropertiesSupport.addWeakIgnoredFilesListener(project, this);
    }

    public boolean acceptDataObject(DataObject object) {
        return this.acceptFileObject(object.getPrimaryFile());
    }

    public boolean acceptFileObject(FileObject file) {
        return !this.isNbProject(file) && !this.isTestDirectory(file) && !this.isSeleniumDirectory(file) && this.phpVisibilityQuery.isVisible(file);
    }

    private boolean isNbProject(FileObject file) {
        return file.equals(this.nbProject);
    }

    private boolean isTestDirectory(FileObject file) {
        for (FileObject root : ProjectPropertiesSupport.getTestDirectories(this.project, false)) {
            if (!this.isDirectory(file, root)) continue;
            return true;
        }
        return false;
    }

    private boolean isSeleniumDirectory(FileObject file) {
        return this.isDirectory(file, ProjectPropertiesSupport.getSeleniumDirectory(this.project, false));
    }

    private boolean isDirectory(FileObject file, FileObject directory) {
        if (this.rootFolder == null || directory == null) {
            return false;
        }
        if (!directory.equals(this.rootFolder)) {
            return directory.equals(file);
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event instanceof VisibilityQueryChangeEvent) {
            FileObject[] fileObjects;
            for (FileObject fileObject : fileObjects = ((VisibilityQueryChangeEvent)event).getFileObjects()) {
                if (!this.project.equals(ProjectConvertors.getNonConvertorOwner((FileObject)fileObject))) continue;
                this.changeSupport.fireChange();
                return;
            }
            return;
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }
}

