/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.widgets;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;

public class WidgetOperator
extends Operator {
    protected Widget widget;

    public WidgetOperator(Widget widget) {
        this.widget = widget;
    }

    public WidgetOperator(WidgetOperator parentWidgetOper, WidgetChooser widgetChooser) {
        this(parentWidgetOper, widgetChooser, 0);
    }

    public WidgetOperator(WidgetOperator parentWidgetOper, int index) {
        this(parentWidgetOper, null, index);
    }

    public WidgetOperator(WidgetOperator parentWidgetOper, WidgetChooser widgetChooser, int index) {
        this(WidgetOperator.waitWidget(parentWidgetOper.getWidget(), widgetChooser, index));
        this.copyEnvironment(parentWidgetOper);
    }

    public WidgetOperator(TopComponentOperator tco, WidgetChooser widgetChooser) {
        this(tco, widgetChooser, 0);
    }

    public WidgetOperator(TopComponentOperator tco, int index) {
        this(tco, null, index);
    }

    public WidgetOperator(TopComponentOperator tco, WidgetChooser widgetChooser, int index) {
        this(WidgetOperator.waitWidget((Widget)WidgetOperator.waitScene(tco), widgetChooser, index));
        this.copyEnvironment((Operator)tco);
    }

    private static Scene waitScene(TopComponentOperator tco) {
        Component sceneComp = tco.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp.getClass().getName().endsWith("SceneComponent");
            }

            public String getDescription() {
                return "SceneComponent";
            }
        });
        try {
            Field[] fields = sceneComp.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Class<?> type = field.getType();
                if (!Scene.class.isAssignableFrom(type)) continue;
                field.setAccessible(true);
                return (Scene)field.get(sceneComp);
            }
        }
        catch (Exception ex) {
            throw new JemmyException("Exception while getting Scene field from " + sceneComp, (Throwable)ex);
        }
        throw new JemmyException("Scene field not found in " + sceneComp);
    }

    private static Widget waitWidget(final Widget parentWidget, final WidgetChooser widgetChooser, final int index) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object obj) {
                    return WidgetOperator.findWidget(parentWidget, widgetChooser, index);
                }

                public String getDescription() {
                    return (index > 0 ? index + "-th " : "") + (widgetChooser == null ? "Widget " : widgetChooser.getDescription()) + " displayed";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("WidgetOperator.WaitWidgetTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (Widget)waiter.waitAction(null);
        }
        catch (InterruptedException ex) {
            throw new JemmyException("Interrupted.", (Throwable)ex);
        }
    }

    public static Widget findWidget(final Widget parentWidget, final WidgetChooser widgetChooser, final int index) {
        return (Widget)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findWidget"){

            public Object launch() {
                return WidgetOperator.findWidget(parentWidget, widgetChooser, index, new Counter());
            }
        });
    }

    private static Widget findWidget(Widget parentWidget, WidgetChooser widgetChooser, int index, Counter counter) {
        List children = parentWidget.getChildren();
        for (Widget child : children) {
            if (widgetChooser != null && !widgetChooser.checkWidget(child)) continue;
            if (index == counter.getValue()) {
                return child;
            }
            counter.increase();
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Widget found = WidgetOperator.findWidget((Widget)it.next(), widgetChooser, index, counter);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Scene getScene() {
        return (Scene)this.runMapping(new Operator.MapAction("widget.getScene()"){

            public Object map() {
                return WidgetOperator.this.widget.getScene();
            }
        });
    }

    public WidgetOperator getSceneOperator() {
        return new WidgetOperator((Widget)this.getScene());
    }

    public List<WidgetOperator> getChildren() {
        List children = (List)this.runMapping(new Operator.MapAction("widget.getChildren"){

            public Object map() {
                return WidgetOperator.this.widget.getChildren();
            }
        });
        ArrayList<WidgetOperator> operators = new ArrayList<WidgetOperator>();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            operators.add(new WidgetOperator((Widget)it.next()));
        }
        return operators;
    }

    public WidgetOperator getParent() {
        Widget parent = (Widget)this.runMapping(new Operator.MapAction("widget.getParentWidget"){

            public Object map() {
                return WidgetOperator.this.widget.getParentWidget();
            }
        });
        if (parent == null) {
            return null;
        }
        return new WidgetOperator(parent);
    }

    public Component getSource() {
        return this.getViewOperator().getSource();
    }

    public JComponentOperator getViewOperator() {
        return new JComponentOperator((JComponent)this.runMapping(new Operator.MapAction("widget.getScene().getView()"){

            public Object map() {
                return WidgetOperator.this.widget.getScene().getView();
            }
        }));
    }

    public Widget getWidget() {
        return this.widget;
    }

    public Point getCenter() {
        return (Point)this.runMapping(new Operator.MapAction("getCenter"){

            public Object map() {
                Rectangle inSceneLocation = WidgetOperator.this.widget.convertLocalToScene(WidgetOperator.this.widget.getBounds());
                Rectangle inViewLocation = WidgetOperator.this.widget.getScene().convertSceneToView(inSceneLocation);
                return new Point(inViewLocation.x + inViewLocation.width / 2, inViewLocation.y + inViewLocation.height / 2);
            }
        });
    }

    public Point getLocation() {
        return (Point)this.runMapping(new Operator.MapAction("widget.getLocation()"){

            public Object map() {
                return WidgetOperator.this.widget.getLocation();
            }
        });
    }

    public Rectangle getBounds() {
        return (Rectangle)this.runMapping(new Operator.MapAction("widget.getBounds()"){

            public Object map() {
                return WidgetOperator.this.widget.getBounds();
            }
        });
    }

    public String toString() {
        return this.widget.getClass().getName() + "[" + this.getLocation() + "," + this.getBounds() + "]";
    }

    public void printDump() {
        this.printDump("");
    }

    private void printDump(String indent) {
        this.getOutput().printLine(indent + (Object)((Object)this));
        indent = indent + "    ";
        List children = this.widget.getChildren();
        for (Widget child : children) {
            WidgetOperator childOper = WidgetOperator.createOperator(child);
            childOper.copyEnvironment(this);
            childOper.printDump(indent);
        }
    }

    public static WidgetOperator createOperator(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        while (Widget.class.isAssignableFrom(widgetClass)) {
            String fullClassName = widgetClass.getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            try {
                return (WidgetOperator)((Object)new ClassReference("org.netbeans.jellytools.widgets." + className + "Operator").newInstance(new Object[]{widget}, new Class[]{widgetClass}));
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    Class<?> clazz = Class.forName("org.netbeans.jellytools.widgets." + className + "Operator", true, Thread.currentThread().getContextClassLoader());
                    return (WidgetOperator)((Object)clazz.getConstructor(widgetClass).newInstance(widget));
                }
                catch (Exception e) {
                    widgetClass = widgetClass.getSuperclass();
                }
            }
            catch (Exception e) {
                throw new JemmyException("Exception while creating operator.", (Throwable)e);
            }
        }
        return new WidgetOperator(widget);
    }

    public void performPopupAction(String popupPath) {
        Point center = this.getCenter();
        this.getViewOperator().clickForPopup(center.x, center.y);
        JPopupMenuOperator popupOper = new JPopupMenuOperator();
        popupOper.setComparator(this.getComparator());
        popupOper.pushMenu(popupPath, "|", this.getComparator());
    }

    public void performPopupActionNoBlock(String popupPath) {
        Point center = this.getCenter();
        this.getViewOperator().clickForPopup(center.x, center.y);
        JPopupMenuOperator popupOper = new JPopupMenuOperator();
        popupOper.setComparator(this.getComparator());
        popupOper.pushMenuNoBlock(popupPath, "|", this.getComparator());
    }

    public void clickMouse(int clickCount) {
        Point center = this.getCenter();
        this.getViewOperator().clickMouse(center.x, center.y, clickCount);
    }

    public void dragNDrop(int relativeX, int relativeY) {
        Point center = this.getCenter();
        this.dragNDrop(center.x, center.y, center.x + relativeX, center.y + relativeY);
    }

    public void dragNDrop(WidgetOperator widgetOperator) {
        Point centerStart = this.getCenter();
        Point centerEnd = widgetOperator.getCenter();
        this.dragNDrop(centerStart.x, centerStart.y, centerEnd.x, centerEnd.y);
    }

    public void dragNDrop(int x1, int y1, int x2, int y2) {
        this.getViewOperator().dragNDrop(x1, y1, x2, y2);
    }

    static {
        Timeouts.initDefault((String)"WidgetOperator.WaitWidgetTimeout", (long)30000L);
    }

    public static interface WidgetChooser {
        public boolean checkWidget(Widget var1);

        public String getDescription();
    }

    private static final class Counter {
        int counter = 0;

        public void increase() {
            ++this.counter;
        }

        public int getValue() {
            return this.counter;
        }
    }
}

