/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormModel {
    private String formName;
    private boolean readOnly = false;
    static final FormVersion LATEST_VERSION = FormVersion.NB74;
    private String leadingComment;
    private FormVersion currentVersionLevel;
    private FormVersion lastConfirmedVersionLevel;
    private FormVersion maxVersionLevel;
    private Class<?> formBaseClass;
    private RADComponent topRADComponent;
    private List<RADComponent> otherComponents = new ArrayList<RADComponent>(10);
    private ComponentContainer modelContainer;
    private LayoutModel layoutModel;
    private Map<String, RADComponent> idToComponents = new HashMap<String, RADComponent>();
    private boolean formLoaded = false;
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private boolean undoCompoundEdit = false;
    private FormEvents formEvents;
    private ArrayList<FormModelListener> listeners;
    private List<FormModelEvent> eventList;
    private boolean firing;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private FormSettings settings = new FormSettings(this);
    private boolean freeDesignDefaultLayout = false;
    private static boolean formModifiedLogged = false;
    private static boolean bindingModifiedLogged = false;
    private static int traceCount = 0;
    private static final boolean TRACE = false;

    FormModel() {
    }

    public void setFormBaseClass(Class<?> formClass) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent topComp = FormUtils.isVisualizableClass(formClass) ? (FormUtils.isContainer(formClass) ? new RADVisualFormContainer() : new RADVisualComponent(){

            @Override
            public String getName() {
                return FormUtils.getBundleString("CTL_FormTopContainerName");
            }

            @Override
            public void setName(String value) {
            }
        }) : (Object.class != formClass ? new RADFormContainer() : null);
        if (topComp != null) {
            this.topRADComponent = topComp;
            topComp.initialize(this);
            topComp.initInstance(formClass);
            topComp.setInModel(true);
        }
        this.formBaseClass = formClass;
        this.layoutModel = new LayoutModel();
        this.layoutModel.setChangeRecording(false);
    }

    public Class<?> getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String name) {
        this.formName = name;
    }

    public String getLeadingComment() {
        return this.leadingComment;
    }

    public void setLeadingComment(String leadingComment) {
        this.leadingComment = leadingComment;
    }

    public void raiseVersionLevel(FormVersion minVersion, FormVersion upgradeTo) {
        if (minVersion.ordinal() > this.currentVersionLevel.ordinal() && (this.undoRedoRecording || !this.formLoaded)) {
            assert (upgradeTo.ordinal() >= minVersion.ordinal());
            this.setCurrentVersionLevel(upgradeTo);
        }
    }

    void setCurrentVersionLevel(FormVersion version) {
        if (this.lastConfirmedVersionLevel == null) {
            this.lastConfirmedVersionLevel = this.currentVersionLevel;
        }
        this.currentVersionLevel = version;
    }

    FormVersion getCurrentVersionLevel() {
        return this.currentVersionLevel;
    }

    void revertVersionLevel() {
        this.currentVersionLevel = this.lastConfirmedVersionLevel;
    }

    void confirmVersionLevel() {
        this.lastConfirmedVersionLevel = this.currentVersionLevel;
    }

    void setMaxVersionLevel(FormVersion version) {
        this.maxVersionLevel = version;
    }

    FormVersion getMaxVersionLevel() {
        return this.maxVersionLevel;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isFormLoaded() {
        return this.formLoaded;
    }

    public final boolean wasCorrected() {
        return this.formLoaded && this.layoutModel != null && this.layoutModel.wasCorrected();
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public Collection<RADComponent> getOtherComponents() {
        return Collections.unmodifiableCollection(this.otherComponents);
    }

    public final LayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    public final RADComponent getMetaComponent(String id) {
        return this.idToComponents.get(id);
    }

    public RADComponent findRADComponent(String name) {
        for (RADComponent comp : this.idToComponents.values()) {
            if (!name.equals(comp.getName())) continue;
            return comp;
        }
        return null;
    }

    public List<RADComponent> getComponentList() {
        return new ArrayList<RADComponent>(this.idToComponents.values());
    }

    public List<RADComponent> getOrderedComponentList() {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>(this.idToComponents.size());
        FormModel.collectMetaComponents(this.getModelContainer(), list);
        return list;
    }

    public Collection<RADComponent> getAllComponents() {
        return Collections.unmodifiableCollection(this.idToComponents.values());
    }

    public List<RADComponent> getNonVisualComponents() {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>(this.otherComponents.size());
        for (RADComponent metacomp : this.otherComponents) {
            if (metacomp instanceof RADVisualComponent) continue;
            list.add(metacomp);
        }
        return list;
    }

    public List<RADComponent> getVisualComponents() {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>(this.idToComponents.size());
        for (Map.Entry<String, RADComponent> e : this.idToComponents.entrySet()) {
            RADComponent metacomp = e.getValue();
            if (!(metacomp instanceof RADVisualComponent)) continue;
            list.add(metacomp);
        }
        return list;
    }

    public FormEvents getFormEvents() {
        if (this.formEvents == null) {
            this.formEvents = new FormEvents(this);
        }
        return this.formEvents;
    }

    private static void collectMetaComponents(ComponentContainer cont, List<RADComponent> list) {
        RADComponent[] comps = cont.getSubBeans();
        for (int i = 0; i < comps.length; ++i) {
            RADComponent comp = comps[i];
            list.add(comp);
            if (!(comp instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)comp), list);
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer cont, List<RADComponent> list) {
        RADVisualComponent[] comps = cont.getSubComponents();
        for (int i = 0; i < comps.length; ++i) {
            RADVisualComponent comp = comps[i];
            list.add(comp);
            if (!(comp instanceof RADVisualContainer)) continue;
            FormModel.collectVisualMetaComponents((RADVisualContainer)comp, list);
        }
    }

    public FormSettings getSettings() {
        return this.settings;
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent metacomp, ComponentContainer parentContainer, boolean newlyAdded) {
        if (newlyAdded || !metacomp.isInModel()) {
            FormModel.setInModelRecursively(metacomp, true);
            newlyAdded = true;
        }
        if (parentContainer != null) {
            parentContainer.add(metacomp);
        } else {
            metacomp.setParentComponent(null);
            this.otherComponents.add(metacomp);
        }
        if (!newlyAdded && metacomp instanceof RADVisualComponent) {
            ((RADVisualComponent)metacomp).resetConstraintsProperties();
        }
        this.fireComponentAdded(metacomp, newlyAdded);
    }

    public void addVisualComponent(RADVisualComponent metacomp, RADVisualContainer parentContainer, Object constraints, boolean newlyAdded) {
        LayoutSupportManager layoutSupport = parentContainer.getLayoutSupport();
        if (layoutSupport != null) {
            int index;
            RADVisualComponent[] compArray = new RADVisualComponent[]{metacomp};
            LayoutConstraints c = constraints instanceof LayoutConstraints ? (LayoutConstraints)constraints : null;
            LayoutConstraints[] constrArray = new LayoutConstraints[]{c};
            int n = index = constraints instanceof Integer ? (Integer)constraints : -1;
            if (newlyAdded || !metacomp.isInModel()) {
                FormModel.setInModelRecursively(metacomp, true);
                newlyAdded = true;
            }
            try {
                layoutSupport.acceptNewComponents(compArray, constrArray, index);
            }
            catch (RuntimeException ex) {
                if (newlyAdded) {
                    FormModel.setInModelRecursively(metacomp, false);
                }
                throw ex;
            }
            parentContainer.add(metacomp, index);
            if (parentContainer.isLayoutSubcomponent(metacomp)) {
                layoutSupport.addComponents(compArray, constrArray, index);
            }
            this.fireComponentAdded(metacomp, newlyAdded);
        } else {
            this.addComponent(metacomp, parentContainer, newlyAdded);
        }
    }

    void setContainerLayoutImpl(RADVisualContainer metacont, LayoutSupportDelegate layoutDelegate) throws Exception {
        LayoutSupportDelegate currentDel;
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        LayoutSupportDelegate layoutSupportDelegate = currentDel = currentLS != null ? currentLS.getLayoutDelegate() : null;
        if (currentLS == null) {
            metacont.setOldLayoutSupport(true);
        }
        try {
            metacont.setLayoutSupportDelegate(layoutDelegate);
        }
        catch (Exception ex) {
            if (currentLS == null) {
                metacont.setOldLayoutSupport(false);
            }
            throw ex;
        }
        this.fireContainerLayoutExchanged(metacont, currentDel, layoutDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerLayout(RADVisualContainer metacont, LayoutSupportDelegate layoutDelegate) throws Exception {
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        this.setContainerLayoutImpl(metacont, layoutDelegate);
        if (currentLS == null) {
            Object layoutStartMark = this.layoutModel.getChangeMark();
            UndoableEdit ue = this.layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                this.layoutModel.changeContainerToComponent(metacont.getId());
                autoUndo = false;
            }
            finally {
                if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                    this.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    this.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    void setNaturalContainerLayoutImpl(RADVisualContainer metacont) {
        LayoutSupportDelegate currentDel = metacont.getLayoutSupport().getLayoutDelegate();
        metacont.setOldLayoutSupport(false);
        this.fireContainerLayoutExchanged(metacont, currentDel, null);
        for (RADVisualComponent metacomp : metacont.getSubComponents()) {
            metacomp.resetConstraintsProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNaturalContainerLayout(RADVisualContainer metacont) {
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        if (currentLS == null) {
            return;
        }
        this.setNaturalContainerLayoutImpl(metacont);
        Object layoutStartMark = this.layoutModel.getChangeMark();
        UndoableEdit ue = this.layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            if (!this.layoutModel.changeComponentToContainer(metacont.getId())) {
                this.layoutModel.addRootComponent(new LayoutComponent(metacont.getId(), true));
            }
            autoUndo = false;
        }
        finally {
            if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(RADComponent metacomp, boolean fromModel) {
        Object layoutStartMark = null;
        UndoableEdit ue = null;
        boolean autoUndo = true;
        try {
            if (fromModel && this.layoutModel != null) {
                layoutStartMark = this.layoutModel.getChangeMark();
                ue = this.layoutModel.getUndoableEdit();
                this.layoutModel.removeComponent(metacomp.getId(), true);
                this.removeLayoutComponentsRecursively(metacomp);
            }
            autoUndo = false;
        }
        finally {
            this.removeComponentImpl(metacomp, fromModel);
            if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    void removeComponentImpl(RADComponent metacomp, boolean fromModel) {
        RADComponent parent;
        if (fromModel && this.formEvents != null) {
            this.removeEventHandlersRecursively(metacomp);
        }
        ComponentContainer parentContainer = (parent = metacomp.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)parent) : this.getModelContainer();
        int index = parentContainer.getIndexOf(metacomp);
        parentContainer.remove(metacomp);
        if (fromModel) {
            FormModel.setInModelRecursively(metacomp, false);
        }
        FormModelEvent ev = this.fireComponentRemoved(metacomp, parentContainer, index, fromModel);
    }

    private void removeLayoutComponentsRecursively(RADComponent metacomp) {
        LayoutComponent layoutComp;
        if (metacomp instanceof ComponentContainer) {
            RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            for (int i = 0; i < comps.length; ++i) {
                this.removeLayoutComponentsRecursively(comps[i]);
            }
        }
        LayoutComponent layoutComponent = layoutComp = this.layoutModel == null ? null : this.layoutModel.getLayoutComponent(metacomp.getId());
        if (layoutComp != null && layoutComp.getParent() == null) {
            this.layoutModel.removeComponent(layoutComp.getId(), true);
        }
    }

    void updateMapping(RADComponent metacomp, boolean register) {
        if (register) {
            this.idToComponents.put(metacomp.getId(), metacomp);
        } else {
            this.idToComponents.remove(metacomp.getId());
        }
    }

    private void removeEventHandlersRecursively(RADComponent comp) {
        int i;
        if (comp instanceof ComponentContainer) {
            RADComponent[] subcomps = ((ComponentContainer)((Object)comp)).getSubBeans();
            for (i = 0; i < subcomps.length; ++i) {
                this.removeEventHandlersRecursively(subcomps[i]);
            }
        }
        Event[] events = comp.getKnownEvents();
        for (i = 0; i < events.length; ++i) {
            if (!events[i].hasEventHandlers()) continue;
            this.getFormEvents().detachEvent(events[i]);
        }
    }

    static void setInModelRecursively(RADComponent metacomp, boolean inModel) {
        if (metacomp instanceof ComponentContainer) {
            RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            for (int i = 0; i < comps.length; ++i) {
                FormModel.setInModelRecursively(comps[i], inModel);
            }
        }
        metacomp.setInModel(inModel);
    }

    public void setUndoRedoRecording(boolean record) {
        FormModel.t("turning undo/redo recording " + (record ? "on" : "off"));
        this.undoRedoRecording = record;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    private void startCompoundEdit() {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
        }
    }

    public CompoundEdit endCompoundEdit(boolean commit) {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit: " + commit);
            this.compoundEdit.end();
            if (commit && this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                if (!formModifiedLogged) {
                    Logger logger = Logger.getLogger("org.netbeans.ui.metrics.form");
                    LogRecord rec = new LogRecord(Level.INFO, "USG_FORM_MODIFIED");
                    rec.setLoggerName(logger.getName());
                    logger.log(rec);
                    formModifiedLogged = true;
                }
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            }
            CompoundEdit edit = this.compoundEdit;
            this.compoundEdit = null;
            return edit;
        }
        return null;
    }

    public void forceUndoOfCompoundEdit() {
        if (this.compoundEdit != null) {
            this.undoCompoundEdit = true;
        }
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null;
    }

    public void addUndoableEdit(UndoableEdit edit) {
        FormModel.t("adding undoable edit");
        if (!this.isCompoundEditInProgress()) {
            this.startCompoundEdit();
        }
        this.compoundEdit.addEdit(edit);
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeFormModelListener(FormModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.formLoaded = true;
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
            this.setUndoRedoRecording(true);
            if (this.layoutModel != null) {
                this.layoutModel.setChangeRecording(true);
            }
        }
        this.sendEventLater(new FormModelEvent(this, 1));
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.sendEventImmediately(new FormModelEvent(this, 2));
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.sendEventImmediately(new FormModelEvent(this, 3));
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer metacont, LayoutSupportDelegate oldLayout, LayoutSupportDelegate newLayout) {
        FormModel.t("firing container layout exchange, container: " + (metacont != null ? metacont.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 4);
        ev.setLayout(metacont, oldLayout, newLayout);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && oldLayout != newLayout) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer metacont, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing container layout change, container: " + (metacont != null ? metacont.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 5);
        ev.setComponentAndContainer(metacont, metacont);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && (propName == null || oldValue != newValue)) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component layout change: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 6);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentAdded(RADComponent metacomp, boolean addedNew) {
        FormModel.t("firing component added: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 7);
        ev.setAddData(metacomp, null, addedNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentRemoved(RADComponent metacomp, ComponentContainer metacont, int index, boolean removedFromModel) {
        FormModel.t("firing component removed: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 8);
        ev.setRemoveData(metacomp, metacont, index, removedFromModel);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer metacont, int[] perm) {
        FormModel.t("firing components reorder in container: " + (metacont instanceof RADComponent ? ((RADComponent)((Object)metacont)).getName() : "<top>"));
        FormModelEvent ev = new FormModelEvent(this, 9);
        ev.setComponentAndContainer(null, metacont);
        ev.setReordering(perm);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component property change, component: " + (metacomp != null ? metacomp.getName() : "<null component>") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 10);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireBindingChanged(RADComponent metacomp, String path, String subProperty, Object oldValue, Object newValue) {
        FormModelEvent ev = new FormModelEvent(this, 16);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(path, oldValue, newValue);
        ev.setSubProperty(subProperty);
        this.sendEvent(ev);
        if (this.undoRedoRecording && oldValue != newValue) {
            if (!bindingModifiedLogged) {
                Logger logger = Logger.getLogger("org.netbeans.ui.metrics.form");
                LogRecord rec = new LogRecord(Level.INFO, "USG_FORM_BINDING_MODIFIED");
                rec.setLoggerName(logger.getName());
                logger.log(rec);
                bindingModifiedLogged = true;
            }
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing synthetic property change, component: " + (metacomp != null ? metacomp.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 11);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, String handler, String bodyText, String annotationText, boolean createdNew) {
        FormModel.t("event handler added: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 12);
        ev.setEvent(event, handler, bodyText, annotationText, createdNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, String handler, boolean handlerDeleted) {
        FormModel.t("firing event handler removed: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 13);
        ev.setEvent(event, handler, null, null, handlerDeleted);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRenamed(String oldHandlerName, String newHandlerName) {
        FormModel.t("event handler renamed: " + oldHandlerName + " to " + newHandlerName);
        FormModelEvent ev = new FormModelEvent(this, 14);
        ev.setEvent(oldHandlerName, newHandlerName);
        this.sendEvent(ev);
        if (this.undoRedoRecording && oldHandlerName != null && newHandlerName != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireFormChanged(boolean immediately) {
        FormModel.t("firing form change");
        FormModelEvent ev = new FormModelEvent(this, 15);
        if (immediately) {
            this.sendEventImmediately(ev);
        } else {
            this.sendEvent(ev);
        }
        return ev;
    }

    private void sendEvent(FormModelEvent ev) {
        if (this.formLoaded) {
            if (this.eventList != null || ev.isModifying()) {
                this.sendEventLater(ev);
            } else {
                this.sendEventImmediately(ev);
            }
        } else {
            this.fireEvents(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventLater(FormModelEvent ev) {
        if (!EventQueue.isDispatchThread()) {
            this.sendEventImmediately(ev);
            return;
        }
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.eventList == null) {
                this.eventList = new ArrayList<FormModelEvent>();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormModel.this.firePendingEvents();
                    }
                });
            }
            this.eventList.add(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventImmediately(FormModelEvent ev) {
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.eventList == null) {
                this.eventList = new ArrayList<FormModelEvent>();
            }
            this.eventList.add(ev);
        }
        this.firePendingEvents();
    }

    private void firePendingEvents() {
        List<FormModelEvent> list = this.pickUpEvents();
        if (list != null && !list.isEmpty()) {
            FormModelEvent[] events = new FormModelEvent[list.size()];
            list.toArray(events);
            this.fireEventBatch(events);
        }
    }

    private synchronized List<FormModelEvent> pickUpEvents() {
        List<FormModelEvent> list = this.eventList;
        this.eventList = null;
        return list;
    }

    boolean hasPendingEvents() {
        return this.eventList != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventBatch(FormModelEvent ... events) {
        block6: {
            block5: {
                boolean revert;
                if (this.firing) break block5;
                boolean firingFailed = false;
                try {
                    this.firing = true;
                    if (!this.undoCompoundEdit) {
                        firingFailed = true;
                        this.fireEvents(events);
                        firingFailed = false;
                    }
                    this.firing = false;
                    revert = this.undoCompoundEdit || firingFailed;
                }
                catch (Throwable throwable) {
                    this.firing = false;
                    boolean revert2 = this.undoCompoundEdit || firingFailed;
                    this.undoCompoundEdit = false;
                    CompoundEdit edit = this.endCompoundEdit(!revert2);
                    if (edit != null && revert2) {
                        edit.undo();
                    }
                    throw throwable;
                }
                this.undoCompoundEdit = false;
                CompoundEdit edit = this.endCompoundEdit(!revert);
                if (edit != null && revert) {
                    edit.undo();
                }
                break block6;
            }
            this.fireEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvents(FormModelEvent ... events) {
        ArrayList targets;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            targets = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            FormModelListener l = (FormModelListener)targets.get(i);
            l.formChanged(events);
        }
    }

    public CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public boolean isFreeDesignDefaultLayout() {
        return this.freeDesignDefaultLayout;
    }

    void setFreeDesignDefaultLayout(boolean freeDesignDefaultLayout) {
        this.freeDesignDefaultLayout = freeDesignDefaultLayout;
    }

    static void t(String str) {
    }

    public static enum FormVersion {
        BASIC,
        NB50,
        NB60_PRE,
        NB60,
        NB61,
        NB65,
        NB71,
        NB74;

    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        @Override
        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] comps = new RADComponent[n];
            FormModel.this.otherComponents.toArray(comps);
            if (FormModel.this.topRADComponent != null) {
                comps[n - 1] = FormModel.this.topRADComponent;
            }
            return comps;
        }

        @Override
        public void initSubComponents(RADComponent[] initComponents) {
            FormModel.this.otherComponents.clear();
            for (int i = 0; i < initComponents.length; ++i) {
                if (initComponents[i] == FormModel.this.topRADComponent) continue;
                FormModel.this.otherComponents.add(initComponents[i]);
            }
        }

        @Override
        public void reorderSubComponents(int[] perm) {
            RADComponent[] components = new RADComponent[FormModel.this.otherComponents.size()];
            for (int i = 0; i < perm.length; ++i) {
                components[perm[i]] = (RADComponent)FormModel.this.otherComponents.get(i);
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(components));
        }

        @Override
        public void add(RADComponent comp) {
            comp.setParentComponent(null);
            FormModel.this.otherComponents.add(comp);
        }

        @Override
        public void remove(RADComponent comp) {
            if (FormModel.this.otherComponents.remove(comp)) {
                comp.setParentComponent(null);
            }
        }

        @Override
        public int getIndexOf(RADComponent comp) {
            int index = FormModel.this.otherComponents.indexOf(comp);
            if (index < 0 && comp == FormModel.this.topRADComponent) {
                index = FormModel.this.otherComponents.size();
            }
            return index;
        }
    }

    public class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction<Object> runUndo = new Mutex.ExceptionAction<Object>(){

            public Object run() throws Exception {
                UndoRedoManager.this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction<Object> runRedo = new Mutex.ExceptionAction<Object>(){

            public Object run() throws Exception {
                UndoRedoManager.this.superRedo();
                return null;
            }
        };
        private boolean undoInProgress;
        private boolean redoInProgress;

        public boolean isUndoInProgress() {
            return this.undoInProgress;
        }

        public boolean isRedoInProgress() {
            return this.redoInProgress;
        }

        public void superUndo() throws CannotUndoException {
            this.undoInProgress = true;
            try {
                super.undo();
            }
            finally {
                this.undoInProgress = false;
            }
        }

        public void superRedo() throws CannotRedoException {
            this.redoInProgress = true;
            try {
                super.redo();
            }
            finally {
                this.redoInProgress = false;
            }
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotUndoException) {
                        throw (CannotUndoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotRedoException) {
                        throw (CannotRedoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }
    }
}

