/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDrgAttachmentRequest
extends BmcRequest<Void> {
    private String drgAttachmentId;
    private String ifMatch;

    public String getDrgAttachmentId() {
        return this.drgAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().drgAttachmentId(this.drgAttachmentId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgAttachmentId=").append(String.valueOf(this.drgAttachmentId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDrgAttachmentRequest)) {
            return false;
        }
        DeleteDrgAttachmentRequest other = (DeleteDrgAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgAttachmentId, other.drgAttachmentId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgAttachmentId == null ? 43 : this.drgAttachmentId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDrgAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgAttachmentId = null;
        private String ifMatch = null;

        public Builder drgAttachmentId(String drgAttachmentId) {
            this.drgAttachmentId = drgAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDrgAttachmentRequest o) {
            this.drgAttachmentId(o.getDrgAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDrgAttachmentRequest build() {
            DeleteDrgAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDrgAttachmentRequest buildWithoutInvocationCallback() {
            DeleteDrgAttachmentRequest request = new DeleteDrgAttachmentRequest();
            request.drgAttachmentId = this.drgAttachmentId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

