/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCrossConnectGroupRequest
extends BmcRequest<Void> {
    private String crossConnectGroupId;

    public String getCrossConnectGroupId() {
        return this.crossConnectGroupId;
    }

    public Builder toBuilder() {
        return new Builder().crossConnectGroupId(this.crossConnectGroupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",crossConnectGroupId=").append(String.valueOf(this.crossConnectGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCrossConnectGroupRequest)) {
            return false;
        }
        GetCrossConnectGroupRequest other = (GetCrossConnectGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.crossConnectGroupId, other.crossConnectGroupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.crossConnectGroupId == null ? 43 : this.crossConnectGroupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCrossConnectGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String crossConnectGroupId = null;

        public Builder crossConnectGroupId(String crossConnectGroupId) {
            this.crossConnectGroupId = crossConnectGroupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCrossConnectGroupRequest o) {
            this.crossConnectGroupId(o.getCrossConnectGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCrossConnectGroupRequest build() {
            GetCrossConnectGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCrossConnectGroupRequest buildWithoutInvocationCallback() {
            GetCrossConnectGroupRequest request = new GetCrossConnectGroupRequest();
            request.crossConnectGroupId = this.crossConnectGroupId;
            return request;
        }
    }
}

