/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeGroupRequest
extends BmcRequest<Void> {
    private String volumeGroupId;

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public Builder toBuilder() {
        return new Builder().volumeGroupId(this.volumeGroupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeGroupId=").append(String.valueOf(this.volumeGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeGroupRequest)) {
            return false;
        }
        GetVolumeGroupRequest other = (GetVolumeGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeGroupId, other.volumeGroupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeGroupId == null ? 43 : this.volumeGroupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeGroupId = null;

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeGroupRequest o) {
            this.volumeGroupId(o.getVolumeGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeGroupRequest build() {
            GetVolumeGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeGroupRequest buildWithoutInvocationCallback() {
            GetVolumeGroupRequest request = new GetVolumeGroupRequest();
            request.volumeGroupId = this.volumeGroupId;
            return request;
        }
    }
}

