/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.api.SourceLauncher;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SharedRootData {
    private static final Logger LOG = Logger.getLogger(SharedRootData.class.getName());
    private static final Map<FileObject, SharedRootData> root2Data = new HashMap<FileObject, SharedRootData>();
    private final FileObject root;
    private final Map<String, FileProperties> properties = new TreeMap<String, FileProperties>();
    private final FileChangeListener listener = new FileChangeAdapter(){

        public void fileAttributeChanged(FileAttributeEvent fe) {
            HashMap<String, FileProperties> newProperties = new HashMap<String, FileProperties>();
            SharedRootData.this.addPropertiesFor(fe.getFile(), newProperties);
            SharedRootData.this.setNewProperties(newProperties);
        }

        public void fileDeleted(FileEvent fe) {
            HashMap<String, FileProperties> newProperties = new HashMap<String, FileProperties>();
            newProperties.put(FileUtil.getRelativePath((FileObject)SharedRootData.this.root, (FileObject)fe.getFile()), null);
            SharedRootData.this.setNewProperties(newProperties);
        }
    };

    public static synchronized void ensureRootRegistered(FileObject root) {
        if (root2Data.get(root) != null) {
            return;
        }
        SharedRootData data = root2Data.computeIfAbsent(root, r -> new SharedRootData((FileObject)r));
        data.init();
    }

    @CheckForNull
    public static synchronized SharedRootData getDataForRoot(FileObject root) {
        return root2Data.get(root);
    }

    private SharedRootData(FileObject root) {
        this.root = root;
    }

    private void init() {
        this.root.addRecursiveListener(this.listener);
        Enumeration todo = this.root.getChildren(true);
        HashMap<String, FileProperties> newProperties = new HashMap<String, FileProperties>();
        while (todo.hasMoreElements()) {
            FileObject current = (FileObject)todo.nextElement();
            this.addPropertiesFor(current, newProperties);
        }
        this.setNewProperties(newProperties);
    }

    private void addPropertiesFor(FileObject file, Map<String, FileProperties> newProperties) {
        if (file.isData() && "text/x-java".equals(file.getMIMEType())) {
            newProperties.put(FileUtil.getRelativePath((FileObject)this.root, (FileObject)file), new FileProperties((String)file.getAttribute("single_file_vm_options"), SingleSourceFileUtil.isTrue(file.getAttribute("register_root"))));
        }
    }

    private synchronized void setNewProperties(Map<String, FileProperties> newProperties) {
        if (newProperties.isEmpty()) {
            return;
        }
        for (String key : newProperties.keySet()) {
            FileProperties fileProperties = newProperties.get(key);
            if (fileProperties == null) {
                this.properties.remove(key);
                continue;
            }
            this.properties.put(key, fileProperties);
        }
        List vmOptions = this.properties.values().stream().map(p -> p.vmOptions).filter(p -> p != null).collect(Collectors.toList());
        String joinedCommandLine = SourceLauncher.joinCommandLines(vmOptions);
        try {
            if (!joinedCommandLine.equals(this.root.getAttribute("single_file_vm_options"))) {
                this.root.setAttribute("single_file_vm_options", (Object)joinedCommandLine);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to set single_file_vm_options for " + this.root.getPath(), ex);
        }
        Boolean registerRoot = this.properties.values().stream().map(p -> p.registerRoot).filter(r -> r).findAny().isPresent();
        try {
            if (!registerRoot.equals(this.root.getAttribute("register_root"))) {
                this.root.setAttribute("register_root", (Object)registerRoot);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to set register_root for " + this.root.getPath(), ex);
        }
    }

    record FileProperties(String vmOptions, boolean registerRoot) {
    }
}

