/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.HostNameValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.localization.LocalizationSupport;

final class ValidHostNameOrIPValidator
extends StringValidator {
    private final HostNameValidator hostVal;
    private final Validator<String> ipVal = StringValidators.IP_ADDRESS;
    private static final Pattern NUMBERS = Pattern.compile("^\\d+$");

    ValidHostNameOrIPValidator(boolean allowPort) {
        this.hostVal = new HostNameValidator(allowPort);
    }

    ValidHostNameOrIPValidator() {
        this(true);
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        if (HostNameValidator.isIpV6(model)) {
            new HostNameValidator(true).validate(problems, compName, model);
            return;
        }
        String[] parts = model.split("\\.");
        boolean hasIntParts = false;
        boolean hasNonIntParts = false;
        if (model.indexOf(" ") > 0 || model.indexOf("\t") > 0) {
            problems.append(LocalizationSupport.getMessage(ValidHostNameOrIPValidator.class, "HOST_MAY_NOT_CONTAIN_WHITESPACE", compName, model));
            return;
        }
        if (parts.length == 0) {
            problems.append(LocalizationSupport.getMessage(ValidHostNameOrIPValidator.class, "INVALID_HOST_OR_IP", compName, model));
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (i == parts.length - 1 && s.contains(":")) {
                String[] partAndPort = s.split(":");
                if (partAndPort.length > 2) {
                    problems.append(LocalizationSupport.getMessage(ValidHostNameOrIPValidator.class, "TOO_MANY_COLONS", compName, model));
                    return;
                }
                if (partAndPort.length == 0) {
                    problems.append(LocalizationSupport.getMessage(ValidHostNameOrIPValidator.class, "INVALID_HOST_OR_IP", compName, model));
                    return;
                }
                s = partAndPort[0];
                if (partAndPort.length == 2) {
                    try {
                        Integer.parseInt(partAndPort[1]);
                    }
                    catch (NumberFormatException nfe) {
                        problems.append(LocalizationSupport.getMessage(ValidHostNameOrIPValidator.class, "INVALID_PORT", compName, partAndPort[1]));
                        return;
                    }
                }
            }
            boolean num = NUMBERS.matcher(s).find();
            hasIntParts |= num;
            hasNonIntParts |= !num;
        }
        if (hasNonIntParts) {
            this.hostVal.validate(problems, compName, model);
        } else {
            assert (hasIntParts);
            this.ipVal.validate(problems, compName, model);
        }
    }
}

