/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Blob;
import java.sql.SQLException;
import org.netbeans.modules.db.dataview.util.RandomAccessOutputStream;
import org.openide.util.Exceptions;

public class FileBackedBlob
implements Blob {
    private boolean freed = false;
    private File backingFile;

    public FileBackedBlob() throws SQLException {
        try {
            this.backingFile = Files.createTempFile("netbeans-db-blob", null, new FileAttribute[0]).toFile();
            this.backingFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    public FileBackedBlob(InputStream is) throws SQLException {
        this();
        OutputStream os = null;
        try {
            os = this.setBinaryStream(1L);
            int read = 0;
            byte[] buffer = new byte[(int)Math.pow(2.0, 18.0)];
            while ((read = is.read(buffer)) > 0) {
                os.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkFreed();
        return this.backingFile.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        this.checkLength(length);
        InputStream is = null;
        try {
            is = new FileInputStream(this.backingFile);
            is.skip(pos - 1L);
            byte[] result = new byte[length];
            is.read(result);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        try {
            return new FileInputStream(this.backingFile);
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkFreed();
        this.checkPos(start);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkFreed();
        this.checkPos(start);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.backingFile, "rw");
            raf.seek(pos - 1L);
            int border = Math.min(bytes.length, offset + len);
            int written = 0;
            for (int i = offset; i < border; ++i) {
                raf.write(bytes[i]);
                ++written;
            }
            int n = written;
            return n;
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.backingFile, "rw");
            try {
                raf.seek(pos - 1L);
            }
            catch (IOException ex) {
                raf.close();
                throw new SQLException(ex);
            }
            return new RandomAccessOutputStream(raf);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkFreed();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.backingFile, "rw");
            raf.setLength(len);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void free() throws SQLException {
        if (!this.freed) {
            this.backingFile.delete();
            this.freed = true;
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkFreed();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("Blob already freed");
        }
    }

    private void checkPos(long pos) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Illegal Value for position: " + Long.toString(pos));
        }
    }

    private void checkLength(long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("Illegal Value for length: " + Long.toString(length));
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    File getBackingFile() {
        return this.backingFile;
    }
}

