/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.Util;

public class TypeUtil {
    public static final String AN_KEY_NAME = "name";

    public static List<Annotation> getClassAnnotations(Class type) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(Arrays.asList(type.getAnnotations()));
        return result;
    }

    public static boolean isXmlRoot(Class type) {
        for (Annotation ann : type.getAnnotations()) {
            String annType = ann.annotationType().getName();
            if (!annType.equals("javax.xml.bind.annotation.XmlRootElement")) continue;
            return true;
        }
        return false;
    }

    public static Annotation getXmlElementAnnotation(Method m) {
        for (Annotation ann : m.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlElement")) continue;
            return ann;
        }
        return null;
    }

    public static Annotation getXmlAttributeAnnotation(Field f) {
        for (Annotation ann : f.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlAttribute")) continue;
            return ann;
        }
        return null;
    }

    public static Annotation getXmlAttributeAnnotation(Method m) {
        for (Annotation ann : m.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlAttribute")) continue;
            return ann;
        }
        return null;
    }

    public static Annotation getXmlElementAnnotation(Field f) {
        for (Annotation ann : f.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlElement")) continue;
            return ann;
        }
        return null;
    }

    public static List<Annotation> getFieldAnnotations(Class type) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Field f : type.getDeclaredFields()) {
            result.addAll(Arrays.asList(f.getAnnotations()));
        }
        return result;
    }

    public static List<Annotation> getMethodAnnotations(Class type) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Method m : type.getDeclaredMethods()) {
            result.addAll(Arrays.asList(m.getAnnotations()));
        }
        return result;
    }

    public static List<Annotation> getAnnotations(Class type, boolean deep) {
        List<Annotation> result = TypeUtil.getFieldAnnotations(type);
        result.addAll(TypeUtil.getMethodAnnotations(type));
        result.addAll(TypeUtil.getClassAnnotations(type));
        if (deep) {
            for (Class<?> c : type.getDeclaredClasses()) {
                result.addAll(TypeUtil.getAnnotations(c, deep));
            }
        }
        return result;
    }

    public static Map<String, String> getSimpleAnnotationValues(Annotation annotation) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        String value = annotation.toString();
        int begin = value.indexOf(40) + 1;
        int end = value.lastIndexOf(41);
        value = value.substring(begin, end);
        for (String s : pairs = value.split(",")) {
            String[] pair = s.split("=");
            if (pair.length != 2) continue;
            result.put(pair[0], pair[1]);
        }
        return result;
    }

    public static String getAnnotationValueName(Annotation annotation) {
        return TypeUtil.getSimpleAnnotationValues(annotation).get(AN_KEY_NAME);
    }

    public static String getAnnotationValueName(CompilationController controller, TypeElement classElement, TypeElement annotationElement) {
        List<? extends AnnotationMirror> annotations = classElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!controller.getTypes().isSameType(annotationElement.asType(), annotationMirror.getAnnotationType())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(AN_KEY_NAME)) continue;
                return (String)expressions.get(entry.getKey()).getValue();
            }
        }
        return null;
    }

    public static String getQualifiedClassName(String simpleName, JavaSource context) throws IOException {
        final String suffix = "." + simpleName;
        final String[] found = new String[1];
        context.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.RESOLVED);
                for (String imp : JavaSourceHelper.getImports(controller)) {
                    if (!imp.endsWith(suffix)) continue;
                    found[0] = imp;
                    break;
                }
            }
        }, true);
        return found[0];
    }

    public static Class getClass(String name, JavaSource context, Project project) throws IOException {
        if (name.indexOf(46) > 0) {
            return Util.getType(project, name);
        }
        String qualifiedName = TypeUtil.getQualifiedClassName(name, context);
        if (qualifiedName != null) {
            return Util.getType(project, qualifiedName);
        }
        return null;
    }

    public static Annotation getJpaTableAnnotation(Class c) {
        for (Annotation ann : c.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.persistence.Table")) continue;
            return ann;
        }
        return null;
    }

    public static Annotation getJpaEntityAnnotation(Class c) {
        for (Annotation ann : c.getAnnotations()) {
            if (!ann.annotationType().getName().equals("javax.persistence.Entity")) continue;
            return ann;
        }
        return null;
    }
}

