/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNodePoolOptionsRequest
extends BmcRequest<Void> {
    private String nodePoolOptionId;
    private String compartmentId;
    private String opcRequestId;

    public String getNodePoolOptionId() {
        return this.nodePoolOptionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().nodePoolOptionId(this.nodePoolOptionId).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",nodePoolOptionId=").append(String.valueOf(this.nodePoolOptionId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNodePoolOptionsRequest)) {
            return false;
        }
        GetNodePoolOptionsRequest other = (GetNodePoolOptionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.nodePoolOptionId, other.nodePoolOptionId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.nodePoolOptionId == null ? 43 : this.nodePoolOptionId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNodePoolOptionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String nodePoolOptionId = null;
        private String compartmentId = null;
        private String opcRequestId = null;

        public Builder nodePoolOptionId(String nodePoolOptionId) {
            this.nodePoolOptionId = nodePoolOptionId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNodePoolOptionsRequest o) {
            this.nodePoolOptionId(o.getNodePoolOptionId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNodePoolOptionsRequest build() {
            GetNodePoolOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNodePoolOptionsRequest buildWithoutInvocationCallback() {
            GetNodePoolOptionsRequest request = new GetNodePoolOptionsRequest();
            request.nodePoolOptionId = this.nodePoolOptionId;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

