/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class JaxWsRootChildren
extends Children.Keys<Service> {
    private static final RequestProcessor JAX_WS_ROOT_RP = new RequestProcessor(JaxWsRootChildren.class);
    JaxWsModel jaxWsModel;
    Service[] services;
    JaxWsListener listener;
    FileObject[] srcRoots;
    private final RequestProcessor.Task updateNodeTask = JAX_WS_ROOT_RP.create(new Runnable(){

        @Override
        public void run() {
            JaxWsRootChildren.this.updateKeys();
        }
    });

    public JaxWsRootChildren(JaxWsModel jaxWsModel, FileObject[] srcRoots) {
        this.jaxWsModel = jaxWsModel;
        this.srcRoots = srcRoots;
    }

    protected void addNotify() {
        this.listener = new JaxWsListener();
        this.jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        this.jaxWsModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    private void updateKeys() {
        ArrayList<Service> keys = new ArrayList<Service>();
        this.services = this.jaxWsModel.getServices();
        if (this.services != null) {
            for (int i = 0; i < this.services.length; ++i) {
                keys.add(this.services[i]);
            }
        }
        this.setKeys(keys);
    }

    protected Node[] createNodes(Service key) {
        String implClass = key.getImplementationClass();
        for (FileObject srcRoot : this.srcRoots) {
            FileObject implClassFo = this.getImplementationClass(implClass, srcRoot);
            if (implClassFo == null) continue;
            return new Node[]{new JaxWsNode(this.jaxWsModel, key, srcRoot, implClassFo)};
        }
        return new Node[0];
    }

    private FileObject getImplementationClass(String implClass, FileObject srcRoot) {
        if (implClass != null && srcRoot != null) {
            return srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
        }
        return null;
    }

    class JaxWsListener
    implements PropertyChangeListener {
        JaxWsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JaxWsRootChildren.this.updateNodeTask.schedule(2000);
        }
    }
}

