/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineMappedMatcherSmall;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class AsciiMultiLineMappedMatcher
extends AbstractMatcher {
    private SearchPattern searchPattern;
    private Pattern pattern;
    private int fileMatches = 0;
    private int itemMatches = 0;

    public AsciiMultiLineMappedMatcher(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MatchingObject.Def checkMeasuredInternal(FileObject fo, SearchListener listener) {
        MatchingObject.Def def;
        AbstractInterruptibleChannel fc;
        MappedByteBuffer bb;
        block18: {
            block19: {
                MatchingObject.Def def2;
                block16: {
                    block17: {
                        bb = null;
                        fc = null;
                        try {
                            listener.fileContentMatchingStarted(fo.getPath());
                            File file = FileUtil.toFile((FileObject)fo);
                            FileInputStream fis = new FileInputStream(file);
                            fc = fis.getChannel();
                            int sz = (int)((FileChannel)fc).size();
                            bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
                            List<TextDetail> list = this.matchWholeFile(new FastCharSequence(bb, 0), fo);
                            if (list != null && !list.isEmpty()) {
                                def2 = new MatchingObject.Def(fo, Charset.forName("ASCII"), list);
                                if (fc == null) break block16;
                                break block17;
                            }
                            def = null;
                            if (fc == null) break block18;
                            break block19;
                        }
                        catch (Exception e) {
                            listener.generalError(e);
                            MatchingObject.Def def3 = null;
                            return def3;
                        }
                    }
                    try {
                        fc.close();
                    }
                    catch (IOException ex) {
                        listener.generalError(ex);
                    }
                }
                MatcherUtils.unmap(bb);
                return def2;
            }
            try {
                fc.close();
            }
            catch (IOException ex) {
                listener.generalError(ex);
            }
        }
        MatcherUtils.unmap(bb);
        return def;
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException ex) {
                    listener.generalError(ex);
                }
            }
            MatcherUtils.unmap(bb);
        }
    }

    private List<TextDetail> matchWholeFile(CharSequence cb, FileObject fo) throws DataObjectNotFoundException {
        Matcher textMatcher = this.pattern.matcher(cb);
        DataObject dataObject = null;
        MultiLineMappedMatcherSmall.LineInfoHelper lineInfoHelper = new MultiLineMappedMatcherSmall.LineInfoHelper(cb);
        LinkedList<TextDetail> textDetails = null;
        while (textMatcher.find()) {
            if (textDetails == null) {
                textDetails = new LinkedList<TextDetail>();
                dataObject = DataObject.find((FileObject)fo);
                ++this.fileMatches;
            }
            ++this.itemMatches;
            TextDetail ntd = new TextDetail(dataObject, this.searchPattern);
            lineInfoHelper.findAndSetPositionInfo(ntd, textMatcher.start(), textMatcher.end(), textMatcher.group());
            textDetails.add(ntd);
            if (this.fileMatches < Constants.COUNT_LIMIT && this.itemMatches < Constants.DETAILS_COUNT_LIMIT) continue;
            break;
        }
        return textDetails;
    }

    @Override
    public void terminate() {
    }

    private class FastCharSequence
    implements CharSequence {
        private ByteBuffer bb;
        private int start;

        public FastCharSequence(ByteBuffer bb, int start) {
            this.bb = bb;
            this.start = start;
        }

        @Override
        public int length() {
            return this.bb.limit();
        }

        @Override
        public char charAt(int index) {
            return (char)this.bb.get(this.start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            StringBuilder sb = new StringBuilder();
            for (int i = start; i < end; ++i) {
                sb.append(this.charAt(i));
            }
            return sb.toString();
        }
    }
}

