/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.util.Date;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.history.HistoryActionSupport;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public abstract class HistoryActionVCSProxyBased
extends NodeAction {
    private final HistoryActionSupport<VCSHistoryProvider.HistoryEntry> support = new HistoryActionSupport<VCSHistoryProvider.HistoryEntry>(this.getCallback());
    private final String name;
    private final boolean multipleHistory;
    private Lookup context;

    public HistoryActionVCSProxyBased() {
        this(null, true);
    }

    public HistoryActionVCSProxyBased(String name) {
        this(name, true);
    }

    public HistoryActionVCSProxyBased(String name, boolean multipleHistory) {
        this.name = name;
        this.multipleHistory = multipleHistory;
    }

    protected abstract void perform(VCSHistoryProvider.HistoryEntry var1, Set<VCSFileProxy> var2);

    public String getName() {
        assert (this.name != null);
        return this.name;
    }

    protected boolean isMultipleHistory() {
        return this.multipleHistory;
    }

    protected String getRevisionShort() {
        return this.support.getRevisionShort();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.context = actionContext;
        return super.createContextAwareInstance(actionContext);
    }

    private Lookup getContext() {
        return this.context;
    }

    protected void performAction(Node[] activatedNodes) {
        this.support.performAction(activatedNodes);
    }

    protected boolean enable(Node[] activatedNodes) {
        return this.support.hasEntryAndFiles(activatedNodes);
    }

    protected HistoryActionSupport.Callback<VCSHistoryProvider.HistoryEntry> getCallback() {
        return new HistoryActionSupport.Callback<VCSHistoryProvider.HistoryEntry>(){

            @Override
            public void call(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                HistoryActionVCSProxyBased.this.perform(entry, files);
            }

            @Override
            public HistoryActionSupport.HistoryEntryWrapper<VCSHistoryProvider.HistoryEntry> lookupEntry(Node node) {
                VCSHistoryProvider.HistoryEntry he = (VCSHistoryProvider.HistoryEntry)node.getLookup().lookup(VCSHistoryProvider.HistoryEntry.class);
                return he != null ? new HistoryEntryImpl(he) : null;
            }

            @Override
            public Lookup getContext() {
                return HistoryActionVCSProxyBased.this.getContext();
            }

            @Override
            public boolean isMultipleHistory() {
                return HistoryActionVCSProxyBased.this.isMultipleHistory();
            }
        };
    }

    private class HistoryEntryImpl
    implements HistoryActionSupport.HistoryEntryWrapper<VCSHistoryProvider.HistoryEntry> {
        private final VCSHistoryProvider.HistoryEntry he;

        public HistoryEntryImpl(VCSHistoryProvider.HistoryEntry he) {
            this.he = he;
        }

        @Override
        public VCSHistoryProvider.HistoryEntry getHistoryEntry() {
            return this.he;
        }

        @Override
        public String getRevisionShort() {
            return this.he.getRevisionShort();
        }

        @Override
        public Date getDateTime() {
            return this.he.getDateTime();
        }

        @Override
        public String getRevision() {
            return this.he.getRevision();
        }
    }
}

