/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.InlineRefactoring;
import org.netbeans.modules.refactoring.java.ui.InlineAction;
import org.netbeans.modules.refactoring.java.ui.InnerToOuterAction;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InlineRefactoringUI
implements RefactoringUI {
    private InlineRefactoring refactoring;
    private String type;
    private String elementName;

    public InlineRefactoringUI(TreePathHandle selectedElement, InlineRefactoring.Type refactoringType, String elementName, String type) {
        this.refactoring = new InlineRefactoring(selectedElement, refactoringType);
        this.elementName = elementName;
        this.type = type;
    }

    private InlineRefactoringUI() {
    }

    public String getName() {
        return NbBundle.getMessage(InlineAction.class, (String)"LBL_Inline", (Object)this.type);
    }

    public String getDescription() {
        return NbBundle.getMessage(InnerToOuterAction.class, (String)"DSC_Inline", (Object)this.elementName);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        return null;
    }

    public Problem setParameters() {
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.refactoring.fastCheckParameters();
    }

    public boolean hasParameters() {
        return false;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.InlineRefactoringUI");
    }

    public static JavaRefactoringUIFactory factory() {
        return new JavaRefactoringUIFactory(){

            @Override
            public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
                InlineRefactoring.Type refactoringType;
                String type;
                assert (handles.length == 1);
                TreePathHandle selectedElement = handles[0];
                switch (selectedElement.getKind()) {
                    case BOOLEAN_LITERAL: 
                    case CHAR_LITERAL: 
                    case DOUBLE_LITERAL: 
                    case FLOAT_LITERAL: 
                    case INT_LITERAL: 
                    case LONG_LITERAL: 
                    case NULL_LITERAL: 
                    case STRING_LITERAL: {
                        TreePath tp = selectedElement.resolve(info);
                        if (tp == null) {
                            return null;
                        }
                        TreePath parent = tp.getParentPath();
                        Element parentElement = info.getTrees().getElement(parent);
                        if (parentElement == null || parentElement.getKind() != ElementKind.LOCAL_VARIABLE) break;
                        selectedElement = TreePathHandle.create((TreePath)parent, (CompilationInfo)info);
                    }
                }
                TreePath path = selectedElement.resolve(info);
                if (path == null || info.getTreeUtilities().isSynthetic(path)) {
                    return null;
                }
                Element element = info.getTrees().getElement(path);
                if (element == null) {
                    return null;
                }
                switch (element.getKind()) {
                    case FIELD: {
                        type = "Constant";
                        refactoringType = InlineRefactoring.Type.CONSTANT;
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        type = "Temp";
                        refactoringType = InlineRefactoring.Type.TEMP;
                        break;
                    }
                    case METHOD: {
                        type = "Method";
                        refactoringType = InlineRefactoring.Type.METHOD;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new InlineRefactoringUI(selectedElement, refactoringType, element.getSimpleName().toString(), type);
            }
        };
    }
}

