/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Arguments for 'continue' request.
 */
@SuppressWarnings("all")
public class ContinueArguments {
  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#supportsSingleThreadExecutionRequests}) and the optional
   * argument {@link #singleThread} is true, only the thread with this ID is resumed.
   */
  private int threadId;
  
  /**
   * If this optional flag is true, execution is resumed only for the thread
   * with given {@link #threadId}.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  private Boolean singleThread;
  
  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#supportsSingleThreadExecutionRequests}) and the optional
   * argument {@link #singleThread} is true, only the thread with this ID is resumed.
   */
  @Pure
  public int getThreadId() {
    return this.threadId;
  }
  
  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#supportsSingleThreadExecutionRequests}) and the optional
   * argument {@link #singleThread} is true, only the thread with this ID is resumed.
   */
  public void setThreadId(final int threadId) {
    this.threadId = threadId;
  }
  
  /**
   * If this optional flag is true, execution is resumed only for the thread
   * with given {@link #threadId}.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  @Pure
  public Boolean getSingleThread() {
    return this.singleThread;
  }
  
  /**
   * If this optional flag is true, execution is resumed only for the thread
   * with given {@link #threadId}.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  public void setSingleThread(final Boolean singleThread) {
    this.singleThread = singleThread;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("threadId", this.threadId);
    b.add("singleThread", this.singleThread);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ContinueArguments other = (ContinueArguments) obj;
    if (other.threadId != this.threadId)
      return false;
    if (this.singleThread == null) {
      if (other.singleThread != null)
        return false;
    } else if (!this.singleThread.equals(other.singleThread))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + this.threadId;
    return prime * result + ((this.singleThread== null) ? 0 : this.singleThread.hashCode());
  }
}
