/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.opensearch.securityanalytics.util.ThrowableCheckingPredicates;

public class ExceptionChecker {
    public boolean doesGroupedActionListenerExceptionMatch(Exception ex, List<ThrowableCheckingPredicates> exceptionMatchers) {
        return Stream.concat(Arrays.stream(ex.getSuppressed()), Stream.of(ex)).allMatch(throwable -> this.doesExceptionMatch((Throwable)throwable, exceptionMatchers));
    }

    private boolean doesExceptionMatch(Throwable throwable, List<ThrowableCheckingPredicates> exceptionMatchers) {
        return exceptionMatchers.stream().map(ThrowableCheckingPredicates::getMatcherPredicate).anyMatch(matcher -> matcher.test(throwable));
    }
}

