/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretInput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretOutput;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyOutput;

public class __default {
    public static boolean ValidPublicKeyLength(DafnySequence<? extends Byte> p) {
        long _0_len = p.cardinalityInt();
        return _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__256() || _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__384() || _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__521();
    }

    public static boolean ValidCompressedPublicKeyLength(DafnySequence<? extends Byte> p) {
        long _0_len = p.cardinalityInt();
        return _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__256() || _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__384() || _0_len == Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__521();
    }

    public static boolean ValidProviderInfoLength(DafnySequence<? extends Byte> p) {
        long _0_len = p.cardinalityInt();
        return _0_len == Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__256__LEN()) || _0_len == Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__384__LEN()) || _0_len == Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN());
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> LocalDeriveSharedSecret(ECCPrivateKey senderPrivateKey, ECCPublicKey recipientPublicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<DeriveSharedSecretOutput, Error> _out0;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DeriveSharedSecretOutput, Error> _0_maybeSharedSecret = _out0 = crypto.DeriveSharedSecret(DeriveSharedSecretInput.create(curveSpec, senderPrivateKey, recipientPublicKey));
        Result<DeriveSharedSecretOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_valueOrError0 = Result.Default(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DeriveSharedSecretOutput.Default());
        _1_valueOrError0 = _0_maybeSharedSecret.MapFailure(DeriveSharedSecretOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            Error _2_e = _2_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_2_e);
        });
        if (_1_valueOrError0.IsFailure(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DeriveSharedSecretOutput _3_sharedSecretOutput = _1_valueOrError0.Extract(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _3_sharedSecretOutput.dtor_sharedSecret());
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> CompressPublicKey(ECCPublicKey publicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<CompressPublicKeyOutput, Error> _out0;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<CompressPublicKeyOutput, Error> _0_maybeCompressedPublicKey = _out0 = crypto.CompressPublicKey(CompressPublicKeyInput.create(publicKey, curveSpec));
        Result<CompressPublicKeyOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_valueOrError0 = Result.Default(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), CompressPublicKeyOutput.Default());
        _1_valueOrError0 = _0_maybeCompressedPublicKey.MapFailure(CompressPublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            Error _2_e = _2_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_2_e);
        });
        if (_1_valueOrError0.IsFailure(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        CompressPublicKeyOutput _3_compressedPublicKey = _1_valueOrError0.Extract(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _3_compressedPublicKey.dtor_compressedPublicKey());
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecompressPublicKey(DafnySequence<? extends Byte> publicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<DecompressPublicKeyOutput, Error> _out0;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DecompressPublicKeyOutput, Error> _0_maybePublicKey = _out0 = crypto.DecompressPublicKey(DecompressPublicKeyInput.create(publicKey, curveSpec));
        Result<DecompressPublicKeyOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_valueOrError0 = Result.Default(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DecompressPublicKeyOutput.Default());
        _1_valueOrError0 = _0_maybePublicKey.MapFailure(DecompressPublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            Error _2_e = _2_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_2_e);
        });
        if (_1_valueOrError0.IsFailure(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DecompressPublicKeyOutput _3_publicKey = _1_valueOrError0.Extract(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _3_publicKey.dtor_publicKey().dtor_der());
        return res;
    }

    public static DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(__default.RAW__ECDH__KEYRING__VERSION(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(recipientPublicKey.cardinalityInt())), recipientPublicKey), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(senderPublicKey.cardinalityInt())), senderPublicKey);
    }

    public static Result<GenerateECCKeyPairOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GenerateEphemeralEccKeyPair(ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<GenerateECCKeyPairOutput, Error> _out0;
        Result<GenerateECCKeyPairOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), GenerateECCKeyPairOutput.Default());
        Result<GenerateECCKeyPairOutput, Error> _0_maybeKeyPair = _out0 = crypto.GenerateECCKeyPair(GenerateECCKeyPairInput.create(curveSpec));
        Result<GenerateECCKeyPairOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_valueOrError0 = Result.Default(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), GenerateECCKeyPairOutput.Default());
        _1_valueOrError0 = _0_maybeKeyPair.MapFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            Error _2_e = _2_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_2_e);
        });
        if (_1_valueOrError0.IsFailure(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), GenerateECCKeyPairOutput._typeDescriptor());
            return res;
        }
        GenerateECCKeyPairOutput _3_keyPair = _1_valueOrError0.Extract(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _3_keyPair);
        return res;
    }

    public static Result<Boolean, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ValidatePublicKey(AtomicPrimitivesClient crypto, ECDHCurveSpec curveSpec, DafnySequence<? extends Byte> publicKey) {
        Result<ValidatePublicKeyOutput, Error> _out0;
        Result<Boolean, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(TypeDescriptor.BOOLEAN, software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), false);
        Result<ValidatePublicKeyOutput, Error> _0_maybeValidate = _out0 = crypto.ValidatePublicKey(ValidatePublicKeyInput.create(curveSpec, publicKey));
        Result<ValidatePublicKeyOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_valueOrError0 = Result.Default(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ValidatePublicKeyOutput.Default());
        _1_valueOrError0 = _0_maybeValidate.MapFailure(ValidatePublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            Error _2_e = _2_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_2_e);
        });
        if (_1_valueOrError0.IsFailure(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        ValidatePublicKeyOutput _3_validate = _1_valueOrError0.Extract(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(TypeDescriptor.BOOLEAN, software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _3_validate.dtor_success());
        return res;
    }

    public static DafnySequence<? extends Character> CurveSpecTypeToString(ECDHCurveSpec c) {
        ECDHCurveSpec _source0 = c;
        if (_source0.is_ECC__NIST__P256()) {
            return DafnySequence.asString((String)"p256");
        }
        if (_source0.is_ECC__NIST__P384()) {
            return DafnySequence.asString((String)"p384");
        }
        if (_source0.is_ECC__NIST__P521()) {
            return DafnySequence.asString((String)"p521");
        }
        return DafnySequence.asString((String)"sm2");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.Error E(DafnySequence<? extends Character> s) {
        return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(s);
    }

    public static DafnySequence<? extends Byte> RAW__ECDH__KEYRING__VERSION() {
        return DafnySequence.of((byte[])new byte[]{1});
    }

    public String toString() {
        return "RawECDHKeyring._default";
    }
}

