/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.utils.Util;

public class Paramer {
    public String analysis;
    public Float boost;
    public String value;
    public Integer slop;
    public final Map<String, Float> fieldsBoosts = new HashMap<String, Float>();
    public String type;
    public Float tieBreaker;
    public Operator operator;
    public String default_field;

    public static Paramer parseParamer(SQLMethodInvokeExpr method) throws SqlParseException {
        Paramer instance = new Paramer();
        List parameters = method.getParameters();
        block22: for (SQLExpr expr : parameters) {
            if (expr instanceof SQLCharExpr) {
                if (instance.value == null) {
                    instance.value = ((SQLCharExpr)expr).getText();
                    continue;
                }
                instance.analysis = ((SQLCharExpr)expr).getText();
                continue;
            }
            if (expr instanceof SQLNumericLiteralExpr) {
                instance.boost = Float.valueOf(((SQLNumericLiteralExpr)expr).getNumber().floatValue());
                continue;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) continue;
            SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)expr;
            switch (Util.expr2Object(sqlExpr.getLeft()).toString()) {
                case "query": {
                    instance.value = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "analyzer": {
                    instance.analysis = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "boost": {
                    instance.boost = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "slop": {
                    instance.slop = Integer.parseInt(Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "fields": {
                    for (String f : Strings.splitStringByCommaToArray((String)Util.expr2Object(sqlExpr.getRight()).toString())) {
                        int index = f.lastIndexOf(94);
                        if (-1 < index) {
                            instance.fieldsBoosts.put(f.substring(0, index), Float.valueOf(Float.parseFloat(f.substring(index + 1))));
                            continue;
                        }
                        instance.fieldsBoosts.put(f, Float.valueOf(1.0f));
                    }
                    continue block22;
                }
                case "type": {
                    instance.type = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "tie_breaker": {
                    instance.tieBreaker = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "operator": {
                    instance.operator = Operator.fromString((String)Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "default_field": {
                    instance.default_field = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
            }
        }
        return instance;
    }

    public static ToXContent fullParamer(MatchPhraseQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        return query;
    }

    public static ToXContent fullParamer(MatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        return query;
    }

    public static ToXContent fullParamer(WildcardQueryBuilder query, Paramer paramer) {
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        return query;
    }

    public static ToXContent fullParamer(QueryStringQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.phraseSlop(paramer.slop.intValue());
        }
        if (paramer.default_field != null) {
            query.defaultField(paramer.default_field);
        }
        return query;
    }

    public static ToXContent fullParamer(MultiMatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        if (paramer.type != null) {
            query.type((Object)paramer.type);
        }
        if (paramer.tieBreaker != null) {
            query.tieBreaker(paramer.tieBreaker);
        }
        if (paramer.operator != null) {
            query.operator(paramer.operator);
        }
        return query;
    }
}

