/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.MetricParserHelper;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class CompositeAggregationParser
implements OpenSearchAggregationResponseParser {
    private final MetricParserHelper metricsParser;

    public CompositeAggregationParser(MetricParser ... metricParserList) {
        this.metricsParser = new MetricParserHelper(Arrays.asList(metricParserList));
    }

    public CompositeAggregationParser(List<MetricParser> metricParserList) {
        this.metricsParser = new MetricParserHelper(metricParserList);
    }

    @Override
    public List<Map<String, Object>> parse(Aggregations aggregations) {
        return ((CompositeAggregation)aggregations.asList().get(0)).getBuckets().stream().map(this::parse).flatMap(Collection::stream).toList();
    }

    private List<Map<String, Object>> parse(CompositeAggregation.Bucket bucket) {
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>();
        resultMapList.add(new HashMap(bucket.getKey()));
        resultMapList.addAll(this.metricsParser.parse(bucket.getAggregations()));
        return resultMapList;
    }

    @Override
    public List<Map<String, Object>> parse(SearchHits hits) {
        throw new UnsupportedOperationException("CompositeAggregationParser doesn't support parse(SearchHits)");
    }

    @Generated
    public MetricParserHelper getMetricsParser() {
        return this.metricsParser;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeAggregationParser)) {
            return false;
        }
        CompositeAggregationParser other = (CompositeAggregationParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricParserHelper this$metricsParser = this.getMetricsParser();
        MetricParserHelper other$metricsParser = other.getMetricsParser();
        return !(this$metricsParser == null ? other$metricsParser != null : !((Object)this$metricsParser).equals(other$metricsParser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompositeAggregationParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricParserHelper $metricsParser = this.getMetricsParser();
        result = result * 59 + ($metricsParser == null ? 43 : ((Object)$metricsParser).hashCode());
        return result;
    }
}

