/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class BitmapIndexQuery
extends Query
implements Accountable {
    private final RoaringBitmap bitmap;
    private final String field;

    public BitmapIndexQuery(String field, RoaringBitmap bitmap) {
        BitmapIndexQuery.checkArgs(field, bitmap);
        this.bitmap = bitmap;
        this.field = field;
    }

    static void checkArgs(String field, RoaringBitmap bitmap) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
    }

    private static BitmapIterator bitmapEncodedIterator(final RoaringBitmap bitmap) {
        return new BitmapIterator(){
            private final PeekableIntIterator iterator;
            private final BytesRef encoded;
            {
                this.iterator = bitmap.getIntIterator();
                this.encoded = new BytesRef(new byte[4]);
            }

            @Override
            public BytesRef next() {
                if (!this.iterator.hasNext()) {
                    return null;
                }
                int value = this.iterator.next();
                IntPoint.encodeDimension((int)value, (byte[])this.encoded.bytes, (int)0);
                return this.encoded;
            }

            @Override
            public void advance(byte[] target) {
                this.iterator.advanceIfNeeded(IntPoint.decodeDimension((byte[])target, (int)0));
            }
        };
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, this, boost){
            final long cardinality;
            final /* synthetic */ BitmapIndexQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
                this.cardinality = this.this$0.bitmap.getLongCardinality();
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(this.this$0.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != 1) {
                    throw new IllegalArgumentException("field must have only one dimension");
                }
                return new ScorerSupplier(this){
                    long cost = -1L;
                    final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                    final MergePointVisitor visitor;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.visitor = new MergePointVisitor(this.this$1.this$0, this.result);
                    }

                    public Scorer get(long leadCost) throws IOException {
                        values.intersect((PointValues.IntersectVisitor)this.visitor);
                        return new ConstantScoreScorer(this.this$1.score(), scoreMode, this.result.build().iterator());
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = this.this$1.cardinality * 20L;
                        }
                        return this.cost;
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.bitmap.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    public String toString(String field) {
        return "BitmapIndexQuery(field=" + this.field + ")";
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        BitmapIndexQuery that = (BitmapIndexQuery)((Object)other);
        return this.field.equals(that.field) && this.bitmap.equals((Object)that.bitmap);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.bitmap);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.shallowSizeOfInstance(BitmapIndexQuery.class) + RamUsageEstimator.sizeOf((String)this.field) + this.bitmap.getLongSizeInBytes();
    }

    private class MergePointVisitor
    implements PointValues.IntersectVisitor {
        private final DocIdSetBuilder result;
        private final BitmapIterator iterator;
        private BytesRef nextQueryPoint;
        private final ArrayUtil.ByteArrayComparator comparator;
        private DocIdSetBuilder.BulkAdder adder;

        public MergePointVisitor(BitmapIndexQuery bitmapIndexQuery, DocIdSetBuilder result) throws IOException {
            this.result = result;
            this.comparator = ArrayUtil.getUnsignedComparator((int)4);
            this.iterator = BitmapIndexQuery.bitmapEncodedIterator(bitmapIndexQuery.bitmap);
            this.nextQueryPoint = this.iterator.next();
        }

        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        public void visit(int docID) {
            this.adder.add(docID);
        }

        public void visit(DocIdSetIterator iterator) throws IOException {
            this.adder.add(iterator);
        }

        public void visit(int docID, byte[] packedValue) {
            if (this.matches(packedValue)) {
                this.visit(docID);
            }
        }

        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            if (this.matches(packedValue)) {
                this.adder.add(iterator);
            }
        }

        private boolean matches(byte[] packedValue) {
            while (this.nextQueryPoint != null) {
                int cmp = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, packedValue, 0);
                if (cmp == 0) {
                    return true;
                }
                if (cmp >= 0) break;
                this.iterator.advance(packedValue);
                this.nextQueryPoint = this.iterator.next();
            }
            return false;
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            while (this.nextQueryPoint != null) {
                int cmpMin = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, minPackedValue, 0);
                if (cmpMin < 0) {
                    this.iterator.advance(minPackedValue);
                    this.nextQueryPoint = this.iterator.next();
                    continue;
                }
                int cmpMax = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, maxPackedValue, 0);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static interface BitmapIterator
    extends BytesRefIterator {
        public BytesRef next();

        public void advance(byte[] var1);
    }
}

