/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexSettings;
import org.opensearch.indices.ClusterMergeSchedulerConfig;

@PublicApi(since="1.0.0")
public final class MergeSchedulerConfig {
    static Logger logger = LogManager.getLogger(MergeSchedulerConfig.class);
    public static final boolean DEFAULT_AUTO_THROTTLE = true;
    public static final Setting<Integer> MAX_THREAD_COUNT_SETTING = new Setting<Integer>("index.merge.scheduler.max_thread_count", MergeSchedulerConfig::getDefaultMaxThreadCount, s -> Setting.parseInt(s, 1, "index.merge.scheduler.max_thread_count"), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_MERGE_COUNT_SETTING = new Setting<Integer>("index.merge.scheduler.max_merge_count", MergeSchedulerConfig::getDefaultMergeCount, s -> Setting.parseInt(s, 1, "index.merge.scheduler.max_merge_count"), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> AUTO_THROTTLE_SETTING = Setting.boolSetting("index.merge.scheduler.auto_throttle", MergeSchedulerConfig::getDefaultAutoThrottle, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> MAX_FORCE_MERGE_MB_PER_SEC_SETTING = Setting.doubleSetting("index.merge.scheduler.max_force_merge_mb_per_sec", Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> CLUSTER_MAX_FORCE_MERGE_MB_PER_SEC_SETTING = Setting.doubleSetting("cluster.merge.scheduler.max_force_merge_mb_per_sec", Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final String indexName;
    private volatile boolean autoThrottle;
    private volatile int maxThreadCount;
    private volatile int maxMergeCount;
    private volatile double maxForceMergeMBPerSec;
    private static volatile Boolean clusterAutoThrottleEnabledDefault;
    private static volatile Integer clusterMaxThreadCountDefault;
    private static volatile Integer clusterMaxMergeCountDefault;

    MergeSchedulerConfig(IndexSettings indexSettings) {
        this.indexName = indexSettings.getIndex().getName();
        this.initMergeConfigs(indexSettings);
        this.updateMaxForceMergeMBPerSec(indexSettings);
    }

    public synchronized void setDefaultMaxThreadAndMergeCount(int threadCount, int mergeCount, boolean overrideExistingConfigs) {
        clusterMaxThreadCountDefault = threadCount;
        clusterMaxMergeCountDefault = mergeCount;
        if (overrideExistingConfigs) {
            this.setMaxThreadAndMergeCount(threadCount, mergeCount);
        }
    }

    public synchronized void setDefaultAutoThrottleEnabled(boolean enabled, boolean overrideExistingConfigs) {
        clusterAutoThrottleEnabledDefault = enabled;
        if (overrideExistingConfigs) {
            this.setAutoThrottle(enabled);
        }
    }

    private void initMergeConfigs(IndexSettings indexSettings) {
        Settings settings = indexSettings.getSettings();
        boolean useCachedClusterDefaults = !MAX_THREAD_COUNT_SETTING.exists(settings) && !MAX_MERGE_COUNT_SETTING.exists(settings) && clusterMaxThreadCountDefault != null && clusterMaxMergeCountDefault != null;
        int maxThread = useCachedClusterDefaults ? clusterMaxThreadCountDefault : MAX_THREAD_COUNT_SETTING.get(settings);
        int maxMerge = useCachedClusterDefaults ? clusterMaxMergeCountDefault : MAX_MERGE_COUNT_SETTING.get(settings);
        boolean autoThrottleEnabled = !AUTO_THROTTLE_SETTING.exists(settings) && clusterAutoThrottleEnabledDefault != null ? clusterAutoThrottleEnabledDefault : AUTO_THROTTLE_SETTING.get(settings);
        this.setAutoThrottle(autoThrottleEnabled);
        this.setMaxThreadAndMergeCount(maxThread, maxMerge);
        logger.info((Message)new ParameterizedMessage("Initialized index {} with maxMergeCount={}, maxThreadCount={}, autoThrottleEnabled={}", new Object[]{this.indexName, this.maxMergeCount, this.maxThreadCount, this.autoThrottle}));
    }

    public boolean isAutoThrottle() {
        return this.autoThrottle;
    }

    public void setAutoThrottle(boolean enabled) {
        logger.info((Message)new ParameterizedMessage("Updating autoThrottle for index {} from [{}] to [{}]", new Object[]{this.indexName, this.autoThrottle, enabled}));
        this.autoThrottle = enabled;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadAndMergeCount(int newMaxThreadCount, int newMaxMergeCount) {
        if (newMaxThreadCount == this.maxThreadCount && newMaxMergeCount == this.maxMergeCount) {
            return;
        }
        MergeSchedulerConfig.validateMaxThreadAndMergeCount(newMaxThreadCount, newMaxMergeCount);
        logger.info((Message)new ParameterizedMessage("Updating maxThreadCount from [{}] to [{}] and maxMergeCount from [{}] to [{}] for index {}.", new Object[]{this.maxThreadCount, newMaxThreadCount, this.maxMergeCount, newMaxMergeCount, this.indexName}));
        this.maxThreadCount = newMaxThreadCount;
        this.maxMergeCount = newMaxMergeCount;
    }

    public static void validateMaxThreadAndMergeCount(int maxThreadCount, int maxMergeCount) {
        if (maxThreadCount < 1) {
            throw new IllegalArgumentException("maxThreadCount (= " + maxThreadCount + ") should be at least 1");
        }
        if (maxMergeCount < 1) {
            throw new IllegalArgumentException("maxMergeCount (= " + maxMergeCount + ") should be at least 1");
        }
        if (maxThreadCount > maxMergeCount) {
            throw new IllegalArgumentException("maxThreadCount (= " + maxThreadCount + ") should be <= maxMergeCount (= " + maxMergeCount + ")");
        }
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public double getMaxForceMergeMBPerSec() {
        return this.maxForceMergeMBPerSec;
    }

    void setMaxForceMergeMBPerSec(double maxForceMergeMBPerSec) {
        this.maxForceMergeMBPerSec = maxForceMergeMBPerSec;
    }

    public void updateMaxForceMergeMBPerSec(IndexSettings indexSettings) {
        boolean hasIndexSetting = MAX_FORCE_MERGE_MB_PER_SEC_SETTING.exists(indexSettings.getSettings());
        this.maxForceMergeMBPerSec = hasIndexSetting ? indexSettings.getValue(MAX_FORCE_MERGE_MB_PER_SEC_SETTING).doubleValue() : CLUSTER_MAX_FORCE_MERGE_MB_PER_SEC_SETTING.get(indexSettings.getNodeSettings()).doubleValue();
    }

    private static String getDefaultMaxThreadCount(Settings settings) {
        if (MAX_MERGE_COUNT_SETTING == null || MAX_MERGE_COUNT_SETTING.exists(settings) || clusterMaxThreadCountDefault == null) {
            return ClusterMergeSchedulerConfig.getClusterMaxThreadCountDefault(settings);
        }
        return Integer.toString(clusterMaxThreadCountDefault);
    }

    private static String getDefaultMergeCount(Settings settings) {
        if (MAX_THREAD_COUNT_SETTING.exists(settings) || clusterMaxMergeCountDefault == null) {
            return Integer.toString(MAX_THREAD_COUNT_SETTING.get(settings) + 5);
        }
        return Integer.toString(clusterMaxMergeCountDefault);
    }

    private static String getDefaultAutoThrottle(Settings settings) {
        return Boolean.toString(Objects.requireNonNullElseGet(clusterAutoThrottleEnabledDefault, () -> true));
    }
}

